# This file is part of the FreeType project
#
# This builds the Watcom library with Watcom's wcc386 under DOS
#
# You'll need Watcom's wmake
#
# Invoke by "wmake -f arch\os2\Makefile.wat" when in the "lib" directory
# This will build "freetype\lib\libttf.lib"
#

.EXTENSIONS:
.EXTENSIONS: .exe .obj .c .h
.obj:.;.\extend
.c:.;.\extend
.h:.;.\extend

CC = wcc386

CCFLAGS = /otexanl+ /s /za /w5 /zq -Iarch\os2 -I. -Iextend

OBJS = ttapi.obj     ttcache.obj  ttcalc.obj   ttcmap.obj    ttdebug.obj &
       tterror.obj   ttfile.obj   ttgload.obj  ttinterp.obj  ttlists.obj &
       ttload.obj    ttmemory.obj ttmutex.obj  ttobjs.obj    ttraster.obj &
       ttextend.obj  extend\ftxgasp.obj  extend\ftxkern.obj

.c.obj :
  $(CC) $(CCFLAGS) $[* /fo=$[*.obj

libname = libttf
libfile = $(libname).lib

$(libfile) : $(OBJS) $(cmdfile)
  wlib -q -n $(libfile) $(OBJS)

clean: .symbolic
         @-erase $(OBJS)

distclean: .symbolic clean
         @-erase $(libfile)

new: .symbolic
         @-wtouch *.c

# end of Makefile.wat
