/* gstate.h -- define data structures for Graphics State, graphics states are 
 * mananged by font instructions.
 * Copyright (C) 1996 Li-Da Lho, All right reserved.
 */

/* 	$Id: gstate.h,v 1.1 1996/11/29 06:37:23 ollie Exp ollie $	 */

/* unit vectors used for directional purpose */
#define F2Dot14_ONE 1<<14
#define F2Dot14_EPSILON 1

#define F26Dot6_ONE 1L<<26
#define F26Dot6_EPSILON 1L

typedef struct {
    F2Dot14 x;
    F2Dot14 y;
} TTFUnitVector;

/* Unit vector point to x and y direction */
#define UnitX {F2Dot14_ONE,0}
#define UnitY {0,F2Dot14_ONE}

/* vectors used as positional vector */
typedef struct {
    F26Dot6 x;
    F26Dot6 y;
} TTFVector;

/* the type of those fields are not well defined in the True Type Font 
 * Specification.
 * We can defined them as pretty much as we want.
 */
typedef struct {
    /* boolean balues */
    BYTE auto_flip;

    BYTE scan_control;
    USHORT instruction_control;
    SHORT round_state;

    F26Dot6 control_value_cut_in;
    F26Dot6 minimum_distance;
    F26Dot6 single_width_cut_in;
    FWord single_width_value;

    ULONG delta_base;
    ULONG delta_shift;

    /* unit vectors */
    TTFUnitVector dual_projection_vector;
    TTFUnitVector freedom_vector;
    TTFUnitVector projection_vector;

    /* reference point */
    ULONG rp0;
    ULONG rp1;
    ULONG rp2;

    /* zone pointers: take only 0 or 1 as value */
    ULONG zp0;
    ULONG zp1;
    ULONG zp2;

    SHORT gep0;
    SHORT gep1;
    SHORT gep2;

    ULONG loop;
} GraphicsState;

#define GS_DEFAULT
