/*
 *  This file is part of MagiCapture.
 *  Copyright (C) 1999 Arthur Jerijian
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * util.c: Miscellaneous utility functions
 */

#include <glib.h>
#include <gtk/gtk.h>

#include "common.h"
#include "stringtable.h"
#include "util.h"

/*********************************************************************
 *
 * error_dialog: Display a GTK dialog box with an error message.
 *
 * Parameters:
 *   error_msg - text to display within the error dialog box
 *
 * Return value:
 *   None.
 */

void error_dialog (gchar *error_msg)
{
    GtkWidget *window;
    GtkWidget *label;
    GtkWidget *OK_button;

    window = gtk_dialog_new ();
    gtk_window_set_modal (GTK_WINDOW (window), TRUE);
    
    gtk_window_set_title (GTK_WINDOW (window), TITLE_ERROR);
    gtk_container_set_border_width (GTK_CONTAINER (window), 5);

    OK_button = gtk_button_new_with_label ("OK");
    gtk_signal_connect_object
    (
        GTK_OBJECT (OK_button),
        "clicked",
        GTK_SIGNAL_FUNC (gtk_widget_destroy),
        GTK_OBJECT (window)
    );
    gtk_box_pack_start
    (
        GTK_BOX (GTK_DIALOG (window) -> action_area),
        OK_button,
        TRUE,
        TRUE,
        0
    );
    gtk_widget_show (OK_button);

    label = gtk_label_new (error_msg);
    gtk_box_pack_start
    (
        GTK_BOX (GTK_DIALOG (window) -> vbox),
        label,
        TRUE,
        TRUE,
        0
    );
    gtk_widget_show (label);

    gtk_widget_show (window);
}

/*********************************************************************
 *
 * debug_print: Print a debug message to the console if debugging
 * is enabled during compile time.
 *
 * Parameters:
 *   debug_msg - debug message text without a trailing newline
 *
 * Return value:
 *   None.
 */

void debug_print (gchar *debug_msg)
{
#ifdef MAGICAPTURE_DEBUG
    GString *debug_buffer;
    
    debug_buffer = g_string_new (NULL);
    g_string_sprintf (debug_buffer, "%s\n", debug_msg);
    g_print (debug_buffer -> str);
    g_string_free (debug_buffer, TRUE);
#endif /* MAGICAPTURE_DEBUG */
}
