/*
 *  This file is part of MagiCapture.
 *  Copyright (C) 1999 Arthur Jerijian
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __MAGICAPTURE_STRINGTABLE_H__
#define __MAGICAPTURE_STRINGTABLE_H__

/*
 * TODO: We want to use gettext to localize these strings.
 * Perhaps we can start with catalogs for en, es, and de.
 */

/* Window titles */

#define TITLE_PANEL "MagiCapture Panel"
#define TITLE_CAPTURE_WINDOW "Screen Capture Preview"
#define TITLE_SAVE_WINDOW "Save Screen Capture"
#define TITLE_FILE_TYPE "Choose File Type"
#define TITLE_ERROR "MagiCapture Error"
#define TITLE_OPTIONS "MagiCapture Options"
#define TITLE_ABOUT "About MagiCapture"
#define TITLE_SAVING_FILE "Saving file"

/* Fixed text labels */

#define LABEL_CAPTURE "Capture:"
#define LABEL_DELAY "Delay:"
#define LABEL_VIEW "View:"
#define LABEL_SECONDS " seconds"
#define LABEL_CHOOSE_MENU "Choose image format: "
#define LABEL_CHOOSE_FILE_TYPE "Choose a file type from the list below."
#define LABEL_FILETYPE_AUTOMATIC "Automatic (by file extension)"
#define LABEL_FILETYPE_OTHER "Other..."

/* Button labels */

#define LABEL_SINGLE_WINDOW "Single Window"
#define LABEL_SINGLE_WINDOW_DECOR "Single Window\nwith Decorations"
#define LABEL_FULL_SCREEN "Full Screen"
#define LABEL_CAPTURE_DO "Capture!"
#define LABEL_PREVIEW "Preview"
#define LABEL_OPTIONS "Options..."
#define LABEL_SAVEAS "Save As..."
#define LABEL_QUIT "Quit"
#define LABEL_ABOUT "About"

#define LABEL_OK "OK"
#define LABEL_CANCEL "Cancel"

/* Option labels */

#define LABEL_OPTION_TAB_GENERAL "General"
#define LABEL_OPTION_PREVIEW "Preview screen capture immediately"
#define LABEL_OPTION_HIDE_PANEL "Hide main panel during capture"
#define LABEL_OPTION_DITHER "Dither the screen capture preview image"

#define LABEL_OPTION_SAVE "Save Options"
#define LABEL_OPTION_APPLY "Apply"
#define LABEL_OPTION_CANCEL "Cancel"

/* Formatting strings */

#define FMT_FILETYPE_SELECTED "Image format selected: %s"
#define FMT_SAVING "Saving image to file %s with type %s ..."

/* String arrays */

#define ARRAY_CLIST_HEADER {"Type", "Description"}

/* Error messages */
/* TODO: Separate informational messages from error messages. */

#define ERROR_VISUAL \
    "FATAL ERROR: Unable to retrieve the Gdk visual!"
#define ERROR_COLORMAP \
    "FATAL ERROR: Unable to retrieve the Gdk system colormap!"
#define ERROR_MAGICK_IMAGE \
    "ERROR: Screen capture failed!"
#define ERROR_MAGICK_IMAGE_SAVE \
    "There is no screen capture to save."
#define ERROR_NOT_IMPLEMENTED \
    "This function is not yet implemented."
#define ERROR_CLONE \
    "ERROR: Unable to clone captured image for saving!"

/*
 * TODO: When this error occurs, let the user know that they may still
 * save the image to a file.
 */
#define ERROR_SAVE_TEMP \
    "ERROR: Unable to save the captured image to a temporary file!"

#define ERROR_UNKNOWN_CAPTURE_TYPE \
    "ERROR: Unable to determine the type of display entity to capture!"
#define ERROR_CAPTURE_WINDOW \
    "ERROR: Unable to create a screen capture output window!"
#define ERROR_CAPTURE_IMAGE_WIDGET \
    "ERROR: Unable to create a screen capture output image!"
#define ERROR_PREVIEW \
    "ERROR: Unable to preview the screen capture!"

#define ERROR_OPTIONS_HOME \
    "ERROR: Environment variable HOME not set! Options won't be saved."
#define ERROR_OPTION_SAVE \
    "ERROR: Unable to save options!"

#define ERROR_SAVE \
    "ERROR: Unable to save the captured image!"

#endif /* __MAGICAPTURE_STRINGTABLE_H__ */

