/*
 * This software is copyrighted as noted below.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 */
/*
 * paste.c - paste a image over other.
 *
 * Author:      Raul Rivero
 *              Mathematics Dept.
 *              University of Oviedo
 * Date:        Thu Jan 16 1992
 * Copyright (c) 1992, Raul Rivero
 *
 */

#include <lug.h>
#include <lugfnts.h>

paste(base, super, xpos, ypos)
bitmap_hdr *base, *super;
int xpos, ypos;
{
  register int i, j;
  byte *r1, *g1, *b1;
  byte *r2, *g2, *b2;

  if ( base->magic != LUGUSED || super->magic != LUGUSED )
    error( 19 );

  r1= base->r, g1= base->g, b1= base->b;
  r2= super->r, g2= super->g, b2= super->b;

  /*
   * Skip pre-paste rows.
   */
  for (i= 0; i< ypos; i++) {
    r1 += base->xsize;
    g1 += base->xsize;
    b1 += base->xsize;
  }

  /*
   * While we are inside surface to paste ...
   */
  for ( i = 0; i < super->ysize; i++ ) {
    for ( j = 0; j< base->xsize; j++ )
      if ( j < xpos  || j >= super->xsize+xpos ) {
        r1++, g1++, b1++;
      }else {
        if ( (*r2 + *g2 + *b2) < CHROMABORDER ) {
          r1++, g1++, b1++;
          r2++, g2++, b2++;
        }else {
          *r1++ = *r2++;
          *g1++ = *g2++;
          *b1++ = *b2++;
        }
      }
  }
}

center_image( base, super )
bitmap_hdr *base, *super;
{
  int xmid, ymid;

  xmid = ( base->xsize / 2 ) - ( super->xsize / 2 );
  ymid = ( base->ysize / 2 ) - ( super->ysize / 2 );

  paste( base, super, xmid, ymid );
}

