/*****************************************************************************
 * vlc.h : vlc table
 *****************************************************************************
 * Copyright (C) 2009 xavs project
 *
 * Authors: Jianwen Chen <jianwen.chen.video@gmail.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************/

#ifndef _XAVS_VLC_H_
#define _XAVS_VLC_H_

typedef struct
{
  int i_bits;
  int i_size;
} vlc_t;
#define NUM_2D_TABLES_T 4
#define CODE2D_ESCAPE_SYMBOL_T 59

//2D code tables for AVS VLC encoding
//The first table is used for Intra coding,
//the other 3 are used for Inter, QPs 0-13, 14-21, 22-31
static const char AVS_2D_VLC_T[NUM_2D_TABLES_T][16][8] = {
  {
   {0, 1, 5, 13, 21, 31, 39, 47},       //Inter. Is coded using Golomb 2
   {-1, 3, 15, 33, 51, -1, -1, -1},
   {-1, 7, 25, 53, -1, -1, -1, -1},
   {-1, 9, 35, -1, -1, -1, -1, -1},
   {-1, 11, 45, -1, -1, -1, -1, -1},    //max symbol for tables depending on golomb base:
   {-1, 17, 55, -1, -1, -1, -1, -1},    //grad 0: 62
   {-1, 19, -1, -1, -1, -1, -1, -1},    //grad 1: 61
   {-1, 23, -1, -1, -1, -1, -1, -1},    //grad 2: 59
   {-1, 27, -1, -1, -1, -1, -1, -1},    //grad 3: 55
   {-1, 29, -1, -1, -1, -1, -1, -1},    //grad 4: 47
   {-1, 37, -1, -1, -1, -1, -1, -1},
   {-1, 41, -1, -1, -1, -1, -1, -1},
   {-1, 43, -1, -1, -1, -1, -1, -1},
   {-1, 49, -1, -1, -1, -1, -1, -1},
   {-1, 57, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1},
   }, 
  {
   {0, 1, 3, 7, 9, 13, 19, 21},     //Intra QP 0..13. Is coded using Golomb 0, 1, or 2.
   {-1, 5, 15, 25, 31, 39, 45, 49},
   {-1, 11, 29, 41, 51, -1, -1, -1},
   {-1, 17, 35, 55, -1, -1, -1, -1},
   {-1, 23, 43, -1, -1, -1, -1, -1},
   {-1, 27, 57, -1, -1, -1, -1, -1},
   {-1, 33, -1, -1, -1, -1, -1, -1},
   {-1, 37, -1, -1, -1, -1, -1, -1},
   {-1, 47, -1, -1, -1, -1, -1, -1},
   {-1, 53, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1},
   }, 
   {
   {0, 1, 3, 9, 13, 19, 23, 31},        //Intra QP 14..21. Is coded using Golomb 0, 1, or 2.
   {-1, 5, 15, 27, 37, 49, 57, -1},
   {-1, 7, 25, 43, -1, -1, -1, -1},
   {-1, 11, 35, -1, -1, -1, -1, -1},
   {-1, 17, 45, -1, -1, -1, -1, -1},
   {-1, 21, 51, -1, -1, -1, -1, -1},
   {-1, 29, -1, -1, -1, -1, -1, -1},
   {-1, 33, -1, -1, -1, -1, -1, -1},
   {-1, 39, -1, -1, -1, -1, -1, -1},
   {-1, 41, -1, -1, -1, -1, -1, -1},
   {-1, 47, -1, -1, -1, -1, -1, -1},
   {-1, 53, -1, -1, -1, -1, -1, -1},
   {-1, 55, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1},
   }, 
   {
   {0, 1, 5, 13, 21, 33, 43, 57},   //Intra QP 22..31. Is coded using Golomb 0, 1, or 2.
   {-1, 3, 17, 31, 49, -1, -1, -1},
   {-1, 7, 25, 47, -1, -1, -1, -1},
   {-1, 9, 35, -1, -1, -1, -1, -1},
   {-1, 11, 41, -1, -1, -1, -1, -1},
   {-1, 15, 51, -1, -1, -1, -1, -1},
   {-1, 19, -1, -1, -1, -1, -1, -1},
   {-1, 23, -1, -1, -1, -1, -1, -1},
   {-1, 27, -1, -1, -1, -1, -1, -1},
   {-1, 29, -1, -1, -1, -1, -1, -1},
   {-1, 37, -1, -1, -1, -1, -1, -1},
   {-1, 39, -1, -1, -1, -1, -1, -1},
   {-1, 45, -1, -1, -1, -1, -1, -1},
   {-1, 53, -1, -1, -1, -1, -1, -1},
   {-1, 55, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1},
   }
};

static const char AVS_2DVLC_INTRA_T[7][26][27] = {
  {
   {0, 22, 38, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {2, 32, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {4, 44, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {6, 50, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {8, 54, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {12, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {14, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {16, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {18, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {20, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {24, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {26, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {28, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {30, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {34, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {36, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {40, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {42, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {46, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {48, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {52, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {56, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   },
  {
   {8, 0, 4, 15, 27, 41, 55, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 2, 17, 35, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 6, 25, 53, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 9, 33, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 11, 39, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 13, 45, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 19, 49, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 21, 51, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 23, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 29, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 31, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 37, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 43, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 57, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   },
  {
   {8, 0, 2, 6, 13, 17, 27, 35, 45, 55, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 4, 11, 21, 33, 49, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 9, 23, 37, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 15, 29, 51, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 19, 39, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 25, 43, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 31, 53, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 41, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 57, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   },
  {
   {8, 0, 2, 4, 9, 11, 17, 21, 25, 33, 39, 45, 55, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 6, 13, 19, 29, 35, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 15, 27, 41, 57, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 23, 37, 53, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 31, 51, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 43, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 49, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   },
  {
   {6, 0, 2, 4, 7, 9, 11, 15, 17, 21, 23, 29, 33, 35, 43, 47, 49, 57, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 13, 19, 27, 31, 37, 45, 55, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 25, 41, 51, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 39, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 53, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   },
  {
   {0, 1, 3, 5, 7, 9, 11, 13, 15, 17, 19, 23, 25, 27, 31, 33, 37, 41, 45, 49, 51, 55, -1, -1, -1, -1, -1},
   {-1, 21, 29, 35, 43, 47, 53, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 39, 57, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   },
  {
   {0, 1, 3, 5, 7, 9, 11, 13, 15, 17, 19, 21, 23, 25, 27, 29, 31, 35, 37, 39, 41, 43, 47, 49, 51, 53, 57},
   {-1, 33, 45, 55, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   }
};


static const char AVS_2DVLC_INTER_T[7][26][27] = {
  {
   {0, 26, 40, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {2, 46, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {6, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {12, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {14, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {16, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {18, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {20, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {22, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {24, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {28, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {30, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {32, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {34, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {36, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {38, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {42, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {44, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {48, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {50, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {52, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {54, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {56, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   },
  {
   {2, 0, 13, 29, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 3, 23, 57, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 5, 35, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 7, 39, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 9, 43, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 11, 49, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 15, 55, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 17, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 19, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 21, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 25, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 27, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 31, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 33, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 37, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 41, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 45, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 51, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 53, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   },
  {
   {2, 0, 5, 11, 23, 35, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 3, 13, 27, 49, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 7, 21, 45, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 9, 29, 55, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 15, 37, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 17, 41, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 19, 53, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 25, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 31, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 33, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 39, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 43, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 51, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 57, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   },
  {
   {2, 0, 3, 7, 13, 17, 27, 35, 43, 55, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 5, 11, 21, 33, 51, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 9, 23, 37, 57, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 15, 29, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 19, 41, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 25, 49, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 31, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 39, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 45, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 53, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   },
  {
   {2, 0, 3, 5, 9, 11, 17, 21, 25, 33, 41, 45, 55, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 7, 13, 19, 29, 35, 49, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 15, 27, 43, 57, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 23, 37, 51, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 31, 53, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 39, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   },
  {
   {0, 1, 3, 5, 7, 9, 13, 15, 17, 21, 25, 29, 33, 39, 43, 49, 53, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 11, 19, 27, 31, 41, 45, 57, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 23, 37, 51, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 35, 55, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   },
  {
   {0, 1, 3, 5, 7, 9, 11, 13, 17, 19, 21, 23, 25, 29, 33, 35, 39, 41, 43, 47, 49, 57, -1, -1, -1, -1, -1},
   {-1, 15, 27, 37, 45, 55, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 31, 51, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 53, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   }
};

static const char AVS_2DVLC_CHROMA_T[5][26][27] = {
  {
   {0, 14, 32, 56, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {2, 48, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {6, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {12, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {16, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {18, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {20, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {22, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {24, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {26, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {28, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {30, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {34, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {36, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {38, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {40, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {42, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {44, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {46, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {50, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {52, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {54, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   },
  {
   {0, 1, 5, 15, 29, 43, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 3, 21, 45, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 7, 37, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 9, 41, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 11, 53, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 13, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 17, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 19, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 23, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 25, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 27, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 31, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 33, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 35, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 39, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 49, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 51, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 55, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 57, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   },
  {
   {2, 0, 3, 7, 11, 17, 27, 33, 47, 53, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 5, 13, 21, 37, 55, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 9, 23, 41, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 15, 31, 57, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 19, 43, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 25, 45, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 29, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 35, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 39, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 49, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 51, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   },
  {
   {0, 1, 3, 5, 7, 11, 15, 19, 23, 29, 35, 43, 47, 53, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 9, 13, 21, 31, 39, 51, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 17, 27, 37, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 25, 41, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 33, 55, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 45, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 49, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 57, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   },
  {
   {0, 1, 3, 5, 7, 9, 11, 13, 15, 19, 21, 23, 27, 29, 33, 37, 41, 43, 51, 55, -1, -1, -1, -1, -1, -1, -1},
   {-1, 17, 25, 31, 39, 45, 53, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 35, 49, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 47, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, 57, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
   }
};

static const char VLC_Golomb_Order_T[3][7][2] = //[interlace/frame][intra/inter/chroma][tablenum][grad/maxlevel]
{
  {
   {2, 9}, {2, 9}, {2, 9}, {2, 9}, {2, 9}, {2, 9}, {2, 9},
   },
  {
   {3, 9}, {2, 9}, {2, 9}, {2, 9}, {2, 9}, {2, 9}, {2, 9},
   },
  {
   {2, 9}, {0, 9}, {1, 9}, {1, 9}, {0, 9}, {-1, -1}, {-1, -1},
   },
};

static const char MaxRun_T[3][7] = {
  {22, 14, 9, 6, 4, 2, 1},
  {25, 18, 13, 9, 6, 4, 3},
  {24, 19, 10, 7, 4, -1, -1}
};

static const char RefAbsLevel_T[19][26] = {
  {4, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, -1, -1, -1},
  {7, 4, 4, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {10, 6, 4, 4, 3, 3, 3, 2, 2, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {13, 7, 5, 4, 3, 2, 2, -1, -1, -1 - 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {18, 8, 4, 2, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {22, 7, 3, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {27, 4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {4, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2},
  {5, 4, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, -1, -1, -1, -1, -1, -1, -1},
  {7, 5, 4, 4, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {10, 6, 5, 4, 3, 3, 2, 2, 2, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {13, 7, 5, 4, 3, 2, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {17, 8, 4, 3, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {22, 6, 3, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {5, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, -1},
  {6, 4, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, -1, -1, -1, -1, -1, -1},
  {10, 6, 4, 4, 3, 3, 2, 2, 2, 2, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {14, 7, 4, 3, 3, 2, 2, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {20, 7, 3, 2, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}
};

/* XXX: don't forget to change it if you change vlc_t */
#define MKVLC( a, b ) { a, b }
static const vlc_t xavs_coeff_token[5][17 * 4] = {
  /* table 0 */
  {
   MKVLC (0x1, 1),              /* str=1 */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */

   MKVLC (0x5, 6),              /* str=000101 */
   MKVLC (0x1, 2),              /* str=01 */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */

   MKVLC (0x7, 8),              /* str=00000111 */
   MKVLC (0x4, 6),              /* str=000100 */
   MKVLC (0x1, 3),              /* str=001 */
   MKVLC (0x0, 0),              /* str= */

   MKVLC (0x7, 9),              /* str=000000111 */
   MKVLC (0x6, 8),              /* str=00000110 */
   MKVLC (0x5, 7),              /* str=0000101 */
   MKVLC (0x3, 5),              /* str=00011 */

   MKVLC (0x7, 10),             /* str=0000000111 */
   MKVLC (0x6, 9),              /* str=000000110 */
   MKVLC (0x5, 8),              /* str=00000101 */
   MKVLC (0x3, 6),              /* str=000011 */

   MKVLC (0x7, 11),             /* str=00000000111 */
   MKVLC (0x6, 10),             /* str=0000000110 */
   MKVLC (0x5, 9),              /* str=000000101 */
   MKVLC (0x4, 7),              /* str=0000100 */

   MKVLC (0xf, 13),             /* str=0000000001111 */
   MKVLC (0x6, 11),             /* str=00000000110 */
   MKVLC (0x5, 10),             /* str=0000000101 */
   MKVLC (0x4, 8),              /* str=00000100 */

   MKVLC (0xb, 13),             /* str=0000000001011 */
   MKVLC (0xe, 13),             /* str=0000000001110 */
   MKVLC (0x5, 11),             /* str=00000000101 */
   MKVLC (0x4, 9),              /* str=000000100 */

   MKVLC (0x8, 13),             /* str=0000000001000 */
   MKVLC (0xa, 13),             /* str=0000000001010 */
   MKVLC (0xd, 13),             /* str=0000000001101 */
   MKVLC (0x4, 10),             /* str=0000000100 */

   MKVLC (0xf, 14),             /* str=00000000001111 */
   MKVLC (0xe, 14),             /* str=00000000001110 */
   MKVLC (0x9, 13),             /* str=0000000001001 */
   MKVLC (0x4, 11),             /* str=00000000100 */

   MKVLC (0xb, 14),             /* str=00000000001011 */
   MKVLC (0xa, 14),             /* str=00000000001010 */
   MKVLC (0xd, 14),             /* str=00000000001101 */
   MKVLC (0xc, 13),             /* str=0000000001100 */

   MKVLC (0xf, 15),             /* str=000000000001111 */
   MKVLC (0xe, 15),             /* str=000000000001110 */
   MKVLC (0x9, 14),             /* str=00000000001001 */
   MKVLC (0xc, 14),             /* str=00000000001100 */

   MKVLC (0xb, 15),             /* str=000000000001011 */
   MKVLC (0xa, 15),             /* str=000000000001010 */
   MKVLC (0xd, 15),             /* str=000000000001101 */
   MKVLC (0x8, 14),             /* str=00000000001000 */

   MKVLC (0xf, 16),             /* str=0000000000001111 */
   MKVLC (0x1, 15),             /* str=000000000000001 */
   MKVLC (0x9, 15),             /* str=000000000001001 */
   MKVLC (0xc, 15),             /* str=000000000001100 */

   MKVLC (0xb, 16),             /* str=0000000000001011 */
   MKVLC (0xe, 16),             /* str=0000000000001110 */
   MKVLC (0xd, 16),             /* str=0000000000001101 */
   MKVLC (0x8, 15),             /* str=000000000001000 */

   MKVLC (0x7, 16),             /* str=0000000000000111 */
   MKVLC (0xa, 16),             /* str=0000000000001010 */
   MKVLC (0x9, 16),             /* str=0000000000001001 */
   MKVLC (0xc, 16),             /* str=0000000000001100 */

   MKVLC (0x4, 16),             /* str=0000000000000100 */
   MKVLC (0x6, 16),             /* str=0000000000000110 */
   MKVLC (0x5, 16),             /* str=0000000000000101 */
   MKVLC (0x8, 16),             /* str=0000000000001000 */
   },

  /* table 1 */
  {
   MKVLC (0x3, 2),              /* str=11 */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */

   MKVLC (0xb, 6),              /* str=001011 */
   MKVLC (0x2, 2),              /* str=10 */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */

   MKVLC (0x7, 6),              /* str=000111 */
   MKVLC (0x7, 5),              /* str=00111 */
   MKVLC (0x3, 3),              /* str=011 */
   MKVLC (0x0, 0),              /* str= */

   MKVLC (0x7, 7),              /* str=0000111 */
   MKVLC (0xa, 6),              /* str=001010 */
   MKVLC (0x9, 6),              /* str=001001 */
   MKVLC (0x5, 4),              /* str=0101 */

   MKVLC (0x7, 8),              /* str=00000111 */
   MKVLC (0x6, 6),              /* str=000110 */
   MKVLC (0x5, 6),              /* str=000101 */
   MKVLC (0x4, 4),              /* str=0100 */

   MKVLC (0x4, 8),              /* str=00000100 */
   MKVLC (0x6, 7),              /* str=0000110 */
   MKVLC (0x5, 7),              /* str=0000101 */
   MKVLC (0x6, 5),              /* str=00110 */

   MKVLC (0x7, 9),              /* str=000000111 */
   MKVLC (0x6, 8),              /* str=00000110 */
   MKVLC (0x5, 8),              /* str=00000101 */
   MKVLC (0x8, 6),              /* str=001000 */

   MKVLC (0xf, 11),             /* str=00000001111 */
   MKVLC (0x6, 9),              /* str=000000110 */
   MKVLC (0x5, 9),              /* str=000000101 */
   MKVLC (0x4, 6),              /* str=000100 */

   MKVLC (0xb, 11),             /* str=00000001011 */
   MKVLC (0xe, 11),             /* str=00000001110 */
   MKVLC (0xd, 11),             /* str=00000001101 */
   MKVLC (0x4, 7),              /* str=0000100 */

   MKVLC (0xf, 12),             /* str=000000001111 */
   MKVLC (0xa, 11),             /* str=00000001010 */
   MKVLC (0x9, 11),             /* str=00000001001 */
   MKVLC (0x4, 9),              /* str=000000100 */

   MKVLC (0xb, 12),             /* str=000000001011 */
   MKVLC (0xe, 12),             /* str=000000001110 */
   MKVLC (0xd, 12),             /* str=000000001101 */
   MKVLC (0xc, 11),             /* str=00000001100 */

   MKVLC (0x8, 12),             /* str=000000001000 */
   MKVLC (0xa, 12),             /* str=000000001010 */
   MKVLC (0x9, 12),             /* str=000000001001 */
   MKVLC (0x8, 11),             /* str=00000001000 */

   MKVLC (0xf, 13),             /* str=0000000001111 */
   MKVLC (0xe, 13),             /* str=0000000001110 */
   MKVLC (0xd, 13),             /* str=0000000001101 */
   MKVLC (0xc, 12),             /* str=000000001100 */

   MKVLC (0xb, 13),             /* str=0000000001011 */
   MKVLC (0xa, 13),             /* str=0000000001010 */
   MKVLC (0x9, 13),             /* str=0000000001001 */
   MKVLC (0xc, 13),             /* str=0000000001100 */

   MKVLC (0x7, 13),             /* str=0000000000111 */
   MKVLC (0xb, 14),             /* str=00000000001011 */
   MKVLC (0x6, 13),             /* str=0000000000110 */
   MKVLC (0x8, 13),             /* str=0000000001000 */

   MKVLC (0x9, 14),             /* str=00000000001001 */
   MKVLC (0x8, 14),             /* str=00000000001000 */
   MKVLC (0xa, 14),             /* str=00000000001010 */
   MKVLC (0x1, 13),             /* str=0000000000001 */

   MKVLC (0x7, 14),             /* str=00000000000111 */
   MKVLC (0x6, 14),             /* str=00000000000110 */
   MKVLC (0x5, 14),             /* str=00000000000101 */
   MKVLC (0x4, 14),             /* str=00000000000100 */
   },
  /* table 2 */
  {
   MKVLC (0xf, 4),              /* str=1111 */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */

   MKVLC (0xf, 6),              /* str=001111 */
   MKVLC (0xe, 4),              /* str=1110 */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */

   MKVLC (0xb, 6),              /* str=001011 */
   MKVLC (0xf, 5),              /* str=01111 */
   MKVLC (0xd, 4),              /* str=1101 */
   MKVLC (0x0, 0),              /* str= */

   MKVLC (0x8, 6),              /* str=001000 */
   MKVLC (0xc, 5),              /* str=01100 */
   MKVLC (0xe, 5),              /* str=01110 */
   MKVLC (0xc, 4),              /* str=1100 */

   MKVLC (0xf, 7),              /* str=0001111 */
   MKVLC (0xa, 5),              /* str=01010 */
   MKVLC (0xb, 5),              /* str=01011 */
   MKVLC (0xb, 4),              /* str=1011 */

   MKVLC (0xb, 7),              /* str=0001011 */
   MKVLC (0x8, 5),              /* str=01000 */
   MKVLC (0x9, 5),              /* str=01001 */
   MKVLC (0xa, 4),              /* str=1010 */

   MKVLC (0x9, 7),              /* str=0001001 */
   MKVLC (0xe, 6),              /* str=001110 */
   MKVLC (0xd, 6),              /* str=001101 */
   MKVLC (0x9, 4),              /* str=1001 */

   MKVLC (0x8, 7),              /* str=0001000 */
   MKVLC (0xa, 6),              /* str=001010 */
   MKVLC (0x9, 6),              /* str=001001 */
   MKVLC (0x8, 4),              /* str=1000 */

   MKVLC (0xf, 8),              /* str=00001111 */
   MKVLC (0xe, 7),              /* str=0001110 */
   MKVLC (0xd, 7),              /* str=0001101 */
   MKVLC (0xd, 5),              /* str=01101 */

   MKVLC (0xb, 8),              /* str=00001011 */
   MKVLC (0xe, 8),              /* str=00001110 */
   MKVLC (0xa, 7),              /* str=0001010 */
   MKVLC (0xc, 6),              /* str=001100 */

   MKVLC (0xf, 9),              /* str=000001111 */
   MKVLC (0xa, 8),              /* str=00001010 */
   MKVLC (0xd, 8),              /* str=00001101 */
   MKVLC (0xc, 7),              /* str=0001100 */

   MKVLC (0xb, 9),              /* str=000001011 */
   MKVLC (0xe, 9),              /* str=000001110 */
   MKVLC (0x9, 8),              /* str=00001001 */
   MKVLC (0xc, 8),              /* str=00001100 */

   MKVLC (0x8, 9),              /* str=000001000 */
   MKVLC (0xa, 9),              /* str=000001010 */
   MKVLC (0xd, 9),              /* str=000001101 */
   MKVLC (0x8, 8),              /* str=00001000 */

   MKVLC (0xd, 10),             /* str=0000001101 */
   MKVLC (0x7, 9),              /* str=000000111 */
   MKVLC (0x9, 9),              /* str=000001001 */
   MKVLC (0xc, 9),              /* str=000001100 */

   MKVLC (0x9, 10),             /* str=0000001001 */
   MKVLC (0xc, 10),             /* str=0000001100 */
   MKVLC (0xb, 10),             /* str=0000001011 */
   MKVLC (0xa, 10),             /* str=0000001010 */

   MKVLC (0x5, 10),             /* str=0000000101 */
   MKVLC (0x8, 10),             /* str=0000001000 */
   MKVLC (0x7, 10),             /* str=0000000111 */
   MKVLC (0x6, 10),             /* str=0000000110 */

   MKVLC (0x1, 10),             /* str=0000000001 */
   MKVLC (0x4, 10),             /* str=0000000100 */
   MKVLC (0x3, 10),             /* str=0000000011 */
   MKVLC (0x2, 10),             /* str=0000000010 */
   },

  /* table 3 */
  {
   MKVLC (0x3, 6),              /* str=000011 */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */

   MKVLC (0x0, 6),              /* str=000000 */
   MKVLC (0x1, 6),              /* str=000001 */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */

   MKVLC (0x4, 6),              /* str=000100 */
   MKVLC (0x5, 6),              /* str=000101 */
   MKVLC (0x6, 6),              /* str=000110 */
   MKVLC (0x0, 0),              /* str= */

   MKVLC (0x8, 6),              /* str=001000 */
   MKVLC (0x9, 6),              /* str=001001 */
   MKVLC (0xa, 6),              /* str=001010 */
   MKVLC (0xb, 6),              /* str=001011 */

   MKVLC (0xc, 6),              /* str=001100 */
   MKVLC (0xd, 6),              /* str=001101 */
   MKVLC (0xe, 6),              /* str=001110 */
   MKVLC (0xf, 6),              /* str=001111 */

   MKVLC (0x10, 6),             /* str=010000 */
   MKVLC (0x11, 6),             /* str=010001 */
   MKVLC (0x12, 6),             /* str=010010 */
   MKVLC (0x13, 6),             /* str=010011 */

   MKVLC (0x14, 6),             /* str=010100 */
   MKVLC (0x15, 6),             /* str=010101 */
   MKVLC (0x16, 6),             /* str=010110 */
   MKVLC (0x17, 6),             /* str=010111 */

   MKVLC (0x18, 6),             /* str=011000 */
   MKVLC (0x19, 6),             /* str=011001 */
   MKVLC (0x1a, 6),             /* str=011010 */
   MKVLC (0x1b, 6),             /* str=011011 */

   MKVLC (0x1c, 6),             /* str=011100 */
   MKVLC (0x1d, 6),             /* str=011101 */
   MKVLC (0x1e, 6),             /* str=011110 */
   MKVLC (0x1f, 6),             /* str=011111 */

   MKVLC (0x20, 6),             /* str=100000 */
   MKVLC (0x21, 6),             /* str=100001 */
   MKVLC (0x22, 6),             /* str=100010 */
   MKVLC (0x23, 6),             /* str=100011 */

   MKVLC (0x24, 6),             /* str=100100 */
   MKVLC (0x25, 6),             /* str=100101 */
   MKVLC (0x26, 6),             /* str=100110 */
   MKVLC (0x27, 6),             /* str=100111 */

   MKVLC (0x28, 6),             /* str=101000 */
   MKVLC (0x29, 6),             /* str=101001 */
   MKVLC (0x2a, 6),             /* str=101010 */
   MKVLC (0x2b, 6),             /* str=101011 */

   MKVLC (0x2c, 6),             /* str=101100 */
   MKVLC (0x2d, 6),             /* str=101101 */
   MKVLC (0x2e, 6),             /* str=101110 */
   MKVLC (0x2f, 6),             /* str=101111 */

   MKVLC (0x30, 6),             /* str=110000 */
   MKVLC (0x31, 6),             /* str=110001 */
   MKVLC (0x32, 6),             /* str=110010 */
   MKVLC (0x33, 6),             /* str=110011 */

   MKVLC (0x34, 6),             /* str=110100 */
   MKVLC (0x35, 6),             /* str=110101 */
   MKVLC (0x36, 6),             /* str=110110 */
   MKVLC (0x37, 6),             /* str=110111 */

   MKVLC (0x38, 6),             /* str=111000 */
   MKVLC (0x39, 6),             /* str=111001 */
   MKVLC (0x3a, 6),             /* str=111010 */
   MKVLC (0x3b, 6),             /* str=111011 */

   MKVLC (0x3c, 6),             /* str=111100 */
   MKVLC (0x3d, 6),             /* str=111101 */
   MKVLC (0x3e, 6),             /* str=111110 */
   MKVLC (0x3f, 6),             /* str=111111 */
   },

  /* table 4 */
  {
   MKVLC (0x1, 2),              /* str=01 */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */

   MKVLC (0x7, 6),              /* str=000111 */
   MKVLC (0x1, 1),              /* str=1 */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */

   MKVLC (0x4, 6),              /* str=000100 */
   MKVLC (0x6, 6),              /* str=000110 */
   MKVLC (0x1, 3),              /* str=001 */
   MKVLC (0x0, 0),              /* str= */

   MKVLC (0x3, 6),              /* str=000011 */
   MKVLC (0x3, 7),              /* str=0000011 */
   MKVLC (0x2, 7),              /* str=0000010 */
   MKVLC (0x5, 6),              /* str=000101 */

   MKVLC (0x2, 6),              /* str=000010 */
   MKVLC (0x3, 8),              /* str=00000011 */
   MKVLC (0x2, 8),              /* str=00000010 */
   MKVLC (0x0, 7),              /* str=0000000 */

   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */

   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */

   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */

   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */

   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */

   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */

   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */

   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */

   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */

   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */

   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */

   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   }
};

static const vlc_t xavs_level_prefix[16] = {
  MKVLC (0x01, 1),
  MKVLC (0x01, 2),
  MKVLC (0x01, 3),
  MKVLC (0x01, 4),
  MKVLC (0x01, 5),
  MKVLC (0x01, 6),
  MKVLC (0x01, 7),
  MKVLC (0x01, 8),
  MKVLC (0x01, 9),
  MKVLC (0x01, 10),
  MKVLC (0x01, 11),
  MKVLC (0x01, 12),
  MKVLC (0x01, 13),
  MKVLC (0x01, 14),
  MKVLC (0x01, 15),
  MKVLC (0x01, 16)
};

/* [i_total_coeff-1][i_total_zeros] */
static const vlc_t xavs_total_zeros[15][16] = {
  {                             /* i_total 1 */
   MKVLC (0x1, 1),              /* str=1 */
   MKVLC (0x3, 3),              /* str=011 */
   MKVLC (0x2, 3),              /* str=010 */
   MKVLC (0x3, 4),              /* str=0011 */
   MKVLC (0x2, 4),              /* str=0010 */
   MKVLC (0x3, 5),              /* str=00011 */
   MKVLC (0x2, 5),              /* str=00010 */
   MKVLC (0x3, 6),              /* str=000011 */
   MKVLC (0x2, 6),              /* str=000010 */
   MKVLC (0x3, 7),              /* str=0000011 */
   MKVLC (0x2, 7),              /* str=0000010 */
   MKVLC (0x3, 8),              /* str=00000011 */
   MKVLC (0x2, 8),              /* str=00000010 */
   MKVLC (0x3, 9),              /* str=000000011 */
   MKVLC (0x2, 9),              /* str=000000010 */
   MKVLC (0x1, 9),              /* str=000000001 */
   },
  {                             /* i_total 2 */
   MKVLC (0x7, 3),              /* str=111 */
   MKVLC (0x6, 3),              /* str=110 */
   MKVLC (0x5, 3),              /* str=101 */
   MKVLC (0x4, 3),              /* str=100 */
   MKVLC (0x3, 3),              /* str=011 */
   MKVLC (0x5, 4),              /* str=0101 */
   MKVLC (0x4, 4),              /* str=0100 */
   MKVLC (0x3, 4),              /* str=0011 */
   MKVLC (0x2, 4),              /* str=0010 */
   MKVLC (0x3, 5),              /* str=00011 */
   MKVLC (0x2, 5),              /* str=00010 */
   MKVLC (0x3, 6),              /* str=000011 */
   MKVLC (0x2, 6),              /* str=000010 */
   MKVLC (0x1, 6),              /* str=000001 */
   MKVLC (0x0, 6),              /* str=000000 */
   MKVLC (0x0, 0),              /* str= */
   },
  {                             /* i_total 3 */
   MKVLC (0x5, 4),              /* str=0101 */
   MKVLC (0x7, 3),              /* str=111 */
   MKVLC (0x6, 3),              /* str=110 */
   MKVLC (0x5, 3),              /* str=101 */
   MKVLC (0x4, 4),              /* str=0100 */
   MKVLC (0x3, 4),              /* str=0011 */
   MKVLC (0x4, 3),              /* str=100 */
   MKVLC (0x3, 3),              /* str=011 */
   MKVLC (0x2, 4),              /* str=0010 */
   MKVLC (0x3, 5),              /* str=00011 */
   MKVLC (0x2, 5),              /* str=00010 */
   MKVLC (0x1, 6),              /* str=000001 */
   MKVLC (0x1, 5),              /* str=00001 */
   MKVLC (0x0, 6),              /* str=000000 */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   },
  {                             /* i_total 4 */
   MKVLC (0x3, 5),              /* str=00011 */
   MKVLC (0x7, 3),              /* str=111 */
   MKVLC (0x5, 4),              /* str=0101 */
   MKVLC (0x4, 4),              /* str=0100 */
   MKVLC (0x6, 3),              /* str=110 */
   MKVLC (0x5, 3),              /* str=101 */
   MKVLC (0x4, 3),              /* str=100 */
   MKVLC (0x3, 4),              /* str=0011 */
   MKVLC (0x3, 3),              /* str=011 */
   MKVLC (0x2, 4),              /* str=0010 */
   MKVLC (0x2, 5),              /* str=00010 */
   MKVLC (0x1, 5),              /* str=00001 */
   MKVLC (0x0, 5),              /* str=00000 */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   },
  {                             /* i_total 5 */
   MKVLC (0x5, 4),              /* str=0101 */
   MKVLC (0x4, 4),              /* str=0100 */
   MKVLC (0x3, 4),              /* str=0011 */
   MKVLC (0x7, 3),              /* str=111 */
   MKVLC (0x6, 3),              /* str=110 */
   MKVLC (0x5, 3),              /* str=101 */
   MKVLC (0x4, 3),              /* str=100 */
   MKVLC (0x3, 3),              /* str=011 */
   MKVLC (0x2, 4),              /* str=0010 */
   MKVLC (0x1, 5),              /* str=00001 */
   MKVLC (0x1, 4),              /* str=0001 */
   MKVLC (0x0, 5),              /* str=00000 */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   },
  {                             /* i_total 6 */
   MKVLC (0x1, 6),              /* str=000001 */
   MKVLC (0x1, 5),              /* str=00001 */
   MKVLC (0x7, 3),              /* str=111 */
   MKVLC (0x6, 3),              /* str=110 */
   MKVLC (0x5, 3),              /* str=101 */
   MKVLC (0x4, 3),              /* str=100 */
   MKVLC (0x3, 3),              /* str=011 */
   MKVLC (0x2, 3),              /* str=010 */
   MKVLC (0x1, 4),              /* str=0001 */
   MKVLC (0x1, 3),              /* str=001 */
   MKVLC (0x0, 6),              /* str=000000 */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   },
  {                             /* i_total 7 */
   MKVLC (0x1, 6),              /* str=000001 */
   MKVLC (0x1, 5),              /* str=00001 */
   MKVLC (0x5, 3),              /* str=101 */
   MKVLC (0x4, 3),              /* str=100 */
   MKVLC (0x3, 3),              /* str=011 */
   MKVLC (0x3, 2),              /* str=11 */
   MKVLC (0x2, 3),              /* str=010 */
   MKVLC (0x1, 4),              /* str=0001 */
   MKVLC (0x1, 3),              /* str=001 */
   MKVLC (0x0, 6),              /* str=000000 */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   },
  {                             /* i_total 8 */
   MKVLC (0x1, 6),              /* str=000001 */
   MKVLC (0x1, 4),              /* str=0001 */
   MKVLC (0x1, 5),              /* str=00001 */
   MKVLC (0x3, 3),              /* str=011 */
   MKVLC (0x3, 2),              /* str=11 */
   MKVLC (0x2, 2),              /* str=10 */
   MKVLC (0x2, 3),              /* str=010 */
   MKVLC (0x1, 3),              /* str=001 */
   MKVLC (0x0, 6),              /* str=000000 */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   },
  {                             /* i_total 9 */
   MKVLC (0x1, 6),              /* str=000001 */
   MKVLC (0x0, 6),              /* str=000000 */
   MKVLC (0x1, 4),              /* str=0001 */
   MKVLC (0x3, 2),              /* str=11 */
   MKVLC (0x2, 2),              /* str=10 */
   MKVLC (0x1, 3),              /* str=001 */
   MKVLC (0x1, 2),              /* str=01 */
   MKVLC (0x1, 5),              /* str=00001 */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   },
  {                             /* i_total 10 */
   MKVLC (0x1, 5),              /* str=00001 */
   MKVLC (0x0, 5),              /* str=00000 */
   MKVLC (0x1, 3),              /* str=001 */
   MKVLC (0x3, 2),              /* str=11 */
   MKVLC (0x2, 2),              /* str=10 */
   MKVLC (0x1, 2),              /* str=01 */
   MKVLC (0x1, 4),              /* str=0001 */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   },
  {                             /* i_total 11 */
   MKVLC (0x0, 4),              /* str=0000 */
   MKVLC (0x1, 4),              /* str=0001 */
   MKVLC (0x1, 3),              /* str=001 */
   MKVLC (0x2, 3),              /* str=010 */
   MKVLC (0x1, 1),              /* str=1 */
   MKVLC (0x3, 3),              /* str=011 */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   },
  {                             /* i_total 12 */
   MKVLC (0x0, 4),              /* str=0000 */
   MKVLC (0x1, 4),              /* str=0001 */
   MKVLC (0x1, 2),              /* str=01 */
   MKVLC (0x1, 1),              /* str=1 */
   MKVLC (0x1, 3),              /* str=001 */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   },
  {                             /* i_total 13 */
   MKVLC (0x0, 3),              /* str=000 */
   MKVLC (0x1, 3),              /* str=001 */
   MKVLC (0x1, 1),              /* str=1 */
   MKVLC (0x1, 2),              /* str=01 */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   },
  {                             /* i_total 14 */
   MKVLC (0x0, 2),              /* str=00 */
   MKVLC (0x1, 2),              /* str=01 */
   MKVLC (0x1, 1),              /* str=1 */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   },
  {                             /* i_total 15 */
   MKVLC (0x0, 1),              /* str=0 */
   MKVLC (0x1, 1),              /* str=1 */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   },
};

/* [i_total_coeff-1][i_total_zeros] */
static const vlc_t xavs_total_zeros_dc[3][4] = {
  {
   MKVLC (0x01, 1),             /* 1  */
   MKVLC (0x01, 2),             /* 01 */
   MKVLC (0x01, 3),             /* 001 */
   MKVLC (0x00, 3)              /* 000 */
   },
  {
   MKVLC (0x01, 1),             /* 1  */
   MKVLC (0x01, 2),             /* 01 */
   MKVLC (0x00, 2),             /* 00 */
   MKVLC (0x00, 0)              /*    */
   },
  {
   MKVLC (0x01, 1),             /* 1  */
   MKVLC (0x00, 1),             /* 0  */
   MKVLC (0x00, 0),             /*    */
   MKVLC (0x00, 0)              /*    */
   }
};

/* xavs_run_before[__MIN( i_zero_left -1, 6 )][run_before] */
static const vlc_t xavs_run_before[7][15] = {
  {                             /* i_zero_left 1 */
   MKVLC (0x1, 1),              /* str=1 */
   MKVLC (0x0, 1),              /* str=0 */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   },
  {                             /* i_zero_left 2 */
   MKVLC (0x1, 1),              /* str=1 */
   MKVLC (0x1, 2),              /* str=01 */
   MKVLC (0x0, 2),              /* str=00 */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   },
  {                             /* i_zero_left 3 */
   MKVLC (0x3, 2),              /* str=11 */
   MKVLC (0x2, 2),              /* str=10 */
   MKVLC (0x1, 2),              /* str=01 */
   MKVLC (0x0, 2),              /* str=00 */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   },
  {                             /* i_zero_left 4 */
   MKVLC (0x3, 2),              /* str=11 */
   MKVLC (0x2, 2),              /* str=10 */
   MKVLC (0x1, 2),              /* str=01 */
   MKVLC (0x1, 3),              /* str=001 */
   MKVLC (0x0, 3),              /* str=000 */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   },
  {                             /* i_zero_left 5 */
   MKVLC (0x3, 2),              /* str=11 */
   MKVLC (0x2, 2),              /* str=10 */
   MKVLC (0x3, 3),              /* str=011 */
   MKVLC (0x2, 3),              /* str=010 */
   MKVLC (0x1, 3),              /* str=001 */
   MKVLC (0x0, 3),              /* str=000 */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   },
  {                             /* i_zero_left 6 */
   MKVLC (0x3, 2),              /* str=11 */
   MKVLC (0x0, 3),              /* str=000 */
   MKVLC (0x1, 3),              /* str=001 */
   MKVLC (0x3, 3),              /* str=011 */
   MKVLC (0x2, 3),              /* str=010 */
   MKVLC (0x5, 3),              /* str=101 */
   MKVLC (0x4, 3),              /* str=100 */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   MKVLC (0x0, 0),              /* str= */
   },
  {                             /* i_zero_left 7 */
   MKVLC (0x7, 3),              /* str=111 */
   MKVLC (0x6, 3),              /* str=110 */
   MKVLC (0x5, 3),              /* str=101 */
   MKVLC (0x4, 3),              /* str=100 */
   MKVLC (0x3, 3),              /* str=011 */
   MKVLC (0x2, 3),              /* str=010 */
   MKVLC (0x1, 3),              /* str=001 */
   MKVLC (0x1, 4),              /* str=0001 */
   MKVLC (0x1, 5),              /* str=00001 */
   MKVLC (0x1, 6),              /* str=000001 */
   MKVLC (0x1, 7),              /* str=0000001 */
   MKVLC (0x1, 8),              /* str=00000001 */
   MKVLC (0x1, 9),              /* str=000000001 */
   MKVLC (0x1, 10),             /* str=0000000001 */
   MKVLC (0x1, 11),             /* str=00000000001 */
   },
};

#endif
