;;; skk-dic.el --- Default dictionary for SKK  -*- mode: emacs-lisp; coding: iso-2022-jp -*-

;; Copyright (C) 2001, 2002 SKK Development Team

;; Maintainer: SKK Development Team <skk@ring.gr.jp>
;; Keywords: japanese, mule, input method

;; This file is part of Daredevil SKK.

;; Daredevil SKK is free software; you can redistribute it and/or
;; modify it under the terms of the GNU General Public License as
;; published by the Free Software Foundation; either version 2, or
;; (at your option) any later version.

;; Daredevil SKK is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with Daredevil SKK, see the file COPYING.  If not, write to
;; the Free Software Foundation Inc., 51 Franklin St, Fifth Floor,
;; Boston, MA 02110-1301, USA.

;;; Commentary:

;; This is the default dictionary, given in Emacs Lisp.
;; This file is automatically generated, at compile time, from SKK-JISYO.S.

;; The purpose of this built-in dictionary is to let everyone enjoy the
;; latest S dictionary, without effort.

;;; Code:

(eval-when-compile
  (require 'skk-macs)
  (require 'skk-vars))

;; Variables.

(defvar skk-dic-buffer nil)

;; Functions.

;;;###autoload
(defun skk-search-small-dic ()
  "`skk-henkan-key' $B$K$D$$$F(B `skk-dic-buffer' $B$r8!:w$7!"8uJd$N%j%9%H$rJV$9!#(B
`skk-search-prog-list' $B$NMWAG$K(B `(skk-search-small-dic)' $B$r;XDj$7$FMxMQ$9$k!#(B
SKK $B%$%s%9%H!<%k;~$K%$%s%9%H!<%i$,(B SKK-JISYO.S $B$r8+$D$1$?$i!"(Bskk-dic.el
$B%m!<%I;~$K(B `skk-dic-buffer' $B$O<+F0E*$K@_Dj$5$l$k!#(B"
  (when (buffer-live-p skk-dic-buffer)
    (skk-search-jisyo-buf skk-dic-buffer 10000)))

;;;###autoload
(defun skk-dic-setup-buffer (&optional arg)
  (cond
   ((null arg)
    skk-dic-buffer)
   ((string= "" arg)
    nil)
   (t
    (let ((buffer (get-buffer-create " *skk-small-dic*")))
      (with-current-buffer buffer
	(when (zerop (buffer-size))
	  (setq buffer-read-only nil)
	  (buffer-disable-undo)
	  (setq case-fold-search nil
		major-mode 'skk-jisyo-mode
		mode-name "SKK dic")
	  (insert arg)
	  (skk-setup-jisyo-buffer)
	  (setq buffer-read-only t)
	  (set-buffer-modified-p nil)))
      (setq skk-dic-buffer buffer)))))

(skk-dic-setup-buffer
  "\
")

(provide 'skk-dic)

;;; skk-dic.el ends here
