;;; isearch mode for skk with emacs 19.

;; $Id: skk-isearch.el,v 1.15 1994/07/10 23:31:22 enami Exp $

;;
;; variables
;;
(defvar skk-isearch-incomplete-message "" "incomplete isearch message")
;; for the debugging, it doesn't start with SPC.
(defvar skk-isearch-working-buffer "*skk-isearch*")

;;;###autoload
(defvar skk-isearch-whitespace-regexp (if (and (boundp 'j-ignore-exp)
					       (stringp j-ignore-exp))
					  j-ignore-exp
					"\\(\\s \\|[ \t\n\r\f]\\)*"))


(defun skk-isearch-set-working-buffer ()
  (set-buffer (get-buffer-create skk-isearch-working-buffer)))

(defun skk-isearch-incomplete-message ()
  (let ((isearch-message (concat isearch-message 
				 skk-isearch-incomplete-message)))
    (isearch-message)))

;; Override the function in skk-isearch.el.  I hope the j-kana-input
;; should be rewritten without using while read-char loop...
(defun j-isearch-message ()
  (skk-isearch-incomplete-message))


;;
;; functions for hooks.
;;
;; 1. always invoke skk isearch.
;; (add-hook 'isearch-mode-hook 'skk-isearch-mode-setup)
;; (add-hook 'isearch-mode-end-hook 'skk-isearch-mode-cleanup)
;; 2. invoke only if skk-mode is on.
;; (add-hook 'isearch-mode-hook
;;           (function (lambda ()
;;			 (and (boundp 'skk-mode) skk-mode
;;			      (skk-isearch-mode-setup)))))
;; (add-hook 'isearch-mode-end-hook
;;	     (function (lambda ()
;;			 (and (boundp 'skk-mode) skk-mode
;;			      (skk-isearch-mode-cleanup)))))
;; 3. invoke if current buffer has japanese characters.
;; ...

;;;###autoload
(defun skk-isearch-mode-setup ()
  "hook functoin called when skk isearch begin."
  ;; setup working buffer
  (save-excursion
    (skk-isearch-set-working-buffer)
    (skk-mode 1)
    (j-kakutei)
    (erase-buffer))
  ;; setup variables and keymap
  (setq overriding-local-map skk-isearch-mode-map
	skk-isearch-incomplete-message ""
	skk-isearch-message ""))

;;;###autoload
(defun skk-isearch-mode-cleanup ()
  "hook functoin called when skk isearch is done."
  (setq skk-isearch-message nil))

(fset 'skk-isearch-forward 'isearch-forward)
(fset 'skk-isearch-forward-regexp 'isearch-forward-regexp)
(fset 'skk-isearch-backward 'isearch-backward)
(fset 'skk-isearch-backward-regexp 'isearch-backward-regexp)


;;
;; define keymap
;;
;; (setq skk-isearch-mode-map nil)
;; (lookup-key skk-isearch-mode-map " ")
;; using defconst for the debugging.
(defconst skk-isearch-mode-map nil "keymap for skk isearch mode.")

(if skk-isearch-mode-map
    nil
  (setq skk-isearch-mode-map (cons 'keymap isearch-mode-map))

  ;; printable chars.
  (let ((c ?\040))
    (while (< c ?\177)
      (define-key skk-isearch-mode-map (char-to-string c) 'skk-isearch-wrapper)
      (setq c (1+ c))))

  ;; control chars for skk.
  (define-key skk-isearch-mode-map "\C-j" 'skk-isearch-newline)
  (define-key skk-isearch-mode-map "\C-m" 'skk-isearch-exit)
  (define-key skk-isearch-mode-map "\177" 'skk-isearch-delete-char)

  ;; C-x map for skk.
  (define-key skk-isearch-mode-map "\C-x" nil) ;first, make undefined.
  (define-key skk-isearch-mode-map "\C-x\C-j" 'skk-isearch-skk-mode))


;;
;; wrapper functions
;;

(defun skk-isearch-redo-function ()
  "execute the command of given key sequence in skk environment."
  (save-excursion
    (skk-isearch-set-working-buffer)
    (setq unread-command-events (append (this-command-keys) nil))
    (condition-case error
	(let* ((keys (read-key-sequence nil))
	       (this-command (key-binding keys)))
	  (setq last-command-char (aref keys (1- (length keys))))
	  (command-execute this-command))
      (quit (signal (car error) (cdr error)))
      (error (signal (car error) (cdr error))))))

(defun skk-isearch-search-string ()
  "return the string to be searched.  if j-henkan-on, just return nil."
  (save-excursion
    (skk-isearch-set-working-buffer)
    (if j-henkan-on
	(prog1
	    nil
	  (setq skk-isearch-incomplete-message (buffer-string))
	  (skk-isearch-incomplete-message))
      (prog1
	  (buffer-string)
	(setq skk-isearch-incomplete-message "")
	(erase-buffer)))))


;;
;; regexp search supports.
;;
(defun skk-isearch-last-char (string)
  (and (string-match ".\\'" string)
       (string-to-char (substring string (match-beginning 0)))))

(defun skk-isearch-breakable-p (char)
  ;;(string-match word-across-newline (char-to-string char))
  (and char
       (let ((lc (char-leading-char char)))
	 (or (= lc lc-jp) (= lc lc-cn)))))

(defun skk-isearch-search-string-regexp (string)
  (if isearch-regexp
      (let ((chars (string-to-char-list string))
	    (prev (skk-isearch-last-char isearch-string))
	    (result ""))
	(while chars
	  (if (and (skk-isearch-breakable-p prev)
		   (skk-isearch-breakable-p (car chars)))
	      (setq result (concat result skk-isearch-whitespace-regexp)))
	  (setq result (concat result (char-to-string (car chars)))
		prev (car chars)
		chars (cdr chars)))
	result)
    string))

(defun skk-isearch-process-search-string (string)
  (isearch-process-search-string (skk-isearch-search-string-regexp string) 
				 string))


;;
;; interactive functions.
;;
(defun skk-isearch-delete-char (&rest args)
  (interactive "P")
  (or (save-excursion
	(skk-isearch-set-working-buffer)
	(if j-henkan-on
	    (prog1
		t
	      ;; now, we can't pass the universal argument within the
	      ;; isearch-mode.  so hard code the value `1'.
	      (delete-backward-char 1)
	      (setq skk-isearch-incomplete-message (buffer-string))
	      (skk-isearch-incomplete-message))))
      (isearch-delete-char)))

(defun skk-isearch-j-kakutei (isearch-function)
  (if (save-excursion
	(skk-isearch-set-working-buffer)
	(if j-henkan-on
	    (prog1
		t
	      (j-kakutei))))
      (skk-isearch-process-search-string (skk-isearch-search-string))
    (funcall isearch-function)))

(defun skk-isearch-exit (&rest args)
  (interactive "P")
  (skk-isearch-j-kakutei (function isearch-exit)))

(defun skk-isearch-newline (&rest args)
  (interactive "P")
  (skk-isearch-j-kakutei (function isearch-printing-char)))

(defun skk-isearch-skk-mode (&rest args)
  (interactive "P")
  (skk-isearch-redo-function)
  (isearch-message))

(defun skk-isearch-wrapper (&rest args)
  (interactive "P")
  (skk-isearch-redo-function)
  (let ((string (skk-isearch-search-string)))
    (if (null string)
	;; on the way to converting to kanji.
	nil
      (let* ((overriding-local-map isearch-mode-map)
	     (command (key-binding string)))
	(if (commandp command)
	    ;; process a special character, such as *, |, ...
	    (command-execute command)
	  ;; just search literally.
	  (skk-isearch-process-search-string string) )))))


(provide 'skk-isearch)

