;; skk-tools: A package of utility functions for SKK.

;; Copyright (C) 1991, 1992, 1993
;; Masahiko Sato (masahiko@sato.riec.tohoku.ac.jp)

;; version 1.13 of April 24, 1993

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either versions 2, or (at your option)
;; any later version.

;; This program is distributed in the hope that it will be useful
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SKK, see the file COPYING.  If not, write to the Free
;; Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

;; Following people contributed modifications to skk-tools.el:
;;	Masakazu Takahashi (masaka-t@ascii.co.jp)
;;	Brian Thomson (thomson@hub.toronto.edu)
;;      Tomoyuki Hiro (hiro@momo.it.okayama-u.ac.jp)

;; version 1.13 released 1993.4.24
;; version 1.12 released 1993.1.22
;; version 1.11 released 1992.5.9
;; version 1.10 released 1992.4.23
;; version 1.9  released 1991.6.9
;; version 1.8  released 1991.6.6
;; version 1.7  released 1991.5.15
;; version 1.6  released 1991.5.8
;; version 1.5  released 1991.4.17
;; version 1.4  released 1991.4.12

(provide 'skk-tools)

(defvar skk-emacs-sort (concat exec-directory "emacs-sort")
  "Full path name of the emacs sort shell script.")

;; Part I
;; SKK diff: Compute the difference of two SKK dictionaries.
;; Modified by Masakazu Takahashi (masaka-t@ascii.co.jp), 1991.1.8., 1991.3.31

;; skk-diff λȤ.
;;
;; äƵŤʼ˲ʤ褦, ȤϤ٤Ƽ򥳥ԡƤ,
;; ԡˤĤƹԤ.
;;
;; [1] ѤΥǥ쥯ȥѰդ,  cd .
;; [2] diff Ȥꤿ2Ĥμ dic1, dic2 ˥ԡ.
;; [3] M-x cd ˤ, emacs  default directory  [1] κѤ
;;     ǥ쥯ȥȰפ.
;; ʲ[4], [5]ΤʤȤ狼äƤ뼭ˤĤƤϾάƤ褤.
;; [4] M-x skk-check-jisyo ¹Ԥ. ּե: פʹƤΤ,
;;     dic1 ޤ dic2 ȥפ.
;; [5] å̤Хåե*jisyo check*פɽ.
;;     Τ,
;;		ñ줬ҤȤĤʤ.
;;		ñ.	
;;      	ԤκǸ夬/פǤʤ.
;;      	ɤߤľ夬 /פǤʤ.
;;		ɤߤñζڤ꤬ʤ.
;;     ȤåΤԤˤĤƤ, ꤬Τ,
;;     Ŭ˽. ʳΥå, 桼ؤդʤΤ̵
;;     Ƥ褤. ʾνɬפʤйԤ, ̤Ƥ dic1 ˥֤.
;; [6] M-x skk-diff ¹Ԥ. ּե1פȡּե2פ
;;      ʹƤΤ, 줾, dic1  dic2 . ׻λ,
;;      ̤ SKK-JISYO-DIFF Ȥ̾Υե dic1  dic2 κʬ(dic1
;;      ˤ뤬 dic2 ˤϤʤ)񤫤.

(defun skk-diff (file1 file2)
  (interactive "fե1: \nfե2: ")
  (let (p q lines)
    (save-excursion
      (set-buffer (get-buffer-create " *work*"))
      (erase-buffer)
      (insert-file-contents file1)
      (goto-char (point-max))
      (if (not (bolp))
	  (progn
	    (insert "\n")
	    (message "%s does not end with a newline!" file1)
	    (sit-for 3)))
      (j-delete-okuri-entries)
      ;; sort the content of file1
      (message "sorting the first file...")
      (skk-sort-lines nil (point-min) (point-max))
      (message "sorting the first file...done")
      (goto-char (point-max))
      (setq lines (count-lines (point-min) (point-max)))
      (insert "/cut point/\n")
      ;;(backward-char 1)
      (setq q (point-marker))
      ;;(forward-char 1)
      (insert-file-contents file2)
      (goto-char (point-max))
      (if (not (bolp))
	  (progn
	    (insert "\n")
	    (message "%s does not end with a newline!" file2)
	    (sit-for 3)))
      ;; sort the content of file2
      (message "sorting the second file...")
      (skk-sort-lines nil (+ q 0) (point-max))
      (message "sorting the second file...done")
      (goto-char (point-min))
      (setq p (point-marker))
      (while (not (looking-at "/cut point/"))
	(if (= (mod lines 100) 0) (message "%d" lines))
	(setq lines (1- lines))
	(let ((yomi (buffer-substring p
				      (progn
					(search-forward " /")
					(point))))
	      vect)
	  (setq p (point))
	  (goto-char q)
	  (let ((kanji-flag nil) (case-fold-search nil) (v (vector)) yomi2)
	    ;; kanji-flag must be set nil for efficiency.
	    (while (and (not (eobp))
			(string< (setq yomi2
				       (buffer-substring
					q
					(progn
					  (search-forward " /")
					  (point))))
				 yomi))
	      (end-of-line)
	      (forward-char 1)
	      (setq q (point-marker)))
	    (if (string= yomi yomi2)
		(progn
		  (setq vect2 (j-make-word-vect-simple))
		  (end-of-line)
		  (forward-char 1)
		  (setq q (point-marker))
		  (goto-char p)
		  (setq vect (j-vdiff (j-make-word-vect-simple) vect2))
		  (if (> (length vect) 0)
		      (progn
			(delete-region p (progn (end-of-line) (point)))
			(let ((i 0) (l (length vect)))
			  (while (< i l)
			    (insert (aref vect i) "/")
			    (setq i (1+ i))))
			(forward-char 1)
			(setq p (point)))
		    (delete-region
		     (progn
		       (beginning-of-line)
		       (point))
		     (progn
		       (end-of-line)
		       (1+ (point))))
		    (setq p (point))))
	      (beginning-of-line)
	      (setq q (point-marker))
	      (goto-char p)
	      (end-of-line)
	      (forward-char 1)
	      (setq p (point))))))
      (message "Done!")
      (goto-char p)
      (search-forward "/cut point/")
      (beginning-of-line)
      (write-region
       (point-min) (point)
       (concat (expand-file-name default-directory) "SKK-JISYO-DIFF")
       nil 'nomsg)
      (kill-buffer " *work*"))))

(defun j-make-word-vect-simple ()
  (let ((v (vector)))
    (while (not (eolp))
      (setq v (vconcat v
		       (vector
			(buffer-substring
			 (point)
			 (progn
			   (search-forward "/")
			   (1- (point))))))))
    v))

(defun j-vdiff (vect1 vect2)
  (let ((v (vector)) (i 0) j w (l1 (length vect1)) (l2 (length vect2)) cont)
    (while (< i l1)
      (setq j 0)
      (setq w (aref vect1 i))
      (setq cont t)
      (while (and cont (< j l2))
	(if (string= w (aref vect2 j)) (setq cont nil))
	(setq j (1+ j)))
      (if cont (setq v (vconcat v (vector w))))
      (setq i (1+ i)))
    v))

(defun skk-check-jisyo (file)
  (interactive "fե: ")
  (let (p q r ok (line 0) lines)
    (set-buffer (get-buffer-create "*jisyo check*"))
    (erase-buffer)
    (set-buffer (get-buffer-create "*checked jisyo*"))
    (erase-buffer)
    (insert-file-contents file)
    (setq lines (1- (count-lines (point-min) (point-max))))
    (goto-char (point-min))
    (while (not (eobp))
      (setq ok t)
      (setq lines (1- lines))
      (if (= (mod lines 100) 0) (message "%d" lines))
      (setq line (1+ line))
      (setq p (point))
      (save-excursion
	(end-of-line)
	(setq q (point))) ; q is end of line
      (or (looking-at ";;") ; skip a comment line (Tomoyuki Hiro, 1992.5.6)
	  (if (search-forward " " q t)
	      (progn
		(setq r (point))
		(goto-char p)
		(let ((char (following-char)))
		  (cond ((or (= char 164) (= char 165) (= char ?#)
			     (looking-at ""))
			 (forward-char 1)
			 (while (or (= (following-char) 164)
				    (= (following-char) 165)
				    ;; added by Tomoyuki Hiro, 1992.5.6
				    (= (following-char) ?#)
				    (looking-at ""))
			   (forward-char 1))
			 (if (not (looking-at "[a-z] \\| "))
			     (j-show-error "ɤߤѤ.")))
			((looking-at "[!-~]+ ") t)
			(t (j-show-error "ɤߤѤ."))))
		(goto-char r)
		(if (= (following-char) ?/)
		    (progn
		      (forward-char 1)
		      (if (search-forward " " q t)
			  (progn
			    (goto-char (1+ r))
			    (j-show-error "ñ줬ڡޤǤ.")))
		      (if (search-forward "\t" q t)
			  (progn
			    (goto-char (1+ r))
			    (j-show-error "ñ줬֤ޤǤ.")))
		      (if (eolp)
			  (j-show-error "ñ줬ҤȤĤʤ." t)
			(while (not (eolp))
			  (if (= (following-char) ?/)
			      (progn
				(j-show-error "ñ." t)
				(end-of-line))
			    (if (not (search-forward "/" q t))
				(progn
				  (j-show-error "ԤκǸ夬/פǤʤ." t)
				  (end-of-line)))))))
		  (j-show-error "ɤߤľ夬 /פǤʤ." t)))
	    (j-show-error "ɤߤñζڤ꤬ʤ." t)))
      (if (not ok)
	  (progn
	    (beginning-of-line)
	    (insert "?")))
      (end-of-line)
      (forward-char 1))
    (message "Done!")
    (switch-to-buffer "*jisyo check*")
    (goto-char (point-min))
    (if (eobp) (insert "եϤޤ."))
    (switch-to-buffer-other-window "*checked jisyo*")
    (goto-char (point-min))))

(defun j-show-error (msg &optional print-error)
  "If PRINT-ERROR is t, ? will be inserted in the jisyo-buffer"
  (let ((line-string
	 (save-excursion
	   (buffer-substring
	    (progn
	      (beginning-of-line)
	      (point))
	    (progn
	      (end-of-line)
	      (point))))))
    (save-excursion
      (set-buffer "*jisyo check*")
      (goto-char (point-min))
      (insert (format "Line: %d %s\n%s\n\n" line msg line-string)))
    (if print-error (setq ok nil))))

(defun j-delete-okuri-entries ()
  (goto-char (point-min))
  (while (search-forward "/[" nil t)
    (delete-region (1- (point)) (progn (end-of-line) (point)))))

;; Part II
;; SKK merge: Merge two SKK dictionaries.

;; ե#1 ȼե#2 ޡ. ƱФ줬 #1  #2
;; ξˤȤ #1 ιܤͥ褷ƥޡ. ե˥
;; ȹ(";; "ǻϤޤ), ȹԤϺƥޡ. 
;; ե뤬Ԥ򶭳Ȥ okuri-ari  okuri-nasi ʬΥ
;; ƤȤ, 餫եդĤʬ䤷Ƥƥޡ
;; ΨŪǤ.

;; Modified by Masakazu Takahashi (masaka-t@ascii.co.jp),
;; 1990.12.13, 1991.3.31
;; Modified by Masahiko Sato (masahiko@sato.riec.tohoku.ac.jp),
;; 1991.4.12, 1991.5.8 
;; Modified by Brian Thomson (thomson@hub.toronto.edu)
;; 1992.4.16, 1992.4.22

;; skk-merge λȤ.
;;
;; äƵŤʼ˲ʤ褦, ȤϤ٤Ƽ򥳥ԡƤ,
;; ԡˤĤƹԤ.
;;
;; [1] ѤΥǥ쥯ȥѰդ,  cd .
;; [2] ޡ dic1, dic2 ˥ԡ.
;; [3] M-x skk-merge ¹Ԥ.
;; [4] ּե1פȡּե2פʹƤΤ dic1, dic2 
;;     . ׻λȷ̤ NEW-SKK-JISYO Ȥ̾Υե
;;     񤫤. ̤μϥȤƤ.

(defun skk-merge (file1 file2 &optional donot-countdown)
  (interactive "fե#1: \nfե#2: ")
  (save-excursion
    (skk-merge-load file1 file2)
    (message "sorting the buffer...")
    (skk-sort-lines nil (point-min) (point-max))
    ;;(sort-fields 1 (point-min) (point-max))
    (message "sorting the buffer...done")
    (skk-merge-rm-dups donot-countdown)
    (message "񤤤Ƥ롣")
    (write-region (point-min) (point-max)
		  (concat default-directory "NEW-SKK-JISYO") nil 'nomsg)
    (message "Done!")
    ;;(kill-buffer " *work*")
    ))

(defun skk-merge-load (&rest files)
  (switch-to-buffer (get-buffer-create " *work*"))
  (erase-buffer)
  (mapcar
   (function
    (lambda (file)
      (setq p (point))
      (insert-file-contents file)
      ;; modified by Masahiko Sato, 1992.4.21
      ;; delete comment lines
      (while (re-search-forward "^;; " nil t)
	(beginning-of-line)
	(delete-region
	 (point)
	 (progn (end-of-line) (1+ (point)))))
      (goto-char (point-max))
      (if (not (bolp))
	  (progn
	    (insert "\n")
	    (message "%s does not end with a newline!" file)
	    (sit-for 3)))))
   files)
  (j-delete-okuri-entries))

(defun skk-sort-lines  (reverse beg end)
  "if REVERS sort by the reverse order. sort the region by calling
emacs-sort."
  (let ((tmp-file
	 (expand-file-name (concat default-directory "SKK-TMP-FILE"))))
    (write-region beg end tmp-file nil 'nomsg)
    (call-process skk-emacs-sort nil nil nil (if reverse "-r" "-n") tmp-file)
    (delete-region beg end)
    (insert-file-contents tmp-file)
    (call-process "/bin/rm" nil nil nil tmp-file)))

(defun skk-merge-rm-dups (shizukani)
  (let (p q (curl 0) (lines 0))
    (if shizukani
        (message "Merging Dictionaries...")
      (setq lines (count-lines (point-min) (point-max))))
    (goto-char (point-min))
    (while (< (point) (point-max))
      (if (not shizukani) (message "%d/%d" curl lines))
      (let ((yomi
	     (concat "\n"
		     (buffer-substring (point)
				       (progn
					 (search-forward " /")
					 (point))))))
	(setq p (point))
	(end-of-line)
	(setq q (+ (point) (length yomi)))
	(if (and
		(< q (point-max))
		(string-equal yomi (buffer-substring (point) q)))
	    (let (vect)
		(goto-char q)
		(setq vect (j-make-word-vect))
                (setq q (progn (end-of-line) (point)))
		(goto-char p)
		(setq vect (j-vadd (j-make-word-vect) vect))
		(delete-region p q)
		(j-vwrite vect)
		(goto-char p)
		(setq lines (1- lines)))
            (forward-char 1)
	    (setq curl (1+ curl)))
	(beginning-of-line)))))

(defun j-make-word-vect ()
  (j-make-word-vect1 (point) (progn (end-of-line) (point))) )

(defun j-make-word-vect1 (p1 p2)
  (goto-char p1)
  (let (lst)
    (while (< (point) p2)
      (setq lst
	    (cons
	     (cond ((= (following-char) ?\[)
		    (let ((end (save-excursion
				 (forward-sexp 1)
				 (1- (point)) )))
		      (forward-char 1)	; skip "["
		      (prog1
			  (cons
			   (buffer-substring
			    (point)
			    (progn (search-forward "/") (1- (point))) )
			   (j-make-word-vect1 (point) end) )
			(forward-char 2) ))) ; skip "]/"
		   (t			; string
		    (buffer-substring
		     (point)
		     (progn (search-forward "/") (1- (point))) ) ))
	     lst )))
    (apply 'vector (nreverse lst)) ))

(defun j-vadd (vect1 vect2)
  "add elements of vect2 not in vect1 to vect1."
  (let ((v vect1)			; result vector
	(i 0)				; loop counter for vect2
	w				; element in vect2
	e1				; element in vect1
	(l1 (length vect1))		; length of vect1
	(l2 (length vect2)) )		; length of vect2
    (while (< i l2)
      (setq w (aref vect2 i))
      (let ((j 0) (cont t))
	(if (stringp w)
	    ;; w is a string
	    (progn
	      (while (and cont (< j l1))
		(if (and (stringp (setq e1 (aref vect1 j)))
			 (string= w e1) )
		    (setq cont nil) )
		(setq j (1+ j)) )
	      (if cont (setq v (vconcat v (vector w)))) )
	  ;; w is not a string
	  (while (and cont (< j l1))
	    (if (and (consp (setq e1 (aref vect1 j)))
		     (string= (car w) (car e1)) )
		(progn
		  (aset v j (cons (car w) (j-vadd (cdr w) (cdr e1))))
		  (setq cont nil) ))
	    (setq j (1+ j)) )
	  (if cont (setq v (vconcat v (vector w)))) ))
      (setq i (1+ i)) )
    v ))

(defun j-vwrite (vect)
  "write merged vector to buffer"
  (let ((i 0)
	(l (length vect))
	elm )
    (while (< i l)
      (setq elm (aref vect i))
      (if (stringp elm)
	  (insert elm "/")
	(insert "[" (car elm) "/")
	(j-vwrite (cdr elm))
	(insert "]/") )
      (setq i (1+ i)) )))

(defun j-reformat-jisyo-buffer ()
  (interactive)
  (message "Your SKK Jisyo is in old format.  I will reformat it...")
  (sit-for 2)
  (let (okuri kanji)
    (j-reformat-buffer)
    (goto-char (point-min))
    (search-forward ";; okuri-nasi")
    (beginning-of-line)
    (setq okuri (buffer-substring (point-min) (point)))
    (delete-region (point-min) (point))
    (save-excursion
      (set-buffer (get-buffer-create " *skk-okuri-jisyo*"))
      (erase-buffer)
      (insert okuri)
      (goto-char (point-min))
      (insert ";; okuri-ari entries.\n")
      (while (search-forward "i /" nil t)
	(setq p (point))
	(search-forward "/")
	(setq kanji (buffer-substring p (1- (point))))
	(end-of-line)
	(or (= ?\] (char-after (- (point) 2)))
	    (insert "[/" kanji "/]/")))
      (goto-char (point-min))
      (while (search-forward "u /" nil t)
	(setq p (point))
	(search-forward "/")
	(setq kanji (buffer-substring p (1- (point))))
	(end-of-line)
	(or (= ?\] (char-after (- (point) 2)))
	    (insert "[/" kanji "/]/")))
      (goto-char (point-min))
      (while (search-forward "e /" nil t)
	(setq p (point))
	(search-forward "/")
	(setq kanji (buffer-substring p (1- (point))))
	(end-of-line)
	(or (= ?\] (char-after (- (point) 2)))
	    (insert "[/" kanji "/]/")))
      (goto-char (point-min))
      (while (search-forward "o /" nil t)
	(setq p (point))
	(search-forward "/")
	(setq kanji (buffer-substring p (1- (point))))
	(end-of-line)
	(or (= ?\] (char-after (- (point) 2)))
	    (insert "[/" kanji "/]/")))
      (skk-save-jisyo)
      )
    ;; remove okuri-jisyo part again
    (goto-char (point-min))
    (search-forward ";; okuri-nasi")
    (beginning-of-line)
    (delete-region (point-min) (point))
    (set-buffer-modified-p nil)
    ))

(defun j-reformat-buffer ()
  (let ((kanji-flag nil) p str (count 0))
    (insert ";; okuri-nasi entries.\n")
    (goto-char (point-min))
    (search-forward ";; okuri-nasi")
    (while (re-search-forward "[a-z] /" nil t)
      (beginning-of-line)
      (if (> (following-char) 127)
	  (progn
	    (setq p (point))
	    (end-of-line)
	    (setq str (buffer-substring p (1+ (point))))
	    (delete-region p (1+ (point)))
	    (goto-char (point-min))
	    (insert str)
	    (goto-char p)
	    (setq count (1+ count))
	    (if (= (mod count 10) 0) (message "%d" count)))
	(end-of-line)))
    (goto-char (point-min))
    (search-forward ";; okuri-nasi")
    (beginning-of-line)
    (skk-sort-lines t (point-min) (point))))

;; Count the number of entries in a jisyo buffer. For instance the following
;; line contains 4 entries.
;;  /////

(defun skk-count-jisyo-entries ()
  "Count the number of entries in a jisyo buffer"
  (interactive)
  (let ((count 0))
    (goto-char (point-min))
    (while (search-forward "/" nil t)
      (or (eolp) (setq count (1+ count))))
    (message "Buffer has %d entries." count)))

;; clear unnecessary braces from info-file created by latexinfo program

(defun skk-latexinfo-format-buffer ()
  (interactive)
  (let (p)
    ;; remove iftex part
    (goto-char (point-min))
    (while (re-search-forward "^\\\\begin{iftex}" nil t)
      (beginning-of-line)
      (setq p (point))
      (re-search-forward "^\\\\end{iftex}")
      (end-of-line)
      (delete-region p (1+ (point))))
    (latexinfo-format-buffer t)
    (goto-char (point-min))
    (while (search-forward "[{[" nil t)
      (delete-backward-char 2)
      (search-forward "}]")
      (delete-backward-char 2))
    (goto-char (point-min))
    (while (search-forward "{[" nil t)
      (backward-char 2)
      (setq p (point))
      (forward-sexp 1)
      (delete-backward-char 1)
      (goto-char p)
      (delete-char 1))
    (goto-char (point-min))
    (Info-tagify)
    (message "Formatting finished, now save it.")))

(autoload 'latexinfo-format-buffer "latexinfo" nil t)
