#include <stdio.h>
#include <stdlib.h>
#include <gnutls/gnutls.h>

static gnutls_session tls_session = NULL;

void
tls_negotiate (fd, cert_file, key_file)
     int fd;
     const char *cert_file, *key_file;
{
  gnutls_certificate_credentials xcred;

  gnutls_global_init ();

  gnutls_certificate_allocate_credentials(&xcred);

  if (cert_file)
    {
      if (!key_file)
	key_file = cert_file;
      gnutls_certificate_set_x509_key_file (xcred, cert_file, key_file,
					    GNUTLS_X509_FMT_PEM);
    }

  gnutls_init (&tls_session, GNUTLS_CLIENT);
  gnutls_set_default_priority (tls_session);
  gnutls_credentials_set (tls_session, GNUTLS_CRD_CERTIFICATE, xcred);

  gnutls_transport_set_ptr (tls_session, (gnutls_transport_ptr)fd);

  gnutls_handshake (tls_session);
}

int
tls_write(fd, buf, num)
     const char *buf;
     int fd, num;
{
  if (tls_session) 
    return gnutls_record_send (tls_session, buf, num);
  return write (fd, buf, num);
}

int
tls_read(fd, buf, num)
     char *buf;
     int fd, num;
{
  if (tls_session)
    return gnutls_record_recv (tls_session, buf, num);
  return read (fd, buf, num);
}

int
tls_pending()
{
  return tls_session && gnutls_record_check_pending (tls_session);
}
