;;; emh-setup.el --- setup file for emh.

;; Copyright (C) 1994,1995,1996,1997,1998 Free Software Foundation, Inc.

;; Author: MORIOKA Tomohiko <morioka@jaist.ac.jp>
;; Keywords: mh-e, mail, news, MIME, multimedia, multilingual

;; This file is part of emh.

;; This program is free software; you can redistribute it and/or
;; modify it under the terms of the GNU General Public License as
;; published by the Free Software Foundation; either version 2, or (at
;; your option) any later version.

;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Code:

(require 'semi-setup)


;;; @ for emh
;;;

(eval-after-load "mh-e" '(require 'emh))


;;; @ for mime-edit
;;;

(autoload 'turn-on-mime-edit "mime-edit"
  "Unconditionally turn on MIME-Edit minor mode." t)

(defun emh-setup-mh-draft-setting ()
  (make-local-variable 'mail-header-separator)
  (setq mail-header-separator "--------")
  (mime-decode-header-in-buffer nil mail-header-separator)
  (let ((ua mime-edit-user-agent-value))
    (make-local-variable 'mime-edit-user-agent-value)
    (setq mime-edit-user-agent-value (concat "EMH/" emh-version " " ua))
    )
  (turn-on-mime-edit)
  (save-excursion
    (goto-char (point-min))
    (setq buffer-read-only nil)
    (if (re-search-forward "^-*$" nil t)
	(progn
	  (replace-match mail-header-separator)
	  (set-buffer-modified-p (buffer-modified-p))
	  ))
    ))

(add-hook 'mh-letter-mode-hook 'emh-setup-mh-draft-setting t)
(add-hook 'mh-before-send-letter-hook 'mime-edit-maybe-translate)


;;; @@ for emh-comp.el
;;;

(autoload 'emh-edit-again "emh-comp"
  "Clean-up a draft or a message previously sent and make it resendable." t)
(autoload 'emh-extract-rejected-mail "emh-comp"
  "Extract a letter returned by the mail system and make it re-editable." t)
(autoload 'emh-forward "emh-comp"
  "Forward a message or message sequence by MIME style." t)

(eval-after-load
    "mh-e"
  '(progn
     (substitute-key-definition
      'mh-edit-again 'emh-edit-again
      mh-folder-mode-map)
     (substitute-key-definition
      'mh-extract-rejected-mail 'emh-extract-rejected-mail
      mh-folder-mode-map)
     (substitute-key-definition
      'mh-forward 'emh-forward
      mh-folder-mode-map)
     ))

(eval-after-load "mh-comp" '(require 'emh-comp))


;;; @ end
;;;

(provide 'emh-setup)

;;; emh-setup.el ends here
