#include <windows.h>
#include "DataObject.h"
#include "DropSource.h"
#include <shlobj.h>
#include <stdio.h>
#include <sys/stat.h>
#include "version.h"

#define PROG "dropfile.exe"

char *g_text;

LRESULT CALLBACK WndProc(HWND, UINT, WPARAM, LPARAM);

BOOL InitInstance (HINSTANCE hInstance, int nCmdShow)
{
  RECT wRect;
  HWND hWnd;
  POINT pt,st;
  LPARAM lParam;

  WNDCLASSEX	wc;

  wc.cbSize = sizeof(wc);
  wc.style = CS_HREDRAW | CS_VREDRAW;
  wc.lpfnWndProc = WndProc;
  wc.cbClsExtra = 0;
  wc.cbWndExtra = 0;
  wc.hInstance = hInstance;
  wc.hIcon = NULL;
  wc.hIconSm = NULL;
  wc.hCursor = ::LoadCursor(NULL, IDC_ARROW);
  wc.hbrBackground = (HBRUSH)(COLOR_WINDOW+1);
  wc.lpszClassName = "DROPFILECLASS";
  wc.lpszMenuName = NULL;

  RegisterClassEx(&wc);

  // Create Dummy Window (1 pixel)
  hWnd = CreateWindowEx(WS_EX_TRANSPARENT,
			"DROPFILECLASS",
			"Dragging File...",
			WS_POPUP,
			0, 0, 1, 1, NULL, NULL, hInstance, NULL);
  if (!hWnd)
    {
      return FALSE;
    }
  ShowWindow (hWnd, nCmdShow);
  SetForegroundWindow(hWnd);
  SetCapture(hWnd);
  GetWindowRect(hWnd,&wRect);
  GetCursorPos(&st);
  SetCursorPos(wRect.left, wRect.top);
  pt.x = wRect.left;
  pt.y = wRect.top;
  ScreenToClient(hWnd, &pt);
  lParam = MAKELPARAM(pt.x,pt.y);
  mouse_event (MOUSEEVENTF_LEFTUP, 0, 0, 0, 0);
  mouse_event (MOUSEEVENTF_LEFTDOWN, 0, 0, 0, 0);
  SetCursorPos(st.x, st.y);

  return TRUE;
}

void createMedium (CLIPFORMAT cfFormat, HANDLE hObject,
		   FORMATETC *pFormatetc, STGMEDIUM *pmedium)
{
  pFormatetc->cfFormat = cfFormat;
  pFormatetc->dwAspect = DVASPECT_CONTENT;
  pFormatetc->lindex = -1;
  pFormatetc->ptd = NULL;
  pFormatetc->tymed = TYMED_HGLOBAL;

  pmedium->hGlobal = hObject;
  pmedium->tymed = TYMED_HGLOBAL;
  pmedium->pUnkForRelease = NULL;
}

HGLOBAL createHText(char *text)
{
  HGLOBAL hText;
  int len;
  char *p;

  len = lstrlen(text);
  hText = GlobalAlloc(GHND, len + 1);
  if (hText == NULL)	return NULL;

  p = (char*)GlobalLock(hText);
  lstrcpy(p, text);
  GlobalUnlock(hText);

  return hText;
}

HDROP createHDrop(char **FileName, int cnt)
{
  HDROP hDrop;
  LPDROPFILES lpDropFile;
  int	btotal;
  int i;
  char *buf;
  
  btotal = 0;
  for(i = 0;i < cnt;i++){
    btotal += lstrlen(FileName[i]) + 1;
  }
  
  hDrop = (HDROP)GlobalAlloc(GHND, sizeof(DROPFILES) + btotal + 2);
  if (hDrop == NULL)	return NULL;
  
  lpDropFile = (LPDROPFILES)GlobalLock(hDrop);
  lpDropFile->pFiles = sizeof(DROPFILES);
  lpDropFile->pt.x = 0;
  lpDropFile->pt.y = 0;
  lpDropFile->fNC = FALSE;
  lpDropFile->fWide = FALSE;

  buf = (char *)(&lpDropFile[1]);
  for(i = 0; i < cnt; i++){
    lstrcpy(buf,FileName[i]);
    buf += lstrlen(FileName[i]) + 1;
  }
  *buf++ = 0;
  *buf = 0;
  GlobalUnlock(hDrop);
  return hDrop;
}

LRESULT OnLButtonDown(WPARAM wParam, LPARAM lParam)
{
  CDataObject	*dobj = NULL;
  CDropSource	*dsrc = NULL;
  HANDLE		hObject = NULL;
  FORMATETC	fmt;
  STGMEDIUM	medium;
  DWORD		dwEffect;
  char		*p[1];
  int	ret;

  dobj = new CDataObject();
  if(dobj == NULL) goto error;
  if(!dobj->allocate(2)) goto error;
  
  if((hObject = createHText(g_text)) == NULL) goto error;
  createMedium(CF_TEXT, hObject, &fmt, &medium);
  if(dobj->SetData(&fmt, &medium, TRUE) != S_OK) goto error;
  
  p[0] = g_text;
  if((hObject = createHDrop(p, 1)) == NULL) goto error;
  createMedium(CF_HDROP, hObject, &fmt, &medium);
  
  if(dobj->SetData(&fmt, &medium, TRUE) != S_OK) goto error;

  hObject = NULL;
  
  dsrc = new CDropSource();
  if(dsrc == NULL) goto error;

  ret = DoDragDrop(dobj, dsrc, DROPEFFECT_MOVE, &dwEffect);
  
 error:
  if(dsrc) dsrc->Release();
  if(dobj) dobj->Release();
  if(hObject) GlobalFree(hObject);

  OleUninitialize();
  exit (0);
}

LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
  switch (message) 
    {
    case WM_DESTROY:
      PostQuitMessage(0);
      break;
    case WM_LBUTTONDOWN:
      return OnLButtonDown(wParam, lParam);      
    default:
      return DefWindowProc(hWnd, message, wParam, lParam);
    }
  return 0;
}

// From mew/bin
int  Optind = 1;
char *Optarg = NULL;
#define NUL '\0'
char *warn_prog = NULL;

void
warn_exit(const char *fmt, ...)
{
  va_list ap;

  if (warn_prog != NULL)
    fprintf(stderr, "%s: ", warn_prog);
  va_start(ap, fmt);
  if (fmt != NULL)
    vfprintf(stderr, fmt, ap);
  va_end(ap);
  
  exit(1);
}

int
Getopt(int argc, char *argv[], const char *fmt)
{
  char *p, *q, c;

  Optarg = NULL;
  if (Optind >= argc)
    return EOF;
  p = argv[Optind];
  if (*p++ != '-')
    return EOF;
  c = *p;
  if (c == NUL)
    return EOF;
  if (*(p + 1) != NUL)
    warn_exit("unknown long option '-%s'.\n", p);
  if ((q = strchr(fmt, c)) == NULL)
    warn_exit("unknown option '-%c'.\n", c);
  if (++q != NULL && *q == ':')
    {
      if (++Optind >= argc)
	warn_exit("no parameter for '-%c'.\n", c);
      Optarg = argv[Optind];
    }
  Optind++;
  return c;
}

void
usage (char *progname)
{
  printf ("%s - drag and drop a file with specified filename\n\
Usage: %s [options] filename\n%s",
	  progname,
	  progname,
	  "Options:\n\
 -f\n\
    Use existing file. By default, read data from stdin.\n\
 -h \n\
    print this message and exit.\n\
");
  exit (1);
}

int APIENTRY WinMain(HINSTANCE hInstance,
		     HINSTANCE hPrevInstance,
		     LPTSTR    lpCmdLine,
		     int       nCmdShow)
{
  MSG msg;
  int optc;
  warn_prog = PROG;

  while ((optc = Getopt (__argc, __argv, "hv")) != EOF)
    {
      switch (optc)
	{
	case 'h': // help
	  usage (PROG);
	  break;
	case 'v':
	  fprintf (stderr, "%s - %s\n", PROG, VERSION);
	  exit (0);
	  break;
	}
    }
  g_text = __argv[Optind];
  OleInitialize(NULL);
  if (!InitInstance (hInstance, nCmdShow)) 
    {
      return FALSE;
    }
  while (GetMessage(&msg, NULL, 0, 0)) 
    {
      TranslateMessage(&msg);
      DispatchMessage(&msg);
    }
  return (int) msg.wParam;
}
