;;; -*- coding: iso-2022-7bit -*-
;;; usupple.el --- tables for various definitions that are
;;;                different from Unicode Consortium's.

;; Copyright (C) 2000 Miyashita Hisashi

;; Keywords: mule, multilingual, 
;;           character set, coding-system, ISO/IEC 10646,
;;           Unicode, JIS X 0221, JDK, Japanese-EUC, Windows,
;;           halfwidth or fullwidth character.

;; This file is part of Mule-UCS

;; Mule-UCS is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; Mule-UCS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;; (defvar exclude-compatibility-area-unicode-translation-rule nil)

(defvar unicode-assoc-for-jisx0221
  '(assoc
    (char-1 . ucs-generic)
    ((?$B!=(B . ?\x0214) ;; HORIZONTAL BAR
     (?$B!1(B . ?\x203E) ;; OVERLINE
     (?$B!=(B . ?\x2014) ;; EM DASH
     (?$B!@(B . ?\xFF3C) ;; FULLWIDTH REVERSE SOLIDUS
     (?$B!o(B . ?\x00A5) ;; YEN SIGN
     (?$(D"7(B . ?\xFFE5) ;; FULLWIDTH TILDE
     )))

(defvar unicode-assoc-for-jdk
  `(assoc
    (char-1 . ucs-generic)
    ((,(make-char 'ascii ?\x5C) . ?\x005C) ;; REVERSE SOLIDUS
     (,(make-char 'ascii ?\x5C) . ?\x00A5) ;; YEN SIGN(ignored at encoding time)
     (,(make-char 'ascii ?\x7E) . ?\x007E) ;; TILDE
     (,(make-char 'ascii ?\x7E) . ?\x203E) ;; OVERLINE(ignored at encoding time)
     (?$B!@(B . ?\xFF3C) ;; FULLWIDTH REVERSE SOLIDUS
     )))

(defvar unicode-assoc-for-windows
  `(assoc
    (char-1 . ucs-generic)
    (;; JIS X 0208 correspondings
     (?$B!@(B . ?\xFF3C) ;; FULLWIDTH REVERSE SOLIDUS
     (?$B!A(B . ?\xFF5E) ;; FULLWIDTH TILDE
     (?$B!B(B . ?\x2225) ;; PARALLEL TO
     (?$B!](B . ?\xFF0D) ;; FULLWIDTH HYPHENMINUS
     (?$B!q(B . ?\xFFE0) ;; FULLWIDTH CENT SIGN
     (?$B!r(B . ?\xFFE1) ;; FULLWIDTH POUND SIGN
     (?$B"L(B . ?\xFFE2) ;; FULLWIDTH NOT SIGN
     ;; JIS X 0212 correspondings
     (?$(D"7(B . ?\xFF5E) ;; FULLWIDTH TILDE (usually not used for decoding)
     (?$(D"C(B . ?\xFF4E) ;; FULLWIDTH BROKEN BAR
     ;; JIS X 0201 correspondings
     ;; (,(make-char 'latin-jisx0201 ?\x5C) . ?\x005C) ;; REVERSE SOLIDUS
     ;; (,(make-char 'latin-jisx0201 ?\x7E) . ?\x007E) ;; TILDE
     )))

(defvar unicode-assoc-for-fullwidth-or-halfwidth-normalization
  '(assoc
    (ucs-generic . ucs-generic)
    ((?\xFF01 . ?\x0021);; FULLWIDTH EXCLAMATION MARK
     (?\xFF02 . ?\x0022);; FULLWIDTH QUOTATION MARK
     (?\xFF03 . ?\x0023);; FULLWIDTH NUMBER SIGN
     (?\xFF04 . ?\x0024);; FULLWIDTH DOLLAR SIGN
     (?\xFF05 . ?\x0025);; FULLWIDTH PERCENT SIGN
     (?\xFF06 . ?\x0026);; FULLWIDTH AMPERSAND
     (?\xFF07 . ?\x0027);; FULLWIDTH APOSTROPHE
     (?\xFF08 . ?\x0028);; FULLWIDTH LEFT PARENTHESIS
     (?\xFF09 . ?\x0029);; FULLWIDTH RIGHT PARENTHESIS
     (?\xFF0A . ?\x002A);; FULLWIDTH ASTERISK
     (?\xFF0B . ?\x002B);; FULLWIDTH PLUS SIGN
     (?\xFF0C . ?\x002C);; FULLWIDTH COMMA
     (?\xFF0D . ?\x002D);; FULLWIDTH HYPHEN-MINUS
     (?\xFF0E . ?\x002E);; FULLWIDTH FULL STOP
     (?\xFF0F . ?\x002F);; FULLWIDTH SOLIDUS
     (?\xFF10 . ?\x0030);; FULLWIDTH DIGIT ZERO
     (?\xFF11 . ?\x0031);; FULLWIDTH DIGIT ONE
     (?\xFF12 . ?\x0032);; FULLWIDTH DIGIT TWO
     (?\xFF13 . ?\x0033);; FULLWIDTH DIGIT THREE
     (?\xFF14 . ?\x0034);; FULLWIDTH DIGIT FOUR
     (?\xFF15 . ?\x0035);; FULLWIDTH DIGIT FIVE
     (?\xFF16 . ?\x0036);; FULLWIDTH DIGIT SIX
     (?\xFF17 . ?\x0037);; FULLWIDTH DIGIT SEVEN
     (?\xFF18 . ?\x0038);; FULLWIDTH DIGIT EIGHT
     (?\xFF19 . ?\x0039);; FULLWIDTH DIGIT NINE
     (?\xFF1A . ?\x003A);; FULLWIDTH COLON
     (?\xFF1B . ?\x003B);; FULLWIDTH SEMICOLON
     (?\xFF1C . ?\x003C);; FULLWIDTH LESS-THAN SIGN
     (?\xFF1D . ?\x003D);; FULLWIDTH EQUALS SIGN
     (?\xFF1E . ?\x003E);; FULLWIDTH GREATER-THAN SIGN
     (?\xFF1F . ?\x003F);; FULLWIDTH QUESTION MARK
     (?\xFF20 . ?\x0040);; FULLWIDTH COMMERCIAL AT
     (?\xFF21 . ?\x0041);; FULLWIDTH LATIN CAPITAL LETTER A
     (?\xFF22 . ?\x0042);; FULLWIDTH LATIN CAPITAL LETTER B
     (?\xFF23 . ?\x0043);; FULLWIDTH LATIN CAPITAL LETTER C
     (?\xFF24 . ?\x0044);; FULLWIDTH LATIN CAPITAL LETTER D
     (?\xFF25 . ?\x0045);; FULLWIDTH LATIN CAPITAL LETTER E
     (?\xFF26 . ?\x0046);; FULLWIDTH LATIN CAPITAL LETTER F
     (?\xFF27 . ?\x0047);; FULLWIDTH LATIN CAPITAL LETTER G
     (?\xFF28 . ?\x0048);; FULLWIDTH LATIN CAPITAL LETTER H
     (?\xFF29 . ?\x0049);; FULLWIDTH LATIN CAPITAL LETTER I
     (?\xFF2A . ?\x004A);; FULLWIDTH LATIN CAPITAL LETTER J
     (?\xFF2B . ?\x004B);; FULLWIDTH LATIN CAPITAL LETTER K
     (?\xFF2C . ?\x004C);; FULLWIDTH LATIN CAPITAL LETTER L
     (?\xFF2D . ?\x004D);; FULLWIDTH LATIN CAPITAL LETTER M
     (?\xFF2E . ?\x004E);; FULLWIDTH LATIN CAPITAL LETTER N
     (?\xFF2F . ?\x004F);; FULLWIDTH LATIN CAPITAL LETTER O
     (?\xFF30 . ?\x0050);; FULLWIDTH LATIN CAPITAL LETTER P
     (?\xFF31 . ?\x0051);; FULLWIDTH LATIN CAPITAL LETTER Q
     (?\xFF32 . ?\x0052);; FULLWIDTH LATIN CAPITAL LETTER R
     (?\xFF33 . ?\x0053);; FULLWIDTH LATIN CAPITAL LETTER S
     (?\xFF34 . ?\x0054);; FULLWIDTH LATIN CAPITAL LETTER T
     (?\xFF35 . ?\x0055);; FULLWIDTH LATIN CAPITAL LETTER U
     (?\xFF36 . ?\x0056);; FULLWIDTH LATIN CAPITAL LETTER V
     (?\xFF37 . ?\x0057);; FULLWIDTH LATIN CAPITAL LETTER W
     (?\xFF38 . ?\x0058);; FULLWIDTH LATIN CAPITAL LETTER X
     (?\xFF39 . ?\x0059);; FULLWIDTH LATIN CAPITAL LETTER Y
     (?\xFF3A . ?\x005A);; FULLWIDTH LATIN CAPITAL LETTER Z
     (?\xFF3B . ?\x005B);; FULLWIDTH LEFT SQUARE BRACKET
     (?\xFF3C . ?\x005C);; FULLWIDTH REVERSE SOLIDUS
     (?\xFF3D . ?\x005D);; FULLWIDTH RIGHT SQUARE BRACKET
     (?\xFF3E . ?\x005E);; FULLWIDTH CIRCUMFLEX ACCENT
     (?\xFF3F . ?\x005F);; FULLWIDTH LOW LINE
     (?\xFF40 . ?\x0060);; FULLWIDTH GRAVE ACCENT
     (?\xFF41 . ?\x0061);; FULLWIDTH LATIN SMALL LETTER A
     (?\xFF42 . ?\x0062);; FULLWIDTH LATIN SMALL LETTER B
     (?\xFF43 . ?\x0063);; FULLWIDTH LATIN SMALL LETTER C
     (?\xFF44 . ?\x0064);; FULLWIDTH LATIN SMALL LETTER D
     (?\xFF45 . ?\x0065);; FULLWIDTH LATIN SMALL LETTER E
     (?\xFF46 . ?\x0066);; FULLWIDTH LATIN SMALL LETTER F
     (?\xFF47 . ?\x0067);; FULLWIDTH LATIN SMALL LETTER G
     (?\xFF48 . ?\x0068);; FULLWIDTH LATIN SMALL LETTER H
     (?\xFF49 . ?\x0069);; FULLWIDTH LATIN SMALL LETTER I
     (?\xFF4A . ?\x006A);; FULLWIDTH LATIN SMALL LETTER J
     (?\xFF4B . ?\x006B);; FULLWIDTH LATIN SMALL LETTER K
     (?\xFF4C . ?\x006C);; FULLWIDTH LATIN SMALL LETTER L
     (?\xFF4D . ?\x006D);; FULLWIDTH LATIN SMALL LETTER M
     (?\xFF4E . ?\x006E);; FULLWIDTH LATIN SMALL LETTER N
     (?\xFF4F . ?\x006F);; FULLWIDTH LATIN SMALL LETTER O
     (?\xFF50 . ?\x0070);; FULLWIDTH LATIN SMALL LETTER P
     (?\xFF51 . ?\x0071);; FULLWIDTH LATIN SMALL LETTER Q
     (?\xFF52 . ?\x0072);; FULLWIDTH LATIN SMALL LETTER R
     (?\xFF53 . ?\x0073);; FULLWIDTH LATIN SMALL LETTER S
     (?\xFF54 . ?\x0074);; FULLWIDTH LATIN SMALL LETTER T
     (?\xFF55 . ?\x0075);; FULLWIDTH LATIN SMALL LETTER U
     (?\xFF56 . ?\x0076);; FULLWIDTH LATIN SMALL LETTER V
     (?\xFF57 . ?\x0077);; FULLWIDTH LATIN SMALL LETTER W
     (?\xFF58 . ?\x0078);; FULLWIDTH LATIN SMALL LETTER X
     (?\xFF59 . ?\x0079);; FULLWIDTH LATIN SMALL LETTER Y
     (?\xFF5A . ?\x007A);; FULLWIDTH LATIN SMALL LETTER Z
     (?\xFF5B . ?\x007B);; FULLWIDTH LEFT CURLY BRACKET
     (?\xFF5C . ?\x007C);; FULLWIDTH VERTICAL LINE
     (?\xFF5D . ?\x007D);; FULLWIDTH RIGHT CURLY BRACKET
     (?\xFF5E . ?\x007E);; FULLWIDTH TILDE
     (?\xFF61 . ?\x3002);; HALFWIDTH IDEOGRAPHIC FULL STOP
     (?\xFF62 . ?\x300C);; HALFWIDTH LEFT CORNER BRACKET
     (?\xFF63 . ?\x300D);; HALFWIDTH RIGHT CORNER BRACKET
     (?\xFF64 . ?\x3001);; HALFWIDTH IDEOGRAPHIC COMMA
     (?\xFF65 . ?\x30FB);; HALFWIDTH KATAKANA MIDDLE DOT
     (?\xFF66 . ?\x30F2);; HALFWIDTH KATAKANA LETTER WO
     (?\xFF67 . ?\x30A1);; HALFWIDTH KATAKANA LETTER SMALL A
     (?\xFF68 . ?\x30A3);; HALFWIDTH KATAKANA LETTER SMALL I
     (?\xFF69 . ?\x30A5);; HALFWIDTH KATAKANA LETTER SMALL U
     (?\xFF6A . ?\x30A7);; HALFWIDTH KATAKANA LETTER SMALL E
     (?\xFF6B . ?\x30A9);; HALFWIDTH KATAKANA LETTER SMALL O
     (?\xFF6C . ?\x30E3);; HALFWIDTH KATAKANA LETTER SMALL YA
     (?\xFF6D . ?\x30E5);; HALFWIDTH KATAKANA LETTER SMALL YU
     (?\xFF6E . ?\x30E7);; HALFWIDTH KATAKANA LETTER SMALL YO
     (?\xFF6F . ?\x30C3);; HALFWIDTH KATAKANA LETTER SMALL TU
     (?\xFF70 . ?\x30FC);; HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK
     (?\xFF71 . ?\x30A2);; HALFWIDTH KATAKANA LETTER A
     (?\xFF72 . ?\x30A4);; HALFWIDTH KATAKANA LETTER I
     (?\xFF73 . ?\x30A6);; HALFWIDTH KATAKANA LETTER U
     (?\xFF74 . ?\x30A8);; HALFWIDTH KATAKANA LETTER E
     (?\xFF75 . ?\x30AA);; HALFWIDTH KATAKANA LETTER O
     (?\xFF76 . ?\x30AB);; HALFWIDTH KATAKANA LETTER KA
     (?\xFF77 . ?\x30AD);; HALFWIDTH KATAKANA LETTER KI
     (?\xFF78 . ?\x30AF);; HALFWIDTH KATAKANA LETTER KU
     (?\xFF79 . ?\x30B1);; HALFWIDTH KATAKANA LETTER KE
     (?\xFF7A . ?\x30B3);; HALFWIDTH KATAKANA LETTER KO
     (?\xFF7B . ?\x30B5);; HALFWIDTH KATAKANA LETTER SA
     (?\xFF7C . ?\x30B7);; HALFWIDTH KATAKANA LETTER SI
     (?\xFF7D . ?\x30B9);; HALFWIDTH KATAKANA LETTER SU
     (?\xFF7E . ?\x30BB);; HALFWIDTH KATAKANA LETTER SE
     (?\xFF7F . ?\x30BD);; HALFWIDTH KATAKANA LETTER SO
     (?\xFF80 . ?\x30BF);; HALFWIDTH KATAKANA LETTER TA
     (?\xFF81 . ?\x30C1);; HALFWIDTH KATAKANA LETTER TI
     (?\xFF82 . ?\x30C4);; HALFWIDTH KATAKANA LETTER TU
     (?\xFF83 . ?\x30C6);; HALFWIDTH KATAKANA LETTER TE
     (?\xFF84 . ?\x30C8);; HALFWIDTH KATAKANA LETTER TO
     (?\xFF85 . ?\x30CA);; HALFWIDTH KATAKANA LETTER NA
     (?\xFF86 . ?\x30CB);; HALFWIDTH KATAKANA LETTER NI
     (?\xFF87 . ?\x30CC);; HALFWIDTH KATAKANA LETTER NU
     (?\xFF88 . ?\x30CD);; HALFWIDTH KATAKANA LETTER NE
     (?\xFF89 . ?\x30CE);; HALFWIDTH KATAKANA LETTER NO
     (?\xFF8A . ?\x30CF);; HALFWIDTH KATAKANA LETTER HA
     (?\xFF8B . ?\x30D2);; HALFWIDTH KATAKANA LETTER HI
     (?\xFF8C . ?\x30D5);; HALFWIDTH KATAKANA LETTER HU
     (?\xFF8D . ?\x30D8);; HALFWIDTH KATAKANA LETTER HE
     (?\xFF8E . ?\x30DB);; HALFWIDTH KATAKANA LETTER HO
     (?\xFF8F . ?\x30DE);; HALFWIDTH KATAKANA LETTER MA
     (?\xFF90 . ?\x30DF);; HALFWIDTH KATAKANA LETTER MI
     (?\xFF91 . ?\x30E0);; HALFWIDTH KATAKANA LETTER MU
     (?\xFF92 . ?\x30E1);; HALFWIDTH KATAKANA LETTER ME
     (?\xFF93 . ?\x30E2);; HALFWIDTH KATAKANA LETTER MO
     (?\xFF94 . ?\x30E4);; HALFWIDTH KATAKANA LETTER YA
     (?\xFF95 . ?\x30E6);; HALFWIDTH KATAKANA LETTER YU
     (?\xFF96 . ?\x30E8);; HALFWIDTH KATAKANA LETTER YO
     (?\xFF97 . ?\x30E9);; HALFWIDTH KATAKANA LETTER RA
     (?\xFF98 . ?\x30EA);; HALFWIDTH KATAKANA LETTER RI
     (?\xFF99 . ?\x30EB);; HALFWIDTH KATAKANA LETTER RU
     (?\xFF9A . ?\x30EC);; HALFWIDTH KATAKANA LETTER RE
     (?\xFF9B . ?\x30ED);; HALFWIDTH KATAKANA LETTER RO
     (?\xFF9C . ?\x30EF);; HALFWIDTH KATAKANA LETTER WA
     (?\xFF9D . ?\x30F3);; HALFWIDTH KATAKANA LETTER N
     (?\xFF9E . ?\x3099);; HALFWIDTH KATAKANA VOICED SOUND MARK
     (?\xFF9F . ?\x309A);; HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK
     (?\xFFA0 . ?\x3164);; HALFWIDTH HANGUL FILLER
     (?\xFFA1 . ?\x3131);; HALFWIDTH HANGUL LETTER KIYEOK
     (?\xFFA2 . ?\x3132);; HALFWIDTH HANGUL LETTER SSANGKIYEOK
     (?\xFFA3 . ?\x3133);; HALFWIDTH HANGUL LETTER KIYEOK-SIOS
     (?\xFFA4 . ?\x3134);; HALFWIDTH HANGUL LETTER NIEUN
     (?\xFFA5 . ?\x3135);; HALFWIDTH HANGUL LETTER NIEUN-CIEUC
     (?\xFFA6 . ?\x3136);; HALFWIDTH HANGUL LETTER NIEUN-HIEUH
     (?\xFFA7 . ?\x3137);; HALFWIDTH HANGUL LETTER TIKEUT
     (?\xFFA8 . ?\x3138);; HALFWIDTH HANGUL LETTER SSANGTIKEUT
     (?\xFFA9 . ?\x3139);; HALFWIDTH HANGUL LETTER RIEUL
     (?\xFFAA . ?\x313A);; HALFWIDTH HANGUL LETTER RIEUL-KIYEOK
     (?\xFFAB . ?\x313B);; HALFWIDTH HANGUL LETTER RIEUL-MIEUM
     (?\xFFAC . ?\x313C);; HALFWIDTH HANGUL LETTER RIEUL-PIEUP
     (?\xFFAD . ?\x313D);; HALFWIDTH HANGUL LETTER RIEUL-SIOS
     (?\xFFAE . ?\x313E);; HALFWIDTH HANGUL LETTER RIEUL-THIEUTH
     (?\xFFAF . ?\x313F);; HALFWIDTH HANGUL LETTER RIEUL-PHIEUPH
     (?\xFFB0 . ?\x3140);; HALFWIDTH HANGUL LETTER RIEUL-HIEUH
     (?\xFFB1 . ?\x3141);; HALFWIDTH HANGUL LETTER MIEUM
     (?\xFFB2 . ?\x3142);; HALFWIDTH HANGUL LETTER PIEUP
     (?\xFFB3 . ?\x3143);; HALFWIDTH HANGUL LETTER SSANGPIEUP
     (?\xFFB4 . ?\x3144);; HALFWIDTH HANGUL LETTER PIEUP-SIOS
     (?\xFFB5 . ?\x3145);; HALFWIDTH HANGUL LETTER SIOS
     (?\xFFB6 . ?\x3146);; HALFWIDTH HANGUL LETTER SSANGSIOS
     (?\xFFB7 . ?\x3147);; HALFWIDTH HANGUL LETTER IEUNG
     (?\xFFB8 . ?\x3148);; HALFWIDTH HANGUL LETTER CIEUC
     (?\xFFB9 . ?\x3149);; HALFWIDTH HANGUL LETTER SSANGCIEUC
     (?\xFFBA . ?\x314A);; HALFWIDTH HANGUL LETTER CHIEUCH
     (?\xFFBB . ?\x314B);; HALFWIDTH HANGUL LETTER KHIEUKH
     (?\xFFBC . ?\x314C);; HALFWIDTH HANGUL LETTER THIEUTH
     (?\xFFBD . ?\x314D);; HALFWIDTH HANGUL LETTER PHIEUPH
     (?\xFFBE . ?\x314E);; HALFWIDTH HANGUL LETTER HIEUH
     (?\xFFC2 . ?\x314F);; HALFWIDTH HANGUL LETTER A
     (?\xFFC3 . ?\x3150);; HALFWIDTH HANGUL LETTER AE
     (?\xFFC4 . ?\x3151);; HALFWIDTH HANGUL LETTER YA
     (?\xFFC5 . ?\x3152);; HALFWIDTH HANGUL LETTER YAE
     (?\xFFC6 . ?\x3153);; HALFWIDTH HANGUL LETTER EO
     (?\xFFC7 . ?\x3154);; HALFWIDTH HANGUL LETTER E
     (?\xFFCA . ?\x3155);; HALFWIDTH HANGUL LETTER YEO
     (?\xFFCB . ?\x3156);; HALFWIDTH HANGUL LETTER YE
     (?\xFFCC . ?\x3157);; HALFWIDTH HANGUL LETTER O
     (?\xFFCD . ?\x3158);; HALFWIDTH HANGUL LETTER WA
     (?\xFFCE . ?\x3159);; HALFWIDTH HANGUL LETTER WAE
     (?\xFFCF . ?\x315A);; HALFWIDTH HANGUL LETTER OE
     (?\xFFD2 . ?\x315B);; HALFWIDTH HANGUL LETTER YO
     (?\xFFD3 . ?\x315C);; HALFWIDTH HANGUL LETTER U
     (?\xFFD4 . ?\x315D);; HALFWIDTH HANGUL LETTER WEO
     (?\xFFD5 . ?\x315E);; HALFWIDTH HANGUL LETTER WE
     (?\xFFD6 . ?\x315F);; HALFWIDTH HANGUL LETTER WI
     (?\xFFD7 . ?\x3160);; HALFWIDTH HANGUL LETTER YU
     (?\xFFDA . ?\x3161);; HALFWIDTH HANGUL LETTER EU
     (?\xFFDB . ?\x3162);; HALFWIDTH HANGUL LETTER YI
     (?\xFFDC . ?\x3163);; HALFWIDTH HANGUL LETTER I
     (?\xFFE0 . ?\x00A2);; FULLWIDTH CENT SIGN
     (?\xFFE1 . ?\x00A3);; FULLWIDTH POUND SIGN
     (?\xFFE2 . ?\x00AC);; FULLWIDTH NOT SIGN
     (?\xFFE3 . ?\x00AF);; FULLWIDTH MACRON
     (?\xFFE4 . ?\x00A6);; FULLWIDTH BROKEN BAR
     (?\xFFE5 . ?\x00A5);; FULLWIDTH YEN SIGN
     (?\xFFE6 . ?\x20A9);; FULLWIDTH WON SIGN
     (?\xFFE8 . ?\x2502);; HALFWIDTH FORMS LIGHT VERTICAL
     (?\xFFE9 . ?\x2190);; HALFWIDTH LEFTWARDS ARROW
     (?\xFFEA . ?\x2191);; HALFWIDTH UPWARDS ARROW
     (?\xFFEB . ?\x2192);; HALFWIDTH RIGHTWARDS ARROW
     (?\xFFEC . ?\x2193);; HALFWIDTH DOWNWARDS ARROW
     (?\xFFED . ?\x25A0);; HALFWIDTH BLACK SQUARE
     (?\xFFEE . ?\x25CB);; HALFWIDTH WHITE CIRCLE
     (all . identity)) ((not-inverse . t))))

;; translation definitions

(tae-declare-translation
 'unicode-translation-rule-for-jisx0221
 unicode-assoc-for-jisx0221)

(tae-declare-translation
 'unicode-translation-rule-for-jdk
 unicode-assoc-for-jdk)

(tae-declare-translation
 'unicode-translation-rule-for-windows
 unicode-assoc-for-windows)

(tae-declare-translation
 'unicode-translation-rule-for-fullwidth-or-halfwidth-normalization
 unicode-assoc-for-fullwidth-or-halfwidth-normalization)

(provide 'usupple)

;;; usupple ends here.
