;;; -*- byte-compile-dynamic: t;coding: iso-2022-7bit -*-
;;; usupple.el --- tables for various definitions that are
;;;                different from Unicode Consortium's.

;; Copyright (C) 2000 Miyashita Hisashi

;; Keywords: mule, multilingual, 
;;           character set, coding-system, ISO/IEC 10646,
;;           Unicode, JIS X 0221, JDK, Japanese-EUC, Windows.

;; This file is part of Mule-UCS

;; Mule-UCS is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; Mule-UCS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;; (defvar exclude-compatibility-area-unicode-translation-rule nil)

(defvar unicode-assoc-for-jisx0221
  '(assoc
    (char-1 . ucs-generic)
    ((?$B!=(B . ?\x0214) ;; HORIZONTAL BAR
     (?$B!1(B . ?\x203E) ;; OVERLINE
     (?$B!=(B . ?\x2014) ;; EM DASH
     (?$B!@(B . ?\xFF3C) ;; FULLWIDTH REVERSE SOLIDUS
     (?$B!o(B . ?\x00A5) ;; YEN SIGN
     (?$(D"7(B . ?\xFFE5) ;; FULLWIDTH TILDE
     )))

(defvar unicode-assoc-for-jdk
  `(assoc
    (char-1 . ucs-generic)
    ((,(make-char 'ascii ?\x5C) . ?\x005C) ;; REVERSE SOLIDUS
     (,(make-char 'ascii ?\x5C) . ?\x00A5) ;; YEN SIGN(ignored at encoding time)
     (,(make-char 'ascii ?\x7E) . ?\x007E) ;; TILDE
     (,(make-char 'ascii ?\x7E) . ?\x203E) ;; OVERLINE(ignored at encoding time)
     (?$B!@(B . ?\xFF3C) ;; FULLWIDTH REVERSE SOLIDUS
     )))

(defvar unicode-assoc-for-windows
  `(assoc
    (char-1 . ucs-generic)
    (;; JIS X 0208 correspondings
     (?$B!@(B . ?\xFF3C) ;; FULLWIDTH REVERSE SOLIDUS
     (?$B!A(B . ?\xFF5E) ;; FULLWIDTH TILDE
     (?$B!B(B . ?\x2225) ;; PARALLEL TO
     (?$B!](B . ?\xFF0D) ;; FULLWIDTH HYPHENMINUS
     (?$B!q(B . ?\xFFE0) ;; FULLWIDTH CENT SIGN
     (?$B!r(B . ?\xFFE1) ;; FULLWIDTH POUND SIGN
     (?$B"L(B . ?\xFFE2) ;; FULLWIDTH NOT SIGN
     ;; JIS X 0212 correspondings
     (?$(D"7(B . ?\xFF5E) ;; FULLWIDTH TILDE (usually not used for decoding)
     (?$(D"C(B . ?\xFF4E) ;; FULLWIDTH BROKEN BAR
     ;; JIS X 0201 correspondings
     ;; (,(make-char 'latin-jisx0201 ?\x5C) . ?\x005C) ;; REVERSE SOLIDUS
     ;; (,(make-char 'latin-jisx0201 ?\x7E) . ?\x007E) ;; TILDE
     )))

;; translation definitions

(tae-declare-translation
 'unicode-translation-rule-for-jisx0221
 unicode-assoc-for-jisx0221)

(tae-declare-translation
 'unicode-translation-rule-for-jdk
 unicode-assoc-for-jdk)

(tae-declare-translation
 'unicode-translation-rule-for-windows
 unicode-assoc-for-windows)

(provide 'usupple)

;;; usupple ends here.
