;;; -*- coding: iso-2022-7bit  -*-
;;; uiso8859-6.el --- tables between UCS and ISO-8859-6

;; Keywords: CCL, mule, multilingual, 
;;           character set, coding-system, ISO10646, Unicode, ISO8859

;; This file is part of Mule-UCS

;; Mule-UCS is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; Mule-UCS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; This file is converted from 8859-6.TXT of Unicode consortium
;;; by Miyashita Hisashi <himi@bird.scphys.kyoto-u.ac.jp>.

(put 'arabic-iso8859-6 'unicode-assoc
     'iso-8859-6-vs-unicode-assoc)

(defvar
  iso-8859-6-vs-unicode-assoc
  '(assoc
    (char-1 . ucs-generic)
    ((?,G (B . ?\x00A0) ;; NO-BREAK SPACE
     (?,G$(B . ?\x00A4) ;; CURRENCY SIGN
     (?,G,(B . ?\x060C) ;; ARABIC COMMA
     (?,G-(B . ?\x00AD) ;; SOFT HYPHEN
     (?,G;(B . ?\x061B) ;; ARABIC SEMICOLON
     (?,G?(B . ?\x061F) ;; ARABIC QUESTION MARK
     (?,GA(B . ?\x0621) ;; ARABIC LETTER HAMZA
     (?,GB(B . ?\x0622) ;; ARABIC LETTER ALEF WITH MADDA ABOVE
     (?,GC(B . ?\x0623) ;; ARABIC LETTER ALEF WITH HAMZA ABOVE
     (?,GD(B . ?\x0624) ;; ARABIC LETTER WAW WITH HAMZA ABOVE
     (?,GE(B . ?\x0625) ;; ARABIC LETTER ALEF WITH HAMZA BELOW
     (?,GF(B . ?\x0626) ;; ARABIC LETTER YEH WITH HAMZA ABOVE
     (?,GG(B . ?\x0627) ;; ARABIC LETTER ALEF
     (?,GH(B . ?\x0628) ;; ARABIC LETTER BEH
     (?,GI(B . ?\x0629) ;; ARABIC LETTER TEH MARBUTA
     (?,GJ(B . ?\x062A) ;; ARABIC LETTER TEH
     (?,GK(B . ?\x062B) ;; ARABIC LETTER THEH
     (?,GL(B . ?\x062C) ;; ARABIC LETTER JEEM
     (?,GM(B . ?\x062D) ;; ARABIC LETTER HAH
     (?,GN(B . ?\x062E) ;; ARABIC LETTER KHAH
     (?,GO(B . ?\x062F) ;; ARABIC LETTER DAL
     (?,GP(B . ?\x0630) ;; ARABIC LETTER THAL
     (?,GQ(B . ?\x0631) ;; ARABIC LETTER REH
     (?,GR(B . ?\x0632) ;; ARABIC LETTER ZAIN
     (?,GS(B . ?\x0633) ;; ARABIC LETTER SEEN
     (?,GT(B . ?\x0634) ;; ARABIC LETTER SHEEN
     (?,GU(B . ?\x0635) ;; ARABIC LETTER SAD
     (?,GV(B . ?\x0636) ;; ARABIC LETTER DAD
     (?,GW(B . ?\x0637) ;; ARABIC LETTER TAH
     (?,GX(B . ?\x0638) ;; ARABIC LETTER ZAH
     (?,GY(B . ?\x0639) ;; ARABIC LETTER AIN
     (?,GZ(B . ?\x063A) ;; ARABIC LETTER GHAIN
     (?,G`(B . ?\x0640) ;; ARABIC TATWEEL
     (?,Ga(B . ?\x0641) ;; ARABIC LETTER FEH
     (?,Gb(B . ?\x0642) ;; ARABIC LETTER QAF
     (?,Gc(B . ?\x0643) ;; ARABIC LETTER KAF
     (?,Gd(B . ?\x0644) ;; ARABIC LETTER LAM
     (?,Ge(B . ?\x0645) ;; ARABIC LETTER MEEM
     (?,Gf(B . ?\x0646) ;; ARABIC LETTER NOON
     (?,Gg(B . ?\x0647) ;; ARABIC LETTER HEH
     (?,Gh(B . ?\x0648) ;; ARABIC LETTER WAW
     (?,Gi(B . ?\x0649) ;; ARABIC LETTER ALEF MAKSURA
     (?,Gj(B . ?\x064A) ;; ARABIC LETTER YEH
     (?,Gk(B . ?\x064B) ;; ARABIC FATHATAN
     (?,Gl(B . ?\x064C) ;; ARABIC DAMMATAN
     (?,Gm(B . ?\x064D) ;; ARABIC KASRATAN
     (?,Gn(B . ?\x064E) ;; ARABIC FATHA
     (?,Go(B . ?\x064F) ;; ARABIC DAMMA
     (?,Gp(B . ?\x0650) ;; ARABIC KASRA
     (?,Gq(B . ?\x0651) ;; ARABIC SHADDA
     (?,Gr(B . ?\x0652) ;; ARABIC SUKUN
     )))

(provide 'uiso8859-6)
