;;; -*- coding: iso-2022-7bit  -*-
;;; uethiopic.el --- tables between Unicode and Mule ethiopic charset

;; Keywords: CCL, mule, multilingual, 
;;           character set, coding-system, ISO10646, Unicode, ethiopic

;; Miyashita Hisashi(himi@bird.scphys.kyoto-u.ac.jp)
;; generated this table by converting UNIDATA of Unicode consortium.

;; This file is part of Mule-UCS

;; Mule-UCS is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; Mule-UCS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;; Comment:
;; this file is converted from UNIDATA by the following dirty code.
; (defun foo ()
;   (let* ((filename "....")
; 	 (buf (generate-new-buffer
; 	       (format "*%s-tbl-translate*" filename)))
; 	 table)
;     (switch-to-buffer buf)
;     (insert-file-contents filename)
;     (setq table (make-table-alist-region
; 		 (point-min)
; 		 (point-max)
; 		 '("\\([0-9a-fA-F]+\\);" . hex-string-to-number)
; 		 '("\\([0-9a-fA-F]+\\);" . hex-string-to-number)
; 		 ".+;.+;\\(.*\\)$"
; 		 "^[0-9A-Fa-f]"))
;     (erase-buffer)
;     (mucs-print-character-a-list
;      table 1 (lambda (ch)
; 	       (setq ch (- ch ?\x1200))
; 	       (make-char 'ethiopic
; 			  (+ (/ ch 94) 33)
; 			  (+ (% ch 94) 33))))))

(put 'ethiopic 'unicode-assoc
     'ethiopic-vs-unicode-assoc)

(defvar
  ethiopic-vs-unicode-assoc
  '(assoc
    (char-1 . ucs-generic)
    ((?$(3!!(B . ?\x1200) ;; ETHIOPIC SYLLABLE HA
     (?$(3!"(B . ?\x1201) ;; ETHIOPIC SYLLABLE HU
     (?$(3!#(B . ?\x1202) ;; ETHIOPIC SYLLABLE HI
     (?$(3!$(B . ?\x1203) ;; ETHIOPIC SYLLABLE HAA
     (?$(3!%(B . ?\x1204) ;; ETHIOPIC SYLLABLE HEE
     (?$(3!&(B . ?\x1205) ;; ETHIOPIC SYLLABLE HE
     (?$(3!'(B . ?\x1206) ;; ETHIOPIC SYLLABLE HO
     (?$(3!)(B . ?\x1208) ;; ETHIOPIC SYLLABLE LA
     (?$(3!*(B . ?\x1209) ;; ETHIOPIC SYLLABLE LU
     (?$(3!+(B . ?\x120A) ;; ETHIOPIC SYLLABLE LI
     (?$(3!,(B . ?\x120B) ;; ETHIOPIC SYLLABLE LAA
     (?$(3!-(B . ?\x120C) ;; ETHIOPIC SYLLABLE LEE
     (?$(3!.(B . ?\x120D) ;; ETHIOPIC SYLLABLE LE
     (?$(3!/(B . ?\x120E) ;; ETHIOPIC SYLLABLE LO
     (?$(3!0(B . ?\x120F) ;; ETHIOPIC SYLLABLE LWA
     (?$(3!1(B . ?\x1210) ;; ETHIOPIC SYLLABLE HHA
     (?$(3!2(B . ?\x1211) ;; ETHIOPIC SYLLABLE HHU
     (?$(3!3(B . ?\x1212) ;; ETHIOPIC SYLLABLE HHI
     (?$(3!4(B . ?\x1213) ;; ETHIOPIC SYLLABLE HHAA
     (?$(3!5(B . ?\x1214) ;; ETHIOPIC SYLLABLE HHEE
     (?$(3!6(B . ?\x1215) ;; ETHIOPIC SYLLABLE HHE
     (?$(3!7(B . ?\x1216) ;; ETHIOPIC SYLLABLE HHO
     (?$(3!8(B . ?\x1217) ;; ETHIOPIC SYLLABLE HHWA
     (?$(3!9(B . ?\x1218) ;; ETHIOPIC SYLLABLE MA
     (?$(3!:(B . ?\x1219) ;; ETHIOPIC SYLLABLE MU
     (?$(3!;(B . ?\x121A) ;; ETHIOPIC SYLLABLE MI
     (?$(3!<(B . ?\x121B) ;; ETHIOPIC SYLLABLE MAA
     (?$(3!=(B . ?\x121C) ;; ETHIOPIC SYLLABLE MEE
     (?$(3!>(B . ?\x121D) ;; ETHIOPIC SYLLABLE ME
     (?$(3!?(B . ?\x121E) ;; ETHIOPIC SYLLABLE MO
     (?$(3!@(B . ?\x121F) ;; ETHIOPIC SYLLABLE MWA
     (?$(3!A(B . ?\x1220) ;; ETHIOPIC SYLLABLE SZA
     (?$(3!B(B . ?\x1221) ;; ETHIOPIC SYLLABLE SZU
     (?$(3!C(B . ?\x1222) ;; ETHIOPIC SYLLABLE SZI
     (?$(3!D(B . ?\x1223) ;; ETHIOPIC SYLLABLE SZAA
     (?$(3!E(B . ?\x1224) ;; ETHIOPIC SYLLABLE SZEE
     (?$(3!F(B . ?\x1225) ;; ETHIOPIC SYLLABLE SZE
     (?$(3!G(B . ?\x1226) ;; ETHIOPIC SYLLABLE SZO
     (?$(3!H(B . ?\x1227) ;; ETHIOPIC SYLLABLE SZWA
     (?$(3!I(B . ?\x1228) ;; ETHIOPIC SYLLABLE RA
     (?$(3!J(B . ?\x1229) ;; ETHIOPIC SYLLABLE RU
     (?$(3!K(B . ?\x122A) ;; ETHIOPIC SYLLABLE RI
     (?$(3!L(B . ?\x122B) ;; ETHIOPIC SYLLABLE RAA
     (?$(3!M(B . ?\x122C) ;; ETHIOPIC SYLLABLE REE
     (?$(3!N(B . ?\x122D) ;; ETHIOPIC SYLLABLE RE
     (?$(3!O(B . ?\x122E) ;; ETHIOPIC SYLLABLE RO
     (?$(3!P(B . ?\x122F) ;; ETHIOPIC SYLLABLE RWA
     (?$(3!Q(B . ?\x1230) ;; ETHIOPIC SYLLABLE SA
     (?$(3!R(B . ?\x1231) ;; ETHIOPIC SYLLABLE SU
     (?$(3!S(B . ?\x1232) ;; ETHIOPIC SYLLABLE SI
     (?$(3!T(B . ?\x1233) ;; ETHIOPIC SYLLABLE SAA
     (?$(3!U(B . ?\x1234) ;; ETHIOPIC SYLLABLE SEE
     (?$(3!V(B . ?\x1235) ;; ETHIOPIC SYLLABLE SE
     (?$(3!W(B . ?\x1236) ;; ETHIOPIC SYLLABLE SO
     (?$(3!X(B . ?\x1237) ;; ETHIOPIC SYLLABLE SWA
     (?$(3!Y(B . ?\x1238) ;; ETHIOPIC SYLLABLE SHA
     (?$(3!Z(B . ?\x1239) ;; ETHIOPIC SYLLABLE SHU
     (?$(3![(B . ?\x123A) ;; ETHIOPIC SYLLABLE SHI
     (?$(3!\(B . ?\x123B) ;; ETHIOPIC SYLLABLE SHAA
     (?$(3!](B . ?\x123C) ;; ETHIOPIC SYLLABLE SHEE
     (?$(3!^(B . ?\x123D) ;; ETHIOPIC SYLLABLE SHE
     (?$(3!_(B . ?\x123E) ;; ETHIOPIC SYLLABLE SHO
     (?$(3!`(B . ?\x123F) ;; ETHIOPIC SYLLABLE SHWA
     (?$(3!a(B . ?\x1240) ;; ETHIOPIC SYLLABLE QA
     (?$(3!b(B . ?\x1241) ;; ETHIOPIC SYLLABLE QU
     (?$(3!c(B . ?\x1242) ;; ETHIOPIC SYLLABLE QI
     (?$(3!d(B . ?\x1243) ;; ETHIOPIC SYLLABLE QAA
     (?$(3!e(B . ?\x1244) ;; ETHIOPIC SYLLABLE QEE
     (?$(3!f(B . ?\x1245) ;; ETHIOPIC SYLLABLE QE
     (?$(3!g(B . ?\x1246) ;; ETHIOPIC SYLLABLE QO
     (?$(3!i(B . ?\x1248) ;; ETHIOPIC SYLLABLE QWA
     (?$(3!k(B . ?\x124A) ;; ETHIOPIC SYLLABLE QWI
     (?$(3!l(B . ?\x124B) ;; ETHIOPIC SYLLABLE QWAA
     (?$(3!m(B . ?\x124C) ;; ETHIOPIC SYLLABLE QWEE
     (?$(3!n(B . ?\x124D) ;; ETHIOPIC SYLLABLE QWE
     (?$(3!q(B . ?\x1250) ;; ETHIOPIC SYLLABLE QHA
     (?$(3!r(B . ?\x1251) ;; ETHIOPIC SYLLABLE QHU
     (?$(3!s(B . ?\x1252) ;; ETHIOPIC SYLLABLE QHI
     (?$(3!t(B . ?\x1253) ;; ETHIOPIC SYLLABLE QHAA
     (?$(3!u(B . ?\x1254) ;; ETHIOPIC SYLLABLE QHEE
     (?$(3!v(B . ?\x1255) ;; ETHIOPIC SYLLABLE QHE
     (?$(3!w(B . ?\x1256) ;; ETHIOPIC SYLLABLE QHO
     (?$(3!y(B . ?\x1258) ;; ETHIOPIC SYLLABLE QHWA
     (?$(3!{(B . ?\x125A) ;; ETHIOPIC SYLLABLE QHWI
     (?$(3!|(B . ?\x125B) ;; ETHIOPIC SYLLABLE QHWAA
     (?$(3!}(B . ?\x125C) ;; ETHIOPIC SYLLABLE QHWEE
     (?$(3!~(B . ?\x125D) ;; ETHIOPIC SYLLABLE QHWE
     (?$(3"#(B . ?\x1260) ;; ETHIOPIC SYLLABLE BA
     (?$(3"$(B . ?\x1261) ;; ETHIOPIC SYLLABLE BU
     (?$(3"%(B . ?\x1262) ;; ETHIOPIC SYLLABLE BI
     (?$(3"&(B . ?\x1263) ;; ETHIOPIC SYLLABLE BAA
     (?$(3"'(B . ?\x1264) ;; ETHIOPIC SYLLABLE BEE
     (?$(3"((B . ?\x1265) ;; ETHIOPIC SYLLABLE BE
     (?$(3")(B . ?\x1266) ;; ETHIOPIC SYLLABLE BO
     (?$(3"*(B . ?\x1267) ;; ETHIOPIC SYLLABLE BWA
     (?$(3"+(B . ?\x1268) ;; ETHIOPIC SYLLABLE VA
     (?$(3",(B . ?\x1269) ;; ETHIOPIC SYLLABLE VU
     (?$(3"-(B . ?\x126A) ;; ETHIOPIC SYLLABLE VI
     (?$(3".(B . ?\x126B) ;; ETHIOPIC SYLLABLE VAA
     (?$(3"/(B . ?\x126C) ;; ETHIOPIC SYLLABLE VEE
     (?$(3"0(B . ?\x126D) ;; ETHIOPIC SYLLABLE VE
     (?$(3"1(B . ?\x126E) ;; ETHIOPIC SYLLABLE VO
     (?$(3"2(B . ?\x126F) ;; ETHIOPIC SYLLABLE VWA
     (?$(3"3(B . ?\x1270) ;; ETHIOPIC SYLLABLE TA
     (?$(3"4(B . ?\x1271) ;; ETHIOPIC SYLLABLE TU
     (?$(3"5(B . ?\x1272) ;; ETHIOPIC SYLLABLE TI
     (?$(3"6(B . ?\x1273) ;; ETHIOPIC SYLLABLE TAA
     (?$(3"7(B . ?\x1274) ;; ETHIOPIC SYLLABLE TEE
     (?$(3"8(B . ?\x1275) ;; ETHIOPIC SYLLABLE TE
     (?$(3"9(B . ?\x1276) ;; ETHIOPIC SYLLABLE TO
     (?$(3":(B . ?\x1277) ;; ETHIOPIC SYLLABLE TWA
     (?$(3";(B . ?\x1278) ;; ETHIOPIC SYLLABLE CA
     (?$(3"<(B . ?\x1279) ;; ETHIOPIC SYLLABLE CU
     (?$(3"=(B . ?\x127A) ;; ETHIOPIC SYLLABLE CI
     (?$(3">(B . ?\x127B) ;; ETHIOPIC SYLLABLE CAA
     (?$(3"?(B . ?\x127C) ;; ETHIOPIC SYLLABLE CEE
     (?$(3"@(B . ?\x127D) ;; ETHIOPIC SYLLABLE CE
     (?$(3"A(B . ?\x127E) ;; ETHIOPIC SYLLABLE CO
     (?$(3"B(B . ?\x127F) ;; ETHIOPIC SYLLABLE CWA
     (?$(3"C(B . ?\x1280) ;; ETHIOPIC SYLLABLE XA
     (?$(3"D(B . ?\x1281) ;; ETHIOPIC SYLLABLE XU
     (?$(3"E(B . ?\x1282) ;; ETHIOPIC SYLLABLE XI
     (?$(3"F(B . ?\x1283) ;; ETHIOPIC SYLLABLE XAA
     (?$(3"G(B . ?\x1284) ;; ETHIOPIC SYLLABLE XEE
     (?$(3"H(B . ?\x1285) ;; ETHIOPIC SYLLABLE XE
     (?$(3"I(B . ?\x1286) ;; ETHIOPIC SYLLABLE XO
     (?$(3"K(B . ?\x1288) ;; ETHIOPIC SYLLABLE XWA
     (?$(3"M(B . ?\x128A) ;; ETHIOPIC SYLLABLE XWI
     (?$(3"N(B . ?\x128B) ;; ETHIOPIC SYLLABLE XWAA
     (?$(3"O(B . ?\x128C) ;; ETHIOPIC SYLLABLE XWEE
     (?$(3"P(B . ?\x128D) ;; ETHIOPIC SYLLABLE XWE
     (?$(3"S(B . ?\x1290) ;; ETHIOPIC SYLLABLE NA
     (?$(3"T(B . ?\x1291) ;; ETHIOPIC SYLLABLE NU
     (?$(3"U(B . ?\x1292) ;; ETHIOPIC SYLLABLE NI
     (?$(3"V(B . ?\x1293) ;; ETHIOPIC SYLLABLE NAA
     (?$(3"W(B . ?\x1294) ;; ETHIOPIC SYLLABLE NEE
     (?$(3"X(B . ?\x1295) ;; ETHIOPIC SYLLABLE NE
     (?$(3"Y(B . ?\x1296) ;; ETHIOPIC SYLLABLE NO
     (?$(3"Z(B . ?\x1297) ;; ETHIOPIC SYLLABLE NWA
     (?$(3"[(B . ?\x1298) ;; ETHIOPIC SYLLABLE NYA
     (?$(3"\(B . ?\x1299) ;; ETHIOPIC SYLLABLE NYU
     (?$(3"](B . ?\x129A) ;; ETHIOPIC SYLLABLE NYI
     (?$(3"^(B . ?\x129B) ;; ETHIOPIC SYLLABLE NYAA
     (?$(3"_(B . ?\x129C) ;; ETHIOPIC SYLLABLE NYEE
     (?$(3"`(B . ?\x129D) ;; ETHIOPIC SYLLABLE NYE
     (?$(3"a(B . ?\x129E) ;; ETHIOPIC SYLLABLE NYO
     (?$(3"b(B . ?\x129F) ;; ETHIOPIC SYLLABLE NYWA
     (?$(3"c(B . ?\x12A0) ;; ETHIOPIC SYLLABLE GLOTTAL A
     (?$(3"d(B . ?\x12A1) ;; ETHIOPIC SYLLABLE GLOTTAL U
     (?$(3"e(B . ?\x12A2) ;; ETHIOPIC SYLLABLE GLOTTAL I
     (?$(3"f(B . ?\x12A3) ;; ETHIOPIC SYLLABLE GLOTTAL AA
     (?$(3"g(B . ?\x12A4) ;; ETHIOPIC SYLLABLE GLOTTAL EE
     (?$(3"h(B . ?\x12A5) ;; ETHIOPIC SYLLABLE GLOTTAL E
     (?$(3"i(B . ?\x12A6) ;; ETHIOPIC SYLLABLE GLOTTAL O
     (?$(3"j(B . ?\x12A7) ;; ETHIOPIC SYLLABLE GLOTTAL WA
     (?$(3"k(B . ?\x12A8) ;; ETHIOPIC SYLLABLE KA
     (?$(3"l(B . ?\x12A9) ;; ETHIOPIC SYLLABLE KU
     (?$(3"m(B . ?\x12AA) ;; ETHIOPIC SYLLABLE KI
     (?$(3"n(B . ?\x12AB) ;; ETHIOPIC SYLLABLE KAA
     (?$(3"o(B . ?\x12AC) ;; ETHIOPIC SYLLABLE KEE
     (?$(3"p(B . ?\x12AD) ;; ETHIOPIC SYLLABLE KE
     (?$(3"q(B . ?\x12AE) ;; ETHIOPIC SYLLABLE KO
     (?$(3"s(B . ?\x12B0) ;; ETHIOPIC SYLLABLE KWA
     (?$(3"u(B . ?\x12B2) ;; ETHIOPIC SYLLABLE KWI
     (?$(3"v(B . ?\x12B3) ;; ETHIOPIC SYLLABLE KWAA
     (?$(3"w(B . ?\x12B4) ;; ETHIOPIC SYLLABLE KWEE
     (?$(3"x(B . ?\x12B5) ;; ETHIOPIC SYLLABLE KWE
     (?$(3"{(B . ?\x12B8) ;; ETHIOPIC SYLLABLE KXA
     (?$(3"|(B . ?\x12B9) ;; ETHIOPIC SYLLABLE KXU
     (?$(3"}(B . ?\x12BA) ;; ETHIOPIC SYLLABLE KXI
     (?$(3"~(B . ?\x12BB) ;; ETHIOPIC SYLLABLE KXAA
     (?$(3#!(B . ?\x12BC) ;; ETHIOPIC SYLLABLE KXEE
     (?$(3#"(B . ?\x12BD) ;; ETHIOPIC SYLLABLE KXE
     (?$(3##(B . ?\x12BE) ;; ETHIOPIC SYLLABLE KXO
     (?$(3#%(B . ?\x12C0) ;; ETHIOPIC SYLLABLE KXWA
     (?$(3#'(B . ?\x12C2) ;; ETHIOPIC SYLLABLE KXWI
     (?$(3#((B . ?\x12C3) ;; ETHIOPIC SYLLABLE KXWAA
     (?$(3#)(B . ?\x12C4) ;; ETHIOPIC SYLLABLE KXWEE
     (?$(3#*(B . ?\x12C5) ;; ETHIOPIC SYLLABLE KXWE
     (?$(3#-(B . ?\x12C8) ;; ETHIOPIC SYLLABLE WA
     (?$(3#.(B . ?\x12C9) ;; ETHIOPIC SYLLABLE WU
     (?$(3#/(B . ?\x12CA) ;; ETHIOPIC SYLLABLE WI
     (?$(3#0(B . ?\x12CB) ;; ETHIOPIC SYLLABLE WAA
     (?$(3#1(B . ?\x12CC) ;; ETHIOPIC SYLLABLE WEE
     (?$(3#2(B . ?\x12CD) ;; ETHIOPIC SYLLABLE WE
     (?$(3#3(B . ?\x12CE) ;; ETHIOPIC SYLLABLE WO
     (?$(3#5(B . ?\x12D0) ;; ETHIOPIC SYLLABLE PHARYNGEAL A
     (?$(3#6(B . ?\x12D1) ;; ETHIOPIC SYLLABLE PHARYNGEAL U
     (?$(3#7(B . ?\x12D2) ;; ETHIOPIC SYLLABLE PHARYNGEAL I
     (?$(3#8(B . ?\x12D3) ;; ETHIOPIC SYLLABLE PHARYNGEAL AA
     (?$(3#9(B . ?\x12D4) ;; ETHIOPIC SYLLABLE PHARYNGEAL EE
     (?$(3#:(B . ?\x12D5) ;; ETHIOPIC SYLLABLE PHARYNGEAL E
     (?$(3#;(B . ?\x12D6) ;; ETHIOPIC SYLLABLE PHARYNGEAL O
     (?$(3#=(B . ?\x12D8) ;; ETHIOPIC SYLLABLE ZA
     (?$(3#>(B . ?\x12D9) ;; ETHIOPIC SYLLABLE ZU
     (?$(3#?(B . ?\x12DA) ;; ETHIOPIC SYLLABLE ZI
     (?$(3#@(B . ?\x12DB) ;; ETHIOPIC SYLLABLE ZAA
     (?$(3#A(B . ?\x12DC) ;; ETHIOPIC SYLLABLE ZEE
     (?$(3#B(B . ?\x12DD) ;; ETHIOPIC SYLLABLE ZE
     (?$(3#C(B . ?\x12DE) ;; ETHIOPIC SYLLABLE ZO
     (?$(3#D(B . ?\x12DF) ;; ETHIOPIC SYLLABLE ZWA
     (?$(3#E(B . ?\x12E0) ;; ETHIOPIC SYLLABLE ZHA
     (?$(3#F(B . ?\x12E1) ;; ETHIOPIC SYLLABLE ZHU
     (?$(3#G(B . ?\x12E2) ;; ETHIOPIC SYLLABLE ZHI
     (?$(3#H(B . ?\x12E3) ;; ETHIOPIC SYLLABLE ZHAA
     (?$(3#I(B . ?\x12E4) ;; ETHIOPIC SYLLABLE ZHEE
     (?$(3#J(B . ?\x12E5) ;; ETHIOPIC SYLLABLE ZHE
     (?$(3#K(B . ?\x12E6) ;; ETHIOPIC SYLLABLE ZHO
     (?$(3#L(B . ?\x12E7) ;; ETHIOPIC SYLLABLE ZHWA
     (?$(3#M(B . ?\x12E8) ;; ETHIOPIC SYLLABLE YA
     (?$(3#N(B . ?\x12E9) ;; ETHIOPIC SYLLABLE YU
     (?$(3#O(B . ?\x12EA) ;; ETHIOPIC SYLLABLE YI
     (?$(3#P(B . ?\x12EB) ;; ETHIOPIC SYLLABLE YAA
     (?$(3#Q(B . ?\x12EC) ;; ETHIOPIC SYLLABLE YEE
     (?$(3#R(B . ?\x12ED) ;; ETHIOPIC SYLLABLE YE
     (?$(3#S(B . ?\x12EE) ;; ETHIOPIC SYLLABLE YO
     (?$(3#U(B . ?\x12F0) ;; ETHIOPIC SYLLABLE DA
     (?$(3#V(B . ?\x12F1) ;; ETHIOPIC SYLLABLE DU
     (?$(3#W(B . ?\x12F2) ;; ETHIOPIC SYLLABLE DI
     (?$(3#X(B . ?\x12F3) ;; ETHIOPIC SYLLABLE DAA
     (?$(3#Y(B . ?\x12F4) ;; ETHIOPIC SYLLABLE DEE
     (?$(3#Z(B . ?\x12F5) ;; ETHIOPIC SYLLABLE DE
     (?$(3#[(B . ?\x12F6) ;; ETHIOPIC SYLLABLE DO
     (?$(3#\(B . ?\x12F7) ;; ETHIOPIC SYLLABLE DWA
     (?$(3#](B . ?\x12F8) ;; ETHIOPIC SYLLABLE DDA
     (?$(3#^(B . ?\x12F9) ;; ETHIOPIC SYLLABLE DDU
     (?$(3#_(B . ?\x12FA) ;; ETHIOPIC SYLLABLE DDI
     (?$(3#`(B . ?\x12FB) ;; ETHIOPIC SYLLABLE DDAA
     (?$(3#a(B . ?\x12FC) ;; ETHIOPIC SYLLABLE DDEE
     (?$(3#b(B . ?\x12FD) ;; ETHIOPIC SYLLABLE DDE
     (?$(3#c(B . ?\x12FE) ;; ETHIOPIC SYLLABLE DDO
     (?$(3#d(B . ?\x12FF) ;; ETHIOPIC SYLLABLE DDWA
     (?$(3#e(B . ?\x1300) ;; ETHIOPIC SYLLABLE JA
     (?$(3#f(B . ?\x1301) ;; ETHIOPIC SYLLABLE JU
     (?$(3#g(B . ?\x1302) ;; ETHIOPIC SYLLABLE JI
     (?$(3#h(B . ?\x1303) ;; ETHIOPIC SYLLABLE JAA
     (?$(3#i(B . ?\x1304) ;; ETHIOPIC SYLLABLE JEE
     (?$(3#j(B . ?\x1305) ;; ETHIOPIC SYLLABLE JE
     (?$(3#k(B . ?\x1306) ;; ETHIOPIC SYLLABLE JO
     (?$(3#l(B . ?\x1307) ;; ETHIOPIC SYLLABLE JWA
     (?$(3#m(B . ?\x1308) ;; ETHIOPIC SYLLABLE GA
     (?$(3#n(B . ?\x1309) ;; ETHIOPIC SYLLABLE GU
     (?$(3#o(B . ?\x130A) ;; ETHIOPIC SYLLABLE GI
     (?$(3#p(B . ?\x130B) ;; ETHIOPIC SYLLABLE GAA
     (?$(3#q(B . ?\x130C) ;; ETHIOPIC SYLLABLE GEE
     (?$(3#r(B . ?\x130D) ;; ETHIOPIC SYLLABLE GE
     (?$(3#s(B . ?\x130E) ;; ETHIOPIC SYLLABLE GO
     (?$(3#u(B . ?\x1310) ;; ETHIOPIC SYLLABLE GWA
     (?$(3#w(B . ?\x1312) ;; ETHIOPIC SYLLABLE GWI
     (?$(3#x(B . ?\x1313) ;; ETHIOPIC SYLLABLE GWAA
     (?$(3#y(B . ?\x1314) ;; ETHIOPIC SYLLABLE GWEE
     (?$(3#z(B . ?\x1315) ;; ETHIOPIC SYLLABLE GWE
     (?$(3#}(B . ?\x1318) ;; ETHIOPIC SYLLABLE GGA
     (?$(3#~(B . ?\x1319) ;; ETHIOPIC SYLLABLE GGU
     (?$(3$!(B . ?\x131A) ;; ETHIOPIC SYLLABLE GGI
     (?$(3$"(B . ?\x131B) ;; ETHIOPIC SYLLABLE GGAA
     (?$(3$#(B . ?\x131C) ;; ETHIOPIC SYLLABLE GGEE
     (?$(3$$(B . ?\x131D) ;; ETHIOPIC SYLLABLE GGE
     (?$(3$%(B . ?\x131E) ;; ETHIOPIC SYLLABLE GGO
     (?$(3$'(B . ?\x1320) ;; ETHIOPIC SYLLABLE THA
     (?$(3$((B . ?\x1321) ;; ETHIOPIC SYLLABLE THU
     (?$(3$)(B . ?\x1322) ;; ETHIOPIC SYLLABLE THI
     (?$(3$*(B . ?\x1323) ;; ETHIOPIC SYLLABLE THAA
     (?$(3$+(B . ?\x1324) ;; ETHIOPIC SYLLABLE THEE
     (?$(3$,(B . ?\x1325) ;; ETHIOPIC SYLLABLE THE
     (?$(3$-(B . ?\x1326) ;; ETHIOPIC SYLLABLE THO
     (?$(3$.(B . ?\x1327) ;; ETHIOPIC SYLLABLE THWA
     (?$(3$/(B . ?\x1328) ;; ETHIOPIC SYLLABLE CHA
     (?$(3$0(B . ?\x1329) ;; ETHIOPIC SYLLABLE CHU
     (?$(3$1(B . ?\x132A) ;; ETHIOPIC SYLLABLE CHI
     (?$(3$2(B . ?\x132B) ;; ETHIOPIC SYLLABLE CHAA
     (?$(3$3(B . ?\x132C) ;; ETHIOPIC SYLLABLE CHEE
     (?$(3$4(B . ?\x132D) ;; ETHIOPIC SYLLABLE CHE
     (?$(3$5(B . ?\x132E) ;; ETHIOPIC SYLLABLE CHO
     (?$(3$6(B . ?\x132F) ;; ETHIOPIC SYLLABLE CHWA
     (?$(3$7(B . ?\x1330) ;; ETHIOPIC SYLLABLE PHA
     (?$(3$8(B . ?\x1331) ;; ETHIOPIC SYLLABLE PHU
     (?$(3$9(B . ?\x1332) ;; ETHIOPIC SYLLABLE PHI
     (?$(3$:(B . ?\x1333) ;; ETHIOPIC SYLLABLE PHAA
     (?$(3$;(B . ?\x1334) ;; ETHIOPIC SYLLABLE PHEE
     (?$(3$<(B . ?\x1335) ;; ETHIOPIC SYLLABLE PHE
     (?$(3$=(B . ?\x1336) ;; ETHIOPIC SYLLABLE PHO
     (?$(3$>(B . ?\x1337) ;; ETHIOPIC SYLLABLE PHWA
     (?$(3$?(B . ?\x1338) ;; ETHIOPIC SYLLABLE TSA
     (?$(3$@(B . ?\x1339) ;; ETHIOPIC SYLLABLE TSU
     (?$(3$A(B . ?\x133A) ;; ETHIOPIC SYLLABLE TSI
     (?$(3$B(B . ?\x133B) ;; ETHIOPIC SYLLABLE TSAA
     (?$(3$C(B . ?\x133C) ;; ETHIOPIC SYLLABLE TSEE
     (?$(3$D(B . ?\x133D) ;; ETHIOPIC SYLLABLE TSE
     (?$(3$E(B . ?\x133E) ;; ETHIOPIC SYLLABLE TSO
     (?$(3$F(B . ?\x133F) ;; ETHIOPIC SYLLABLE TSWA
     (?$(3$G(B . ?\x1340) ;; ETHIOPIC SYLLABLE TZA
     (?$(3$H(B . ?\x1341) ;; ETHIOPIC SYLLABLE TZU
     (?$(3$I(B . ?\x1342) ;; ETHIOPIC SYLLABLE TZI
     (?$(3$J(B . ?\x1343) ;; ETHIOPIC SYLLABLE TZAA
     (?$(3$K(B . ?\x1344) ;; ETHIOPIC SYLLABLE TZEE
     (?$(3$L(B . ?\x1345) ;; ETHIOPIC SYLLABLE TZE
     (?$(3$M(B . ?\x1346) ;; ETHIOPIC SYLLABLE TZO
     (?$(3$O(B . ?\x1348) ;; ETHIOPIC SYLLABLE FA
     (?$(3$P(B . ?\x1349) ;; ETHIOPIC SYLLABLE FU
     (?$(3$Q(B . ?\x134A) ;; ETHIOPIC SYLLABLE FI
     (?$(3$R(B . ?\x134B) ;; ETHIOPIC SYLLABLE FAA
     (?$(3$S(B . ?\x134C) ;; ETHIOPIC SYLLABLE FEE
     (?$(3$T(B . ?\x134D) ;; ETHIOPIC SYLLABLE FE
     (?$(3$U(B . ?\x134E) ;; ETHIOPIC SYLLABLE FO
     (?$(3$V(B . ?\x134F) ;; ETHIOPIC SYLLABLE FWA
     (?$(3$W(B . ?\x1350) ;; ETHIOPIC SYLLABLE PA
     (?$(3$X(B . ?\x1351) ;; ETHIOPIC SYLLABLE PU
     (?$(3$Y(B . ?\x1352) ;; ETHIOPIC SYLLABLE PI
     (?$(3$Z(B . ?\x1353) ;; ETHIOPIC SYLLABLE PAA
     (?$(3$[(B . ?\x1354) ;; ETHIOPIC SYLLABLE PEE
     (?$(3$\(B . ?\x1355) ;; ETHIOPIC SYLLABLE PE
     (?$(3$](B . ?\x1356) ;; ETHIOPIC SYLLABLE PO
     (?$(3$^(B . ?\x1357) ;; ETHIOPIC SYLLABLE PWA
     (?$(3$_(B . ?\x1358) ;; ETHIOPIC SYLLABLE RYA
     (?$(3$`(B . ?\x1359) ;; ETHIOPIC SYLLABLE MYA
     (?$(3$a(B . ?\x135A) ;; ETHIOPIC SYLLABLE FYA
     (?$(3$h(B . ?\x1361) ;; ETHIOPIC WORDSPACE
     (?$(3$i(B . ?\x1362) ;; ETHIOPIC FULL STOP
     (?$(3$j(B . ?\x1363) ;; ETHIOPIC COMMA
     (?$(3$k(B . ?\x1364) ;; ETHIOPIC SEMICOLON
     (?$(3$l(B . ?\x1365) ;; ETHIOPIC COLON
     (?$(3$m(B . ?\x1366) ;; ETHIOPIC PREFACE COLON
     (?$(3$n(B . ?\x1367) ;; ETHIOPIC QUESTION MARK
     (?$(3$o(B . ?\x1368) ;; ETHIOPIC PARAGRAPH SEPARATOR
     (?$(3$p(B . ?\x1369) ;; ETHIOPIC DIGIT ONE
     (?$(3$q(B . ?\x136A) ;; ETHIOPIC DIGIT TWO
     (?$(3$r(B . ?\x136B) ;; ETHIOPIC DIGIT THREE
     (?$(3$s(B . ?\x136C) ;; ETHIOPIC DIGIT FOUR
     (?$(3$t(B . ?\x136D) ;; ETHIOPIC DIGIT FIVE
     (?$(3$u(B . ?\x136E) ;; ETHIOPIC DIGIT SIX
     (?$(3$v(B . ?\x136F) ;; ETHIOPIC DIGIT SEVEN
     (?$(3$w(B . ?\x1370) ;; ETHIOPIC DIGIT EIGHT
     (?$(3$x(B . ?\x1371) ;; ETHIOPIC DIGIT NINE
     (?$(3$y(B . ?\x1372) ;; ETHIOPIC NUMBER TEN
     (?$(3$z(B . ?\x1373) ;; ETHIOPIC NUMBER TWENTY
     (?$(3${(B . ?\x1374) ;; ETHIOPIC NUMBER THIRTY
     (?$(3$|(B . ?\x1375) ;; ETHIOPIC NUMBER FORTY
     (?$(3$}(B . ?\x1376) ;; ETHIOPIC NUMBER FIFTY
     (?$(3$~(B . ?\x1377) ;; ETHIOPIC NUMBER SIXTY
     (?$(3%!(B . ?\x1378) ;; ETHIOPIC NUMBER SEVENTY
     (?$(3%"(B . ?\x1379) ;; ETHIOPIC NUMBER EIGHTY
     (?$(3%#(B . ?\x137A) ;; ETHIOPIC NUMBER NINETY
     (?$(3%$(B . ?\x137B) ;; ETHIOPIC NUMBER HUNDRED
     (?$(3%%(B . ?\x137C) ;; ETHIOPIC NUMBER TEN THOUSAND
     )))

(provide 'uetiopic)
