; -*- coding: iso-2022-7bit  -*-
;;; u-cns-7.el --- tables between UCS and CNS 11643:1992 plain 7

;; Copyright (C) 1998 Koichi Yasuoka.
;; Copyright (C) 1998 MORIOKA Tomohiko.

;; Author: MORIOKA Tomohiko <morioka@jaist.ac.jp>

;; Keywords: CCL, mule, multilingual, character set, coding-system,
;;                ISO/IEC 10646, Unicode 2.0, CNS 11643:1992

;; This file is part of MULE-UCS.

;;; Commentary:

;; This program was originally based on "Uni2CNS.Z" by Koichi Yasuoka
;; <yasuoka@kudpc.kyoto-u.ac.jp>, and checked and translated to Emacs
;; Lisp by MORIOKA Tomohiko.

;;; Code:

(put 'chinese-cns11643-7 'unicode-assoc
     'cns11643-7-vs-unicode-assoc)

(defvar cns11643-7-vs-unicode-assoc
  '(assoc
    (char-1 . ucs-generic)
    ((?$(M!c(B . ?\x5655) ; <CJK>
     (?$(M!x(B . ?\x58C4) ; <CJK>
     (?$(M"q(B . ?\x617F) ; <CJK>
     (?$(M#-(B . ?\x6469) ; <CJK>
     (?$(M$O(B . ?\x6F6E) ; <CJK>
     (?$(M/O(B . ?\x71D7) ; <CJK>
     (?$(M1-(B . ?\x7CD2) ; <CJK>
     (?$(M2a(B . ?\x8666) ; <CJK>
     (?$(M42(B . ?\x8F3A) ; <CJK>
     (?$(M;8(B . ?\x8667) ; <CJK>
     (?$(M?b(B . ?\x64F5) ; <CJK>
     (?$(MAY(B . ?\x7E64) ; <CJK>
     (?$(MAa(B . ?\x7F80) ; <CJK>
     (?$(MCR(B . ?\x8D01) ; <CJK>
     (?$(MFE(B . ?\x58E1) ; <CJK>
     (?$(MHW(B . ?\x7CE9) ; <CJK>
     (?$(MH|(B . ?\x81CB) ; <CJK>
     (?$(MK@(B . ?\x95D9) ; <CJK>
     (?$(MSG(B . ?\x6707) ; <CJK>
     (?$(MVQ(B . ?\x9A47) ; <CJK>
     (?$(MdR(B . ?\x7674) ; <CJK>
     )))

(provide 'u-cns-7)
 
;;; u-cns-7.el ends here
 