;;; -*- coding: iso-2022-7bit  -*-
;;; uviscii.el --- tables between Unicode and VISCII 1.1

;; Keywords: CCL, mule, multilingual, 
;;           character set, coding-system, ISO10646, Unicode, VISCII

;; Miyashita Hisashi(himi@bird.scphys.kyoto-u.ac.jp)
;; converted VISCII.TXT created by Mark Leisher <mleisher@crl.nmsu.edu>

;; This file is part of Mule-UCS

;; Mule-UCS is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; Mule-UCS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

(put 'vietnamese-viscii-lower 'unicode-assoc
     'viscii-lower-vs-unicode-assoc)
(put 'vietnamese-viscii-upper 'unicode-assoc
     'viscii-upper-vs-unicode-assoc)

(defvar viscii-lower-vs-unicode-assoc
  '(assoc
    (char-1 . ucs-generic)
    ((?,1!(B . ?\x1EAF) ;; LATIN SMALL LETTER A WITH BREVE AND ACUTE
     (?,1"(B . ?\x1EB1) ;; LATIN SMALL LETTER A WITH BREVE AND GRAVE
     (?,1#(B . ?\x1EB7) ;; LATIN SMALL LETTER A WITH BREVE AND DOT BELOW
     (?,1$(B . ?\x1EA5) ;; LATIN SMALL LETTER A WITH CIRCUMFLEX AND ACUTE
     (?,1%(B . ?\x1EA7) ;; LATIN SMALL LETTER A WITH CIRCUMFLEX AND GRAVE
     (?,1&(B . ?\x1EA9) ;; LATIN SMALL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE
     (?,1'(B . ?\x1EAD) ;; LATIN SMALL LETTER A WITH CIRCUMFLEX AND DOT BELOW
     (?,1((B . ?\x1EBD) ;; LATIN SMALL LETTER E WITH TILDE
     (?,1)(B . ?\x1EB9) ;; LATIN SMALL LETTER E WITH DOT BELOW
     (?,1*(B . ?\x1EBF) ;; LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE
     (?,1+(B . ?\x1EC1) ;; LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE
     (?,1,(B . ?\x1EC3) ;; LATIN SMALL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
     (?,1-(B . ?\x1EC5) ;; LATIN SMALL LETTER E WITH CIRCUMFLEX AND TILDE
     (?,1.(B . ?\x1EC7) ;; LATIN SMALL LETTER E WITH CIRCUMFLEX AND DOT BELOW
     (?,1/(B . ?\x1ED1) ;; LATIN SMALL LETTER O WITH CIRCUMFLEX AND ACUTE
     (?,10(B . ?\x1ED3) ;; LATIN SMALL LETTER O WITH CIRCUMFLEX AND GRAVE
     (?,11(B . ?\x1ED5) ;; LATIN SMALL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE
     (?,12(B . ?\x1ED7) ;; LATIN SMALL LETTER O WITH CIRCUMFLEX AND TILDE
     (?,15(B . ?\x1ED9) ;; LATIN SMALL LETTER O WITH CIRCUMFLEX AND DOT BELOW
     (?,16(B . ?\x1EDD) ;; LATIN SMALL LETTER O WITH HORN AND GRAVE
     (?,17(B . ?\x1EDF) ;; LATIN SMALL LETTER O WITH HORN AND HOOK ABOVE
     (?,18(B . ?\x1ECB) ;; LATIN SMALL LETTER I WITH DOT BELOW
     (?,1=(B . ?\x01A1) ;; LATIN SMALL LETTER O WITH HORN
     (?,1>(B . ?\x1EDB) ;; LATIN SMALL LETTER O WITH HORN AND ACUTE
     (?,1F(B . ?\x1EB3) ;; LATIN SMALL LETTER A WITH BREVE AND HOOK ABOVE
     (?,1G(B . ?\x1EB5) ;; LATIN SMALL LETTER A WITH BREVE AND TILDE
     (?,1O(B . ?\x1EF3) ;; LATIN SMALL LETTER Y WITH GRAVE
     (?,1Q(B . ?\x1EE9) ;; LATIN SMALL LETTER U WITH HORN AND ACUTE
     (?,1U(B . ?\x1EA1) ;; LATIN SMALL LETTER A WITH DOT BELOW
     (?,1V(B . ?\x1EF7) ;; LATIN SMALL LETTER Y WITH HOOK ABOVE
     (?,1W(B . ?\x1EEB) ;; LATIN SMALL LETTER U WITH HORN AND GRAVE
     (?,1X(B . ?\x1EED) ;; LATIN SMALL LETTER U WITH HORN AND HOOK ABOVE
     (?,1[(B . ?\x1EF9) ;; LATIN SMALL LETTER Y WITH TILDE
     (?,1\(B . ?\x1EF5) ;; LATIN SMALL LETTER Y WITH DOT BELOW
     (?,1^(B . ?\x1EE1) ;; LATIN SMALL LETTER O WITH HORN AND TILDE
     (?,1_(B . ?\x01B0) ;; LATIN SMALL LETTER U WITH HORN
     (?,1`(B . ?\x00E0) ;; LATIN SMALL LETTER A WITH GRAVE
     (?,1a(B . ?\x00E1) ;; LATIN SMALL LETTER A WITH ACUTE
     (?,1b(B . ?\x00E2) ;; LATIN SMALL LETTER A WITH CIRCUMFLEX
     (?,1c(B . ?\x00E3) ;; LATIN SMALL LETTER A WITH TILDE
     (?,1d(B . ?\x1EA3) ;; LATIN SMALL LETTER A WITH HOOK ABOVE
     (?,1e(B . ?\x0103) ;; LATIN SMALL LETTER A WITH BREVE
     (?,1f(B . ?\x1EEF) ;; LATIN SMALL LETTER U WITH HORN AND TILDE
     (?,1g(B . ?\x1EAB) ;; LATIN SMALL LETTER A WITH CIRCUMFLEX AND TILDE
     (?,1h(B . ?\x00E8) ;; LATIN SMALL LETTER E WITH GRAVE
     (?,1i(B . ?\x00E9) ;; LATIN SMALL LETTER E WITH ACUTE
     (?,1j(B . ?\x00EA) ;; LATIN SMALL LETTER E WITH CIRCUMFLEX
     (?,1k(B . ?\x1EBB) ;; LATIN SMALL LETTER E WITH HOOK ABOVE
     (?,1l(B . ?\x00EC) ;; LATIN SMALL LETTER I WITH GRAVE
     (?,1m(B . ?\x00ED) ;; LATIN SMALL LETTER I WITH ACUTE
     (?,1n(B . ?\x0129) ;; LATIN SMALL LETTER I WITH TILDE
     (?,1o(B . ?\x1EC9) ;; LATIN SMALL LETTER I WITH HOOK ABOVE
     (?,1p(B . ?\x0111) ;; LATIN SMALL LETTER D WITH STROKE
     (?,1q(B . ?\x1EF1) ;; LATIN SMALL LETTER U WITH HORN AND DOT BELOW
     (?,1r(B . ?\x00F2) ;; LATIN SMALL LETTER O WITH GRAVE
     (?,1s(B . ?\x00F3) ;; LATIN SMALL LETTER O WITH ACUTE
     (?,1t(B . ?\x00F4) ;; LATIN SMALL LETTER O WITH CIRCUMFLEX
     (?,1u(B . ?\x00F5) ;; LATIN SMALL LETTER O WITH TILDE
     (?,1v(B . ?\x1ECF) ;; LATIN SMALL LETTER O WITH HOOK ABOVE
     (?,1w(B . ?\x1ECD) ;; LATIN SMALL LETTER O WITH DOT BELOW
     (?,1x(B . ?\x1EE5) ;; LATIN SMALL LETTER U WITH DOT BELOW
     (?,1y(B . ?\x00F9) ;; LATIN SMALL LETTER U WITH GRAVE
     (?,1z(B . ?\x00FA) ;; LATIN SMALL LETTER U WITH ACUTE
     (?,1{(B . ?\x0169) ;; LATIN SMALL LETTER U WITH TILDE
     (?,1|(B . ?\x1EE7) ;; LATIN SMALL LETTER U WITH HOOK ABOVE
     (?,1}(B . ?\x00FD) ;; LATIN SMALL LETTER Y WITH ACUTE
     (?,1~(B . ?\x1EE3) ;; LATIN SMALL LETTER O WITH HORN AND DOT BELOW
     )))

(defvar viscii-upper-vs-unicode-assoc
  '(assoc
    (char-1 . ucs-generic)
    ((?,2!(B . ?\x1EAE) ;; LATIN CAPITAL LETTER A WITH BREVE AND ACUTE
     (?,2"(B . ?\x1EB0) ;; LATIN CAPITAL LETTER A WITH BREVE AND GRAVE
     (?,2#(B . ?\x1EB6) ;; LATIN CAPITAL LETTER A WITH BREVE AND DOT BELOW
     (?,2$(B . ?\x1EA4) ;; LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND ACUTE
     (?,2%(B . ?\x1EA6) ;; LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND GRAVE
     (?,2&(B . ?\x1EA8) ;; LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE
     (?,2'(B . ?\x1EAC) ;; LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND DOT BELOW
     (?,2((B . ?\x1EBC) ;; LATIN CAPITAL LETTER E WITH TILDE
     (?,2)(B . ?\x1EB8) ;; LATIN CAPITAL LETTER E WITH DOT BELOW
     (?,2*(B . ?\x1EBE) ;; LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE
     (?,2+(B . ?\x1EC0) ;; LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE
     (?,2,(B . ?\x1EC2) ;; LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
     (?,2-(B . ?\x1EC4) ;; LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND TILDE
     (?,2.(B . ?\x1EC6) ;; LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND DOT BELOW
     (?,2/(B . ?\x1ED0) ;; LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND ACUTE
     (?,20(B . ?\x1ED2) ;; LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND GRAVE
     (?,21(B . ?\x1ED4) ;; LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE
     (?,22(B . ?\x1ED6) ;; LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND TILDE
     (?,25(B . ?\x1ED8) ;; LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND DOT BELOW
     (?,26(B . ?\x1EDC) ;; LATIN CAPITAL LETTER O WITH HORN AND GRAVE
     (?,27(B . ?\x1EDE) ;; LATIN CAPITAL LETTER O WITH HORN AND HOOK ABOVE
     (?,28(B . ?\x1ECA) ;; LATIN CAPITAL LETTER I WITH DOT BELOW
     (?,2=(B . ?\x01A0) ;; LATIN CAPITAL LETTER O WITH HORN
     (?,2>(B . ?\x1EDA) ;; LATIN CAPITAL LETTER O WITH HORN AND ACUTE
     (?,2F(B . ?\x1EB2) ;; LATIN CAPITAL LETTER A WITH BREVE AND HOOK ABOVE
     (?,2G(B . ?\x1EB4) ;; LATIN CAPITAL LETTER A WITH BREVE AND TILDE
     (?,2O(B . ?\x1EF2) ;; LATIN CAPITAL LETTER Y WITH GRAVE
     (?,2Q(B . ?\x1EE8) ;; LATIN CAPITAL LETTER U WITH HORN AND ACUTE
     (?,2U(B . ?\x1EA0) ;; LATIN CAPITAL LETTER A WITH DOT BELOW
     (?,2V(B . ?\x1EF6) ;; LATIN CAPITAL LETTER Y WITH HOOK ABOVE
     (?,2W(B . ?\x1EEA) ;; LATIN CAPITAL LETTER U WITH HORN AND GRAVE
     (?,2X(B . ?\x1EEC) ;; LATIN CAPITAL LETTER U WITH HORN AND HOOK ABOVE
     (?,2[(B . ?\x1EF8) ;; LATIN CAPITAL LETTER Y WITH TILDE
     (?,2\(B . ?\x1EF4) ;; LATIN CAPITAL LETTER Y WITH DOT BELOW
     (?,2^(B . ?\x1EE0) ;; LATIN CAPITAL LETTER O WITH HORN AND TILDE
     (?,2_(B . ?\x01AF) ;; LATIN CAPITAL LETTER U WITH HORN
     (?,2`(B . ?\x00C0) ;; LATIN CAPITAL LETTER A WITH GRAVE
     (?,2a(B . ?\x00C1) ;; LATIN CAPITAL LETTER A WITH ACUTE
     (?,2b(B . ?\x00C2) ;; LATIN CAPITAL LETTER A WITH CIRCUMFLEX
     (?,2c(B . ?\x00C3) ;; LATIN CAPITAL LETTER A WITH TILDE
     (?,2d(B . ?\x1EA2) ;; LATIN CAPITAL LETTER A WITH HOOK ABOVE
     (?,2e(B . ?\x0102) ;; LATIN CAPITAL LETTER A WITH BREVE
     (?,2f(B . ?\x1EEE) ;; LATIN CAPITAL LETTER U WITH HORN AND TILDE
     (?,2g(B . ?\x1EAA) ;; LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND TILDE
     (?,2h(B . ?\x00C8) ;; LATIN CAPITAL LETTER E WITH GRAVE
     (?,2i(B . ?\x00C9) ;; LATIN CAPITAL LETTER E WITH ACUTE
     (?,2j(B . ?\x00CA) ;; LATIN CAPITAL LETTER E WITH CIRCUMFLEX
     (?,2k(B . ?\x1EBA) ;; LATIN CAPITAL LETTER E WITH HOOK ABOVE
     (?,2l(B . ?\x00CC) ;; LATIN CAPITAL LETTER I WITH GRAVE
     (?,2m(B . ?\x00CD) ;; LATIN CAPITAL LETTER I WITH ACUTE
     (?,2n(B . ?\x0128) ;; LATIN CAPITAL LETTER I WITH TILDE
     (?,2o(B . ?\x1EC8) ;; LATIN CAPITAL LETTER I WITH HOOK ABOVE
     (?,2p(B . ?\x0110) ;; LATIN CAPITAL LETTER D WITH STROKE
     (?,2q(B . ?\x1EF0) ;; LATIN CAPITAL LETTER U WITH HORN AND DOT BELOW
     (?,2r(B . ?\x00D2) ;; LATIN CAPITAL LETTER O WITH GRAVE
     (?,2s(B . ?\x00D3) ;; LATIN CAPITAL LETTER O WITH ACUTE
     (?,2t(B . ?\x00D4) ;; LATIN CAPITAL LETTER O WITH CIRCUMFLEX
     (?,2u(B . ?\x00D5) ;; LATIN CAPITAL LETTER O WITH TILDE
     (?,2v(B . ?\x1ECE) ;; LATIN CAPITAL LETTER O WITH HOOK ABOVE
     (?,2w(B . ?\x1ECC) ;; LATIN CAPITAL LETTER O WITH DOT BELOW
     (?,2x(B . ?\x1EE4) ;; LATIN CAPITAL LETTER U WITH DOT BELOW
     (?,2y(B . ?\x00D9) ;; LATIN CAPITAL LETTER U WITH GRAVE
     (?,2z(B . ?\x00DA) ;; LATIN CAPITAL LETTER U WITH ACUTE
     (?,2{(B . ?\x0168) ;; LATIN CAPITAL LETTER U WITH TILDE
     (?,2|(B . ?\x1EE6) ;; LATIN CAPITAL LETTER U WITH HOOK ABOVE
     (?,2}(B . ?\x00DD) ;; LATIN CAPITAL LETTER Y WITH ACUTE
     (?,2~(B . ?\x1EE2) ;; LATIN CAPITAL LETTER O WITH HORN AND DOT BELOW
     )))

(provide 'uviscii)

