; -*- coding: iso-2022-7bit  -*-
;;; u-cns-6.el --- tables between UCS and CNS 11643:1992 plain 6

;; Copyright (C) 1998 Koichi Yasuoka.
;; Copyright (C) 1998 MORIOKA Tomohiko.

;; Author: MORIOKA Tomohiko <morioka@jaist.ac.jp>

;; Keywords: CCL, mule, multilingual, character set, coding-system,
;;                ISO/IEC 10646, Unicode 2.0, CNS 11643:1992

;; This file is part of MULE-UCS.

;;; Commentary:

;; This program was originally based on "Uni2CNS.Z" by Koichi Yasuoka
;; <yasuoka@kudpc.kyoto-u.ac.jp>, and checked and translated to Emacs
;; Lisp by MORIOKA Tomohiko.

;;; Code:

(put 'chinese-cns11643-6 'unicode-assoc
     'cns11643-6-vs-unicode-assoc)

(defvar cns11643-6-vs-unicode-assoc
  '(assoc
    (char-1 . ucs-generic)
    ((?$(L!#(B . ?\x4E44) ; <CJK>
     (?$(L!-(B . ?\x536B) ; <CJK>
     (?$(L!1(B . ?\x4E38) ; <CJK>
     (?$(L!8(B . ?\x5203) ; <CJK>
     (?$(L!P(B . ?\x5185) ; <CJK>
     (?$(L!a(B . ?\x53CA) ; <CJK>
     (?$(L"F(B . ?\x5305) ; <CJK>
     (?$(L"[(B . ?\x53EB) ; <CJK>
     (?$(L#R(B . ?\x5145) ; <CJK>
     (?$(L#l(B . ?\x6530) ; <CJK>
     (?$(L%#(B . ?\x6B21) ; <CJK>
     (?$(L%R(B . ?\x828B) ; <CJK>
     (?$(L&N(B . ?\x5438) ; <CJK>
     (?$(L&g(B . ?\x575A) ; <CJK>
     (?$(L'!(B . ?\x5BFF) ; <CJK>
     (?$(L'6(B . ?\x5DE1) ; <CJK>
     (?$(L'C(B . ?\x5E94) ; <CJK>
     (?$(L'_(B . ?\x5FCD) ; <CJK>
     (?$(L(.(B . ?\x6753) ; <CJK>
     (?$(L)'(B . ?\x829D) ; <CJK>
     (?$(L)((B . ?\x82B1) ; <CJK>
     (?$(L*!(B . ?\x5365) ; <CJK>
     (?$(L+`(B . ?\x62E8) ; <CJK>
     (?$(L+c(B . ?\x62B1) ; <CJK>
     (?$(L,[(B . ?\x6CBF) ; <CJK>
     (?$(L-E(B . ?\x76F4) ; <CJK>
     (?$(L-i(B . ?\x80B2) ; <CJK>
     (?$(L."(B . ?\x82BD) ; <CJK>
     (?$(L.#(B . ?\x82E6) ; <CJK>
     (?$(L.$(B . ?\x82E5) ; <CJK>
     (?$(L/%(B . ?\x52C7) ; <CJK>
     (?$(L/8(B . ?\x5351) ; <CJK>
     (?$(L1m(B . ?\x5192) ; <CJK>
     (?$(L1r(B . ?\x6804) ; <CJK>
     (?$(L2B(B . ?\x6D3E) ; <CJK>
     (?$(L2H(B . ?\x70AD) ; <CJK>
     (?$(L4G(B . ?\x8650) ; <CJK>
     (?$(L4`(B . ?\x8FEC) ; <CJK>
     (?$(L5X(B . ?\x52C9) ; <CJK>
     (?$(L5x(B . ?\x53DE) ; <CJK>
     (?$(L5~(B . ?\x5510) ; <CJK>
     (?$(L65(B . ?\x57CE) ; <CJK>
     (?$(L6W(B . ?\x5A30) ; <CJK>
     (?$(L6f(B . ?\x5BB2) ; <CJK>
     (?$(L86(B . ?\x66F8) ; <CJK>
     (?$(L8t(B . ?\x6D78) ; <CJK>
     (?$(L9-(B . ?\x6D69) ; <CJK>
     (?$(L:-(B . ?\x771F) ; <CJK>
     (?$(L:C(B . ?\x79EB) ; <CJK>
     (?$(L;!(B . ?\x8038) ; <CJK>
     (?$(L;$(B . ?\x8081) ; <CJK>
     (?$(L;:(B . ?\x81F4) ; <CJK>
     (?$(L<;(B . ?\x8D77) ; <CJK>
     (?$(L>P(B . ?\x5A66) ; <CJK>
     (?$(L>v(B . ?\x5D2B) ; <CJK>
     (?$(L@+(B . ?\x6383) ; <CJK>
     (?$(L@6(B . ?\x6368) ; <CJK>
     (?$(L@X(B . ?\x671B) ; <CJK>
     (?$(LD;(B . ?\x8457) ; <CJK>
     (?$(LD<(B . ?\x83CC) ; <CJK>
     (?$(LD=(B . ?\x83DC) ; <CJK>
     (?$(LD>(B . ?\x83CA) ; <CJK>
     (?$(LDp(B . ?\x8A24) ; <CJK>
     (?$(LE8(B . ?\x8DC3) ; <CJK>
     (?$(LF>(B . ?\x9EBB) ; <CJK>
     (?$(LFe(B . ?\x51F2) ; <CJK>
     (?$(LFg(B . ?\x5272) ; <CJK>
     (?$(LFt(B . ?\x535A) ; <CJK>
     (?$(LG)(B . ?\x55B6) ; <CJK>
     (?$(LG*(B . ?\x5584) ; <CJK>
     (?$(LG1(B . ?\x55AB) ; <CJK>
     (?$(LGV(B . ?\x5962) ; <CJK>
     (?$(LG{(B . ?\x5C60) ; <CJK>
     (?$(LH+(B . ?\x5D43) ; <CJK>
     (?$(LH7(B . ?\x5DFD) ; <CJK>
     (?$(LH<(B . ?\x5E3D) ; <CJK>
     (?$(LHE(B . ?\x5EC3) ; <CJK>
     (?$(LIx(B . ?\x6700) ; <CJK>
     (?$(LJe(B . ?\x6E2F) ; <CJK>
     (?$(LKV(B . ?\x7570) ; <CJK>
     (?$(LL/(B . ?\x7861) ; <CJK>
     (?$(LLC(B . ?\x7A06) ; <CJK>
     (?$(LLH(B . ?\x7A01) ; <CJK>
     (?$(LMG(B . ?\x8157) ; <CJK>
     (?$(LMn(B . ?\x83F7) ; <CJK>
     (?$(LNO(B . ?\x8849) ; <CJK>
     (?$(LN`(B . ?\x8999) ; <CJK>
     (?$(LOo(B . ?\x921F) ; <CJK>
     (?$(LPt(B . ?\x5313) ; <CJK>
     (?$(LQ6(B . ?\x5606) ; <CJK>
     (?$(LQC(B . ?\x55E0) ; <CJK>
     (?$(LQ^(B . ?\x5922) ; <CJK>
     (?$(LR@(B . ?\x5ECA) ; <CJK>
     (?$(LRd(B . ?\x6139) ; <CJK>
     (?$(LRf(B . ?\x614E) ; <CJK>
     (?$(LS<(B . ?\x6691) ; <CJK>
     (?$(LTD(B . ?\x6E7F) ; <CJK>
     (?$(LTN(B . ?\x6ED7) ; <CJK>
     (?$(LT|(B . ?\x733D) ; <CJK>
     (?$(L[[(B . ?\x5716) ; <CJK>
     (?$(L\/(B . ?\x5900) ; <CJK>
     (?$(L]K(B . ?\x6577) ; <CJK>
     (?$(L]h(B . ?\x69A3) ; <CJK>
     (?$(L`X(B . ?\x7FE4) ; <CJK>
     (?$(L``(B . ?\x8088) ; <CJK>
     )))

(provide 'u-cns-6)

;;; u-cns-6.el ends here
 