;;; mule-uni.el --- Mule Private charset definitions for unicode.

;; Copyright (C) 2000 Miyashita Hisashi

;; Keywords: mule, multilingual, 
;;           character set, ISO/IEC 10646, Unicode.

;; This file is part of Mule-UCS

;; Mule-UCS is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; Mule-UCS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

(if (not (charsetp 'mule-unicode-0100-24ff))
    (define-charset 244 'mule-unicode-0100-24ff
      [2 96 1 0 ?1 0 "Unicode subset" "Unicode subset (U+0100..U+24FF)"
	 "Unicode characters of the range U+0100..U+24FF."]))

(put 'mule-unicode-0100-24ff
     'unicode-assoc
     'mule-unicode-0100-24ff-vs-unicode-assoc)

(defun ucs-to-mule-unicode-0100-24ff (codepoint)
  (if (or (not (numberp codepoint))
	  (> codepoint ?\x24FF)
	  (< codepoint ?\x0100))
      (error "The given codepoint is invalid:%S" codepoint))
  (setq codepoint (- codepoint ?\x0100))
  (make-char 'mule-unicode-0100-24ff
	     (+ (/ codepoint 96) 32)
	     (+ (% codepoint 96) 32)))

(defun mule-unicode-0100-24ff-to-ucs (char)
  (let (cs row col)
    (if (and (char-valid-p char)
	     (eq 'mule-unicode-0100-24ff-to-ucs
		 (setq cs (split-char char)
		       row (nth 1 cs)
		       col (nth 2 cs)
		       cs (car cs))))
	(+ (* (- row 32) 96) (- col 32) ?\x0100)
      (error "The given char is invalid:%S" char))))

(define-category ?u "Mule unicode characters")
(modify-category-entry (make-char 'mule-unicode-0100-24ff) ?u)

(defvar
  mule-unicode-0100-24ff-vs-unicode-assoc
  `(range
    (char-1 . ucs-generic)
    (((,(ucs-to-mule-unicode-0100-24ff ?\x0100) .
       ,(ucs-to-mule-unicode-0100-24ff ?\x24FF)) .
       (?\x100 . ?\x24FF)))))

(provide 'mule-uni)
