;;; mccl-font.el --- Library for Mule-UCS CCL Font encoder.

;; Copyright (C) 2000 Miyashita Hisashi

;; Keywords: mule, multilingual,
;;           character set, coding-system, CCL, font

;; This file is part of Mule-UCS

;; Mule-UCS is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; Mule-UCS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;; Comment:
(require 'mucs)
(require 'mucs-ccl)
(require 'mucs-type)

;;; Type definitions

(defconst mccl-font-charset-alist
  (mapcar
   (lambda (charset)
     (let ((typesym
	    (intern (format "font-%s"
			    charset))))
     (mucs-define-type
      typesym
      'identity
      'identity)
     (cons typesym charset)))
   (charset-list)))

(mucs-define-type
 'font-codepoint
 'identity
 'identity)

;;; Type conversions.

(defun mucs-ccl-flat-code-to-font-encoding (bytes)
  (setq mucs-current-type 'font-codepoint)
  (cond ((= bytes 1)
	 '((r1 = r0)))
	((= bytes 2)
	 '((r1 = (r0 >8 r0))
	   (r2 = r7)))
	(t
	 (error "Not support such bytes in font encoding:%S."
		bytes))))

(defun mucs-ccl-convert-font-encoding (dimension)
  (if (not (eq mucs-current-type
	       'font-codepoint))
      (signal 'mucs-type-mismatch-error
	      mucs-current-type 'font-codepoint))
  (setq mucs-current-type 'char-1)
  (cond ((= dimension 1)
	 '((r0 = ((r0 << 16) | r1))))
	((= dimension 2)
	 `((r0 <<= 16)
	   (r0 |= ((r1 * 96) + r2))))
	(t
	 (error "Unknown dimension:%S." dimension))))

(defun mucs-ccl-font-type-convert (type)
  (if (not (eq mucs-current-type
	       'font-codepoint))
      (signal 'mucs-type-mismatch-error
	      mucs-current-type 'font-codepoint))
  (let* ((charset (cdr (assq mccl-font-charset-alist
			     type)))
	 (dim (charset-dimension charset)))
    (setq mucs-current-type 'char-1)
    (mucs-ccl-convert-font-encoding dim)))

;
; Charset
;

(defvar charset-id-charset-list
  (let* ((chidlist
	  (sort
	   (mapcar
	    (lambda (cs)
	      (cons cs (charset-id cs)))
	    (charset-list))
	   (lambda (x y) (< (cdr x) (cdr y)))))
	 (i 0)
	 slot charset id result)
    (while (setq slot (car chidlist))
      (setq chidlist (cdr chidlist)
	    charset (car slot)
	    id (cdr slot))
      (while (< i id)
	(setq result (cons nil result)
	      i (1+ i)))
      (setq result (cons charset result)))
    (nreverse result)))

(defun mucs-ccl-font-encoder (charset-spec)
  (setq charset-spec
	(sort (copy-sequence charset-spec)
	      (lambda (x y) (< (charset-id (car x))
			       (charset-id (car y))))))
  (let ((result-myo (mucs-ccl-empty-myo))
	(i 0) id
	charset-clist slot
	myo ccl-prog)

    (while (setq slot (car charset-spec))
      (setq id (charset-id (car slot))
	    charset-spec (cdr charset-spec))
      (while (< i id)
	(setq charset-clist (cons nil charset-clist)
	      i (1+ i)))
      (setq charset-clist (cons slot charset-clist)
	    i (1+ i)))
    (setq charset-clist (nreverse charset-clist))
    (mucs-ccl-myo-set-ccl
     `((branch
	r0
	,@(mapcar
	   (lambda (cs)
	     (cond ((charsetp (car cs))
		    (setq myo
			  (mucs-ccl-bind-program (eval (cdr cs))))
		    (mucs-ccl-myo-append-safe
		     result-myo
		     myo)
		    (mucs-ccl-myo-get-ccl myo))
;		    (append
;		     (mucs-ccl-myo-get-ccl myo)
;		     '((end))))
		   (t
		    nil)))
;		    '((end)))))
	   charset-clist)))
     result-myo)
    result-myo))

(provide 'mccl-font)