;;; -*- coding: iso-2022-7bit  -*-
;;; uiso8859-9.el --- tables between UCS and ISO-8859-9

;; Keywords: CCL, mule, multilingual, 
;;           character set, coding-system, ISO10646, Unicode, ISO8859

;; This file is part of Mule-UCS

;; Mule-UCS is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; Mule-UCS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; This file is converted from 8859-9.TXT of Unicode consortium
;;; by Miyashita Hisashi <himi@bird.scphys.kyoto-u.ac.jp>.

(put 'latin-iso8859-9 'unicode-assoc
     'iso-8859-9-vs-unicode-assoc)

(defvar
  iso-8859-9-vs-unicode-assoc
  '(assoc
    (char-1 . ucs-generic)
    ((?,M (B . ?\x00A0) ;; NO-BREAK SPACE
     (?,M!(B . ?\x00A1) ;; INVERTED EXCLAMATION MARK
     (?,M"(B . ?\x00A2) ;; CENT SIGN
     (?,M#(B . ?\x00A3) ;; POUND SIGN
     (?,M$(B . ?\x00A4) ;; CURRENCY SIGN
     (?,M%(B . ?\x00A5) ;; YEN SIGN
     (?,M&(B . ?\x00A6) ;; BROKEN BAR
     (?,M'(B . ?\x00A7) ;; SECTION SIGN
     (?,M((B . ?\x00A8) ;; DIAERESIS
     (?,M)(B . ?\x00A9) ;; COPYRIGHT SIGN
     (?,M*(B . ?\x00AA) ;; FEMININE ORDINAL INDICATOR
     (?,M+(B . ?\x00AB) ;; LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
     (?,M,(B . ?\x00AC) ;; NOT SIGN
     (?,M-(B . ?\x00AD) ;; SOFT HYPHEN
     (?,M.(B . ?\x00AE) ;; REGISTERED SIGN
     (?,M/(B . ?\x00AF) ;; MACRON
     (?,M0(B . ?\x00B0) ;; DEGREE SIGN
     (?,M1(B . ?\x00B1) ;; PLUS-MINUS SIGN
     (?,M2(B . ?\x00B2) ;; SUPERSCRIPT TWO
     (?,M3(B . ?\x00B3) ;; SUPERSCRIPT THREE
     (?,M4(B . ?\x00B4) ;; ACUTE ACCENT
     (?,M5(B . ?\x00B5) ;; MICRO SIGN
     (?,M6(B . ?\x00B6) ;; PILCROW SIGN
     (?,M7(B . ?\x00B7) ;; MIDDLE DOT
     (?,M8(B . ?\x00B8) ;; CEDILLA
     (?,M9(B . ?\x00B9) ;; SUPERSCRIPT ONE
     (?,M:(B . ?\x00BA) ;; MASCULINE ORDINAL INDICATOR
     (?,M;(B . ?\x00BB) ;; RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
     (?,M<(B . ?\x00BC) ;; VULGAR FRACTION ONE QUARTER
     (?,M=(B . ?\x00BD) ;; VULGAR FRACTION ONE HALF
     (?,M>(B . ?\x00BE) ;; VULGAR FRACTION THREE QUARTERS
     (?,M?(B . ?\x00BF) ;; INVERTED QUESTION MARK
     (?,M@(B . ?\x00C0) ;; LATIN CAPITAL LETTER A WITH GRAVE
     (?,MA(B . ?\x00C1) ;; LATIN CAPITAL LETTER A WITH ACUTE
     (?,MB(B . ?\x00C2) ;; LATIN CAPITAL LETTER A WITH CIRCUMFLEX
     (?,MC(B . ?\x00C3) ;; LATIN CAPITAL LETTER A WITH TILDE
     (?,MD(B . ?\x00C4) ;; LATIN CAPITAL LETTER A WITH DIAERESIS
     (?,ME(B . ?\x00C5) ;; LATIN CAPITAL LETTER A WITH RING ABOVE
     (?,MF(B . ?\x00C6) ;; LATIN CAPITAL LETTER AE
     (?,MG(B . ?\x00C7) ;; LATIN CAPITAL LETTER C WITH CEDILLA
     (?,MH(B . ?\x00C8) ;; LATIN CAPITAL LETTER E WITH GRAVE
     (?,MI(B . ?\x00C9) ;; LATIN CAPITAL LETTER E WITH ACUTE
     (?,MJ(B . ?\x00CA) ;; LATIN CAPITAL LETTER E WITH CIRCUMFLEX
     (?,MK(B . ?\x00CB) ;; LATIN CAPITAL LETTER E WITH DIAERESIS
     (?,ML(B . ?\x00CC) ;; LATIN CAPITAL LETTER I WITH GRAVE
     (?,MM(B . ?\x00CD) ;; LATIN CAPITAL LETTER I WITH ACUTE
     (?,MN(B . ?\x00CE) ;; LATIN CAPITAL LETTER I WITH CIRCUMFLEX
     (?,MO(B . ?\x00CF) ;; LATIN CAPITAL LETTER I WITH DIAERESIS
     (?,MP(B . ?\x011E) ;; LATIN CAPITAL LETTER G WITH BREVE
     (?,MQ(B . ?\x00D1) ;; LATIN CAPITAL LETTER N WITH TILDE
     (?,MR(B . ?\x00D2) ;; LATIN CAPITAL LETTER O WITH GRAVE
     (?,MS(B . ?\x00D3) ;; LATIN CAPITAL LETTER O WITH ACUTE
     (?,MT(B . ?\x00D4) ;; LATIN CAPITAL LETTER O WITH CIRCUMFLEX
     (?,MU(B . ?\x00D5) ;; LATIN CAPITAL LETTER O WITH TILDE
     (?,MV(B . ?\x00D6) ;; LATIN CAPITAL LETTER O WITH DIAERESIS
     (?,MW(B . ?\x00D7) ;; MULTIPLICATION SIGN
     (?,MX(B . ?\x00D8) ;; LATIN CAPITAL LETTER O WITH STROKE
     (?,MY(B . ?\x00D9) ;; LATIN CAPITAL LETTER U WITH GRAVE
     (?,MZ(B . ?\x00DA) ;; LATIN CAPITAL LETTER U WITH ACUTE
     (?,M[(B . ?\x00DB) ;; LATIN CAPITAL LETTER U WITH CIRCUMFLEX
     (?,M\(B . ?\x00DC) ;; LATIN CAPITAL LETTER U WITH DIAERESIS
     (?,M](B . ?\x0130) ;; LATIN CAPITAL LETTER I WITH DOT ABOVE
     (?,M^(B . ?\x015E) ;; LATIN CAPITAL LETTER S WITH CEDILLA
     (?,M_(B . ?\x00DF) ;; LATIN SMALL LETTER SHARP S
     (?,M`(B . ?\x00E0) ;; LATIN SMALL LETTER A WITH GRAVE
     (?,Ma(B . ?\x00E1) ;; LATIN SMALL LETTER A WITH ACUTE
     (?,Mb(B . ?\x00E2) ;; LATIN SMALL LETTER A WITH CIRCUMFLEX
     (?,Mc(B . ?\x00E3) ;; LATIN SMALL LETTER A WITH TILDE
     (?,Md(B . ?\x00E4) ;; LATIN SMALL LETTER A WITH DIAERESIS
     (?,Me(B . ?\x00E5) ;; LATIN SMALL LETTER A WITH RING ABOVE
     (?,Mf(B . ?\x00E6) ;; LATIN SMALL LETTER AE
     (?,Mg(B . ?\x00E7) ;; LATIN SMALL LETTER C WITH CEDILLA
     (?,Mh(B . ?\x00E8) ;; LATIN SMALL LETTER E WITH GRAVE
     (?,Mi(B . ?\x00E9) ;; LATIN SMALL LETTER E WITH ACUTE
     (?,Mj(B . ?\x00EA) ;; LATIN SMALL LETTER E WITH CIRCUMFLEX
     (?,Mk(B . ?\x00EB) ;; LATIN SMALL LETTER E WITH DIAERESIS
     (?,Ml(B . ?\x00EC) ;; LATIN SMALL LETTER I WITH GRAVE
     (?,Mm(B . ?\x00ED) ;; LATIN SMALL LETTER I WITH ACUTE
     (?,Mn(B . ?\x00EE) ;; LATIN SMALL LETTER I WITH CIRCUMFLEX
     (?,Mo(B . ?\x00EF) ;; LATIN SMALL LETTER I WITH DIAERESIS
     (?,Mp(B . ?\x011F) ;; LATIN SMALL LETTER G WITH BREVE
     (?,Mq(B . ?\x00F1) ;; LATIN SMALL LETTER N WITH TILDE
     (?,Mr(B . ?\x00F2) ;; LATIN SMALL LETTER O WITH GRAVE
     (?,Ms(B . ?\x00F3) ;; LATIN SMALL LETTER O WITH ACUTE
     (?,Mt(B . ?\x00F4) ;; LATIN SMALL LETTER O WITH CIRCUMFLEX
     (?,Mu(B . ?\x00F5) ;; LATIN SMALL LETTER O WITH TILDE
     (?,Mv(B . ?\x00F6) ;; LATIN SMALL LETTER O WITH DIAERESIS
     (?,Mw(B . ?\x00F7) ;; DIVISION SIGN
     (?,Mx(B . ?\x00F8) ;; LATIN SMALL LETTER O WITH STROKE
     (?,My(B . ?\x00F9) ;; LATIN SMALL LETTER U WITH GRAVE
     (?,Mz(B . ?\x00FA) ;; LATIN SMALL LETTER U WITH ACUTE
     (?,M{(B . ?\x00FB) ;; LATIN SMALL LETTER U WITH CIRCUMFLEX
     (?,M|(B . ?\x00FC) ;; LATIN SMALL LETTER U WITH DIAERESIS
     (?,M}(B . ?\x0131) ;; LATIN SMALL LETTER DOTLESS I
     (?,M~(B . ?\x015F) ;; LATIN SMALL LETTER S WITH CEDILLA
     (?,M(B . ?\x00FF) ;; LATIN SMALL LETTER Y WITH DIAERESIS
     )))

(provide 'uiso8859-9)
