; -*- coding: iso-2022-7bit  -*-
;;; ujisx0212.el --- tables between UCS and JIS X 0212

;; Keywords: CCL, mule, multilingual, 
;;           character set, coding-system, ISO10646, Unicode, JIS X 0208

;; This file is part of Mule-UCS

;; Mule-UCS is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; Mule-UCS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; This file is converted from JIX0212.TXT of Unicode consortium
;;; by Miyashita Hisashi <himi@bird.scphys.kyoto-u.ac.jp>.

(put 'japanese-jisx0212 'unicode-assoc
     'jis-x-0212-vs-unicode-assoc)

(defvar
  jis-x-0212-vs-unicode-assoc
  '(assoc
    (char-1 . ucs-generic)
    (
;----------------------------------
     (?$(D"/(B . ?\x02D8) ;; BREVE
     (?$(D"0(B . ?\x02C7) ;; CARON (Mandarin Chinese third tone)
     (?$(D"1(B . ?\x00B8) ;; CEDILLA
     (?$(D"2(B . ?\x02D9) ;; DOT ABOVE (Mandarin Chinese light tone)
     (?$(D"3(B . ?\x02DD) ;; DOUBLE ACUTE ACCENT
     (?$(D"4(B . ?\x00AF) ;; MACRON
     (?$(D"5(B . ?\x02DB) ;; OGONEK
     (?$(D"6(B . ?\x02DA) ;; RING ABOVE
     (?$(D"7(B . ?\x007E) ;; TILDE
     (?$(D"8(B . ?\x0384) ;; GREEK TONOS
     (?$(D"9(B . ?\x0385) ;; GREEK DIALYTIKA TONOS
     (?$(D"B(B . ?\x00A1) ;; INVERTED EXCLAMATION MARK
     (?$(D"C(B . ?\x00A6) ;; BROKEN BAR
     (?$(D"D(B . ?\x00BF) ;; INVERTED QUESTION MARK
     (?$(D"k(B . ?\x00BA) ;; MASCULINE ORDINAL INDICATOR
     (?$(D"l(B . ?\x00AA) ;; FEMININE ORDINAL INDICATOR
     (?$(D"m(B . ?\x00A9) ;; COPYRIGHT SIGN
     (?$(D"n(B . ?\x00AE) ;; REGISTERED SIGN
     (?$(D"o(B . ?\x2122) ;; TRADE MARK SIGN
     (?$(D"p(B . ?\x00A4) ;; CURRENCY SIGN
     (?$(D"q(B . ?\x2116) ;; NUMERO SIGN
     (?$(D&a(B . ?\x0386) ;; GREEK CAPITAL LETTER ALPHA WITH TONOS
     (?$(D&b(B . ?\x0388) ;; GREEK CAPITAL LETTER EPSILON WITH TONOS
     (?$(D&c(B . ?\x0389) ;; GREEK CAPITAL LETTER ETA WITH TONOS
     (?$(D&d(B . ?\x038A) ;; GREEK CAPITAL LETTER IOTA WITH TONOS
     (?$(D&e(B . ?\x03AA) ;; GREEK CAPITAL LETTER IOTA WITH DIALYTIKA
     (?$(D&g(B . ?\x038C) ;; GREEK CAPITAL LETTER OMICRON WITH TONOS
     (?$(D&i(B . ?\x038E) ;; GREEK CAPITAL LETTER UPSILON WITH TONOS
     (?$(D&j(B . ?\x03AB) ;; GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA
     (?$(D&l(B . ?\x038F) ;; GREEK CAPITAL LETTER OMEGA WITH TONOS
     (?$(D&q(B . ?\x03AC) ;; GREEK SMALL LETTER ALPHA WITH TONOS
     (?$(D&r(B . ?\x03AD) ;; GREEK SMALL LETTER EPSILON WITH TONOS
     (?$(D&s(B . ?\x03AE) ;; GREEK SMALL LETTER ETA WITH TONOS
     (?$(D&t(B . ?\x03AF) ;; GREEK SMALL LETTER IOTA WITH TONOS
     (?$(D&u(B . ?\x03CA) ;; GREEK SMALL LETTER IOTA WITH DIALYTIKA
     (?$(D&v(B . ?\x0390) ;; GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS
     (?$(D&w(B . ?\x03CC) ;; GREEK SMALL LETTER OMICRON WITH TONOS
     (?$(D&x(B . ?\x03C2) ;; GREEK SMALL LETTER FINAL SIGMA
     (?$(D&y(B . ?\x03CD) ;; GREEK SMALL LETTER UPSILON WITH TONOS
     (?$(D&z(B . ?\x03CB) ;; GREEK SMALL LETTER UPSILON WITH DIALYTIKA
     (?$(D&{(B . ?\x03B0) ;; GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS
     (?$(D&|(B . ?\x03CE) ;; GREEK SMALL LETTER OMEGA WITH TONOS
     (?$(D'B(B . ?\x0402) ;; CYRILLIC CAPITAL LETTER DJE
     (?$(D'C(B . ?\x0403) ;; CYRILLIC CAPITAL LETTER GJE
     (?$(D'D(B . ?\x0404) ;; CYRILLIC CAPITAL LETTER UKRAINIAN IE
     (?$(D'E(B . ?\x0405) ;; CYRILLIC CAPITAL LETTER DZE
     (?$(D'F(B . ?\x0406) ;; CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I
     (?$(D'G(B . ?\x0407) ;; CYRILLIC CAPITAL LETTER YI
     (?$(D'H(B . ?\x0408) ;; CYRILLIC CAPITAL LETTER JE
     (?$(D'I(B . ?\x0409) ;; CYRILLIC CAPITAL LETTER LJE
     (?$(D'J(B . ?\x040A) ;; CYRILLIC CAPITAL LETTER NJE
     (?$(D'K(B . ?\x040B) ;; CYRILLIC CAPITAL LETTER TSHE
     (?$(D'L(B . ?\x040C) ;; CYRILLIC CAPITAL LETTER KJE
     (?$(D'M(B . ?\x040E) ;; CYRILLIC CAPITAL LETTER SHORT U
     (?$(D'N(B . ?\x040F) ;; CYRILLIC CAPITAL LETTER DZHE
     (?$(D'r(B . ?\x0452) ;; CYRILLIC SMALL LETTER DJE
     (?$(D's(B . ?\x0453) ;; CYRILLIC SMALL LETTER GJE
     (?$(D't(B . ?\x0454) ;; CYRILLIC SMALL LETTER UKRAINIAN IE
     (?$(D'u(B . ?\x0455) ;; CYRILLIC SMALL LETTER DZE
     (?$(D'v(B . ?\x0456) ;; CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I
     (?$(D'w(B . ?\x0457) ;; CYRILLIC SMALL LETTER YI
     (?$(D'x(B . ?\x0458) ;; CYRILLIC SMALL LETTER JE
     (?$(D'y(B . ?\x0459) ;; CYRILLIC SMALL LETTER LJE
     (?$(D'z(B . ?\x045A) ;; CYRILLIC SMALL LETTER NJE
     (?$(D'{(B . ?\x045B) ;; CYRILLIC SMALL LETTER TSHE
     (?$(D'|(B . ?\x045C) ;; CYRILLIC SMALL LETTER KJE
     (?$(D'}(B . ?\x045E) ;; CYRILLIC SMALL LETTER SHORT U
     (?$(D'~(B . ?\x045F) ;; CYRILLIC SMALL LETTER DZHE
     (?$(D)!(B . ?\x00C6) ;; LATIN CAPITAL LIGATURE AE
     (?$(D)"(B . ?\x0110) ;; LATIN CAPITAL LETTER D WITH STROKE
     (?$(D)$(B . ?\x0126) ;; LATIN CAPITAL LETTER H WITH STROKE
     (?$(D)&(B . ?\x0132) ;; LATIN CAPITAL LIGATURE IJ
     (?$(D)((B . ?\x0141) ;; LATIN CAPITAL LETTER L WITH STROKE
     (?$(D))(B . ?\x013F) ;; LATIN CAPITAL LETTER L WITH MIDDLE DOT
     (?$(D)+(B . ?\x014A) ;; LATIN CAPITAL LETTER ENG
     (?$(D),(B . ?\x00D8) ;; LATIN CAPITAL LETTER O WITH STROKE
     (?$(D)-(B . ?\x0152) ;; LATIN CAPITAL LIGATURE OE
     (?$(D)/(B . ?\x0166) ;; LATIN CAPITAL LETTER T WITH STROKE
     (?$(D)0(B . ?\x00DE) ;; LATIN CAPITAL LETTER THORN
     (?$(D)A(B . ?\x00E6) ;; LATIN SMALL LIGATURE AE
     (?$(D)B(B . ?\x0111) ;; LATIN SMALL LETTER D WITH STROKE
     (?$(D)C(B . ?\x00F0) ;; LATIN SMALL LETTER ETH
     (?$(D)D(B . ?\x0127) ;; LATIN SMALL LETTER H WITH STROKE
     (?$(D)E(B . ?\x0131) ;; LATIN SMALL LETTER DOTLESS I
     (?$(D)F(B . ?\x0133) ;; LATIN SMALL LIGATURE IJ
     (?$(D)G(B . ?\x0138) ;; LATIN SMALL LETTER KRA
     (?$(D)H(B . ?\x0142) ;; LATIN SMALL LETTER L WITH STROKE
     (?$(D)I(B . ?\x0140) ;; LATIN SMALL LETTER L WITH MIDDLE DOT
     (?$(D)J(B . ?\x0149) ;; LATIN SMALL LETTER N PRECEDED BY APOSTROPHE
     (?$(D)K(B . ?\x014B) ;; LATIN SMALL LETTER ENG
     (?$(D)L(B . ?\x00F8) ;; LATIN SMALL LETTER O WITH STROKE
     (?$(D)M(B . ?\x0153) ;; LATIN SMALL LIGATURE OE
     (?$(D)N(B . ?\x00DF) ;; LATIN SMALL LETTER SHARP S
     (?$(D)O(B . ?\x0167) ;; LATIN SMALL LETTER T WITH STROKE
     (?$(D)P(B . ?\x00FE) ;; LATIN SMALL LETTER THORN
     (?$(D*!(B . ?\x00C1) ;; LATIN CAPITAL LETTER A WITH ACUTE
     (?$(D*"(B . ?\x00C0) ;; LATIN CAPITAL LETTER A WITH GRAVE
     (?$(D*#(B . ?\x00C4) ;; LATIN CAPITAL LETTER A WITH DIAERESIS
     (?$(D*$(B . ?\x00C2) ;; LATIN CAPITAL LETTER A WITH CIRCUMFLEX
     (?$(D*%(B . ?\x0102) ;; LATIN CAPITAL LETTER A WITH BREVE
     (?$(D*&(B . ?\x01CD) ;; LATIN CAPITAL LETTER A WITH CARON
     (?$(D*'(B . ?\x0100) ;; LATIN CAPITAL LETTER A WITH MACRON
     (?$(D*((B . ?\x0104) ;; LATIN CAPITAL LETTER A WITH OGONEK
     (?$(D*)(B . ?\x00C5) ;; LATIN CAPITAL LETTER A WITH RING ABOVE
     (?$(D**(B . ?\x00C3) ;; LATIN CAPITAL LETTER A WITH TILDE
     (?$(D*+(B . ?\x0106) ;; LATIN CAPITAL LETTER C WITH ACUTE
     (?$(D*,(B . ?\x0108) ;; LATIN CAPITAL LETTER C WITH CIRCUMFLEX
     (?$(D*-(B . ?\x010C) ;; LATIN CAPITAL LETTER C WITH CARON
     (?$(D*.(B . ?\x00C7) ;; LATIN CAPITAL LETTER C WITH CEDILLA
     (?$(D*/(B . ?\x010A) ;; LATIN CAPITAL LETTER C WITH DOT ABOVE
     (?$(D*0(B . ?\x010E) ;; LATIN CAPITAL LETTER D WITH CARON
     (?$(D*1(B . ?\x00C9) ;; LATIN CAPITAL LETTER E WITH ACUTE
     (?$(D*2(B . ?\x00C8) ;; LATIN CAPITAL LETTER E WITH GRAVE
     (?$(D*3(B . ?\x00CB) ;; LATIN CAPITAL LETTER E WITH DIAERESIS
     (?$(D*4(B . ?\x00CA) ;; LATIN CAPITAL LETTER E WITH CIRCUMFLEX
     (?$(D*5(B . ?\x011A) ;; LATIN CAPITAL LETTER E WITH CARON
     (?$(D*6(B . ?\x0116) ;; LATIN CAPITAL LETTER E WITH DOT ABOVE
     (?$(D*7(B . ?\x0112) ;; LATIN CAPITAL LETTER E WITH MACRON
     (?$(D*8(B . ?\x0118) ;; LATIN CAPITAL LETTER E WITH OGONEK
     (?$(D*:(B . ?\x011C) ;; LATIN CAPITAL LETTER G WITH CIRCUMFLEX
     (?$(D*;(B . ?\x011E) ;; LATIN CAPITAL LETTER G WITH BREVE
     (?$(D*<(B . ?\x0122) ;; LATIN CAPITAL LETTER G WITH CEDILLA
     (?$(D*=(B . ?\x0120) ;; LATIN CAPITAL LETTER G WITH DOT ABOVE
     (?$(D*>(B . ?\x0124) ;; LATIN CAPITAL LETTER H WITH CIRCUMFLEX
     (?$(D*?(B . ?\x00CD) ;; LATIN CAPITAL LETTER I WITH ACUTE
     (?$(D*@(B . ?\x00CC) ;; LATIN CAPITAL LETTER I WITH GRAVE
     (?$(D*A(B . ?\x00CF) ;; LATIN CAPITAL LETTER I WITH DIAERESIS
     (?$(D*B(B . ?\x00CE) ;; LATIN CAPITAL LETTER I WITH CIRCUMFLEX
     (?$(D*C(B . ?\x01CF) ;; LATIN CAPITAL LETTER I WITH CARON
     (?$(D*D(B . ?\x0130) ;; LATIN CAPITAL LETTER I WITH DOT ABOVE
     (?$(D*E(B . ?\x012A) ;; LATIN CAPITAL LETTER I WITH MACRON
     (?$(D*F(B . ?\x012E) ;; LATIN CAPITAL LETTER I WITH OGONEK
     (?$(D*G(B . ?\x0128) ;; LATIN CAPITAL LETTER I WITH TILDE
     (?$(D*H(B . ?\x0134) ;; LATIN CAPITAL LETTER J WITH CIRCUMFLEX
     (?$(D*I(B . ?\x0136) ;; LATIN CAPITAL LETTER K WITH CEDILLA
     (?$(D*J(B . ?\x0139) ;; LATIN CAPITAL LETTER L WITH ACUTE
     (?$(D*K(B . ?\x013D) ;; LATIN CAPITAL LETTER L WITH CARON
     (?$(D*L(B . ?\x013B) ;; LATIN CAPITAL LETTER L WITH CEDILLA
     (?$(D*M(B . ?\x0143) ;; LATIN CAPITAL LETTER N WITH ACUTE
     (?$(D*N(B . ?\x0147) ;; LATIN CAPITAL LETTER N WITH CARON
     (?$(D*O(B . ?\x0145) ;; LATIN CAPITAL LETTER N WITH CEDILLA
     (?$(D*P(B . ?\x00D1) ;; LATIN CAPITAL LETTER N WITH TILDE
     (?$(D*Q(B . ?\x00D3) ;; LATIN CAPITAL LETTER O WITH ACUTE
     (?$(D*R(B . ?\x00D2) ;; LATIN CAPITAL LETTER O WITH GRAVE
     (?$(D*S(B . ?\x00D6) ;; LATIN CAPITAL LETTER O WITH DIAERESIS
     (?$(D*T(B . ?\x00D4) ;; LATIN CAPITAL LETTER O WITH CIRCUMFLEX
     (?$(D*U(B . ?\x01D1) ;; LATIN CAPITAL LETTER O WITH CARON
     (?$(D*V(B . ?\x0150) ;; LATIN CAPITAL LETTER O WITH DOUBLE ACUTE
     (?$(D*W(B . ?\x014C) ;; LATIN CAPITAL LETTER O WITH MACRON
     (?$(D*X(B . ?\x00D5) ;; LATIN CAPITAL LETTER O WITH TILDE
     (?$(D*Y(B . ?\x0154) ;; LATIN CAPITAL LETTER R WITH ACUTE
     (?$(D*Z(B . ?\x0158) ;; LATIN CAPITAL LETTER R WITH CARON
     (?$(D*[(B . ?\x0156) ;; LATIN CAPITAL LETTER R WITH CEDILLA
     (?$(D*\(B . ?\x015A) ;; LATIN CAPITAL LETTER S WITH ACUTE
     (?$(D*](B . ?\x015C) ;; LATIN CAPITAL LETTER S WITH CIRCUMFLEX
     (?$(D*^(B . ?\x0160) ;; LATIN CAPITAL LETTER S WITH CARON
     (?$(D*_(B . ?\x015E) ;; LATIN CAPITAL LETTER S WITH CEDILLA
     (?$(D*`(B . ?\x0164) ;; LATIN CAPITAL LETTER T WITH CARON
     (?$(D*a(B . ?\x0162) ;; LATIN CAPITAL LETTER T WITH CEDILLA
     (?$(D*b(B . ?\x00DA) ;; LATIN CAPITAL LETTER U WITH ACUTE
     (?$(D*c(B . ?\x00D9) ;; LATIN CAPITAL LETTER U WITH GRAVE
     (?$(D*d(B . ?\x00DC) ;; LATIN CAPITAL LETTER U WITH DIAERESIS
     (?$(D*e(B . ?\x00DB) ;; LATIN CAPITAL LETTER U WITH CIRCUMFLEX
     (?$(D*f(B . ?\x016C) ;; LATIN CAPITAL LETTER U WITH BREVE
     (?$(D*g(B . ?\x01D3) ;; LATIN CAPITAL LETTER U WITH CARON
     (?$(D*h(B . ?\x0170) ;; LATIN CAPITAL LETTER U WITH DOUBLE ACUTE
     (?$(D*i(B . ?\x016A) ;; LATIN CAPITAL LETTER U WITH MACRON
     (?$(D*j(B . ?\x0172) ;; LATIN CAPITAL LETTER U WITH OGONEK
     (?$(D*k(B . ?\x016E) ;; LATIN CAPITAL LETTER U WITH RING ABOVE
     (?$(D*l(B . ?\x0168) ;; LATIN CAPITAL LETTER U WITH TILDE
     (?$(D*m(B . ?\x01D7) ;; LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE
     (?$(D*n(B . ?\x01DB) ;; LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE
     (?$(D*o(B . ?\x01D9) ;; LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON
     (?$(D*p(B . ?\x01D5) ;; LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON
     (?$(D*q(B . ?\x0174) ;; LATIN CAPITAL LETTER W WITH CIRCUMFLEX
     (?$(D*r(B . ?\x00DD) ;; LATIN CAPITAL LETTER Y WITH ACUTE
     (?$(D*s(B . ?\x0178) ;; LATIN CAPITAL LETTER Y WITH DIAERESIS
     (?$(D*t(B . ?\x0176) ;; LATIN CAPITAL LETTER Y WITH CIRCUMFLEX
     (?$(D*u(B . ?\x0179) ;; LATIN CAPITAL LETTER Z WITH ACUTE
     (?$(D*v(B . ?\x017D) ;; LATIN CAPITAL LETTER Z WITH CARON
     (?$(D*w(B . ?\x017B) ;; LATIN CAPITAL LETTER Z WITH DOT ABOVE
     (?$(D+!(B . ?\x00E1) ;; LATIN SMALL LETTER A WITH ACUTE
     (?$(D+"(B . ?\x00E0) ;; LATIN SMALL LETTER A WITH GRAVE
     (?$(D+#(B . ?\x00E4) ;; LATIN SMALL LETTER A WITH DIAERESIS
     (?$(D+$(B . ?\x00E2) ;; LATIN SMALL LETTER A WITH CIRCUMFLEX
     (?$(D+%(B . ?\x0103) ;; LATIN SMALL LETTER A WITH BREVE
     (?$(D+&(B . ?\x01CE) ;; LATIN SMALL LETTER A WITH CARON
     (?$(D+'(B . ?\x0101) ;; LATIN SMALL LETTER A WITH MACRON
     (?$(D+((B . ?\x0105) ;; LATIN SMALL LETTER A WITH OGONEK
     (?$(D+)(B . ?\x00E5) ;; LATIN SMALL LETTER A WITH RING ABOVE
     (?$(D+*(B . ?\x00E3) ;; LATIN SMALL LETTER A WITH TILDE
     (?$(D++(B . ?\x0107) ;; LATIN SMALL LETTER C WITH ACUTE
     (?$(D+,(B . ?\x0109) ;; LATIN SMALL LETTER C WITH CIRCUMFLEX
     (?$(D+-(B . ?\x010D) ;; LATIN SMALL LETTER C WITH CARON
     (?$(D+.(B . ?\x00E7) ;; LATIN SMALL LETTER C WITH CEDILLA
     (?$(D+/(B . ?\x010B) ;; LATIN SMALL LETTER C WITH DOT ABOVE
     (?$(D+0(B . ?\x010F) ;; LATIN SMALL LETTER D WITH CARON
     (?$(D+1(B . ?\x00E9) ;; LATIN SMALL LETTER E WITH ACUTE
     (?$(D+2(B . ?\x00E8) ;; LATIN SMALL LETTER E WITH GRAVE
     (?$(D+3(B . ?\x00EB) ;; LATIN SMALL LETTER E WITH DIAERESIS
     (?$(D+4(B . ?\x00EA) ;; LATIN SMALL LETTER E WITH CIRCUMFLEX
     (?$(D+5(B . ?\x011B) ;; LATIN SMALL LETTER E WITH CARON
     (?$(D+6(B . ?\x0117) ;; LATIN SMALL LETTER E WITH DOT ABOVE
     (?$(D+7(B . ?\x0113) ;; LATIN SMALL LETTER E WITH MACRON
     (?$(D+8(B . ?\x0119) ;; LATIN SMALL LETTER E WITH OGONEK
     (?$(D+9(B . ?\x01F5) ;; LATIN SMALL LETTER G WITH ACUTE
     (?$(D+:(B . ?\x011D) ;; LATIN SMALL LETTER G WITH CIRCUMFLEX
     (?$(D+;(B . ?\x011F) ;; LATIN SMALL LETTER G WITH BREVE
     (?$(D+=(B . ?\x0121) ;; LATIN SMALL LETTER G WITH DOT ABOVE
     (?$(D+>(B . ?\x0125) ;; LATIN SMALL LETTER H WITH CIRCUMFLEX
     (?$(D+?(B . ?\x00ED) ;; LATIN SMALL LETTER I WITH ACUTE
     (?$(D+@(B . ?\x00EC) ;; LATIN SMALL LETTER I WITH GRAVE
     (?$(D+A(B . ?\x00EF) ;; LATIN SMALL LETTER I WITH DIAERESIS
     (?$(D+B(B . ?\x00EE) ;; LATIN SMALL LETTER I WITH CIRCUMFLEX
     (?$(D+C(B . ?\x01D0) ;; LATIN SMALL LETTER I WITH CARON
     (?$(D+E(B . ?\x012B) ;; LATIN SMALL LETTER I WITH MACRON
     (?$(D+F(B . ?\x012F) ;; LATIN SMALL LETTER I WITH OGONEK
     (?$(D+G(B . ?\x0129) ;; LATIN SMALL LETTER I WITH TILDE
     (?$(D+H(B . ?\x0135) ;; LATIN SMALL LETTER J WITH CIRCUMFLEX
     (?$(D+I(B . ?\x0137) ;; LATIN SMALL LETTER K WITH CEDILLA
     (?$(D+J(B . ?\x013A) ;; LATIN SMALL LETTER L WITH ACUTE
     (?$(D+K(B . ?\x013E) ;; LATIN SMALL LETTER L WITH CARON
     (?$(D+L(B . ?\x013C) ;; LATIN SMALL LETTER L WITH CEDILLA
     (?$(D+M(B . ?\x0144) ;; LATIN SMALL LETTER N WITH ACUTE
     (?$(D+N(B . ?\x0148) ;; LATIN SMALL LETTER N WITH CARON
     (?$(D+O(B . ?\x0146) ;; LATIN SMALL LETTER N WITH CEDILLA
     (?$(D+P(B . ?\x00F1) ;; LATIN SMALL LETTER N WITH TILDE
     (?$(D+Q(B . ?\x00F3) ;; LATIN SMALL LETTER O WITH ACUTE
     (?$(D+R(B . ?\x00F2) ;; LATIN SMALL LETTER O WITH GRAVE
     (?$(D+S(B . ?\x00F6) ;; LATIN SMALL LETTER O WITH DIAERESIS
     (?$(D+T(B . ?\x00F4) ;; LATIN SMALL LETTER O WITH CIRCUMFLEX
     (?$(D+U(B . ?\x01D2) ;; LATIN SMALL LETTER O WITH CARON
     (?$(D+V(B . ?\x0151) ;; LATIN SMALL LETTER O WITH DOUBLE ACUTE
     (?$(D+W(B . ?\x014D) ;; LATIN SMALL LETTER O WITH MACRON
     (?$(D+X(B . ?\x00F5) ;; LATIN SMALL LETTER O WITH TILDE
     (?$(D+Y(B . ?\x0155) ;; LATIN SMALL LETTER R WITH ACUTE
     (?$(D+Z(B . ?\x0159) ;; LATIN SMALL LETTER R WITH CARON
     (?$(D+[(B . ?\x0157) ;; LATIN SMALL LETTER R WITH CEDILLA
     (?$(D+\(B . ?\x015B) ;; LATIN SMALL LETTER S WITH ACUTE
     (?$(D+](B . ?\x015D) ;; LATIN SMALL LETTER S WITH CIRCUMFLEX
     (?$(D+^(B . ?\x0161) ;; LATIN SMALL LETTER S WITH CARON
     (?$(D+_(B . ?\x015F) ;; LATIN SMALL LETTER S WITH CEDILLA
     (?$(D+`(B . ?\x0165) ;; LATIN SMALL LETTER T WITH CARON
     (?$(D+a(B . ?\x0163) ;; LATIN SMALL LETTER T WITH CEDILLA
     (?$(D+b(B . ?\x00FA) ;; LATIN SMALL LETTER U WITH ACUTE
     (?$(D+c(B . ?\x00F9) ;; LATIN SMALL LETTER U WITH GRAVE
     (?$(D+d(B . ?\x00FC) ;; LATIN SMALL LETTER U WITH DIAERESIS
     (?$(D+e(B . ?\x00FB) ;; LATIN SMALL LETTER U WITH CIRCUMFLEX
     (?$(D+f(B . ?\x016D) ;; LATIN SMALL LETTER U WITH BREVE
     (?$(D+g(B . ?\x01D4) ;; LATIN SMALL LETTER U WITH CARON
     (?$(D+h(B . ?\x0171) ;; LATIN SMALL LETTER U WITH DOUBLE ACUTE
     (?$(D+i(B . ?\x016B) ;; LATIN SMALL LETTER U WITH MACRON
     (?$(D+j(B . ?\x0173) ;; LATIN SMALL LETTER U WITH OGONEK
     (?$(D+k(B . ?\x016F) ;; LATIN SMALL LETTER U WITH RING ABOVE
     (?$(D+l(B . ?\x0169) ;; LATIN SMALL LETTER U WITH TILDE
     (?$(D+m(B . ?\x01D8) ;; LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE
     (?$(D+n(B . ?\x01DC) ;; LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE
     (?$(D+o(B . ?\x01DA) ;; LATIN SMALL LETTER U WITH DIAERESIS AND CARON
     (?$(D+p(B . ?\x01D6) ;; LATIN SMALL LETTER U WITH DIAERESIS AND MACRON
     (?$(D+q(B . ?\x0175) ;; LATIN SMALL LETTER W WITH CIRCUMFLEX
     (?$(D+r(B . ?\x00FD) ;; LATIN SMALL LETTER Y WITH ACUTE
     (?$(D+s(B . ?\x00FF) ;; LATIN SMALL LETTER Y WITH DIAERESIS
     (?$(D+t(B . ?\x0177) ;; LATIN SMALL LETTER Y WITH CIRCUMFLEX
     (?$(D+u(B . ?\x017A) ;; LATIN SMALL LETTER Z WITH ACUTE
     (?$(D+v(B . ?\x017E) ;; LATIN SMALL LETTER Z WITH CARON
     (?$(D+w(B . ?\x017C) ;; LATIN SMALL LETTER Z WITH DOT ABOVE
 ;----------------------------------
     (?$(D0!(B . ?\x4E02) ;; <CJK>
     (?$(D0"(B . ?\x4E04) ;; <CJK>
     (?$(D0#(B . ?\x4E05) ;; <CJK>
     (?$(D0$(B . ?\x4E0C) ;; <CJK>
     (?$(D0%(B . ?\x4E12) ;; <CJK>
     (?$(D0&(B . ?\x4E1F) ;; <CJK>
     (?$(D0'(B . ?\x4E23) ;; <CJK>
     (?$(D0((B . ?\x4E24) ;; <CJK>
     (?$(D0)(B . ?\x4E28) ;; <CJK>
     (?$(D0*(B . ?\x4E2B) ;; <CJK>
     (?$(D0+(B . ?\x4E2E) ;; <CJK>
     (?$(D0,(B . ?\x4E2F) ;; <CJK>
     (?$(D0-(B . ?\x4E30) ;; <CJK>
     (?$(D0.(B . ?\x4E35) ;; <CJK>
     (?$(D0/(B . ?\x4E40) ;; <CJK>
     (?$(D00(B . ?\x4E41) ;; <CJK>
     (?$(D01(B . ?\x4E44) ;; <CJK>
     (?$(D02(B . ?\x4E47) ;; <CJK>
     (?$(D03(B . ?\x4E51) ;; <CJK>
     (?$(D04(B . ?\x4E5A) ;; <CJK>
     (?$(D05(B . ?\x4E5C) ;; <CJK>
     (?$(D06(B . ?\x4E63) ;; <CJK>
     (?$(D07(B . ?\x4E68) ;; <CJK>
     (?$(D08(B . ?\x4E69) ;; <CJK>
     (?$(D09(B . ?\x4E74) ;; <CJK>
     (?$(D0:(B . ?\x4E75) ;; <CJK>
     (?$(D0;(B . ?\x4E79) ;; <CJK>
     (?$(D0<(B . ?\x4E7F) ;; <CJK>
     (?$(D0=(B . ?\x4E8D) ;; <CJK>
     (?$(D0>(B . ?\x4E96) ;; <CJK>
     (?$(D0?(B . ?\x4E97) ;; <CJK>
     (?$(D0@(B . ?\x4E9D) ;; <CJK>
     (?$(D0A(B . ?\x4EAF) ;; <CJK>
     (?$(D0B(B . ?\x4EB9) ;; <CJK>
     (?$(D0C(B . ?\x4EC3) ;; <CJK>
     (?$(D0D(B . ?\x4ED0) ;; <CJK>
     (?$(D0E(B . ?\x4EDA) ;; <CJK>
     (?$(D0F(B . ?\x4EDB) ;; <CJK>
     (?$(D0G(B . ?\x4EE0) ;; <CJK>
     (?$(D0H(B . ?\x4EE1) ;; <CJK>
     (?$(D0I(B . ?\x4EE2) ;; <CJK>
     (?$(D0J(B . ?\x4EE8) ;; <CJK>
     (?$(D0K(B . ?\x4EEF) ;; <CJK>
     (?$(D0L(B . ?\x4EF1) ;; <CJK>
     (?$(D0M(B . ?\x4EF3) ;; <CJK>
     (?$(D0N(B . ?\x4EF5) ;; <CJK>
     (?$(D0O(B . ?\x4EFD) ;; <CJK>
     (?$(D0P(B . ?\x4EFE) ;; <CJK>
     (?$(D0Q(B . ?\x4EFF) ;; <CJK>
     (?$(D0R(B . ?\x4F00) ;; <CJK>
     (?$(D0S(B . ?\x4F02) ;; <CJK>
     (?$(D0T(B . ?\x4F03) ;; <CJK>
     (?$(D0U(B . ?\x4F08) ;; <CJK>
     (?$(D0V(B . ?\x4F0B) ;; <CJK>
     (?$(D0W(B . ?\x4F0C) ;; <CJK>
     (?$(D0X(B . ?\x4F12) ;; <CJK>
     (?$(D0Y(B . ?\x4F15) ;; <CJK>
     (?$(D0Z(B . ?\x4F16) ;; <CJK>
     (?$(D0[(B . ?\x4F17) ;; <CJK>
     (?$(D0\(B . ?\x4F19) ;; <CJK>
     (?$(D0](B . ?\x4F2E) ;; <CJK>
     (?$(D0^(B . ?\x4F31) ;; <CJK>
     (?$(D0_(B . ?\x4F60) ;; <CJK>
     (?$(D0`(B . ?\x4F33) ;; <CJK>
     (?$(D0a(B . ?\x4F35) ;; <CJK>
     (?$(D0b(B . ?\x4F37) ;; <CJK>
     (?$(D0c(B . ?\x4F39) ;; <CJK>
     (?$(D0d(B . ?\x4F3B) ;; <CJK>
     (?$(D0e(B . ?\x4F3E) ;; <CJK>
     (?$(D0f(B . ?\x4F40) ;; <CJK>
     (?$(D0g(B . ?\x4F42) ;; <CJK>
     (?$(D0h(B . ?\x4F48) ;; <CJK>
     (?$(D0i(B . ?\x4F49) ;; <CJK>
     (?$(D0j(B . ?\x4F4B) ;; <CJK>
     (?$(D0k(B . ?\x4F4C) ;; <CJK>
     (?$(D0l(B . ?\x4F52) ;; <CJK>
     (?$(D0m(B . ?\x4F54) ;; <CJK>
     (?$(D0n(B . ?\x4F56) ;; <CJK>
     (?$(D0o(B . ?\x4F58) ;; <CJK>
     (?$(D0p(B . ?\x4F5F) ;; <CJK>
     (?$(D0q(B . ?\x4F63) ;; <CJK>
     (?$(D0r(B . ?\x4F6A) ;; <CJK>
     (?$(D0s(B . ?\x4F6C) ;; <CJK>
     (?$(D0t(B . ?\x4F6E) ;; <CJK>
     (?$(D0u(B . ?\x4F71) ;; <CJK>
     (?$(D0v(B . ?\x4F77) ;; <CJK>
     (?$(D0w(B . ?\x4F78) ;; <CJK>
     (?$(D0x(B . ?\x4F79) ;; <CJK>
     (?$(D0y(B . ?\x4F7A) ;; <CJK>
     (?$(D0z(B . ?\x4F7D) ;; <CJK>
     (?$(D0{(B . ?\x4F7E) ;; <CJK>
     (?$(D0|(B . ?\x4F81) ;; <CJK>
     (?$(D0}(B . ?\x4F82) ;; <CJK>
     (?$(D0~(B . ?\x4F84) ;; <CJK>
     (?$(D1!(B . ?\x4F85) ;; <CJK>
     (?$(D1"(B . ?\x4F89) ;; <CJK>
     (?$(D1#(B . ?\x4F8A) ;; <CJK>
     (?$(D1$(B . ?\x4F8C) ;; <CJK>
     (?$(D1%(B . ?\x4F8E) ;; <CJK>
     (?$(D1&(B . ?\x4F90) ;; <CJK>
     (?$(D1'(B . ?\x4F92) ;; <CJK>
     (?$(D1((B . ?\x4F93) ;; <CJK>
     (?$(D1)(B . ?\x4F94) ;; <CJK>
     (?$(D1*(B . ?\x4F97) ;; <CJK>
     (?$(D1+(B . ?\x4F99) ;; <CJK>
     (?$(D1,(B . ?\x4F9A) ;; <CJK>
     (?$(D1-(B . ?\x4F9E) ;; <CJK>
     (?$(D1.(B . ?\x4F9F) ;; <CJK>
     (?$(D1/(B . ?\x4FB2) ;; <CJK>
     (?$(D10(B . ?\x4FB7) ;; <CJK>
     (?$(D11(B . ?\x4FB9) ;; <CJK>
     (?$(D12(B . ?\x4FBB) ;; <CJK>
     (?$(D13(B . ?\x4FBC) ;; <CJK>
     (?$(D14(B . ?\x4FBD) ;; <CJK>
     (?$(D15(B . ?\x4FBE) ;; <CJK>
     (?$(D16(B . ?\x4FC0) ;; <CJK>
     (?$(D17(B . ?\x4FC1) ;; <CJK>
     (?$(D18(B . ?\x4FC5) ;; <CJK>
     (?$(D19(B . ?\x4FC6) ;; <CJK>
     (?$(D1:(B . ?\x4FC8) ;; <CJK>
     (?$(D1;(B . ?\x4FC9) ;; <CJK>
     (?$(D1<(B . ?\x4FCB) ;; <CJK>
     (?$(D1=(B . ?\x4FCC) ;; <CJK>
     (?$(D1>(B . ?\x4FCD) ;; <CJK>
     (?$(D1?(B . ?\x4FCF) ;; <CJK>
     (?$(D1@(B . ?\x4FD2) ;; <CJK>
     (?$(D1A(B . ?\x4FDC) ;; <CJK>
     (?$(D1B(B . ?\x4FE0) ;; <CJK>
     (?$(D1C(B . ?\x4FE2) ;; <CJK>
     (?$(D1D(B . ?\x4FF0) ;; <CJK>
     (?$(D1E(B . ?\x4FF2) ;; <CJK>
     (?$(D1F(B . ?\x4FFC) ;; <CJK>
     (?$(D1G(B . ?\x4FFD) ;; <CJK>
     (?$(D1H(B . ?\x4FFF) ;; <CJK>
     (?$(D1I(B . ?\x5000) ;; <CJK>
     (?$(D1J(B . ?\x5001) ;; <CJK>
     (?$(D1K(B . ?\x5004) ;; <CJK>
     (?$(D1L(B . ?\x5007) ;; <CJK>
     (?$(D1M(B . ?\x500A) ;; <CJK>
     (?$(D1N(B . ?\x500C) ;; <CJK>
     (?$(D1O(B . ?\x500E) ;; <CJK>
     (?$(D1P(B . ?\x5010) ;; <CJK>
     (?$(D1Q(B . ?\x5013) ;; <CJK>
     (?$(D1R(B . ?\x5017) ;; <CJK>
     (?$(D1S(B . ?\x5018) ;; <CJK>
     (?$(D1T(B . ?\x501B) ;; <CJK>
     (?$(D1U(B . ?\x501C) ;; <CJK>
     (?$(D1V(B . ?\x501D) ;; <CJK>
     (?$(D1W(B . ?\x501E) ;; <CJK>
     (?$(D1X(B . ?\x5022) ;; <CJK>
     (?$(D1Y(B . ?\x5027) ;; <CJK>
     (?$(D1Z(B . ?\x502E) ;; <CJK>
     (?$(D1[(B . ?\x5030) ;; <CJK>
     (?$(D1\(B . ?\x5032) ;; <CJK>
     (?$(D1](B . ?\x5033) ;; <CJK>
     (?$(D1^(B . ?\x5035) ;; <CJK>
     (?$(D1_(B . ?\x5040) ;; <CJK>
     (?$(D1`(B . ?\x5041) ;; <CJK>
     (?$(D1a(B . ?\x5042) ;; <CJK>
     (?$(D1b(B . ?\x5045) ;; <CJK>
     (?$(D1c(B . ?\x5046) ;; <CJK>
     (?$(D1d(B . ?\x504A) ;; <CJK>
     (?$(D1e(B . ?\x504C) ;; <CJK>
     (?$(D1f(B . ?\x504E) ;; <CJK>
     (?$(D1g(B . ?\x5051) ;; <CJK>
     (?$(D1h(B . ?\x5052) ;; <CJK>
     (?$(D1i(B . ?\x5053) ;; <CJK>
     (?$(D1j(B . ?\x5057) ;; <CJK>
     (?$(D1k(B . ?\x5059) ;; <CJK>
     (?$(D1l(B . ?\x505F) ;; <CJK>
     (?$(D1m(B . ?\x5060) ;; <CJK>
     (?$(D1n(B . ?\x5062) ;; <CJK>
     (?$(D1o(B . ?\x5063) ;; <CJK>
     (?$(D1p(B . ?\x5066) ;; <CJK>
     (?$(D1q(B . ?\x5067) ;; <CJK>
     (?$(D1r(B . ?\x506A) ;; <CJK>
     (?$(D1s(B . ?\x506D) ;; <CJK>
     (?$(D1t(B . ?\x5070) ;; <CJK>
     (?$(D1u(B . ?\x5071) ;; <CJK>
     (?$(D1v(B . ?\x503B) ;; <CJK>
     (?$(D1w(B . ?\x5081) ;; <CJK>
     (?$(D1x(B . ?\x5083) ;; <CJK>
     (?$(D1y(B . ?\x5084) ;; <CJK>
     (?$(D1z(B . ?\x5086) ;; <CJK>
     (?$(D1{(B . ?\x508A) ;; <CJK>
     (?$(D1|(B . ?\x508E) ;; <CJK>
     (?$(D1}(B . ?\x508F) ;; <CJK>
     (?$(D1~(B . ?\x5090) ;; <CJK>
     (?$(D2!(B . ?\x5092) ;; <CJK>
     (?$(D2"(B . ?\x5093) ;; <CJK>
     (?$(D2#(B . ?\x5094) ;; <CJK>
     (?$(D2$(B . ?\x5096) ;; <CJK>
     (?$(D2%(B . ?\x509B) ;; <CJK>
     (?$(D2&(B . ?\x509C) ;; <CJK>
     (?$(D2'(B . ?\x509E) ;; <CJK>
     (?$(D2((B . ?\x509F) ;; <CJK>
     (?$(D2)(B . ?\x50A0) ;; <CJK>
     (?$(D2*(B . ?\x50A1) ;; <CJK>
     (?$(D2+(B . ?\x50A2) ;; <CJK>
     (?$(D2,(B . ?\x50AA) ;; <CJK>
     (?$(D2-(B . ?\x50AF) ;; <CJK>
     (?$(D2.(B . ?\x50B0) ;; <CJK>
     (?$(D2/(B . ?\x50B9) ;; <CJK>
     (?$(D20(B . ?\x50BA) ;; <CJK>
     (?$(D21(B . ?\x50BD) ;; <CJK>
     (?$(D22(B . ?\x50C0) ;; <CJK>
     (?$(D23(B . ?\x50C3) ;; <CJK>
     (?$(D24(B . ?\x50C4) ;; <CJK>
     (?$(D25(B . ?\x50C7) ;; <CJK>
     (?$(D26(B . ?\x50CC) ;; <CJK>
     (?$(D27(B . ?\x50CE) ;; <CJK>
     (?$(D28(B . ?\x50D0) ;; <CJK>
     (?$(D29(B . ?\x50D3) ;; <CJK>
     (?$(D2:(B . ?\x50D4) ;; <CJK>
     (?$(D2;(B . ?\x50D8) ;; <CJK>
     (?$(D2<(B . ?\x50DC) ;; <CJK>
     (?$(D2=(B . ?\x50DD) ;; <CJK>
     (?$(D2>(B . ?\x50DF) ;; <CJK>
     (?$(D2?(B . ?\x50E2) ;; <CJK>
     (?$(D2@(B . ?\x50E4) ;; <CJK>
     (?$(D2A(B . ?\x50E6) ;; <CJK>
     (?$(D2B(B . ?\x50E8) ;; <CJK>
     (?$(D2C(B . ?\x50E9) ;; <CJK>
     (?$(D2D(B . ?\x50EF) ;; <CJK>
     (?$(D2E(B . ?\x50F1) ;; <CJK>
     (?$(D2F(B . ?\x50F6) ;; <CJK>
     (?$(D2G(B . ?\x50FA) ;; <CJK>
     (?$(D2H(B . ?\x50FE) ;; <CJK>
     (?$(D2I(B . ?\x5103) ;; <CJK>
     (?$(D2J(B . ?\x5106) ;; <CJK>
     (?$(D2K(B . ?\x5107) ;; <CJK>
     (?$(D2L(B . ?\x5108) ;; <CJK>
     (?$(D2M(B . ?\x510B) ;; <CJK>
     (?$(D2N(B . ?\x510C) ;; <CJK>
     (?$(D2O(B . ?\x510D) ;; <CJK>
     (?$(D2P(B . ?\x510E) ;; <CJK>
     (?$(D2Q(B . ?\x50F2) ;; <CJK>
     (?$(D2R(B . ?\x5110) ;; <CJK>
     (?$(D2S(B . ?\x5117) ;; <CJK>
     (?$(D2T(B . ?\x5119) ;; <CJK>
     (?$(D2U(B . ?\x511B) ;; <CJK>
     (?$(D2V(B . ?\x511C) ;; <CJK>
     (?$(D2W(B . ?\x511D) ;; <CJK>
     (?$(D2X(B . ?\x511E) ;; <CJK>
     (?$(D2Y(B . ?\x5123) ;; <CJK>
     (?$(D2Z(B . ?\x5127) ;; <CJK>
     (?$(D2[(B . ?\x5128) ;; <CJK>
     (?$(D2\(B . ?\x512C) ;; <CJK>
     (?$(D2](B . ?\x512D) ;; <CJK>
     (?$(D2^(B . ?\x512F) ;; <CJK>
     (?$(D2_(B . ?\x5131) ;; <CJK>
     (?$(D2`(B . ?\x5133) ;; <CJK>
     (?$(D2a(B . ?\x5134) ;; <CJK>
     (?$(D2b(B . ?\x5135) ;; <CJK>
     (?$(D2c(B . ?\x5138) ;; <CJK>
     (?$(D2d(B . ?\x5139) ;; <CJK>
     (?$(D2e(B . ?\x5142) ;; <CJK>
     (?$(D2f(B . ?\x514A) ;; <CJK>
     (?$(D2g(B . ?\x514F) ;; <CJK>
     (?$(D2h(B . ?\x5153) ;; <CJK>
     (?$(D2i(B . ?\x5155) ;; <CJK>
     (?$(D2j(B . ?\x5157) ;; <CJK>
     (?$(D2k(B . ?\x5158) ;; <CJK>
     (?$(D2l(B . ?\x515F) ;; <CJK>
     (?$(D2m(B . ?\x5164) ;; <CJK>
     (?$(D2n(B . ?\x5166) ;; <CJK>
     (?$(D2o(B . ?\x517E) ;; <CJK>
     (?$(D2p(B . ?\x5183) ;; <CJK>
     (?$(D2q(B . ?\x5184) ;; <CJK>
     (?$(D2r(B . ?\x518B) ;; <CJK>
     (?$(D2s(B . ?\x518E) ;; <CJK>
     (?$(D2t(B . ?\x5198) ;; <CJK>
     (?$(D2u(B . ?\x519D) ;; <CJK>
     (?$(D2v(B . ?\x51A1) ;; <CJK>
     (?$(D2w(B . ?\x51A3) ;; <CJK>
     (?$(D2x(B . ?\x51AD) ;; <CJK>
     (?$(D2y(B . ?\x51B8) ;; <CJK>
     (?$(D2z(B . ?\x51BA) ;; <CJK>
     (?$(D2{(B . ?\x51BC) ;; <CJK>
     (?$(D2|(B . ?\x51BE) ;; <CJK>
     (?$(D2}(B . ?\x51BF) ;; <CJK>
     (?$(D2~(B . ?\x51C2) ;; <CJK>
     (?$(D3!(B . ?\x51C8) ;; <CJK>
     (?$(D3"(B . ?\x51CF) ;; <CJK>
     (?$(D3#(B . ?\x51D1) ;; <CJK>
     (?$(D3$(B . ?\x51D2) ;; <CJK>
     (?$(D3%(B . ?\x51D3) ;; <CJK>
     (?$(D3&(B . ?\x51D5) ;; <CJK>
     (?$(D3'(B . ?\x51D8) ;; <CJK>
     (?$(D3((B . ?\x51DE) ;; <CJK>
     (?$(D3)(B . ?\x51E2) ;; <CJK>
     (?$(D3*(B . ?\x51E5) ;; <CJK>
     (?$(D3+(B . ?\x51EE) ;; <CJK>
     (?$(D3,(B . ?\x51F2) ;; <CJK>
     (?$(D3-(B . ?\x51F3) ;; <CJK>
     (?$(D3.(B . ?\x51F4) ;; <CJK>
     (?$(D3/(B . ?\x51F7) ;; <CJK>
     (?$(D30(B . ?\x5201) ;; <CJK>
     (?$(D31(B . ?\x5202) ;; <CJK>
     (?$(D32(B . ?\x5205) ;; <CJK>
     (?$(D33(B . ?\x5212) ;; <CJK>
     (?$(D34(B . ?\x5213) ;; <CJK>
     (?$(D35(B . ?\x5215) ;; <CJK>
     (?$(D36(B . ?\x5216) ;; <CJK>
     (?$(D37(B . ?\x5218) ;; <CJK>
     (?$(D38(B . ?\x5222) ;; <CJK>
     (?$(D39(B . ?\x5228) ;; <CJK>
     (?$(D3:(B . ?\x5231) ;; <CJK>
     (?$(D3;(B . ?\x5232) ;; <CJK>
     (?$(D3<(B . ?\x5235) ;; <CJK>
     (?$(D3=(B . ?\x523C) ;; <CJK>
     (?$(D3>(B . ?\x5245) ;; <CJK>
     (?$(D3?(B . ?\x5249) ;; <CJK>
     (?$(D3@(B . ?\x5255) ;; <CJK>
     (?$(D3A(B . ?\x5257) ;; <CJK>
     (?$(D3B(B . ?\x5258) ;; <CJK>
     (?$(D3C(B . ?\x525A) ;; <CJK>
     (?$(D3D(B . ?\x525C) ;; <CJK>
     (?$(D3E(B . ?\x525F) ;; <CJK>
     (?$(D3F(B . ?\x5260) ;; <CJK>
     (?$(D3G(B . ?\x5261) ;; <CJK>
     (?$(D3H(B . ?\x5266) ;; <CJK>
     (?$(D3I(B . ?\x526E) ;; <CJK>
     (?$(D3J(B . ?\x5277) ;; <CJK>
     (?$(D3K(B . ?\x5278) ;; <CJK>
     (?$(D3L(B . ?\x5279) ;; <CJK>
     (?$(D3M(B . ?\x5280) ;; <CJK>
     (?$(D3N(B . ?\x5282) ;; <CJK>
     (?$(D3O(B . ?\x5285) ;; <CJK>
     (?$(D3P(B . ?\x528A) ;; <CJK>
     (?$(D3Q(B . ?\x528C) ;; <CJK>
     (?$(D3R(B . ?\x5293) ;; <CJK>
     (?$(D3S(B . ?\x5295) ;; <CJK>
     (?$(D3T(B . ?\x5296) ;; <CJK>
     (?$(D3U(B . ?\x5297) ;; <CJK>
     (?$(D3V(B . ?\x5298) ;; <CJK>
     (?$(D3W(B . ?\x529A) ;; <CJK>
     (?$(D3X(B . ?\x529C) ;; <CJK>
     (?$(D3Y(B . ?\x52A4) ;; <CJK>
     (?$(D3Z(B . ?\x52A5) ;; <CJK>
     (?$(D3[(B . ?\x52A6) ;; <CJK>
     (?$(D3\(B . ?\x52A7) ;; <CJK>
     (?$(D3](B . ?\x52AF) ;; <CJK>
     (?$(D3^(B . ?\x52B0) ;; <CJK>
     (?$(D3_(B . ?\x52B6) ;; <CJK>
     (?$(D3`(B . ?\x52B7) ;; <CJK>
     (?$(D3a(B . ?\x52B8) ;; <CJK>
     (?$(D3b(B . ?\x52BA) ;; <CJK>
     (?$(D3c(B . ?\x52BB) ;; <CJK>
     (?$(D3d(B . ?\x52BD) ;; <CJK>
     (?$(D3e(B . ?\x52C0) ;; <CJK>
     (?$(D3f(B . ?\x52C4) ;; <CJK>
     (?$(D3g(B . ?\x52C6) ;; <CJK>
     (?$(D3h(B . ?\x52C8) ;; <CJK>
     (?$(D3i(B . ?\x52CC) ;; <CJK>
     (?$(D3j(B . ?\x52CF) ;; <CJK>
     (?$(D3k(B . ?\x52D1) ;; <CJK>
     (?$(D3l(B . ?\x52D4) ;; <CJK>
     (?$(D3m(B . ?\x52D6) ;; <CJK>
     (?$(D3n(B . ?\x52DB) ;; <CJK>
     (?$(D3o(B . ?\x52DC) ;; <CJK>
     (?$(D3p(B . ?\x52E1) ;; <CJK>
     (?$(D3q(B . ?\x52E5) ;; <CJK>
     (?$(D3r(B . ?\x52E8) ;; <CJK>
     (?$(D3s(B . ?\x52E9) ;; <CJK>
     (?$(D3t(B . ?\x52EA) ;; <CJK>
     (?$(D3u(B . ?\x52EC) ;; <CJK>
     (?$(D3v(B . ?\x52F0) ;; <CJK>
     (?$(D3w(B . ?\x52F1) ;; <CJK>
     (?$(D3x(B . ?\x52F4) ;; <CJK>
     (?$(D3y(B . ?\x52F6) ;; <CJK>
     (?$(D3z(B . ?\x52F7) ;; <CJK>
     (?$(D3{(B . ?\x5300) ;; <CJK>
     (?$(D3|(B . ?\x5303) ;; <CJK>
     (?$(D3}(B . ?\x530A) ;; <CJK>
     (?$(D3~(B . ?\x530B) ;; <CJK>
     (?$(D4!(B . ?\x530C) ;; <CJK>
     (?$(D4"(B . ?\x5311) ;; <CJK>
     (?$(D4#(B . ?\x5313) ;; <CJK>
     (?$(D4$(B . ?\x5318) ;; <CJK>
     (?$(D4%(B . ?\x531B) ;; <CJK>
     (?$(D4&(B . ?\x531C) ;; <CJK>
     (?$(D4'(B . ?\x531E) ;; <CJK>
     (?$(D4((B . ?\x531F) ;; <CJK>
     (?$(D4)(B . ?\x5325) ;; <CJK>
     (?$(D4*(B . ?\x5327) ;; <CJK>
     (?$(D4+(B . ?\x5328) ;; <CJK>
     (?$(D4,(B . ?\x5329) ;; <CJK>
     (?$(D4-(B . ?\x532B) ;; <CJK>
     (?$(D4.(B . ?\x532C) ;; <CJK>
     (?$(D4/(B . ?\x532D) ;; <CJK>
     (?$(D40(B . ?\x5330) ;; <CJK>
     (?$(D41(B . ?\x5332) ;; <CJK>
     (?$(D42(B . ?\x5335) ;; <CJK>
     (?$(D43(B . ?\x533C) ;; <CJK>
     (?$(D44(B . ?\x533D) ;; <CJK>
     (?$(D45(B . ?\x533E) ;; <CJK>
     (?$(D46(B . ?\x5342) ;; <CJK>
     (?$(D47(B . ?\x534C) ;; <CJK>
     (?$(D48(B . ?\x534B) ;; <CJK>
     (?$(D49(B . ?\x5359) ;; <CJK>
     (?$(D4:(B . ?\x535B) ;; <CJK>
     (?$(D4;(B . ?\x5361) ;; <CJK>
     (?$(D4<(B . ?\x5363) ;; <CJK>
     (?$(D4=(B . ?\x5365) ;; <CJK>
     (?$(D4>(B . ?\x536C) ;; <CJK>
     (?$(D4?(B . ?\x536D) ;; <CJK>
     (?$(D4@(B . ?\x5372) ;; <CJK>
     (?$(D4A(B . ?\x5379) ;; <CJK>
     (?$(D4B(B . ?\x537E) ;; <CJK>
     (?$(D4C(B . ?\x5383) ;; <CJK>
     (?$(D4D(B . ?\x5387) ;; <CJK>
     (?$(D4E(B . ?\x5388) ;; <CJK>
     (?$(D4F(B . ?\x538E) ;; <CJK>
     (?$(D4G(B . ?\x5393) ;; <CJK>
     (?$(D4H(B . ?\x5394) ;; <CJK>
     (?$(D4I(B . ?\x5399) ;; <CJK>
     (?$(D4J(B . ?\x539D) ;; <CJK>
     (?$(D4K(B . ?\x53A1) ;; <CJK>
     (?$(D4L(B . ?\x53A4) ;; <CJK>
     (?$(D4M(B . ?\x53AA) ;; <CJK>
     (?$(D4N(B . ?\x53AB) ;; <CJK>
     (?$(D4O(B . ?\x53AF) ;; <CJK>
     (?$(D4P(B . ?\x53B2) ;; <CJK>
     (?$(D4Q(B . ?\x53B4) ;; <CJK>
     (?$(D4R(B . ?\x53B5) ;; <CJK>
     (?$(D4S(B . ?\x53B7) ;; <CJK>
     (?$(D4T(B . ?\x53B8) ;; <CJK>
     (?$(D4U(B . ?\x53BA) ;; <CJK>
     (?$(D4V(B . ?\x53BD) ;; <CJK>
     (?$(D4W(B . ?\x53C0) ;; <CJK>
     (?$(D4X(B . ?\x53C5) ;; <CJK>
     (?$(D4Y(B . ?\x53CF) ;; <CJK>
     (?$(D4Z(B . ?\x53D2) ;; <CJK>
     (?$(D4[(B . ?\x53D3) ;; <CJK>
     (?$(D4\(B . ?\x53D5) ;; <CJK>
     (?$(D4](B . ?\x53DA) ;; <CJK>
     (?$(D4^(B . ?\x53DD) ;; <CJK>
     (?$(D4_(B . ?\x53DE) ;; <CJK>
     (?$(D4`(B . ?\x53E0) ;; <CJK>
     (?$(D4a(B . ?\x53E6) ;; <CJK>
     (?$(D4b(B . ?\x53E7) ;; <CJK>
     (?$(D4c(B . ?\x53F5) ;; <CJK>
     (?$(D4d(B . ?\x5402) ;; <CJK>
     (?$(D4e(B . ?\x5413) ;; <CJK>
     (?$(D4f(B . ?\x541A) ;; <CJK>
     (?$(D4g(B . ?\x5421) ;; <CJK>
     (?$(D4h(B . ?\x5427) ;; <CJK>
     (?$(D4i(B . ?\x5428) ;; <CJK>
     (?$(D4j(B . ?\x542A) ;; <CJK>
     (?$(D4k(B . ?\x542F) ;; <CJK>
     (?$(D4l(B . ?\x5431) ;; <CJK>
     (?$(D4m(B . ?\x5434) ;; <CJK>
     (?$(D4n(B . ?\x5435) ;; <CJK>
     (?$(D4o(B . ?\x5443) ;; <CJK>
     (?$(D4p(B . ?\x5444) ;; <CJK>
     (?$(D4q(B . ?\x5447) ;; <CJK>
     (?$(D4r(B . ?\x544D) ;; <CJK>
     (?$(D4s(B . ?\x544F) ;; <CJK>
     (?$(D4t(B . ?\x545E) ;; <CJK>
     (?$(D4u(B . ?\x5462) ;; <CJK>
     (?$(D4v(B . ?\x5464) ;; <CJK>
     (?$(D4w(B . ?\x5466) ;; <CJK>
     (?$(D4x(B . ?\x5467) ;; <CJK>
     (?$(D4y(B . ?\x5469) ;; <CJK>
     (?$(D4z(B . ?\x546B) ;; <CJK>
     (?$(D4{(B . ?\x546D) ;; <CJK>
     (?$(D4|(B . ?\x546E) ;; <CJK>
     (?$(D4}(B . ?\x5474) ;; <CJK>
     (?$(D4~(B . ?\x547F) ;; <CJK>
     (?$(D5!(B . ?\x5481) ;; <CJK>
     (?$(D5"(B . ?\x5483) ;; <CJK>
     (?$(D5#(B . ?\x5485) ;; <CJK>
     (?$(D5$(B . ?\x5488) ;; <CJK>
     (?$(D5%(B . ?\x5489) ;; <CJK>
     (?$(D5&(B . ?\x548D) ;; <CJK>
     (?$(D5'(B . ?\x5491) ;; <CJK>
     (?$(D5((B . ?\x5495) ;; <CJK>
     (?$(D5)(B . ?\x5496) ;; <CJK>
     (?$(D5*(B . ?\x549C) ;; <CJK>
     (?$(D5+(B . ?\x549F) ;; <CJK>
     (?$(D5,(B . ?\x54A1) ;; <CJK>
     (?$(D5-(B . ?\x54A6) ;; <CJK>
     (?$(D5.(B . ?\x54A7) ;; <CJK>
     (?$(D5/(B . ?\x54A9) ;; <CJK>
     (?$(D50(B . ?\x54AA) ;; <CJK>
     (?$(D51(B . ?\x54AD) ;; <CJK>
     (?$(D52(B . ?\x54AE) ;; <CJK>
     (?$(D53(B . ?\x54B1) ;; <CJK>
     (?$(D54(B . ?\x54B7) ;; <CJK>
     (?$(D55(B . ?\x54B9) ;; <CJK>
     (?$(D56(B . ?\x54BA) ;; <CJK>
     (?$(D57(B . ?\x54BB) ;; <CJK>
     (?$(D58(B . ?\x54BF) ;; <CJK>
     (?$(D59(B . ?\x54C6) ;; <CJK>
     (?$(D5:(B . ?\x54CA) ;; <CJK>
     (?$(D5;(B . ?\x54CD) ;; <CJK>
     (?$(D5<(B . ?\x54CE) ;; <CJK>
     (?$(D5=(B . ?\x54E0) ;; <CJK>
     (?$(D5>(B . ?\x54EA) ;; <CJK>
     (?$(D5?(B . ?\x54EC) ;; <CJK>
     (?$(D5@(B . ?\x54EF) ;; <CJK>
     (?$(D5A(B . ?\x54F6) ;; <CJK>
     (?$(D5B(B . ?\x54FC) ;; <CJK>
     (?$(D5C(B . ?\x54FE) ;; <CJK>
     (?$(D5D(B . ?\x54FF) ;; <CJK>
     (?$(D5E(B . ?\x5500) ;; <CJK>
     (?$(D5F(B . ?\x5501) ;; <CJK>
     (?$(D5G(B . ?\x5505) ;; <CJK>
     (?$(D5H(B . ?\x5508) ;; <CJK>
     (?$(D5I(B . ?\x5509) ;; <CJK>
     (?$(D5J(B . ?\x550C) ;; <CJK>
     (?$(D5K(B . ?\x550D) ;; <CJK>
     (?$(D5L(B . ?\x550E) ;; <CJK>
     (?$(D5M(B . ?\x5515) ;; <CJK>
     (?$(D5N(B . ?\x552A) ;; <CJK>
     (?$(D5O(B . ?\x552B) ;; <CJK>
     (?$(D5P(B . ?\x5532) ;; <CJK>
     (?$(D5Q(B . ?\x5535) ;; <CJK>
     (?$(D5R(B . ?\x5536) ;; <CJK>
     (?$(D5S(B . ?\x553B) ;; <CJK>
     (?$(D5T(B . ?\x553C) ;; <CJK>
     (?$(D5U(B . ?\x553D) ;; <CJK>
     (?$(D5V(B . ?\x5541) ;; <CJK>
     (?$(D5W(B . ?\x5547) ;; <CJK>
     (?$(D5X(B . ?\x5549) ;; <CJK>
     (?$(D5Y(B . ?\x554A) ;; <CJK>
     (?$(D5Z(B . ?\x554D) ;; <CJK>
     (?$(D5[(B . ?\x5550) ;; <CJK>
     (?$(D5\(B . ?\x5551) ;; <CJK>
     (?$(D5](B . ?\x5558) ;; <CJK>
     (?$(D5^(B . ?\x555A) ;; <CJK>
     (?$(D5_(B . ?\x555B) ;; <CJK>
     (?$(D5`(B . ?\x555E) ;; <CJK>
     (?$(D5a(B . ?\x5560) ;; <CJK>
     (?$(D5b(B . ?\x5561) ;; <CJK>
     (?$(D5c(B . ?\x5564) ;; <CJK>
     (?$(D5d(B . ?\x5566) ;; <CJK>
     (?$(D5e(B . ?\x557F) ;; <CJK>
     (?$(D5f(B . ?\x5581) ;; <CJK>
     (?$(D5g(B . ?\x5582) ;; <CJK>
     (?$(D5h(B . ?\x5586) ;; <CJK>
     (?$(D5i(B . ?\x5588) ;; <CJK>
     (?$(D5j(B . ?\x558E) ;; <CJK>
     (?$(D5k(B . ?\x558F) ;; <CJK>
     (?$(D5l(B . ?\x5591) ;; <CJK>
     (?$(D5m(B . ?\x5592) ;; <CJK>
     (?$(D5n(B . ?\x5593) ;; <CJK>
     (?$(D5o(B . ?\x5594) ;; <CJK>
     (?$(D5p(B . ?\x5597) ;; <CJK>
     (?$(D5q(B . ?\x55A3) ;; <CJK>
     (?$(D5r(B . ?\x55A4) ;; <CJK>
     (?$(D5s(B . ?\x55AD) ;; <CJK>
     (?$(D5t(B . ?\x55B2) ;; <CJK>
     (?$(D5u(B . ?\x55BF) ;; <CJK>
     (?$(D5v(B . ?\x55C1) ;; <CJK>
     (?$(D5w(B . ?\x55C3) ;; <CJK>
     (?$(D5x(B . ?\x55C6) ;; <CJK>
     (?$(D5y(B . ?\x55C9) ;; <CJK>
     (?$(D5z(B . ?\x55CB) ;; <CJK>
     (?$(D5{(B . ?\x55CC) ;; <CJK>
     (?$(D5|(B . ?\x55CE) ;; <CJK>
     (?$(D5}(B . ?\x55D1) ;; <CJK>
     (?$(D5~(B . ?\x55D2) ;; <CJK>
     (?$(D6!(B . ?\x55D3) ;; <CJK>
     (?$(D6"(B . ?\x55D7) ;; <CJK>
     (?$(D6#(B . ?\x55D8) ;; <CJK>
     (?$(D6$(B . ?\x55DB) ;; <CJK>
     (?$(D6%(B . ?\x55DE) ;; <CJK>
     (?$(D6&(B . ?\x55E2) ;; <CJK>
     (?$(D6'(B . ?\x55E9) ;; <CJK>
     (?$(D6((B . ?\x55F6) ;; <CJK>
     (?$(D6)(B . ?\x55FF) ;; <CJK>
     (?$(D6*(B . ?\x5605) ;; <CJK>
     (?$(D6+(B . ?\x5608) ;; <CJK>
     (?$(D6,(B . ?\x560A) ;; <CJK>
     (?$(D6-(B . ?\x560D) ;; <CJK>
     (?$(D6.(B . ?\x560E) ;; <CJK>
     (?$(D6/(B . ?\x560F) ;; <CJK>
     (?$(D60(B . ?\x5610) ;; <CJK>
     (?$(D61(B . ?\x5611) ;; <CJK>
     (?$(D62(B . ?\x5612) ;; <CJK>
     (?$(D63(B . ?\x5619) ;; <CJK>
     (?$(D64(B . ?\x562C) ;; <CJK>
     (?$(D65(B . ?\x5630) ;; <CJK>
     (?$(D66(B . ?\x5633) ;; <CJK>
     (?$(D67(B . ?\x5635) ;; <CJK>
     (?$(D68(B . ?\x5637) ;; <CJK>
     (?$(D69(B . ?\x5639) ;; <CJK>
     (?$(D6:(B . ?\x563B) ;; <CJK>
     (?$(D6;(B . ?\x563C) ;; <CJK>
     (?$(D6<(B . ?\x563D) ;; <CJK>
     (?$(D6=(B . ?\x563F) ;; <CJK>
     (?$(D6>(B . ?\x5640) ;; <CJK>
     (?$(D6?(B . ?\x5641) ;; <CJK>
     (?$(D6@(B . ?\x5643) ;; <CJK>
     (?$(D6A(B . ?\x5644) ;; <CJK>
     (?$(D6B(B . ?\x5646) ;; <CJK>
     (?$(D6C(B . ?\x5649) ;; <CJK>
     (?$(D6D(B . ?\x564B) ;; <CJK>
     (?$(D6E(B . ?\x564D) ;; <CJK>
     (?$(D6F(B . ?\x564F) ;; <CJK>
     (?$(D6G(B . ?\x5654) ;; <CJK>
     (?$(D6H(B . ?\x565E) ;; <CJK>
     (?$(D6I(B . ?\x5660) ;; <CJK>
     (?$(D6J(B . ?\x5661) ;; <CJK>
     (?$(D6K(B . ?\x5662) ;; <CJK>
     (?$(D6L(B . ?\x5663) ;; <CJK>
     (?$(D6M(B . ?\x5666) ;; <CJK>
     (?$(D6N(B . ?\x5669) ;; <CJK>
     (?$(D6O(B . ?\x566D) ;; <CJK>
     (?$(D6P(B . ?\x566F) ;; <CJK>
     (?$(D6Q(B . ?\x5671) ;; <CJK>
     (?$(D6R(B . ?\x5672) ;; <CJK>
     (?$(D6S(B . ?\x5675) ;; <CJK>
     (?$(D6T(B . ?\x5684) ;; <CJK>
     (?$(D6U(B . ?\x5685) ;; <CJK>
     (?$(D6V(B . ?\x5688) ;; <CJK>
     (?$(D6W(B . ?\x568B) ;; <CJK>
     (?$(D6X(B . ?\x568C) ;; <CJK>
     (?$(D6Y(B . ?\x5695) ;; <CJK>
     (?$(D6Z(B . ?\x5699) ;; <CJK>
     (?$(D6[(B . ?\x569A) ;; <CJK>
     (?$(D6\(B . ?\x569D) ;; <CJK>
     (?$(D6](B . ?\x569E) ;; <CJK>
     (?$(D6^(B . ?\x569F) ;; <CJK>
     (?$(D6_(B . ?\x56A6) ;; <CJK>
     (?$(D6`(B . ?\x56A7) ;; <CJK>
     (?$(D6a(B . ?\x56A8) ;; <CJK>
     (?$(D6b(B . ?\x56A9) ;; <CJK>
     (?$(D6c(B . ?\x56AB) ;; <CJK>
     (?$(D6d(B . ?\x56AC) ;; <CJK>
     (?$(D6e(B . ?\x56AD) ;; <CJK>
     (?$(D6f(B . ?\x56B1) ;; <CJK>
     (?$(D6g(B . ?\x56B3) ;; <CJK>
     (?$(D6h(B . ?\x56B7) ;; <CJK>
     (?$(D6i(B . ?\x56BE) ;; <CJK>
     (?$(D6j(B . ?\x56C5) ;; <CJK>
     (?$(D6k(B . ?\x56C9) ;; <CJK>
     (?$(D6l(B . ?\x56CA) ;; <CJK>
     (?$(D6m(B . ?\x56CB) ;; <CJK>
     (?$(D6n(B . ?\x56CF) ;; <CJK>
     (?$(D6o(B . ?\x56D0) ;; <CJK>
     (?$(D6p(B . ?\x56CC) ;; <CJK>
     (?$(D6q(B . ?\x56CD) ;; <CJK>
     (?$(D6r(B . ?\x56D9) ;; <CJK>
     (?$(D6s(B . ?\x56DC) ;; <CJK>
     (?$(D6t(B . ?\x56DD) ;; <CJK>
     (?$(D6u(B . ?\x56DF) ;; <CJK>
     (?$(D6v(B . ?\x56E1) ;; <CJK>
     (?$(D6w(B . ?\x56E4) ;; <CJK>
     (?$(D6x(B . ?\x56E5) ;; <CJK>
     (?$(D6y(B . ?\x56E6) ;; <CJK>
     (?$(D6z(B . ?\x56E7) ;; <CJK>
     (?$(D6{(B . ?\x56E8) ;; <CJK>
     (?$(D6|(B . ?\x56F1) ;; <CJK>
     (?$(D6}(B . ?\x56EB) ;; <CJK>
     (?$(D6~(B . ?\x56ED) ;; <CJK>
     (?$(D7!(B . ?\x56F6) ;; <CJK>
     (?$(D7"(B . ?\x56F7) ;; <CJK>
     (?$(D7#(B . ?\x5701) ;; <CJK>
     (?$(D7$(B . ?\x5702) ;; <CJK>
     (?$(D7%(B . ?\x5707) ;; <CJK>
     (?$(D7&(B . ?\x570A) ;; <CJK>
     (?$(D7'(B . ?\x570C) ;; <CJK>
     (?$(D7((B . ?\x5711) ;; <CJK>
     (?$(D7)(B . ?\x5715) ;; <CJK>
     (?$(D7*(B . ?\x571A) ;; <CJK>
     (?$(D7+(B . ?\x571B) ;; <CJK>
     (?$(D7,(B . ?\x571D) ;; <CJK>
     (?$(D7-(B . ?\x5720) ;; <CJK>
     (?$(D7.(B . ?\x5722) ;; <CJK>
     (?$(D7/(B . ?\x5723) ;; <CJK>
     (?$(D70(B . ?\x5724) ;; <CJK>
     (?$(D71(B . ?\x5725) ;; <CJK>
     (?$(D72(B . ?\x5729) ;; <CJK>
     (?$(D73(B . ?\x572A) ;; <CJK>
     (?$(D74(B . ?\x572C) ;; <CJK>
     (?$(D75(B . ?\x572E) ;; <CJK>
     (?$(D76(B . ?\x572F) ;; <CJK>
     (?$(D77(B . ?\x5733) ;; <CJK>
     (?$(D78(B . ?\x5734) ;; <CJK>
     (?$(D79(B . ?\x573D) ;; <CJK>
     (?$(D7:(B . ?\x573E) ;; <CJK>
     (?$(D7;(B . ?\x573F) ;; <CJK>
     (?$(D7<(B . ?\x5745) ;; <CJK>
     (?$(D7=(B . ?\x5746) ;; <CJK>
     (?$(D7>(B . ?\x574C) ;; <CJK>
     (?$(D7?(B . ?\x574D) ;; <CJK>
     (?$(D7@(B . ?\x5752) ;; <CJK>
     (?$(D7A(B . ?\x5762) ;; <CJK>
     (?$(D7B(B . ?\x5765) ;; <CJK>
     (?$(D7C(B . ?\x5767) ;; <CJK>
     (?$(D7D(B . ?\x5768) ;; <CJK>
     (?$(D7E(B . ?\x576B) ;; <CJK>
     (?$(D7F(B . ?\x576D) ;; <CJK>
     (?$(D7G(B . ?\x576E) ;; <CJK>
     (?$(D7H(B . ?\x576F) ;; <CJK>
     (?$(D7I(B . ?\x5770) ;; <CJK>
     (?$(D7J(B . ?\x5771) ;; <CJK>
     (?$(D7K(B . ?\x5773) ;; <CJK>
     (?$(D7L(B . ?\x5774) ;; <CJK>
     (?$(D7M(B . ?\x5775) ;; <CJK>
     (?$(D7N(B . ?\x5777) ;; <CJK>
     (?$(D7O(B . ?\x5779) ;; <CJK>
     (?$(D7P(B . ?\x577A) ;; <CJK>
     (?$(D7Q(B . ?\x577B) ;; <CJK>
     (?$(D7R(B . ?\x577C) ;; <CJK>
     (?$(D7S(B . ?\x577E) ;; <CJK>
     (?$(D7T(B . ?\x5781) ;; <CJK>
     (?$(D7U(B . ?\x5783) ;; <CJK>
     (?$(D7V(B . ?\x578C) ;; <CJK>
     (?$(D7W(B . ?\x5794) ;; <CJK>
     (?$(D7X(B . ?\x5797) ;; <CJK>
     (?$(D7Y(B . ?\x5799) ;; <CJK>
     (?$(D7Z(B . ?\x579A) ;; <CJK>
     (?$(D7[(B . ?\x579C) ;; <CJK>
     (?$(D7\(B . ?\x579D) ;; <CJK>
     (?$(D7](B . ?\x579E) ;; <CJK>
     (?$(D7^(B . ?\x579F) ;; <CJK>
     (?$(D7_(B . ?\x57A1) ;; <CJK>
     (?$(D7`(B . ?\x5795) ;; <CJK>
     (?$(D7a(B . ?\x57A7) ;; <CJK>
     (?$(D7b(B . ?\x57A8) ;; <CJK>
     (?$(D7c(B . ?\x57A9) ;; <CJK>
     (?$(D7d(B . ?\x57AC) ;; <CJK>
     (?$(D7e(B . ?\x57B8) ;; <CJK>
     (?$(D7f(B . ?\x57BD) ;; <CJK>
     (?$(D7g(B . ?\x57C7) ;; <CJK>
     (?$(D7h(B . ?\x57C8) ;; <CJK>
     (?$(D7i(B . ?\x57CC) ;; <CJK>
     (?$(D7j(B . ?\x57CF) ;; <CJK>
     (?$(D7k(B . ?\x57D5) ;; <CJK>
     (?$(D7l(B . ?\x57DD) ;; <CJK>
     (?$(D7m(B . ?\x57DE) ;; <CJK>
     (?$(D7n(B . ?\x57E4) ;; <CJK>
     (?$(D7o(B . ?\x57E6) ;; <CJK>
     (?$(D7p(B . ?\x57E7) ;; <CJK>
     (?$(D7q(B . ?\x57E9) ;; <CJK>
     (?$(D7r(B . ?\x57ED) ;; <CJK>
     (?$(D7s(B . ?\x57F0) ;; <CJK>
     (?$(D7t(B . ?\x57F5) ;; <CJK>
     (?$(D7u(B . ?\x57F6) ;; <CJK>
     (?$(D7v(B . ?\x57F8) ;; <CJK>
     (?$(D7w(B . ?\x57FD) ;; <CJK>
     (?$(D7x(B . ?\x57FE) ;; <CJK>
     (?$(D7y(B . ?\x57FF) ;; <CJK>
     (?$(D7z(B . ?\x5803) ;; <CJK>
     (?$(D7{(B . ?\x5804) ;; <CJK>
     (?$(D7|(B . ?\x5808) ;; <CJK>
     (?$(D7}(B . ?\x5809) ;; <CJK>
     (?$(D7~(B . ?\x57E1) ;; <CJK>
     (?$(D8!(B . ?\x580C) ;; <CJK>
     (?$(D8"(B . ?\x580D) ;; <CJK>
     (?$(D8#(B . ?\x581B) ;; <CJK>
     (?$(D8$(B . ?\x581E) ;; <CJK>
     (?$(D8%(B . ?\x581F) ;; <CJK>
     (?$(D8&(B . ?\x5820) ;; <CJK>
     (?$(D8'(B . ?\x5826) ;; <CJK>
     (?$(D8((B . ?\x5827) ;; <CJK>
     (?$(D8)(B . ?\x582D) ;; <CJK>
     (?$(D8*(B . ?\x5832) ;; <CJK>
     (?$(D8+(B . ?\x5839) ;; <CJK>
     (?$(D8,(B . ?\x583F) ;; <CJK>
     (?$(D8-(B . ?\x5849) ;; <CJK>
     (?$(D8.(B . ?\x584C) ;; <CJK>
     (?$(D8/(B . ?\x584D) ;; <CJK>
     (?$(D80(B . ?\x584F) ;; <CJK>
     (?$(D81(B . ?\x5850) ;; <CJK>
     (?$(D82(B . ?\x5855) ;; <CJK>
     (?$(D83(B . ?\x585F) ;; <CJK>
     (?$(D84(B . ?\x5861) ;; <CJK>
     (?$(D85(B . ?\x5864) ;; <CJK>
     (?$(D86(B . ?\x5867) ;; <CJK>
     (?$(D87(B . ?\x5868) ;; <CJK>
     (?$(D88(B . ?\x5878) ;; <CJK>
     (?$(D89(B . ?\x587C) ;; <CJK>
     (?$(D8:(B . ?\x587F) ;; <CJK>
     (?$(D8;(B . ?\x5880) ;; <CJK>
     (?$(D8<(B . ?\x5881) ;; <CJK>
     (?$(D8=(B . ?\x5887) ;; <CJK>
     (?$(D8>(B . ?\x5888) ;; <CJK>
     (?$(D8?(B . ?\x5889) ;; <CJK>
     (?$(D8@(B . ?\x588A) ;; <CJK>
     (?$(D8A(B . ?\x588C) ;; <CJK>
     (?$(D8B(B . ?\x588D) ;; <CJK>
     (?$(D8C(B . ?\x588F) ;; <CJK>
     (?$(D8D(B . ?\x5890) ;; <CJK>
     (?$(D8E(B . ?\x5894) ;; <CJK>
     (?$(D8F(B . ?\x5896) ;; <CJK>
     (?$(D8G(B . ?\x589D) ;; <CJK>
     (?$(D8H(B . ?\x58A0) ;; <CJK>
     (?$(D8I(B . ?\x58A1) ;; <CJK>
     (?$(D8J(B . ?\x58A2) ;; <CJK>
     (?$(D8K(B . ?\x58A6) ;; <CJK>
     (?$(D8L(B . ?\x58A9) ;; <CJK>
     (?$(D8M(B . ?\x58B1) ;; <CJK>
     (?$(D8N(B . ?\x58B2) ;; <CJK>
     (?$(D8O(B . ?\x58C4) ;; <CJK>
     (?$(D8P(B . ?\x58BC) ;; <CJK>
     (?$(D8Q(B . ?\x58C2) ;; <CJK>
     (?$(D8R(B . ?\x58C8) ;; <CJK>
     (?$(D8S(B . ?\x58CD) ;; <CJK>
     (?$(D8T(B . ?\x58CE) ;; <CJK>
     (?$(D8U(B . ?\x58D0) ;; <CJK>
     (?$(D8V(B . ?\x58D2) ;; <CJK>
     (?$(D8W(B . ?\x58D4) ;; <CJK>
     (?$(D8X(B . ?\x58D6) ;; <CJK>
     (?$(D8Y(B . ?\x58DA) ;; <CJK>
     (?$(D8Z(B . ?\x58DD) ;; <CJK>
     (?$(D8[(B . ?\x58E1) ;; <CJK>
     (?$(D8\(B . ?\x58E2) ;; <CJK>
     (?$(D8](B . ?\x58E9) ;; <CJK>
     (?$(D8^(B . ?\x58F3) ;; <CJK>
     (?$(D8_(B . ?\x5905) ;; <CJK>
     (?$(D8`(B . ?\x5906) ;; <CJK>
     (?$(D8a(B . ?\x590B) ;; <CJK>
     (?$(D8b(B . ?\x590C) ;; <CJK>
     (?$(D8c(B . ?\x5912) ;; <CJK>
     (?$(D8d(B . ?\x5913) ;; <CJK>
     (?$(D8e(B . ?\x5914) ;; <CJK>
     (?$(D8f(B . ?\x8641) ;; <CJK>
     (?$(D8g(B . ?\x591D) ;; <CJK>
     (?$(D8h(B . ?\x5921) ;; <CJK>
     (?$(D8i(B . ?\x5923) ;; <CJK>
     (?$(D8j(B . ?\x5924) ;; <CJK>
     (?$(D8k(B . ?\x5928) ;; <CJK>
     (?$(D8l(B . ?\x592F) ;; <CJK>
     (?$(D8m(B . ?\x5930) ;; <CJK>
     (?$(D8n(B . ?\x5933) ;; <CJK>
     (?$(D8o(B . ?\x5935) ;; <CJK>
     (?$(D8p(B . ?\x5936) ;; <CJK>
     (?$(D8q(B . ?\x593F) ;; <CJK>
     (?$(D8r(B . ?\x5943) ;; <CJK>
     (?$(D8s(B . ?\x5946) ;; <CJK>
     (?$(D8t(B . ?\x5952) ;; <CJK>
     (?$(D8u(B . ?\x5953) ;; <CJK>
     (?$(D8v(B . ?\x5959) ;; <CJK>
     (?$(D8w(B . ?\x595B) ;; <CJK>
     (?$(D8x(B . ?\x595D) ;; <CJK>
     (?$(D8y(B . ?\x595E) ;; <CJK>
     (?$(D8z(B . ?\x595F) ;; <CJK>
     (?$(D8{(B . ?\x5961) ;; <CJK>
     (?$(D8|(B . ?\x5963) ;; <CJK>
     (?$(D8}(B . ?\x596B) ;; <CJK>
     (?$(D8~(B . ?\x596D) ;; <CJK>
     (?$(D9!(B . ?\x596F) ;; <CJK>
     (?$(D9"(B . ?\x5972) ;; <CJK>
     (?$(D9#(B . ?\x5975) ;; <CJK>
     (?$(D9$(B . ?\x5976) ;; <CJK>
     (?$(D9%(B . ?\x5979) ;; <CJK>
     (?$(D9&(B . ?\x597B) ;; <CJK>
     (?$(D9'(B . ?\x597C) ;; <CJK>
     (?$(D9((B . ?\x598B) ;; <CJK>
     (?$(D9)(B . ?\x598C) ;; <CJK>
     (?$(D9*(B . ?\x598E) ;; <CJK>
     (?$(D9+(B . ?\x5992) ;; <CJK>
     (?$(D9,(B . ?\x5995) ;; <CJK>
     (?$(D9-(B . ?\x5997) ;; <CJK>
     (?$(D9.(B . ?\x599F) ;; <CJK>
     (?$(D9/(B . ?\x59A4) ;; <CJK>
     (?$(D90(B . ?\x59A7) ;; <CJK>
     (?$(D91(B . ?\x59AD) ;; <CJK>
     (?$(D92(B . ?\x59AE) ;; <CJK>
     (?$(D93(B . ?\x59AF) ;; <CJK>
     (?$(D94(B . ?\x59B0) ;; <CJK>
     (?$(D95(B . ?\x59B3) ;; <CJK>
     (?$(D96(B . ?\x59B7) ;; <CJK>
     (?$(D97(B . ?\x59BA) ;; <CJK>
     (?$(D98(B . ?\x59BC) ;; <CJK>
     (?$(D99(B . ?\x59C1) ;; <CJK>
     (?$(D9:(B . ?\x59C3) ;; <CJK>
     (?$(D9;(B . ?\x59C4) ;; <CJK>
     (?$(D9<(B . ?\x59C8) ;; <CJK>
     (?$(D9=(B . ?\x59CA) ;; <CJK>
     (?$(D9>(B . ?\x59CD) ;; <CJK>
     (?$(D9?(B . ?\x59D2) ;; <CJK>
     (?$(D9@(B . ?\x59DD) ;; <CJK>
     (?$(D9A(B . ?\x59DE) ;; <CJK>
     (?$(D9B(B . ?\x59DF) ;; <CJK>
     (?$(D9C(B . ?\x59E3) ;; <CJK>
     (?$(D9D(B . ?\x59E4) ;; <CJK>
     (?$(D9E(B . ?\x59E7) ;; <CJK>
     (?$(D9F(B . ?\x59EE) ;; <CJK>
     (?$(D9G(B . ?\x59EF) ;; <CJK>
     (?$(D9H(B . ?\x59F1) ;; <CJK>
     (?$(D9I(B . ?\x59F2) ;; <CJK>
     (?$(D9J(B . ?\x59F4) ;; <CJK>
     (?$(D9K(B . ?\x59F7) ;; <CJK>
     (?$(D9L(B . ?\x5A00) ;; <CJK>
     (?$(D9M(B . ?\x5A04) ;; <CJK>
     (?$(D9N(B . ?\x5A0C) ;; <CJK>
     (?$(D9O(B . ?\x5A0D) ;; <CJK>
     (?$(D9P(B . ?\x5A0E) ;; <CJK>
     (?$(D9Q(B . ?\x5A12) ;; <CJK>
     (?$(D9R(B . ?\x5A13) ;; <CJK>
     (?$(D9S(B . ?\x5A1E) ;; <CJK>
     (?$(D9T(B . ?\x5A23) ;; <CJK>
     (?$(D9U(B . ?\x5A24) ;; <CJK>
     (?$(D9V(B . ?\x5A27) ;; <CJK>
     (?$(D9W(B . ?\x5A28) ;; <CJK>
     (?$(D9X(B . ?\x5A2A) ;; <CJK>
     (?$(D9Y(B . ?\x5A2D) ;; <CJK>
     (?$(D9Z(B . ?\x5A30) ;; <CJK>
     (?$(D9[(B . ?\x5A44) ;; <CJK>
     (?$(D9\(B . ?\x5A45) ;; <CJK>
     (?$(D9](B . ?\x5A47) ;; <CJK>
     (?$(D9^(B . ?\x5A48) ;; <CJK>
     (?$(D9_(B . ?\x5A4C) ;; <CJK>
     (?$(D9`(B . ?\x5A50) ;; <CJK>
     (?$(D9a(B . ?\x5A55) ;; <CJK>
     (?$(D9b(B . ?\x5A5E) ;; <CJK>
     (?$(D9c(B . ?\x5A63) ;; <CJK>
     (?$(D9d(B . ?\x5A65) ;; <CJK>
     (?$(D9e(B . ?\x5A67) ;; <CJK>
     (?$(D9f(B . ?\x5A6D) ;; <CJK>
     (?$(D9g(B . ?\x5A77) ;; <CJK>
     (?$(D9h(B . ?\x5A7A) ;; <CJK>
     (?$(D9i(B . ?\x5A7B) ;; <CJK>
     (?$(D9j(B . ?\x5A7E) ;; <CJK>
     (?$(D9k(B . ?\x5A8B) ;; <CJK>
     (?$(D9l(B . ?\x5A90) ;; <CJK>
     (?$(D9m(B . ?\x5A93) ;; <CJK>
     (?$(D9n(B . ?\x5A96) ;; <CJK>
     (?$(D9o(B . ?\x5A99) ;; <CJK>
     (?$(D9p(B . ?\x5A9C) ;; <CJK>
     (?$(D9q(B . ?\x5A9E) ;; <CJK>
     (?$(D9r(B . ?\x5A9F) ;; <CJK>
     (?$(D9s(B . ?\x5AA0) ;; <CJK>
     (?$(D9t(B . ?\x5AA2) ;; <CJK>
     (?$(D9u(B . ?\x5AA7) ;; <CJK>
     (?$(D9v(B . ?\x5AAC) ;; <CJK>
     (?$(D9w(B . ?\x5AB1) ;; <CJK>
     (?$(D9x(B . ?\x5AB2) ;; <CJK>
     (?$(D9y(B . ?\x5AB3) ;; <CJK>
     (?$(D9z(B . ?\x5AB5) ;; <CJK>
     (?$(D9{(B . ?\x5AB8) ;; <CJK>
     (?$(D9|(B . ?\x5ABA) ;; <CJK>
     (?$(D9}(B . ?\x5ABB) ;; <CJK>
     (?$(D9~(B . ?\x5ABF) ;; <CJK>
     (?$(D:!(B . ?\x5AC4) ;; <CJK>
     (?$(D:"(B . ?\x5AC6) ;; <CJK>
     (?$(D:#(B . ?\x5AC8) ;; <CJK>
     (?$(D:$(B . ?\x5ACF) ;; <CJK>
     (?$(D:%(B . ?\x5ADA) ;; <CJK>
     (?$(D:&(B . ?\x5ADC) ;; <CJK>
     (?$(D:'(B . ?\x5AE0) ;; <CJK>
     (?$(D:((B . ?\x5AE5) ;; <CJK>
     (?$(D:)(B . ?\x5AEA) ;; <CJK>
     (?$(D:*(B . ?\x5AEE) ;; <CJK>
     (?$(D:+(B . ?\x5AF5) ;; <CJK>
     (?$(D:,(B . ?\x5AF6) ;; <CJK>
     (?$(D:-(B . ?\x5AFD) ;; <CJK>
     (?$(D:.(B . ?\x5B00) ;; <CJK>
     (?$(D:/(B . ?\x5B01) ;; <CJK>
     (?$(D:0(B . ?\x5B08) ;; <CJK>
     (?$(D:1(B . ?\x5B17) ;; <CJK>
     (?$(D:2(B . ?\x5B34) ;; <CJK>
     (?$(D:3(B . ?\x5B19) ;; <CJK>
     (?$(D:4(B . ?\x5B1B) ;; <CJK>
     (?$(D:5(B . ?\x5B1D) ;; <CJK>
     (?$(D:6(B . ?\x5B21) ;; <CJK>
     (?$(D:7(B . ?\x5B25) ;; <CJK>
     (?$(D:8(B . ?\x5B2D) ;; <CJK>
     (?$(D:9(B . ?\x5B38) ;; <CJK>
     (?$(D::(B . ?\x5B41) ;; <CJK>
     (?$(D:;(B . ?\x5B4B) ;; <CJK>
     (?$(D:<(B . ?\x5B4C) ;; <CJK>
     (?$(D:=(B . ?\x5B52) ;; <CJK>
     (?$(D:>(B . ?\x5B56) ;; <CJK>
     (?$(D:?(B . ?\x5B5E) ;; <CJK>
     (?$(D:@(B . ?\x5B68) ;; <CJK>
     (?$(D:A(B . ?\x5B6E) ;; <CJK>
     (?$(D:B(B . ?\x5B6F) ;; <CJK>
     (?$(D:C(B . ?\x5B7C) ;; <CJK>
     (?$(D:D(B . ?\x5B7D) ;; <CJK>
     (?$(D:E(B . ?\x5B7E) ;; <CJK>
     (?$(D:F(B . ?\x5B7F) ;; <CJK>
     (?$(D:G(B . ?\x5B81) ;; <CJK>
     (?$(D:H(B . ?\x5B84) ;; <CJK>
     (?$(D:I(B . ?\x5B86) ;; <CJK>
     (?$(D:J(B . ?\x5B8A) ;; <CJK>
     (?$(D:K(B . ?\x5B8E) ;; <CJK>
     (?$(D:L(B . ?\x5B90) ;; <CJK>
     (?$(D:M(B . ?\x5B91) ;; <CJK>
     (?$(D:N(B . ?\x5B93) ;; <CJK>
     (?$(D:O(B . ?\x5B94) ;; <CJK>
     (?$(D:P(B . ?\x5B96) ;; <CJK>
     (?$(D:Q(B . ?\x5BA8) ;; <CJK>
     (?$(D:R(B . ?\x5BA9) ;; <CJK>
     (?$(D:S(B . ?\x5BAC) ;; <CJK>
     (?$(D:T(B . ?\x5BAD) ;; <CJK>
     (?$(D:U(B . ?\x5BAF) ;; <CJK>
     (?$(D:V(B . ?\x5BB1) ;; <CJK>
     (?$(D:W(B . ?\x5BB2) ;; <CJK>
     (?$(D:X(B . ?\x5BB7) ;; <CJK>
     (?$(D:Y(B . ?\x5BBA) ;; <CJK>
     (?$(D:Z(B . ?\x5BBC) ;; <CJK>
     (?$(D:[(B . ?\x5BC0) ;; <CJK>
     (?$(D:\(B . ?\x5BC1) ;; <CJK>
     (?$(D:](B . ?\x5BCD) ;; <CJK>
     (?$(D:^(B . ?\x5BCF) ;; <CJK>
     (?$(D:_(B . ?\x5BD6) ;; <CJK>
     (?$(D:`(B . ?\x5BD7) ;; <CJK>
     (?$(D:a(B . ?\x5BD8) ;; <CJK>
     (?$(D:b(B . ?\x5BD9) ;; <CJK>
     (?$(D:c(B . ?\x5BDA) ;; <CJK>
     (?$(D:d(B . ?\x5BE0) ;; <CJK>
     (?$(D:e(B . ?\x5BEF) ;; <CJK>
     (?$(D:f(B . ?\x5BF1) ;; <CJK>
     (?$(D:g(B . ?\x5BF4) ;; <CJK>
     (?$(D:h(B . ?\x5BFD) ;; <CJK>
     (?$(D:i(B . ?\x5C0C) ;; <CJK>
     (?$(D:j(B . ?\x5C17) ;; <CJK>
     (?$(D:k(B . ?\x5C1E) ;; <CJK>
     (?$(D:l(B . ?\x5C1F) ;; <CJK>
     (?$(D:m(B . ?\x5C23) ;; <CJK>
     (?$(D:n(B . ?\x5C26) ;; <CJK>
     (?$(D:o(B . ?\x5C29) ;; <CJK>
     (?$(D:p(B . ?\x5C2B) ;; <CJK>
     (?$(D:q(B . ?\x5C2C) ;; <CJK>
     (?$(D:r(B . ?\x5C2E) ;; <CJK>
     (?$(D:s(B . ?\x5C30) ;; <CJK>
     (?$(D:t(B . ?\x5C32) ;; <CJK>
     (?$(D:u(B . ?\x5C35) ;; <CJK>
     (?$(D:v(B . ?\x5C36) ;; <CJK>
     (?$(D:w(B . ?\x5C59) ;; <CJK>
     (?$(D:x(B . ?\x5C5A) ;; <CJK>
     (?$(D:y(B . ?\x5C5C) ;; <CJK>
     (?$(D:z(B . ?\x5C62) ;; <CJK>
     (?$(D:{(B . ?\x5C63) ;; <CJK>
     (?$(D:|(B . ?\x5C67) ;; <CJK>
     (?$(D:}(B . ?\x5C68) ;; <CJK>
     (?$(D:~(B . ?\x5C69) ;; <CJK>
     (?$(D;!(B . ?\x5C6D) ;; <CJK>
     (?$(D;"(B . ?\x5C70) ;; <CJK>
     (?$(D;#(B . ?\x5C74) ;; <CJK>
     (?$(D;$(B . ?\x5C75) ;; <CJK>
     (?$(D;%(B . ?\x5C7A) ;; <CJK>
     (?$(D;&(B . ?\x5C7B) ;; <CJK>
     (?$(D;'(B . ?\x5C7C) ;; <CJK>
     (?$(D;((B . ?\x5C7D) ;; <CJK>
     (?$(D;)(B . ?\x5C87) ;; <CJK>
     (?$(D;*(B . ?\x5C88) ;; <CJK>
     (?$(D;+(B . ?\x5C8A) ;; <CJK>
     (?$(D;,(B . ?\x5C8F) ;; <CJK>
     (?$(D;-(B . ?\x5C92) ;; <CJK>
     (?$(D;.(B . ?\x5C9D) ;; <CJK>
     (?$(D;/(B . ?\x5C9F) ;; <CJK>
     (?$(D;0(B . ?\x5CA0) ;; <CJK>
     (?$(D;1(B . ?\x5CA2) ;; <CJK>
     (?$(D;2(B . ?\x5CA3) ;; <CJK>
     (?$(D;3(B . ?\x5CA6) ;; <CJK>
     (?$(D;4(B . ?\x5CAA) ;; <CJK>
     (?$(D;5(B . ?\x5CB2) ;; <CJK>
     (?$(D;6(B . ?\x5CB4) ;; <CJK>
     (?$(D;7(B . ?\x5CB5) ;; <CJK>
     (?$(D;8(B . ?\x5CBA) ;; <CJK>
     (?$(D;9(B . ?\x5CC9) ;; <CJK>
     (?$(D;:(B . ?\x5CCB) ;; <CJK>
     (?$(D;;(B . ?\x5CD2) ;; <CJK>
     (?$(D;<(B . ?\x5CDD) ;; <CJK>
     (?$(D;=(B . ?\x5CD7) ;; <CJK>
     (?$(D;>(B . ?\x5CEE) ;; <CJK>
     (?$(D;?(B . ?\x5CF1) ;; <CJK>
     (?$(D;@(B . ?\x5CF2) ;; <CJK>
     (?$(D;A(B . ?\x5CF4) ;; <CJK>
     (?$(D;B(B . ?\x5D01) ;; <CJK>
     (?$(D;C(B . ?\x5D06) ;; <CJK>
     (?$(D;D(B . ?\x5D0D) ;; <CJK>
     (?$(D;E(B . ?\x5D12) ;; <CJK>
     (?$(D;F(B . ?\x5D2B) ;; <CJK>
     (?$(D;G(B . ?\x5D23) ;; <CJK>
     (?$(D;H(B . ?\x5D24) ;; <CJK>
     (?$(D;I(B . ?\x5D26) ;; <CJK>
     (?$(D;J(B . ?\x5D27) ;; <CJK>
     (?$(D;K(B . ?\x5D31) ;; <CJK>
     (?$(D;L(B . ?\x5D34) ;; <CJK>
     (?$(D;M(B . ?\x5D39) ;; <CJK>
     (?$(D;N(B . ?\x5D3D) ;; <CJK>
     (?$(D;O(B . ?\x5D3F) ;; <CJK>
     (?$(D;P(B . ?\x5D42) ;; <CJK>
     (?$(D;Q(B . ?\x5D43) ;; <CJK>
     (?$(D;R(B . ?\x5D46) ;; <CJK>
     (?$(D;S(B . ?\x5D48) ;; <CJK>
     (?$(D;T(B . ?\x5D55) ;; <CJK>
     (?$(D;U(B . ?\x5D51) ;; <CJK>
     (?$(D;V(B . ?\x5D59) ;; <CJK>
     (?$(D;W(B . ?\x5D4A) ;; <CJK>
     (?$(D;X(B . ?\x5D5F) ;; <CJK>
     (?$(D;Y(B . ?\x5D60) ;; <CJK>
     (?$(D;Z(B . ?\x5D61) ;; <CJK>
     (?$(D;[(B . ?\x5D62) ;; <CJK>
     (?$(D;\(B . ?\x5D64) ;; <CJK>
     (?$(D;](B . ?\x5D6A) ;; <CJK>
     (?$(D;^(B . ?\x5D6D) ;; <CJK>
     (?$(D;_(B . ?\x5D70) ;; <CJK>
     (?$(D;`(B . ?\x5D79) ;; <CJK>
     (?$(D;a(B . ?\x5D7A) ;; <CJK>
     (?$(D;b(B . ?\x5D7E) ;; <CJK>
     (?$(D;c(B . ?\x5D7F) ;; <CJK>
     (?$(D;d(B . ?\x5D81) ;; <CJK>
     (?$(D;e(B . ?\x5D83) ;; <CJK>
     (?$(D;f(B . ?\x5D88) ;; <CJK>
     (?$(D;g(B . ?\x5D8A) ;; <CJK>
     (?$(D;h(B . ?\x5D92) ;; <CJK>
     (?$(D;i(B . ?\x5D93) ;; <CJK>
     (?$(D;j(B . ?\x5D94) ;; <CJK>
     (?$(D;k(B . ?\x5D95) ;; <CJK>
     (?$(D;l(B . ?\x5D99) ;; <CJK>
     (?$(D;m(B . ?\x5D9B) ;; <CJK>
     (?$(D;n(B . ?\x5D9F) ;; <CJK>
     (?$(D;o(B . ?\x5DA0) ;; <CJK>
     (?$(D;p(B . ?\x5DA7) ;; <CJK>
     (?$(D;q(B . ?\x5DAB) ;; <CJK>
     (?$(D;r(B . ?\x5DB0) ;; <CJK>
     (?$(D;s(B . ?\x5DB4) ;; <CJK>
     (?$(D;t(B . ?\x5DB8) ;; <CJK>
     (?$(D;u(B . ?\x5DB9) ;; <CJK>
     (?$(D;v(B . ?\x5DC3) ;; <CJK>
     (?$(D;w(B . ?\x5DC7) ;; <CJK>
     (?$(D;x(B . ?\x5DCB) ;; <CJK>
     (?$(D;y(B . ?\x5DD0) ;; <CJK>
     (?$(D;z(B . ?\x5DCE) ;; <CJK>
     (?$(D;{(B . ?\x5DD8) ;; <CJK>
     (?$(D;|(B . ?\x5DD9) ;; <CJK>
     (?$(D;}(B . ?\x5DE0) ;; <CJK>
     (?$(D;~(B . ?\x5DE4) ;; <CJK>
     (?$(D<!(B . ?\x5DE9) ;; <CJK>
     (?$(D<"(B . ?\x5DF8) ;; <CJK>
     (?$(D<#(B . ?\x5DF9) ;; <CJK>
     (?$(D<$(B . ?\x5E00) ;; <CJK>
     (?$(D<%(B . ?\x5E07) ;; <CJK>
     (?$(D<&(B . ?\x5E0D) ;; <CJK>
     (?$(D<'(B . ?\x5E12) ;; <CJK>
     (?$(D<((B . ?\x5E14) ;; <CJK>
     (?$(D<)(B . ?\x5E15) ;; <CJK>
     (?$(D<*(B . ?\x5E18) ;; <CJK>
     (?$(D<+(B . ?\x5E1F) ;; <CJK>
     (?$(D<,(B . ?\x5E20) ;; <CJK>
     (?$(D<-(B . ?\x5E2E) ;; <CJK>
     (?$(D<.(B . ?\x5E28) ;; <CJK>
     (?$(D</(B . ?\x5E32) ;; <CJK>
     (?$(D<0(B . ?\x5E35) ;; <CJK>
     (?$(D<1(B . ?\x5E3E) ;; <CJK>
     (?$(D<2(B . ?\x5E4B) ;; <CJK>
     (?$(D<3(B . ?\x5E50) ;; <CJK>
     (?$(D<4(B . ?\x5E49) ;; <CJK>
     (?$(D<5(B . ?\x5E51) ;; <CJK>
     (?$(D<6(B . ?\x5E56) ;; <CJK>
     (?$(D<7(B . ?\x5E58) ;; <CJK>
     (?$(D<8(B . ?\x5E5B) ;; <CJK>
     (?$(D<9(B . ?\x5E5C) ;; <CJK>
     (?$(D<:(B . ?\x5E5E) ;; <CJK>
     (?$(D<;(B . ?\x5E68) ;; <CJK>
     (?$(D<<(B . ?\x5E6A) ;; <CJK>
     (?$(D<=(B . ?\x5E6B) ;; <CJK>
     (?$(D<>(B . ?\x5E6C) ;; <CJK>
     (?$(D<?(B . ?\x5E6D) ;; <CJK>
     (?$(D<@(B . ?\x5E6E) ;; <CJK>
     (?$(D<A(B . ?\x5E70) ;; <CJK>
     (?$(D<B(B . ?\x5E80) ;; <CJK>
     (?$(D<C(B . ?\x5E8B) ;; <CJK>
     (?$(D<D(B . ?\x5E8E) ;; <CJK>
     (?$(D<E(B . ?\x5EA2) ;; <CJK>
     (?$(D<F(B . ?\x5EA4) ;; <CJK>
     (?$(D<G(B . ?\x5EA5) ;; <CJK>
     (?$(D<H(B . ?\x5EA8) ;; <CJK>
     (?$(D<I(B . ?\x5EAA) ;; <CJK>
     (?$(D<J(B . ?\x5EAC) ;; <CJK>
     (?$(D<K(B . ?\x5EB1) ;; <CJK>
     (?$(D<L(B . ?\x5EB3) ;; <CJK>
     (?$(D<M(B . ?\x5EBD) ;; <CJK>
     (?$(D<N(B . ?\x5EBE) ;; <CJK>
     (?$(D<O(B . ?\x5EBF) ;; <CJK>
     (?$(D<P(B . ?\x5EC6) ;; <CJK>
     (?$(D<Q(B . ?\x5ECC) ;; <CJK>
     (?$(D<R(B . ?\x5ECB) ;; <CJK>
     (?$(D<S(B . ?\x5ECE) ;; <CJK>
     (?$(D<T(B . ?\x5ED1) ;; <CJK>
     (?$(D<U(B . ?\x5ED2) ;; <CJK>
     (?$(D<V(B . ?\x5ED4) ;; <CJK>
     (?$(D<W(B . ?\x5ED5) ;; <CJK>
     (?$(D<X(B . ?\x5EDC) ;; <CJK>
     (?$(D<Y(B . ?\x5EDE) ;; <CJK>
     (?$(D<Z(B . ?\x5EE5) ;; <CJK>
     (?$(D<[(B . ?\x5EEB) ;; <CJK>
     (?$(D<\(B . ?\x5F02) ;; <CJK>
     (?$(D<](B . ?\x5F06) ;; <CJK>
     (?$(D<^(B . ?\x5F07) ;; <CJK>
     (?$(D<_(B . ?\x5F08) ;; <CJK>
     (?$(D<`(B . ?\x5F0E) ;; <CJK>
     (?$(D<a(B . ?\x5F19) ;; <CJK>
     (?$(D<b(B . ?\x5F1C) ;; <CJK>
     (?$(D<c(B . ?\x5F1D) ;; <CJK>
     (?$(D<d(B . ?\x5F21) ;; <CJK>
     (?$(D<e(B . ?\x5F22) ;; <CJK>
     (?$(D<f(B . ?\x5F23) ;; <CJK>
     (?$(D<g(B . ?\x5F24) ;; <CJK>
     (?$(D<h(B . ?\x5F28) ;; <CJK>
     (?$(D<i(B . ?\x5F2B) ;; <CJK>
     (?$(D<j(B . ?\x5F2C) ;; <CJK>
     (?$(D<k(B . ?\x5F2E) ;; <CJK>
     (?$(D<l(B . ?\x5F30) ;; <CJK>
     (?$(D<m(B . ?\x5F34) ;; <CJK>
     (?$(D<n(B . ?\x5F36) ;; <CJK>
     (?$(D<o(B . ?\x5F3B) ;; <CJK>
     (?$(D<p(B . ?\x5F3D) ;; <CJK>
     (?$(D<q(B . ?\x5F3F) ;; <CJK>
     (?$(D<r(B . ?\x5F40) ;; <CJK>
     (?$(D<s(B . ?\x5F44) ;; <CJK>
     (?$(D<t(B . ?\x5F45) ;; <CJK>
     (?$(D<u(B . ?\x5F47) ;; <CJK>
     (?$(D<v(B . ?\x5F4D) ;; <CJK>
     (?$(D<w(B . ?\x5F50) ;; <CJK>
     (?$(D<x(B . ?\x5F54) ;; <CJK>
     (?$(D<y(B . ?\x5F58) ;; <CJK>
     (?$(D<z(B . ?\x5F5B) ;; <CJK>
     (?$(D<{(B . ?\x5F60) ;; <CJK>
     (?$(D<|(B . ?\x5F63) ;; <CJK>
     (?$(D<}(B . ?\x5F64) ;; <CJK>
     (?$(D<~(B . ?\x5F67) ;; <CJK>
     (?$(D=!(B . ?\x5F6F) ;; <CJK>
     (?$(D="(B . ?\x5F72) ;; <CJK>
     (?$(D=#(B . ?\x5F74) ;; <CJK>
     (?$(D=$(B . ?\x5F75) ;; <CJK>
     (?$(D=%(B . ?\x5F78) ;; <CJK>
     (?$(D=&(B . ?\x5F7A) ;; <CJK>
     (?$(D='(B . ?\x5F7D) ;; <CJK>
     (?$(D=((B . ?\x5F7E) ;; <CJK>
     (?$(D=)(B . ?\x5F89) ;; <CJK>
     (?$(D=*(B . ?\x5F8D) ;; <CJK>
     (?$(D=+(B . ?\x5F8F) ;; <CJK>
     (?$(D=,(B . ?\x5F96) ;; <CJK>
     (?$(D=-(B . ?\x5F9C) ;; <CJK>
     (?$(D=.(B . ?\x5F9D) ;; <CJK>
     (?$(D=/(B . ?\x5FA2) ;; <CJK>
     (?$(D=0(B . ?\x5FA7) ;; <CJK>
     (?$(D=1(B . ?\x5FAB) ;; <CJK>
     (?$(D=2(B . ?\x5FA4) ;; <CJK>
     (?$(D=3(B . ?\x5FAC) ;; <CJK>
     (?$(D=4(B . ?\x5FAF) ;; <CJK>
     (?$(D=5(B . ?\x5FB0) ;; <CJK>
     (?$(D=6(B . ?\x5FB1) ;; <CJK>
     (?$(D=7(B . ?\x5FB8) ;; <CJK>
     (?$(D=8(B . ?\x5FC4) ;; <CJK>
     (?$(D=9(B . ?\x5FC7) ;; <CJK>
     (?$(D=:(B . ?\x5FC8) ;; <CJK>
     (?$(D=;(B . ?\x5FC9) ;; <CJK>
     (?$(D=<(B . ?\x5FCB) ;; <CJK>
     (?$(D==(B . ?\x5FD0) ;; <CJK>
     (?$(D=>(B . ?\x5FD1) ;; <CJK>
     (?$(D=?(B . ?\x5FD2) ;; <CJK>
     (?$(D=@(B . ?\x5FD3) ;; <CJK>
     (?$(D=A(B . ?\x5FD4) ;; <CJK>
     (?$(D=B(B . ?\x5FDE) ;; <CJK>
     (?$(D=C(B . ?\x5FE1) ;; <CJK>
     (?$(D=D(B . ?\x5FE2) ;; <CJK>
     (?$(D=E(B . ?\x5FE8) ;; <CJK>
     (?$(D=F(B . ?\x5FE9) ;; <CJK>
     (?$(D=G(B . ?\x5FEA) ;; <CJK>
     (?$(D=H(B . ?\x5FEC) ;; <CJK>
     (?$(D=I(B . ?\x5FED) ;; <CJK>
     (?$(D=J(B . ?\x5FEE) ;; <CJK>
     (?$(D=K(B . ?\x5FEF) ;; <CJK>
     (?$(D=L(B . ?\x5FF2) ;; <CJK>
     (?$(D=M(B . ?\x5FF3) ;; <CJK>
     (?$(D=N(B . ?\x5FF6) ;; <CJK>
     (?$(D=O(B . ?\x5FFA) ;; <CJK>
     (?$(D=P(B . ?\x5FFC) ;; <CJK>
     (?$(D=Q(B . ?\x6007) ;; <CJK>
     (?$(D=R(B . ?\x600A) ;; <CJK>
     (?$(D=S(B . ?\x600D) ;; <CJK>
     (?$(D=T(B . ?\x6013) ;; <CJK>
     (?$(D=U(B . ?\x6014) ;; <CJK>
     (?$(D=V(B . ?\x6017) ;; <CJK>
     (?$(D=W(B . ?\x6018) ;; <CJK>
     (?$(D=X(B . ?\x601A) ;; <CJK>
     (?$(D=Y(B . ?\x601F) ;; <CJK>
     (?$(D=Z(B . ?\x6024) ;; <CJK>
     (?$(D=[(B . ?\x602D) ;; <CJK>
     (?$(D=\(B . ?\x6033) ;; <CJK>
     (?$(D=](B . ?\x6035) ;; <CJK>
     (?$(D=^(B . ?\x6040) ;; <CJK>
     (?$(D=_(B . ?\x6047) ;; <CJK>
     (?$(D=`(B . ?\x6048) ;; <CJK>
     (?$(D=a(B . ?\x6049) ;; <CJK>
     (?$(D=b(B . ?\x604C) ;; <CJK>
     (?$(D=c(B . ?\x6051) ;; <CJK>
     (?$(D=d(B . ?\x6054) ;; <CJK>
     (?$(D=e(B . ?\x6056) ;; <CJK>
     (?$(D=f(B . ?\x6057) ;; <CJK>
     (?$(D=g(B . ?\x605D) ;; <CJK>
     (?$(D=h(B . ?\x6061) ;; <CJK>
     (?$(D=i(B . ?\x6067) ;; <CJK>
     (?$(D=j(B . ?\x6071) ;; <CJK>
     (?$(D=k(B . ?\x607E) ;; <CJK>
     (?$(D=l(B . ?\x607F) ;; <CJK>
     (?$(D=m(B . ?\x6082) ;; <CJK>
     (?$(D=n(B . ?\x6086) ;; <CJK>
     (?$(D=o(B . ?\x6088) ;; <CJK>
     (?$(D=p(B . ?\x608A) ;; <CJK>
     (?$(D=q(B . ?\x608E) ;; <CJK>
     (?$(D=r(B . ?\x6091) ;; <CJK>
     (?$(D=s(B . ?\x6093) ;; <CJK>
     (?$(D=t(B . ?\x6095) ;; <CJK>
     (?$(D=u(B . ?\x6098) ;; <CJK>
     (?$(D=v(B . ?\x609D) ;; <CJK>
     (?$(D=w(B . ?\x609E) ;; <CJK>
     (?$(D=x(B . ?\x60A2) ;; <CJK>
     (?$(D=y(B . ?\x60A4) ;; <CJK>
     (?$(D=z(B . ?\x60A5) ;; <CJK>
     (?$(D={(B . ?\x60A8) ;; <CJK>
     (?$(D=|(B . ?\x60B0) ;; <CJK>
     (?$(D=}(B . ?\x60B1) ;; <CJK>
     (?$(D=~(B . ?\x60B7) ;; <CJK>
     (?$(D>!(B . ?\x60BB) ;; <CJK>
     (?$(D>"(B . ?\x60BE) ;; <CJK>
     (?$(D>#(B . ?\x60C2) ;; <CJK>
     (?$(D>$(B . ?\x60C4) ;; <CJK>
     (?$(D>%(B . ?\x60C8) ;; <CJK>
     (?$(D>&(B . ?\x60C9) ;; <CJK>
     (?$(D>'(B . ?\x60CA) ;; <CJK>
     (?$(D>((B . ?\x60CB) ;; <CJK>
     (?$(D>)(B . ?\x60CE) ;; <CJK>
     (?$(D>*(B . ?\x60CF) ;; <CJK>
     (?$(D>+(B . ?\x60D4) ;; <CJK>
     (?$(D>,(B . ?\x60D5) ;; <CJK>
     (?$(D>-(B . ?\x60D9) ;; <CJK>
     (?$(D>.(B . ?\x60DB) ;; <CJK>
     (?$(D>/(B . ?\x60DD) ;; <CJK>
     (?$(D>0(B . ?\x60DE) ;; <CJK>
     (?$(D>1(B . ?\x60E2) ;; <CJK>
     (?$(D>2(B . ?\x60E5) ;; <CJK>
     (?$(D>3(B . ?\x60F2) ;; <CJK>
     (?$(D>4(B . ?\x60F5) ;; <CJK>
     (?$(D>5(B . ?\x60F8) ;; <CJK>
     (?$(D>6(B . ?\x60FC) ;; <CJK>
     (?$(D>7(B . ?\x60FD) ;; <CJK>
     (?$(D>8(B . ?\x6102) ;; <CJK>
     (?$(D>9(B . ?\x6107) ;; <CJK>
     (?$(D>:(B . ?\x610A) ;; <CJK>
     (?$(D>;(B . ?\x610C) ;; <CJK>
     (?$(D><(B . ?\x6110) ;; <CJK>
     (?$(D>=(B . ?\x6111) ;; <CJK>
     (?$(D>>(B . ?\x6112) ;; <CJK>
     (?$(D>?(B . ?\x6113) ;; <CJK>
     (?$(D>@(B . ?\x6114) ;; <CJK>
     (?$(D>A(B . ?\x6116) ;; <CJK>
     (?$(D>B(B . ?\x6117) ;; <CJK>
     (?$(D>C(B . ?\x6119) ;; <CJK>
     (?$(D>D(B . ?\x611C) ;; <CJK>
     (?$(D>E(B . ?\x611E) ;; <CJK>
     (?$(D>F(B . ?\x6122) ;; <CJK>
     (?$(D>G(B . ?\x612A) ;; <CJK>
     (?$(D>H(B . ?\x612B) ;; <CJK>
     (?$(D>I(B . ?\x6130) ;; <CJK>
     (?$(D>J(B . ?\x6131) ;; <CJK>
     (?$(D>K(B . ?\x6135) ;; <CJK>
     (?$(D>L(B . ?\x6136) ;; <CJK>
     (?$(D>M(B . ?\x6137) ;; <CJK>
     (?$(D>N(B . ?\x6139) ;; <CJK>
     (?$(D>O(B . ?\x6141) ;; <CJK>
     (?$(D>P(B . ?\x6145) ;; <CJK>
     (?$(D>Q(B . ?\x6146) ;; <CJK>
     (?$(D>R(B . ?\x6149) ;; <CJK>
     (?$(D>S(B . ?\x615E) ;; <CJK>
     (?$(D>T(B . ?\x6160) ;; <CJK>
     (?$(D>U(B . ?\x616C) ;; <CJK>
     (?$(D>V(B . ?\x6172) ;; <CJK>
     (?$(D>W(B . ?\x6178) ;; <CJK>
     (?$(D>X(B . ?\x617B) ;; <CJK>
     (?$(D>Y(B . ?\x617C) ;; <CJK>
     (?$(D>Z(B . ?\x617F) ;; <CJK>
     (?$(D>[(B . ?\x6180) ;; <CJK>
     (?$(D>\(B . ?\x6181) ;; <CJK>
     (?$(D>](B . ?\x6183) ;; <CJK>
     (?$(D>^(B . ?\x6184) ;; <CJK>
     (?$(D>_(B . ?\x618B) ;; <CJK>
     (?$(D>`(B . ?\x618D) ;; <CJK>
     (?$(D>a(B . ?\x6192) ;; <CJK>
     (?$(D>b(B . ?\x6193) ;; <CJK>
     (?$(D>c(B . ?\x6197) ;; <CJK>
     (?$(D>d(B . ?\x6198) ;; <CJK>
     (?$(D>e(B . ?\x619C) ;; <CJK>
     (?$(D>f(B . ?\x619D) ;; <CJK>
     (?$(D>g(B . ?\x619F) ;; <CJK>
     (?$(D>h(B . ?\x61A0) ;; <CJK>
     (?$(D>i(B . ?\x61A5) ;; <CJK>
     (?$(D>j(B . ?\x61A8) ;; <CJK>
     (?$(D>k(B . ?\x61AA) ;; <CJK>
     (?$(D>l(B . ?\x61AD) ;; <CJK>
     (?$(D>m(B . ?\x61B8) ;; <CJK>
     (?$(D>n(B . ?\x61B9) ;; <CJK>
     (?$(D>o(B . ?\x61BC) ;; <CJK>
     (?$(D>p(B . ?\x61C0) ;; <CJK>
     (?$(D>q(B . ?\x61C1) ;; <CJK>
     (?$(D>r(B . ?\x61C2) ;; <CJK>
     (?$(D>s(B . ?\x61CE) ;; <CJK>
     (?$(D>t(B . ?\x61CF) ;; <CJK>
     (?$(D>u(B . ?\x61D5) ;; <CJK>
     (?$(D>v(B . ?\x61DC) ;; <CJK>
     (?$(D>w(B . ?\x61DD) ;; <CJK>
     (?$(D>x(B . ?\x61DE) ;; <CJK>
     (?$(D>y(B . ?\x61DF) ;; <CJK>
     (?$(D>z(B . ?\x61E1) ;; <CJK>
     (?$(D>{(B . ?\x61E2) ;; <CJK>
     (?$(D>|(B . ?\x61E7) ;; <CJK>
     (?$(D>}(B . ?\x61E9) ;; <CJK>
     (?$(D>~(B . ?\x61E5) ;; <CJK>
     (?$(D?!(B . ?\x61EC) ;; <CJK>
     (?$(D?"(B . ?\x61ED) ;; <CJK>
     (?$(D?#(B . ?\x61EF) ;; <CJK>
     (?$(D?$(B . ?\x6201) ;; <CJK>
     (?$(D?%(B . ?\x6203) ;; <CJK>
     (?$(D?&(B . ?\x6204) ;; <CJK>
     (?$(D?'(B . ?\x6207) ;; <CJK>
     (?$(D?((B . ?\x6213) ;; <CJK>
     (?$(D?)(B . ?\x6215) ;; <CJK>
     (?$(D?*(B . ?\x621C) ;; <CJK>
     (?$(D?+(B . ?\x6220) ;; <CJK>
     (?$(D?,(B . ?\x6222) ;; <CJK>
     (?$(D?-(B . ?\x6223) ;; <CJK>
     (?$(D?.(B . ?\x6227) ;; <CJK>
     (?$(D?/(B . ?\x6229) ;; <CJK>
     (?$(D?0(B . ?\x622B) ;; <CJK>
     (?$(D?1(B . ?\x6239) ;; <CJK>
     (?$(D?2(B . ?\x623D) ;; <CJK>
     (?$(D?3(B . ?\x6242) ;; <CJK>
     (?$(D?4(B . ?\x6243) ;; <CJK>
     (?$(D?5(B . ?\x6244) ;; <CJK>
     (?$(D?6(B . ?\x6246) ;; <CJK>
     (?$(D?7(B . ?\x624C) ;; <CJK>
     (?$(D?8(B . ?\x6250) ;; <CJK>
     (?$(D?9(B . ?\x6251) ;; <CJK>
     (?$(D?:(B . ?\x6252) ;; <CJK>
     (?$(D?;(B . ?\x6254) ;; <CJK>
     (?$(D?<(B . ?\x6256) ;; <CJK>
     (?$(D?=(B . ?\x625A) ;; <CJK>
     (?$(D?>(B . ?\x625C) ;; <CJK>
     (?$(D??(B . ?\x6264) ;; <CJK>
     (?$(D?@(B . ?\x626D) ;; <CJK>
     (?$(D?A(B . ?\x626F) ;; <CJK>
     (?$(D?B(B . ?\x6273) ;; <CJK>
     (?$(D?C(B . ?\x627A) ;; <CJK>
     (?$(D?D(B . ?\x627D) ;; <CJK>
     (?$(D?E(B . ?\x628D) ;; <CJK>
     (?$(D?F(B . ?\x628E) ;; <CJK>
     (?$(D?G(B . ?\x628F) ;; <CJK>
     (?$(D?H(B . ?\x6290) ;; <CJK>
     (?$(D?I(B . ?\x62A6) ;; <CJK>
     (?$(D?J(B . ?\x62A8) ;; <CJK>
     (?$(D?K(B . ?\x62B3) ;; <CJK>
     (?$(D?L(B . ?\x62B6) ;; <CJK>
     (?$(D?M(B . ?\x62B7) ;; <CJK>
     (?$(D?N(B . ?\x62BA) ;; <CJK>
     (?$(D?O(B . ?\x62BE) ;; <CJK>
     (?$(D?P(B . ?\x62BF) ;; <CJK>
     (?$(D?Q(B . ?\x62C4) ;; <CJK>
     (?$(D?R(B . ?\x62CE) ;; <CJK>
     (?$(D?S(B . ?\x62D5) ;; <CJK>
     (?$(D?T(B . ?\x62D6) ;; <CJK>
     (?$(D?U(B . ?\x62DA) ;; <CJK>
     (?$(D?V(B . ?\x62EA) ;; <CJK>
     (?$(D?W(B . ?\x62F2) ;; <CJK>
     (?$(D?X(B . ?\x62F4) ;; <CJK>
     (?$(D?Y(B . ?\x62FC) ;; <CJK>
     (?$(D?Z(B . ?\x62FD) ;; <CJK>
     (?$(D?[(B . ?\x6303) ;; <CJK>
     (?$(D?\(B . ?\x6304) ;; <CJK>
     (?$(D?](B . ?\x630A) ;; <CJK>
     (?$(D?^(B . ?\x630B) ;; <CJK>
     (?$(D?_(B . ?\x630D) ;; <CJK>
     (?$(D?`(B . ?\x6310) ;; <CJK>
     (?$(D?a(B . ?\x6313) ;; <CJK>
     (?$(D?b(B . ?\x6316) ;; <CJK>
     (?$(D?c(B . ?\x6318) ;; <CJK>
     (?$(D?d(B . ?\x6329) ;; <CJK>
     (?$(D?e(B . ?\x632A) ;; <CJK>
     (?$(D?f(B . ?\x632D) ;; <CJK>
     (?$(D?g(B . ?\x6335) ;; <CJK>
     (?$(D?h(B . ?\x6336) ;; <CJK>
     (?$(D?i(B . ?\x6339) ;; <CJK>
     (?$(D?j(B . ?\x633C) ;; <CJK>
     (?$(D?k(B . ?\x6341) ;; <CJK>
     (?$(D?l(B . ?\x6342) ;; <CJK>
     (?$(D?m(B . ?\x6343) ;; <CJK>
     (?$(D?n(B . ?\x6344) ;; <CJK>
     (?$(D?o(B . ?\x6346) ;; <CJK>
     (?$(D?p(B . ?\x634A) ;; <CJK>
     (?$(D?q(B . ?\x634B) ;; <CJK>
     (?$(D?r(B . ?\x634E) ;; <CJK>
     (?$(D?s(B . ?\x6352) ;; <CJK>
     (?$(D?t(B . ?\x6353) ;; <CJK>
     (?$(D?u(B . ?\x6354) ;; <CJK>
     (?$(D?v(B . ?\x6358) ;; <CJK>
     (?$(D?w(B . ?\x635B) ;; <CJK>
     (?$(D?x(B . ?\x6365) ;; <CJK>
     (?$(D?y(B . ?\x6366) ;; <CJK>
     (?$(D?z(B . ?\x636C) ;; <CJK>
     (?$(D?{(B . ?\x636D) ;; <CJK>
     (?$(D?|(B . ?\x6371) ;; <CJK>
     (?$(D?}(B . ?\x6374) ;; <CJK>
     (?$(D?~(B . ?\x6375) ;; <CJK>
     (?$(D@!(B . ?\x6378) ;; <CJK>
     (?$(D@"(B . ?\x637C) ;; <CJK>
     (?$(D@#(B . ?\x637D) ;; <CJK>
     (?$(D@$(B . ?\x637F) ;; <CJK>
     (?$(D@%(B . ?\x6382) ;; <CJK>
     (?$(D@&(B . ?\x6384) ;; <CJK>
     (?$(D@'(B . ?\x6387) ;; <CJK>
     (?$(D@((B . ?\x638A) ;; <CJK>
     (?$(D@)(B . ?\x6390) ;; <CJK>
     (?$(D@*(B . ?\x6394) ;; <CJK>
     (?$(D@+(B . ?\x6395) ;; <CJK>
     (?$(D@,(B . ?\x6399) ;; <CJK>
     (?$(D@-(B . ?\x639A) ;; <CJK>
     (?$(D@.(B . ?\x639E) ;; <CJK>
     (?$(D@/(B . ?\x63A4) ;; <CJK>
     (?$(D@0(B . ?\x63A6) ;; <CJK>
     (?$(D@1(B . ?\x63AD) ;; <CJK>
     (?$(D@2(B . ?\x63AE) ;; <CJK>
     (?$(D@3(B . ?\x63AF) ;; <CJK>
     (?$(D@4(B . ?\x63BD) ;; <CJK>
     (?$(D@5(B . ?\x63C1) ;; <CJK>
     (?$(D@6(B . ?\x63C5) ;; <CJK>
     (?$(D@7(B . ?\x63C8) ;; <CJK>
     (?$(D@8(B . ?\x63CE) ;; <CJK>
     (?$(D@9(B . ?\x63D1) ;; <CJK>
     (?$(D@:(B . ?\x63D3) ;; <CJK>
     (?$(D@;(B . ?\x63D4) ;; <CJK>
     (?$(D@<(B . ?\x63D5) ;; <CJK>
     (?$(D@=(B . ?\x63DC) ;; <CJK>
     (?$(D@>(B . ?\x63E0) ;; <CJK>
     (?$(D@?(B . ?\x63E5) ;; <CJK>
     (?$(D@@(B . ?\x63EA) ;; <CJK>
     (?$(D@A(B . ?\x63EC) ;; <CJK>
     (?$(D@B(B . ?\x63F2) ;; <CJK>
     (?$(D@C(B . ?\x63F3) ;; <CJK>
     (?$(D@D(B . ?\x63F5) ;; <CJK>
     (?$(D@E(B . ?\x63F8) ;; <CJK>
     (?$(D@F(B . ?\x63F9) ;; <CJK>
     (?$(D@G(B . ?\x6409) ;; <CJK>
     (?$(D@H(B . ?\x640A) ;; <CJK>
     (?$(D@I(B . ?\x6410) ;; <CJK>
     (?$(D@J(B . ?\x6412) ;; <CJK>
     (?$(D@K(B . ?\x6414) ;; <CJK>
     (?$(D@L(B . ?\x6418) ;; <CJK>
     (?$(D@M(B . ?\x641E) ;; <CJK>
     (?$(D@N(B . ?\x6420) ;; <CJK>
     (?$(D@O(B . ?\x6422) ;; <CJK>
     (?$(D@P(B . ?\x6424) ;; <CJK>
     (?$(D@Q(B . ?\x6425) ;; <CJK>
     (?$(D@R(B . ?\x6429) ;; <CJK>
     (?$(D@S(B . ?\x642A) ;; <CJK>
     (?$(D@T(B . ?\x642F) ;; <CJK>
     (?$(D@U(B . ?\x6430) ;; <CJK>
     (?$(D@V(B . ?\x6435) ;; <CJK>
     (?$(D@W(B . ?\x643D) ;; <CJK>
     (?$(D@X(B . ?\x643F) ;; <CJK>
     (?$(D@Y(B . ?\x644B) ;; <CJK>
     (?$(D@Z(B . ?\x644F) ;; <CJK>
     (?$(D@[(B . ?\x6451) ;; <CJK>
     (?$(D@\(B . ?\x6452) ;; <CJK>
     (?$(D@](B . ?\x6453) ;; <CJK>
     (?$(D@^(B . ?\x6454) ;; <CJK>
     (?$(D@_(B . ?\x645A) ;; <CJK>
     (?$(D@`(B . ?\x645B) ;; <CJK>
     (?$(D@a(B . ?\x645C) ;; <CJK>
     (?$(D@b(B . ?\x645D) ;; <CJK>
     (?$(D@c(B . ?\x645F) ;; <CJK>
     (?$(D@d(B . ?\x6460) ;; <CJK>
     (?$(D@e(B . ?\x6461) ;; <CJK>
     (?$(D@f(B . ?\x6463) ;; <CJK>
     (?$(D@g(B . ?\x646D) ;; <CJK>
     (?$(D@h(B . ?\x6473) ;; <CJK>
     (?$(D@i(B . ?\x6474) ;; <CJK>
     (?$(D@j(B . ?\x647B) ;; <CJK>
     (?$(D@k(B . ?\x647D) ;; <CJK>
     (?$(D@l(B . ?\x6485) ;; <CJK>
     (?$(D@m(B . ?\x6487) ;; <CJK>
     (?$(D@n(B . ?\x648F) ;; <CJK>
     (?$(D@o(B . ?\x6490) ;; <CJK>
     (?$(D@p(B . ?\x6491) ;; <CJK>
     (?$(D@q(B . ?\x6498) ;; <CJK>
     (?$(D@r(B . ?\x6499) ;; <CJK>
     (?$(D@s(B . ?\x649B) ;; <CJK>
     (?$(D@t(B . ?\x649D) ;; <CJK>
     (?$(D@u(B . ?\x649F) ;; <CJK>
     (?$(D@v(B . ?\x64A1) ;; <CJK>
     (?$(D@w(B . ?\x64A3) ;; <CJK>
     (?$(D@x(B . ?\x64A6) ;; <CJK>
     (?$(D@y(B . ?\x64A8) ;; <CJK>
     (?$(D@z(B . ?\x64AC) ;; <CJK>
     (?$(D@{(B . ?\x64B3) ;; <CJK>
     (?$(D@|(B . ?\x64BD) ;; <CJK>
     (?$(D@}(B . ?\x64BE) ;; <CJK>
     (?$(D@~(B . ?\x64BF) ;; <CJK>
     (?$(DA!(B . ?\x64C4) ;; <CJK>
     (?$(DA"(B . ?\x64C9) ;; <CJK>
     (?$(DA#(B . ?\x64CA) ;; <CJK>
     (?$(DA$(B . ?\x64CB) ;; <CJK>
     (?$(DA%(B . ?\x64CC) ;; <CJK>
     (?$(DA&(B . ?\x64CE) ;; <CJK>
     (?$(DA'(B . ?\x64D0) ;; <CJK>
     (?$(DA((B . ?\x64D1) ;; <CJK>
     (?$(DA)(B . ?\x64D5) ;; <CJK>
     (?$(DA*(B . ?\x64D7) ;; <CJK>
     (?$(DA+(B . ?\x64E4) ;; <CJK>
     (?$(DA,(B . ?\x64E5) ;; <CJK>
     (?$(DA-(B . ?\x64E9) ;; <CJK>
     (?$(DA.(B . ?\x64EA) ;; <CJK>
     (?$(DA/(B . ?\x64ED) ;; <CJK>
     (?$(DA0(B . ?\x64F0) ;; <CJK>
     (?$(DA1(B . ?\x64F5) ;; <CJK>
     (?$(DA2(B . ?\x64F7) ;; <CJK>
     (?$(DA3(B . ?\x64FB) ;; <CJK>
     (?$(DA4(B . ?\x64FF) ;; <CJK>
     (?$(DA5(B . ?\x6501) ;; <CJK>
     (?$(DA6(B . ?\x6504) ;; <CJK>
     (?$(DA7(B . ?\x6508) ;; <CJK>
     (?$(DA8(B . ?\x6509) ;; <CJK>
     (?$(DA9(B . ?\x650A) ;; <CJK>
     (?$(DA:(B . ?\x650F) ;; <CJK>
     (?$(DA;(B . ?\x6513) ;; <CJK>
     (?$(DA<(B . ?\x6514) ;; <CJK>
     (?$(DA=(B . ?\x6516) ;; <CJK>
     (?$(DA>(B . ?\x6519) ;; <CJK>
     (?$(DA?(B . ?\x651B) ;; <CJK>
     (?$(DA@(B . ?\x651E) ;; <CJK>
     (?$(DAA(B . ?\x651F) ;; <CJK>
     (?$(DAB(B . ?\x6522) ;; <CJK>
     (?$(DAC(B . ?\x6526) ;; <CJK>
     (?$(DAD(B . ?\x6529) ;; <CJK>
     (?$(DAE(B . ?\x652E) ;; <CJK>
     (?$(DAF(B . ?\x6531) ;; <CJK>
     (?$(DAG(B . ?\x653A) ;; <CJK>
     (?$(DAH(B . ?\x653C) ;; <CJK>
     (?$(DAI(B . ?\x653D) ;; <CJK>
     (?$(DAJ(B . ?\x6543) ;; <CJK>
     (?$(DAK(B . ?\x6547) ;; <CJK>
     (?$(DAL(B . ?\x6549) ;; <CJK>
     (?$(DAM(B . ?\x6550) ;; <CJK>
     (?$(DAN(B . ?\x6552) ;; <CJK>
     (?$(DAO(B . ?\x6554) ;; <CJK>
     (?$(DAP(B . ?\x655F) ;; <CJK>
     (?$(DAQ(B . ?\x6560) ;; <CJK>
     (?$(DAR(B . ?\x6567) ;; <CJK>
     (?$(DAS(B . ?\x656B) ;; <CJK>
     (?$(DAT(B . ?\x657A) ;; <CJK>
     (?$(DAU(B . ?\x657D) ;; <CJK>
     (?$(DAV(B . ?\x6581) ;; <CJK>
     (?$(DAW(B . ?\x6585) ;; <CJK>
     (?$(DAX(B . ?\x658A) ;; <CJK>
     (?$(DAY(B . ?\x6592) ;; <CJK>
     (?$(DAZ(B . ?\x6595) ;; <CJK>
     (?$(DA[(B . ?\x6598) ;; <CJK>
     (?$(DA\(B . ?\x659D) ;; <CJK>
     (?$(DA](B . ?\x65A0) ;; <CJK>
     (?$(DA^(B . ?\x65A3) ;; <CJK>
     (?$(DA_(B . ?\x65A6) ;; <CJK>
     (?$(DA`(B . ?\x65AE) ;; <CJK>
     (?$(DAa(B . ?\x65B2) ;; <CJK>
     (?$(DAb(B . ?\x65B3) ;; <CJK>
     (?$(DAc(B . ?\x65B4) ;; <CJK>
     (?$(DAd(B . ?\x65BF) ;; <CJK>
     (?$(DAe(B . ?\x65C2) ;; <CJK>
     (?$(DAf(B . ?\x65C8) ;; <CJK>
     (?$(DAg(B . ?\x65C9) ;; <CJK>
     (?$(DAh(B . ?\x65CE) ;; <CJK>
     (?$(DAi(B . ?\x65D0) ;; <CJK>
     (?$(DAj(B . ?\x65D4) ;; <CJK>
     (?$(DAk(B . ?\x65D6) ;; <CJK>
     (?$(DAl(B . ?\x65D8) ;; <CJK>
     (?$(DAm(B . ?\x65DF) ;; <CJK>
     (?$(DAn(B . ?\x65F0) ;; <CJK>
     (?$(DAo(B . ?\x65F2) ;; <CJK>
     (?$(DAp(B . ?\x65F4) ;; <CJK>
     (?$(DAq(B . ?\x65F5) ;; <CJK>
     (?$(DAr(B . ?\x65F9) ;; <CJK>
     (?$(DAs(B . ?\x65FE) ;; <CJK>
     (?$(DAt(B . ?\x65FF) ;; <CJK>
     (?$(DAu(B . ?\x6600) ;; <CJK>
     (?$(DAv(B . ?\x6604) ;; <CJK>
     (?$(DAw(B . ?\x6608) ;; <CJK>
     (?$(DAx(B . ?\x6609) ;; <CJK>
     (?$(DAy(B . ?\x660D) ;; <CJK>
     (?$(DAz(B . ?\x6611) ;; <CJK>
     (?$(DA{(B . ?\x6612) ;; <CJK>
     (?$(DA|(B . ?\x6615) ;; <CJK>
     (?$(DA}(B . ?\x6616) ;; <CJK>
     (?$(DA~(B . ?\x661D) ;; <CJK>
     (?$(DB!(B . ?\x661E) ;; <CJK>
     (?$(DB"(B . ?\x6621) ;; <CJK>
     (?$(DB#(B . ?\x6622) ;; <CJK>
     (?$(DB$(B . ?\x6623) ;; <CJK>
     (?$(DB%(B . ?\x6624) ;; <CJK>
     (?$(DB&(B . ?\x6626) ;; <CJK>
     (?$(DB'(B . ?\x6629) ;; <CJK>
     (?$(DB((B . ?\x662A) ;; <CJK>
     (?$(DB)(B . ?\x662B) ;; <CJK>
     (?$(DB*(B . ?\x662C) ;; <CJK>
     (?$(DB+(B . ?\x662E) ;; <CJK>
     (?$(DB,(B . ?\x6630) ;; <CJK>
     (?$(DB-(B . ?\x6631) ;; <CJK>
     (?$(DB.(B . ?\x6633) ;; <CJK>
     (?$(DB/(B . ?\x6639) ;; <CJK>
     (?$(DB0(B . ?\x6637) ;; <CJK>
     (?$(DB1(B . ?\x6640) ;; <CJK>
     (?$(DB2(B . ?\x6645) ;; <CJK>
     (?$(DB3(B . ?\x6646) ;; <CJK>
     (?$(DB4(B . ?\x664A) ;; <CJK>
     (?$(DB5(B . ?\x664C) ;; <CJK>
     (?$(DB6(B . ?\x6651) ;; <CJK>
     (?$(DB7(B . ?\x664E) ;; <CJK>
     (?$(DB8(B . ?\x6657) ;; <CJK>
     (?$(DB9(B . ?\x6658) ;; <CJK>
     (?$(DB:(B . ?\x6659) ;; <CJK>
     (?$(DB;(B . ?\x665B) ;; <CJK>
     (?$(DB<(B . ?\x665C) ;; <CJK>
     (?$(DB=(B . ?\x6660) ;; <CJK>
     (?$(DB>(B . ?\x6661) ;; <CJK>
     (?$(DB?(B . ?\x66FB) ;; <CJK>
     (?$(DB@(B . ?\x666A) ;; <CJK>
     (?$(DBA(B . ?\x666B) ;; <CJK>
     (?$(DBB(B . ?\x666C) ;; <CJK>
     (?$(DBC(B . ?\x667E) ;; <CJK>
     (?$(DBD(B . ?\x6673) ;; <CJK>
     (?$(DBE(B . ?\x6675) ;; <CJK>
     (?$(DBF(B . ?\x667F) ;; <CJK>
     (?$(DBG(B . ?\x6677) ;; <CJK>
     (?$(DBH(B . ?\x6678) ;; <CJK>
     (?$(DBI(B . ?\x6679) ;; <CJK>
     (?$(DBJ(B . ?\x667B) ;; <CJK>
     (?$(DBK(B . ?\x6680) ;; <CJK>
     (?$(DBL(B . ?\x667C) ;; <CJK>
     (?$(DBM(B . ?\x668B) ;; <CJK>
     (?$(DBN(B . ?\x668C) ;; <CJK>
     (?$(DBO(B . ?\x668D) ;; <CJK>
     (?$(DBP(B . ?\x6690) ;; <CJK>
     (?$(DBQ(B . ?\x6692) ;; <CJK>
     (?$(DBR(B . ?\x6699) ;; <CJK>
     (?$(DBS(B . ?\x669A) ;; <CJK>
     (?$(DBT(B . ?\x669B) ;; <CJK>
     (?$(DBU(B . ?\x669C) ;; <CJK>
     (?$(DBV(B . ?\x669F) ;; <CJK>
     (?$(DBW(B . ?\x66A0) ;; <CJK>
     (?$(DBX(B . ?\x66A4) ;; <CJK>
     (?$(DBY(B . ?\x66AD) ;; <CJK>
     (?$(DBZ(B . ?\x66B1) ;; <CJK>
     (?$(DB[(B . ?\x66B2) ;; <CJK>
     (?$(DB\(B . ?\x66B5) ;; <CJK>
     (?$(DB](B . ?\x66BB) ;; <CJK>
     (?$(DB^(B . ?\x66BF) ;; <CJK>
     (?$(DB_(B . ?\x66C0) ;; <CJK>
     (?$(DB`(B . ?\x66C2) ;; <CJK>
     (?$(DBa(B . ?\x66C3) ;; <CJK>
     (?$(DBb(B . ?\x66C8) ;; <CJK>
     (?$(DBc(B . ?\x66CC) ;; <CJK>
     (?$(DBd(B . ?\x66CE) ;; <CJK>
     (?$(DBe(B . ?\x66CF) ;; <CJK>
     (?$(DBf(B . ?\x66D4) ;; <CJK>
     (?$(DBg(B . ?\x66DB) ;; <CJK>
     (?$(DBh(B . ?\x66DF) ;; <CJK>
     (?$(DBi(B . ?\x66E8) ;; <CJK>
     (?$(DBj(B . ?\x66EB) ;; <CJK>
     (?$(DBk(B . ?\x66EC) ;; <CJK>
     (?$(DBl(B . ?\x66EE) ;; <CJK>
     (?$(DBm(B . ?\x66FA) ;; <CJK>
     (?$(DBn(B . ?\x6705) ;; <CJK>
     (?$(DBo(B . ?\x6707) ;; <CJK>
     (?$(DBp(B . ?\x670E) ;; <CJK>
     (?$(DBq(B . ?\x6713) ;; <CJK>
     (?$(DBr(B . ?\x6719) ;; <CJK>
     (?$(DBs(B . ?\x671C) ;; <CJK>
     (?$(DBt(B . ?\x6720) ;; <CJK>
     (?$(DBu(B . ?\x6722) ;; <CJK>
     (?$(DBv(B . ?\x6733) ;; <CJK>
     (?$(DBw(B . ?\x673E) ;; <CJK>
     (?$(DBx(B . ?\x6745) ;; <CJK>
     (?$(DBy(B . ?\x6747) ;; <CJK>
     (?$(DBz(B . ?\x6748) ;; <CJK>
     (?$(DB{(B . ?\x674C) ;; <CJK>
     (?$(DB|(B . ?\x6754) ;; <CJK>
     (?$(DB}(B . ?\x6755) ;; <CJK>
     (?$(DB~(B . ?\x675D) ;; <CJK>
     (?$(DC!(B . ?\x6766) ;; <CJK>
     (?$(DC"(B . ?\x676C) ;; <CJK>
     (?$(DC#(B . ?\x676E) ;; <CJK>
     (?$(DC$(B . ?\x6774) ;; <CJK>
     (?$(DC%(B . ?\x6776) ;; <CJK>
     (?$(DC&(B . ?\x677B) ;; <CJK>
     (?$(DC'(B . ?\x6781) ;; <CJK>
     (?$(DC((B . ?\x6784) ;; <CJK>
     (?$(DC)(B . ?\x678E) ;; <CJK>
     (?$(DC*(B . ?\x678F) ;; <CJK>
     (?$(DC+(B . ?\x6791) ;; <CJK>
     (?$(DC,(B . ?\x6793) ;; <CJK>
     (?$(DC-(B . ?\x6796) ;; <CJK>
     (?$(DC.(B . ?\x6798) ;; <CJK>
     (?$(DC/(B . ?\x6799) ;; <CJK>
     (?$(DC0(B . ?\x679B) ;; <CJK>
     (?$(DC1(B . ?\x67B0) ;; <CJK>
     (?$(DC2(B . ?\x67B1) ;; <CJK>
     (?$(DC3(B . ?\x67B2) ;; <CJK>
     (?$(DC4(B . ?\x67B5) ;; <CJK>
     (?$(DC5(B . ?\x67BB) ;; <CJK>
     (?$(DC6(B . ?\x67BC) ;; <CJK>
     (?$(DC7(B . ?\x67BD) ;; <CJK>
     (?$(DC8(B . ?\x67F9) ;; <CJK>
     (?$(DC9(B . ?\x67C0) ;; <CJK>
     (?$(DC:(B . ?\x67C2) ;; <CJK>
     (?$(DC;(B . ?\x67C3) ;; <CJK>
     (?$(DC<(B . ?\x67C5) ;; <CJK>
     (?$(DC=(B . ?\x67C8) ;; <CJK>
     (?$(DC>(B . ?\x67C9) ;; <CJK>
     (?$(DC?(B . ?\x67D2) ;; <CJK>
     (?$(DC@(B . ?\x67D7) ;; <CJK>
     (?$(DCA(B . ?\x67D9) ;; <CJK>
     (?$(DCB(B . ?\x67DC) ;; <CJK>
     (?$(DCC(B . ?\x67E1) ;; <CJK>
     (?$(DCD(B . ?\x67E6) ;; <CJK>
     (?$(DCE(B . ?\x67F0) ;; <CJK>
     (?$(DCF(B . ?\x67F2) ;; <CJK>
     (?$(DCG(B . ?\x67F6) ;; <CJK>
     (?$(DCH(B . ?\x67F7) ;; <CJK>
     (?$(DCI(B . ?\x6852) ;; <CJK>
     (?$(DCJ(B . ?\x6814) ;; <CJK>
     (?$(DCK(B . ?\x6819) ;; <CJK>
     (?$(DCL(B . ?\x681D) ;; <CJK>
     (?$(DCM(B . ?\x681F) ;; <CJK>
     (?$(DCN(B . ?\x6828) ;; <CJK>
     (?$(DCO(B . ?\x6827) ;; <CJK>
     (?$(DCP(B . ?\x682C) ;; <CJK>
     (?$(DCQ(B . ?\x682D) ;; <CJK>
     (?$(DCR(B . ?\x682F) ;; <CJK>
     (?$(DCS(B . ?\x6830) ;; <CJK>
     (?$(DCT(B . ?\x6831) ;; <CJK>
     (?$(DCU(B . ?\x6833) ;; <CJK>
     (?$(DCV(B . ?\x683B) ;; <CJK>
     (?$(DCW(B . ?\x683F) ;; <CJK>
     (?$(DCX(B . ?\x6844) ;; <CJK>
     (?$(DCY(B . ?\x6845) ;; <CJK>
     (?$(DCZ(B . ?\x684A) ;; <CJK>
     (?$(DC[(B . ?\x684C) ;; <CJK>
     (?$(DC\(B . ?\x6855) ;; <CJK>
     (?$(DC](B . ?\x6857) ;; <CJK>
     (?$(DC^(B . ?\x6858) ;; <CJK>
     (?$(DC_(B . ?\x685B) ;; <CJK>
     (?$(DC`(B . ?\x686B) ;; <CJK>
     (?$(DCa(B . ?\x686E) ;; <CJK>
     (?$(DCb(B . ?\x686F) ;; <CJK>
     (?$(DCc(B . ?\x6870) ;; <CJK>
     (?$(DCd(B . ?\x6871) ;; <CJK>
     (?$(DCe(B . ?\x6872) ;; <CJK>
     (?$(DCf(B . ?\x6875) ;; <CJK>
     (?$(DCg(B . ?\x6879) ;; <CJK>
     (?$(DCh(B . ?\x687A) ;; <CJK>
     (?$(DCi(B . ?\x687B) ;; <CJK>
     (?$(DCj(B . ?\x687C) ;; <CJK>
     (?$(DCk(B . ?\x6882) ;; <CJK>
     (?$(DCl(B . ?\x6884) ;; <CJK>
     (?$(DCm(B . ?\x6886) ;; <CJK>
     (?$(DCn(B . ?\x6888) ;; <CJK>
     (?$(DCo(B . ?\x6896) ;; <CJK>
     (?$(DCp(B . ?\x6898) ;; <CJK>
     (?$(DCq(B . ?\x689A) ;; <CJK>
     (?$(DCr(B . ?\x689C) ;; <CJK>
     (?$(DCs(B . ?\x68A1) ;; <CJK>
     (?$(DCt(B . ?\x68A3) ;; <CJK>
     (?$(DCu(B . ?\x68A5) ;; <CJK>
     (?$(DCv(B . ?\x68A9) ;; <CJK>
     (?$(DCw(B . ?\x68AA) ;; <CJK>
     (?$(DCx(B . ?\x68AE) ;; <CJK>
     (?$(DCy(B . ?\x68B2) ;; <CJK>
     (?$(DCz(B . ?\x68BB) ;; <CJK>
     (?$(DC{(B . ?\x68C5) ;; <CJK>
     (?$(DC|(B . ?\x68C8) ;; <CJK>
     (?$(DC}(B . ?\x68CC) ;; <CJK>
     (?$(DC~(B . ?\x68CF) ;; <CJK>
     (?$(DD!(B . ?\x68D0) ;; <CJK>
     (?$(DD"(B . ?\x68D1) ;; <CJK>
     (?$(DD#(B . ?\x68D3) ;; <CJK>
     (?$(DD$(B . ?\x68D6) ;; <CJK>
     (?$(DD%(B . ?\x68D9) ;; <CJK>
     (?$(DD&(B . ?\x68DC) ;; <CJK>
     (?$(DD'(B . ?\x68DD) ;; <CJK>
     (?$(DD((B . ?\x68E5) ;; <CJK>
     (?$(DD)(B . ?\x68E8) ;; <CJK>
     (?$(DD*(B . ?\x68EA) ;; <CJK>
     (?$(DD+(B . ?\x68EB) ;; <CJK>
     (?$(DD,(B . ?\x68EC) ;; <CJK>
     (?$(DD-(B . ?\x68ED) ;; <CJK>
     (?$(DD.(B . ?\x68F0) ;; <CJK>
     (?$(DD/(B . ?\x68F1) ;; <CJK>
     (?$(DD0(B . ?\x68F5) ;; <CJK>
     (?$(DD1(B . ?\x68F6) ;; <CJK>
     (?$(DD2(B . ?\x68FB) ;; <CJK>
     (?$(DD3(B . ?\x68FC) ;; <CJK>
     (?$(DD4(B . ?\x68FD) ;; <CJK>
     (?$(DD5(B . ?\x6906) ;; <CJK>
     (?$(DD6(B . ?\x6909) ;; <CJK>
     (?$(DD7(B . ?\x690A) ;; <CJK>
     (?$(DD8(B . ?\x6910) ;; <CJK>
     (?$(DD9(B . ?\x6911) ;; <CJK>
     (?$(DD:(B . ?\x6913) ;; <CJK>
     (?$(DD;(B . ?\x6916) ;; <CJK>
     (?$(DD<(B . ?\x6917) ;; <CJK>
     (?$(DD=(B . ?\x6931) ;; <CJK>
     (?$(DD>(B . ?\x6933) ;; <CJK>
     (?$(DD?(B . ?\x6935) ;; <CJK>
     (?$(DD@(B . ?\x6938) ;; <CJK>
     (?$(DDA(B . ?\x693B) ;; <CJK>
     (?$(DDB(B . ?\x6942) ;; <CJK>
     (?$(DDC(B . ?\x6945) ;; <CJK>
     (?$(DDD(B . ?\x6949) ;; <CJK>
     (?$(DDE(B . ?\x694E) ;; <CJK>
     (?$(DDF(B . ?\x6957) ;; <CJK>
     (?$(DDG(B . ?\x695B) ;; <CJK>
     (?$(DDH(B . ?\x6963) ;; <CJK>
     (?$(DDI(B . ?\x6964) ;; <CJK>
     (?$(DDJ(B . ?\x6965) ;; <CJK>
     (?$(DDK(B . ?\x6966) ;; <CJK>
     (?$(DDL(B . ?\x6968) ;; <CJK>
     (?$(DDM(B . ?\x6969) ;; <CJK>
     (?$(DDN(B . ?\x696C) ;; <CJK>
     (?$(DDO(B . ?\x6970) ;; <CJK>
     (?$(DDP(B . ?\x6971) ;; <CJK>
     (?$(DDQ(B . ?\x6972) ;; <CJK>
     (?$(DDR(B . ?\x697A) ;; <CJK>
     (?$(DDS(B . ?\x697B) ;; <CJK>
     (?$(DDT(B . ?\x697F) ;; <CJK>
     (?$(DDU(B . ?\x6980) ;; <CJK>
     (?$(DDV(B . ?\x698D) ;; <CJK>
     (?$(DDW(B . ?\x6992) ;; <CJK>
     (?$(DDX(B . ?\x6996) ;; <CJK>
     (?$(DDY(B . ?\x6998) ;; <CJK>
     (?$(DDZ(B . ?\x69A1) ;; <CJK>
     (?$(DD[(B . ?\x69A5) ;; <CJK>
     (?$(DD\(B . ?\x69A6) ;; <CJK>
     (?$(DD](B . ?\x69A8) ;; <CJK>
     (?$(DD^(B . ?\x69AB) ;; <CJK>
     (?$(DD_(B . ?\x69AD) ;; <CJK>
     (?$(DD`(B . ?\x69AF) ;; <CJK>
     (?$(DDa(B . ?\x69B7) ;; <CJK>
     (?$(DDb(B . ?\x69B8) ;; <CJK>
     (?$(DDc(B . ?\x69BA) ;; <CJK>
     (?$(DDd(B . ?\x69BC) ;; <CJK>
     (?$(DDe(B . ?\x69C5) ;; <CJK>
     (?$(DDf(B . ?\x69C8) ;; <CJK>
     (?$(DDg(B . ?\x69D1) ;; <CJK>
     (?$(DDh(B . ?\x69D6) ;; <CJK>
     (?$(DDi(B . ?\x69D7) ;; <CJK>
     (?$(DDj(B . ?\x69E2) ;; <CJK>
     (?$(DDk(B . ?\x69E5) ;; <CJK>
     (?$(DDl(B . ?\x69EE) ;; <CJK>
     (?$(DDm(B . ?\x69EF) ;; <CJK>
     (?$(DDn(B . ?\x69F1) ;; <CJK>
     (?$(DDo(B . ?\x69F3) ;; <CJK>
     (?$(DDp(B . ?\x69F5) ;; <CJK>
     (?$(DDq(B . ?\x69FE) ;; <CJK>
     (?$(DDr(B . ?\x6A00) ;; <CJK>
     (?$(DDs(B . ?\x6A01) ;; <CJK>
     (?$(DDt(B . ?\x6A03) ;; <CJK>
     (?$(DDu(B . ?\x6A0F) ;; <CJK>
     (?$(DDv(B . ?\x6A11) ;; <CJK>
     (?$(DDw(B . ?\x6A15) ;; <CJK>
     (?$(DDx(B . ?\x6A1A) ;; <CJK>
     (?$(DDy(B . ?\x6A1D) ;; <CJK>
     (?$(DDz(B . ?\x6A20) ;; <CJK>
     (?$(DD{(B . ?\x6A24) ;; <CJK>
     (?$(DD|(B . ?\x6A28) ;; <CJK>
     (?$(DD}(B . ?\x6A30) ;; <CJK>
     (?$(DD~(B . ?\x6A32) ;; <CJK>
     (?$(DE!(B . ?\x6A34) ;; <CJK>
     (?$(DE"(B . ?\x6A37) ;; <CJK>
     (?$(DE#(B . ?\x6A3B) ;; <CJK>
     (?$(DE$(B . ?\x6A3E) ;; <CJK>
     (?$(DE%(B . ?\x6A3F) ;; <CJK>
     (?$(DE&(B . ?\x6A45) ;; <CJK>
     (?$(DE'(B . ?\x6A46) ;; <CJK>
     (?$(DE((B . ?\x6A49) ;; <CJK>
     (?$(DE)(B . ?\x6A4A) ;; <CJK>
     (?$(DE*(B . ?\x6A4E) ;; <CJK>
     (?$(DE+(B . ?\x6A50) ;; <CJK>
     (?$(DE,(B . ?\x6A51) ;; <CJK>
     (?$(DE-(B . ?\x6A52) ;; <CJK>
     (?$(DE.(B . ?\x6A55) ;; <CJK>
     (?$(DE/(B . ?\x6A56) ;; <CJK>
     (?$(DE0(B . ?\x6A5B) ;; <CJK>
     (?$(DE1(B . ?\x6A64) ;; <CJK>
     (?$(DE2(B . ?\x6A67) ;; <CJK>
     (?$(DE3(B . ?\x6A6A) ;; <CJK>
     (?$(DE4(B . ?\x6A71) ;; <CJK>
     (?$(DE5(B . ?\x6A73) ;; <CJK>
     (?$(DE6(B . ?\x6A7E) ;; <CJK>
     (?$(DE7(B . ?\x6A81) ;; <CJK>
     (?$(DE8(B . ?\x6A83) ;; <CJK>
     (?$(DE9(B . ?\x6A86) ;; <CJK>
     (?$(DE:(B . ?\x6A87) ;; <CJK>
     (?$(DE;(B . ?\x6A89) ;; <CJK>
     (?$(DE<(B . ?\x6A8B) ;; <CJK>
     (?$(DE=(B . ?\x6A91) ;; <CJK>
     (?$(DE>(B . ?\x6A9B) ;; <CJK>
     (?$(DE?(B . ?\x6A9D) ;; <CJK>
     (?$(DE@(B . ?\x6A9E) ;; <CJK>
     (?$(DEA(B . ?\x6A9F) ;; <CJK>
     (?$(DEB(B . ?\x6AA5) ;; <CJK>
     (?$(DEC(B . ?\x6AAB) ;; <CJK>
     (?$(DED(B . ?\x6AAF) ;; <CJK>
     (?$(DEE(B . ?\x6AB0) ;; <CJK>
     (?$(DEF(B . ?\x6AB1) ;; <CJK>
     (?$(DEG(B . ?\x6AB4) ;; <CJK>
     (?$(DEH(B . ?\x6ABD) ;; <CJK>
     (?$(DEI(B . ?\x6ABE) ;; <CJK>
     (?$(DEJ(B . ?\x6ABF) ;; <CJK>
     (?$(DEK(B . ?\x6AC6) ;; <CJK>
     (?$(DEL(B . ?\x6AC9) ;; <CJK>
     (?$(DEM(B . ?\x6AC8) ;; <CJK>
     (?$(DEN(B . ?\x6ACC) ;; <CJK>
     (?$(DEO(B . ?\x6AD0) ;; <CJK>
     (?$(DEP(B . ?\x6AD4) ;; <CJK>
     (?$(DEQ(B . ?\x6AD5) ;; <CJK>
     (?$(DER(B . ?\x6AD6) ;; <CJK>
     (?$(DES(B . ?\x6ADC) ;; <CJK>
     (?$(DET(B . ?\x6ADD) ;; <CJK>
     (?$(DEU(B . ?\x6AE4) ;; <CJK>
     (?$(DEV(B . ?\x6AE7) ;; <CJK>
     (?$(DEW(B . ?\x6AEC) ;; <CJK>
     (?$(DEX(B . ?\x6AF0) ;; <CJK>
     (?$(DEY(B . ?\x6AF1) ;; <CJK>
     (?$(DEZ(B . ?\x6AF2) ;; <CJK>
     (?$(DE[(B . ?\x6AFC) ;; <CJK>
     (?$(DE\(B . ?\x6AFD) ;; <CJK>
     (?$(DE](B . ?\x6B02) ;; <CJK>
     (?$(DE^(B . ?\x6B03) ;; <CJK>
     (?$(DE_(B . ?\x6B06) ;; <CJK>
     (?$(DE`(B . ?\x6B07) ;; <CJK>
     (?$(DEa(B . ?\x6B09) ;; <CJK>
     (?$(DEb(B . ?\x6B0F) ;; <CJK>
     (?$(DEc(B . ?\x6B10) ;; <CJK>
     (?$(DEd(B . ?\x6B11) ;; <CJK>
     (?$(DEe(B . ?\x6B17) ;; <CJK>
     (?$(DEf(B . ?\x6B1B) ;; <CJK>
     (?$(DEg(B . ?\x6B1E) ;; <CJK>
     (?$(DEh(B . ?\x6B24) ;; <CJK>
     (?$(DEi(B . ?\x6B28) ;; <CJK>
     (?$(DEj(B . ?\x6B2B) ;; <CJK>
     (?$(DEk(B . ?\x6B2C) ;; <CJK>
     (?$(DEl(B . ?\x6B2F) ;; <CJK>
     (?$(DEm(B . ?\x6B35) ;; <CJK>
     (?$(DEn(B . ?\x6B36) ;; <CJK>
     (?$(DEo(B . ?\x6B3B) ;; <CJK>
     (?$(DEp(B . ?\x6B3F) ;; <CJK>
     (?$(DEq(B . ?\x6B46) ;; <CJK>
     (?$(DEr(B . ?\x6B4A) ;; <CJK>
     (?$(DEs(B . ?\x6B4D) ;; <CJK>
     (?$(DEt(B . ?\x6B52) ;; <CJK>
     (?$(DEu(B . ?\x6B56) ;; <CJK>
     (?$(DEv(B . ?\x6B58) ;; <CJK>
     (?$(DEw(B . ?\x6B5D) ;; <CJK>
     (?$(DEx(B . ?\x6B60) ;; <CJK>
     (?$(DEy(B . ?\x6B67) ;; <CJK>
     (?$(DEz(B . ?\x6B6B) ;; <CJK>
     (?$(DE{(B . ?\x6B6E) ;; <CJK>
     (?$(DE|(B . ?\x6B70) ;; <CJK>
     (?$(DE}(B . ?\x6B75) ;; <CJK>
     (?$(DE~(B . ?\x6B7D) ;; <CJK>
     (?$(DF!(B . ?\x6B7E) ;; <CJK>
     (?$(DF"(B . ?\x6B82) ;; <CJK>
     (?$(DF#(B . ?\x6B85) ;; <CJK>
     (?$(DF$(B . ?\x6B97) ;; <CJK>
     (?$(DF%(B . ?\x6B9B) ;; <CJK>
     (?$(DF&(B . ?\x6B9F) ;; <CJK>
     (?$(DF'(B . ?\x6BA0) ;; <CJK>
     (?$(DF((B . ?\x6BA2) ;; <CJK>
     (?$(DF)(B . ?\x6BA3) ;; <CJK>
     (?$(DF*(B . ?\x6BA8) ;; <CJK>
     (?$(DF+(B . ?\x6BA9) ;; <CJK>
     (?$(DF,(B . ?\x6BAC) ;; <CJK>
     (?$(DF-(B . ?\x6BAD) ;; <CJK>
     (?$(DF.(B . ?\x6BAE) ;; <CJK>
     (?$(DF/(B . ?\x6BB0) ;; <CJK>
     (?$(DF0(B . ?\x6BB8) ;; <CJK>
     (?$(DF1(B . ?\x6BB9) ;; <CJK>
     (?$(DF2(B . ?\x6BBD) ;; <CJK>
     (?$(DF3(B . ?\x6BBE) ;; <CJK>
     (?$(DF4(B . ?\x6BC3) ;; <CJK>
     (?$(DF5(B . ?\x6BC4) ;; <CJK>
     (?$(DF6(B . ?\x6BC9) ;; <CJK>
     (?$(DF7(B . ?\x6BCC) ;; <CJK>
     (?$(DF8(B . ?\x6BD6) ;; <CJK>
     (?$(DF9(B . ?\x6BDA) ;; <CJK>
     (?$(DF:(B . ?\x6BE1) ;; <CJK>
     (?$(DF;(B . ?\x6BE3) ;; <CJK>
     (?$(DF<(B . ?\x6BE6) ;; <CJK>
     (?$(DF=(B . ?\x6BE7) ;; <CJK>
     (?$(DF>(B . ?\x6BEE) ;; <CJK>
     (?$(DF?(B . ?\x6BF1) ;; <CJK>
     (?$(DF@(B . ?\x6BF7) ;; <CJK>
     (?$(DFA(B . ?\x6BF9) ;; <CJK>
     (?$(DFB(B . ?\x6BFF) ;; <CJK>
     (?$(DFC(B . ?\x6C02) ;; <CJK>
     (?$(DFD(B . ?\x6C04) ;; <CJK>
     (?$(DFE(B . ?\x6C05) ;; <CJK>
     (?$(DFF(B . ?\x6C09) ;; <CJK>
     (?$(DFG(B . ?\x6C0D) ;; <CJK>
     (?$(DFH(B . ?\x6C0E) ;; <CJK>
     (?$(DFI(B . ?\x6C10) ;; <CJK>
     (?$(DFJ(B . ?\x6C12) ;; <CJK>
     (?$(DFK(B . ?\x6C19) ;; <CJK>
     (?$(DFL(B . ?\x6C1F) ;; <CJK>
     (?$(DFM(B . ?\x6C26) ;; <CJK>
     (?$(DFN(B . ?\x6C27) ;; <CJK>
     (?$(DFO(B . ?\x6C28) ;; <CJK>
     (?$(DFP(B . ?\x6C2C) ;; <CJK>
     (?$(DFQ(B . ?\x6C2E) ;; <CJK>
     (?$(DFR(B . ?\x6C33) ;; <CJK>
     (?$(DFS(B . ?\x6C35) ;; <CJK>
     (?$(DFT(B . ?\x6C36) ;; <CJK>
     (?$(DFU(B . ?\x6C3A) ;; <CJK>
     (?$(DFV(B . ?\x6C3B) ;; <CJK>
     (?$(DFW(B . ?\x6C3F) ;; <CJK>
     (?$(DFX(B . ?\x6C4A) ;; <CJK>
     (?$(DFY(B . ?\x6C4B) ;; <CJK>
     (?$(DFZ(B . ?\x6C4D) ;; <CJK>
     (?$(DF[(B . ?\x6C4F) ;; <CJK>
     (?$(DF\(B . ?\x6C52) ;; <CJK>
     (?$(DF](B . ?\x6C54) ;; <CJK>
     (?$(DF^(B . ?\x6C59) ;; <CJK>
     (?$(DF_(B . ?\x6C5B) ;; <CJK>
     (?$(DF`(B . ?\x6C5C) ;; <CJK>
     (?$(DFa(B . ?\x6C6B) ;; <CJK>
     (?$(DFb(B . ?\x6C6D) ;; <CJK>
     (?$(DFc(B . ?\x6C6F) ;; <CJK>
     (?$(DFd(B . ?\x6C74) ;; <CJK>
     (?$(DFe(B . ?\x6C76) ;; <CJK>
     (?$(DFf(B . ?\x6C78) ;; <CJK>
     (?$(DFg(B . ?\x6C79) ;; <CJK>
     (?$(DFh(B . ?\x6C7B) ;; <CJK>
     (?$(DFi(B . ?\x6C85) ;; <CJK>
     (?$(DFj(B . ?\x6C86) ;; <CJK>
     (?$(DFk(B . ?\x6C87) ;; <CJK>
     (?$(DFl(B . ?\x6C89) ;; <CJK>
     (?$(DFm(B . ?\x6C94) ;; <CJK>
     (?$(DFn(B . ?\x6C95) ;; <CJK>
     (?$(DFo(B . ?\x6C97) ;; <CJK>
     (?$(DFp(B . ?\x6C98) ;; <CJK>
     (?$(DFq(B . ?\x6C9C) ;; <CJK>
     (?$(DFr(B . ?\x6C9F) ;; <CJK>
     (?$(DFs(B . ?\x6CB0) ;; <CJK>
     (?$(DFt(B . ?\x6CB2) ;; <CJK>
     (?$(DFu(B . ?\x6CB4) ;; <CJK>
     (?$(DFv(B . ?\x6CC2) ;; <CJK>
     (?$(DFw(B . ?\x6CC6) ;; <CJK>
     (?$(DFx(B . ?\x6CCD) ;; <CJK>
     (?$(DFy(B . ?\x6CCF) ;; <CJK>
     (?$(DFz(B . ?\x6CD0) ;; <CJK>
     (?$(DF{(B . ?\x6CD1) ;; <CJK>
     (?$(DF|(B . ?\x6CD2) ;; <CJK>
     (?$(DF}(B . ?\x6CD4) ;; <CJK>
     (?$(DF~(B . ?\x6CD6) ;; <CJK>
     (?$(DG!(B . ?\x6CDA) ;; <CJK>
     (?$(DG"(B . ?\x6CDC) ;; <CJK>
     (?$(DG#(B . ?\x6CE0) ;; <CJK>
     (?$(DG$(B . ?\x6CE7) ;; <CJK>
     (?$(DG%(B . ?\x6CE9) ;; <CJK>
     (?$(DG&(B . ?\x6CEB) ;; <CJK>
     (?$(DG'(B . ?\x6CEC) ;; <CJK>
     (?$(DG((B . ?\x6CEE) ;; <CJK>
     (?$(DG)(B . ?\x6CF2) ;; <CJK>
     (?$(DG*(B . ?\x6CF4) ;; <CJK>
     (?$(DG+(B . ?\x6D04) ;; <CJK>
     (?$(DG,(B . ?\x6D07) ;; <CJK>
     (?$(DG-(B . ?\x6D0A) ;; <CJK>
     (?$(DG.(B . ?\x6D0E) ;; <CJK>
     (?$(DG/(B . ?\x6D0F) ;; <CJK>
     (?$(DG0(B . ?\x6D11) ;; <CJK>
     (?$(DG1(B . ?\x6D13) ;; <CJK>
     (?$(DG2(B . ?\x6D1A) ;; <CJK>
     (?$(DG3(B . ?\x6D26) ;; <CJK>
     (?$(DG4(B . ?\x6D27) ;; <CJK>
     (?$(DG5(B . ?\x6D28) ;; <CJK>
     (?$(DG6(B . ?\x6C67) ;; <CJK>
     (?$(DG7(B . ?\x6D2E) ;; <CJK>
     (?$(DG8(B . ?\x6D2F) ;; <CJK>
     (?$(DG9(B . ?\x6D31) ;; <CJK>
     (?$(DG:(B . ?\x6D39) ;; <CJK>
     (?$(DG;(B . ?\x6D3C) ;; <CJK>
     (?$(DG<(B . ?\x6D3F) ;; <CJK>
     (?$(DG=(B . ?\x6D57) ;; <CJK>
     (?$(DG>(B . ?\x6D5E) ;; <CJK>
     (?$(DG?(B . ?\x6D5F) ;; <CJK>
     (?$(DG@(B . ?\x6D61) ;; <CJK>
     (?$(DGA(B . ?\x6D65) ;; <CJK>
     (?$(DGB(B . ?\x6D67) ;; <CJK>
     (?$(DGC(B . ?\x6D6F) ;; <CJK>
     (?$(DGD(B . ?\x6D70) ;; <CJK>
     (?$(DGE(B . ?\x6D7C) ;; <CJK>
     (?$(DGF(B . ?\x6D82) ;; <CJK>
     (?$(DGG(B . ?\x6D87) ;; <CJK>
     (?$(DGH(B . ?\x6D91) ;; <CJK>
     (?$(DGI(B . ?\x6D92) ;; <CJK>
     (?$(DGJ(B . ?\x6D94) ;; <CJK>
     (?$(DGK(B . ?\x6D96) ;; <CJK>
     (?$(DGL(B . ?\x6D97) ;; <CJK>
     (?$(DGM(B . ?\x6D98) ;; <CJK>
     (?$(DGN(B . ?\x6DAA) ;; <CJK>
     (?$(DGO(B . ?\x6DAC) ;; <CJK>
     (?$(DGP(B . ?\x6DB4) ;; <CJK>
     (?$(DGQ(B . ?\x6DB7) ;; <CJK>
     (?$(DGR(B . ?\x6DB9) ;; <CJK>
     (?$(DGS(B . ?\x6DBD) ;; <CJK>
     (?$(DGT(B . ?\x6DBF) ;; <CJK>
     (?$(DGU(B . ?\x6DC4) ;; <CJK>
     (?$(DGV(B . ?\x6DC8) ;; <CJK>
     (?$(DGW(B . ?\x6DCA) ;; <CJK>
     (?$(DGX(B . ?\x6DCE) ;; <CJK>
     (?$(DGY(B . ?\x6DCF) ;; <CJK>
     (?$(DGZ(B . ?\x6DD6) ;; <CJK>
     (?$(DG[(B . ?\x6DDB) ;; <CJK>
     (?$(DG\(B . ?\x6DDD) ;; <CJK>
     (?$(DG](B . ?\x6DDF) ;; <CJK>
     (?$(DG^(B . ?\x6DE0) ;; <CJK>
     (?$(DG_(B . ?\x6DE2) ;; <CJK>
     (?$(DG`(B . ?\x6DE5) ;; <CJK>
     (?$(DGa(B . ?\x6DE9) ;; <CJK>
     (?$(DGb(B . ?\x6DEF) ;; <CJK>
     (?$(DGc(B . ?\x6DF0) ;; <CJK>
     (?$(DGd(B . ?\x6DF4) ;; <CJK>
     (?$(DGe(B . ?\x6DF6) ;; <CJK>
     (?$(DGf(B . ?\x6DFC) ;; <CJK>
     (?$(DGg(B . ?\x6E00) ;; <CJK>
     (?$(DGh(B . ?\x6E04) ;; <CJK>
     (?$(DGi(B . ?\x6E1E) ;; <CJK>
     (?$(DGj(B . ?\x6E22) ;; <CJK>
     (?$(DGk(B . ?\x6E27) ;; <CJK>
     (?$(DGl(B . ?\x6E32) ;; <CJK>
     (?$(DGm(B . ?\x6E36) ;; <CJK>
     (?$(DGn(B . ?\x6E39) ;; <CJK>
     (?$(DGo(B . ?\x6E3B) ;; <CJK>
     (?$(DGp(B . ?\x6E3C) ;; <CJK>
     (?$(DGq(B . ?\x6E44) ;; <CJK>
     (?$(DGr(B . ?\x6E45) ;; <CJK>
     (?$(DGs(B . ?\x6E48) ;; <CJK>
     (?$(DGt(B . ?\x6E49) ;; <CJK>
     (?$(DGu(B . ?\x6E4B) ;; <CJK>
     (?$(DGv(B . ?\x6E4F) ;; <CJK>
     (?$(DGw(B . ?\x6E51) ;; <CJK>
     (?$(DGx(B . ?\x6E52) ;; <CJK>
     (?$(DGy(B . ?\x6E53) ;; <CJK>
     (?$(DGz(B . ?\x6E54) ;; <CJK>
     (?$(DG{(B . ?\x6E57) ;; <CJK>
     (?$(DG|(B . ?\x6E5C) ;; <CJK>
     (?$(DG}(B . ?\x6E5D) ;; <CJK>
     (?$(DG~(B . ?\x6E5E) ;; <CJK>
     (?$(DH!(B . ?\x6E62) ;; <CJK>
     (?$(DH"(B . ?\x6E63) ;; <CJK>
     (?$(DH#(B . ?\x6E68) ;; <CJK>
     (?$(DH$(B . ?\x6E73) ;; <CJK>
     (?$(DH%(B . ?\x6E7B) ;; <CJK>
     (?$(DH&(B . ?\x6E7D) ;; <CJK>
     (?$(DH'(B . ?\x6E8D) ;; <CJK>
     (?$(DH((B . ?\x6E93) ;; <CJK>
     (?$(DH)(B . ?\x6E99) ;; <CJK>
     (?$(DH*(B . ?\x6EA0) ;; <CJK>
     (?$(DH+(B . ?\x6EA7) ;; <CJK>
     (?$(DH,(B . ?\x6EAD) ;; <CJK>
     (?$(DH-(B . ?\x6EAE) ;; <CJK>
     (?$(DH.(B . ?\x6EB1) ;; <CJK>
     (?$(DH/(B . ?\x6EB3) ;; <CJK>
     (?$(DH0(B . ?\x6EBB) ;; <CJK>
     (?$(DH1(B . ?\x6EBF) ;; <CJK>
     (?$(DH2(B . ?\x6EC0) ;; <CJK>
     (?$(DH3(B . ?\x6EC1) ;; <CJK>
     (?$(DH4(B . ?\x6EC3) ;; <CJK>
     (?$(DH5(B . ?\x6EC7) ;; <CJK>
     (?$(DH6(B . ?\x6EC8) ;; <CJK>
     (?$(DH7(B . ?\x6ECA) ;; <CJK>
     (?$(DH8(B . ?\x6ECD) ;; <CJK>
     (?$(DH9(B . ?\x6ECE) ;; <CJK>
     (?$(DH:(B . ?\x6ECF) ;; <CJK>
     (?$(DH;(B . ?\x6EEB) ;; <CJK>
     (?$(DH<(B . ?\x6EED) ;; <CJK>
     (?$(DH=(B . ?\x6EEE) ;; <CJK>
     (?$(DH>(B . ?\x6EF9) ;; <CJK>
     (?$(DH?(B . ?\x6EFB) ;; <CJK>
     (?$(DH@(B . ?\x6EFD) ;; <CJK>
     (?$(DHA(B . ?\x6F04) ;; <CJK>
     (?$(DHB(B . ?\x6F08) ;; <CJK>
     (?$(DHC(B . ?\x6F0A) ;; <CJK>
     (?$(DHD(B . ?\x6F0C) ;; <CJK>
     (?$(DHE(B . ?\x6F0D) ;; <CJK>
     (?$(DHF(B . ?\x6F16) ;; <CJK>
     (?$(DHG(B . ?\x6F18) ;; <CJK>
     (?$(DHH(B . ?\x6F1A) ;; <CJK>
     (?$(DHI(B . ?\x6F1B) ;; <CJK>
     (?$(DHJ(B . ?\x6F26) ;; <CJK>
     (?$(DHK(B . ?\x6F29) ;; <CJK>
     (?$(DHL(B . ?\x6F2A) ;; <CJK>
     (?$(DHM(B . ?\x6F2F) ;; <CJK>
     (?$(DHN(B . ?\x6F30) ;; <CJK>
     (?$(DHO(B . ?\x6F33) ;; <CJK>
     (?$(DHP(B . ?\x6F36) ;; <CJK>
     (?$(DHQ(B . ?\x6F3B) ;; <CJK>
     (?$(DHR(B . ?\x6F3C) ;; <CJK>
     (?$(DHS(B . ?\x6F2D) ;; <CJK>
     (?$(DHT(B . ?\x6F4F) ;; <CJK>
     (?$(DHU(B . ?\x6F51) ;; <CJK>
     (?$(DHV(B . ?\x6F52) ;; <CJK>
     (?$(DHW(B . ?\x6F53) ;; <CJK>
     (?$(DHX(B . ?\x6F57) ;; <CJK>
     (?$(DHY(B . ?\x6F59) ;; <CJK>
     (?$(DHZ(B . ?\x6F5A) ;; <CJK>
     (?$(DH[(B . ?\x6F5D) ;; <CJK>
     (?$(DH\(B . ?\x6F5E) ;; <CJK>
     (?$(DH](B . ?\x6F61) ;; <CJK>
     (?$(DH^(B . ?\x6F62) ;; <CJK>
     (?$(DH_(B . ?\x6F68) ;; <CJK>
     (?$(DH`(B . ?\x6F6C) ;; <CJK>
     (?$(DHa(B . ?\x6F7D) ;; <CJK>
     (?$(DHb(B . ?\x6F7E) ;; <CJK>
     (?$(DHc(B . ?\x6F83) ;; <CJK>
     (?$(DHd(B . ?\x6F87) ;; <CJK>
     (?$(DHe(B . ?\x6F88) ;; <CJK>
     (?$(DHf(B . ?\x6F8B) ;; <CJK>
     (?$(DHg(B . ?\x6F8C) ;; <CJK>
     (?$(DHh(B . ?\x6F8D) ;; <CJK>
     (?$(DHi(B . ?\x6F90) ;; <CJK>
     (?$(DHj(B . ?\x6F92) ;; <CJK>
     (?$(DHk(B . ?\x6F93) ;; <CJK>
     (?$(DHl(B . ?\x6F94) ;; <CJK>
     (?$(DHm(B . ?\x6F96) ;; <CJK>
     (?$(DHn(B . ?\x6F9A) ;; <CJK>
     (?$(DHo(B . ?\x6F9F) ;; <CJK>
     (?$(DHp(B . ?\x6FA0) ;; <CJK>
     (?$(DHq(B . ?\x6FA5) ;; <CJK>
     (?$(DHr(B . ?\x6FA6) ;; <CJK>
     (?$(DHs(B . ?\x6FA7) ;; <CJK>
     (?$(DHt(B . ?\x6FA8) ;; <CJK>
     (?$(DHu(B . ?\x6FAE) ;; <CJK>
     (?$(DHv(B . ?\x6FAF) ;; <CJK>
     (?$(DHw(B . ?\x6FB0) ;; <CJK>
     (?$(DHx(B . ?\x6FB5) ;; <CJK>
     (?$(DHy(B . ?\x6FB6) ;; <CJK>
     (?$(DHz(B . ?\x6FBC) ;; <CJK>
     (?$(DH{(B . ?\x6FC5) ;; <CJK>
     (?$(DH|(B . ?\x6FC7) ;; <CJK>
     (?$(DH}(B . ?\x6FC8) ;; <CJK>
     (?$(DH~(B . ?\x6FCA) ;; <CJK>
     (?$(DI!(B . ?\x6FDA) ;; <CJK>
     (?$(DI"(B . ?\x6FDE) ;; <CJK>
     (?$(DI#(B . ?\x6FE8) ;; <CJK>
     (?$(DI$(B . ?\x6FE9) ;; <CJK>
     (?$(DI%(B . ?\x6FF0) ;; <CJK>
     (?$(DI&(B . ?\x6FF5) ;; <CJK>
     (?$(DI'(B . ?\x6FF9) ;; <CJK>
     (?$(DI((B . ?\x6FFC) ;; <CJK>
     (?$(DI)(B . ?\x6FFD) ;; <CJK>
     (?$(DI*(B . ?\x7000) ;; <CJK>
     (?$(DI+(B . ?\x7005) ;; <CJK>
     (?$(DI,(B . ?\x7006) ;; <CJK>
     (?$(DI-(B . ?\x7007) ;; <CJK>
     (?$(DI.(B . ?\x700D) ;; <CJK>
     (?$(DI/(B . ?\x7017) ;; <CJK>
     (?$(DI0(B . ?\x7020) ;; <CJK>
     (?$(DI1(B . ?\x7023) ;; <CJK>
     (?$(DI2(B . ?\x702F) ;; <CJK>
     (?$(DI3(B . ?\x7034) ;; <CJK>
     (?$(DI4(B . ?\x7037) ;; <CJK>
     (?$(DI5(B . ?\x7039) ;; <CJK>
     (?$(DI6(B . ?\x703C) ;; <CJK>
     (?$(DI7(B . ?\x7043) ;; <CJK>
     (?$(DI8(B . ?\x7044) ;; <CJK>
     (?$(DI9(B . ?\x7048) ;; <CJK>
     (?$(DI:(B . ?\x7049) ;; <CJK>
     (?$(DI;(B . ?\x704A) ;; <CJK>
     (?$(DI<(B . ?\x704B) ;; <CJK>
     (?$(DI=(B . ?\x7054) ;; <CJK>
     (?$(DI>(B . ?\x7055) ;; <CJK>
     (?$(DI?(B . ?\x705D) ;; <CJK>
     (?$(DI@(B . ?\x705E) ;; <CJK>
     (?$(DIA(B . ?\x704E) ;; <CJK>
     (?$(DIB(B . ?\x7064) ;; <CJK>
     (?$(DIC(B . ?\x7065) ;; <CJK>
     (?$(DID(B . ?\x706C) ;; <CJK>
     (?$(DIE(B . ?\x706E) ;; <CJK>
     (?$(DIF(B . ?\x7075) ;; <CJK>
     (?$(DIG(B . ?\x7076) ;; <CJK>
     (?$(DIH(B . ?\x707E) ;; <CJK>
     (?$(DII(B . ?\x7081) ;; <CJK>
     (?$(DIJ(B . ?\x7085) ;; <CJK>
     (?$(DIK(B . ?\x7086) ;; <CJK>
     (?$(DIL(B . ?\x7094) ;; <CJK>
     (?$(DIM(B . ?\x7095) ;; <CJK>
     (?$(DIN(B . ?\x7096) ;; <CJK>
     (?$(DIO(B . ?\x7097) ;; <CJK>
     (?$(DIP(B . ?\x7098) ;; <CJK>
     (?$(DIQ(B . ?\x709B) ;; <CJK>
     (?$(DIR(B . ?\x70A4) ;; <CJK>
     (?$(DIS(B . ?\x70AB) ;; <CJK>
     (?$(DIT(B . ?\x70B0) ;; <CJK>
     (?$(DIU(B . ?\x70B1) ;; <CJK>
     (?$(DIV(B . ?\x70B4) ;; <CJK>
     (?$(DIW(B . ?\x70B7) ;; <CJK>
     (?$(DIX(B . ?\x70CA) ;; <CJK>
     (?$(DIY(B . ?\x70D1) ;; <CJK>
     (?$(DIZ(B . ?\x70D3) ;; <CJK>
     (?$(DI[(B . ?\x70D4) ;; <CJK>
     (?$(DI\(B . ?\x70D5) ;; <CJK>
     (?$(DI](B . ?\x70D6) ;; <CJK>
     (?$(DI^(B . ?\x70D8) ;; <CJK>
     (?$(DI_(B . ?\x70DC) ;; <CJK>
     (?$(DI`(B . ?\x70E4) ;; <CJK>
     (?$(DIa(B . ?\x70FA) ;; <CJK>
     (?$(DIb(B . ?\x7103) ;; <CJK>
     (?$(DIc(B . ?\x7104) ;; <CJK>
     (?$(DId(B . ?\x7105) ;; <CJK>
     (?$(DIe(B . ?\x7106) ;; <CJK>
     (?$(DIf(B . ?\x7107) ;; <CJK>
     (?$(DIg(B . ?\x710B) ;; <CJK>
     (?$(DIh(B . ?\x710C) ;; <CJK>
     (?$(DIi(B . ?\x710F) ;; <CJK>
     (?$(DIj(B . ?\x711E) ;; <CJK>
     (?$(DIk(B . ?\x7120) ;; <CJK>
     (?$(DIl(B . ?\x712B) ;; <CJK>
     (?$(DIm(B . ?\x712D) ;; <CJK>
     (?$(DIn(B . ?\x712F) ;; <CJK>
     (?$(DIo(B . ?\x7130) ;; <CJK>
     (?$(DIp(B . ?\x7131) ;; <CJK>
     (?$(DIq(B . ?\x7138) ;; <CJK>
     (?$(DIr(B . ?\x7141) ;; <CJK>
     (?$(DIs(B . ?\x7145) ;; <CJK>
     (?$(DIt(B . ?\x7146) ;; <CJK>
     (?$(DIu(B . ?\x7147) ;; <CJK>
     (?$(DIv(B . ?\x714A) ;; <CJK>
     (?$(DIw(B . ?\x714B) ;; <CJK>
     (?$(DIx(B . ?\x7150) ;; <CJK>
     (?$(DIy(B . ?\x7152) ;; <CJK>
     (?$(DIz(B . ?\x7157) ;; <CJK>
     (?$(DI{(B . ?\x715A) ;; <CJK>
     (?$(DI|(B . ?\x715C) ;; <CJK>
     (?$(DI}(B . ?\x715E) ;; <CJK>
     (?$(DI~(B . ?\x7160) ;; <CJK>
     (?$(DJ!(B . ?\x7168) ;; <CJK>
     (?$(DJ"(B . ?\x7179) ;; <CJK>
     (?$(DJ#(B . ?\x7180) ;; <CJK>
     (?$(DJ$(B . ?\x7185) ;; <CJK>
     (?$(DJ%(B . ?\x7187) ;; <CJK>
     (?$(DJ&(B . ?\x718C) ;; <CJK>
     (?$(DJ'(B . ?\x7192) ;; <CJK>
     (?$(DJ((B . ?\x719A) ;; <CJK>
     (?$(DJ)(B . ?\x719B) ;; <CJK>
     (?$(DJ*(B . ?\x71A0) ;; <CJK>
     (?$(DJ+(B . ?\x71A2) ;; <CJK>
     (?$(DJ,(B . ?\x71AF) ;; <CJK>
     (?$(DJ-(B . ?\x71B0) ;; <CJK>
     (?$(DJ.(B . ?\x71B2) ;; <CJK>
     (?$(DJ/(B . ?\x71B3) ;; <CJK>
     (?$(DJ0(B . ?\x71BA) ;; <CJK>
     (?$(DJ1(B . ?\x71BF) ;; <CJK>
     (?$(DJ2(B . ?\x71C0) ;; <CJK>
     (?$(DJ3(B . ?\x71C1) ;; <CJK>
     (?$(DJ4(B . ?\x71C4) ;; <CJK>
     (?$(DJ5(B . ?\x71CB) ;; <CJK>
     (?$(DJ6(B . ?\x71CC) ;; <CJK>
     (?$(DJ7(B . ?\x71D3) ;; <CJK>
     (?$(DJ8(B . ?\x71D6) ;; <CJK>
     (?$(DJ9(B . ?\x71D9) ;; <CJK>
     (?$(DJ:(B . ?\x71DA) ;; <CJK>
     (?$(DJ;(B . ?\x71DC) ;; <CJK>
     (?$(DJ<(B . ?\x71F8) ;; <CJK>
     (?$(DJ=(B . ?\x71FE) ;; <CJK>
     (?$(DJ>(B . ?\x7200) ;; <CJK>
     (?$(DJ?(B . ?\x7207) ;; <CJK>
     (?$(DJ@(B . ?\x7208) ;; <CJK>
     (?$(DJA(B . ?\x7209) ;; <CJK>
     (?$(DJB(B . ?\x7213) ;; <CJK>
     (?$(DJC(B . ?\x7217) ;; <CJK>
     (?$(DJD(B . ?\x721A) ;; <CJK>
     (?$(DJE(B . ?\x721D) ;; <CJK>
     (?$(DJF(B . ?\x721F) ;; <CJK>
     (?$(DJG(B . ?\x7224) ;; <CJK>
     (?$(DJH(B . ?\x722B) ;; <CJK>
     (?$(DJI(B . ?\x722F) ;; <CJK>
     (?$(DJJ(B . ?\x7234) ;; <CJK>
     (?$(DJK(B . ?\x7238) ;; <CJK>
     (?$(DJL(B . ?\x7239) ;; <CJK>
     (?$(DJM(B . ?\x7241) ;; <CJK>
     (?$(DJN(B . ?\x7242) ;; <CJK>
     (?$(DJO(B . ?\x7243) ;; <CJK>
     (?$(DJP(B . ?\x7245) ;; <CJK>
     (?$(DJQ(B . ?\x724E) ;; <CJK>
     (?$(DJR(B . ?\x724F) ;; <CJK>
     (?$(DJS(B . ?\x7250) ;; <CJK>
     (?$(DJT(B . ?\x7253) ;; <CJK>
     (?$(DJU(B . ?\x7255) ;; <CJK>
     (?$(DJV(B . ?\x7256) ;; <CJK>
     (?$(DJW(B . ?\x725A) ;; <CJK>
     (?$(DJX(B . ?\x725C) ;; <CJK>
     (?$(DJY(B . ?\x725E) ;; <CJK>
     (?$(DJZ(B . ?\x7260) ;; <CJK>
     (?$(DJ[(B . ?\x7263) ;; <CJK>
     (?$(DJ\(B . ?\x7268) ;; <CJK>
     (?$(DJ](B . ?\x726B) ;; <CJK>
     (?$(DJ^(B . ?\x726E) ;; <CJK>
     (?$(DJ_(B . ?\x726F) ;; <CJK>
     (?$(DJ`(B . ?\x7271) ;; <CJK>
     (?$(DJa(B . ?\x7277) ;; <CJK>
     (?$(DJb(B . ?\x7278) ;; <CJK>
     (?$(DJc(B . ?\x727B) ;; <CJK>
     (?$(DJd(B . ?\x727C) ;; <CJK>
     (?$(DJe(B . ?\x727F) ;; <CJK>
     (?$(DJf(B . ?\x7284) ;; <CJK>
     (?$(DJg(B . ?\x7289) ;; <CJK>
     (?$(DJh(B . ?\x728D) ;; <CJK>
     (?$(DJi(B . ?\x728E) ;; <CJK>
     (?$(DJj(B . ?\x7293) ;; <CJK>
     (?$(DJk(B . ?\x729B) ;; <CJK>
     (?$(DJl(B . ?\x72A8) ;; <CJK>
     (?$(DJm(B . ?\x72AD) ;; <CJK>
     (?$(DJn(B . ?\x72AE) ;; <CJK>
     (?$(DJo(B . ?\x72B1) ;; <CJK>
     (?$(DJp(B . ?\x72B4) ;; <CJK>
     (?$(DJq(B . ?\x72BE) ;; <CJK>
     (?$(DJr(B . ?\x72C1) ;; <CJK>
     (?$(DJs(B . ?\x72C7) ;; <CJK>
     (?$(DJt(B . ?\x72C9) ;; <CJK>
     (?$(DJu(B . ?\x72CC) ;; <CJK>
     (?$(DJv(B . ?\x72D5) ;; <CJK>
     (?$(DJw(B . ?\x72D6) ;; <CJK>
     (?$(DJx(B . ?\x72D8) ;; <CJK>
     (?$(DJy(B . ?\x72DF) ;; <CJK>
     (?$(DJz(B . ?\x72E5) ;; <CJK>
     (?$(DJ{(B . ?\x72F3) ;; <CJK>
     (?$(DJ|(B . ?\x72F4) ;; <CJK>
     (?$(DJ}(B . ?\x72FA) ;; <CJK>
     (?$(DJ~(B . ?\x72FB) ;; <CJK>
     (?$(DK!(B . ?\x72FE) ;; <CJK>
     (?$(DK"(B . ?\x7302) ;; <CJK>
     (?$(DK#(B . ?\x7304) ;; <CJK>
     (?$(DK$(B . ?\x7305) ;; <CJK>
     (?$(DK%(B . ?\x7307) ;; <CJK>
     (?$(DK&(B . ?\x730B) ;; <CJK>
     (?$(DK'(B . ?\x730D) ;; <CJK>
     (?$(DK((B . ?\x7312) ;; <CJK>
     (?$(DK)(B . ?\x7313) ;; <CJK>
     (?$(DK*(B . ?\x7318) ;; <CJK>
     (?$(DK+(B . ?\x7319) ;; <CJK>
     (?$(DK,(B . ?\x731E) ;; <CJK>
     (?$(DK-(B . ?\x7322) ;; <CJK>
     (?$(DK.(B . ?\x7324) ;; <CJK>
     (?$(DK/(B . ?\x7327) ;; <CJK>
     (?$(DK0(B . ?\x7328) ;; <CJK>
     (?$(DK1(B . ?\x732C) ;; <CJK>
     (?$(DK2(B . ?\x7331) ;; <CJK>
     (?$(DK3(B . ?\x7332) ;; <CJK>
     (?$(DK4(B . ?\x7335) ;; <CJK>
     (?$(DK5(B . ?\x733A) ;; <CJK>
     (?$(DK6(B . ?\x733B) ;; <CJK>
     (?$(DK7(B . ?\x733D) ;; <CJK>
     (?$(DK8(B . ?\x7343) ;; <CJK>
     (?$(DK9(B . ?\x734D) ;; <CJK>
     (?$(DK:(B . ?\x7350) ;; <CJK>
     (?$(DK;(B . ?\x7352) ;; <CJK>
     (?$(DK<(B . ?\x7356) ;; <CJK>
     (?$(DK=(B . ?\x7358) ;; <CJK>
     (?$(DK>(B . ?\x735D) ;; <CJK>
     (?$(DK?(B . ?\x735E) ;; <CJK>
     (?$(DK@(B . ?\x735F) ;; <CJK>
     (?$(DKA(B . ?\x7360) ;; <CJK>
     (?$(DKB(B . ?\x7366) ;; <CJK>
     (?$(DKC(B . ?\x7367) ;; <CJK>
     (?$(DKD(B . ?\x7369) ;; <CJK>
     (?$(DKE(B . ?\x736B) ;; <CJK>
     (?$(DKF(B . ?\x736C) ;; <CJK>
     (?$(DKG(B . ?\x736E) ;; <CJK>
     (?$(DKH(B . ?\x736F) ;; <CJK>
     (?$(DKI(B . ?\x7371) ;; <CJK>
     (?$(DKJ(B . ?\x7377) ;; <CJK>
     (?$(DKK(B . ?\x7379) ;; <CJK>
     (?$(DKL(B . ?\x737C) ;; <CJK>
     (?$(DKM(B . ?\x7380) ;; <CJK>
     (?$(DKN(B . ?\x7381) ;; <CJK>
     (?$(DKO(B . ?\x7383) ;; <CJK>
     (?$(DKP(B . ?\x7385) ;; <CJK>
     (?$(DKQ(B . ?\x7386) ;; <CJK>
     (?$(DKR(B . ?\x738E) ;; <CJK>
     (?$(DKS(B . ?\x7390) ;; <CJK>
     (?$(DKT(B . ?\x7393) ;; <CJK>
     (?$(DKU(B . ?\x7395) ;; <CJK>
     (?$(DKV(B . ?\x7397) ;; <CJK>
     (?$(DKW(B . ?\x7398) ;; <CJK>
     (?$(DKX(B . ?\x739C) ;; <CJK>
     (?$(DKY(B . ?\x739E) ;; <CJK>
     (?$(DKZ(B . ?\x739F) ;; <CJK>
     (?$(DK[(B . ?\x73A0) ;; <CJK>
     (?$(DK\(B . ?\x73A2) ;; <CJK>
     (?$(DK](B . ?\x73A5) ;; <CJK>
     (?$(DK^(B . ?\x73A6) ;; <CJK>
     (?$(DK_(B . ?\x73AA) ;; <CJK>
     (?$(DK`(B . ?\x73AB) ;; <CJK>
     (?$(DKa(B . ?\x73AD) ;; <CJK>
     (?$(DKb(B . ?\x73B5) ;; <CJK>
     (?$(DKc(B . ?\x73B7) ;; <CJK>
     (?$(DKd(B . ?\x73B9) ;; <CJK>
     (?$(DKe(B . ?\x73BC) ;; <CJK>
     (?$(DKf(B . ?\x73BD) ;; <CJK>
     (?$(DKg(B . ?\x73BF) ;; <CJK>
     (?$(DKh(B . ?\x73C5) ;; <CJK>
     (?$(DKi(B . ?\x73C6) ;; <CJK>
     (?$(DKj(B . ?\x73C9) ;; <CJK>
     (?$(DKk(B . ?\x73CB) ;; <CJK>
     (?$(DKl(B . ?\x73CC) ;; <CJK>
     (?$(DKm(B . ?\x73CF) ;; <CJK>
     (?$(DKn(B . ?\x73D2) ;; <CJK>
     (?$(DKo(B . ?\x73D3) ;; <CJK>
     (?$(DKp(B . ?\x73D6) ;; <CJK>
     (?$(DKq(B . ?\x73D9) ;; <CJK>
     (?$(DKr(B . ?\x73DD) ;; <CJK>
     (?$(DKs(B . ?\x73E1) ;; <CJK>
     (?$(DKt(B . ?\x73E3) ;; <CJK>
     (?$(DKu(B . ?\x73E6) ;; <CJK>
     (?$(DKv(B . ?\x73E7) ;; <CJK>
     (?$(DKw(B . ?\x73E9) ;; <CJK>
     (?$(DKx(B . ?\x73F4) ;; <CJK>
     (?$(DKy(B . ?\x73F5) ;; <CJK>
     (?$(DKz(B . ?\x73F7) ;; <CJK>
     (?$(DK{(B . ?\x73F9) ;; <CJK>
     (?$(DK|(B . ?\x73FA) ;; <CJK>
     (?$(DK}(B . ?\x73FB) ;; <CJK>
     (?$(DK~(B . ?\x73FD) ;; <CJK>
     (?$(DL!(B . ?\x73FF) ;; <CJK>
     (?$(DL"(B . ?\x7400) ;; <CJK>
     (?$(DL#(B . ?\x7401) ;; <CJK>
     (?$(DL$(B . ?\x7404) ;; <CJK>
     (?$(DL%(B . ?\x7407) ;; <CJK>
     (?$(DL&(B . ?\x740A) ;; <CJK>
     (?$(DL'(B . ?\x7411) ;; <CJK>
     (?$(DL((B . ?\x741A) ;; <CJK>
     (?$(DL)(B . ?\x741B) ;; <CJK>
     (?$(DL*(B . ?\x7424) ;; <CJK>
     (?$(DL+(B . ?\x7426) ;; <CJK>
     (?$(DL,(B . ?\x7428) ;; <CJK>
     (?$(DL-(B . ?\x7429) ;; <CJK>
     (?$(DL.(B . ?\x742A) ;; <CJK>
     (?$(DL/(B . ?\x742B) ;; <CJK>
     (?$(DL0(B . ?\x742C) ;; <CJK>
     (?$(DL1(B . ?\x742D) ;; <CJK>
     (?$(DL2(B . ?\x742E) ;; <CJK>
     (?$(DL3(B . ?\x742F) ;; <CJK>
     (?$(DL4(B . ?\x7430) ;; <CJK>
     (?$(DL5(B . ?\x7431) ;; <CJK>
     (?$(DL6(B . ?\x7439) ;; <CJK>
     (?$(DL7(B . ?\x7440) ;; <CJK>
     (?$(DL8(B . ?\x7443) ;; <CJK>
     (?$(DL9(B . ?\x7444) ;; <CJK>
     (?$(DL:(B . ?\x7446) ;; <CJK>
     (?$(DL;(B . ?\x7447) ;; <CJK>
     (?$(DL<(B . ?\x744B) ;; <CJK>
     (?$(DL=(B . ?\x744D) ;; <CJK>
     (?$(DL>(B . ?\x7451) ;; <CJK>
     (?$(DL?(B . ?\x7452) ;; <CJK>
     (?$(DL@(B . ?\x7457) ;; <CJK>
     (?$(DLA(B . ?\x745D) ;; <CJK>
     (?$(DLB(B . ?\x7462) ;; <CJK>
     (?$(DLC(B . ?\x7466) ;; <CJK>
     (?$(DLD(B . ?\x7467) ;; <CJK>
     (?$(DLE(B . ?\x7468) ;; <CJK>
     (?$(DLF(B . ?\x746B) ;; <CJK>
     (?$(DLG(B . ?\x746D) ;; <CJK>
     (?$(DLH(B . ?\x746E) ;; <CJK>
     (?$(DLI(B . ?\x7471) ;; <CJK>
     (?$(DLJ(B . ?\x7472) ;; <CJK>
     (?$(DLK(B . ?\x7480) ;; <CJK>
     (?$(DLL(B . ?\x7481) ;; <CJK>
     (?$(DLM(B . ?\x7485) ;; <CJK>
     (?$(DLN(B . ?\x7486) ;; <CJK>
     (?$(DLO(B . ?\x7487) ;; <CJK>
     (?$(DLP(B . ?\x7489) ;; <CJK>
     (?$(DLQ(B . ?\x748F) ;; <CJK>
     (?$(DLR(B . ?\x7490) ;; <CJK>
     (?$(DLS(B . ?\x7491) ;; <CJK>
     (?$(DLT(B . ?\x7492) ;; <CJK>
     (?$(DLU(B . ?\x7498) ;; <CJK>
     (?$(DLV(B . ?\x7499) ;; <CJK>
     (?$(DLW(B . ?\x749A) ;; <CJK>
     (?$(DLX(B . ?\x749C) ;; <CJK>
     (?$(DLY(B . ?\x749F) ;; <CJK>
     (?$(DLZ(B . ?\x74A0) ;; <CJK>
     (?$(DL[(B . ?\x74A1) ;; <CJK>
     (?$(DL\(B . ?\x74A3) ;; <CJK>
     (?$(DL](B . ?\x74A6) ;; <CJK>
     (?$(DL^(B . ?\x74A8) ;; <CJK>
     (?$(DL_(B . ?\x74A9) ;; <CJK>
     (?$(DL`(B . ?\x74AA) ;; <CJK>
     (?$(DLa(B . ?\x74AB) ;; <CJK>
     (?$(DLb(B . ?\x74AE) ;; <CJK>
     (?$(DLc(B . ?\x74AF) ;; <CJK>
     (?$(DLd(B . ?\x74B1) ;; <CJK>
     (?$(DLe(B . ?\x74B2) ;; <CJK>
     (?$(DLf(B . ?\x74B5) ;; <CJK>
     (?$(DLg(B . ?\x74B9) ;; <CJK>
     (?$(DLh(B . ?\x74BB) ;; <CJK>
     (?$(DLi(B . ?\x74BF) ;; <CJK>
     (?$(DLj(B . ?\x74C8) ;; <CJK>
     (?$(DLk(B . ?\x74C9) ;; <CJK>
     (?$(DLl(B . ?\x74CC) ;; <CJK>
     (?$(DLm(B . ?\x74D0) ;; <CJK>
     (?$(DLn(B . ?\x74D3) ;; <CJK>
     (?$(DLo(B . ?\x74D8) ;; <CJK>
     (?$(DLp(B . ?\x74DA) ;; <CJK>
     (?$(DLq(B . ?\x74DB) ;; <CJK>
     (?$(DLr(B . ?\x74DE) ;; <CJK>
     (?$(DLs(B . ?\x74DF) ;; <CJK>
     (?$(DLt(B . ?\x74E4) ;; <CJK>
     (?$(DLu(B . ?\x74E8) ;; <CJK>
     (?$(DLv(B . ?\x74EA) ;; <CJK>
     (?$(DLw(B . ?\x74EB) ;; <CJK>
     (?$(DLx(B . ?\x74EF) ;; <CJK>
     (?$(DLy(B . ?\x74F4) ;; <CJK>
     (?$(DLz(B . ?\x74FA) ;; <CJK>
     (?$(DL{(B . ?\x74FB) ;; <CJK>
     (?$(DL|(B . ?\x74FC) ;; <CJK>
     (?$(DL}(B . ?\x74FF) ;; <CJK>
     (?$(DL~(B . ?\x7506) ;; <CJK>
     (?$(DM!(B . ?\x7512) ;; <CJK>
     (?$(DM"(B . ?\x7516) ;; <CJK>
     (?$(DM#(B . ?\x7517) ;; <CJK>
     (?$(DM$(B . ?\x7520) ;; <CJK>
     (?$(DM%(B . ?\x7521) ;; <CJK>
     (?$(DM&(B . ?\x7524) ;; <CJK>
     (?$(DM'(B . ?\x7527) ;; <CJK>
     (?$(DM((B . ?\x7529) ;; <CJK>
     (?$(DM)(B . ?\x752A) ;; <CJK>
     (?$(DM*(B . ?\x752F) ;; <CJK>
     (?$(DM+(B . ?\x7536) ;; <CJK>
     (?$(DM,(B . ?\x7539) ;; <CJK>
     (?$(DM-(B . ?\x753D) ;; <CJK>
     (?$(DM.(B . ?\x753E) ;; <CJK>
     (?$(DM/(B . ?\x753F) ;; <CJK>
     (?$(DM0(B . ?\x7540) ;; <CJK>
     (?$(DM1(B . ?\x7543) ;; <CJK>
     (?$(DM2(B . ?\x7547) ;; <CJK>
     (?$(DM3(B . ?\x7548) ;; <CJK>
     (?$(DM4(B . ?\x754E) ;; <CJK>
     (?$(DM5(B . ?\x7550) ;; <CJK>
     (?$(DM6(B . ?\x7552) ;; <CJK>
     (?$(DM7(B . ?\x7557) ;; <CJK>
     (?$(DM8(B . ?\x755E) ;; <CJK>
     (?$(DM9(B . ?\x755F) ;; <CJK>
     (?$(DM:(B . ?\x7561) ;; <CJK>
     (?$(DM;(B . ?\x756F) ;; <CJK>
     (?$(DM<(B . ?\x7571) ;; <CJK>
     (?$(DM=(B . ?\x7579) ;; <CJK>
     (?$(DM>(B . ?\x757A) ;; <CJK>
     (?$(DM?(B . ?\x757B) ;; <CJK>
     (?$(DM@(B . ?\x757C) ;; <CJK>
     (?$(DMA(B . ?\x757D) ;; <CJK>
     (?$(DMB(B . ?\x757E) ;; <CJK>
     (?$(DMC(B . ?\x7581) ;; <CJK>
     (?$(DMD(B . ?\x7585) ;; <CJK>
     (?$(DME(B . ?\x7590) ;; <CJK>
     (?$(DMF(B . ?\x7592) ;; <CJK>
     (?$(DMG(B . ?\x7593) ;; <CJK>
     (?$(DMH(B . ?\x7595) ;; <CJK>
     (?$(DMI(B . ?\x7599) ;; <CJK>
     (?$(DMJ(B . ?\x759C) ;; <CJK>
     (?$(DMK(B . ?\x75A2) ;; <CJK>
     (?$(DML(B . ?\x75A4) ;; <CJK>
     (?$(DMM(B . ?\x75B4) ;; <CJK>
     (?$(DMN(B . ?\x75BA) ;; <CJK>
     (?$(DMO(B . ?\x75BF) ;; <CJK>
     (?$(DMP(B . ?\x75C0) ;; <CJK>
     (?$(DMQ(B . ?\x75C1) ;; <CJK>
     (?$(DMR(B . ?\x75C4) ;; <CJK>
     (?$(DMS(B . ?\x75C6) ;; <CJK>
     (?$(DMT(B . ?\x75CC) ;; <CJK>
     (?$(DMU(B . ?\x75CE) ;; <CJK>
     (?$(DMV(B . ?\x75CF) ;; <CJK>
     (?$(DMW(B . ?\x75D7) ;; <CJK>
     (?$(DMX(B . ?\x75DC) ;; <CJK>
     (?$(DMY(B . ?\x75DF) ;; <CJK>
     (?$(DMZ(B . ?\x75E0) ;; <CJK>
     (?$(DM[(B . ?\x75E1) ;; <CJK>
     (?$(DM\(B . ?\x75E4) ;; <CJK>
     (?$(DM](B . ?\x75E7) ;; <CJK>
     (?$(DM^(B . ?\x75EC) ;; <CJK>
     (?$(DM_(B . ?\x75EE) ;; <CJK>
     (?$(DM`(B . ?\x75EF) ;; <CJK>
     (?$(DMa(B . ?\x75F1) ;; <CJK>
     (?$(DMb(B . ?\x75F9) ;; <CJK>
     (?$(DMc(B . ?\x7600) ;; <CJK>
     (?$(DMd(B . ?\x7602) ;; <CJK>
     (?$(DMe(B . ?\x7603) ;; <CJK>
     (?$(DMf(B . ?\x7604) ;; <CJK>
     (?$(DMg(B . ?\x7607) ;; <CJK>
     (?$(DMh(B . ?\x7608) ;; <CJK>
     (?$(DMi(B . ?\x760A) ;; <CJK>
     (?$(DMj(B . ?\x760C) ;; <CJK>
     (?$(DMk(B . ?\x760F) ;; <CJK>
     (?$(DMl(B . ?\x7612) ;; <CJK>
     (?$(DMm(B . ?\x7613) ;; <CJK>
     (?$(DMn(B . ?\x7615) ;; <CJK>
     (?$(DMo(B . ?\x7616) ;; <CJK>
     (?$(DMp(B . ?\x7619) ;; <CJK>
     (?$(DMq(B . ?\x761B) ;; <CJK>
     (?$(DMr(B . ?\x761C) ;; <CJK>
     (?$(DMs(B . ?\x761D) ;; <CJK>
     (?$(DMt(B . ?\x761E) ;; <CJK>
     (?$(DMu(B . ?\x7623) ;; <CJK>
     (?$(DMv(B . ?\x7625) ;; <CJK>
     (?$(DMw(B . ?\x7626) ;; <CJK>
     (?$(DMx(B . ?\x7629) ;; <CJK>
     (?$(DMy(B . ?\x762D) ;; <CJK>
     (?$(DMz(B . ?\x7632) ;; <CJK>
     (?$(DM{(B . ?\x7633) ;; <CJK>
     (?$(DM|(B . ?\x7635) ;; <CJK>
     (?$(DM}(B . ?\x7638) ;; <CJK>
     (?$(DM~(B . ?\x7639) ;; <CJK>
     (?$(DN!(B . ?\x763A) ;; <CJK>
     (?$(DN"(B . ?\x763C) ;; <CJK>
     (?$(DN#(B . ?\x764A) ;; <CJK>
     (?$(DN$(B . ?\x7640) ;; <CJK>
     (?$(DN%(B . ?\x7641) ;; <CJK>
     (?$(DN&(B . ?\x7643) ;; <CJK>
     (?$(DN'(B . ?\x7644) ;; <CJK>
     (?$(DN((B . ?\x7645) ;; <CJK>
     (?$(DN)(B . ?\x7649) ;; <CJK>
     (?$(DN*(B . ?\x764B) ;; <CJK>
     (?$(DN+(B . ?\x7655) ;; <CJK>
     (?$(DN,(B . ?\x7659) ;; <CJK>
     (?$(DN-(B . ?\x765F) ;; <CJK>
     (?$(DN.(B . ?\x7664) ;; <CJK>
     (?$(DN/(B . ?\x7665) ;; <CJK>
     (?$(DN0(B . ?\x766D) ;; <CJK>
     (?$(DN1(B . ?\x766E) ;; <CJK>
     (?$(DN2(B . ?\x766F) ;; <CJK>
     (?$(DN3(B . ?\x7671) ;; <CJK>
     (?$(DN4(B . ?\x7674) ;; <CJK>
     (?$(DN5(B . ?\x7681) ;; <CJK>
     (?$(DN6(B . ?\x7685) ;; <CJK>
     (?$(DN7(B . ?\x768C) ;; <CJK>
     (?$(DN8(B . ?\x768D) ;; <CJK>
     (?$(DN9(B . ?\x7695) ;; <CJK>
     (?$(DN:(B . ?\x769B) ;; <CJK>
     (?$(DN;(B . ?\x769C) ;; <CJK>
     (?$(DN<(B . ?\x769D) ;; <CJK>
     (?$(DN=(B . ?\x769F) ;; <CJK>
     (?$(DN>(B . ?\x76A0) ;; <CJK>
     (?$(DN?(B . ?\x76A2) ;; <CJK>
     (?$(DN@(B . ?\x76A3) ;; <CJK>
     (?$(DNA(B . ?\x76A4) ;; <CJK>
     (?$(DNB(B . ?\x76A5) ;; <CJK>
     (?$(DNC(B . ?\x76A6) ;; <CJK>
     (?$(DND(B . ?\x76A7) ;; <CJK>
     (?$(DNE(B . ?\x76A8) ;; <CJK>
     (?$(DNF(B . ?\x76AA) ;; <CJK>
     (?$(DNG(B . ?\x76AD) ;; <CJK>
     (?$(DNH(B . ?\x76BD) ;; <CJK>
     (?$(DNI(B . ?\x76C1) ;; <CJK>
     (?$(DNJ(B . ?\x76C5) ;; <CJK>
     (?$(DNK(B . ?\x76C9) ;; <CJK>
     (?$(DNL(B . ?\x76CB) ;; <CJK>
     (?$(DNM(B . ?\x76CC) ;; <CJK>
     (?$(DNN(B . ?\x76CE) ;; <CJK>
     (?$(DNO(B . ?\x76D4) ;; <CJK>
     (?$(DNP(B . ?\x76D9) ;; <CJK>
     (?$(DNQ(B . ?\x76E0) ;; <CJK>
     (?$(DNR(B . ?\x76E6) ;; <CJK>
     (?$(DNS(B . ?\x76E8) ;; <CJK>
     (?$(DNT(B . ?\x76EC) ;; <CJK>
     (?$(DNU(B . ?\x76F0) ;; <CJK>
     (?$(DNV(B . ?\x76F1) ;; <CJK>
     (?$(DNW(B . ?\x76F6) ;; <CJK>
     (?$(DNX(B . ?\x76F9) ;; <CJK>
     (?$(DNY(B . ?\x76FC) ;; <CJK>
     (?$(DNZ(B . ?\x7700) ;; <CJK>
     (?$(DN[(B . ?\x7706) ;; <CJK>
     (?$(DN\(B . ?\x770A) ;; <CJK>
     (?$(DN](B . ?\x770E) ;; <CJK>
     (?$(DN^(B . ?\x7712) ;; <CJK>
     (?$(DN_(B . ?\x7714) ;; <CJK>
     (?$(DN`(B . ?\x7715) ;; <CJK>
     (?$(DNa(B . ?\x7717) ;; <CJK>
     (?$(DNb(B . ?\x7719) ;; <CJK>
     (?$(DNc(B . ?\x771A) ;; <CJK>
     (?$(DNd(B . ?\x771C) ;; <CJK>
     (?$(DNe(B . ?\x7722) ;; <CJK>
     (?$(DNf(B . ?\x7728) ;; <CJK>
     (?$(DNg(B . ?\x772D) ;; <CJK>
     (?$(DNh(B . ?\x772E) ;; <CJK>
     (?$(DNi(B . ?\x772F) ;; <CJK>
     (?$(DNj(B . ?\x7734) ;; <CJK>
     (?$(DNk(B . ?\x7735) ;; <CJK>
     (?$(DNl(B . ?\x7736) ;; <CJK>
     (?$(DNm(B . ?\x7739) ;; <CJK>
     (?$(DNn(B . ?\x773D) ;; <CJK>
     (?$(DNo(B . ?\x773E) ;; <CJK>
     (?$(DNp(B . ?\x7742) ;; <CJK>
     (?$(DNq(B . ?\x7745) ;; <CJK>
     (?$(DNr(B . ?\x7746) ;; <CJK>
     (?$(DNs(B . ?\x774A) ;; <CJK>
     (?$(DNt(B . ?\x774D) ;; <CJK>
     (?$(DNu(B . ?\x774E) ;; <CJK>
     (?$(DNv(B . ?\x774F) ;; <CJK>
     (?$(DNw(B . ?\x7752) ;; <CJK>
     (?$(DNx(B . ?\x7756) ;; <CJK>
     (?$(DNy(B . ?\x7757) ;; <CJK>
     (?$(DNz(B . ?\x775C) ;; <CJK>
     (?$(DN{(B . ?\x775E) ;; <CJK>
     (?$(DN|(B . ?\x775F) ;; <CJK>
     (?$(DN}(B . ?\x7760) ;; <CJK>
     (?$(DN~(B . ?\x7762) ;; <CJK>
     (?$(DO!(B . ?\x7764) ;; <CJK>
     (?$(DO"(B . ?\x7767) ;; <CJK>
     (?$(DO#(B . ?\x776A) ;; <CJK>
     (?$(DO$(B . ?\x776C) ;; <CJK>
     (?$(DO%(B . ?\x7770) ;; <CJK>
     (?$(DO&(B . ?\x7772) ;; <CJK>
     (?$(DO'(B . ?\x7773) ;; <CJK>
     (?$(DO((B . ?\x7774) ;; <CJK>
     (?$(DO)(B . ?\x777A) ;; <CJK>
     (?$(DO*(B . ?\x777D) ;; <CJK>
     (?$(DO+(B . ?\x7780) ;; <CJK>
     (?$(DO,(B . ?\x7784) ;; <CJK>
     (?$(DO-(B . ?\x778C) ;; <CJK>
     (?$(DO.(B . ?\x778D) ;; <CJK>
     (?$(DO/(B . ?\x7794) ;; <CJK>
     (?$(DO0(B . ?\x7795) ;; <CJK>
     (?$(DO1(B . ?\x7796) ;; <CJK>
     (?$(DO2(B . ?\x779A) ;; <CJK>
     (?$(DO3(B . ?\x779F) ;; <CJK>
     (?$(DO4(B . ?\x77A2) ;; <CJK>
     (?$(DO5(B . ?\x77A7) ;; <CJK>
     (?$(DO6(B . ?\x77AA) ;; <CJK>
     (?$(DO7(B . ?\x77AE) ;; <CJK>
     (?$(DO8(B . ?\x77AF) ;; <CJK>
     (?$(DO9(B . ?\x77B1) ;; <CJK>
     (?$(DO:(B . ?\x77B5) ;; <CJK>
     (?$(DO;(B . ?\x77BE) ;; <CJK>
     (?$(DO<(B . ?\x77C3) ;; <CJK>
     (?$(DO=(B . ?\x77C9) ;; <CJK>
     (?$(DO>(B . ?\x77D1) ;; <CJK>
     (?$(DO?(B . ?\x77D2) ;; <CJK>
     (?$(DO@(B . ?\x77D5) ;; <CJK>
     (?$(DOA(B . ?\x77D9) ;; <CJK>
     (?$(DOB(B . ?\x77DE) ;; <CJK>
     (?$(DOC(B . ?\x77DF) ;; <CJK>
     (?$(DOD(B . ?\x77E0) ;; <CJK>
     (?$(DOE(B . ?\x77E4) ;; <CJK>
     (?$(DOF(B . ?\x77E6) ;; <CJK>
     (?$(DOG(B . ?\x77EA) ;; <CJK>
     (?$(DOH(B . ?\x77EC) ;; <CJK>
     (?$(DOI(B . ?\x77F0) ;; <CJK>
     (?$(DOJ(B . ?\x77F1) ;; <CJK>
     (?$(DOK(B . ?\x77F4) ;; <CJK>
     (?$(DOL(B . ?\x77F8) ;; <CJK>
     (?$(DOM(B . ?\x77FB) ;; <CJK>
     (?$(DON(B . ?\x7805) ;; <CJK>
     (?$(DOO(B . ?\x7806) ;; <CJK>
     (?$(DOP(B . ?\x7809) ;; <CJK>
     (?$(DOQ(B . ?\x780D) ;; <CJK>
     (?$(DOR(B . ?\x780E) ;; <CJK>
     (?$(DOS(B . ?\x7811) ;; <CJK>
     (?$(DOT(B . ?\x781D) ;; <CJK>
     (?$(DOU(B . ?\x7821) ;; <CJK>
     (?$(DOV(B . ?\x7822) ;; <CJK>
     (?$(DOW(B . ?\x7823) ;; <CJK>
     (?$(DOX(B . ?\x782D) ;; <CJK>
     (?$(DOY(B . ?\x782E) ;; <CJK>
     (?$(DOZ(B . ?\x7830) ;; <CJK>
     (?$(DO[(B . ?\x7835) ;; <CJK>
     (?$(DO\(B . ?\x7837) ;; <CJK>
     (?$(DO](B . ?\x7843) ;; <CJK>
     (?$(DO^(B . ?\x7844) ;; <CJK>
     (?$(DO_(B . ?\x7847) ;; <CJK>
     (?$(DO`(B . ?\x7848) ;; <CJK>
     (?$(DOa(B . ?\x784C) ;; <CJK>
     (?$(DOb(B . ?\x784E) ;; <CJK>
     (?$(DOc(B . ?\x7852) ;; <CJK>
     (?$(DOd(B . ?\x785C) ;; <CJK>
     (?$(DOe(B . ?\x785E) ;; <CJK>
     (?$(DOf(B . ?\x7860) ;; <CJK>
     (?$(DOg(B . ?\x7861) ;; <CJK>
     (?$(DOh(B . ?\x7863) ;; <CJK>
     (?$(DOi(B . ?\x7864) ;; <CJK>
     (?$(DOj(B . ?\x7868) ;; <CJK>
     (?$(DOk(B . ?\x786A) ;; <CJK>
     (?$(DOl(B . ?\x786E) ;; <CJK>
     (?$(DOm(B . ?\x787A) ;; <CJK>
     (?$(DOn(B . ?\x787E) ;; <CJK>
     (?$(DOo(B . ?\x788A) ;; <CJK>
     (?$(DOp(B . ?\x788F) ;; <CJK>
     (?$(DOq(B . ?\x7894) ;; <CJK>
     (?$(DOr(B . ?\x7898) ;; <CJK>
     (?$(DOs(B . ?\x78A1) ;; <CJK>
     (?$(DOt(B . ?\x789D) ;; <CJK>
     (?$(DOu(B . ?\x789E) ;; <CJK>
     (?$(DOv(B . ?\x789F) ;; <CJK>
     (?$(DOw(B . ?\x78A4) ;; <CJK>
     (?$(DOx(B . ?\x78A8) ;; <CJK>
     (?$(DOy(B . ?\x78AC) ;; <CJK>
     (?$(DOz(B . ?\x78AD) ;; <CJK>
     (?$(DO{(B . ?\x78B0) ;; <CJK>
     (?$(DO|(B . ?\x78B1) ;; <CJK>
     (?$(DO}(B . ?\x78B2) ;; <CJK>
     (?$(DO~(B . ?\x78B3) ;; <CJK>
     (?$(DP!(B . ?\x78BB) ;; <CJK>
     (?$(DP"(B . ?\x78BD) ;; <CJK>
     (?$(DP#(B . ?\x78BF) ;; <CJK>
     (?$(DP$(B . ?\x78C7) ;; <CJK>
     (?$(DP%(B . ?\x78C8) ;; <CJK>
     (?$(DP&(B . ?\x78C9) ;; <CJK>
     (?$(DP'(B . ?\x78CC) ;; <CJK>
     (?$(DP((B . ?\x78CE) ;; <CJK>
     (?$(DP)(B . ?\x78D2) ;; <CJK>
     (?$(DP*(B . ?\x78D3) ;; <CJK>
     (?$(DP+(B . ?\x78D5) ;; <CJK>
     (?$(DP,(B . ?\x78D6) ;; <CJK>
     (?$(DP-(B . ?\x78E4) ;; <CJK>
     (?$(DP.(B . ?\x78DB) ;; <CJK>
     (?$(DP/(B . ?\x78DF) ;; <CJK>
     (?$(DP0(B . ?\x78E0) ;; <CJK>
     (?$(DP1(B . ?\x78E1) ;; <CJK>
     (?$(DP2(B . ?\x78E6) ;; <CJK>
     (?$(DP3(B . ?\x78EA) ;; <CJK>
     (?$(DP4(B . ?\x78F2) ;; <CJK>
     (?$(DP5(B . ?\x78F3) ;; <CJK>
     (?$(DP6(B . ?\x7900) ;; <CJK>
     (?$(DP7(B . ?\x78F6) ;; <CJK>
     (?$(DP8(B . ?\x78F7) ;; <CJK>
     (?$(DP9(B . ?\x78FA) ;; <CJK>
     (?$(DP:(B . ?\x78FB) ;; <CJK>
     (?$(DP;(B . ?\x78FF) ;; <CJK>
     (?$(DP<(B . ?\x7906) ;; <CJK>
     (?$(DP=(B . ?\x790C) ;; <CJK>
     (?$(DP>(B . ?\x7910) ;; <CJK>
     (?$(DP?(B . ?\x791A) ;; <CJK>
     (?$(DP@(B . ?\x791C) ;; <CJK>
     (?$(DPA(B . ?\x791E) ;; <CJK>
     (?$(DPB(B . ?\x791F) ;; <CJK>
     (?$(DPC(B . ?\x7920) ;; <CJK>
     (?$(DPD(B . ?\x7925) ;; <CJK>
     (?$(DPE(B . ?\x7927) ;; <CJK>
     (?$(DPF(B . ?\x7929) ;; <CJK>
     (?$(DPG(B . ?\x792D) ;; <CJK>
     (?$(DPH(B . ?\x7931) ;; <CJK>
     (?$(DPI(B . ?\x7934) ;; <CJK>
     (?$(DPJ(B . ?\x7935) ;; <CJK>
     (?$(DPK(B . ?\x793B) ;; <CJK>
     (?$(DPL(B . ?\x793D) ;; <CJK>
     (?$(DPM(B . ?\x793F) ;; <CJK>
     (?$(DPN(B . ?\x7944) ;; <CJK>
     (?$(DPO(B . ?\x7945) ;; <CJK>
     (?$(DPP(B . ?\x7946) ;; <CJK>
     (?$(DPQ(B . ?\x794A) ;; <CJK>
     (?$(DPR(B . ?\x794B) ;; <CJK>
     (?$(DPS(B . ?\x794F) ;; <CJK>
     (?$(DPT(B . ?\x7951) ;; <CJK>
     (?$(DPU(B . ?\x7954) ;; <CJK>
     (?$(DPV(B . ?\x7958) ;; <CJK>
     (?$(DPW(B . ?\x795B) ;; <CJK>
     (?$(DPX(B . ?\x795C) ;; <CJK>
     (?$(DPY(B . ?\x7967) ;; <CJK>
     (?$(DPZ(B . ?\x7969) ;; <CJK>
     (?$(DP[(B . ?\x796B) ;; <CJK>
     (?$(DP\(B . ?\x7972) ;; <CJK>
     (?$(DP](B . ?\x7979) ;; <CJK>
     (?$(DP^(B . ?\x797B) ;; <CJK>
     (?$(DP_(B . ?\x797C) ;; <CJK>
     (?$(DP`(B . ?\x797E) ;; <CJK>
     (?$(DPa(B . ?\x798B) ;; <CJK>
     (?$(DPb(B . ?\x798C) ;; <CJK>
     (?$(DPc(B . ?\x7991) ;; <CJK>
     (?$(DPd(B . ?\x7993) ;; <CJK>
     (?$(DPe(B . ?\x7994) ;; <CJK>
     (?$(DPf(B . ?\x7995) ;; <CJK>
     (?$(DPg(B . ?\x7996) ;; <CJK>
     (?$(DPh(B . ?\x7998) ;; <CJK>
     (?$(DPi(B . ?\x799B) ;; <CJK>
     (?$(DPj(B . ?\x799C) ;; <CJK>
     (?$(DPk(B . ?\x79A1) ;; <CJK>
     (?$(DPl(B . ?\x79A8) ;; <CJK>
     (?$(DPm(B . ?\x79A9) ;; <CJK>
     (?$(DPn(B . ?\x79AB) ;; <CJK>
     (?$(DPo(B . ?\x79AF) ;; <CJK>
     (?$(DPp(B . ?\x79B1) ;; <CJK>
     (?$(DPq(B . ?\x79B4) ;; <CJK>
     (?$(DPr(B . ?\x79B8) ;; <CJK>
     (?$(DPs(B . ?\x79BB) ;; <CJK>
     (?$(DPt(B . ?\x79C2) ;; <CJK>
     (?$(DPu(B . ?\x79C4) ;; <CJK>
     (?$(DPv(B . ?\x79C7) ;; <CJK>
     (?$(DPw(B . ?\x79C8) ;; <CJK>
     (?$(DPx(B . ?\x79CA) ;; <CJK>
     (?$(DPy(B . ?\x79CF) ;; <CJK>
     (?$(DPz(B . ?\x79D4) ;; <CJK>
     (?$(DP{(B . ?\x79D6) ;; <CJK>
     (?$(DP|(B . ?\x79DA) ;; <CJK>
     (?$(DP}(B . ?\x79DD) ;; <CJK>
     (?$(DP~(B . ?\x79DE) ;; <CJK>
     (?$(DQ!(B . ?\x79E0) ;; <CJK>
     (?$(DQ"(B . ?\x79E2) ;; <CJK>
     (?$(DQ#(B . ?\x79E5) ;; <CJK>
     (?$(DQ$(B . ?\x79EA) ;; <CJK>
     (?$(DQ%(B . ?\x79EB) ;; <CJK>
     (?$(DQ&(B . ?\x79ED) ;; <CJK>
     (?$(DQ'(B . ?\x79F1) ;; <CJK>
     (?$(DQ((B . ?\x79F8) ;; <CJK>
     (?$(DQ)(B . ?\x79FC) ;; <CJK>
     (?$(DQ*(B . ?\x7A02) ;; <CJK>
     (?$(DQ+(B . ?\x7A03) ;; <CJK>
     (?$(DQ,(B . ?\x7A07) ;; <CJK>
     (?$(DQ-(B . ?\x7A09) ;; <CJK>
     (?$(DQ.(B . ?\x7A0A) ;; <CJK>
     (?$(DQ/(B . ?\x7A0C) ;; <CJK>
     (?$(DQ0(B . ?\x7A11) ;; <CJK>
     (?$(DQ1(B . ?\x7A15) ;; <CJK>
     (?$(DQ2(B . ?\x7A1B) ;; <CJK>
     (?$(DQ3(B . ?\x7A1E) ;; <CJK>
     (?$(DQ4(B . ?\x7A21) ;; <CJK>
     (?$(DQ5(B . ?\x7A27) ;; <CJK>
     (?$(DQ6(B . ?\x7A2B) ;; <CJK>
     (?$(DQ7(B . ?\x7A2D) ;; <CJK>
     (?$(DQ8(B . ?\x7A2F) ;; <CJK>
     (?$(DQ9(B . ?\x7A30) ;; <CJK>
     (?$(DQ:(B . ?\x7A34) ;; <CJK>
     (?$(DQ;(B . ?\x7A35) ;; <CJK>
     (?$(DQ<(B . ?\x7A38) ;; <CJK>
     (?$(DQ=(B . ?\x7A39) ;; <CJK>
     (?$(DQ>(B . ?\x7A3A) ;; <CJK>
     (?$(DQ?(B . ?\x7A44) ;; <CJK>
     (?$(DQ@(B . ?\x7A45) ;; <CJK>
     (?$(DQA(B . ?\x7A47) ;; <CJK>
     (?$(DQB(B . ?\x7A48) ;; <CJK>
     (?$(DQC(B . ?\x7A4C) ;; <CJK>
     (?$(DQD(B . ?\x7A55) ;; <CJK>
     (?$(DQE(B . ?\x7A56) ;; <CJK>
     (?$(DQF(B . ?\x7A59) ;; <CJK>
     (?$(DQG(B . ?\x7A5C) ;; <CJK>
     (?$(DQH(B . ?\x7A5D) ;; <CJK>
     (?$(DQI(B . ?\x7A5F) ;; <CJK>
     (?$(DQJ(B . ?\x7A60) ;; <CJK>
     (?$(DQK(B . ?\x7A65) ;; <CJK>
     (?$(DQL(B . ?\x7A67) ;; <CJK>
     (?$(DQM(B . ?\x7A6A) ;; <CJK>
     (?$(DQN(B . ?\x7A6D) ;; <CJK>
     (?$(DQO(B . ?\x7A75) ;; <CJK>
     (?$(DQP(B . ?\x7A78) ;; <CJK>
     (?$(DQQ(B . ?\x7A7E) ;; <CJK>
     (?$(DQR(B . ?\x7A80) ;; <CJK>
     (?$(DQS(B . ?\x7A82) ;; <CJK>
     (?$(DQT(B . ?\x7A85) ;; <CJK>
     (?$(DQU(B . ?\x7A86) ;; <CJK>
     (?$(DQV(B . ?\x7A8A) ;; <CJK>
     (?$(DQW(B . ?\x7A8B) ;; <CJK>
     (?$(DQX(B . ?\x7A90) ;; <CJK>
     (?$(DQY(B . ?\x7A91) ;; <CJK>
     (?$(DQZ(B . ?\x7A94) ;; <CJK>
     (?$(DQ[(B . ?\x7A9E) ;; <CJK>
     (?$(DQ\(B . ?\x7AA0) ;; <CJK>
     (?$(DQ](B . ?\x7AA3) ;; <CJK>
     (?$(DQ^(B . ?\x7AAC) ;; <CJK>
     (?$(DQ_(B . ?\x7AB3) ;; <CJK>
     (?$(DQ`(B . ?\x7AB5) ;; <CJK>
     (?$(DQa(B . ?\x7AB9) ;; <CJK>
     (?$(DQb(B . ?\x7ABB) ;; <CJK>
     (?$(DQc(B . ?\x7ABC) ;; <CJK>
     (?$(DQd(B . ?\x7AC6) ;; <CJK>
     (?$(DQe(B . ?\x7AC9) ;; <CJK>
     (?$(DQf(B . ?\x7ACC) ;; <CJK>
     (?$(DQg(B . ?\x7ACE) ;; <CJK>
     (?$(DQh(B . ?\x7AD1) ;; <CJK>
     (?$(DQi(B . ?\x7ADB) ;; <CJK>
     (?$(DQj(B . ?\x7AE8) ;; <CJK>
     (?$(DQk(B . ?\x7AE9) ;; <CJK>
     (?$(DQl(B . ?\x7AEB) ;; <CJK>
     (?$(DQm(B . ?\x7AEC) ;; <CJK>
     (?$(DQn(B . ?\x7AF1) ;; <CJK>
     (?$(DQo(B . ?\x7AF4) ;; <CJK>
     (?$(DQp(B . ?\x7AFB) ;; <CJK>
     (?$(DQq(B . ?\x7AFD) ;; <CJK>
     (?$(DQr(B . ?\x7AFE) ;; <CJK>
     (?$(DQs(B . ?\x7B07) ;; <CJK>
     (?$(DQt(B . ?\x7B14) ;; <CJK>
     (?$(DQu(B . ?\x7B1F) ;; <CJK>
     (?$(DQv(B . ?\x7B23) ;; <CJK>
     (?$(DQw(B . ?\x7B27) ;; <CJK>
     (?$(DQx(B . ?\x7B29) ;; <CJK>
     (?$(DQy(B . ?\x7B2A) ;; <CJK>
     (?$(DQz(B . ?\x7B2B) ;; <CJK>
     (?$(DQ{(B . ?\x7B2D) ;; <CJK>
     (?$(DQ|(B . ?\x7B2E) ;; <CJK>
     (?$(DQ}(B . ?\x7B2F) ;; <CJK>
     (?$(DQ~(B . ?\x7B30) ;; <CJK>
     (?$(DR!(B . ?\x7B31) ;; <CJK>
     (?$(DR"(B . ?\x7B34) ;; <CJK>
     (?$(DR#(B . ?\x7B3D) ;; <CJK>
     (?$(DR$(B . ?\x7B3F) ;; <CJK>
     (?$(DR%(B . ?\x7B40) ;; <CJK>
     (?$(DR&(B . ?\x7B41) ;; <CJK>
     (?$(DR'(B . ?\x7B47) ;; <CJK>
     (?$(DR((B . ?\x7B4E) ;; <CJK>
     (?$(DR)(B . ?\x7B55) ;; <CJK>
     (?$(DR*(B . ?\x7B60) ;; <CJK>
     (?$(DR+(B . ?\x7B64) ;; <CJK>
     (?$(DR,(B . ?\x7B66) ;; <CJK>
     (?$(DR-(B . ?\x7B69) ;; <CJK>
     (?$(DR.(B . ?\x7B6A) ;; <CJK>
     (?$(DR/(B . ?\x7B6D) ;; <CJK>
     (?$(DR0(B . ?\x7B6F) ;; <CJK>
     (?$(DR1(B . ?\x7B72) ;; <CJK>
     (?$(DR2(B . ?\x7B73) ;; <CJK>
     (?$(DR3(B . ?\x7B77) ;; <CJK>
     (?$(DR4(B . ?\x7B84) ;; <CJK>
     (?$(DR5(B . ?\x7B89) ;; <CJK>
     (?$(DR6(B . ?\x7B8E) ;; <CJK>
     (?$(DR7(B . ?\x7B90) ;; <CJK>
     (?$(DR8(B . ?\x7B91) ;; <CJK>
     (?$(DR9(B . ?\x7B96) ;; <CJK>
     (?$(DR:(B . ?\x7B9B) ;; <CJK>
     (?$(DR;(B . ?\x7B9E) ;; <CJK>
     (?$(DR<(B . ?\x7BA0) ;; <CJK>
     (?$(DR=(B . ?\x7BA5) ;; <CJK>
     (?$(DR>(B . ?\x7BAC) ;; <CJK>
     (?$(DR?(B . ?\x7BAF) ;; <CJK>
     (?$(DR@(B . ?\x7BB0) ;; <CJK>
     (?$(DRA(B . ?\x7BB2) ;; <CJK>
     (?$(DRB(B . ?\x7BB5) ;; <CJK>
     (?$(DRC(B . ?\x7BB6) ;; <CJK>
     (?$(DRD(B . ?\x7BBA) ;; <CJK>
     (?$(DRE(B . ?\x7BBB) ;; <CJK>
     (?$(DRF(B . ?\x7BBC) ;; <CJK>
     (?$(DRG(B . ?\x7BBD) ;; <CJK>
     (?$(DRH(B . ?\x7BC2) ;; <CJK>
     (?$(DRI(B . ?\x7BC5) ;; <CJK>
     (?$(DRJ(B . ?\x7BC8) ;; <CJK>
     (?$(DRK(B . ?\x7BCA) ;; <CJK>
     (?$(DRL(B . ?\x7BD4) ;; <CJK>
     (?$(DRM(B . ?\x7BD6) ;; <CJK>
     (?$(DRN(B . ?\x7BD7) ;; <CJK>
     (?$(DRO(B . ?\x7BD9) ;; <CJK>
     (?$(DRP(B . ?\x7BDA) ;; <CJK>
     (?$(DRQ(B . ?\x7BDB) ;; <CJK>
     (?$(DRR(B . ?\x7BE8) ;; <CJK>
     (?$(DRS(B . ?\x7BEA) ;; <CJK>
     (?$(DRT(B . ?\x7BF2) ;; <CJK>
     (?$(DRU(B . ?\x7BF4) ;; <CJK>
     (?$(DRV(B . ?\x7BF5) ;; <CJK>
     (?$(DRW(B . ?\x7BF8) ;; <CJK>
     (?$(DRX(B . ?\x7BF9) ;; <CJK>
     (?$(DRY(B . ?\x7BFA) ;; <CJK>
     (?$(DRZ(B . ?\x7BFC) ;; <CJK>
     (?$(DR[(B . ?\x7BFE) ;; <CJK>
     (?$(DR\(B . ?\x7C01) ;; <CJK>
     (?$(DR](B . ?\x7C02) ;; <CJK>
     (?$(DR^(B . ?\x7C03) ;; <CJK>
     (?$(DR_(B . ?\x7C04) ;; <CJK>
     (?$(DR`(B . ?\x7C06) ;; <CJK>
     (?$(DRa(B . ?\x7C09) ;; <CJK>
     (?$(DRb(B . ?\x7C0B) ;; <CJK>
     (?$(DRc(B . ?\x7C0C) ;; <CJK>
     (?$(DRd(B . ?\x7C0E) ;; <CJK>
     (?$(DRe(B . ?\x7C0F) ;; <CJK>
     (?$(DRf(B . ?\x7C19) ;; <CJK>
     (?$(DRg(B . ?\x7C1B) ;; <CJK>
     (?$(DRh(B . ?\x7C20) ;; <CJK>
     (?$(DRi(B . ?\x7C25) ;; <CJK>
     (?$(DRj(B . ?\x7C26) ;; <CJK>
     (?$(DRk(B . ?\x7C28) ;; <CJK>
     (?$(DRl(B . ?\x7C2C) ;; <CJK>
     (?$(DRm(B . ?\x7C31) ;; <CJK>
     (?$(DRn(B . ?\x7C33) ;; <CJK>
     (?$(DRo(B . ?\x7C34) ;; <CJK>
     (?$(DRp(B . ?\x7C36) ;; <CJK>
     (?$(DRq(B . ?\x7C39) ;; <CJK>
     (?$(DRr(B . ?\x7C3A) ;; <CJK>
     (?$(DRs(B . ?\x7C46) ;; <CJK>
     (?$(DRt(B . ?\x7C4A) ;; <CJK>
     (?$(DRu(B . ?\x7C55) ;; <CJK>
     (?$(DRv(B . ?\x7C51) ;; <CJK>
     (?$(DRw(B . ?\x7C52) ;; <CJK>
     (?$(DRx(B . ?\x7C53) ;; <CJK>
     (?$(DRy(B . ?\x7C59) ;; <CJK>
     (?$(DRz(B . ?\x7C5A) ;; <CJK>
     (?$(DR{(B . ?\x7C5B) ;; <CJK>
     (?$(DR|(B . ?\x7C5C) ;; <CJK>
     (?$(DR}(B . ?\x7C5D) ;; <CJK>
     (?$(DR~(B . ?\x7C5E) ;; <CJK>
     (?$(DS!(B . ?\x7C61) ;; <CJK>
     (?$(DS"(B . ?\x7C63) ;; <CJK>
     (?$(DS#(B . ?\x7C67) ;; <CJK>
     (?$(DS$(B . ?\x7C69) ;; <CJK>
     (?$(DS%(B . ?\x7C6D) ;; <CJK>
     (?$(DS&(B . ?\x7C6E) ;; <CJK>
     (?$(DS'(B . ?\x7C70) ;; <CJK>
     (?$(DS((B . ?\x7C72) ;; <CJK>
     (?$(DS)(B . ?\x7C79) ;; <CJK>
     (?$(DS*(B . ?\x7C7C) ;; <CJK>
     (?$(DS+(B . ?\x7C7D) ;; <CJK>
     (?$(DS,(B . ?\x7C86) ;; <CJK>
     (?$(DS-(B . ?\x7C87) ;; <CJK>
     (?$(DS.(B . ?\x7C8F) ;; <CJK>
     (?$(DS/(B . ?\x7C94) ;; <CJK>
     (?$(DS0(B . ?\x7C9E) ;; <CJK>
     (?$(DS1(B . ?\x7CA0) ;; <CJK>
     (?$(DS2(B . ?\x7CA6) ;; <CJK>
     (?$(DS3(B . ?\x7CB0) ;; <CJK>
     (?$(DS4(B . ?\x7CB6) ;; <CJK>
     (?$(DS5(B . ?\x7CB7) ;; <CJK>
     (?$(DS6(B . ?\x7CBA) ;; <CJK>
     (?$(DS7(B . ?\x7CBB) ;; <CJK>
     (?$(DS8(B . ?\x7CBC) ;; <CJK>
     (?$(DS9(B . ?\x7CBF) ;; <CJK>
     (?$(DS:(B . ?\x7CC4) ;; <CJK>
     (?$(DS;(B . ?\x7CC7) ;; <CJK>
     (?$(DS<(B . ?\x7CC8) ;; <CJK>
     (?$(DS=(B . ?\x7CC9) ;; <CJK>
     (?$(DS>(B . ?\x7CCD) ;; <CJK>
     (?$(DS?(B . ?\x7CCF) ;; <CJK>
     (?$(DS@(B . ?\x7CD3) ;; <CJK>
     (?$(DSA(B . ?\x7CD4) ;; <CJK>
     (?$(DSB(B . ?\x7CD5) ;; <CJK>
     (?$(DSC(B . ?\x7CD7) ;; <CJK>
     (?$(DSD(B . ?\x7CD9) ;; <CJK>
     (?$(DSE(B . ?\x7CDA) ;; <CJK>
     (?$(DSF(B . ?\x7CDD) ;; <CJK>
     (?$(DSG(B . ?\x7CE6) ;; <CJK>
     (?$(DSH(B . ?\x7CE9) ;; <CJK>
     (?$(DSI(B . ?\x7CEB) ;; <CJK>
     (?$(DSJ(B . ?\x7CF5) ;; <CJK>
     (?$(DSK(B . ?\x7D03) ;; <CJK>
     (?$(DSL(B . ?\x7D07) ;; <CJK>
     (?$(DSM(B . ?\x7D08) ;; <CJK>
     (?$(DSN(B . ?\x7D09) ;; <CJK>
     (?$(DSO(B . ?\x7D0F) ;; <CJK>
     (?$(DSP(B . ?\x7D11) ;; <CJK>
     (?$(DSQ(B . ?\x7D12) ;; <CJK>
     (?$(DSR(B . ?\x7D13) ;; <CJK>
     (?$(DSS(B . ?\x7D16) ;; <CJK>
     (?$(DST(B . ?\x7D1D) ;; <CJK>
     (?$(DSU(B . ?\x7D1E) ;; <CJK>
     (?$(DSV(B . ?\x7D23) ;; <CJK>
     (?$(DSW(B . ?\x7D26) ;; <CJK>
     (?$(DSX(B . ?\x7D2A) ;; <CJK>
     (?$(DSY(B . ?\x7D2D) ;; <CJK>
     (?$(DSZ(B . ?\x7D31) ;; <CJK>
     (?$(DS[(B . ?\x7D3C) ;; <CJK>
     (?$(DS\(B . ?\x7D3D) ;; <CJK>
     (?$(DS](B . ?\x7D3E) ;; <CJK>
     (?$(DS^(B . ?\x7D40) ;; <CJK>
     (?$(DS_(B . ?\x7D41) ;; <CJK>
     (?$(DS`(B . ?\x7D47) ;; <CJK>
     (?$(DSa(B . ?\x7D48) ;; <CJK>
     (?$(DSb(B . ?\x7D4D) ;; <CJK>
     (?$(DSc(B . ?\x7D51) ;; <CJK>
     (?$(DSd(B . ?\x7D53) ;; <CJK>
     (?$(DSe(B . ?\x7D57) ;; <CJK>
     (?$(DSf(B . ?\x7D59) ;; <CJK>
     (?$(DSg(B . ?\x7D5A) ;; <CJK>
     (?$(DSh(B . ?\x7D5C) ;; <CJK>
     (?$(DSi(B . ?\x7D5D) ;; <CJK>
     (?$(DSj(B . ?\x7D65) ;; <CJK>
     (?$(DSk(B . ?\x7D67) ;; <CJK>
     (?$(DSl(B . ?\x7D6A) ;; <CJK>
     (?$(DSm(B . ?\x7D70) ;; <CJK>
     (?$(DSn(B . ?\x7D78) ;; <CJK>
     (?$(DSo(B . ?\x7D7A) ;; <CJK>
     (?$(DSp(B . ?\x7D7B) ;; <CJK>
     (?$(DSq(B . ?\x7D7F) ;; <CJK>
     (?$(DSr(B . ?\x7D81) ;; <CJK>
     (?$(DSs(B . ?\x7D82) ;; <CJK>
     (?$(DSt(B . ?\x7D83) ;; <CJK>
     (?$(DSu(B . ?\x7D85) ;; <CJK>
     (?$(DSv(B . ?\x7D86) ;; <CJK>
     (?$(DSw(B . ?\x7D88) ;; <CJK>
     (?$(DSx(B . ?\x7D8B) ;; <CJK>
     (?$(DSy(B . ?\x7D8C) ;; <CJK>
     (?$(DSz(B . ?\x7D8D) ;; <CJK>
     (?$(DS{(B . ?\x7D91) ;; <CJK>
     (?$(DS|(B . ?\x7D96) ;; <CJK>
     (?$(DS}(B . ?\x7D97) ;; <CJK>
     (?$(DS~(B . ?\x7D9D) ;; <CJK>
     (?$(DT!(B . ?\x7D9E) ;; <CJK>
     (?$(DT"(B . ?\x7DA6) ;; <CJK>
     (?$(DT#(B . ?\x7DA7) ;; <CJK>
     (?$(DT$(B . ?\x7DAA) ;; <CJK>
     (?$(DT%(B . ?\x7DB3) ;; <CJK>
     (?$(DT&(B . ?\x7DB6) ;; <CJK>
     (?$(DT'(B . ?\x7DB7) ;; <CJK>
     (?$(DT((B . ?\x7DB9) ;; <CJK>
     (?$(DT)(B . ?\x7DC2) ;; <CJK>
     (?$(DT*(B . ?\x7DC3) ;; <CJK>
     (?$(DT+(B . ?\x7DC4) ;; <CJK>
     (?$(DT,(B . ?\x7DC5) ;; <CJK>
     (?$(DT-(B . ?\x7DC6) ;; <CJK>
     (?$(DT.(B . ?\x7DCC) ;; <CJK>
     (?$(DT/(B . ?\x7DCD) ;; <CJK>
     (?$(DT0(B . ?\x7DCE) ;; <CJK>
     (?$(DT1(B . ?\x7DD7) ;; <CJK>
     (?$(DT2(B . ?\x7DD9) ;; <CJK>
     (?$(DT3(B . ?\x7E00) ;; <CJK>
     (?$(DT4(B . ?\x7DE2) ;; <CJK>
     (?$(DT5(B . ?\x7DE5) ;; <CJK>
     (?$(DT6(B . ?\x7DE6) ;; <CJK>
     (?$(DT7(B . ?\x7DEA) ;; <CJK>
     (?$(DT8(B . ?\x7DEB) ;; <CJK>
     (?$(DT9(B . ?\x7DED) ;; <CJK>
     (?$(DT:(B . ?\x7DF1) ;; <CJK>
     (?$(DT;(B . ?\x7DF5) ;; <CJK>
     (?$(DT<(B . ?\x7DF6) ;; <CJK>
     (?$(DT=(B . ?\x7DF9) ;; <CJK>
     (?$(DT>(B . ?\x7DFA) ;; <CJK>
     (?$(DT?(B . ?\x7E08) ;; <CJK>
     (?$(DT@(B . ?\x7E10) ;; <CJK>
     (?$(DTA(B . ?\x7E11) ;; <CJK>
     (?$(DTB(B . ?\x7E15) ;; <CJK>
     (?$(DTC(B . ?\x7E17) ;; <CJK>
     (?$(DTD(B . ?\x7E1C) ;; <CJK>
     (?$(DTE(B . ?\x7E1D) ;; <CJK>
     (?$(DTF(B . ?\x7E20) ;; <CJK>
     (?$(DTG(B . ?\x7E27) ;; <CJK>
     (?$(DTH(B . ?\x7E28) ;; <CJK>
     (?$(DTI(B . ?\x7E2C) ;; <CJK>
     (?$(DTJ(B . ?\x7E2D) ;; <CJK>
     (?$(DTK(B . ?\x7E2F) ;; <CJK>
     (?$(DTL(B . ?\x7E33) ;; <CJK>
     (?$(DTM(B . ?\x7E36) ;; <CJK>
     (?$(DTN(B . ?\x7E3F) ;; <CJK>
     (?$(DTO(B . ?\x7E44) ;; <CJK>
     (?$(DTP(B . ?\x7E45) ;; <CJK>
     (?$(DTQ(B . ?\x7E47) ;; <CJK>
     (?$(DTR(B . ?\x7E4E) ;; <CJK>
     (?$(DTS(B . ?\x7E50) ;; <CJK>
     (?$(DTT(B . ?\x7E52) ;; <CJK>
     (?$(DTU(B . ?\x7E58) ;; <CJK>
     (?$(DTV(B . ?\x7E5F) ;; <CJK>
     (?$(DTW(B . ?\x7E61) ;; <CJK>
     (?$(DTX(B . ?\x7E62) ;; <CJK>
     (?$(DTY(B . ?\x7E65) ;; <CJK>
     (?$(DTZ(B . ?\x7E6B) ;; <CJK>
     (?$(DT[(B . ?\x7E6E) ;; <CJK>
     (?$(DT\(B . ?\x7E6F) ;; <CJK>
     (?$(DT](B . ?\x7E73) ;; <CJK>
     (?$(DT^(B . ?\x7E78) ;; <CJK>
     (?$(DT_(B . ?\x7E7E) ;; <CJK>
     (?$(DT`(B . ?\x7E81) ;; <CJK>
     (?$(DTa(B . ?\x7E86) ;; <CJK>
     (?$(DTb(B . ?\x7E87) ;; <CJK>
     (?$(DTc(B . ?\x7E8A) ;; <CJK>
     (?$(DTd(B . ?\x7E8D) ;; <CJK>
     (?$(DTe(B . ?\x7E91) ;; <CJK>
     (?$(DTf(B . ?\x7E95) ;; <CJK>
     (?$(DTg(B . ?\x7E98) ;; <CJK>
     (?$(DTh(B . ?\x7E9A) ;; <CJK>
     (?$(DTi(B . ?\x7E9D) ;; <CJK>
     (?$(DTj(B . ?\x7E9E) ;; <CJK>
     (?$(DTk(B . ?\x7F3C) ;; <CJK>
     (?$(DTl(B . ?\x7F3B) ;; <CJK>
     (?$(DTm(B . ?\x7F3D) ;; <CJK>
     (?$(DTn(B . ?\x7F3E) ;; <CJK>
     (?$(DTo(B . ?\x7F3F) ;; <CJK>
     (?$(DTp(B . ?\x7F43) ;; <CJK>
     (?$(DTq(B . ?\x7F44) ;; <CJK>
     (?$(DTr(B . ?\x7F47) ;; <CJK>
     (?$(DTs(B . ?\x7F4F) ;; <CJK>
     (?$(DTt(B . ?\x7F52) ;; <CJK>
     (?$(DTu(B . ?\x7F53) ;; <CJK>
     (?$(DTv(B . ?\x7F5B) ;; <CJK>
     (?$(DTw(B . ?\x7F5C) ;; <CJK>
     (?$(DTx(B . ?\x7F5D) ;; <CJK>
     (?$(DTy(B . ?\x7F61) ;; <CJK>
     (?$(DTz(B . ?\x7F63) ;; <CJK>
     (?$(DT{(B . ?\x7F64) ;; <CJK>
     (?$(DT|(B . ?\x7F65) ;; <CJK>
     (?$(DT}(B . ?\x7F66) ;; <CJK>
     (?$(DT~(B . ?\x7F6D) ;; <CJK>
     (?$(DU!(B . ?\x7F71) ;; <CJK>
     (?$(DU"(B . ?\x7F7D) ;; <CJK>
     (?$(DU#(B . ?\x7F7E) ;; <CJK>
     (?$(DU$(B . ?\x7F7F) ;; <CJK>
     (?$(DU%(B . ?\x7F80) ;; <CJK>
     (?$(DU&(B . ?\x7F8B) ;; <CJK>
     (?$(DU'(B . ?\x7F8D) ;; <CJK>
     (?$(DU((B . ?\x7F8F) ;; <CJK>
     (?$(DU)(B . ?\x7F90) ;; <CJK>
     (?$(DU*(B . ?\x7F91) ;; <CJK>
     (?$(DU+(B . ?\x7F96) ;; <CJK>
     (?$(DU,(B . ?\x7F97) ;; <CJK>
     (?$(DU-(B . ?\x7F9C) ;; <CJK>
     (?$(DU.(B . ?\x7FA1) ;; <CJK>
     (?$(DU/(B . ?\x7FA2) ;; <CJK>
     (?$(DU0(B . ?\x7FA6) ;; <CJK>
     (?$(DU1(B . ?\x7FAA) ;; <CJK>
     (?$(DU2(B . ?\x7FAD) ;; <CJK>
     (?$(DU3(B . ?\x7FB4) ;; <CJK>
     (?$(DU4(B . ?\x7FBC) ;; <CJK>
     (?$(DU5(B . ?\x7FBF) ;; <CJK>
     (?$(DU6(B . ?\x7FC0) ;; <CJK>
     (?$(DU7(B . ?\x7FC3) ;; <CJK>
     (?$(DU8(B . ?\x7FC8) ;; <CJK>
     (?$(DU9(B . ?\x7FCE) ;; <CJK>
     (?$(DU:(B . ?\x7FCF) ;; <CJK>
     (?$(DU;(B . ?\x7FDB) ;; <CJK>
     (?$(DU<(B . ?\x7FDF) ;; <CJK>
     (?$(DU=(B . ?\x7FE3) ;; <CJK>
     (?$(DU>(B . ?\x7FE5) ;; <CJK>
     (?$(DU?(B . ?\x7FE8) ;; <CJK>
     (?$(DU@(B . ?\x7FEC) ;; <CJK>
     (?$(DUA(B . ?\x7FEE) ;; <CJK>
     (?$(DUB(B . ?\x7FEF) ;; <CJK>
     (?$(DUC(B . ?\x7FF2) ;; <CJK>
     (?$(DUD(B . ?\x7FFA) ;; <CJK>
     (?$(DUE(B . ?\x7FFD) ;; <CJK>
     (?$(DUF(B . ?\x7FFE) ;; <CJK>
     (?$(DUG(B . ?\x7FFF) ;; <CJK>
     (?$(DUH(B . ?\x8007) ;; <CJK>
     (?$(DUI(B . ?\x8008) ;; <CJK>
     (?$(DUJ(B . ?\x800A) ;; <CJK>
     (?$(DUK(B . ?\x800D) ;; <CJK>
     (?$(DUL(B . ?\x800E) ;; <CJK>
     (?$(DUM(B . ?\x800F) ;; <CJK>
     (?$(DUN(B . ?\x8011) ;; <CJK>
     (?$(DUO(B . ?\x8013) ;; <CJK>
     (?$(DUP(B . ?\x8014) ;; <CJK>
     (?$(DUQ(B . ?\x8016) ;; <CJK>
     (?$(DUR(B . ?\x801D) ;; <CJK>
     (?$(DUS(B . ?\x801E) ;; <CJK>
     (?$(DUT(B . ?\x801F) ;; <CJK>
     (?$(DUU(B . ?\x8020) ;; <CJK>
     (?$(DUV(B . ?\x8024) ;; <CJK>
     (?$(DUW(B . ?\x8026) ;; <CJK>
     (?$(DUX(B . ?\x802C) ;; <CJK>
     (?$(DUY(B . ?\x802E) ;; <CJK>
     (?$(DUZ(B . ?\x8030) ;; <CJK>
     (?$(DU[(B . ?\x8034) ;; <CJK>
     (?$(DU\(B . ?\x8035) ;; <CJK>
     (?$(DU](B . ?\x8037) ;; <CJK>
     (?$(DU^(B . ?\x8039) ;; <CJK>
     (?$(DU_(B . ?\x803A) ;; <CJK>
     (?$(DU`(B . ?\x803C) ;; <CJK>
     (?$(DUa(B . ?\x803E) ;; <CJK>
     (?$(DUb(B . ?\x8040) ;; <CJK>
     (?$(DUc(B . ?\x8044) ;; <CJK>
     (?$(DUd(B . ?\x8060) ;; <CJK>
     (?$(DUe(B . ?\x8064) ;; <CJK>
     (?$(DUf(B . ?\x8066) ;; <CJK>
     (?$(DUg(B . ?\x806D) ;; <CJK>
     (?$(DUh(B . ?\x8071) ;; <CJK>
     (?$(DUi(B . ?\x8075) ;; <CJK>
     (?$(DUj(B . ?\x8081) ;; <CJK>
     (?$(DUk(B . ?\x8088) ;; <CJK>
     (?$(DUl(B . ?\x808E) ;; <CJK>
     (?$(DUm(B . ?\x809C) ;; <CJK>
     (?$(DUn(B . ?\x809E) ;; <CJK>
     (?$(DUo(B . ?\x80A6) ;; <CJK>
     (?$(DUp(B . ?\x80A7) ;; <CJK>
     (?$(DUq(B . ?\x80AB) ;; <CJK>
     (?$(DUr(B . ?\x80B8) ;; <CJK>
     (?$(DUs(B . ?\x80B9) ;; <CJK>
     (?$(DUt(B . ?\x80C8) ;; <CJK>
     (?$(DUu(B . ?\x80CD) ;; <CJK>
     (?$(DUv(B . ?\x80CF) ;; <CJK>
     (?$(DUw(B . ?\x80D2) ;; <CJK>
     (?$(DUx(B . ?\x80D4) ;; <CJK>
     (?$(DUy(B . ?\x80D5) ;; <CJK>
     (?$(DUz(B . ?\x80D7) ;; <CJK>
     (?$(DU{(B . ?\x80D8) ;; <CJK>
     (?$(DU|(B . ?\x80E0) ;; <CJK>
     (?$(DU}(B . ?\x80ED) ;; <CJK>
     (?$(DU~(B . ?\x80EE) ;; <CJK>
     (?$(DV!(B . ?\x80F0) ;; <CJK>
     (?$(DV"(B . ?\x80F2) ;; <CJK>
     (?$(DV#(B . ?\x80F3) ;; <CJK>
     (?$(DV$(B . ?\x80F6) ;; <CJK>
     (?$(DV%(B . ?\x80F9) ;; <CJK>
     (?$(DV&(B . ?\x80FA) ;; <CJK>
     (?$(DV'(B . ?\x80FE) ;; <CJK>
     (?$(DV((B . ?\x8103) ;; <CJK>
     (?$(DV)(B . ?\x810B) ;; <CJK>
     (?$(DV*(B . ?\x8116) ;; <CJK>
     (?$(DV+(B . ?\x8117) ;; <CJK>
     (?$(DV,(B . ?\x8118) ;; <CJK>
     (?$(DV-(B . ?\x811C) ;; <CJK>
     (?$(DV.(B . ?\x811E) ;; <CJK>
     (?$(DV/(B . ?\x8120) ;; <CJK>
     (?$(DV0(B . ?\x8124) ;; <CJK>
     (?$(DV1(B . ?\x8127) ;; <CJK>
     (?$(DV2(B . ?\x812C) ;; <CJK>
     (?$(DV3(B . ?\x8130) ;; <CJK>
     (?$(DV4(B . ?\x8135) ;; <CJK>
     (?$(DV5(B . ?\x813A) ;; <CJK>
     (?$(DV6(B . ?\x813C) ;; <CJK>
     (?$(DV7(B . ?\x8145) ;; <CJK>
     (?$(DV8(B . ?\x8147) ;; <CJK>
     (?$(DV9(B . ?\x814A) ;; <CJK>
     (?$(DV:(B . ?\x814C) ;; <CJK>
     (?$(DV;(B . ?\x8152) ;; <CJK>
     (?$(DV<(B . ?\x8157) ;; <CJK>
     (?$(DV=(B . ?\x8160) ;; <CJK>
     (?$(DV>(B . ?\x8161) ;; <CJK>
     (?$(DV?(B . ?\x8167) ;; <CJK>
     (?$(DV@(B . ?\x8168) ;; <CJK>
     (?$(DVA(B . ?\x8169) ;; <CJK>
     (?$(DVB(B . ?\x816D) ;; <CJK>
     (?$(DVC(B . ?\x816F) ;; <CJK>
     (?$(DVD(B . ?\x8177) ;; <CJK>
     (?$(DVE(B . ?\x8181) ;; <CJK>
     (?$(DVF(B . ?\x8190) ;; <CJK>
     (?$(DVG(B . ?\x8184) ;; <CJK>
     (?$(DVH(B . ?\x8185) ;; <CJK>
     (?$(DVI(B . ?\x8186) ;; <CJK>
     (?$(DVJ(B . ?\x818B) ;; <CJK>
     (?$(DVK(B . ?\x818E) ;; <CJK>
     (?$(DVL(B . ?\x8196) ;; <CJK>
     (?$(DVM(B . ?\x8198) ;; <CJK>
     (?$(DVN(B . ?\x819B) ;; <CJK>
     (?$(DVO(B . ?\x819E) ;; <CJK>
     (?$(DVP(B . ?\x81A2) ;; <CJK>
     (?$(DVQ(B . ?\x81AE) ;; <CJK>
     (?$(DVR(B . ?\x81B2) ;; <CJK>
     (?$(DVS(B . ?\x81B4) ;; <CJK>
     (?$(DVT(B . ?\x81BB) ;; <CJK>
     (?$(DVU(B . ?\x81CB) ;; <CJK>
     (?$(DVV(B . ?\x81C3) ;; <CJK>
     (?$(DVW(B . ?\x81C5) ;; <CJK>
     (?$(DVX(B . ?\x81CA) ;; <CJK>
     (?$(DVY(B . ?\x81CE) ;; <CJK>
     (?$(DVZ(B . ?\x81CF) ;; <CJK>
     (?$(DV[(B . ?\x81D5) ;; <CJK>
     (?$(DV\(B . ?\x81D7) ;; <CJK>
     (?$(DV](B . ?\x81DB) ;; <CJK>
     (?$(DV^(B . ?\x81DD) ;; <CJK>
     (?$(DV_(B . ?\x81DE) ;; <CJK>
     (?$(DV`(B . ?\x81E1) ;; <CJK>
     (?$(DVa(B . ?\x81E4) ;; <CJK>
     (?$(DVb(B . ?\x81EB) ;; <CJK>
     (?$(DVc(B . ?\x81EC) ;; <CJK>
     (?$(DVd(B . ?\x81F0) ;; <CJK>
     (?$(DVe(B . ?\x81F1) ;; <CJK>
     (?$(DVf(B . ?\x81F2) ;; <CJK>
     (?$(DVg(B . ?\x81F5) ;; <CJK>
     (?$(DVh(B . ?\x81F6) ;; <CJK>
     (?$(DVi(B . ?\x81F8) ;; <CJK>
     (?$(DVj(B . ?\x81F9) ;; <CJK>
     (?$(DVk(B . ?\x81FD) ;; <CJK>
     (?$(DVl(B . ?\x81FF) ;; <CJK>
     (?$(DVm(B . ?\x8200) ;; <CJK>
     (?$(DVn(B . ?\x8203) ;; <CJK>
     (?$(DVo(B . ?\x820F) ;; <CJK>
     (?$(DVp(B . ?\x8213) ;; <CJK>
     (?$(DVq(B . ?\x8214) ;; <CJK>
     (?$(DVr(B . ?\x8219) ;; <CJK>
     (?$(DVs(B . ?\x821A) ;; <CJK>
     (?$(DVt(B . ?\x821D) ;; <CJK>
     (?$(DVu(B . ?\x8221) ;; <CJK>
     (?$(DVv(B . ?\x8222) ;; <CJK>
     (?$(DVw(B . ?\x8228) ;; <CJK>
     (?$(DVx(B . ?\x8232) ;; <CJK>
     (?$(DVy(B . ?\x8234) ;; <CJK>
     (?$(DVz(B . ?\x823A) ;; <CJK>
     (?$(DV{(B . ?\x8243) ;; <CJK>
     (?$(DV|(B . ?\x8244) ;; <CJK>
     (?$(DV}(B . ?\x8245) ;; <CJK>
     (?$(DV~(B . ?\x8246) ;; <CJK>
     (?$(DW!(B . ?\x824B) ;; <CJK>
     (?$(DW"(B . ?\x824E) ;; <CJK>
     (?$(DW#(B . ?\x824F) ;; <CJK>
     (?$(DW$(B . ?\x8251) ;; <CJK>
     (?$(DW%(B . ?\x8256) ;; <CJK>
     (?$(DW&(B . ?\x825C) ;; <CJK>
     (?$(DW'(B . ?\x8260) ;; <CJK>
     (?$(DW((B . ?\x8263) ;; <CJK>
     (?$(DW)(B . ?\x8267) ;; <CJK>
     (?$(DW*(B . ?\x826D) ;; <CJK>
     (?$(DW+(B . ?\x8274) ;; <CJK>
     (?$(DW,(B . ?\x827B) ;; <CJK>
     (?$(DW-(B . ?\x827D) ;; <CJK>
     (?$(DW.(B . ?\x827F) ;; <CJK>
     (?$(DW/(B . ?\x8280) ;; <CJK>
     (?$(DW0(B . ?\x8281) ;; <CJK>
     (?$(DW1(B . ?\x8283) ;; <CJK>
     (?$(DW2(B . ?\x8284) ;; <CJK>
     (?$(DW3(B . ?\x8287) ;; <CJK>
     (?$(DW4(B . ?\x8289) ;; <CJK>
     (?$(DW5(B . ?\x828A) ;; <CJK>
     (?$(DW6(B . ?\x828E) ;; <CJK>
     (?$(DW7(B . ?\x8291) ;; <CJK>
     (?$(DW8(B . ?\x8294) ;; <CJK>
     (?$(DW9(B . ?\x8296) ;; <CJK>
     (?$(DW:(B . ?\x8298) ;; <CJK>
     (?$(DW;(B . ?\x829A) ;; <CJK>
     (?$(DW<(B . ?\x829B) ;; <CJK>
     (?$(DW=(B . ?\x82A0) ;; <CJK>
     (?$(DW>(B . ?\x82A1) ;; <CJK>
     (?$(DW?(B . ?\x82A3) ;; <CJK>
     (?$(DW@(B . ?\x82A4) ;; <CJK>
     (?$(DWA(B . ?\x82A7) ;; <CJK>
     (?$(DWB(B . ?\x82A8) ;; <CJK>
     (?$(DWC(B . ?\x82A9) ;; <CJK>
     (?$(DWD(B . ?\x82AA) ;; <CJK>
     (?$(DWE(B . ?\x82AE) ;; <CJK>
     (?$(DWF(B . ?\x82B0) ;; <CJK>
     (?$(DWG(B . ?\x82B2) ;; <CJK>
     (?$(DWH(B . ?\x82B4) ;; <CJK>
     (?$(DWI(B . ?\x82B7) ;; <CJK>
     (?$(DWJ(B . ?\x82BA) ;; <CJK>
     (?$(DWK(B . ?\x82BC) ;; <CJK>
     (?$(DWL(B . ?\x82BE) ;; <CJK>
     (?$(DWM(B . ?\x82BF) ;; <CJK>
     (?$(DWN(B . ?\x82C6) ;; <CJK>
     (?$(DWO(B . ?\x82D0) ;; <CJK>
     (?$(DWP(B . ?\x82D5) ;; <CJK>
     (?$(DWQ(B . ?\x82DA) ;; <CJK>
     (?$(DWR(B . ?\x82E0) ;; <CJK>
     (?$(DWS(B . ?\x82E2) ;; <CJK>
     (?$(DWT(B . ?\x82E4) ;; <CJK>
     (?$(DWU(B . ?\x82E8) ;; <CJK>
     (?$(DWV(B . ?\x82EA) ;; <CJK>
     (?$(DWW(B . ?\x82ED) ;; <CJK>
     (?$(DWX(B . ?\x82EF) ;; <CJK>
     (?$(DWY(B . ?\x82F6) ;; <CJK>
     (?$(DWZ(B . ?\x82F7) ;; <CJK>
     (?$(DW[(B . ?\x82FD) ;; <CJK>
     (?$(DW\(B . ?\x82FE) ;; <CJK>
     (?$(DW](B . ?\x8300) ;; <CJK>
     (?$(DW^(B . ?\x8301) ;; <CJK>
     (?$(DW_(B . ?\x8307) ;; <CJK>
     (?$(DW`(B . ?\x8308) ;; <CJK>
     (?$(DWa(B . ?\x830A) ;; <CJK>
     (?$(DWb(B . ?\x830B) ;; <CJK>
     (?$(DWc(B . ?\x8354) ;; <CJK>
     (?$(DWd(B . ?\x831B) ;; <CJK>
     (?$(DWe(B . ?\x831D) ;; <CJK>
     (?$(DWf(B . ?\x831E) ;; <CJK>
     (?$(DWg(B . ?\x831F) ;; <CJK>
     (?$(DWh(B . ?\x8321) ;; <CJK>
     (?$(DWi(B . ?\x8322) ;; <CJK>
     (?$(DWj(B . ?\x832C) ;; <CJK>
     (?$(DWk(B . ?\x832D) ;; <CJK>
     (?$(DWl(B . ?\x832E) ;; <CJK>
     (?$(DWm(B . ?\x8330) ;; <CJK>
     (?$(DWn(B . ?\x8333) ;; <CJK>
     (?$(DWo(B . ?\x8337) ;; <CJK>
     (?$(DWp(B . ?\x833A) ;; <CJK>
     (?$(DWq(B . ?\x833C) ;; <CJK>
     (?$(DWr(B . ?\x833D) ;; <CJK>
     (?$(DWs(B . ?\x8342) ;; <CJK>
     (?$(DWt(B . ?\x8343) ;; <CJK>
     (?$(DWu(B . ?\x8344) ;; <CJK>
     (?$(DWv(B . ?\x8347) ;; <CJK>
     (?$(DWw(B . ?\x834D) ;; <CJK>
     (?$(DWx(B . ?\x834E) ;; <CJK>
     (?$(DWy(B . ?\x8351) ;; <CJK>
     (?$(DWz(B . ?\x8355) ;; <CJK>
     (?$(DW{(B . ?\x8356) ;; <CJK>
     (?$(DW|(B . ?\x8357) ;; <CJK>
     (?$(DW}(B . ?\x8370) ;; <CJK>
     (?$(DW~(B . ?\x8378) ;; <CJK>
     (?$(DX!(B . ?\x837D) ;; <CJK>
     (?$(DX"(B . ?\x837F) ;; <CJK>
     (?$(DX#(B . ?\x8380) ;; <CJK>
     (?$(DX$(B . ?\x8382) ;; <CJK>
     (?$(DX%(B . ?\x8384) ;; <CJK>
     (?$(DX&(B . ?\x8386) ;; <CJK>
     (?$(DX'(B . ?\x838D) ;; <CJK>
     (?$(DX((B . ?\x8392) ;; <CJK>
     (?$(DX)(B . ?\x8394) ;; <CJK>
     (?$(DX*(B . ?\x8395) ;; <CJK>
     (?$(DX+(B . ?\x8398) ;; <CJK>
     (?$(DX,(B . ?\x8399) ;; <CJK>
     (?$(DX-(B . ?\x839B) ;; <CJK>
     (?$(DX.(B . ?\x839C) ;; <CJK>
     (?$(DX/(B . ?\x839D) ;; <CJK>
     (?$(DX0(B . ?\x83A6) ;; <CJK>
     (?$(DX1(B . ?\x83A7) ;; <CJK>
     (?$(DX2(B . ?\x83A9) ;; <CJK>
     (?$(DX3(B . ?\x83AC) ;; <CJK>
     (?$(DX4(B . ?\x83BE) ;; <CJK>
     (?$(DX5(B . ?\x83BF) ;; <CJK>
     (?$(DX6(B . ?\x83C0) ;; <CJK>
     (?$(DX7(B . ?\x83C7) ;; <CJK>
     (?$(DX8(B . ?\x83C9) ;; <CJK>
     (?$(DX9(B . ?\x83CF) ;; <CJK>
     (?$(DX:(B . ?\x83D0) ;; <CJK>
     (?$(DX;(B . ?\x83D1) ;; <CJK>
     (?$(DX<(B . ?\x83D4) ;; <CJK>
     (?$(DX=(B . ?\x83DD) ;; <CJK>
     (?$(DX>(B . ?\x8353) ;; <CJK>
     (?$(DX?(B . ?\x83E8) ;; <CJK>
     (?$(DX@(B . ?\x83EA) ;; <CJK>
     (?$(DXA(B . ?\x83F6) ;; <CJK>
     (?$(DXB(B . ?\x83F8) ;; <CJK>
     (?$(DXC(B . ?\x83F9) ;; <CJK>
     (?$(DXD(B . ?\x83FC) ;; <CJK>
     (?$(DXE(B . ?\x8401) ;; <CJK>
     (?$(DXF(B . ?\x8406) ;; <CJK>
     (?$(DXG(B . ?\x840A) ;; <CJK>
     (?$(DXH(B . ?\x840F) ;; <CJK>
     (?$(DXI(B . ?\x8411) ;; <CJK>
     (?$(DXJ(B . ?\x8415) ;; <CJK>
     (?$(DXK(B . ?\x8419) ;; <CJK>
     (?$(DXL(B . ?\x83AD) ;; <CJK>
     (?$(DXM(B . ?\x842F) ;; <CJK>
     (?$(DXN(B . ?\x8439) ;; <CJK>
     (?$(DXO(B . ?\x8445) ;; <CJK>
     (?$(DXP(B . ?\x8447) ;; <CJK>
     (?$(DXQ(B . ?\x8448) ;; <CJK>
     (?$(DXR(B . ?\x844A) ;; <CJK>
     (?$(DXS(B . ?\x844D) ;; <CJK>
     (?$(DXT(B . ?\x844F) ;; <CJK>
     (?$(DXU(B . ?\x8451) ;; <CJK>
     (?$(DXV(B . ?\x8452) ;; <CJK>
     (?$(DXW(B . ?\x8456) ;; <CJK>
     (?$(DXX(B . ?\x8458) ;; <CJK>
     (?$(DXY(B . ?\x8459) ;; <CJK>
     (?$(DXZ(B . ?\x845A) ;; <CJK>
     (?$(DX[(B . ?\x845C) ;; <CJK>
     (?$(DX\(B . ?\x8460) ;; <CJK>
     (?$(DX](B . ?\x8464) ;; <CJK>
     (?$(DX^(B . ?\x8465) ;; <CJK>
     (?$(DX_(B . ?\x8467) ;; <CJK>
     (?$(DX`(B . ?\x846A) ;; <CJK>
     (?$(DXa(B . ?\x8470) ;; <CJK>
     (?$(DXb(B . ?\x8473) ;; <CJK>
     (?$(DXc(B . ?\x8474) ;; <CJK>
     (?$(DXd(B . ?\x8476) ;; <CJK>
     (?$(DXe(B . ?\x8478) ;; <CJK>
     (?$(DXf(B . ?\x847C) ;; <CJK>
     (?$(DXg(B . ?\x847D) ;; <CJK>
     (?$(DXh(B . ?\x8481) ;; <CJK>
     (?$(DXi(B . ?\x8485) ;; <CJK>
     (?$(DXj(B . ?\x8492) ;; <CJK>
     (?$(DXk(B . ?\x8493) ;; <CJK>
     (?$(DXl(B . ?\x8495) ;; <CJK>
     (?$(DXm(B . ?\x849E) ;; <CJK>
     (?$(DXn(B . ?\x84A6) ;; <CJK>
     (?$(DXo(B . ?\x84A8) ;; <CJK>
     (?$(DXp(B . ?\x84A9) ;; <CJK>
     (?$(DXq(B . ?\x84AA) ;; <CJK>
     (?$(DXr(B . ?\x84AF) ;; <CJK>
     (?$(DXs(B . ?\x84B1) ;; <CJK>
     (?$(DXt(B . ?\x84B4) ;; <CJK>
     (?$(DXu(B . ?\x84BA) ;; <CJK>
     (?$(DXv(B . ?\x84BD) ;; <CJK>
     (?$(DXw(B . ?\x84BE) ;; <CJK>
     (?$(DXx(B . ?\x84C0) ;; <CJK>
     (?$(DXy(B . ?\x84C2) ;; <CJK>
     (?$(DXz(B . ?\x84C7) ;; <CJK>
     (?$(DX{(B . ?\x84C8) ;; <CJK>
     (?$(DX|(B . ?\x84CC) ;; <CJK>
     (?$(DX}(B . ?\x84CF) ;; <CJK>
     (?$(DX~(B . ?\x84D3) ;; <CJK>
     (?$(DY!(B . ?\x84DC) ;; <CJK>
     (?$(DY"(B . ?\x84E7) ;; <CJK>
     (?$(DY#(B . ?\x84EA) ;; <CJK>
     (?$(DY$(B . ?\x84EF) ;; <CJK>
     (?$(DY%(B . ?\x84F0) ;; <CJK>
     (?$(DY&(B . ?\x84F1) ;; <CJK>
     (?$(DY'(B . ?\x84F2) ;; <CJK>
     (?$(DY((B . ?\x84F7) ;; <CJK>
     (?$(DY)(B . ?\x8532) ;; <CJK>
     (?$(DY*(B . ?\x84FA) ;; <CJK>
     (?$(DY+(B . ?\x84FB) ;; <CJK>
     (?$(DY,(B . ?\x84FD) ;; <CJK>
     (?$(DY-(B . ?\x8502) ;; <CJK>
     (?$(DY.(B . ?\x8503) ;; <CJK>
     (?$(DY/(B . ?\x8507) ;; <CJK>
     (?$(DY0(B . ?\x850C) ;; <CJK>
     (?$(DY1(B . ?\x850E) ;; <CJK>
     (?$(DY2(B . ?\x8510) ;; <CJK>
     (?$(DY3(B . ?\x851C) ;; <CJK>
     (?$(DY4(B . ?\x851E) ;; <CJK>
     (?$(DY5(B . ?\x8522) ;; <CJK>
     (?$(DY6(B . ?\x8523) ;; <CJK>
     (?$(DY7(B . ?\x8524) ;; <CJK>
     (?$(DY8(B . ?\x8525) ;; <CJK>
     (?$(DY9(B . ?\x8527) ;; <CJK>
     (?$(DY:(B . ?\x852A) ;; <CJK>
     (?$(DY;(B . ?\x852B) ;; <CJK>
     (?$(DY<(B . ?\x852F) ;; <CJK>
     (?$(DY=(B . ?\x8533) ;; <CJK>
     (?$(DY>(B . ?\x8534) ;; <CJK>
     (?$(DY?(B . ?\x8536) ;; <CJK>
     (?$(DY@(B . ?\x853F) ;; <CJK>
     (?$(DYA(B . ?\x8546) ;; <CJK>
     (?$(DYB(B . ?\x854F) ;; <CJK>
     (?$(DYC(B . ?\x8550) ;; <CJK>
     (?$(DYD(B . ?\x8551) ;; <CJK>
     (?$(DYE(B . ?\x8552) ;; <CJK>
     (?$(DYF(B . ?\x8553) ;; <CJK>
     (?$(DYG(B . ?\x8556) ;; <CJK>
     (?$(DYH(B . ?\x8559) ;; <CJK>
     (?$(DYI(B . ?\x855C) ;; <CJK>
     (?$(DYJ(B . ?\x855D) ;; <CJK>
     (?$(DYK(B . ?\x855E) ;; <CJK>
     (?$(DYL(B . ?\x855F) ;; <CJK>
     (?$(DYM(B . ?\x8560) ;; <CJK>
     (?$(DYN(B . ?\x8561) ;; <CJK>
     (?$(DYO(B . ?\x8562) ;; <CJK>
     (?$(DYP(B . ?\x8564) ;; <CJK>
     (?$(DYQ(B . ?\x856B) ;; <CJK>
     (?$(DYR(B . ?\x856F) ;; <CJK>
     (?$(DYS(B . ?\x8579) ;; <CJK>
     (?$(DYT(B . ?\x857A) ;; <CJK>
     (?$(DYU(B . ?\x857B) ;; <CJK>
     (?$(DYV(B . ?\x857D) ;; <CJK>
     (?$(DYW(B . ?\x857F) ;; <CJK>
     (?$(DYX(B . ?\x8581) ;; <CJK>
     (?$(DYY(B . ?\x8585) ;; <CJK>
     (?$(DYZ(B . ?\x8586) ;; <CJK>
     (?$(DY[(B . ?\x8589) ;; <CJK>
     (?$(DY\(B . ?\x858B) ;; <CJK>
     (?$(DY](B . ?\x858C) ;; <CJK>
     (?$(DY^(B . ?\x858F) ;; <CJK>
     (?$(DY_(B . ?\x8593) ;; <CJK>
     (?$(DY`(B . ?\x8598) ;; <CJK>
     (?$(DYa(B . ?\x859D) ;; <CJK>
     (?$(DYb(B . ?\x859F) ;; <CJK>
     (?$(DYc(B . ?\x85A0) ;; <CJK>
     (?$(DYd(B . ?\x85A2) ;; <CJK>
     (?$(DYe(B . ?\x85A5) ;; <CJK>
     (?$(DYf(B . ?\x85A7) ;; <CJK>
     (?$(DYg(B . ?\x85B4) ;; <CJK>
     (?$(DYh(B . ?\x85B6) ;; <CJK>
     (?$(DYi(B . ?\x85B7) ;; <CJK>
     (?$(DYj(B . ?\x85B8) ;; <CJK>
     (?$(DYk(B . ?\x85BC) ;; <CJK>
     (?$(DYl(B . ?\x85BD) ;; <CJK>
     (?$(DYm(B . ?\x85BE) ;; <CJK>
     (?$(DYn(B . ?\x85BF) ;; <CJK>
     (?$(DYo(B . ?\x85C2) ;; <CJK>
     (?$(DYp(B . ?\x85C7) ;; <CJK>
     (?$(DYq(B . ?\x85CA) ;; <CJK>
     (?$(DYr(B . ?\x85CB) ;; <CJK>
     (?$(DYs(B . ?\x85CE) ;; <CJK>
     (?$(DYt(B . ?\x85AD) ;; <CJK>
     (?$(DYu(B . ?\x85D8) ;; <CJK>
     (?$(DYv(B . ?\x85DA) ;; <CJK>
     (?$(DYw(B . ?\x85DF) ;; <CJK>
     (?$(DYx(B . ?\x85E0) ;; <CJK>
     (?$(DYy(B . ?\x85E6) ;; <CJK>
     (?$(DYz(B . ?\x85E8) ;; <CJK>
     (?$(DY{(B . ?\x85ED) ;; <CJK>
     (?$(DY|(B . ?\x85F3) ;; <CJK>
     (?$(DY}(B . ?\x85F6) ;; <CJK>
     (?$(DY~(B . ?\x85FC) ;; <CJK>
     (?$(DZ!(B . ?\x85FF) ;; <CJK>
     (?$(DZ"(B . ?\x8600) ;; <CJK>
     (?$(DZ#(B . ?\x8604) ;; <CJK>
     (?$(DZ$(B . ?\x8605) ;; <CJK>
     (?$(DZ%(B . ?\x860D) ;; <CJK>
     (?$(DZ&(B . ?\x860E) ;; <CJK>
     (?$(DZ'(B . ?\x8610) ;; <CJK>
     (?$(DZ((B . ?\x8611) ;; <CJK>
     (?$(DZ)(B . ?\x8612) ;; <CJK>
     (?$(DZ*(B . ?\x8618) ;; <CJK>
     (?$(DZ+(B . ?\x8619) ;; <CJK>
     (?$(DZ,(B . ?\x861B) ;; <CJK>
     (?$(DZ-(B . ?\x861E) ;; <CJK>
     (?$(DZ.(B . ?\x8621) ;; <CJK>
     (?$(DZ/(B . ?\x8627) ;; <CJK>
     (?$(DZ0(B . ?\x8629) ;; <CJK>
     (?$(DZ1(B . ?\x8636) ;; <CJK>
     (?$(DZ2(B . ?\x8638) ;; <CJK>
     (?$(DZ3(B . ?\x863A) ;; <CJK>
     (?$(DZ4(B . ?\x863C) ;; <CJK>
     (?$(DZ5(B . ?\x863D) ;; <CJK>
     (?$(DZ6(B . ?\x8640) ;; <CJK>
     (?$(DZ7(B . ?\x8642) ;; <CJK>
     (?$(DZ8(B . ?\x8646) ;; <CJK>
     (?$(DZ9(B . ?\x8652) ;; <CJK>
     (?$(DZ:(B . ?\x8653) ;; <CJK>
     (?$(DZ;(B . ?\x8656) ;; <CJK>
     (?$(DZ<(B . ?\x8657) ;; <CJK>
     (?$(DZ=(B . ?\x8658) ;; <CJK>
     (?$(DZ>(B . ?\x8659) ;; <CJK>
     (?$(DZ?(B . ?\x865D) ;; <CJK>
     (?$(DZ@(B . ?\x8660) ;; <CJK>
     (?$(DZA(B . ?\x8661) ;; <CJK>
     (?$(DZB(B . ?\x8662) ;; <CJK>
     (?$(DZC(B . ?\x8663) ;; <CJK>
     (?$(DZD(B . ?\x8664) ;; <CJK>
     (?$(DZE(B . ?\x8669) ;; <CJK>
     (?$(DZF(B . ?\x866C) ;; <CJK>
     (?$(DZG(B . ?\x866F) ;; <CJK>
     (?$(DZH(B . ?\x8675) ;; <CJK>
     (?$(DZI(B . ?\x8676) ;; <CJK>
     (?$(DZJ(B . ?\x8677) ;; <CJK>
     (?$(DZK(B . ?\x867A) ;; <CJK>
     (?$(DZL(B . ?\x868D) ;; <CJK>
     (?$(DZM(B . ?\x8691) ;; <CJK>
     (?$(DZN(B . ?\x8696) ;; <CJK>
     (?$(DZO(B . ?\x8698) ;; <CJK>
     (?$(DZP(B . ?\x869A) ;; <CJK>
     (?$(DZQ(B . ?\x869C) ;; <CJK>
     (?$(DZR(B . ?\x86A1) ;; <CJK>
     (?$(DZS(B . ?\x86A6) ;; <CJK>
     (?$(DZT(B . ?\x86A7) ;; <CJK>
     (?$(DZU(B . ?\x86A8) ;; <CJK>
     (?$(DZV(B . ?\x86AD) ;; <CJK>
     (?$(DZW(B . ?\x86B1) ;; <CJK>
     (?$(DZX(B . ?\x86B3) ;; <CJK>
     (?$(DZY(B . ?\x86B4) ;; <CJK>
     (?$(DZZ(B . ?\x86B5) ;; <CJK>
     (?$(DZ[(B . ?\x86B7) ;; <CJK>
     (?$(DZ\(B . ?\x86B8) ;; <CJK>
     (?$(DZ](B . ?\x86B9) ;; <CJK>
     (?$(DZ^(B . ?\x86BF) ;; <CJK>
     (?$(DZ_(B . ?\x86C0) ;; <CJK>
     (?$(DZ`(B . ?\x86C1) ;; <CJK>
     (?$(DZa(B . ?\x86C3) ;; <CJK>
     (?$(DZb(B . ?\x86C5) ;; <CJK>
     (?$(DZc(B . ?\x86D1) ;; <CJK>
     (?$(DZd(B . ?\x86D2) ;; <CJK>
     (?$(DZe(B . ?\x86D5) ;; <CJK>
     (?$(DZf(B . ?\x86D7) ;; <CJK>
     (?$(DZg(B . ?\x86DA) ;; <CJK>
     (?$(DZh(B . ?\x86DC) ;; <CJK>
     (?$(DZi(B . ?\x86E0) ;; <CJK>
     (?$(DZj(B . ?\x86E3) ;; <CJK>
     (?$(DZk(B . ?\x86E5) ;; <CJK>
     (?$(DZl(B . ?\x86E7) ;; <CJK>
     (?$(DZm(B . ?\x8688) ;; <CJK>
     (?$(DZn(B . ?\x86FA) ;; <CJK>
     (?$(DZo(B . ?\x86FC) ;; <CJK>
     (?$(DZp(B . ?\x86FD) ;; <CJK>
     (?$(DZq(B . ?\x8704) ;; <CJK>
     (?$(DZr(B . ?\x8705) ;; <CJK>
     (?$(DZs(B . ?\x8707) ;; <CJK>
     (?$(DZt(B . ?\x870B) ;; <CJK>
     (?$(DZu(B . ?\x870E) ;; <CJK>
     (?$(DZv(B . ?\x870F) ;; <CJK>
     (?$(DZw(B . ?\x8710) ;; <CJK>
     (?$(DZx(B . ?\x8713) ;; <CJK>
     (?$(DZy(B . ?\x8714) ;; <CJK>
     (?$(DZz(B . ?\x8719) ;; <CJK>
     (?$(DZ{(B . ?\x871E) ;; <CJK>
     (?$(DZ|(B . ?\x871F) ;; <CJK>
     (?$(DZ}(B . ?\x8721) ;; <CJK>
     (?$(DZ~(B . ?\x8723) ;; <CJK>
     (?$(D[!(B . ?\x8728) ;; <CJK>
     (?$(D["(B . ?\x872E) ;; <CJK>
     (?$(D[#(B . ?\x872F) ;; <CJK>
     (?$(D[$(B . ?\x8731) ;; <CJK>
     (?$(D[%(B . ?\x8732) ;; <CJK>
     (?$(D[&(B . ?\x8739) ;; <CJK>
     (?$(D['(B . ?\x873A) ;; <CJK>
     (?$(D[((B . ?\x873C) ;; <CJK>
     (?$(D[)(B . ?\x873D) ;; <CJK>
     (?$(D[*(B . ?\x873E) ;; <CJK>
     (?$(D[+(B . ?\x8740) ;; <CJK>
     (?$(D[,(B . ?\x8743) ;; <CJK>
     (?$(D[-(B . ?\x8745) ;; <CJK>
     (?$(D[.(B . ?\x874D) ;; <CJK>
     (?$(D[/(B . ?\x8758) ;; <CJK>
     (?$(D[0(B . ?\x875D) ;; <CJK>
     (?$(D[1(B . ?\x8761) ;; <CJK>
     (?$(D[2(B . ?\x8764) ;; <CJK>
     (?$(D[3(B . ?\x8765) ;; <CJK>
     (?$(D[4(B . ?\x876F) ;; <CJK>
     (?$(D[5(B . ?\x8771) ;; <CJK>
     (?$(D[6(B . ?\x8772) ;; <CJK>
     (?$(D[7(B . ?\x877B) ;; <CJK>
     (?$(D[8(B . ?\x8783) ;; <CJK>
     (?$(D[9(B . ?\x8784) ;; <CJK>
     (?$(D[:(B . ?\x8785) ;; <CJK>
     (?$(D[;(B . ?\x8786) ;; <CJK>
     (?$(D[<(B . ?\x8787) ;; <CJK>
     (?$(D[=(B . ?\x8788) ;; <CJK>
     (?$(D[>(B . ?\x8789) ;; <CJK>
     (?$(D[?(B . ?\x878B) ;; <CJK>
     (?$(D[@(B . ?\x878C) ;; <CJK>
     (?$(D[A(B . ?\x8790) ;; <CJK>
     (?$(D[B(B . ?\x8793) ;; <CJK>
     (?$(D[C(B . ?\x8795) ;; <CJK>
     (?$(D[D(B . ?\x8797) ;; <CJK>
     (?$(D[E(B . ?\x8798) ;; <CJK>
     (?$(D[F(B . ?\x8799) ;; <CJK>
     (?$(D[G(B . ?\x879E) ;; <CJK>
     (?$(D[H(B . ?\x87A0) ;; <CJK>
     (?$(D[I(B . ?\x87A3) ;; <CJK>
     (?$(D[J(B . ?\x87A7) ;; <CJK>
     (?$(D[K(B . ?\x87AC) ;; <CJK>
     (?$(D[L(B . ?\x87AD) ;; <CJK>
     (?$(D[M(B . ?\x87AE) ;; <CJK>
     (?$(D[N(B . ?\x87B1) ;; <CJK>
     (?$(D[O(B . ?\x87B5) ;; <CJK>
     (?$(D[P(B . ?\x87BE) ;; <CJK>
     (?$(D[Q(B . ?\x87BF) ;; <CJK>
     (?$(D[R(B . ?\x87C1) ;; <CJK>
     (?$(D[S(B . ?\x87C8) ;; <CJK>
     (?$(D[T(B . ?\x87C9) ;; <CJK>
     (?$(D[U(B . ?\x87CA) ;; <CJK>
     (?$(D[V(B . ?\x87CE) ;; <CJK>
     (?$(D[W(B . ?\x87D5) ;; <CJK>
     (?$(D[X(B . ?\x87D6) ;; <CJK>
     (?$(D[Y(B . ?\x87D9) ;; <CJK>
     (?$(D[Z(B . ?\x87DA) ;; <CJK>
     (?$(D[[(B . ?\x87DC) ;; <CJK>
     (?$(D[\(B . ?\x87DF) ;; <CJK>
     (?$(D[](B . ?\x87E2) ;; <CJK>
     (?$(D[^(B . ?\x87E3) ;; <CJK>
     (?$(D[_(B . ?\x87E4) ;; <CJK>
     (?$(D[`(B . ?\x87EA) ;; <CJK>
     (?$(D[a(B . ?\x87EB) ;; <CJK>
     (?$(D[b(B . ?\x87ED) ;; <CJK>
     (?$(D[c(B . ?\x87F1) ;; <CJK>
     (?$(D[d(B . ?\x87F3) ;; <CJK>
     (?$(D[e(B . ?\x87F8) ;; <CJK>
     (?$(D[f(B . ?\x87FA) ;; <CJK>
     (?$(D[g(B . ?\x87FF) ;; <CJK>
     (?$(D[h(B . ?\x8801) ;; <CJK>
     (?$(D[i(B . ?\x8803) ;; <CJK>
     (?$(D[j(B . ?\x8806) ;; <CJK>
     (?$(D[k(B . ?\x8809) ;; <CJK>
     (?$(D[l(B . ?\x880A) ;; <CJK>
     (?$(D[m(B . ?\x880B) ;; <CJK>
     (?$(D[n(B . ?\x8810) ;; <CJK>
     (?$(D[o(B . ?\x8819) ;; <CJK>
     (?$(D[p(B . ?\x8812) ;; <CJK>
     (?$(D[q(B . ?\x8813) ;; <CJK>
     (?$(D[r(B . ?\x8814) ;; <CJK>
     (?$(D[s(B . ?\x8818) ;; <CJK>
     (?$(D[t(B . ?\x881A) ;; <CJK>
     (?$(D[u(B . ?\x881B) ;; <CJK>
     (?$(D[v(B . ?\x881C) ;; <CJK>
     (?$(D[w(B . ?\x881E) ;; <CJK>
     (?$(D[x(B . ?\x881F) ;; <CJK>
     (?$(D[y(B . ?\x8828) ;; <CJK>
     (?$(D[z(B . ?\x882D) ;; <CJK>
     (?$(D[{(B . ?\x882E) ;; <CJK>
     (?$(D[|(B . ?\x8830) ;; <CJK>
     (?$(D[}(B . ?\x8832) ;; <CJK>
     (?$(D[~(B . ?\x8835) ;; <CJK>
     (?$(D\!(B . ?\x883A) ;; <CJK>
     (?$(D\"(B . ?\x883C) ;; <CJK>
     (?$(D\#(B . ?\x8841) ;; <CJK>
     (?$(D\$(B . ?\x8843) ;; <CJK>
     (?$(D\%(B . ?\x8845) ;; <CJK>
     (?$(D\&(B . ?\x8848) ;; <CJK>
     (?$(D\'(B . ?\x8849) ;; <CJK>
     (?$(D\((B . ?\x884A) ;; <CJK>
     (?$(D\)(B . ?\x884B) ;; <CJK>
     (?$(D\*(B . ?\x884E) ;; <CJK>
     (?$(D\+(B . ?\x8851) ;; <CJK>
     (?$(D\,(B . ?\x8855) ;; <CJK>
     (?$(D\-(B . ?\x8856) ;; <CJK>
     (?$(D\.(B . ?\x8858) ;; <CJK>
     (?$(D\/(B . ?\x885A) ;; <CJK>
     (?$(D\0(B . ?\x885C) ;; <CJK>
     (?$(D\1(B . ?\x885F) ;; <CJK>
     (?$(D\2(B . ?\x8860) ;; <CJK>
     (?$(D\3(B . ?\x8864) ;; <CJK>
     (?$(D\4(B . ?\x8869) ;; <CJK>
     (?$(D\5(B . ?\x8871) ;; <CJK>
     (?$(D\6(B . ?\x8879) ;; <CJK>
     (?$(D\7(B . ?\x887B) ;; <CJK>
     (?$(D\8(B . ?\x8880) ;; <CJK>
     (?$(D\9(B . ?\x8898) ;; <CJK>
     (?$(D\:(B . ?\x889A) ;; <CJK>
     (?$(D\;(B . ?\x889B) ;; <CJK>
     (?$(D\<(B . ?\x889C) ;; <CJK>
     (?$(D\=(B . ?\x889F) ;; <CJK>
     (?$(D\>(B . ?\x88A0) ;; <CJK>
     (?$(D\?(B . ?\x88A8) ;; <CJK>
     (?$(D\@(B . ?\x88AA) ;; <CJK>
     (?$(D\A(B . ?\x88BA) ;; <CJK>
     (?$(D\B(B . ?\x88BD) ;; <CJK>
     (?$(D\C(B . ?\x88BE) ;; <CJK>
     (?$(D\D(B . ?\x88C0) ;; <CJK>
     (?$(D\E(B . ?\x88CA) ;; <CJK>
     (?$(D\F(B . ?\x88CB) ;; <CJK>
     (?$(D\G(B . ?\x88CC) ;; <CJK>
     (?$(D\H(B . ?\x88CD) ;; <CJK>
     (?$(D\I(B . ?\x88CE) ;; <CJK>
     (?$(D\J(B . ?\x88D1) ;; <CJK>
     (?$(D\K(B . ?\x88D2) ;; <CJK>
     (?$(D\L(B . ?\x88D3) ;; <CJK>
     (?$(D\M(B . ?\x88DB) ;; <CJK>
     (?$(D\N(B . ?\x88DE) ;; <CJK>
     (?$(D\O(B . ?\x88E7) ;; <CJK>
     (?$(D\P(B . ?\x88EF) ;; <CJK>
     (?$(D\Q(B . ?\x88F0) ;; <CJK>
     (?$(D\R(B . ?\x88F1) ;; <CJK>
     (?$(D\S(B . ?\x88F5) ;; <CJK>
     (?$(D\T(B . ?\x88F7) ;; <CJK>
     (?$(D\U(B . ?\x8901) ;; <CJK>
     (?$(D\V(B . ?\x8906) ;; <CJK>
     (?$(D\W(B . ?\x890D) ;; <CJK>
     (?$(D\X(B . ?\x890E) ;; <CJK>
     (?$(D\Y(B . ?\x890F) ;; <CJK>
     (?$(D\Z(B . ?\x8915) ;; <CJK>
     (?$(D\[(B . ?\x8916) ;; <CJK>
     (?$(D\\(B . ?\x8918) ;; <CJK>
     (?$(D\](B . ?\x8919) ;; <CJK>
     (?$(D\^(B . ?\x891A) ;; <CJK>
     (?$(D\_(B . ?\x891C) ;; <CJK>
     (?$(D\`(B . ?\x8920) ;; <CJK>
     (?$(D\a(B . ?\x8926) ;; <CJK>
     (?$(D\b(B . ?\x8927) ;; <CJK>
     (?$(D\c(B . ?\x8928) ;; <CJK>
     (?$(D\d(B . ?\x8930) ;; <CJK>
     (?$(D\e(B . ?\x8931) ;; <CJK>
     (?$(D\f(B . ?\x8932) ;; <CJK>
     (?$(D\g(B . ?\x8935) ;; <CJK>
     (?$(D\h(B . ?\x8939) ;; <CJK>
     (?$(D\i(B . ?\x893A) ;; <CJK>
     (?$(D\j(B . ?\x893E) ;; <CJK>
     (?$(D\k(B . ?\x8940) ;; <CJK>
     (?$(D\l(B . ?\x8942) ;; <CJK>
     (?$(D\m(B . ?\x8945) ;; <CJK>
     (?$(D\n(B . ?\x8946) ;; <CJK>
     (?$(D\o(B . ?\x8949) ;; <CJK>
     (?$(D\p(B . ?\x894F) ;; <CJK>
     (?$(D\q(B . ?\x8952) ;; <CJK>
     (?$(D\r(B . ?\x8957) ;; <CJK>
     (?$(D\s(B . ?\x895A) ;; <CJK>
     (?$(D\t(B . ?\x895B) ;; <CJK>
     (?$(D\u(B . ?\x895C) ;; <CJK>
     (?$(D\v(B . ?\x8961) ;; <CJK>
     (?$(D\w(B . ?\x8962) ;; <CJK>
     (?$(D\x(B . ?\x8963) ;; <CJK>
     (?$(D\y(B . ?\x896B) ;; <CJK>
     (?$(D\z(B . ?\x896E) ;; <CJK>
     (?$(D\{(B . ?\x8970) ;; <CJK>
     (?$(D\|(B . ?\x8973) ;; <CJK>
     (?$(D\}(B . ?\x8975) ;; <CJK>
     (?$(D\~(B . ?\x897A) ;; <CJK>
     (?$(D]!(B . ?\x897B) ;; <CJK>
     (?$(D]"(B . ?\x897C) ;; <CJK>
     (?$(D]#(B . ?\x897D) ;; <CJK>
     (?$(D]$(B . ?\x8989) ;; <CJK>
     (?$(D]%(B . ?\x898D) ;; <CJK>
     (?$(D]&(B . ?\x8990) ;; <CJK>
     (?$(D]'(B . ?\x8994) ;; <CJK>
     (?$(D]((B . ?\x8995) ;; <CJK>
     (?$(D])(B . ?\x899B) ;; <CJK>
     (?$(D]*(B . ?\x899C) ;; <CJK>
     (?$(D]+(B . ?\x899F) ;; <CJK>
     (?$(D],(B . ?\x89A0) ;; <CJK>
     (?$(D]-(B . ?\x89A5) ;; <CJK>
     (?$(D].(B . ?\x89B0) ;; <CJK>
     (?$(D]/(B . ?\x89B4) ;; <CJK>
     (?$(D]0(B . ?\x89B5) ;; <CJK>
     (?$(D]1(B . ?\x89B6) ;; <CJK>
     (?$(D]2(B . ?\x89B7) ;; <CJK>
     (?$(D]3(B . ?\x89BC) ;; <CJK>
     (?$(D]4(B . ?\x89D4) ;; <CJK>
     (?$(D]5(B . ?\x89D5) ;; <CJK>
     (?$(D]6(B . ?\x89D6) ;; <CJK>
     (?$(D]7(B . ?\x89D7) ;; <CJK>
     (?$(D]8(B . ?\x89D8) ;; <CJK>
     (?$(D]9(B . ?\x89E5) ;; <CJK>
     (?$(D]:(B . ?\x89E9) ;; <CJK>
     (?$(D];(B . ?\x89EB) ;; <CJK>
     (?$(D]<(B . ?\x89ED) ;; <CJK>
     (?$(D]=(B . ?\x89F1) ;; <CJK>
     (?$(D]>(B . ?\x89F3) ;; <CJK>
     (?$(D]?(B . ?\x89F6) ;; <CJK>
     (?$(D]@(B . ?\x89F9) ;; <CJK>
     (?$(D]A(B . ?\x89FD) ;; <CJK>
     (?$(D]B(B . ?\x89FF) ;; <CJK>
     (?$(D]C(B . ?\x8A04) ;; <CJK>
     (?$(D]D(B . ?\x8A05) ;; <CJK>
     (?$(D]E(B . ?\x8A07) ;; <CJK>
     (?$(D]F(B . ?\x8A0F) ;; <CJK>
     (?$(D]G(B . ?\x8A11) ;; <CJK>
     (?$(D]H(B . ?\x8A12) ;; <CJK>
     (?$(D]I(B . ?\x8A14) ;; <CJK>
     (?$(D]J(B . ?\x8A15) ;; <CJK>
     (?$(D]K(B . ?\x8A1E) ;; <CJK>
     (?$(D]L(B . ?\x8A20) ;; <CJK>
     (?$(D]M(B . ?\x8A22) ;; <CJK>
     (?$(D]N(B . ?\x8A24) ;; <CJK>
     (?$(D]O(B . ?\x8A26) ;; <CJK>
     (?$(D]P(B . ?\x8A2B) ;; <CJK>
     (?$(D]Q(B . ?\x8A2C) ;; <CJK>
     (?$(D]R(B . ?\x8A2F) ;; <CJK>
     (?$(D]S(B . ?\x8A35) ;; <CJK>
     (?$(D]T(B . ?\x8A37) ;; <CJK>
     (?$(D]U(B . ?\x8A3D) ;; <CJK>
     (?$(D]V(B . ?\x8A3E) ;; <CJK>
     (?$(D]W(B . ?\x8A40) ;; <CJK>
     (?$(D]X(B . ?\x8A43) ;; <CJK>
     (?$(D]Y(B . ?\x8A45) ;; <CJK>
     (?$(D]Z(B . ?\x8A47) ;; <CJK>
     (?$(D][(B . ?\x8A49) ;; <CJK>
     (?$(D]\(B . ?\x8A4D) ;; <CJK>
     (?$(D]](B . ?\x8A4E) ;; <CJK>
     (?$(D]^(B . ?\x8A53) ;; <CJK>
     (?$(D]_(B . ?\x8A56) ;; <CJK>
     (?$(D]`(B . ?\x8A57) ;; <CJK>
     (?$(D]a(B . ?\x8A58) ;; <CJK>
     (?$(D]b(B . ?\x8A5C) ;; <CJK>
     (?$(D]c(B . ?\x8A5D) ;; <CJK>
     (?$(D]d(B . ?\x8A61) ;; <CJK>
     (?$(D]e(B . ?\x8A65) ;; <CJK>
     (?$(D]f(B . ?\x8A67) ;; <CJK>
     (?$(D]g(B . ?\x8A75) ;; <CJK>
     (?$(D]h(B . ?\x8A76) ;; <CJK>
     (?$(D]i(B . ?\x8A77) ;; <CJK>
     (?$(D]j(B . ?\x8A79) ;; <CJK>
     (?$(D]k(B . ?\x8A7A) ;; <CJK>
     (?$(D]l(B . ?\x8A7B) ;; <CJK>
     (?$(D]m(B . ?\x8A7E) ;; <CJK>
     (?$(D]n(B . ?\x8A7F) ;; <CJK>
     (?$(D]o(B . ?\x8A80) ;; <CJK>
     (?$(D]p(B . ?\x8A83) ;; <CJK>
     (?$(D]q(B . ?\x8A86) ;; <CJK>
     (?$(D]r(B . ?\x8A8B) ;; <CJK>
     (?$(D]s(B . ?\x8A8F) ;; <CJK>
     (?$(D]t(B . ?\x8A90) ;; <CJK>
     (?$(D]u(B . ?\x8A92) ;; <CJK>
     (?$(D]v(B . ?\x8A96) ;; <CJK>
     (?$(D]w(B . ?\x8A97) ;; <CJK>
     (?$(D]x(B . ?\x8A99) ;; <CJK>
     (?$(D]y(B . ?\x8A9F) ;; <CJK>
     (?$(D]z(B . ?\x8AA7) ;; <CJK>
     (?$(D]{(B . ?\x8AA9) ;; <CJK>
     (?$(D]|(B . ?\x8AAE) ;; <CJK>
     (?$(D]}(B . ?\x8AAF) ;; <CJK>
     (?$(D]~(B . ?\x8AB3) ;; <CJK>
     (?$(D^!(B . ?\x8AB6) ;; <CJK>
     (?$(D^"(B . ?\x8AB7) ;; <CJK>
     (?$(D^#(B . ?\x8ABB) ;; <CJK>
     (?$(D^$(B . ?\x8ABE) ;; <CJK>
     (?$(D^%(B . ?\x8AC3) ;; <CJK>
     (?$(D^&(B . ?\x8AC6) ;; <CJK>
     (?$(D^'(B . ?\x8AC8) ;; <CJK>
     (?$(D^((B . ?\x8AC9) ;; <CJK>
     (?$(D^)(B . ?\x8ACA) ;; <CJK>
     (?$(D^*(B . ?\x8AD1) ;; <CJK>
     (?$(D^+(B . ?\x8AD3) ;; <CJK>
     (?$(D^,(B . ?\x8AD4) ;; <CJK>
     (?$(D^-(B . ?\x8AD5) ;; <CJK>
     (?$(D^.(B . ?\x8AD7) ;; <CJK>
     (?$(D^/(B . ?\x8ADD) ;; <CJK>
     (?$(D^0(B . ?\x8ADF) ;; <CJK>
     (?$(D^1(B . ?\x8AEC) ;; <CJK>
     (?$(D^2(B . ?\x8AF0) ;; <CJK>
     (?$(D^3(B . ?\x8AF4) ;; <CJK>
     (?$(D^4(B . ?\x8AF5) ;; <CJK>
     (?$(D^5(B . ?\x8AF6) ;; <CJK>
     (?$(D^6(B . ?\x8AFC) ;; <CJK>
     (?$(D^7(B . ?\x8AFF) ;; <CJK>
     (?$(D^8(B . ?\x8B05) ;; <CJK>
     (?$(D^9(B . ?\x8B06) ;; <CJK>
     (?$(D^:(B . ?\x8B0B) ;; <CJK>
     (?$(D^;(B . ?\x8B11) ;; <CJK>
     (?$(D^<(B . ?\x8B1C) ;; <CJK>
     (?$(D^=(B . ?\x8B1E) ;; <CJK>
     (?$(D^>(B . ?\x8B1F) ;; <CJK>
     (?$(D^?(B . ?\x8B0A) ;; <CJK>
     (?$(D^@(B . ?\x8B2D) ;; <CJK>
     (?$(D^A(B . ?\x8B30) ;; <CJK>
     (?$(D^B(B . ?\x8B37) ;; <CJK>
     (?$(D^C(B . ?\x8B3C) ;; <CJK>
     (?$(D^D(B . ?\x8B42) ;; <CJK>
     (?$(D^E(B . ?\x8B43) ;; <CJK>
     (?$(D^F(B . ?\x8B44) ;; <CJK>
     (?$(D^G(B . ?\x8B45) ;; <CJK>
     (?$(D^H(B . ?\x8B46) ;; <CJK>
     (?$(D^I(B . ?\x8B48) ;; <CJK>
     (?$(D^J(B . ?\x8B52) ;; <CJK>
     (?$(D^K(B . ?\x8B53) ;; <CJK>
     (?$(D^L(B . ?\x8B54) ;; <CJK>
     (?$(D^M(B . ?\x8B59) ;; <CJK>
     (?$(D^N(B . ?\x8B4D) ;; <CJK>
     (?$(D^O(B . ?\x8B5E) ;; <CJK>
     (?$(D^P(B . ?\x8B63) ;; <CJK>
     (?$(D^Q(B . ?\x8B6D) ;; <CJK>
     (?$(D^R(B . ?\x8B76) ;; <CJK>
     (?$(D^S(B . ?\x8B78) ;; <CJK>
     (?$(D^T(B . ?\x8B79) ;; <CJK>
     (?$(D^U(B . ?\x8B7C) ;; <CJK>
     (?$(D^V(B . ?\x8B7E) ;; <CJK>
     (?$(D^W(B . ?\x8B81) ;; <CJK>
     (?$(D^X(B . ?\x8B84) ;; <CJK>
     (?$(D^Y(B . ?\x8B85) ;; <CJK>
     (?$(D^Z(B . ?\x8B8B) ;; <CJK>
     (?$(D^[(B . ?\x8B8D) ;; <CJK>
     (?$(D^\(B . ?\x8B8F) ;; <CJK>
     (?$(D^](B . ?\x8B94) ;; <CJK>
     (?$(D^^(B . ?\x8B95) ;; <CJK>
     (?$(D^_(B . ?\x8B9C) ;; <CJK>
     (?$(D^`(B . ?\x8B9E) ;; <CJK>
     (?$(D^a(B . ?\x8B9F) ;; <CJK>
     (?$(D^b(B . ?\x8C38) ;; <CJK>
     (?$(D^c(B . ?\x8C39) ;; <CJK>
     (?$(D^d(B . ?\x8C3D) ;; <CJK>
     (?$(D^e(B . ?\x8C3E) ;; <CJK>
     (?$(D^f(B . ?\x8C45) ;; <CJK>
     (?$(D^g(B . ?\x8C47) ;; <CJK>
     (?$(D^h(B . ?\x8C49) ;; <CJK>
     (?$(D^i(B . ?\x8C4B) ;; <CJK>
     (?$(D^j(B . ?\x8C4F) ;; <CJK>
     (?$(D^k(B . ?\x8C51) ;; <CJK>
     (?$(D^l(B . ?\x8C53) ;; <CJK>
     (?$(D^m(B . ?\x8C54) ;; <CJK>
     (?$(D^n(B . ?\x8C57) ;; <CJK>
     (?$(D^o(B . ?\x8C58) ;; <CJK>
     (?$(D^p(B . ?\x8C5B) ;; <CJK>
     (?$(D^q(B . ?\x8C5D) ;; <CJK>
     (?$(D^r(B . ?\x8C59) ;; <CJK>
     (?$(D^s(B . ?\x8C63) ;; <CJK>
     (?$(D^t(B . ?\x8C64) ;; <CJK>
     (?$(D^u(B . ?\x8C66) ;; <CJK>
     (?$(D^v(B . ?\x8C68) ;; <CJK>
     (?$(D^w(B . ?\x8C69) ;; <CJK>
     (?$(D^x(B . ?\x8C6D) ;; <CJK>
     (?$(D^y(B . ?\x8C73) ;; <CJK>
     (?$(D^z(B . ?\x8C75) ;; <CJK>
     (?$(D^{(B . ?\x8C76) ;; <CJK>
     (?$(D^|(B . ?\x8C7B) ;; <CJK>
     (?$(D^}(B . ?\x8C7E) ;; <CJK>
     (?$(D^~(B . ?\x8C86) ;; <CJK>
     (?$(D_!(B . ?\x8C87) ;; <CJK>
     (?$(D_"(B . ?\x8C8B) ;; <CJK>
     (?$(D_#(B . ?\x8C90) ;; <CJK>
     (?$(D_$(B . ?\x8C92) ;; <CJK>
     (?$(D_%(B . ?\x8C93) ;; <CJK>
     (?$(D_&(B . ?\x8C99) ;; <CJK>
     (?$(D_'(B . ?\x8C9B) ;; <CJK>
     (?$(D_((B . ?\x8C9C) ;; <CJK>
     (?$(D_)(B . ?\x8CA4) ;; <CJK>
     (?$(D_*(B . ?\x8CB9) ;; <CJK>
     (?$(D_+(B . ?\x8CBA) ;; <CJK>
     (?$(D_,(B . ?\x8CC5) ;; <CJK>
     (?$(D_-(B . ?\x8CC6) ;; <CJK>
     (?$(D_.(B . ?\x8CC9) ;; <CJK>
     (?$(D_/(B . ?\x8CCB) ;; <CJK>
     (?$(D_0(B . ?\x8CCF) ;; <CJK>
     (?$(D_1(B . ?\x8CD6) ;; <CJK>
     (?$(D_2(B . ?\x8CD5) ;; <CJK>
     (?$(D_3(B . ?\x8CD9) ;; <CJK>
     (?$(D_4(B . ?\x8CDD) ;; <CJK>
     (?$(D_5(B . ?\x8CE1) ;; <CJK>
     (?$(D_6(B . ?\x8CE8) ;; <CJK>
     (?$(D_7(B . ?\x8CEC) ;; <CJK>
     (?$(D_8(B . ?\x8CEF) ;; <CJK>
     (?$(D_9(B . ?\x8CF0) ;; <CJK>
     (?$(D_:(B . ?\x8CF2) ;; <CJK>
     (?$(D_;(B . ?\x8CF5) ;; <CJK>
     (?$(D_<(B . ?\x8CF7) ;; <CJK>
     (?$(D_=(B . ?\x8CF8) ;; <CJK>
     (?$(D_>(B . ?\x8CFE) ;; <CJK>
     (?$(D_?(B . ?\x8CFF) ;; <CJK>
     (?$(D_@(B . ?\x8D01) ;; <CJK>
     (?$(D_A(B . ?\x8D03) ;; <CJK>
     (?$(D_B(B . ?\x8D09) ;; <CJK>
     (?$(D_C(B . ?\x8D12) ;; <CJK>
     (?$(D_D(B . ?\x8D17) ;; <CJK>
     (?$(D_E(B . ?\x8D1B) ;; <CJK>
     (?$(D_F(B . ?\x8D65) ;; <CJK>
     (?$(D_G(B . ?\x8D69) ;; <CJK>
     (?$(D_H(B . ?\x8D6C) ;; <CJK>
     (?$(D_I(B . ?\x8D6E) ;; <CJK>
     (?$(D_J(B . ?\x8D7F) ;; <CJK>
     (?$(D_K(B . ?\x8D82) ;; <CJK>
     (?$(D_L(B . ?\x8D84) ;; <CJK>
     (?$(D_M(B . ?\x8D88) ;; <CJK>
     (?$(D_N(B . ?\x8D8D) ;; <CJK>
     (?$(D_O(B . ?\x8D90) ;; <CJK>
     (?$(D_P(B . ?\x8D91) ;; <CJK>
     (?$(D_Q(B . ?\x8D95) ;; <CJK>
     (?$(D_R(B . ?\x8D9E) ;; <CJK>
     (?$(D_S(B . ?\x8D9F) ;; <CJK>
     (?$(D_T(B . ?\x8DA0) ;; <CJK>
     (?$(D_U(B . ?\x8DA6) ;; <CJK>
     (?$(D_V(B . ?\x8DAB) ;; <CJK>
     (?$(D_W(B . ?\x8DAC) ;; <CJK>
     (?$(D_X(B . ?\x8DAF) ;; <CJK>
     (?$(D_Y(B . ?\x8DB2) ;; <CJK>
     (?$(D_Z(B . ?\x8DB5) ;; <CJK>
     (?$(D_[(B . ?\x8DB7) ;; <CJK>
     (?$(D_\(B . ?\x8DB9) ;; <CJK>
     (?$(D_](B . ?\x8DBB) ;; <CJK>
     (?$(D_^(B . ?\x8DC0) ;; <CJK>
     (?$(D__(B . ?\x8DC5) ;; <CJK>
     (?$(D_`(B . ?\x8DC6) ;; <CJK>
     (?$(D_a(B . ?\x8DC7) ;; <CJK>
     (?$(D_b(B . ?\x8DC8) ;; <CJK>
     (?$(D_c(B . ?\x8DCA) ;; <CJK>
     (?$(D_d(B . ?\x8DCE) ;; <CJK>
     (?$(D_e(B . ?\x8DD1) ;; <CJK>
     (?$(D_f(B . ?\x8DD4) ;; <CJK>
     (?$(D_g(B . ?\x8DD5) ;; <CJK>
     (?$(D_h(B . ?\x8DD7) ;; <CJK>
     (?$(D_i(B . ?\x8DD9) ;; <CJK>
     (?$(D_j(B . ?\x8DE4) ;; <CJK>
     (?$(D_k(B . ?\x8DE5) ;; <CJK>
     (?$(D_l(B . ?\x8DE7) ;; <CJK>
     (?$(D_m(B . ?\x8DEC) ;; <CJK>
     (?$(D_n(B . ?\x8DF0) ;; <CJK>
     (?$(D_o(B . ?\x8DBC) ;; <CJK>
     (?$(D_p(B . ?\x8DF1) ;; <CJK>
     (?$(D_q(B . ?\x8DF2) ;; <CJK>
     (?$(D_r(B . ?\x8DF4) ;; <CJK>
     (?$(D_s(B . ?\x8DFD) ;; <CJK>
     (?$(D_t(B . ?\x8E01) ;; <CJK>
     (?$(D_u(B . ?\x8E04) ;; <CJK>
     (?$(D_v(B . ?\x8E05) ;; <CJK>
     (?$(D_w(B . ?\x8E06) ;; <CJK>
     (?$(D_x(B . ?\x8E0B) ;; <CJK>
     (?$(D_y(B . ?\x8E11) ;; <CJK>
     (?$(D_z(B . ?\x8E14) ;; <CJK>
     (?$(D_{(B . ?\x8E16) ;; <CJK>
     (?$(D_|(B . ?\x8E20) ;; <CJK>
     (?$(D_}(B . ?\x8E21) ;; <CJK>
     (?$(D_~(B . ?\x8E22) ;; <CJK>
     (?$(D`!(B . ?\x8E23) ;; <CJK>
     (?$(D`"(B . ?\x8E26) ;; <CJK>
     (?$(D`#(B . ?\x8E27) ;; <CJK>
     (?$(D`$(B . ?\x8E31) ;; <CJK>
     (?$(D`%(B . ?\x8E33) ;; <CJK>
     (?$(D`&(B . ?\x8E36) ;; <CJK>
     (?$(D`'(B . ?\x8E37) ;; <CJK>
     (?$(D`((B . ?\x8E38) ;; <CJK>
     (?$(D`)(B . ?\x8E39) ;; <CJK>
     (?$(D`*(B . ?\x8E3D) ;; <CJK>
     (?$(D`+(B . ?\x8E40) ;; <CJK>
     (?$(D`,(B . ?\x8E41) ;; <CJK>
     (?$(D`-(B . ?\x8E4B) ;; <CJK>
     (?$(D`.(B . ?\x8E4D) ;; <CJK>
     (?$(D`/(B . ?\x8E4E) ;; <CJK>
     (?$(D`0(B . ?\x8E4F) ;; <CJK>
     (?$(D`1(B . ?\x8E54) ;; <CJK>
     (?$(D`2(B . ?\x8E5B) ;; <CJK>
     (?$(D`3(B . ?\x8E5C) ;; <CJK>
     (?$(D`4(B . ?\x8E5D) ;; <CJK>
     (?$(D`5(B . ?\x8E5E) ;; <CJK>
     (?$(D`6(B . ?\x8E61) ;; <CJK>
     (?$(D`7(B . ?\x8E62) ;; <CJK>
     (?$(D`8(B . ?\x8E69) ;; <CJK>
     (?$(D`9(B . ?\x8E6C) ;; <CJK>
     (?$(D`:(B . ?\x8E6D) ;; <CJK>
     (?$(D`;(B . ?\x8E6F) ;; <CJK>
     (?$(D`<(B . ?\x8E70) ;; <CJK>
     (?$(D`=(B . ?\x8E71) ;; <CJK>
     (?$(D`>(B . ?\x8E79) ;; <CJK>
     (?$(D`?(B . ?\x8E7A) ;; <CJK>
     (?$(D`@(B . ?\x8E7B) ;; <CJK>
     (?$(D`A(B . ?\x8E82) ;; <CJK>
     (?$(D`B(B . ?\x8E83) ;; <CJK>
     (?$(D`C(B . ?\x8E89) ;; <CJK>
     (?$(D`D(B . ?\x8E90) ;; <CJK>
     (?$(D`E(B . ?\x8E92) ;; <CJK>
     (?$(D`F(B . ?\x8E95) ;; <CJK>
     (?$(D`G(B . ?\x8E9A) ;; <CJK>
     (?$(D`H(B . ?\x8E9B) ;; <CJK>
     (?$(D`I(B . ?\x8E9D) ;; <CJK>
     (?$(D`J(B . ?\x8E9E) ;; <CJK>
     (?$(D`K(B . ?\x8EA2) ;; <CJK>
     (?$(D`L(B . ?\x8EA7) ;; <CJK>
     (?$(D`M(B . ?\x8EA9) ;; <CJK>
     (?$(D`N(B . ?\x8EAD) ;; <CJK>
     (?$(D`O(B . ?\x8EAE) ;; <CJK>
     (?$(D`P(B . ?\x8EB3) ;; <CJK>
     (?$(D`Q(B . ?\x8EB5) ;; <CJK>
     (?$(D`R(B . ?\x8EBA) ;; <CJK>
     (?$(D`S(B . ?\x8EBB) ;; <CJK>
     (?$(D`T(B . ?\x8EC0) ;; <CJK>
     (?$(D`U(B . ?\x8EC1) ;; <CJK>
     (?$(D`V(B . ?\x8EC3) ;; <CJK>
     (?$(D`W(B . ?\x8EC4) ;; <CJK>
     (?$(D`X(B . ?\x8EC7) ;; <CJK>
     (?$(D`Y(B . ?\x8ECF) ;; <CJK>
     (?$(D`Z(B . ?\x8ED1) ;; <CJK>
     (?$(D`[(B . ?\x8ED4) ;; <CJK>
     (?$(D`\(B . ?\x8EDC) ;; <CJK>
     (?$(D`](B . ?\x8EE8) ;; <CJK>
     (?$(D`^(B . ?\x8EEE) ;; <CJK>
     (?$(D`_(B . ?\x8EF0) ;; <CJK>
     (?$(D``(B . ?\x8EF1) ;; <CJK>
     (?$(D`a(B . ?\x8EF7) ;; <CJK>
     (?$(D`b(B . ?\x8EF9) ;; <CJK>
     (?$(D`c(B . ?\x8EFA) ;; <CJK>
     (?$(D`d(B . ?\x8EED) ;; <CJK>
     (?$(D`e(B . ?\x8F00) ;; <CJK>
     (?$(D`f(B . ?\x8F02) ;; <CJK>
     (?$(D`g(B . ?\x8F07) ;; <CJK>
     (?$(D`h(B . ?\x8F08) ;; <CJK>
     (?$(D`i(B . ?\x8F0F) ;; <CJK>
     (?$(D`j(B . ?\x8F10) ;; <CJK>
     (?$(D`k(B . ?\x8F16) ;; <CJK>
     (?$(D`l(B . ?\x8F17) ;; <CJK>
     (?$(D`m(B . ?\x8F18) ;; <CJK>
     (?$(D`n(B . ?\x8F1E) ;; <CJK>
     (?$(D`o(B . ?\x8F20) ;; <CJK>
     (?$(D`p(B . ?\x8F21) ;; <CJK>
     (?$(D`q(B . ?\x8F23) ;; <CJK>
     (?$(D`r(B . ?\x8F25) ;; <CJK>
     (?$(D`s(B . ?\x8F27) ;; <CJK>
     (?$(D`t(B . ?\x8F28) ;; <CJK>
     (?$(D`u(B . ?\x8F2C) ;; <CJK>
     (?$(D`v(B . ?\x8F2D) ;; <CJK>
     (?$(D`w(B . ?\x8F2E) ;; <CJK>
     (?$(D`x(B . ?\x8F34) ;; <CJK>
     (?$(D`y(B . ?\x8F35) ;; <CJK>
     (?$(D`z(B . ?\x8F36) ;; <CJK>
     (?$(D`{(B . ?\x8F37) ;; <CJK>
     (?$(D`|(B . ?\x8F3A) ;; <CJK>
     (?$(D`}(B . ?\x8F40) ;; <CJK>
     (?$(D`~(B . ?\x8F41) ;; <CJK>
     (?$(Da!(B . ?\x8F43) ;; <CJK>
     (?$(Da"(B . ?\x8F47) ;; <CJK>
     (?$(Da#(B . ?\x8F4F) ;; <CJK>
     (?$(Da$(B . ?\x8F51) ;; <CJK>
     (?$(Da%(B . ?\x8F52) ;; <CJK>
     (?$(Da&(B . ?\x8F53) ;; <CJK>
     (?$(Da'(B . ?\x8F54) ;; <CJK>
     (?$(Da((B . ?\x8F55) ;; <CJK>
     (?$(Da)(B . ?\x8F58) ;; <CJK>
     (?$(Da*(B . ?\x8F5D) ;; <CJK>
     (?$(Da+(B . ?\x8F5E) ;; <CJK>
     (?$(Da,(B . ?\x8F65) ;; <CJK>
     (?$(Da-(B . ?\x8F9D) ;; <CJK>
     (?$(Da.(B . ?\x8FA0) ;; <CJK>
     (?$(Da/(B . ?\x8FA1) ;; <CJK>
     (?$(Da0(B . ?\x8FA4) ;; <CJK>
     (?$(Da1(B . ?\x8FA5) ;; <CJK>
     (?$(Da2(B . ?\x8FA6) ;; <CJK>
     (?$(Da3(B . ?\x8FB5) ;; <CJK>
     (?$(Da4(B . ?\x8FB6) ;; <CJK>
     (?$(Da5(B . ?\x8FB8) ;; <CJK>
     (?$(Da6(B . ?\x8FBE) ;; <CJK>
     (?$(Da7(B . ?\x8FC0) ;; <CJK>
     (?$(Da8(B . ?\x8FC1) ;; <CJK>
     (?$(Da9(B . ?\x8FC6) ;; <CJK>
     (?$(Da:(B . ?\x8FCA) ;; <CJK>
     (?$(Da;(B . ?\x8FCB) ;; <CJK>
     (?$(Da<(B . ?\x8FCD) ;; <CJK>
     (?$(Da=(B . ?\x8FD0) ;; <CJK>
     (?$(Da>(B . ?\x8FD2) ;; <CJK>
     (?$(Da?(B . ?\x8FD3) ;; <CJK>
     (?$(Da@(B . ?\x8FD5) ;; <CJK>
     (?$(DaA(B . ?\x8FE0) ;; <CJK>
     (?$(DaB(B . ?\x8FE3) ;; <CJK>
     (?$(DaC(B . ?\x8FE4) ;; <CJK>
     (?$(DaD(B . ?\x8FE8) ;; <CJK>
     (?$(DaE(B . ?\x8FEE) ;; <CJK>
     (?$(DaF(B . ?\x8FF1) ;; <CJK>
     (?$(DaG(B . ?\x8FF5) ;; <CJK>
     (?$(DaH(B . ?\x8FF6) ;; <CJK>
     (?$(DaI(B . ?\x8FFB) ;; <CJK>
     (?$(DaJ(B . ?\x8FFE) ;; <CJK>
     (?$(DaK(B . ?\x9002) ;; <CJK>
     (?$(DaL(B . ?\x9004) ;; <CJK>
     (?$(DaM(B . ?\x9008) ;; <CJK>
     (?$(DaN(B . ?\x900C) ;; <CJK>
     (?$(DaO(B . ?\x9018) ;; <CJK>
     (?$(DaP(B . ?\x901B) ;; <CJK>
     (?$(DaQ(B . ?\x9028) ;; <CJK>
     (?$(DaR(B . ?\x9029) ;; <CJK>
     (?$(DaS(B . ?\x902F) ;; <CJK>
     (?$(DaT(B . ?\x902A) ;; <CJK>
     (?$(DaU(B . ?\x902C) ;; <CJK>
     (?$(DaV(B . ?\x902D) ;; <CJK>
     (?$(DaW(B . ?\x9033) ;; <CJK>
     (?$(DaX(B . ?\x9034) ;; <CJK>
     (?$(DaY(B . ?\x9037) ;; <CJK>
     (?$(DaZ(B . ?\x903F) ;; <CJK>
     (?$(Da[(B . ?\x9043) ;; <CJK>
     (?$(Da\(B . ?\x9044) ;; <CJK>
     (?$(Da](B . ?\x904C) ;; <CJK>
     (?$(Da^(B . ?\x905B) ;; <CJK>
     (?$(Da_(B . ?\x905D) ;; <CJK>
     (?$(Da`(B . ?\x9062) ;; <CJK>
     (?$(Daa(B . ?\x9066) ;; <CJK>
     (?$(Dab(B . ?\x9067) ;; <CJK>
     (?$(Dac(B . ?\x906C) ;; <CJK>
     (?$(Dad(B . ?\x9070) ;; <CJK>
     (?$(Dae(B . ?\x9074) ;; <CJK>
     (?$(Daf(B . ?\x9079) ;; <CJK>
     (?$(Dag(B . ?\x9085) ;; <CJK>
     (?$(Dah(B . ?\x9088) ;; <CJK>
     (?$(Dai(B . ?\x908B) ;; <CJK>
     (?$(Daj(B . ?\x908C) ;; <CJK>
     (?$(Dak(B . ?\x908E) ;; <CJK>
     (?$(Dal(B . ?\x9090) ;; <CJK>
     (?$(Dam(B . ?\x9095) ;; <CJK>
     (?$(Dan(B . ?\x9097) ;; <CJK>
     (?$(Dao(B . ?\x9098) ;; <CJK>
     (?$(Dap(B . ?\x9099) ;; <CJK>
     (?$(Daq(B . ?\x909B) ;; <CJK>
     (?$(Dar(B . ?\x90A0) ;; <CJK>
     (?$(Das(B . ?\x90A1) ;; <CJK>
     (?$(Dat(B . ?\x90A2) ;; <CJK>
     (?$(Dau(B . ?\x90A5) ;; <CJK>
     (?$(Dav(B . ?\x90B0) ;; <CJK>
     (?$(Daw(B . ?\x90B2) ;; <CJK>
     (?$(Dax(B . ?\x90B3) ;; <CJK>
     (?$(Day(B . ?\x90B4) ;; <CJK>
     (?$(Daz(B . ?\x90B6) ;; <CJK>
     (?$(Da{(B . ?\x90BD) ;; <CJK>
     (?$(Da|(B . ?\x90CC) ;; <CJK>
     (?$(Da}(B . ?\x90BE) ;; <CJK>
     (?$(Da~(B . ?\x90C3) ;; <CJK>
     (?$(Db!(B . ?\x90C4) ;; <CJK>
     (?$(Db"(B . ?\x90C5) ;; <CJK>
     (?$(Db#(B . ?\x90C7) ;; <CJK>
     (?$(Db$(B . ?\x90C8) ;; <CJK>
     (?$(Db%(B . ?\x90D5) ;; <CJK>
     (?$(Db&(B . ?\x90D7) ;; <CJK>
     (?$(Db'(B . ?\x90D8) ;; <CJK>
     (?$(Db((B . ?\x90D9) ;; <CJK>
     (?$(Db)(B . ?\x90DC) ;; <CJK>
     (?$(Db*(B . ?\x90DD) ;; <CJK>
     (?$(Db+(B . ?\x90DF) ;; <CJK>
     (?$(Db,(B . ?\x90E5) ;; <CJK>
     (?$(Db-(B . ?\x90D2) ;; <CJK>
     (?$(Db.(B . ?\x90F6) ;; <CJK>
     (?$(Db/(B . ?\x90EB) ;; <CJK>
     (?$(Db0(B . ?\x90EF) ;; <CJK>
     (?$(Db1(B . ?\x90F0) ;; <CJK>
     (?$(Db2(B . ?\x90F4) ;; <CJK>
     (?$(Db3(B . ?\x90FE) ;; <CJK>
     (?$(Db4(B . ?\x90FF) ;; <CJK>
     (?$(Db5(B . ?\x9100) ;; <CJK>
     (?$(Db6(B . ?\x9104) ;; <CJK>
     (?$(Db7(B . ?\x9105) ;; <CJK>
     (?$(Db8(B . ?\x9106) ;; <CJK>
     (?$(Db9(B . ?\x9108) ;; <CJK>
     (?$(Db:(B . ?\x910D) ;; <CJK>
     (?$(Db;(B . ?\x9110) ;; <CJK>
     (?$(Db<(B . ?\x9114) ;; <CJK>
     (?$(Db=(B . ?\x9116) ;; <CJK>
     (?$(Db>(B . ?\x9117) ;; <CJK>
     (?$(Db?(B . ?\x9118) ;; <CJK>
     (?$(Db@(B . ?\x911A) ;; <CJK>
     (?$(DbA(B . ?\x911C) ;; <CJK>
     (?$(DbB(B . ?\x911E) ;; <CJK>
     (?$(DbC(B . ?\x9120) ;; <CJK>
     (?$(DbD(B . ?\x9125) ;; <CJK>
     (?$(DbE(B . ?\x9122) ;; <CJK>
     (?$(DbF(B . ?\x9123) ;; <CJK>
     (?$(DbG(B . ?\x9127) ;; <CJK>
     (?$(DbH(B . ?\x9129) ;; <CJK>
     (?$(DbI(B . ?\x912E) ;; <CJK>
     (?$(DbJ(B . ?\x912F) ;; <CJK>
     (?$(DbK(B . ?\x9131) ;; <CJK>
     (?$(DbL(B . ?\x9134) ;; <CJK>
     (?$(DbM(B . ?\x9136) ;; <CJK>
     (?$(DbN(B . ?\x9137) ;; <CJK>
     (?$(DbO(B . ?\x9139) ;; <CJK>
     (?$(DbP(B . ?\x913A) ;; <CJK>
     (?$(DbQ(B . ?\x913C) ;; <CJK>
     (?$(DbR(B . ?\x913D) ;; <CJK>
     (?$(DbS(B . ?\x9143) ;; <CJK>
     (?$(DbT(B . ?\x9147) ;; <CJK>
     (?$(DbU(B . ?\x9148) ;; <CJK>
     (?$(DbV(B . ?\x914F) ;; <CJK>
     (?$(DbW(B . ?\x9153) ;; <CJK>
     (?$(DbX(B . ?\x9157) ;; <CJK>
     (?$(DbY(B . ?\x9159) ;; <CJK>
     (?$(DbZ(B . ?\x915A) ;; <CJK>
     (?$(Db[(B . ?\x915B) ;; <CJK>
     (?$(Db\(B . ?\x9161) ;; <CJK>
     (?$(Db](B . ?\x9164) ;; <CJK>
     (?$(Db^(B . ?\x9167) ;; <CJK>
     (?$(Db_(B . ?\x916D) ;; <CJK>
     (?$(Db`(B . ?\x9174) ;; <CJK>
     (?$(Dba(B . ?\x9179) ;; <CJK>
     (?$(Dbb(B . ?\x917A) ;; <CJK>
     (?$(Dbc(B . ?\x917B) ;; <CJK>
     (?$(Dbd(B . ?\x9181) ;; <CJK>
     (?$(Dbe(B . ?\x9183) ;; <CJK>
     (?$(Dbf(B . ?\x9185) ;; <CJK>
     (?$(Dbg(B . ?\x9186) ;; <CJK>
     (?$(Dbh(B . ?\x918A) ;; <CJK>
     (?$(Dbi(B . ?\x918E) ;; <CJK>
     (?$(Dbj(B . ?\x9191) ;; <CJK>
     (?$(Dbk(B . ?\x9193) ;; <CJK>
     (?$(Dbl(B . ?\x9194) ;; <CJK>
     (?$(Dbm(B . ?\x9195) ;; <CJK>
     (?$(Dbn(B . ?\x9198) ;; <CJK>
     (?$(Dbo(B . ?\x919E) ;; <CJK>
     (?$(Dbp(B . ?\x91A1) ;; <CJK>
     (?$(Dbq(B . ?\x91A6) ;; <CJK>
     (?$(Dbr(B . ?\x91A8) ;; <CJK>
     (?$(Dbs(B . ?\x91AC) ;; <CJK>
     (?$(Dbt(B . ?\x91AD) ;; <CJK>
     (?$(Dbu(B . ?\x91AE) ;; <CJK>
     (?$(Dbv(B . ?\x91B0) ;; <CJK>
     (?$(Dbw(B . ?\x91B1) ;; <CJK>
     (?$(Dbx(B . ?\x91B2) ;; <CJK>
     (?$(Dby(B . ?\x91B3) ;; <CJK>
     (?$(Dbz(B . ?\x91B6) ;; <CJK>
     (?$(Db{(B . ?\x91BB) ;; <CJK>
     (?$(Db|(B . ?\x91BC) ;; <CJK>
     (?$(Db}(B . ?\x91BD) ;; <CJK>
     (?$(Db~(B . ?\x91BF) ;; <CJK>
     (?$(Dc!(B . ?\x91C2) ;; <CJK>
     (?$(Dc"(B . ?\x91C3) ;; <CJK>
     (?$(Dc#(B . ?\x91C5) ;; <CJK>
     (?$(Dc$(B . ?\x91D3) ;; <CJK>
     (?$(Dc%(B . ?\x91D4) ;; <CJK>
     (?$(Dc&(B . ?\x91D7) ;; <CJK>
     (?$(Dc'(B . ?\x91D9) ;; <CJK>
     (?$(Dc((B . ?\x91DA) ;; <CJK>
     (?$(Dc)(B . ?\x91DE) ;; <CJK>
     (?$(Dc*(B . ?\x91E4) ;; <CJK>
     (?$(Dc+(B . ?\x91E5) ;; <CJK>
     (?$(Dc,(B . ?\x91E9) ;; <CJK>
     (?$(Dc-(B . ?\x91EA) ;; <CJK>
     (?$(Dc.(B . ?\x91EC) ;; <CJK>
     (?$(Dc/(B . ?\x91ED) ;; <CJK>
     (?$(Dc0(B . ?\x91EE) ;; <CJK>
     (?$(Dc1(B . ?\x91EF) ;; <CJK>
     (?$(Dc2(B . ?\x91F0) ;; <CJK>
     (?$(Dc3(B . ?\x91F1) ;; <CJK>
     (?$(Dc4(B . ?\x91F7) ;; <CJK>
     (?$(Dc5(B . ?\x91F9) ;; <CJK>
     (?$(Dc6(B . ?\x91FB) ;; <CJK>
     (?$(Dc7(B . ?\x91FD) ;; <CJK>
     (?$(Dc8(B . ?\x9200) ;; <CJK>
     (?$(Dc9(B . ?\x9201) ;; <CJK>
     (?$(Dc:(B . ?\x9204) ;; <CJK>
     (?$(Dc;(B . ?\x9205) ;; <CJK>
     (?$(Dc<(B . ?\x9206) ;; <CJK>
     (?$(Dc=(B . ?\x9207) ;; <CJK>
     (?$(Dc>(B . ?\x9209) ;; <CJK>
     (?$(Dc?(B . ?\x920A) ;; <CJK>
     (?$(Dc@(B . ?\x920C) ;; <CJK>
     (?$(DcA(B . ?\x9210) ;; <CJK>
     (?$(DcB(B . ?\x9212) ;; <CJK>
     (?$(DcC(B . ?\x9213) ;; <CJK>
     (?$(DcD(B . ?\x9216) ;; <CJK>
     (?$(DcE(B . ?\x9218) ;; <CJK>
     (?$(DcF(B . ?\x921C) ;; <CJK>
     (?$(DcG(B . ?\x921D) ;; <CJK>
     (?$(DcH(B . ?\x9223) ;; <CJK>
     (?$(DcI(B . ?\x9224) ;; <CJK>
     (?$(DcJ(B . ?\x9225) ;; <CJK>
     (?$(DcK(B . ?\x9226) ;; <CJK>
     (?$(DcL(B . ?\x9228) ;; <CJK>
     (?$(DcM(B . ?\x922E) ;; <CJK>
     (?$(DcN(B . ?\x922F) ;; <CJK>
     (?$(DcO(B . ?\x9230) ;; <CJK>
     (?$(DcP(B . ?\x9233) ;; <CJK>
     (?$(DcQ(B . ?\x9235) ;; <CJK>
     (?$(DcR(B . ?\x9236) ;; <CJK>
     (?$(DcS(B . ?\x9238) ;; <CJK>
     (?$(DcT(B . ?\x9239) ;; <CJK>
     (?$(DcU(B . ?\x923A) ;; <CJK>
     (?$(DcV(B . ?\x923C) ;; <CJK>
     (?$(DcW(B . ?\x923E) ;; <CJK>
     (?$(DcX(B . ?\x9240) ;; <CJK>
     (?$(DcY(B . ?\x9242) ;; <CJK>
     (?$(DcZ(B . ?\x9243) ;; <CJK>
     (?$(Dc[(B . ?\x9246) ;; <CJK>
     (?$(Dc\(B . ?\x9247) ;; <CJK>
     (?$(Dc](B . ?\x924A) ;; <CJK>
     (?$(Dc^(B . ?\x924D) ;; <CJK>
     (?$(Dc_(B . ?\x924E) ;; <CJK>
     (?$(Dc`(B . ?\x924F) ;; <CJK>
     (?$(Dca(B . ?\x9251) ;; <CJK>
     (?$(Dcb(B . ?\x9258) ;; <CJK>
     (?$(Dcc(B . ?\x9259) ;; <CJK>
     (?$(Dcd(B . ?\x925C) ;; <CJK>
     (?$(Dce(B . ?\x925D) ;; <CJK>
     (?$(Dcf(B . ?\x9260) ;; <CJK>
     (?$(Dcg(B . ?\x9261) ;; <CJK>
     (?$(Dch(B . ?\x9265) ;; <CJK>
     (?$(Dci(B . ?\x9267) ;; <CJK>
     (?$(Dcj(B . ?\x9268) ;; <CJK>
     (?$(Dck(B . ?\x9269) ;; <CJK>
     (?$(Dcl(B . ?\x926E) ;; <CJK>
     (?$(Dcm(B . ?\x926F) ;; <CJK>
     (?$(Dcn(B . ?\x9270) ;; <CJK>
     (?$(Dco(B . ?\x9275) ;; <CJK>
     (?$(Dcp(B . ?\x9276) ;; <CJK>
     (?$(Dcq(B . ?\x9277) ;; <CJK>
     (?$(Dcr(B . ?\x9278) ;; <CJK>
     (?$(Dcs(B . ?\x9279) ;; <CJK>
     (?$(Dct(B . ?\x927B) ;; <CJK>
     (?$(Dcu(B . ?\x927C) ;; <CJK>
     (?$(Dcv(B . ?\x927D) ;; <CJK>
     (?$(Dcw(B . ?\x927F) ;; <CJK>
     (?$(Dcx(B . ?\x9288) ;; <CJK>
     (?$(Dcy(B . ?\x9289) ;; <CJK>
     (?$(Dcz(B . ?\x928A) ;; <CJK>
     (?$(Dc{(B . ?\x928D) ;; <CJK>
     (?$(Dc|(B . ?\x928E) ;; <CJK>
     (?$(Dc}(B . ?\x9292) ;; <CJK>
     (?$(Dc~(B . ?\x9297) ;; <CJK>
     (?$(Dd!(B . ?\x9299) ;; <CJK>
     (?$(Dd"(B . ?\x929F) ;; <CJK>
     (?$(Dd#(B . ?\x92A0) ;; <CJK>
     (?$(Dd$(B . ?\x92A4) ;; <CJK>
     (?$(Dd%(B . ?\x92A5) ;; <CJK>
     (?$(Dd&(B . ?\x92A7) ;; <CJK>
     (?$(Dd'(B . ?\x92A8) ;; <CJK>
     (?$(Dd((B . ?\x92AB) ;; <CJK>
     (?$(Dd)(B . ?\x92AF) ;; <CJK>
     (?$(Dd*(B . ?\x92B2) ;; <CJK>
     (?$(Dd+(B . ?\x92B6) ;; <CJK>
     (?$(Dd,(B . ?\x92B8) ;; <CJK>
     (?$(Dd-(B . ?\x92BA) ;; <CJK>
     (?$(Dd.(B . ?\x92BB) ;; <CJK>
     (?$(Dd/(B . ?\x92BC) ;; <CJK>
     (?$(Dd0(B . ?\x92BD) ;; <CJK>
     (?$(Dd1(B . ?\x92BF) ;; <CJK>
     (?$(Dd2(B . ?\x92C0) ;; <CJK>
     (?$(Dd3(B . ?\x92C1) ;; <CJK>
     (?$(Dd4(B . ?\x92C2) ;; <CJK>
     (?$(Dd5(B . ?\x92C3) ;; <CJK>
     (?$(Dd6(B . ?\x92C5) ;; <CJK>
     (?$(Dd7(B . ?\x92C6) ;; <CJK>
     (?$(Dd8(B . ?\x92C7) ;; <CJK>
     (?$(Dd9(B . ?\x92C8) ;; <CJK>
     (?$(Dd:(B . ?\x92CB) ;; <CJK>
     (?$(Dd;(B . ?\x92CC) ;; <CJK>
     (?$(Dd<(B . ?\x92CD) ;; <CJK>
     (?$(Dd=(B . ?\x92CE) ;; <CJK>
     (?$(Dd>(B . ?\x92D0) ;; <CJK>
     (?$(Dd?(B . ?\x92D3) ;; <CJK>
     (?$(Dd@(B . ?\x92D5) ;; <CJK>
     (?$(DdA(B . ?\x92D7) ;; <CJK>
     (?$(DdB(B . ?\x92D8) ;; <CJK>
     (?$(DdC(B . ?\x92D9) ;; <CJK>
     (?$(DdD(B . ?\x92DC) ;; <CJK>
     (?$(DdE(B . ?\x92DD) ;; <CJK>
     (?$(DdF(B . ?\x92DF) ;; <CJK>
     (?$(DdG(B . ?\x92E0) ;; <CJK>
     (?$(DdH(B . ?\x92E1) ;; <CJK>
     (?$(DdI(B . ?\x92E3) ;; <CJK>
     (?$(DdJ(B . ?\x92E5) ;; <CJK>
     (?$(DdK(B . ?\x92E7) ;; <CJK>
     (?$(DdL(B . ?\x92E8) ;; <CJK>
     (?$(DdM(B . ?\x92EC) ;; <CJK>
     (?$(DdN(B . ?\x92EE) ;; <CJK>
     (?$(DdO(B . ?\x92F0) ;; <CJK>
     (?$(DdP(B . ?\x92F9) ;; <CJK>
     (?$(DdQ(B . ?\x92FB) ;; <CJK>
     (?$(DdR(B . ?\x92FF) ;; <CJK>
     (?$(DdS(B . ?\x9300) ;; <CJK>
     (?$(DdT(B . ?\x9302) ;; <CJK>
     (?$(DdU(B . ?\x9308) ;; <CJK>
     (?$(DdV(B . ?\x930D) ;; <CJK>
     (?$(DdW(B . ?\x9311) ;; <CJK>
     (?$(DdX(B . ?\x9314) ;; <CJK>
     (?$(DdY(B . ?\x9315) ;; <CJK>
     (?$(DdZ(B . ?\x931C) ;; <CJK>
     (?$(Dd[(B . ?\x931D) ;; <CJK>
     (?$(Dd\(B . ?\x931E) ;; <CJK>
     (?$(Dd](B . ?\x931F) ;; <CJK>
     (?$(Dd^(B . ?\x9321) ;; <CJK>
     (?$(Dd_(B . ?\x9324) ;; <CJK>
     (?$(Dd`(B . ?\x9325) ;; <CJK>
     (?$(Dda(B . ?\x9327) ;; <CJK>
     (?$(Ddb(B . ?\x9329) ;; <CJK>
     (?$(Ddc(B . ?\x932A) ;; <CJK>
     (?$(Ddd(B . ?\x9333) ;; <CJK>
     (?$(Dde(B . ?\x9334) ;; <CJK>
     (?$(Ddf(B . ?\x9336) ;; <CJK>
     (?$(Ddg(B . ?\x9337) ;; <CJK>
     (?$(Ddh(B . ?\x9347) ;; <CJK>
     (?$(Ddi(B . ?\x9348) ;; <CJK>
     (?$(Ddj(B . ?\x9349) ;; <CJK>
     (?$(Ddk(B . ?\x9350) ;; <CJK>
     (?$(Ddl(B . ?\x9351) ;; <CJK>
     (?$(Ddm(B . ?\x9352) ;; <CJK>
     (?$(Ddn(B . ?\x9355) ;; <CJK>
     (?$(Ddo(B . ?\x9357) ;; <CJK>
     (?$(Ddp(B . ?\x9358) ;; <CJK>
     (?$(Ddq(B . ?\x935A) ;; <CJK>
     (?$(Ddr(B . ?\x935E) ;; <CJK>
     (?$(Dds(B . ?\x9364) ;; <CJK>
     (?$(Ddt(B . ?\x9365) ;; <CJK>
     (?$(Ddu(B . ?\x9367) ;; <CJK>
     (?$(Ddv(B . ?\x9369) ;; <CJK>
     (?$(Ddw(B . ?\x936A) ;; <CJK>
     (?$(Ddx(B . ?\x936D) ;; <CJK>
     (?$(Ddy(B . ?\x936F) ;; <CJK>
     (?$(Ddz(B . ?\x9370) ;; <CJK>
     (?$(Dd{(B . ?\x9371) ;; <CJK>
     (?$(Dd|(B . ?\x9373) ;; <CJK>
     (?$(Dd}(B . ?\x9374) ;; <CJK>
     (?$(Dd~(B . ?\x9376) ;; <CJK>
     (?$(De!(B . ?\x937A) ;; <CJK>
     (?$(De"(B . ?\x937D) ;; <CJK>
     (?$(De#(B . ?\x937F) ;; <CJK>
     (?$(De$(B . ?\x9380) ;; <CJK>
     (?$(De%(B . ?\x9381) ;; <CJK>
     (?$(De&(B . ?\x9382) ;; <CJK>
     (?$(De'(B . ?\x9388) ;; <CJK>
     (?$(De((B . ?\x938A) ;; <CJK>
     (?$(De)(B . ?\x938B) ;; <CJK>
     (?$(De*(B . ?\x938D) ;; <CJK>
     (?$(De+(B . ?\x938F) ;; <CJK>
     (?$(De,(B . ?\x9392) ;; <CJK>
     (?$(De-(B . ?\x9395) ;; <CJK>
     (?$(De.(B . ?\x9398) ;; <CJK>
     (?$(De/(B . ?\x939B) ;; <CJK>
     (?$(De0(B . ?\x939E) ;; <CJK>
     (?$(De1(B . ?\x93A1) ;; <CJK>
     (?$(De2(B . ?\x93A3) ;; <CJK>
     (?$(De3(B . ?\x93A4) ;; <CJK>
     (?$(De4(B . ?\x93A6) ;; <CJK>
     (?$(De5(B . ?\x93A8) ;; <CJK>
     (?$(De6(B . ?\x93AB) ;; <CJK>
     (?$(De7(B . ?\x93B4) ;; <CJK>
     (?$(De8(B . ?\x93B5) ;; <CJK>
     (?$(De9(B . ?\x93B6) ;; <CJK>
     (?$(De:(B . ?\x93BA) ;; <CJK>
     (?$(De;(B . ?\x93A9) ;; <CJK>
     (?$(De<(B . ?\x93C1) ;; <CJK>
     (?$(De=(B . ?\x93C4) ;; <CJK>
     (?$(De>(B . ?\x93C5) ;; <CJK>
     (?$(De?(B . ?\x93C6) ;; <CJK>
     (?$(De@(B . ?\x93C7) ;; <CJK>
     (?$(DeA(B . ?\x93C9) ;; <CJK>
     (?$(DeB(B . ?\x93CA) ;; <CJK>
     (?$(DeC(B . ?\x93CB) ;; <CJK>
     (?$(DeD(B . ?\x93CC) ;; <CJK>
     (?$(DeE(B . ?\x93CD) ;; <CJK>
     (?$(DeF(B . ?\x93D3) ;; <CJK>
     (?$(DeG(B . ?\x93D9) ;; <CJK>
     (?$(DeH(B . ?\x93DC) ;; <CJK>
     (?$(DeI(B . ?\x93DE) ;; <CJK>
     (?$(DeJ(B . ?\x93DF) ;; <CJK>
     (?$(DeK(B . ?\x93E2) ;; <CJK>
     (?$(DeL(B . ?\x93E6) ;; <CJK>
     (?$(DeM(B . ?\x93E7) ;; <CJK>
     (?$(DeN(B . ?\x93F9) ;; <CJK>
     (?$(DeO(B . ?\x93F7) ;; <CJK>
     (?$(DeP(B . ?\x93F8) ;; <CJK>
     (?$(DeQ(B . ?\x93FA) ;; <CJK>
     (?$(DeR(B . ?\x93FB) ;; <CJK>
     (?$(DeS(B . ?\x93FD) ;; <CJK>
     (?$(DeT(B . ?\x9401) ;; <CJK>
     (?$(DeU(B . ?\x9402) ;; <CJK>
     (?$(DeV(B . ?\x9404) ;; <CJK>
     (?$(DeW(B . ?\x9408) ;; <CJK>
     (?$(DeX(B . ?\x9409) ;; <CJK>
     (?$(DeY(B . ?\x940D) ;; <CJK>
     (?$(DeZ(B . ?\x940E) ;; <CJK>
     (?$(De[(B . ?\x940F) ;; <CJK>
     (?$(De\(B . ?\x9415) ;; <CJK>
     (?$(De](B . ?\x9416) ;; <CJK>
     (?$(De^(B . ?\x9417) ;; <CJK>
     (?$(De_(B . ?\x941F) ;; <CJK>
     (?$(De`(B . ?\x942E) ;; <CJK>
     (?$(Dea(B . ?\x942F) ;; <CJK>
     (?$(Deb(B . ?\x9431) ;; <CJK>
     (?$(Dec(B . ?\x9432) ;; <CJK>
     (?$(Ded(B . ?\x9433) ;; <CJK>
     (?$(Dee(B . ?\x9434) ;; <CJK>
     (?$(Def(B . ?\x943B) ;; <CJK>
     (?$(Deg(B . ?\x943F) ;; <CJK>
     (?$(Deh(B . ?\x943D) ;; <CJK>
     (?$(Dei(B . ?\x9443) ;; <CJK>
     (?$(Dej(B . ?\x9445) ;; <CJK>
     (?$(Dek(B . ?\x9448) ;; <CJK>
     (?$(Del(B . ?\x944A) ;; <CJK>
     (?$(Dem(B . ?\x944C) ;; <CJK>
     (?$(Den(B . ?\x9455) ;; <CJK>
     (?$(Deo(B . ?\x9459) ;; <CJK>
     (?$(Dep(B . ?\x945C) ;; <CJK>
     (?$(Deq(B . ?\x945F) ;; <CJK>
     (?$(Der(B . ?\x9461) ;; <CJK>
     (?$(Des(B . ?\x9463) ;; <CJK>
     (?$(Det(B . ?\x9468) ;; <CJK>
     (?$(Deu(B . ?\x946B) ;; <CJK>
     (?$(Dev(B . ?\x946D) ;; <CJK>
     (?$(Dew(B . ?\x946E) ;; <CJK>
     (?$(Dex(B . ?\x946F) ;; <CJK>
     (?$(Dey(B . ?\x9471) ;; <CJK>
     (?$(Dez(B . ?\x9472) ;; <CJK>
     (?$(De{(B . ?\x9484) ;; <CJK>
     (?$(De|(B . ?\x9483) ;; <CJK>
     (?$(De}(B . ?\x9578) ;; <CJK>
     (?$(De~(B . ?\x9579) ;; <CJK>
     (?$(Df!(B . ?\x957E) ;; <CJK>
     (?$(Df"(B . ?\x9584) ;; <CJK>
     (?$(Df#(B . ?\x9588) ;; <CJK>
     (?$(Df$(B . ?\x958C) ;; <CJK>
     (?$(Df%(B . ?\x958D) ;; <CJK>
     (?$(Df&(B . ?\x958E) ;; <CJK>
     (?$(Df'(B . ?\x959D) ;; <CJK>
     (?$(Df((B . ?\x959E) ;; <CJK>
     (?$(Df)(B . ?\x959F) ;; <CJK>
     (?$(Df*(B . ?\x95A1) ;; <CJK>
     (?$(Df+(B . ?\x95A6) ;; <CJK>
     (?$(Df,(B . ?\x95A9) ;; <CJK>
     (?$(Df-(B . ?\x95AB) ;; <CJK>
     (?$(Df.(B . ?\x95AC) ;; <CJK>
     (?$(Df/(B . ?\x95B4) ;; <CJK>
     (?$(Df0(B . ?\x95B6) ;; <CJK>
     (?$(Df1(B . ?\x95BA) ;; <CJK>
     (?$(Df2(B . ?\x95BD) ;; <CJK>
     (?$(Df3(B . ?\x95BF) ;; <CJK>
     (?$(Df4(B . ?\x95C6) ;; <CJK>
     (?$(Df5(B . ?\x95C8) ;; <CJK>
     (?$(Df6(B . ?\x95C9) ;; <CJK>
     (?$(Df7(B . ?\x95CB) ;; <CJK>
     (?$(Df8(B . ?\x95D0) ;; <CJK>
     (?$(Df9(B . ?\x95D1) ;; <CJK>
     (?$(Df:(B . ?\x95D2) ;; <CJK>
     (?$(Df;(B . ?\x95D3) ;; <CJK>
     (?$(Df<(B . ?\x95D9) ;; <CJK>
     (?$(Df=(B . ?\x95DA) ;; <CJK>
     (?$(Df>(B . ?\x95DD) ;; <CJK>
     (?$(Df?(B . ?\x95DE) ;; <CJK>
     (?$(Df@(B . ?\x95DF) ;; <CJK>
     (?$(DfA(B . ?\x95E0) ;; <CJK>
     (?$(DfB(B . ?\x95E4) ;; <CJK>
     (?$(DfC(B . ?\x95E6) ;; <CJK>
     (?$(DfD(B . ?\x961D) ;; <CJK>
     (?$(DfE(B . ?\x961E) ;; <CJK>
     (?$(DfF(B . ?\x9622) ;; <CJK>
     (?$(DfG(B . ?\x9624) ;; <CJK>
     (?$(DfH(B . ?\x9625) ;; <CJK>
     (?$(DfI(B . ?\x9626) ;; <CJK>
     (?$(DfJ(B . ?\x962C) ;; <CJK>
     (?$(DfK(B . ?\x9631) ;; <CJK>
     (?$(DfL(B . ?\x9633) ;; <CJK>
     (?$(DfM(B . ?\x9637) ;; <CJK>
     (?$(DfN(B . ?\x9638) ;; <CJK>
     (?$(DfO(B . ?\x9639) ;; <CJK>
     (?$(DfP(B . ?\x963A) ;; <CJK>
     (?$(DfQ(B . ?\x963C) ;; <CJK>
     (?$(DfR(B . ?\x963D) ;; <CJK>
     (?$(DfS(B . ?\x9641) ;; <CJK>
     (?$(DfT(B . ?\x9652) ;; <CJK>
     (?$(DfU(B . ?\x9654) ;; <CJK>
     (?$(DfV(B . ?\x9656) ;; <CJK>
     (?$(DfW(B . ?\x9657) ;; <CJK>
     (?$(DfX(B . ?\x9658) ;; <CJK>
     (?$(DfY(B . ?\x9661) ;; <CJK>
     (?$(DfZ(B . ?\x966E) ;; <CJK>
     (?$(Df[(B . ?\x9674) ;; <CJK>
     (?$(Df\(B . ?\x967B) ;; <CJK>
     (?$(Df](B . ?\x967C) ;; <CJK>
     (?$(Df^(B . ?\x967E) ;; <CJK>
     (?$(Df_(B . ?\x967F) ;; <CJK>
     (?$(Df`(B . ?\x9681) ;; <CJK>
     (?$(Dfa(B . ?\x9682) ;; <CJK>
     (?$(Dfb(B . ?\x9683) ;; <CJK>
     (?$(Dfc(B . ?\x9684) ;; <CJK>
     (?$(Dfd(B . ?\x9689) ;; <CJK>
     (?$(Dfe(B . ?\x9691) ;; <CJK>
     (?$(Dff(B . ?\x9696) ;; <CJK>
     (?$(Dfg(B . ?\x969A) ;; <CJK>
     (?$(Dfh(B . ?\x969D) ;; <CJK>
     (?$(Dfi(B . ?\x969F) ;; <CJK>
     (?$(Dfj(B . ?\x96A4) ;; <CJK>
     (?$(Dfk(B . ?\x96A5) ;; <CJK>
     (?$(Dfl(B . ?\x96A6) ;; <CJK>
     (?$(Dfm(B . ?\x96A9) ;; <CJK>
     (?$(Dfn(B . ?\x96AE) ;; <CJK>
     (?$(Dfo(B . ?\x96AF) ;; <CJK>
     (?$(Dfp(B . ?\x96B3) ;; <CJK>
     (?$(Dfq(B . ?\x96BA) ;; <CJK>
     (?$(Dfr(B . ?\x96CA) ;; <CJK>
     (?$(Dfs(B . ?\x96D2) ;; <CJK>
     (?$(Dft(B . ?\x5DB2) ;; <CJK>
     (?$(Dfu(B . ?\x96D8) ;; <CJK>
     (?$(Dfv(B . ?\x96DA) ;; <CJK>
     (?$(Dfw(B . ?\x96DD) ;; <CJK>
     (?$(Dfx(B . ?\x96DE) ;; <CJK>
     (?$(Dfy(B . ?\x96DF) ;; <CJK>
     (?$(Dfz(B . ?\x96E9) ;; <CJK>
     (?$(Df{(B . ?\x96EF) ;; <CJK>
     (?$(Df|(B . ?\x96F1) ;; <CJK>
     (?$(Df}(B . ?\x96FA) ;; <CJK>
     (?$(Df~(B . ?\x9702) ;; <CJK>
     (?$(Dg!(B . ?\x9703) ;; <CJK>
     (?$(Dg"(B . ?\x9705) ;; <CJK>
     (?$(Dg#(B . ?\x9709) ;; <CJK>
     (?$(Dg$(B . ?\x971A) ;; <CJK>
     (?$(Dg%(B . ?\x971B) ;; <CJK>
     (?$(Dg&(B . ?\x971D) ;; <CJK>
     (?$(Dg'(B . ?\x9721) ;; <CJK>
     (?$(Dg((B . ?\x9722) ;; <CJK>
     (?$(Dg)(B . ?\x9723) ;; <CJK>
     (?$(Dg*(B . ?\x9728) ;; <CJK>
     (?$(Dg+(B . ?\x9731) ;; <CJK>
     (?$(Dg,(B . ?\x9733) ;; <CJK>
     (?$(Dg-(B . ?\x9741) ;; <CJK>
     (?$(Dg.(B . ?\x9743) ;; <CJK>
     (?$(Dg/(B . ?\x974A) ;; <CJK>
     (?$(Dg0(B . ?\x974E) ;; <CJK>
     (?$(Dg1(B . ?\x974F) ;; <CJK>
     (?$(Dg2(B . ?\x9755) ;; <CJK>
     (?$(Dg3(B . ?\x9757) ;; <CJK>
     (?$(Dg4(B . ?\x9758) ;; <CJK>
     (?$(Dg5(B . ?\x975A) ;; <CJK>
     (?$(Dg6(B . ?\x975B) ;; <CJK>
     (?$(Dg7(B . ?\x9763) ;; <CJK>
     (?$(Dg8(B . ?\x9767) ;; <CJK>
     (?$(Dg9(B . ?\x976A) ;; <CJK>
     (?$(Dg:(B . ?\x976E) ;; <CJK>
     (?$(Dg;(B . ?\x9773) ;; <CJK>
     (?$(Dg<(B . ?\x9776) ;; <CJK>
     (?$(Dg=(B . ?\x9777) ;; <CJK>
     (?$(Dg>(B . ?\x9778) ;; <CJK>
     (?$(Dg?(B . ?\x977B) ;; <CJK>
     (?$(Dg@(B . ?\x977D) ;; <CJK>
     (?$(DgA(B . ?\x977F) ;; <CJK>
     (?$(DgB(B . ?\x9780) ;; <CJK>
     (?$(DgC(B . ?\x9789) ;; <CJK>
     (?$(DgD(B . ?\x9795) ;; <CJK>
     (?$(DgE(B . ?\x9796) ;; <CJK>
     (?$(DgF(B . ?\x9797) ;; <CJK>
     (?$(DgG(B . ?\x9799) ;; <CJK>
     (?$(DgH(B . ?\x979A) ;; <CJK>
     (?$(DgI(B . ?\x979E) ;; <CJK>
     (?$(DgJ(B . ?\x979F) ;; <CJK>
     (?$(DgK(B . ?\x97A2) ;; <CJK>
     (?$(DgL(B . ?\x97AC) ;; <CJK>
     (?$(DgM(B . ?\x97AE) ;; <CJK>
     (?$(DgN(B . ?\x97B1) ;; <CJK>
     (?$(DgO(B . ?\x97B2) ;; <CJK>
     (?$(DgP(B . ?\x97B5) ;; <CJK>
     (?$(DgQ(B . ?\x97B6) ;; <CJK>
     (?$(DgR(B . ?\x97B8) ;; <CJK>
     (?$(DgS(B . ?\x97B9) ;; <CJK>
     (?$(DgT(B . ?\x97BA) ;; <CJK>
     (?$(DgU(B . ?\x97BC) ;; <CJK>
     (?$(DgV(B . ?\x97BE) ;; <CJK>
     (?$(DgW(B . ?\x97BF) ;; <CJK>
     (?$(DgX(B . ?\x97C1) ;; <CJK>
     (?$(DgY(B . ?\x97C4) ;; <CJK>
     (?$(DgZ(B . ?\x97C5) ;; <CJK>
     (?$(Dg[(B . ?\x97C7) ;; <CJK>
     (?$(Dg\(B . ?\x97C9) ;; <CJK>
     (?$(Dg](B . ?\x97CA) ;; <CJK>
     (?$(Dg^(B . ?\x97CC) ;; <CJK>
     (?$(Dg_(B . ?\x97CD) ;; <CJK>
     (?$(Dg`(B . ?\x97CE) ;; <CJK>
     (?$(Dga(B . ?\x97D0) ;; <CJK>
     (?$(Dgb(B . ?\x97D1) ;; <CJK>
     (?$(Dgc(B . ?\x97D4) ;; <CJK>
     (?$(Dgd(B . ?\x97D7) ;; <CJK>
     (?$(Dge(B . ?\x97D8) ;; <CJK>
     (?$(Dgf(B . ?\x97D9) ;; <CJK>
     (?$(Dgg(B . ?\x97DD) ;; <CJK>
     (?$(Dgh(B . ?\x97DE) ;; <CJK>
     (?$(Dgi(B . ?\x97E0) ;; <CJK>
     (?$(Dgj(B . ?\x97DB) ;; <CJK>
     (?$(Dgk(B . ?\x97E1) ;; <CJK>
     (?$(Dgl(B . ?\x97E4) ;; <CJK>
     (?$(Dgm(B . ?\x97EF) ;; <CJK>
     (?$(Dgn(B . ?\x97F1) ;; <CJK>
     (?$(Dgo(B . ?\x97F4) ;; <CJK>
     (?$(Dgp(B . ?\x97F7) ;; <CJK>
     (?$(Dgq(B . ?\x97F8) ;; <CJK>
     (?$(Dgr(B . ?\x97FA) ;; <CJK>
     (?$(Dgs(B . ?\x9807) ;; <CJK>
     (?$(Dgt(B . ?\x980A) ;; <CJK>
     (?$(Dgu(B . ?\x9819) ;; <CJK>
     (?$(Dgv(B . ?\x980D) ;; <CJK>
     (?$(Dgw(B . ?\x980E) ;; <CJK>
     (?$(Dgx(B . ?\x9814) ;; <CJK>
     (?$(Dgy(B . ?\x9816) ;; <CJK>
     (?$(Dgz(B . ?\x981C) ;; <CJK>
     (?$(Dg{(B . ?\x981E) ;; <CJK>
     (?$(Dg|(B . ?\x9820) ;; <CJK>
     (?$(Dg}(B . ?\x9823) ;; <CJK>
     (?$(Dg~(B . ?\x9826) ;; <CJK>
     (?$(Dh!(B . ?\x982B) ;; <CJK>
     (?$(Dh"(B . ?\x982E) ;; <CJK>
     (?$(Dh#(B . ?\x982F) ;; <CJK>
     (?$(Dh$(B . ?\x9830) ;; <CJK>
     (?$(Dh%(B . ?\x9832) ;; <CJK>
     (?$(Dh&(B . ?\x9833) ;; <CJK>
     (?$(Dh'(B . ?\x9835) ;; <CJK>
     (?$(Dh((B . ?\x9825) ;; <CJK>
     (?$(Dh)(B . ?\x983E) ;; <CJK>
     (?$(Dh*(B . ?\x9844) ;; <CJK>
     (?$(Dh+(B . ?\x9847) ;; <CJK>
     (?$(Dh,(B . ?\x984A) ;; <CJK>
     (?$(Dh-(B . ?\x9851) ;; <CJK>
     (?$(Dh.(B . ?\x9852) ;; <CJK>
     (?$(Dh/(B . ?\x9853) ;; <CJK>
     (?$(Dh0(B . ?\x9856) ;; <CJK>
     (?$(Dh1(B . ?\x9857) ;; <CJK>
     (?$(Dh2(B . ?\x9859) ;; <CJK>
     (?$(Dh3(B . ?\x985A) ;; <CJK>
     (?$(Dh4(B . ?\x9862) ;; <CJK>
     (?$(Dh5(B . ?\x9863) ;; <CJK>
     (?$(Dh6(B . ?\x9865) ;; <CJK>
     (?$(Dh7(B . ?\x9866) ;; <CJK>
     (?$(Dh8(B . ?\x986A) ;; <CJK>
     (?$(Dh9(B . ?\x986C) ;; <CJK>
     (?$(Dh:(B . ?\x98AB) ;; <CJK>
     (?$(Dh;(B . ?\x98AD) ;; <CJK>
     (?$(Dh<(B . ?\x98AE) ;; <CJK>
     (?$(Dh=(B . ?\x98B0) ;; <CJK>
     (?$(Dh>(B . ?\x98B4) ;; <CJK>
     (?$(Dh?(B . ?\x98B7) ;; <CJK>
     (?$(Dh@(B . ?\x98B8) ;; <CJK>
     (?$(DhA(B . ?\x98BA) ;; <CJK>
     (?$(DhB(B . ?\x98BB) ;; <CJK>
     (?$(DhC(B . ?\x98BF) ;; <CJK>
     (?$(DhD(B . ?\x98C2) ;; <CJK>
     (?$(DhE(B . ?\x98C5) ;; <CJK>
     (?$(DhF(B . ?\x98C8) ;; <CJK>
     (?$(DhG(B . ?\x98CC) ;; <CJK>
     (?$(DhH(B . ?\x98E1) ;; <CJK>
     (?$(DhI(B . ?\x98E3) ;; <CJK>
     (?$(DhJ(B . ?\x98E5) ;; <CJK>
     (?$(DhK(B . ?\x98E6) ;; <CJK>
     (?$(DhL(B . ?\x98E7) ;; <CJK>
     (?$(DhM(B . ?\x98EA) ;; <CJK>
     (?$(DhN(B . ?\x98F3) ;; <CJK>
     (?$(DhO(B . ?\x98F6) ;; <CJK>
     (?$(DhP(B . ?\x9902) ;; <CJK>
     (?$(DhQ(B . ?\x9907) ;; <CJK>
     (?$(DhR(B . ?\x9908) ;; <CJK>
     (?$(DhS(B . ?\x9911) ;; <CJK>
     (?$(DhT(B . ?\x9915) ;; <CJK>
     (?$(DhU(B . ?\x9916) ;; <CJK>
     (?$(DhV(B . ?\x9917) ;; <CJK>
     (?$(DhW(B . ?\x991A) ;; <CJK>
     (?$(DhX(B . ?\x991B) ;; <CJK>
     (?$(DhY(B . ?\x991C) ;; <CJK>
     (?$(DhZ(B . ?\x991F) ;; <CJK>
     (?$(Dh[(B . ?\x9922) ;; <CJK>
     (?$(Dh\(B . ?\x9926) ;; <CJK>
     (?$(Dh](B . ?\x9927) ;; <CJK>
     (?$(Dh^(B . ?\x992B) ;; <CJK>
     (?$(Dh_(B . ?\x9931) ;; <CJK>
     (?$(Dh`(B . ?\x9932) ;; <CJK>
     (?$(Dha(B . ?\x9933) ;; <CJK>
     (?$(Dhb(B . ?\x9934) ;; <CJK>
     (?$(Dhc(B . ?\x9935) ;; <CJK>
     (?$(Dhd(B . ?\x9939) ;; <CJK>
     (?$(Dhe(B . ?\x993A) ;; <CJK>
     (?$(Dhf(B . ?\x993B) ;; <CJK>
     (?$(Dhg(B . ?\x993C) ;; <CJK>
     (?$(Dhh(B . ?\x9940) ;; <CJK>
     (?$(Dhi(B . ?\x9941) ;; <CJK>
     (?$(Dhj(B . ?\x9946) ;; <CJK>
     (?$(Dhk(B . ?\x9947) ;; <CJK>
     (?$(Dhl(B . ?\x9948) ;; <CJK>
     (?$(Dhm(B . ?\x994D) ;; <CJK>
     (?$(Dhn(B . ?\x994E) ;; <CJK>
     (?$(Dho(B . ?\x9954) ;; <CJK>
     (?$(Dhp(B . ?\x9958) ;; <CJK>
     (?$(Dhq(B . ?\x9959) ;; <CJK>
     (?$(Dhr(B . ?\x995B) ;; <CJK>
     (?$(Dhs(B . ?\x995C) ;; <CJK>
     (?$(Dht(B . ?\x995E) ;; <CJK>
     (?$(Dhu(B . ?\x995F) ;; <CJK>
     (?$(Dhv(B . ?\x9960) ;; <CJK>
     (?$(Dhw(B . ?\x999B) ;; <CJK>
     (?$(Dhx(B . ?\x999D) ;; <CJK>
     (?$(Dhy(B . ?\x999F) ;; <CJK>
     (?$(Dhz(B . ?\x99A6) ;; <CJK>
     (?$(Dh{(B . ?\x99B0) ;; <CJK>
     (?$(Dh|(B . ?\x99B1) ;; <CJK>
     (?$(Dh}(B . ?\x99B2) ;; <CJK>
     (?$(Dh~(B . ?\x99B5) ;; <CJK>
     (?$(Di!(B . ?\x99B9) ;; <CJK>
     (?$(Di"(B . ?\x99BA) ;; <CJK>
     (?$(Di#(B . ?\x99BD) ;; <CJK>
     (?$(Di$(B . ?\x99BF) ;; <CJK>
     (?$(Di%(B . ?\x99C3) ;; <CJK>
     (?$(Di&(B . ?\x99C9) ;; <CJK>
     (?$(Di'(B . ?\x99D3) ;; <CJK>
     (?$(Di((B . ?\x99D4) ;; <CJK>
     (?$(Di)(B . ?\x99D9) ;; <CJK>
     (?$(Di*(B . ?\x99DA) ;; <CJK>
     (?$(Di+(B . ?\x99DC) ;; <CJK>
     (?$(Di,(B . ?\x99DE) ;; <CJK>
     (?$(Di-(B . ?\x99E7) ;; <CJK>
     (?$(Di.(B . ?\x99EA) ;; <CJK>
     (?$(Di/(B . ?\x99EB) ;; <CJK>
     (?$(Di0(B . ?\x99EC) ;; <CJK>
     (?$(Di1(B . ?\x99F0) ;; <CJK>
     (?$(Di2(B . ?\x99F4) ;; <CJK>
     (?$(Di3(B . ?\x99F5) ;; <CJK>
     (?$(Di4(B . ?\x99F9) ;; <CJK>
     (?$(Di5(B . ?\x99FD) ;; <CJK>
     (?$(Di6(B . ?\x99FE) ;; <CJK>
     (?$(Di7(B . ?\x9A02) ;; <CJK>
     (?$(Di8(B . ?\x9A03) ;; <CJK>
     (?$(Di9(B . ?\x9A04) ;; <CJK>
     (?$(Di:(B . ?\x9A0B) ;; <CJK>
     (?$(Di;(B . ?\x9A0C) ;; <CJK>
     (?$(Di<(B . ?\x9A10) ;; <CJK>
     (?$(Di=(B . ?\x9A11) ;; <CJK>
     (?$(Di>(B . ?\x9A16) ;; <CJK>
     (?$(Di?(B . ?\x9A1E) ;; <CJK>
     (?$(Di@(B . ?\x9A20) ;; <CJK>
     (?$(DiA(B . ?\x9A22) ;; <CJK>
     (?$(DiB(B . ?\x9A23) ;; <CJK>
     (?$(DiC(B . ?\x9A24) ;; <CJK>
     (?$(DiD(B . ?\x9A27) ;; <CJK>
     (?$(DiE(B . ?\x9A2D) ;; <CJK>
     (?$(DiF(B . ?\x9A2E) ;; <CJK>
     (?$(DiG(B . ?\x9A33) ;; <CJK>
     (?$(DiH(B . ?\x9A35) ;; <CJK>
     (?$(DiI(B . ?\x9A36) ;; <CJK>
     (?$(DiJ(B . ?\x9A38) ;; <CJK>
     (?$(DiK(B . ?\x9A47) ;; <CJK>
     (?$(DiL(B . ?\x9A41) ;; <CJK>
     (?$(DiM(B . ?\x9A44) ;; <CJK>
     (?$(DiN(B . ?\x9A4A) ;; <CJK>
     (?$(DiO(B . ?\x9A4B) ;; <CJK>
     (?$(DiP(B . ?\x9A4C) ;; <CJK>
     (?$(DiQ(B . ?\x9A4E) ;; <CJK>
     (?$(DiR(B . ?\x9A51) ;; <CJK>
     (?$(DiS(B . ?\x9A54) ;; <CJK>
     (?$(DiT(B . ?\x9A56) ;; <CJK>
     (?$(DiU(B . ?\x9A5D) ;; <CJK>
     (?$(DiV(B . ?\x9AAA) ;; <CJK>
     (?$(DiW(B . ?\x9AAC) ;; <CJK>
     (?$(DiX(B . ?\x9AAE) ;; <CJK>
     (?$(DiY(B . ?\x9AAF) ;; <CJK>
     (?$(DiZ(B . ?\x9AB2) ;; <CJK>
     (?$(Di[(B . ?\x9AB4) ;; <CJK>
     (?$(Di\(B . ?\x9AB5) ;; <CJK>
     (?$(Di](B . ?\x9AB6) ;; <CJK>
     (?$(Di^(B . ?\x9AB9) ;; <CJK>
     (?$(Di_(B . ?\x9ABB) ;; <CJK>
     (?$(Di`(B . ?\x9ABE) ;; <CJK>
     (?$(Dia(B . ?\x9ABF) ;; <CJK>
     (?$(Dib(B . ?\x9AC1) ;; <CJK>
     (?$(Dic(B . ?\x9AC3) ;; <CJK>
     (?$(Did(B . ?\x9AC6) ;; <CJK>
     (?$(Die(B . ?\x9AC8) ;; <CJK>
     (?$(Dif(B . ?\x9ACE) ;; <CJK>
     (?$(Dig(B . ?\x9AD0) ;; <CJK>
     (?$(Dih(B . ?\x9AD2) ;; <CJK>
     (?$(Dii(B . ?\x9AD5) ;; <CJK>
     (?$(Dij(B . ?\x9AD6) ;; <CJK>
     (?$(Dik(B . ?\x9AD7) ;; <CJK>
     (?$(Dil(B . ?\x9ADB) ;; <CJK>
     (?$(Dim(B . ?\x9ADC) ;; <CJK>
     (?$(Din(B . ?\x9AE0) ;; <CJK>
     (?$(Dio(B . ?\x9AE4) ;; <CJK>
     (?$(Dip(B . ?\x9AE5) ;; <CJK>
     (?$(Diq(B . ?\x9AE7) ;; <CJK>
     (?$(Dir(B . ?\x9AE9) ;; <CJK>
     (?$(Dis(B . ?\x9AEC) ;; <CJK>
     (?$(Dit(B . ?\x9AF2) ;; <CJK>
     (?$(Diu(B . ?\x9AF3) ;; <CJK>
     (?$(Div(B . ?\x9AF5) ;; <CJK>
     (?$(Diw(B . ?\x9AF9) ;; <CJK>
     (?$(Dix(B . ?\x9AFA) ;; <CJK>
     (?$(Diy(B . ?\x9AFD) ;; <CJK>
     (?$(Diz(B . ?\x9AFF) ;; <CJK>
     (?$(Di{(B . ?\x9B00) ;; <CJK>
     (?$(Di|(B . ?\x9B01) ;; <CJK>
     (?$(Di}(B . ?\x9B02) ;; <CJK>
     (?$(Di~(B . ?\x9B03) ;; <CJK>
     (?$(Dj!(B . ?\x9B04) ;; <CJK>
     (?$(Dj"(B . ?\x9B05) ;; <CJK>
     (?$(Dj#(B . ?\x9B08) ;; <CJK>
     (?$(Dj$(B . ?\x9B09) ;; <CJK>
     (?$(Dj%(B . ?\x9B0B) ;; <CJK>
     (?$(Dj&(B . ?\x9B0C) ;; <CJK>
     (?$(Dj'(B . ?\x9B0D) ;; <CJK>
     (?$(Dj((B . ?\x9B0E) ;; <CJK>
     (?$(Dj)(B . ?\x9B10) ;; <CJK>
     (?$(Dj*(B . ?\x9B12) ;; <CJK>
     (?$(Dj+(B . ?\x9B16) ;; <CJK>
     (?$(Dj,(B . ?\x9B19) ;; <CJK>
     (?$(Dj-(B . ?\x9B1B) ;; <CJK>
     (?$(Dj.(B . ?\x9B1C) ;; <CJK>
     (?$(Dj/(B . ?\x9B20) ;; <CJK>
     (?$(Dj0(B . ?\x9B26) ;; <CJK>
     (?$(Dj1(B . ?\x9B2B) ;; <CJK>
     (?$(Dj2(B . ?\x9B2D) ;; <CJK>
     (?$(Dj3(B . ?\x9B33) ;; <CJK>
     (?$(Dj4(B . ?\x9B34) ;; <CJK>
     (?$(Dj5(B . ?\x9B35) ;; <CJK>
     (?$(Dj6(B . ?\x9B37) ;; <CJK>
     (?$(Dj7(B . ?\x9B39) ;; <CJK>
     (?$(Dj8(B . ?\x9B3A) ;; <CJK>
     (?$(Dj9(B . ?\x9B3D) ;; <CJK>
     (?$(Dj:(B . ?\x9B48) ;; <CJK>
     (?$(Dj;(B . ?\x9B4B) ;; <CJK>
     (?$(Dj<(B . ?\x9B4C) ;; <CJK>
     (?$(Dj=(B . ?\x9B55) ;; <CJK>
     (?$(Dj>(B . ?\x9B56) ;; <CJK>
     (?$(Dj?(B . ?\x9B57) ;; <CJK>
     (?$(Dj@(B . ?\x9B5B) ;; <CJK>
     (?$(DjA(B . ?\x9B5E) ;; <CJK>
     (?$(DjB(B . ?\x9B61) ;; <CJK>
     (?$(DjC(B . ?\x9B63) ;; <CJK>
     (?$(DjD(B . ?\x9B65) ;; <CJK>
     (?$(DjE(B . ?\x9B66) ;; <CJK>
     (?$(DjF(B . ?\x9B68) ;; <CJK>
     (?$(DjG(B . ?\x9B6A) ;; <CJK>
     (?$(DjH(B . ?\x9B6B) ;; <CJK>
     (?$(DjI(B . ?\x9B6C) ;; <CJK>
     (?$(DjJ(B . ?\x9B6D) ;; <CJK>
     (?$(DjK(B . ?\x9B6E) ;; <CJK>
     (?$(DjL(B . ?\x9B73) ;; <CJK>
     (?$(DjM(B . ?\x9B75) ;; <CJK>
     (?$(DjN(B . ?\x9B77) ;; <CJK>
     (?$(DjO(B . ?\x9B78) ;; <CJK>
     (?$(DjP(B . ?\x9B79) ;; <CJK>
     (?$(DjQ(B . ?\x9B7F) ;; <CJK>
     (?$(DjR(B . ?\x9B80) ;; <CJK>
     (?$(DjS(B . ?\x9B84) ;; <CJK>
     (?$(DjT(B . ?\x9B85) ;; <CJK>
     (?$(DjU(B . ?\x9B86) ;; <CJK>
     (?$(DjV(B . ?\x9B87) ;; <CJK>
     (?$(DjW(B . ?\x9B89) ;; <CJK>
     (?$(DjX(B . ?\x9B8A) ;; <CJK>
     (?$(DjY(B . ?\x9B8B) ;; <CJK>
     (?$(DjZ(B . ?\x9B8D) ;; <CJK>
     (?$(Dj[(B . ?\x9B8F) ;; <CJK>
     (?$(Dj\(B . ?\x9B90) ;; <CJK>
     (?$(Dj](B . ?\x9B94) ;; <CJK>
     (?$(Dj^(B . ?\x9B9A) ;; <CJK>
     (?$(Dj_(B . ?\x9B9D) ;; <CJK>
     (?$(Dj`(B . ?\x9B9E) ;; <CJK>
     (?$(Dja(B . ?\x9BA6) ;; <CJK>
     (?$(Djb(B . ?\x9BA7) ;; <CJK>
     (?$(Djc(B . ?\x9BA9) ;; <CJK>
     (?$(Djd(B . ?\x9BAC) ;; <CJK>
     (?$(Dje(B . ?\x9BB0) ;; <CJK>
     (?$(Djf(B . ?\x9BB1) ;; <CJK>
     (?$(Djg(B . ?\x9BB2) ;; <CJK>
     (?$(Djh(B . ?\x9BB7) ;; <CJK>
     (?$(Dji(B . ?\x9BB8) ;; <CJK>
     (?$(Djj(B . ?\x9BBB) ;; <CJK>
     (?$(Djk(B . ?\x9BBC) ;; <CJK>
     (?$(Djl(B . ?\x9BBE) ;; <CJK>
     (?$(Djm(B . ?\x9BBF) ;; <CJK>
     (?$(Djn(B . ?\x9BC1) ;; <CJK>
     (?$(Djo(B . ?\x9BC7) ;; <CJK>
     (?$(Djp(B . ?\x9BC8) ;; <CJK>
     (?$(Djq(B . ?\x9BCE) ;; <CJK>
     (?$(Djr(B . ?\x9BD0) ;; <CJK>
     (?$(Djs(B . ?\x9BD7) ;; <CJK>
     (?$(Djt(B . ?\x9BD8) ;; <CJK>
     (?$(Dju(B . ?\x9BDD) ;; <CJK>
     (?$(Djv(B . ?\x9BDF) ;; <CJK>
     (?$(Djw(B . ?\x9BE5) ;; <CJK>
     (?$(Djx(B . ?\x9BE7) ;; <CJK>
     (?$(Djy(B . ?\x9BEA) ;; <CJK>
     (?$(Djz(B . ?\x9BEB) ;; <CJK>
     (?$(Dj{(B . ?\x9BEF) ;; <CJK>
     (?$(Dj|(B . ?\x9BF3) ;; <CJK>
     (?$(Dj}(B . ?\x9BF7) ;; <CJK>
     (?$(Dj~(B . ?\x9BF8) ;; <CJK>
     (?$(Dk!(B . ?\x9BF9) ;; <CJK>
     (?$(Dk"(B . ?\x9BFA) ;; <CJK>
     (?$(Dk#(B . ?\x9BFD) ;; <CJK>
     (?$(Dk$(B . ?\x9BFF) ;; <CJK>
     (?$(Dk%(B . ?\x9C00) ;; <CJK>
     (?$(Dk&(B . ?\x9C02) ;; <CJK>
     (?$(Dk'(B . ?\x9C0B) ;; <CJK>
     (?$(Dk((B . ?\x9C0F) ;; <CJK>
     (?$(Dk)(B . ?\x9C11) ;; <CJK>
     (?$(Dk*(B . ?\x9C16) ;; <CJK>
     (?$(Dk+(B . ?\x9C18) ;; <CJK>
     (?$(Dk,(B . ?\x9C19) ;; <CJK>
     (?$(Dk-(B . ?\x9C1A) ;; <CJK>
     (?$(Dk.(B . ?\x9C1C) ;; <CJK>
     (?$(Dk/(B . ?\x9C1E) ;; <CJK>
     (?$(Dk0(B . ?\x9C22) ;; <CJK>
     (?$(Dk1(B . ?\x9C23) ;; <CJK>
     (?$(Dk2(B . ?\x9C26) ;; <CJK>
     (?$(Dk3(B . ?\x9C27) ;; <CJK>
     (?$(Dk4(B . ?\x9C28) ;; <CJK>
     (?$(Dk5(B . ?\x9C29) ;; <CJK>
     (?$(Dk6(B . ?\x9C2A) ;; <CJK>
     (?$(Dk7(B . ?\x9C31) ;; <CJK>
     (?$(Dk8(B . ?\x9C35) ;; <CJK>
     (?$(Dk9(B . ?\x9C36) ;; <CJK>
     (?$(Dk:(B . ?\x9C37) ;; <CJK>
     (?$(Dk;(B . ?\x9C3D) ;; <CJK>
     (?$(Dk<(B . ?\x9C41) ;; <CJK>
     (?$(Dk=(B . ?\x9C43) ;; <CJK>
     (?$(Dk>(B . ?\x9C44) ;; <CJK>
     (?$(Dk?(B . ?\x9C45) ;; <CJK>
     (?$(Dk@(B . ?\x9C49) ;; <CJK>
     (?$(DkA(B . ?\x9C4A) ;; <CJK>
     (?$(DkB(B . ?\x9C4E) ;; <CJK>
     (?$(DkC(B . ?\x9C4F) ;; <CJK>
     (?$(DkD(B . ?\x9C50) ;; <CJK>
     (?$(DkE(B . ?\x9C53) ;; <CJK>
     (?$(DkF(B . ?\x9C54) ;; <CJK>
     (?$(DkG(B . ?\x9C56) ;; <CJK>
     (?$(DkH(B . ?\x9C58) ;; <CJK>
     (?$(DkI(B . ?\x9C5B) ;; <CJK>
     (?$(DkJ(B . ?\x9C5D) ;; <CJK>
     (?$(DkK(B . ?\x9C5E) ;; <CJK>
     (?$(DkL(B . ?\x9C5F) ;; <CJK>
     (?$(DkM(B . ?\x9C63) ;; <CJK>
     (?$(DkN(B . ?\x9C69) ;; <CJK>
     (?$(DkO(B . ?\x9C6A) ;; <CJK>
     (?$(DkP(B . ?\x9C5C) ;; <CJK>
     (?$(DkQ(B . ?\x9C6B) ;; <CJK>
     (?$(DkR(B . ?\x9C68) ;; <CJK>
     (?$(DkS(B . ?\x9C6E) ;; <CJK>
     (?$(DkT(B . ?\x9C70) ;; <CJK>
     (?$(DkU(B . ?\x9C72) ;; <CJK>
     (?$(DkV(B . ?\x9C75) ;; <CJK>
     (?$(DkW(B . ?\x9C77) ;; <CJK>
     (?$(DkX(B . ?\x9C7B) ;; <CJK>
     (?$(DkY(B . ?\x9CE6) ;; <CJK>
     (?$(DkZ(B . ?\x9CF2) ;; <CJK>
     (?$(Dk[(B . ?\x9CF7) ;; <CJK>
     (?$(Dk\(B . ?\x9CF9) ;; <CJK>
     (?$(Dk](B . ?\x9D0B) ;; <CJK>
     (?$(Dk^(B . ?\x9D02) ;; <CJK>
     (?$(Dk_(B . ?\x9D11) ;; <CJK>
     (?$(Dk`(B . ?\x9D17) ;; <CJK>
     (?$(Dka(B . ?\x9D18) ;; <CJK>
     (?$(Dkb(B . ?\x9D1C) ;; <CJK>
     (?$(Dkc(B . ?\x9D1D) ;; <CJK>
     (?$(Dkd(B . ?\x9D1E) ;; <CJK>
     (?$(Dke(B . ?\x9D2F) ;; <CJK>
     (?$(Dkf(B . ?\x9D30) ;; <CJK>
     (?$(Dkg(B . ?\x9D32) ;; <CJK>
     (?$(Dkh(B . ?\x9D33) ;; <CJK>
     (?$(Dki(B . ?\x9D34) ;; <CJK>
     (?$(Dkj(B . ?\x9D3A) ;; <CJK>
     (?$(Dkk(B . ?\x9D3C) ;; <CJK>
     (?$(Dkl(B . ?\x9D45) ;; <CJK>
     (?$(Dkm(B . ?\x9D3D) ;; <CJK>
     (?$(Dkn(B . ?\x9D42) ;; <CJK>
     (?$(Dko(B . ?\x9D43) ;; <CJK>
     (?$(Dkp(B . ?\x9D47) ;; <CJK>
     (?$(Dkq(B . ?\x9D4A) ;; <CJK>
     (?$(Dkr(B . ?\x9D53) ;; <CJK>
     (?$(Dks(B . ?\x9D54) ;; <CJK>
     (?$(Dkt(B . ?\x9D5F) ;; <CJK>
     (?$(Dku(B . ?\x9D63) ;; <CJK>
     (?$(Dkv(B . ?\x9D62) ;; <CJK>
     (?$(Dkw(B . ?\x9D65) ;; <CJK>
     (?$(Dkx(B . ?\x9D69) ;; <CJK>
     (?$(Dky(B . ?\x9D6A) ;; <CJK>
     (?$(Dkz(B . ?\x9D6B) ;; <CJK>
     (?$(Dk{(B . ?\x9D70) ;; <CJK>
     (?$(Dk|(B . ?\x9D76) ;; <CJK>
     (?$(Dk}(B . ?\x9D77) ;; <CJK>
     (?$(Dk~(B . ?\x9D7B) ;; <CJK>
     (?$(Dl!(B . ?\x9D7C) ;; <CJK>
     (?$(Dl"(B . ?\x9D7E) ;; <CJK>
     (?$(Dl#(B . ?\x9D83) ;; <CJK>
     (?$(Dl$(B . ?\x9D84) ;; <CJK>
     (?$(Dl%(B . ?\x9D86) ;; <CJK>
     (?$(Dl&(B . ?\x9D8A) ;; <CJK>
     (?$(Dl'(B . ?\x9D8D) ;; <CJK>
     (?$(Dl((B . ?\x9D8E) ;; <CJK>
     (?$(Dl)(B . ?\x9D92) ;; <CJK>
     (?$(Dl*(B . ?\x9D93) ;; <CJK>
     (?$(Dl+(B . ?\x9D95) ;; <CJK>
     (?$(Dl,(B . ?\x9D96) ;; <CJK>
     (?$(Dl-(B . ?\x9D97) ;; <CJK>
     (?$(Dl.(B . ?\x9D98) ;; <CJK>
     (?$(Dl/(B . ?\x9DA1) ;; <CJK>
     (?$(Dl0(B . ?\x9DAA) ;; <CJK>
     (?$(Dl1(B . ?\x9DAC) ;; <CJK>
     (?$(Dl2(B . ?\x9DAE) ;; <CJK>
     (?$(Dl3(B . ?\x9DB1) ;; <CJK>
     (?$(Dl4(B . ?\x9DB5) ;; <CJK>
     (?$(Dl5(B . ?\x9DB9) ;; <CJK>
     (?$(Dl6(B . ?\x9DBC) ;; <CJK>
     (?$(Dl7(B . ?\x9DBF) ;; <CJK>
     (?$(Dl8(B . ?\x9DC3) ;; <CJK>
     (?$(Dl9(B . ?\x9DC7) ;; <CJK>
     (?$(Dl:(B . ?\x9DC9) ;; <CJK>
     (?$(Dl;(B . ?\x9DCA) ;; <CJK>
     (?$(Dl<(B . ?\x9DD4) ;; <CJK>
     (?$(Dl=(B . ?\x9DD5) ;; <CJK>
     (?$(Dl>(B . ?\x9DD6) ;; <CJK>
     (?$(Dl?(B . ?\x9DD7) ;; <CJK>
     (?$(Dl@(B . ?\x9DDA) ;; <CJK>
     (?$(DlA(B . ?\x9DDE) ;; <CJK>
     (?$(DlB(B . ?\x9DDF) ;; <CJK>
     (?$(DlC(B . ?\x9DE0) ;; <CJK>
     (?$(DlD(B . ?\x9DE5) ;; <CJK>
     (?$(DlE(B . ?\x9DE7) ;; <CJK>
     (?$(DlF(B . ?\x9DE9) ;; <CJK>
     (?$(DlG(B . ?\x9DEB) ;; <CJK>
     (?$(DlH(B . ?\x9DEE) ;; <CJK>
     (?$(DlI(B . ?\x9DF0) ;; <CJK>
     (?$(DlJ(B . ?\x9DF3) ;; <CJK>
     (?$(DlK(B . ?\x9DF4) ;; <CJK>
     (?$(DlL(B . ?\x9DFE) ;; <CJK>
     (?$(DlM(B . ?\x9E0A) ;; <CJK>
     (?$(DlN(B . ?\x9E02) ;; <CJK>
     (?$(DlO(B . ?\x9E07) ;; <CJK>
     (?$(DlP(B . ?\x9E0E) ;; <CJK>
     (?$(DlQ(B . ?\x9E10) ;; <CJK>
     (?$(DlR(B . ?\x9E11) ;; <CJK>
     (?$(DlS(B . ?\x9E12) ;; <CJK>
     (?$(DlT(B . ?\x9E15) ;; <CJK>
     (?$(DlU(B . ?\x9E16) ;; <CJK>
     (?$(DlV(B . ?\x9E19) ;; <CJK>
     (?$(DlW(B . ?\x9E1C) ;; <CJK>
     (?$(DlX(B . ?\x9E1D) ;; <CJK>
     (?$(DlY(B . ?\x9E7A) ;; <CJK>
     (?$(DlZ(B . ?\x9E7B) ;; <CJK>
     (?$(Dl[(B . ?\x9E7C) ;; <CJK>
     (?$(Dl\(B . ?\x9E80) ;; <CJK>
     (?$(Dl](B . ?\x9E82) ;; <CJK>
     (?$(Dl^(B . ?\x9E83) ;; <CJK>
     (?$(Dl_(B . ?\x9E84) ;; <CJK>
     (?$(Dl`(B . ?\x9E85) ;; <CJK>
     (?$(Dla(B . ?\x9E87) ;; <CJK>
     (?$(Dlb(B . ?\x9E8E) ;; <CJK>
     (?$(Dlc(B . ?\x9E8F) ;; <CJK>
     (?$(Dld(B . ?\x9E96) ;; <CJK>
     (?$(Dle(B . ?\x9E98) ;; <CJK>
     (?$(Dlf(B . ?\x9E9B) ;; <CJK>
     (?$(Dlg(B . ?\x9E9E) ;; <CJK>
     (?$(Dlh(B . ?\x9EA4) ;; <CJK>
     (?$(Dli(B . ?\x9EA8) ;; <CJK>
     (?$(Dlj(B . ?\x9EAC) ;; <CJK>
     (?$(Dlk(B . ?\x9EAE) ;; <CJK>
     (?$(Dll(B . ?\x9EAF) ;; <CJK>
     (?$(Dlm(B . ?\x9EB0) ;; <CJK>
     (?$(Dln(B . ?\x9EB3) ;; <CJK>
     (?$(Dlo(B . ?\x9EB4) ;; <CJK>
     (?$(Dlp(B . ?\x9EB5) ;; <CJK>
     (?$(Dlq(B . ?\x9EC6) ;; <CJK>
     (?$(Dlr(B . ?\x9EC8) ;; <CJK>
     (?$(Dls(B . ?\x9ECB) ;; <CJK>
     (?$(Dlt(B . ?\x9ED5) ;; <CJK>
     (?$(Dlu(B . ?\x9EDF) ;; <CJK>
     (?$(Dlv(B . ?\x9EE4) ;; <CJK>
     (?$(Dlw(B . ?\x9EE7) ;; <CJK>
     (?$(Dlx(B . ?\x9EEC) ;; <CJK>
     (?$(Dly(B . ?\x9EED) ;; <CJK>
     (?$(Dlz(B . ?\x9EEE) ;; <CJK>
     (?$(Dl{(B . ?\x9EF0) ;; <CJK>
     (?$(Dl|(B . ?\x9EF1) ;; <CJK>
     (?$(Dl}(B . ?\x9EF2) ;; <CJK>
     (?$(Dl~(B . ?\x9EF5) ;; <CJK>
     (?$(Dm!(B . ?\x9EF8) ;; <CJK>
     (?$(Dm"(B . ?\x9EFF) ;; <CJK>
     (?$(Dm#(B . ?\x9F02) ;; <CJK>
     (?$(Dm$(B . ?\x9F03) ;; <CJK>
     (?$(Dm%(B . ?\x9F09) ;; <CJK>
     (?$(Dm&(B . ?\x9F0F) ;; <CJK>
     (?$(Dm'(B . ?\x9F10) ;; <CJK>
     (?$(Dm((B . ?\x9F11) ;; <CJK>
     (?$(Dm)(B . ?\x9F12) ;; <CJK>
     (?$(Dm*(B . ?\x9F14) ;; <CJK>
     (?$(Dm+(B . ?\x9F16) ;; <CJK>
     (?$(Dm,(B . ?\x9F17) ;; <CJK>
     (?$(Dm-(B . ?\x9F19) ;; <CJK>
     (?$(Dm.(B . ?\x9F1A) ;; <CJK>
     (?$(Dm/(B . ?\x9F1B) ;; <CJK>
     (?$(Dm0(B . ?\x9F1F) ;; <CJK>
     (?$(Dm1(B . ?\x9F22) ;; <CJK>
     (?$(Dm2(B . ?\x9F26) ;; <CJK>
     (?$(Dm3(B . ?\x9F2A) ;; <CJK>
     (?$(Dm4(B . ?\x9F2B) ;; <CJK>
     (?$(Dm5(B . ?\x9F2F) ;; <CJK>
     (?$(Dm6(B . ?\x9F31) ;; <CJK>
     (?$(Dm7(B . ?\x9F32) ;; <CJK>
     (?$(Dm8(B . ?\x9F34) ;; <CJK>
     (?$(Dm9(B . ?\x9F37) ;; <CJK>
     (?$(Dm:(B . ?\x9F39) ;; <CJK>
     (?$(Dm;(B . ?\x9F3A) ;; <CJK>
     (?$(Dm<(B . ?\x9F3C) ;; <CJK>
     (?$(Dm=(B . ?\x9F3D) ;; <CJK>
     (?$(Dm>(B . ?\x9F3F) ;; <CJK>
     (?$(Dm?(B . ?\x9F41) ;; <CJK>
     (?$(Dm@(B . ?\x9F43) ;; <CJK>
     (?$(DmA(B . ?\x9F44) ;; <CJK>
     (?$(DmB(B . ?\x9F45) ;; <CJK>
     (?$(DmC(B . ?\x9F46) ;; <CJK>
     (?$(DmD(B . ?\x9F47) ;; <CJK>
     (?$(DmE(B . ?\x9F53) ;; <CJK>
     (?$(DmF(B . ?\x9F55) ;; <CJK>
     (?$(DmG(B . ?\x9F56) ;; <CJK>
     (?$(DmH(B . ?\x9F57) ;; <CJK>
     (?$(DmI(B . ?\x9F58) ;; <CJK>
     (?$(DmJ(B . ?\x9F5A) ;; <CJK>
     (?$(DmK(B . ?\x9F5D) ;; <CJK>
     (?$(DmL(B . ?\x9F5E) ;; <CJK>
     (?$(DmM(B . ?\x9F68) ;; <CJK>
     (?$(DmN(B . ?\x9F69) ;; <CJK>
     (?$(DmO(B . ?\x9F6D) ;; <CJK>
     (?$(DmP(B . ?\x9F6E) ;; <CJK>
     (?$(DmQ(B . ?\x9F6F) ;; <CJK>
     (?$(DmR(B . ?\x9F70) ;; <CJK>
     (?$(DmS(B . ?\x9F71) ;; <CJK>
     (?$(DmT(B . ?\x9F73) ;; <CJK>
     (?$(DmU(B . ?\x9F75) ;; <CJK>
     (?$(DmV(B . ?\x9F7A) ;; <CJK>
     (?$(DmW(B . ?\x9F7D) ;; <CJK>
     (?$(DmX(B . ?\x9F8F) ;; <CJK>
     (?$(DmY(B . ?\x9F90) ;; <CJK>
     (?$(DmZ(B . ?\x9F91) ;; <CJK>
     (?$(Dm[(B . ?\x9F92) ;; <CJK>
     (?$(Dm\(B . ?\x9F94) ;; <CJK>
     (?$(Dm](B . ?\x9F96) ;; <CJK>
     (?$(Dm^(B . ?\x9F97) ;; <CJK>
     (?$(Dm_(B . ?\x9F9E) ;; <CJK>
     (?$(Dm`(B . ?\x9FA1) ;; <CJK>
     (?$(Dma(B . ?\x9FA2) ;; <CJK>
     (?$(Dmb(B . ?\x9FA3) ;; <CJK>
     (?$(Dmc(B . ?\x9FA5) ;; <CJK>
     )))

(provide 'ujisx0212)
     