;;; un-sample.el --- sample configuration for UTF.

;; Copyright (C) 1997-1999 Miyashita Hisashi

;; Keywords: mule, multilingual, 
;;           character set, coding-system, ISO10646, Unicode

;; This file is part of MULE-UCS

;; MULE-UCS is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; MULE-UCS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;; Comment:
;;  This module supports useful functions for unicode.
;;  If you want to use auto detecting utf? .etc, 
;;  add (require 'un-tools) to your .emacs.

;
; This is a sample program for generating unicode coding system.
; You can customize these configuration, and byte-compile it,
; then you get your expected coding-system with only its result.
; You need only un-sample.elc after compile this.
;

;;; This sentense is needed.
;;; You can define any data to generate
;;; new coding systems or ccl.
(eval-when-compile
  (require 'unicode)

  (defvar un-sample-charset-order-list
    '(ascii
      latin-iso8859-1
      latin-iso8859-2
      latin-iso8859-3
      latin-iso8859-4
      cyrillic-iso8859-5
;      arabic-iso8859-6
      greek-iso8859-7
      hebrew-iso8859-8
      latin-iso8859-9
      ipa
      japanese-jisx0208
      japanese-jisx0212
      chinese-gb2312
      chinese-cns11643-1 
      chinese-cns11643-2
      chinese-cns11643-3
      chinese-cns11643-4
      chinese-cns11643-5
      chinese-cns11643-6
      chinese-cns11643-7
      korean-ksc5601
      latin-jisx0201
      katakana-jisx0201
      ))

  ;; load-table
  (mapcar
   (lambda (x)
     (require-unicode-charset-data x))
   un-sample-charset-order-list)

  (tae-declare-translation
   'unicode-basic-translation-rule
   `(| ,us-ascii-vs-unicode-assoc
       ,iso-8859-1-vs-unicode-assoc
       ,iso-8859-2-vs-unicode-assoc
       ,iso-8859-3-vs-unicode-assoc
       ,iso-8859-4-vs-unicode-assoc
       ,iso-8859-5-vs-unicode-assoc
;       ,iso-8859-6-vs-unicode-assoc
       ,iso-8859-7-vs-unicode-assoc
       ,iso-8859-8-vs-unicode-assoc
       ,iso-8859-9-vs-unicode-assoc
       ,ipa-vs-unicode-assoc
       ,jis-x-0208-1990-vs-unicode-assoc
       ,jis-x-0212-vs-unicode-assoc
       ,gb2312-80-vs-unicode-assoc
       ,cns11643-1-vs-unicode-assoc
       ,cns11643-2-vs-unicode-assoc
       ,cns11643-3-vs-unicode-assoc
       ,cns11643-4-vs-unicode-assoc
       ,cns11643-5-vs-unicode-assoc
       ,cns11643-6-vs-unicode-assoc
       ,cns11643-7-vs-unicode-assoc
       ,ks-c-5601-1987-vs-unicode-assoc
       ,jis-x-0201-latin-vs-unicode-assoc
       ,jis-x-0201-katakana-vs-unicode-assoc
       ,unicode-not-found-assoc))

  (tae-declare-translation
   'unicode-line-separator-translation-rule
   `(| ,lf-vs-unicode-line-separator-assoc
       unicode-basic-translation-rule))

  (tae-declare-translation
   'unicode-mac-line-separator-translation-rule
   `(| ,lf-vs-cr-assoc
       unicode-basic-translation-rule))

  (defun un-sample-decode-template (tr read write)
    (mucs-ccl-stream-form
     (mucs-ccl-read 'ucs-generic read)
     (tae-compile tr t)
     (mucs-ccl-write write)))

  (defun un-sample-encode-template (tr read write)
    (mucs-ccl-stream-form
     (mucs-ccl-read 'char-packed-1 read)
     (tae-compile tr nil)
     (mucs-ccl-write write)))

  (defun un-sample-coding-system-alist
    (mime-charset &optional charsets)
    (append
     (if mime-charset
	 (list (cons 'mime-charset  mime-charset)))
     (list (cons 'safe-charsets
		 (or charsets
		     un-sample-charset-order-list)))))
)

;--------------------------------------------------------
; Coding system definition.
;--------------------------------------------------------

(mucs-define-package  ;;; Define package.
 un-sample            ;;; This and feature name(the argument of require)
                      ;;; should be same.

;;; UTF-8 section

 (mucs-define-simple-coding-system
  utf-8-unix ?u
  "UTF-8 coding system whose line separator is LF."
  (utf-8-decode-buffer-magnification
   ((un-sample-decode-template
     'unicode-basic-translation-rule 'utf-8 'emacs-mule)))
  (utf-8-encode-buffer-magnification
   ((un-sample-encode-template
     'unicode-basic-translation-rule 'emacs-mule 'utf-8)))
  (un-sample-coding-system-alist 'utf-8))

 (mucs-define-simple-coding-system
  utf-8-dos ?u
  "UTF-8 coding system whose line separator is CRLF."
  (utf-8-decode-buffer-magnification
   ((un-sample-decode-template
     'unicode-basic-translation-rule 'utf-8 'emacs-mule-dos)))
  (utf-8-encode-buffer-magnification
   ((un-sample-encode-template
     'unicode-basic-translation-rule 'emacs-mule 'utf-8-dos)))
  (un-sample-coding-system-alist 'utf-8))

 (mucs-define-simple-coding-system
  utf-8-mac ?u
  "UTF-8 coding system whose line separator is CR."
  (utf-8-decode-buffer-magnification
   ((un-sample-decode-template
     'unicode-mac-line-separator-translation-rule
     'utf-8 'emacs-mule)))
  (utf-8-encode-buffer-magnification
   ((un-sample-encode-template
     'unicode-mac-line-separator-translation-rule
     'emacs-mule 'utf-8)))
  (un-sample-coding-system-alist 'utf-8))

 (define-coding-system-alias 'utf-8 'utf-8-unix)

;;; UTF-8 with signature

 (mucs-define-simple-coding-system
  utf-8-ws-unix ?u
  "UTF-8 coding system with signature whose line separator is LF."
  (utf-8-decode-buffer-magnification
   ((un-sample-decode-template
     'unicode-basic-translation-rule 'utf-8 'emacs-mule)))
  (utf-8-encode-buffer-magnification
   ((mucs-ccl-write-utf-8-signature)
    (un-sample-encode-template
     'unicode-basic-translation-rule
     'emacs-mule 'utf-8)))
  (un-sample-coding-system-alist 'utf-8))


 (mucs-define-simple-coding-system
  utf-8-ws-dos ?u
  "UTF-8 coding system with signature whose line separator is CRLF."
  (utf-8-decode-buffer-magnification
   ((un-sample-decode-template
     'unicode-basic-translation-rule 'utf-8 'emacs-mule-dos)))
  (utf-8-encode-buffer-magnification
   ((mucs-ccl-write-utf-8-signature)
    (un-sample-encode-template
     'unicode-basic-translation-rule
     'emacs-mule 'utf-8-dos)))
  (un-sample-coding-system-alist 'utf-8))

 (mucs-define-simple-coding-system
  utf-8-ws-mac ?u
  "UTF-8 coding system with signature whose line separator is CR."
  (utf-8-decode-buffer-magnification
   ((un-sample-decode-template
     'unicode-mac-line-separator-translation-rule
     'utf-8 'emacs-mule)))
  (utf-8-encode-buffer-magnification
   ((mucs-ccl-write-utf-8-signature)
    (un-sample-encode-template
     'unicode-mac-line-separator-translation-rule
     'emacs-mule 'utf-8)))
  (un-sample-coding-system-alist 'utf-8))

  (define-coding-system-alias 'utf-8-ws 'utf-8-ws-unix)

;;; UTF-16 Little Endian Section

 (mucs-define-simple-coding-system
  utf-16-le ?U
  "UTF-16 Little Endian coding system whose line separator is U+2028."
  (utf-16-decode-buffer-magnification
   ((un-sample-decode-template
     'unicode-line-separator-translation-rule
     'utf-16-le 'emacs-mule)))
  (utf-16-encode-buffer-magnification
   ((mucs-ccl-write-utf-16-le-signature)
    (un-sample-encode-template
     'unicode-line-separator-translation-rule
     'emacs-mule 'utf-16-le)))
  (un-sample-coding-system-alist nil))

 (mucs-define-simple-coding-system
  utf-16-le-unix ?U
  "UTF-16 Little Endian coding system whose line separator is LF."
  (utf-16-decode-buffer-magnification
   ((un-sample-decode-template
     'unicode-basic-translation-rule
     'utf-16-le 'emacs-mule)))
  (utf-16-encode-buffer-magnification
   ((mucs-ccl-write-utf-16-le-signature)
    (un-sample-encode-template
     'unicode-basic-translation-rule
     'emacs-mule 'utf-16-le)))
  (un-sample-coding-system-alist nil))

 (mucs-define-simple-coding-system
  utf-16-dos ?U
  "UTF-16 Little Endian coding system whose line separator is CRLF."
  (utf-16-decode-buffer-magnification
   ((un-sample-decode-template
     'unicode-basic-translation-rule
     'utf-16-le 'emacs-mule-dos)))
  (utf-16-encode-buffer-magnification
   ((mucs-ccl-write-utf-16-le-signature)
    (un-sample-encode-template
     'unicode-basic-translation-rule
     'emacs-mule 'utf-16-le-dos)))
  (un-sample-coding-system-alist nil))

 (mucs-define-simple-coding-system
  utf-16-mac ?U
  "UTF-16 Little Endian coding system whose line separator is CR."
  (utf-16-decode-buffer-magnification
   ((un-sample-decode-template
     'unicode-mac-line-separator-translation-rule
     'utf-16-le 'emacs-mule)))
  (utf-16-encode-buffer-magnification
   ((mucs-ccl-write-utf-16-le-signature)
    (un-sample-encode-template
     'unicode-mac-line-separator-translation-rule
     'emacs-mule 'utf-16-le)))
  (un-sample-coding-system-alist 'nil))

;;; UTF-16 Big Endian Section

 (mucs-define-simple-coding-system
  utf-16-be ?U
  "UTF-16 Big Endian coding system whose line separator is LF"
  (utf-16-decode-buffer-magnification
   ((un-sample-decode-template
     'unicode-line-separator-translation-rule
     'utf-16-be 'emacs-mule)))
  (utf-16-encode-buffer-magnification
   ((mucs-ccl-write-utf-16-be-signature)
    (un-sample-encode-template
     'unicode-line-separator-translation-rule
     'emacs-mule 'utf-16-be)))
  (un-sample-coding-system-alist nil))

 (mucs-define-simple-coding-system
  utf-16-be-unix ?U
  "UTF-16 Big Endian coding system whose line separator is LF"
  (utf-16-decode-buffer-magnification
   ((un-sample-decode-template
     'unicode-basic-translation-rule 'utf-16-be 'emacs-mule)))
  (utf-16-encode-buffer-magnification
   ((mucs-ccl-write-utf-16-be-signature)
    (un-sample-encode-template
     'unicode-basic-translation-rule 'emacs-mule 'utf-16-be)))
  (un-sample-coding-system-alist nil))

 (mucs-define-simple-coding-system
  utf-16-be-dos ?U
  "UTF-16 Big Endian coding system whose line separator is CRLF."
  (utf-16-decode-buffer-magnification
   ((un-sample-decode-template
     'unicode-basic-translation-rule
     'utf-16-be 'emacs-mule-dos)))
  (utf-16-encode-buffer-magnification
   ((mucs-ccl-write-utf-16-be-signature)
    (un-sample-encode-template
     'unicode-basic-translation-rule
     'emacs-mule 'utf-16-be-dos)))
  (un-sample-coding-system-alist nil))

 (mucs-define-simple-coding-system
  utf-16-be-mac ?U
  "UTF-16 Big Endian coding system whose line separator is CR."
  (utf-16-decode-buffer-magnification
   ((un-sample-decode-template
     'unicode-mac-line-separator-translation-rule
     'utf-16-be 'emacs-mule)))
  (utf-16-encode-buffer-magnification
   ((mucs-ccl-write-utf-16-be-signature)
    (un-sample-encode-template
     'unicode-mac-line-separator-translation-rule
     'emacs-mule 'utf-16-be)))
  (un-sample-coding-system-alist nil))
)

(provide 'un-sample)
