;;; -*- coding: iso-2022-7bit  -*-
;;; tae.el --- Translate And Encoding compiler(TAE:$BL/(B):-)

;; Copyright (C) 1997-1999 Miyashita Hisashi

;; Keywords: mule, multilingual, encode, CCL

;; This file is part of MULE-UCS

;; MULE-UCS is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; MULE-UCS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; This module manages Translation And Encodings.
;;; This is main and very important module to MULE-UCS.
;;; TAE is CORE module. But this is VERY insufficient version.

(require 'mucs)
(require 'mucs-ccl)
(require 'mucs-type)
(require 'tbl-mg)


(defun tae-project-all-translation-vector (val)
  (vector t val 0 (mucs-max-code)))

;(register-code-conversion-map
; 'tae-cease-translation-table
; (vector t -1 0 (mucs-max-code)))


(defvar tae-translation-table-set-index 1)
(defsubst tae-generate-translation-table-set-name (tr-name &optional decodep index)
    "Return a name of a symbol used to register a table-set,
which is managed by TAE."
    (if (null index)
	(setq index tae-translation-table-set-index
	      tae-translation-table-set-index (1+ index)))
    (format "%s-tae-table-set-%s-%d"
	    (symbol-name tr-name)
	    (if decodep "decode" "encode")
	    index))

;;
;;
;; Interface to declare translation
;;
;;  Note about internals:
;;         A declared translation is distinguished by SYMBOL
;;         that is specified by users.
;;         The SYMBOL has the follwing properties.
;;               SYMBOL's VALUE.
;;                    TRANSLATION itself.
;;               tae-translation:
;;                    t(In the future, this property may be
;;                      used to express something.)
;;               tae-reduced-translation-for-encode:
;;                    Reduced translation for encode.
;;               tae-reduced-translation-for-decode:
;;                    Reduced translation for decode.
;;               tae-dynamic-translation:
;;                    If non-nil, TAE assumes this translation
;;                   may be modified after its compilation.
;;                   Concretely, TAE remember the location of
;;                   CCL and TABLE-SET where this translation correspond.
;;                   And then embed the location to compiled result and
;;                   the state of MUCS-CCL, which
;;                   can be refered by the property of 
;;                   `tae-translation-location-and-state'.
;;               tae-products-for-encode:
;;                   Produced TAE messages for encode.
;;               tae-products-for-decode:
;;                   Produced TAE messages for decode.
;;               tae-table-set:
;;                   Generated table-sets.

(defvar tae-internal-translation-property
  '(tae-translation
    tae-dynamic-translation
    tae-reduced-translation-for-encode
    tae-reduced-translation-for-decode
    tae-products-for-encode
    tae-products-for-decode
    tae-table-set))

(defsubst tae-declared-translation-p (name)
  (and (symbolp name)
       (get name 'tae-translation)))

(defun tae-copy-declared-translation (dest src)
  (mapcar
   (lambda (x)
     (put dest x (get src x)))
   tae-internal-translation-property)
  ;;; declared table-set must be copied.
  (let ((table-sets (get src 'tae-table-set))
	new-table-set-name)
    (while table-sets
      (table-set-add-reference (car table-sets))
      (setq table-sets (cdr table-sets)))))


(defun tae-initialize-translation (name)
  (set name nil)

  ;;; Remove reference all generated table-sets.
  (mapcar
   (lambda (x)
     (table-set-remove-reference x))
   (get name 'tae-table-set))

  ;;; any properties of internal use must be set to nil.
  (mapcar
   (lambda (x)
     (put name x nil))
   tae-internal-translation-property))

(defun tae-translation-add-table-set (name table-set)
  (put name 'tae-table-set
       (cons table-set (get name 'tae-table-set))))

(defsubst tae-get-translation-produced-products (translation type decodep)
  (cdr (assq type
	     (get translation
		  (if decodep
		      'tae-products-for-decode
		    'tae-products-for-encode)))))

(defun tae-set-translation-produced-products (translation type decodep value)
  (let* ((prop (if decodep
		  'tae-products-for-decode
		'tae-products-for-encode))
	 (slots (get translation prop))
	 (slot (assq type slots)))
    (if slot
	(setcdr slot value))
    (put translation prop 
	 (cons (cons type value)
	       slots))))

(defun tae-declare-translation (name translation &optional dynamicp)
  "Declare translation.
NAME must be a symbol to distinguish TRANSLATION.
If DYNAMICP is non-nil, this translation can be modified
after its compilation."
  (if (not (symbolp name))
      (error "NAME:%S must be a symbol!" name))

  (if (tae-declared-translation-p translation)
      (tae-copy-declared-translation name translation)
    (tae-initialize-translation name)
    (set name translation)
    (put name 'tae-translation t)
    (if dynamicp
	(put name 'tae-dynamic-translation t))))

;;; Translation rule syntax
;;;
;;; TR-ELEM := (`elisp' TYPE-SPEC Lisp_Func(num of args is 1) FUNC-RANGE [OPTION-ALIST]) 
;;;            | (`assoc' TYPE-SPEC A-LIST [OPTION-ALIST])
;;;            | (`ccl' TYPE-SPEC CCL_Program [OPTION-ALIST])
;;;
;;; If type of TR-ELEM is A-LIST or CCL program,
;;;  this TR-ELEM is called PRECOMPILED.
;;;
;;; FUNC-RANGE := DEF-RANGE [VAL-RANGE]
;;; DEF-RANGE, VAL-RANGE := RANGE
;;; TYPE-SPEC := (CAR-TYPE . CDR-TYPE)
;;; RANGE := ((RANGE1-MIN . RANGE1-MAX) (RANGE2-MIN . RANGE2-MAX) ... )
;;;
;;; TYPE := registered type (see mucs-types.el)
;;;
;;; RANGEx-MIN, RANGEx-MAX := integer
;;;
;;; TRANSLATION := TRANSLATION-ELEMENT  |
;;;                DECLARED-TRANSLATION |
;;;                (OP TRANSLATION [...TRANSLATION] ) |
;;;                (FOP TRANSLATION TRANSLATION)
;;;
;;; DECLARED-TRANSLATION := SYMBOL (see `tae-declare-translation')
;;;
;;; OP := `&' | `|' | `c'
;;; FOP := `ct' | `f' | `ff'
;;; TAG := symbol

;;;;;;   A-LIST note.
;;;;;;
;;;;;;     A-LIST is an association list to describe connections between
;;;;;;   mainly NUMBER and NUMBER.
;;;;;;   For example, an A-LIST, ((A1 . A2) (B1 . B2) ... (Z1 . Z2)),
;;;;;;   means correspondences between A1 and A2, B1 and B2, and so on.
;;;;;;   The element of A-LIST is a cons cell.
;;;;;;     In encoding, TAE regard it as car element to cdr element
;;;;;;   translation, and in decoding, regard it as cdr to car translation.
;;;;;;   Threfore, in above example, TAE translates A1 to A2 in encoding,
;;;;;;   and translates A2 to A1 in decoding.
;;;
;;;;;;     In a special case, an element of A-LIST can have 'all(SYMBOL)
;;;;;;   that matches anything.  For example, an A-LIST, ((1 . 5) (all . 10))
;;;;;;   directs to translate 1 to 5, and any other number to 10 in encoding.
;;;;;;   In decoding, TAE ignores the (all . 10) element, because it is
;;;;;;   impossible translate a number to everything.
;;;;;;     And, in another special case, it can also have 'invalid(SYMBOL)
;;;;;;   that matches nothing and if a translated result is invalid, it
;;;;;;   ceases any further translation, and make the CCL state invalid.

(defmacro tae-get-tr-elem-type (tr-elem-zzz)
  (list 'car tr-elem-zzz))

(defmacro tae-tr-elem-assoc-p (tr-elem-zzz)
  (list 'eq (list 'car-safe tr-elem-zzz)
	''assoc))

(defmacro tae-tr-elem-ccl-p (tr-elem-zzz)
  (list 'eq (list 'car-safe tr-elem-zzz)
	''ccl))

(defmacro tae-tr-elem-elisp-p (tr-elem-zzz)
  (list 'eq (list 'car-safe tr-elem-zzz)
	''elisp))

(defmacro tae-tr-elem-p (tr-elem-zzz)
  (list 'memq (list 'car-safe tr-elem-zzz)
	''(assoc elisp ccl)))

(defsubst tae-get-tr-elem-type-spec (tr-elem)
  (nth 1 tr-elem))

(defsubst tae-get-tr-elem-assoc (tr-elem)
  (nth 2 tr-elem))

(defsubst tae-set-tr-elem-assoc (tr-elem assoc)
  (setcar (nthcdr 2 tr-elem) assoc))

(defsubst tae-get-tr-elem-ccl (tr-elem)
  (nth 2 tr-elem))

(defsubst tae-get-tr-elem-elisp-func (tr-elem)
  (nth 2 tr-elem))

(defsubst tae-get-tr-elem-range (tr-elem)
  (if (tae-tr-elem-elisp-p tr-elem)
      (nth 3 tr-elem)
    (error "This translation element:%S have no RANGE."
	   tr-elem)))

(defsubst tae-get-tr-elem-option-alist (tr-elem)
  (cond ((tae-tr-elem-assoc-p tr-elem)
	 (nth 3 tr-elem))
	((tae-tr-elem-elisp-p tr-elem)
	 (nth 4 tr-elem))
	((tae-tr-elem-ccl-p tr-elem)
	 (nth 3 tr-elem))))

(defsubst tae-set-tr-elem-option-alist (tr-elem alist)
  (let (slot)
    (cond ((tae-tr-elem-assoc-p tr-elem)
	   (setq slot (nthcdr 3 tr-elem)))
	  ((tae-tr-elem-elisp-p tr-elem)
	   (setq slot (nthcdr 4 tr-elem)))
	  ((tae-tr-elem-ccl-p tr-elem)
	   (setq slot (nthcdr 3 tr-elem))))
    (if slot
	(setcar slot alist)
      (setq tr-elem (nconc tr-elem (list alist)))))
  tr-elem)

(defsubst tae-assq-tr-elem-option-alist (tr-elem key)
  (assq key (tae-get-tr-elem-option-alist tr-elem)))

(defsubst tae-delq-tr-elem-option-alist (tr-elem key)
  (let ((alist (tae-get-tr-elem-option-alist tr-elem)))
    (tae-set-tr-elem-option-alist
     tr-elem
     (delq (assq key alist) alist))))

(defsubst tae-put-tr-elem-option-alist (tr-elem key value)
  (let* ((alist (tae-get-tr-elem-option-alist tr-elem))
	 (slot (assq key alist)))
    (if slot
	(setcdr slot value)
      (setq alist (cons (cons key value) alist))
      (tae-set-tr-elem-option-alist tr-elem alist))
    slot))

(defsubst tae-tr-elem-set-normalized-flag (tr-elem decodep &optional resetp)
  (tae-put-tr-elem-option-alist
   tr-elem
   'normalized (and (not resetp)
		    (if decodep
			'decode
		      'encode))))

(defsubst tae-tr-elem-normalized-p (tr-elem decodep)
  (eq (cdr (tae-assq-tr-elem-option-alist tr-elem 'normalized))
      (if decodep
	  'decode
	'encode)))

(defsubst tae-get-tr-elem-all-key (tr-elem)
  (cdr (tae-assq-tr-elem-option-alist tr-elem 'all)))

(defsubst tae-set-tr-elem-all-key (tr-elem value)
  (tae-put-tr-elem-option-alist tr-elem 'all value))

(defun tae-check-and-normalize-range (range-list)
  (let (reduced-range
    	max-rl
	max-re
	min-rl
	min-re)
    (mapcar
     (lambda (x)
       (if (numberp x) (setq x (cons x x))
	 (if (not (and (numberp (car x))
		       (numberp (cdr x))
		       (>= (cdr x) (car x))))
	     (error "Invalid range!:%S" x)))

       (setq  min-re (car reduced-range)
	      min-rl (cons nil reduced-range))
       (while 
	   (if (null min-re)
	       (progn
		 (setq reduced-range
		       (nconc reduced-range
			      (list x)))
		 nil)
	     (if (<= (car x) (1+ (cdr min-re)))
		 (progn

		   ;; (message "%S: (%S-->)" x min-re)

		   (setq  max-re min-re
			  max-rl min-rl)
		   (while
		       (and (> (1+ (cdr x)) (cdr max-re))
			    (setq max-rl (cdr max-rl)
				  max-re (car (cdr max-rl)))))

		   ;;; fix up list
		   ;;; (message "%S: (%S<->%S)" x min-re max-re)

		   (if (< (car x) (car min-re))
		       (setcar min-re (car x)))
		   (if (> (cdr x) (cdr min-re))
		       (setcdr min-re (cdr x)))
		   (if (and max-re
			    (<= (car max-re)(cdr min-re)))
		       (progn
			 (setcdr min-re (cdr max-re))
			 (setq max-rl (cdr max-rl))))
		   (setcdr (cdr min-rl) (cdr max-rl))

		   nil)
	       (setq min-rl (cdr min-rl)
		     min-re (car (cdr min-rl)))
	       t))))
     range-list)
;;    (mapcar
;;     (lambda (x)
;;       (if (eq (car x) (cdr x))
;;	   (car x)
;;	 x))
;;     reduced-range)
    reduced-range
    ))

(defun tae-normalize-translation (tr-elem decodep)
  "Normalized TR.
TR-ELEM, the translation element, are reduced to
ASSOC or CCL program. 
But, we have not be able to reduce
Emacs Lisp Function to CCL program yet.
And then, if the translation-element is ASSOC, sort it.

When decodep is non-nil, normalize for decording."
  (setq tr-elem (copy-sequence tr-elem))
  (cond ((tae-tr-elem-assoc-p tr-elem)
	 (let ((curll (tae-get-tr-elem-assoc tr-elem))
	       curel alist-copy all-slot)
	   
	   ;;; copy alist and remove 'all and invalid slot.
	   (if decodep
	     (while 
		 (and (setq curel (car curll))
		      (cond ((eq (cdr curel) 'all)
			     (setq all-slot curel)
			     nil)
			    ;; skip the slot
			    ((or (eq (car curel) 'all)
				 (eq (cdr curel) 'invalid))
			     (setq curll (cdr curll)))
			    (t
			     (setq alist-copy (cons (cons (car curel)
							  (cdr curel))
						    alist-copy))
			     (setq curll (cdr curll))))))
	     (while 
		 (and (setq curel (car curll))
		      (cond ((eq (car curel) 'all)
			     (setq all-slot curel)
			     nil)
			    ;; skip the slot
			    ((or (eq (cdr curel) 'all)
				 (eq (car curel) 'invalid))
			     (setq curll (cdr curll)))
			    (t
			     (setq alist-copy (cons (cons (car curel)
							  (cdr curel))
						    alist-copy))
			     (setq curll (cdr curll)))))))

	 (tae-set-tr-elem-assoc
	  tr-elem
	  (nconc
	   (sort alist-copy
		 (if decodep
		     (lambda (x y) (< (cdr x) (cdr y)))
		   (lambda (x y) (< (car x) (car y)))))))
	 (if all-slot
	     (tae-set-tr-elem-all-key tr-elem
				      (if decodep
					  (car all-slot)
					(cdr all-slot))))
	 ))

	((tae-tr-elem-elisp-p tr-elem)
	 (let ((range-list (tae-check-and-normalize-range
			    (tae-get-tr-elem-range tr-elem)))
	       (func (tae-get-tr-elem-elisp-func tr-elem))
	       range-elem
	       i j
	       alist)
	   (while (setq range-elem (car range-list))
	     (cond ((numberp range-elem)
		    (setq alist (cons
				 (cons range-elem
				       (funcall func range-elem))
				 alist)))
		   ((consp range-elem)
		    (setq i (car range-elem)
			  j (cdr range-elem))
		    (while (<= i j)
		      (setq alist (cons
				   (cons i
					 (funcall func i))
				   alist)
			    i (1+ i))))
		   (t
		    (error "Invalid range:%S" range-elem)))
	     (setq range-list (cdr range-list)))
	   (setq tr-elem
		 (list 'assoc
		       (tae-get-tr-elem-type-spec tr-elem)
		       (nreverse alist)))))

	((tae-tr-elem-ccl-p tr-elem)
	 )
	)
  (tae-tr-elem-set-normalized-flag tr-elem decodep)
  tr-elem)

(defun tae-reduce-OR-translations (tr-elems decodep)
  "Reduce `OR' translations.
TR-ELEMS must be a list that consists of TR-ELEMs
that must be normalized.
When DECODEP is t, reduce for decodeing translation."
  (let ((tr1 (car tr-elems))
	(tr2 (nth 1 tr-elems))
	(tr-curl (cdr tr-elems))
	result-list result)
    (while (and tr2
		(not (tae-get-tr-elem-all-key tr1)))
      (setq result
	    (cond ((and (tae-tr-elem-assoc-p tr1)
			(tae-tr-elem-assoc-p tr2))
		   (let* ((alist1 (tae-get-tr-elem-assoc tr1))
			  (alist2 (tae-get-tr-elem-assoc tr2))
			  (cur-ll2 alist2)
			  cur-ll1
			  cur-el1 cur-el2
			  result)
		     (setq cur-el1 (car alist1)
			   cur-ll1 (cons nil alist1))
		     (while (setq cur-el2 (car cur-ll2))
		       (while 
			   (progn
			     (cond ((if decodep
					(> (cdr cur-el1)
					   (cdr cur-el2))
				      (> (car cur-el1)
					 (car cur-el2)))
				    (if (null (car cur-ll1))
					(setq alist1
					      (cons cur-el2
						    alist1))
				      (setcdr cur-ll1
					      (cons cur-el2
						    (cdr cur-ll1))))
				    nil)
				   ((if decodep
					(= (cdr cur-el1)
					   (cdr cur-el2))
				      (= (car cur-el1)
					 (car cur-el2)))
				    nil)
				   (t
				    (setq cur-ll1 (cdr cur-ll1))
				    (if (setq cur-el1 (car (cdr cur-ll1)))
					t
				      (setq alist1 (nconc alist1
							  cur-ll2)
					    cur-ll2 nil)
				      nil)))))
		       (setq cur-ll2 (cdr cur-ll2)))
		     ;; making assoc tr-elem
		     (setq result
			   (list 'assoc
				 ;; TYPE spec
				 (tae-get-tr-elem-type-spec tr1)
				 ;; Association
				 alist1))

		     ;; set all key
		     (tae-set-tr-elem-all-key
		      result
		      (tae-get-tr-elem-all-key tr2))

		     result))

		  ((and (or (tae-tr-elem-ccl-p tr1)
			    (tae-tr-elem-elisp-p tr1))
			(or (tae-tr-elem-ccl-p tr2)
			    (tae-tr-elem-elisp-p tr2)))
		   nil)
		  ((or (tae-declared-translation-p tr1)
		       (tae-declared-translation-p tr2))
		   nil)
		  (t
		   (error "Unknown translations:%S, %S" tr1 tr2))
		  ))
      (if result
	  (progn
	    (tae-tr-elem-set-normalized-flag result decodep)
	    (setq tr1 result))
	(setq result-list (cons tr1 result-list)
	      tr1 tr2))
      (setq tr-curl (cdr tr-curl)
	    tr2 (car tr-curl)))
    (setq result-list (cons tr1 result-list))
    (nreverse result-list)))

(defun tae-reduce-AND-translations (tr-elems decodep)
  "Reduce `AND' translations.
TR-ELEMS must be a list that consists of TR-ELEMs
that must be normalized.
When DECODEP is t, reduce for decodeing translation."
  (let ((tr1 (car tr-elems))
	(tr2 (nth 1 tr-elems))
	(tr-curl (cdr tr-elems))
	result-list result)
    (while tr2
      (if (and (tae-get-tr-elem-all-key tr1)
	       (tae-get-tr-elem-all-key tr2))
	  (setq result tr1)
	(if (not (tae-get-tr-elem-all-key tr2))
	    (tae-set-tr-elem-all-key tr1 nil))
	(setq result
	      (cond ((and (tae-tr-elem-assoc-p tr1)
			  (tae-tr-elem-assoc-p tr2))
		     (let* (result-alist
			    (alist1 (tae-get-tr-elem-assoc tr1))
			    (alist2 (tae-get-tr-elem-assoc tr2))
			    (cur-ll2 alist2)
			    cur-ll1
			    cur-el1 cur-el2)
		       (while (setq cur-el2 (car cur-ll2))
			 (setq cur-el1 (car alist1)
			       cur-ll1 (cons nil alist1))
			 (while 
			     (progn
			       (cond ((if decodep
					  (= (cdr cur-el1)
					     (cdr cur-el2))
					(= (car cur-el1)
					   (car cur-el2)))
				      (setq result-alist
					    (cons cur-el2 result-alist))
				      nil)
				     (t
				      (setq cur-ll1 (cdr cur-ll1)
					    cur-el1 (car (cdr cur-ll1)))
				      ))))
			 (setq cur-ll2 (cdr cur-ll2)))
		       (list 'assoc
			     (tae-get-tr-elem-type-spec tr1)
			     result-alist)))
		    ((and (or (tae-tr-elem-ccl-p tr1)
			      (tae-tr-elem-elisp-p tr1))
			  (or (tae-tr-elem-ccl-p tr2)
			      (tae-tr-elem-elisp-p tr2)))
		     nil)
		    ((or (tae-declared-translation-p tr1)
			 (tae-declared-translation-p tr2))
		     nil)
		    (t
		     (error "Unknown translations:%S, %S" tr1 tr2))
		    )))
      (if result
	  (progn
	    (tae-tr-elem-set-normalized-flag result decodep)
	    (setq tr1 result))
	(setq result-list (cons tr1 result-list)
	      tr1 tr2))
      (setq tr-curl (cdr tr-curl)
	    tr2 (car tr-curl)))
    (setq result-list (cons tr1 result-list))
    (nreverse result-list)))

(defun tae-reduce-composite-translations (tr-elems decodep)
  "Reduce `composite' translations.
TR-ELEMS must be a list that consists of TR-ELEMs
that must be normalized.
When DECODEP is t, reduce for decodeing translation."
  (let ((tr1 (car tr-elems))
	(tr2 (nth 1 tr-elems))
	(tr-curl (cdr tr-elems))
	tr1-all-key
	tr2-all-key
	result-list result)
    (while tr2
      (setq tr1-all-key (tae-get-tr-elem-all-key tr1)
	    tr2-all-key (tae-get-tr-elem-all-key tr2))
      (setq result
	    (cond ((and (tae-tr-elem-assoc-p tr1)
			(tae-tr-elem-assoc-p tr2))
		   (let* (result-alist
			  (alist1 (tae-get-tr-elem-assoc tr1))
			  (alist2 (tae-get-tr-elem-assoc tr2))
			  (cur-ll2 alist2)
			  cur-ll1
			  cur-el1 cur-el2
			  tr-new-all-key)
		     (while (setq cur-el2 (car cur-ll2))
		       (setq cur-el1 (car alist1)
			     cur-ll1 (cons nil alist1))
		       (while 
			   (progn
			     (cond ((= (cdr cur-el1)
				       (car cur-el2))
				    (setq result-alist
					  (cons
					   (cons (car cur-el1)
						 (cdr cur-el2))
						result-alist))
				    ;; remove slot at encoding time.
				    (if (not decodep)
					(if (null (car cur-ll1))
					    (setq alist1 (cdr alist1))
					  (setcdr cur-ll1 (cdr cur-ll1))))

				    nil)

				   (t
				    (setq cur-ll1 (cdr cur-ll1)
					  cur-el1 (car (cdr cur-ll1))))
				   )))

		       (if tr1-all-key
			   (if decodep
			       (setq result-alist
				     (cons
				      (cons tr1-all-key
					    (car cur-el2))
				      result-alist))
			     (if (and (null tr-new-all-key)
				      (= tr1-all-key (car cur-el2)))
				 (setq tr-new-all-key (cdr cur-el2)))
				 ))
		       (setq cur-ll2 (cdr cur-ll2)))

		     ;; operate tr2-all-key
		     (if tr2-all-key
			 (if decodep
		     ;;; At decoding, find out its correspond slot in alist1.
			     (setq tr-new-all-key
				   (car (rassq tr2-all-key alist1)))
		     ;;; At encoding, append rest alist1.
			   (setq cur-ll1 alist1)
			   (while cur-ll1
			     (setq result-alist
				   (cons
				    (cons (car (car cur-ll1))
					  tr2-all-key)
				    result-alist)
				   cur-ll1 (cdr cur-ll1)))
			   (if (null tr-new-all-key)
			       (setq tr-new-all-key
				     tr2-all-key))))

		     (list 'assoc 
			   (tae-get-tr-elem-type-spec tr1)
			   result-alist
			   (list (cons 'all tr-new-all-key)))
		     ))
		  ((and (or (tae-tr-elem-ccl-p tr1)
			    (tae-tr-elem-elisp-p tr1))
			(or (tae-tr-elem-ccl-p tr2)
			    (tae-tr-elem-elisp-p tr2)))
		   nil)
		  ((or (tae-declared-translation-p tr1)
		       (tae-declared-translation-p tr2))
		   nil)
		  (t
		   (error "Unknown translations:%S, %S" tr1 tr2))
		  ))
      (if result
	  (setq tr1 (tae-normalize-translation result decodep))
	;;; unreduced
	(setq result-list (cons tr1 result-list)
	      tr1 tr2))
      (setq tr-curl (cdr tr-curl)
	    tr2 (car tr-curl)))
    (setq result-list (cons tr1 result-list))
    (nreverse result-list)))

(defun tae-reduce-composite-transparent-translations (tr-elems decodep)
  "Reduce `composite' translations.
TR-ELEMS must be a list that consists of two TR-ELEMs
that must be normalized.
When DECODEP is t, reduce for decodeing translation."
  (if (/= (length tr-elems) 2)
      (error "Composite Transparent requires two arguments:%S"
	     tr-elems))
  (let ((copied (copy-sequence (car tr-elems))))
    (setq tr-elems
	  (tae-reduce-composite-translations tr-elems decodep))
    (setq tr-elems (mapcar
		    (lambda (x)
		      (if (tae-tr-elem-normalized-p x decodep)
			  x
			(tae-normalize-translation x decodep)))
		    tr-elems))
    (tae-reduce-OR-translations
     (nconc tr-elems (list copied)) decodep)))

;;
;;
;;

(defun tae-normalize-reduction-unit (unit &optional decodep)
  "Destructively, normalize reduction unit.
This function checks type-spec of UNIT, and
according to it, rearrange the elements of UNIT."
  (let ((cur-ll unit)
	cur-el)
  (while (setq cur-el (car cur-ll))
    (if (tae-tr-elem-p cur-el)
	(if (tae-tr-elem-normalized-p cur-el decodep)
	    nil
	  (setcar cur-ll (tae-normalize-translation cur-el decodep)))
      (setcar cur-ll (tae-reduce-translation cur-el decodep)))
    (setq cur-ll (cdr cur-ll))))
  unit)

(defun tae-reduce-translation (translation &optional decodep)
  "Reduce translation."
  (if (or (tae-declared-translation-p translation)
	  (tae-tr-elem-p translation))
      translation
    (let ((op (car translation))
	  (args (copy-sequence (cdr translation))))
      (cond ((eq op '|)
	     (setq args (tae-normalize-reduction-unit args decodep))
	     (setq args (tae-reduce-OR-translations args decodep))
	     (if (= (length args) 1)
		 (car args)
	       (cons '| args)))
	    ((eq op '&)
	     (setq args (tae-normalize-reduction-unit args decodep))
	     (setq args (tae-reduce-AND-translations args decodep))
	     (if (= (length args) 1)
		 (car args)
	       (cons '& args)))
	    ((eq op 'c)
	     (setq args (tae-normalize-reduction-unit args decodep))
	     (setq args 
		   (tae-normalize-reduction-unit
		    (tae-reduce-composite-translations args decodep)
		    decodep))
	     (if (= (length args) 1)
		 (car args)
	       (cons 'c args)))
	    ((eq op 'ct)
	     (setq args (tae-normalize-reduction-unit args decodep))
	     (setq args 
		   (tae-normalize-reduction-unit
		    (tae-reduce-composite-transparent-translations
		     args decodep)
		    decodep))
	     (if (= (length args) 1)
		 (car args)
	       (cons 'ct args)))
	    (t
	     (error "TAE have not supported OP:`%S' yet!!" op))))))

;; TAE message
;;   Not yet fixed :-P.
;;       ((tables . ...) ...???)

;; currently, nested table only --> table-set

;;
;; Produce MYO from translation rule.
;;

(defsubst tae-message-append (mes1 mes2)
  (let ((alist1 mes1)
	(alist2 mes2)
	elem1 elem2)
    (while (setq elem1 (car alist1))
      (if (memq elem1 '(new-type))     ;;;; not merged key list.
	  nil
	(setq elem2 (assq (car elem1) alist2)
	      alist1 (cdr alist1))
	(if elem2
	    (progn
	      (nconc elem1 (cdr elem2))
	      (setq alist2 (delq elem2 alist2))))))
    (nconc mes1 alist2)))

(defsubst tae-message-add (message key data)
  (nconc (assq key message) (list data))
  message)

(defsubst tae-message-get (message key)
  (cdr (assq key message)))

(defsubst tae-message-put (message key value)
  (setcdr (assq key message) value))

(defsubst tae-message-table-add (message &rest tables)
  (let ((slot (assq 'tables message)))
    (if slot
	(progn
	  (setcdr slot
		  (nconc (cdr slot) tables))
	  message)
      (cons (cons 'tables tables) message))))

(defsubst tae-message-new-type-set (message type)
  (let ((slot (assq 'new-type message)))
    (if slot
	(progn
	  (setcdr slot type)
	  message)
      (cons (cons 'new-type type) message))))

(defun tae-compile-translation-element (tr-elem type decodep)
  (let* ((type-spec (tae-get-tr-elem-type-spec tr-elem))
	 (from-type (if decodep
			(cdr type-spec)
		      (car type-spec)))
	 (to-type (if decodep
		      (car type-spec)
		    (cdr type-spec)))
	 (type-func (mucs-type-get-ccl-representation type))
	 (to-func (mucs-type-get-ccl-representation to-type))
	 (conv-func (if (eq type from-type)
			'identity
		      (mucs-type-get-conversion from-type type)))
	 (tr-elem-all-key (tae-get-tr-elem-all-key tr-elem))
	 conv-slot
	 result)
    (if (null conv-func)
	(error "TYPE:%S cannot be converted to %S" from-type type))
    (setq result
	  (cond ((tae-tr-elem-assoc-p tr-elem)
		 (if (not (tae-tr-elem-normalized-p tr-elem decodep))
		     (error "TAE cannot compile unnormalized translation:%S"
			    tr-elem))
		   
		   ;; type-func, conv-func, and to-func are bound by the above `let'.
		   ;; Owing to Dynamic Binding of Emacs, this function can call
		   ;; a function bounded by them respectively.
		 (setq conv-slot (if decodep
				     (lambda (x)
				       (cons
					(funcall type-func
						 (funcall conv-func (cdr x)))
					(funcall to-func (car x))))
				   (lambda (x)
				     (cons
				      (funcall type-func
					       (funcall conv-func (car x)))
				      (funcall to-func (cdr x))))))
		 (list 
		  (cons 'tables
			(nconc
			 (make-code-conversion-tables
			  (tae-get-tr-elem-assoc tr-elem)
			  conv-slot)
			 ;;;;; We should replace nested table-set.???
			 (if tr-elem-all-key
			     (list
			      (tae-project-all-translation-vector
			       tr-elem-all-key))
			   nil)
			 ))))

		((tae-tr-elem-ccl-p tr-elem)
		 (list (cons 'ccl (tae-get-tr-elem-ccl tr-elem))))

		((tae-tr-elem-elisp-p tr-elem)
		 (error "TAE cannot compile Elisp translation element directly:%S"
			tr-elem))))

    (tae-message-new-type-set result to-type)))

(defun tae-compile-OR-operation (translations type decodep)
  (let (tr result results to-type new-type)
    (while (setq tr (car translations))
      (setq translations (cdr translations)
	    result (tae-get-compiled-products-internal tr type decodep)
	    new-type (cdr (assq 'new-type result)))

      ;;; type operation.
      (if to-type
	  (if (not (eq to-type new-type))
	      (error "TYPE mismatch:between %S and %S"
		     to-type new-type))
	(setq to-type new-type)
	(setq results
	      (tae-message-new-type-set results to-type)))

      (setq results
	    ;;;; only append .... :-P think more.
	    ;;;; At this stage, tables of declared translation are
	    ;;;; made into one (or more) table-set.  Hence, the tables
	    ;;;; slot are NOT merged.  But we can retrieve
	    ;;;; an alist like (... (table-set ...) ... (tables ...))
	    ;;;; Since the tables slot will be made into a table-set slot at
	    ;;;; later stage, we will have an alist like
	    ;;;; (... (table-set) ... (table-set) ).
	    ;;;; This is very dirty, thus I should implement
	    ;;;; nested table-set as soon as possible.
	    (tae-message-append results result))
      )
    results))

(defun tae-compile-AND-operation (translations type decodep)
  (error "Not supported yet:"))

(defun tae-compile-composite-operation (translations type decodep)
  (error "Not supported yet:"))
(defun tae-compile-composite-transparent-operation (translations type decodep)
  (error "Not supported yet:"))

(defsubst tae-get-compiled-products-internal (translation type decodep)
  (let (op args)
    (if (consp translation)
	(setq op (car translation)
	      args (cdr translation)))
    (cond ((tae-declared-translation-p translation)
	    (tae-get-compiled-products translation type decodep))
	   ((tae-tr-elem-p translation)
	    (tae-compile-translation-element translation type decodep))
	   ((eq op '|)
	    (tae-compile-OR-operation args type decodep))
	   ((eq op '&)
	    (tae-compile-AND-operation args type decodep))
	   ((eq op 'c)
	    (tae-compile-composite-operation args type decodep))
	   ((eq op 'ct)
	    (tae-compile-composite-transparent-operation args type decodep))
	   (t
	    (error "TAE have not supported OP:`%S' yet!!" op)))))

(defun tae-get-compiled-products (name type decodep)
  (let ((products (tae-get-translation-produced-products
		   name mucs-current-type decodep))
	tables-slot
	tables
	table-set
	reduced-sym
	translation)
    (if products
	products
      (setq reduced-sym (if decodep
			    'tae-reduced-translation-for-decode
			  'tae-reduced-translation-for-encode)
	    translation (or (get name reduced-sym)
			    (put name reduced-sym
				 (tae-reduce-translation
				  (symbol-value name)
				  decodep)))
	    products (tae-get-compiled-products-internal
		      translation type decodep))

      ;;; convert tables to table-set.
      (setq tables-slot (assq 'tables products))
      (if tables-slot
	  (progn
	    (setq tables (cdr tables-slot)
		  table-set (intern
			     (tae-generate-translation-table-set-name
			      name decodep)))
	    (if (null tables)
		(error "In one TAE message, tables element exists more than once.")

	      (tae-translation-add-table-set name table-set)
	      (define-table-set table-set tables)

	      (setcar tables-slot 'table-set)
	      (setcdr tables-slot table-set))))

      (tae-set-translation-produced-products
       name type decodep products)
      products)))

;; API for compilation.


(defun tae-compile (name &optional decodep applied-type)
  "Retrieve MYO from the declared translation.
NAME must be a declared translation."
  (if (not (tae-declared-translation-p name))
      (error "Undeclared or invalid translation:%S" name))
  (let* ((type (or applied-type
		   mucs-current-type))
	 (products (tae-get-compiled-products name type decodep))
	 (result-myo (mucs-ccl-empty-myo))
	 (tae-translation-table-set-index
	  tae-translation-table-set-index)
	 pr-el
	 table-set table-syms table-syms-nested-p)
    (while (setq pr-el (car products))
      (setq products (cdr products))
      (cond ((eq 'table-set (car pr-el))
	     (setq table-set (cdr pr-el)
		   table-syms
		   (append table-syms
			   (get-table-set-symbol-tables table-set))
		   result-myo (mucs-ccl-myo-add-table-set
			       table-set result-myo))
	     (if (table-set-nested-p table-set)
		 (setq table-syms-nested-p t)))

	    ((eq 'new-type (car pr-el))
	     (setq mucs-current-type (cdr pr-el)))

	    (t
	     (error "Internal error.  unknown TAE message:%S" pr-el)
	     )))
    (if table-syms-nested-p
	(mucs-ccl-myo-add-ccl
	 `((r1 = 0)
	   (map-multiple r1 r0 ,table-syms))
	 result-myo)
      (mucs-ccl-myo-add-ccl
       `((r1 = 0)
	 (iterate-multiple-map r1 r0 ,@table-syms))
       result-myo))
    result-myo))

;; MAPPING FUNCTION
;;
;;  mapping functions are 
;;

;; this is a temporal function.

(defun tae-generate-union-func-map (funcs decodep)
  "Make a union function from a list of functions."
  (let (elem func-alist tables ctables)
    (while funcs
	(setq elem (car funcs)
	      funcs (cdr funcs))
	(cond ((table-set-p elem)
	       (setq ctables
		     (get-table-set-symbol-tables elem decodep)
		     tables (append tables ctables)))
	       (t
		(error "Not yet supported type! %S" elem))))
	tables))

(defun tae-generate-func-to-func-map (funcs decodep &optional type)
  "Recieve a-list of (TAG . function)s.
Return a-list<CAR> (TAG . TABLE-NO(index of <CDR> list from 0)) and
a list<CDR> (TABLE<SYMBOL> TABLE<SYMBOL> ...)."
  (let ((idx 0) tbl-alist tbl-c
	elem elemt elemf func-alist tables)
    (while (setq elem (car funcs))
      (setq elemt (car elem)
	    elemf (cdr elem)
	    funcs (cdr funcs))
      (cond ((table-set-p elemf)
	     (if (setq tbl-c (assq elemt tbl-alist))
		 (setcdr tbl-c
			 (nconc
			  (cdr tbl-c)
			  (get-table-set-tables elemf decodep)))
	       (setq tbl-alist
		     (nconc
		      tbl-alist
		      (list
		       (cons elemt
			     (get-table-set-tables elemf decodep)))))))
	    (t
	     (error "Not yet supported type! %S" elem))))
    (while (setq elem (car tbl-alist))
      (setq elemt (car elem)
	    elemf (cdr elem)
	    tbl-alist (cdr tbl-alist)
	    func-alist (cons
			(cons elemt
			      (cond ((eq type 'symbol)
				     (car elemf))
				    (t idx)))
			func-alist)
	    idx (+ idx (length elemf) 1)
	    tables (append tables
			   (if tables
			       '(tae-cease-translation-table)
			     nil)
			   elemf)))
    (cons func-alist tables)))

;; Generative Functions
;;

(defun tae-function-union-1 (func1 func2))
(defun tae-function-union-2 (func1 func2))

(defun tae-function-intersection-1 (func1 func2))
(defun tae-function-intersection-2 (func1 func2))

(defun tae-function-compose-1 (func1 func2))
(defun tae-function-compose-2 (func1 func2))

(defun tae-function-to-function (func1 reg))

(provide 'tae)
