;;; -*- coding: iso-2022-7bit  -*-
;;; mucs.el --- for MULE-UCS configuration

;; Copyright (C) 1997-1999 Miyashita Hisashi

;; Keywords: mule, multilingual, 
;;           character set, coding-system, ISO10646, Unicode

;; This file is part of MULE-UCS

;; MULE-UCS is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; MULE-UCS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;; Comment:

;; 0.50->MYOSHIN-JI.
(defconst mucs-version "0.52(TAIZO-IN:$BB`B"1!(B)")

;;; fundamental data.

(defvar emacs-value-bits 28)
(defvar mucs-code-range-bits 24)
(defvar mucs-data-path "reldata/")
(defvar mucs-invalid-code -1
  "invalid code.  If this value is set, skip operation.")

(defun mucs-require-data (package)
  (or (featurep package)
      (load (expand-file-name (symbol-name package)
			      mucs-data-path)
	    t)
      (require package)))

(defun mucs-max-code ()
  (1- (lsh 1 mucs-code-range-bits)))

(defun mucs-number-mask ()
  (lognot 0))

;;; Package management.

(defvar mucs-current-package nil)

(defvar mucs-current-type nil
  "MUCS-UCS code generator's internal variable.
This variable specifies the type of data that the current context stores.")

(defmacro mucs-define-package (package &rest form)
  "Enclose a unit of package with this.
By this specification, MULE-UCS may judge
whether generate a new program to prepare.
You should make PACKAGE same of your package name
that you set in `provide' function."
  (if (not (symbolp package))
      (signal 'wrong-type-argument package))
  (setq mucs-current-package package)
  (put mucs-current-package 'mucs-registered-tables nil)
  (put mucs-current-package 'mucs-registered-ccls nil)
  (append
   `(let ((mucs-current-package (quote ,package))))
   form))

;;;
;;; Character representation.
;;;    CCL can't treat character itself as it is, as well as Emacs.
;;;    Since CCL can deal with only numbers currently, we must manage
;;;    to convert character to number.
;;;
;;;    But, like XEmacs, some systems distinguish between number and
;;;    character.  In addition, Emacs may give some abstraction
;;;    to characters.  Therefore MULE-UCS should prepare certain
;;;    abstraction layer to represent character format on CCL.

;;;    MULE-UCS prepare `TYPE' to give any kind of representations
;;;    defined by users to data sturucture to be translated.
;;;    Users can define any representation on translation in their fashion.

;;;
;;;
;;;

(defmacro mucs-define-simple-coding-system
  (symbol mnemonic doc-string decode-tr encode-tr &optional alist)
  (require 'mucs-ccl)
  (let ((encode-ccl-data (mucs-ccl-setup-ccl-program encode-tr))
	(decode-ccl-data (mucs-ccl-setup-ccl-program decode-tr))
	(alist-val (eval alist))
	(ccl-symbol-func
	 (lambda (suf)
	   (intern (format "%s-%s" (symbol-name symbol) suf))))
	ccl-encode-sym
	ccl-decode-sym)
    (setq ccl-encode-sym
	  (funcall ccl-symbol-func "ccl-encoder")
	  ccl-decode-sym
	  (funcall ccl-symbol-func "ccl-decoder"))

    (mucs-ccl-add-registration ccl-encode-sym)
    (mucs-ccl-add-registration ccl-encode-sym)

    `(progn
       ,@(car encode-ccl-data)
       ,@(car decode-ccl-data)
       (declare-ccl-program 
	 ,ccl-encode-sym
	 ,(cdr encode-ccl-data))
       (declare-ccl-program
	 ,ccl-decode-sym
	 ,(cdr decode-ccl-data))
       (make-coding-system
	(quote ,symbol) 4 ,mnemonic ,doc-string 
	(quote ,(cons ccl-decode-sym
		      ccl-encode-sym))
	(quote ,alist-val)))))

(provide 'mucs)
