;;; texi2info.el --- format Texinfo files into Info files non-interactively.

;; Copyright (C) 2000 IIDA Yosiaki

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2 of the License, or
;; (at your option) any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; if not, write to the Free Software
;; Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
;; 02111-1307, USA

;; @(#) $Id$

;; Maintainer: IIDA Yosiaki <iida@ring.gr.jp>
;; Keywords: maint, tex, docs

;;; Code:

;;; Emacs Lisp functions to convert Texinfo files to Info files
;;; non-interactively.

;; We do this here now -- before inserting Texinfo stuffs.
(if noninteractive
    (set-language-environment "Japanese"))

(defun gph-texi2info ()
  "Format Texinfo files into Info files non-interactively.
It is supposed to use like the following:
emacs --batch -l texi2info.el --insert FOOBAR.texi -f gph-texi2info --kill

The RCS ID of this code is:
@(#) $Id: texi2info.el,v 1.3 2000-09-22 11:10:32+09 iida Exp $"
  (set-buffer-file-coding-system 'euc-jp nil)
  (mark-whole-buffer)
  (let ((bmp (buffer-modified-p))
	buffer-read-only)
    (save-excursion
      (texinfo-sequential-node-update t)
      (texinfo-all-menus-update ())
      (texinfo-format-buffer t)
      (save-buffer))
    (set-buffer-modified-p bmp)))

;;; texi2info.el ends here.
