iftexi(@node Command Reference
)dnl
beginreference()dnl
tagdocinfo([[$Id: c6.sgml,v 1.13 1999/12/19 01:25:19 jashley Exp $]])dnl
tagtitle([[iyiftexi([[dnl]])
iydraft(
Command Reference
,
ޥɻ
)]])

beginpartintro
beginappendixsec()dnl
tagtitle([[iyiftexi([[dnl]])
iydraft(
Key specifiers
,

)]])

beginpara
iydraft([[dnl
Many commands and options require a tagfirstterm(key specifier).
A key specifier is the key ID or any portion of ther user ID of
a key.
Consider the following example.
]],[[dnl
ޥɤ䥪ץ¿ϡ
tagfirstterm()ɬפǤ
ҤϡIDޤϡΥ桼IDǤդʬǤ
򸫤Ƥ
]])dnl

beginscreen(width="80")
tagprompt(alice%) taguserinput(gpg --list-keys chloe)
pub  1024D/B87DBA93 1999-06-28 Chloe (Jester) taglt()chloe[[]]atmark[[]]cyb.org>
uid                            Chloe (Plebian) taglt()chloe[[]]atmark[[]]tel.net>
sub  2048g/B7934539 1999-06-28
endscreen

iydraft([[dnl
For this key, tagliteral(0xB87DBA93),
tagliteral(Chloe),
tagliteral(Plebian), and
tagliteral(oe[[]]atmark[[]]tel)
are all examples of key specifiers that match the above key.
]],[[dnl
θѤˡ
tagliteral(0xB87DBA93)
tagliteral(Chloe)
tagliteral(Plebian)
tagliteral(oe[[]]atmark[[]]tel)
ϡҤθб븰ҤΤ٤ƤǤ
]])dnl
endpara
endsection
endpartintro
iftexi([[
@menu
* sign-doc::                    
* detach-signature::            
* encrypt::                     
* symmetric::                   
* decrypt::                     
* clearsign::                   
* verify::                      
* gen-key::                     
* gen-revoke::                  
* send-keys::                   
* recv-keys::                   
* list-keys::                   
* list-public-keys::            
* list-secret-keys::            
* list-sigs::                   
* check-sigs::                  
* fingerprint::                 
* import::                      
* fast-import::                 
* export::                      
* export-all::                  
* export-secret-keys::          
* edit-key::                    
* sign-key::                    
* lsign-key::                   
* delete-key::                  
* delete-secret-key::           
* store::                       
* export-ownertrust::           
* import-ownertrust::           
* update-trustdb::              
* print-md::                    
* gen-random::                  
* gen-prime::                   
* version::                     
* warranty::                    
* help::                        
@end menu]])dnl

beginrefentry(sign-doc)
beginrefnamediv
tagrefname(sign)
tagrefpurpose(iydraft(
sign a document
,
ʸ˽̾
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(sign) tagreplaceableparam(filename)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
This command signs the document 
tagreplaceableparam(filename).
If the parameter tagreplaceableparam(filename)
is omitted, then the document to sign is taken from standard input.
If the option taglink(output,tagoption(output)) is used,
taggpg will output the signed information to the specified file.
]],[[dnl
Υޥɤϡʸtagreplaceableparam(filename)˽̾򤷤ޤ
ѥ᡼tagreplaceableparam(filename)άȡ
ɸϤ̾ʸȤޤ
taglink(output,tagoption(output))ץȤȡ
taggpgϡ̾줿Υե˽Ϥޤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(detach-signature)
beginrefnamediv
tagrefname(detach-signature)
tagrefpurpose(iydraft(
make a detached signature
,
ʬΥ̾
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(detach-signature) tagreplaceableparam(filename)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
This command creates a signature file that can be used 
to verify that the original file 
tagreplaceableparam(filename) has not
been changed.  
Verification of the file using a detached signature is done using the 
command taglink(verify,tagoption(verify)).
]],[[dnl
Υޥɤϡ
եtagreplaceableparam(filename)
θʸѤäƤʤȤ򸡾ڤ뤿˻Ȥ̾եޤ
ʬΥ̾Ȥեθڤˤϡ
taglink(verify,tagoption(verify))ޥɤȤޤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(encrypt)
beginrefnamediv
tagrefname(encrypt)
tagrefpurpose(iydraft(
encrypt a document
,
ʸΰŹ沽
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(encrypt) tagreplaceableparam(filename)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
This command encrypts the document 
tagreplaceableparam(filename) to
recipients specified using the 
option taglink(recipient,tagoption(recipient)).
If the parameter tagreplaceableparam(filename)
is omitted, then the document to encrypt is taken from standard input.
If the option tagoption(recipient) is omitted,
taggpg will prompt for a recipient.
If the option taglink(output,tagoption(output)) is used,
taggpg will output the encrypted information to the specified file.
]],[[dnl
Υޥɤϡ
taglink(recipient,tagoption(recipient))
ץǻꤷͤˤƤơ
ʸtagreplaceableparam(filename)Ź沽ޤ
ѥ᡼tagreplaceableparam(filename)άȡ
Ź沽ʸϡɸϤȤޤ
tagoption(recipient)ץ󤬾άȡ
taggpgϡͤϤԤޤ
taglink(output,tagoption(output))
ץȤȡŹ沽ϡΥե˽Ϥޤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(symmetric)
beginrefnamediv
tagrefname(symmetric)
tagrefpurpose(iydraft(
encrypt a document using only a symmetric encryption algorithm
,
оΰŹ沽르ꥺȤäʸΰŹ沽
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(symmetric) tagreplaceableparam(filename)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
This command encrypts a document using a symmetric algorithm with
a key derived from a passphrase supplied by you during execution.
The key should be selected to make it difficult to randomly guess the key.
To decrypt a document encrypted in this manner use the command
taglink(decrypt,tagoption(decrypt)).
]],[[dnl
Υޥɤϡ
¹Իˤѥե졼ǤĤäоŪ르ꥺǡ
ʸŹ沽ޤ
ꤷο¬񤷤ʤ褦
򤹤٤Ǥ
ˡǰŹ沽ʸˤϡ
taglink(decrypt,tagoption(decrypt))
ޥɤȤäƤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(decrypt)
beginrefnamediv
tagrefname(decrypt)
tagrefpurpose(iydraft(
decrypt an encrypted document
,
Ź沽ʸ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(decrypt) tagreplaceableparam(filename)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
This command decrypts tagreplaceableparam(filename)
and puts the result on standard output.
If the parameter tagreplaceableparam(filename)
is omitted, then the document to decrypt is taken from standard input.
Use the option taglink(output,tagoption(output))
to output the decrypted message to a file instead.
]],[[dnl
Υޥɤϡ
tagreplaceableparam(filename)椷
̤ɸϤ˽񤭤ޤ
ѥ᡼tagreplaceableparam(filename)άȡ
椹ʸϡɸϤȤޤ
椷åե˽Ϥˤϡ
taglink(output,tagoption(output))ץȤޤ
]])dnl
endpara
endrefsect1
endrefentry


beginrefentry(clearsign)
beginrefnamediv
tagrefname(clearsign)
tagrefpurpose(iydraft(
make a cleartext signature
,
ʿʸ̾
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(clearsign) tagreplaceableparam(filename)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
This command signs a message that can be verified to ensure that the 
original message has not been changed.
Verification of the signed message is done using the command
taglink(verify,tagoption(verify)).
]],[[dnl
ΥޥɤϡåθʸѤäƤʤȤְ㤤ʤڤǤ褦
å˽̾ޤ
̾åθڤˤϡ
taglink(verify,tagoption(verify))ޥɤȤޤ
]])dnl

endpara
endrefsect1
endrefentry

beginrefentry(verify)
beginrefnamediv
tagrefname(verify)
tagrefpurpose(iydraft(
verify a signed document
,
ɽ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(verify) tagreplaceableparam(signature document)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
This command verifies a document against a signature
to ensure that the document has not been altered since the signature
was created.
If tagreplaceableparam(signature) is omitted,
taggpg will look in tagreplaceableparam(document)
for a clearsign signature.
]],[[



Υޥɤϡꤷλޤ
ѥ᡼tagreplaceableparam(name)ϡ
ҤǤ
ѥ᡼tagreplaceableparam(name)ʤȡ
ؾΤ٤Ƥθλޤ



]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(gen-key)
beginrefnamediv
tagrefname(gen-key)
tagrefpurpose(iydraft(
generate a new keypair
,
Ф
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(gen-key)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
This command generates a private/public key pair for use in encrypting, 
decrypting, and signing of messages.
You will be prompted for the kind of key you wish to create, the key 
size, and the key's expiration date.
]],[[dnl
Υޥɤϡ
åΰŹ沽桢
̾κݤ˻Ѥ̩/Фޤ
μࡢλϤޤޤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(gen-revoke)
beginrefnamediv
tagrefname(gen-revoke)
tagrefpurpose(iydraft(
generate a revocation certificate for a public/private keypair
,
/̩Ѥ˴
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(gen-revoke) tagreplaceableparam(key)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
This command generates a revocation certificate for a public/private 
key pair.  
The parameter tagreplaceableparam(key) is 
a key specifier.
]],[[dnl
Υޥɤϡ/̩Ѥ˴ޤ
ѥ᡼tagreplaceableparam(key)ϡ
ҤǤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(send-keys)
beginrefnamediv
tagrefname(send-keys)
tagrefpurpose(iydraft(
send keys to a key server
,
Сؤθ
)[[dnl]])


endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(send-keys) tagreplaceableparam(key)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
This command sends a public key to a keyserver.  
The parameter tagreplaceableparam(key) specifies 
the public key that should be uploaded.
The command requires the option
taglink(keyserver,tagoption(keyserver)) to specify
to which keyserver taggpg should send the keys.
]],[[dnl
Υޥɤϡ򸰥Сޤ
ѥ᡼tagreplaceableparam(key)ϡ
åץɤꤷޤ
Υޥɤϡ
taggpgɤθСظΤλˡ
taglink(keyserver,tagoption(keyserver))
ץ󤬤ޤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(recv-keys)
beginrefnamediv
tagrefname(recv-keys)
tagrefpurpose(iydraft(
retrieve keys from a key server
,
СθμФ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(recv-keys) tagreplaceableparam(key-id key-id tagdots)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
This command downloads one or more public keys from a keyserver.  
Each tagreplaceableparam(key-id) is a key ID.
The command requires the option
taglink(keyserver,tagoption(keyserver)) to 
specify from which keyserver taggpg should download the keys.
]],[[dnl
ΥޥɤϡС1ʾθɤޤ
tagreplaceableparam(key-id)ϡIDǤ
Υޥɤϡ
taggpgɤθС鸰ɤΤλˡ
taglink(keyserver,tagoption(keyserver))
ץ󤬤ޤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(list-keys)
beginrefnamediv
tagrefname(list-keys)
tagrefpurpose(iydraft(
list information about keys
,
ξΥꥹ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(list-keys) tagreplaceableparam(key tagdots)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
This command lists the public keys specified by the key specifiers on the
command line.
If no key specifier is given, taggpg will list all of the public keys.
]],
Υޥɤϡ
ޥɹԤθҤǻꤷꥹȤޤ
Ҥʤȡ
ؤΤ٤ƤθꥹȤޤ
)dnl
endpara
endrefsect1
endrefentry

beginrefentry(list-public-keys)
beginrefnamediv
tagrefname(list-public-keys)
tagrefpurpose(iydraft(
list keys on public keyrings
,
ꤷؤθΥꥹ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(list-public-keys) tagreplaceableparam(name tagdots)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
List all keys from public keyrings or just the keys specified with
tagreplaceableparam(name tagdots).
]],[[dnl
tagreplaceableparam(name tagdots)ǻꤷ
ؤΤ٤ƤθꥹȤޤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(list-secret-keys)
beginrefnamediv
tagrefname(list-secret-keys)
tagrefpurpose(iydraft(
list keys on secret keyrings
,
ꤷ̩ؤθΥꥹ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(list-secret-keys) tagreplaceableparam(name tagdots)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
List all keys from secret keyrings or just the keys specified with
tagreplaceableparam(name tagdots).
]],[[dnl
tagreplaceableparam(name tagdots)ǻꤷ
̩ؤΤ٤ƤθꥹȤޤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(list-sigs)
beginrefnamediv
tagrefname(list-sigs)
tagrefpurpose(iydraft(
list information about keys including signatures
,
̾դะξΥꥹ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(list-sigs) tagreplaceableparam(name tagdots)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
This command lists the public keys specified by the key specifiers on the
command line.
Signatures on the keys are listed as well.
If no key specifier is given, taggpg will list all of public keys.
]],
Υޥɤϡ
ޥɹԤθҤǻꤷꥹȤޤ
ν̾ΥꥹȤ⤷ޤ
Ҥʤȡ
٤ƤθꥹȤޤ
)dnl
endpara
endrefsect1
endrefentry

beginrefentry(check-sigs)
beginrefnamediv
tagrefname(check-sigs)
tagrefpurpose(iydraft(
list information about keys including validated signatures
,
ڤ̾դะξΥꥹ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(check-sigs) tagreplaceableparam(name tagdots)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
This command lists the public keys specified by the key specifiers on the
command line.
Signatures on the keys are listed as well, and each signature is validated.
If no key specifier is given, taggpg will list all of public keys.
]],[[dnl
Υޥɤϡ
ޥɹԤθҤǻꤷꥹȤޤ
ν̾ΥꥹȤ䡢
ƽ̾θڤ⤷ޤ
Ҥʤȡ
٤ƤθꥹȤޤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(fingerprint)
beginrefnamediv
tagrefname(fingerprint)
tagrefpurpose(iydraft(
display key fingerprints
,
ɽ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(fingerprint) tagreplaceableparam(name tagdots)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
This command prints the fingerprints of the specified public keys.
The parameter tagreplaceableparam(name) is a
key specifier.
If no parameter tagreplaceableparam(name) is
provided, taggpg will print the fingerprints of all the keys on 
your public keyring.
]],[[dnl
Υޥɤϡꤷλޤ
ѥ᡼tagreplaceableparam(name)ϡ
ҤǤ
ѥ᡼tagreplaceableparam(name)ʤȡ
ؾΤ٤Ƥθλޤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(import)
beginrefnamediv
tagrefname(import)
tagrefpurpose(iydraft(
import keys to a local keyring
,
ʸإؤθɹ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(import) tagreplaceableparam(filename)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
This command imports one or more public keys onto the user's public 
keyring from the file tagreplaceableparam(filename).
]],[[dnl
Υޥɤϡ
եtagreplaceableparam(filename)
1İʾθ桼θؤɤ߹ߤޤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(fast-import)
beginrefnamediv
tagrefname(fast-import)
tagrefpurpose(iydraft(
import/merge keys
,
ɹߡʻ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(fast-import) tagreplaceableparam(file tagdots)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
This is the same as the command taglink(import,import),
but the keys are not added to the trust database.
This can be done later using the command
taglink(update-trustdb,update-trustdb),
]],[[dnl
ϡtaglink(import,import)ޥɤƱǤ
ϡѥǡ١˲äޤ
ϡtaglink(update-trustdb,update-trustdb)ޥɤǤǤޤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(export)
beginrefnamediv
tagrefname(export)
tagrefpurpose(iydraft(
export keys from a local keyring
,
븰ؤθνФ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(export) tagreplaceableparam(key tagdots)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
This command exports the public keys components of the keys specified
by the key specifiers tagreplaceableparam(key tagdots).
The export command by default sends its output to standard output.  
This key file can later be imported into another keyring using the command
taglink(import,tagoption(import)).
]],[[dnl
Υޥɤϡ
tagreplaceableparam(key tagdots)Ҥǻꤵ줿θʬ񤭽Фޤ
񤭽ФޥɤϥǥեȤǡϤɸϤ˽Фޤ
θեϡ
taglink(import,tagoption(import))ޥɤ̤θؤɤ߹ळȤǤޤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(export-all)
beginrefnamediv
tagrefname(export-all)
tagrefpurpose(iydraft(
export all public keys
,
νФ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(export-all) tagreplaceableparam(name tagdots)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
This is the same as the command taglink(export,export),
but keys that are not OpenPGP-compliant are also exported.
]],[[dnl
taglink(export,export)ޥɤƱǤ
OpenPGPǤʤ⡢
񤭽Фޤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(export-secret-keys)
beginrefnamediv
tagrefname(export-secret-keys)
tagrefpurpose(iydraft(
export secret keys
,
̩νФ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(export-secret-keys) tagreplaceableparam(name tagdots)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
This is the same as the command taglink(export,export),
but private keys are exported instead of public keys.
This is normally not very useful and is a security risk since private
keys are left unprotected.
]],[[dnl
taglink(export,export)ޥɤƱǤ
̩񤭽Фޤ
̵̩ˤʤΤǡ
̾ޤͭפǤϤʤƥǤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(edit-key)
beginrefnamediv
tagrefname(edit-key)
tagrefpurpose(iydraft(
presents a menu for operating on keys
,
˥塼ɽ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(edit-key) tagreplaceableparam(key)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
This command presents a menu which enables you to perform
key-related taskes.
The key specifier tagreplaceableparam(key)
specifies the key pair to be edited.
If the specifier matches more than one key pair, taggpg issues
an error and exits.
]],[[dnl
Υޥɤϡ˴ϢΤǤ˥塼ޤ
tagreplaceableparam(key)ǡ
Խ븰ꤷޤ
⤷ҤȰפ븰ʣȡ顼ȴޤ
]])dnl
endpara

beginpara
iydraft([[dnl
Key listings displayed during key editing show the key with its
secondary keys and all user ids.
Selected keys or user ids are indicated by an asterisk.
The trust and validity values are displayed with the primary key: 
the first is the assigned trust and the second is the
calculated validity.
Letters are used for the values:
]],[[dnl
Խδ֤ɽ줿ꥹȤϡ桼IDǸ򼨤ޤ
򤵤줿桼IDϡƥꥹǼޤ
Ѥͭͤϡ縰Ȥäɽޤ
ǽ餬Ƥ줿ѡ
׻줿ͭǤ
ͤ򼨤ΤάȤޤ
]])dnl

begininformaltable()
begintgroup(2)
tagthead([[
]]atc(tagrow(tag1entry(iydraft(Letter, ʸ))
atc(tag1entry(iydraft([[Meaning]],[[̣]])))))[[
]])
tagtbody([[tagrow([[tag3entry(-)
tag3entry(iydraft([[dnl
No ownertrust assigned / not yet calculated.
]],[[dnl
οѤϡ
̤׻ޤ̤ơ
]])[[dnl]])]])
tagrow([[tag3entry(e)
tag3entry(iydraft([[dnl
Trust calculation has failed.
]],[[dnl
ѷ׻ϡԤ
]])[[dnl]])]])

tagrow([[tag3entry(q)
tag3entry(iydraft([[dnl
Not enough information for calculation.
]],[[dnl
׻Τνʬʾʤ
]])[[dnl]])]])

tagrow([[tag3entry(n)
tag3entry(iydraft([[dnl
Never trust this key.
]],[[dnl
θ褷ƿѤޤ
]])[[dnl]])]])

tagrow([[tag3entry(m)
tag3entry(iydraft([[dnl
Marginally trusted.
]],[[dnl
ٿѤޤ
]])[[dnl]])]])

tagrow([[tag3entry(f)
tag3entry(iydraft([[dnl
Fully trusted.
]],[[dnl
˿Ѥޤ
]])[[dnl]])]])

tagrow([[tag3entry(u)
tag3entry(iydraft([[dnl
Ultimately trusted.
]],
Ū˿Ѥޤ
)[[dnl]])]])]])
endtgroup
endinformaltable
endpara

beginpara
iydraft([[dnl
The following lists each key editing command and a description
of its behavior.
]],
ΥꥹȤϡޥɤԽƸȤưǤ
)dnl
endpara

beginrefsect2(sign)
tagtitle([[
sign
]])

beginpara
iydraft([[dnl
Makes a signature on the current key.
If the key is not yet signed by the default user or the user 
given with the option
taglink(local-user,tagoption(local-user)), 
the program displays the information of the key again, together with
its  fingerprint and asks whether it should be signed.
This question is repeated for all users specified with the option
tagoption(local-user).
]],[[dnl
ߤθ˽̾򤷤ޤ
⤷
taglink(local-user,tagoption(local-user))
ץˤäƤ줿桼
Υ桼ˤäƤޤ̾Ƥʤʤ顢
λȸξɽơ줬̾٤Ǥ뤫ɤҤͤޤ
μϡ
taglink(local-user,tagoption(local-user))
ץǻꤵ줿桼ˤĤƷ֤ޤ
]])dnl
endpara
endrefsect2

beginrefsect2(lsign)
tagtitle([[
lsign
]])

beginpara
iydraft([[dnl
Same as taglink(sign,sign), but the signature is
marked as non-exportable and will therefore never be used by others.
This may be used to make keys valid only in the local environment.
]],[[dnl
taglink(sign,sign)ƱǤ
ν̾ϽФԲĤˤʤäƤ뤿ᡢ¾ԤˤäƷ褷ƻȤʤǤ礦
ϡ
ʴĶˤƤΤͭʸΤ˻Ȥ뤫⤷ޤ
]])dnl
endpara
endrefsect2

beginrefsect2(revsig)
tagtitle([[
revsig
]])

beginpara
iydraft([[dnl
Revoke a signature.
Asks for each signature made by a one of the private keys whether
a revocation certificate should be generated.
]],[[dnl
̾˴ޤ
˴٤Ǥ뤫ݤˤ餺
̩ΤΤҤȤĤˤä줿ƽ̾ˤĤƿҤͤޤ
]])dnl
endpara
endrefsect2

beginrefsect2(trust)
tagtitle([[
trust
]])

beginpara
iydraft([[dnl
Change the owner trust value.
This updates the trust database immediately and no save is required.
]],[[dnl
翮ͤѹ
ϡ¨¤˿ѥǡ١򹹿¸ɬפϤޤ
]])dnl
endpara
endrefsect2

beginrefsect2(disable)
tagtitle([[
disable
]])

beginpara
iydraft([[dnl
Disable the key.
A disabled key cannot normally be used for encryption.
]],[[dnl
ԲĤˤޤԲĤθ̡Ź沽ˤϻȤޤ
]])dnl
endpara
endrefsect2

beginrefsect2(enable)
tagtitle([[
enable
]])

beginpara
iydraft([[dnl
Enable a key that has been previously
taglink(disable,disabled).
]],[[dnl
taglink(disable,ԲĤˤ줿)ѲĤˤޤ
]])dnl
endpara
endrefsect2

beginrefsect2(adduid)
tagtitle([[
adduid
]])

beginpara
iydraft([[dnl
Add a new user id to the current key.
]],[[dnl
桼ID򸽺ߤθɲäޤ
]])dnl
endpara
endrefsect2

beginrefsect2(deluid)
tagtitle([[
deluid
]])

beginpara
iydraft([[dnl
Delete a user id from the current key.
]],[[dnl
ߤθ桼IDޤ
]])dnl
endpara
endrefsect2

beginrefsect2(addkey)
tagtitle([[
addkey
]])

beginpara
iydraft([[dnl
Add a new subkey to the current key.
]],[[dnl
򸽺ߤθɲäޤ
]])dnl
endpara
endrefsect2

beginrefsect2(delkey)
tagtitle([[
delkey
]])

beginpara
iydraft([[dnl
Delete a subkey from the current key.
]],[[dnl
ߤθޤ
]])dnl
endpara
endrefsect2

beginrefsect2(revkey)
tagtitle([[
revkey
]])

beginpara
iydraft([[dnl
Revoke a subkey of the current key.
]],[[dnl
ߤθ˴ޤ
]])dnl
endpara
endrefsect2

beginrefsect2(expire)
tagtitle([[
expire
]])

beginpara
iydraft([[dnl
Change a key expiration time.
If a subkey is selected, the time of that key will be changed.
With no selection the expiration time of the current primary key is changed.
]],[[dnl
ѹ
򤵤ȡθλѹޤ
򤬤ʤȡߤμ縰ѹޤ
]])dnl
endpara
endrefsect2

beginrefsect2(key)
tagtitle([[
key n
]])

beginpara
iydraft([[dnl
Toggle selection of subkey with index n.
Use 0 to deselect all.
]],[[dnl
ǥånΥȥ
٤ˤˤ0Ȥޤ
]])dnl
endpara
endrefsect2

beginrefsect2(uid)
tagtitle([[
uid n
]])

beginpara
iydraft([[dnl
Toggle selection of user id with index n.
Use 0 to deselect all.
]],[[dnl
ǥånĥ桼IDΥȥ
٤ˤˤ0Ȥޤ
]])dnl
endpara
endrefsect2

beginrefsect2(passwd)
tagtitle([[
passwd
]])

beginpara
iydraft([[dnl
Change the passphrase of the private key of the selected key pair.
]],[[dnl
򤵤줿Ф̩Υѥե졼Ѥޤ
]])dnl
endpara
endrefsect2

beginrefsect2(toggle)
tagtitle([[
toggle
]])

beginpara
iydraft([[dnl
Toggle between public and private key listings.
]],[[dnl
/̩ꥹȤδ֤Υȥ롣
]])dnl
endpara
endrefsect2

beginrefsect2(check)
tagtitle([[
check
]])

beginpara
iydraft([[dnl
Check all selected user ids.
]],[[dnl
򤵤줿桼IDΥå
]])dnl
endpara
endrefsect2

beginrefsect2(pref)
tagtitle([[
pref
]])

beginpara
iydraft([[dnl
List preferences.
]],[[dnl
Υꥹȡ
]])dnl
endpara
endrefsect2

beginrefsect2(save)
tagtitle([[
save
]])

beginpara
iydraft([[dnl
Save all changes to the current key and quit.
]],[[dnl
٤Ƥѹ򸽺ߤθ¸ơ
̤ޤ
]])dnl
endpara
endrefsect2

beginrefsect2(quit)
tagtitle([[
save
]])

beginpara
iydraft([[dnl
Quit without updating the current key.
]],[[dnl
ߤθ򹹿ˤ̤ޤ
]])dnl
endpara
endrefsect2

endrefsect1
endrefentry


beginrefentry(sign-key)
beginrefnamediv
tagrefname(sign-key)
tagrefpurpose(iydraft(
sign a public key with a private key
,
̩Ǹ˽̾
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(sign-key) tagreplaceableparam(name)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
This is a shortcut for the subcommand 
taglink(sign,sign).
within the command
taglink(edit-key,edit-key).
]],[[dnl
ϡtaglink(sign,sign)̥ޥɤƻǤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(lsign-key)
beginrefnamediv
tagrefname(lsign-key)
tagrefpurpose(iydraft(
locally sign a public key with a private key
,
̩Ǹ˥˽̾
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(lsign-key) tagreplaceableparam(name)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
This is a shortcut for the subcommand 
taglink(lsign,lsign)
within the command
taglink(edit-key,edit-key).
]],[[dnl
ϡ
taglink(edit-key,edit-key)ޥɤtaglink(lsign,lsign)̥ޥɤƻǤ

]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(delete-key)
beginrefnamediv
tagrefname(delete-key)
tagrefpurpose(iydraft(
remove a public key
,
ξõ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(delete-key) tagreplaceableparam(name)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
Remove the public key specified by 
tagreplaceableparam(name).
]],[[dnl
tagreplaceableparam(name)ǻꤵ줿äޤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(delete-secret-key)
beginrefnamediv
tagrefname(delete-secret-key)
tagrefpurpose(iydraft(
remove a public and private key
,
̩ξõ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(delete-secret-key) tagreplaceableparam(name)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
Remove the keypair (both the public and private keys) specified by 
tagreplaceableparam(name).
]],[[dnl
tagreplaceableparam(name)ǻꤵ줿(̩)Фäޤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(store)
beginrefnamediv
tagrefname(store)
tagrefpurpose(iydraft(
make only simple rfc1991 packets
,
ñrfc1991ΥѥåȤ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(store)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
Elaborate.
]],[[dnl
԰ռɮ档
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(export-ownertrust)
beginrefnamediv
tagrefname(export-ownertrust)
tagrefpurpose(iydraft(
export assigned owner-trust values
,
ƤͭԿͤνФ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(export-ownertrust) tagreplaceableparam(file tagdots)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
The owner-trust values are exported in ASCII format.
This is useful for making a backup of the trust values assigned to
key owners.
]],[[dnl
ͭԿͤASCIIǽ񤭽Фޤ
ϡλ˳Ƥ줿ͤΥХååפȤΤǤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(import-ownertrust)
beginrefnamediv
tagrefname(import-ownertrust)
tagrefpurpose(iydraft(
import owner-trust values
,
ͭԿͤɹ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(import-ownertrust) tagreplaceableparam(file tagdots)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
The trust database is updated with the trust values take from the files
tagreplaceableparam(file tagdots).
If no files are listed, the input is taken from standard input.
]],[[dnl
եtagreplaceableparam(file tagdots)Ȥ뿮ͤǡ
ѥǡ١򹹿ޤ
ե򤢤ʤȡ
ɸϤϤȤޤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(update-trustdb)
beginrefnamediv
tagrefname(update-trustdb)
tagrefpurpose(iydraft(
update the trust database 
,
ͭԿͤι
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(update-trustdb)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
Enough said.
]],[[dnl
鷺⤬ʡ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(print-md)
beginrefnamediv
tagrefname(print-md)
tagrefpurpose(iydraft(
display message digests
,
åɽ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(print-md) tagreplaceableparam(algo) tagreplaceableparam(file tagdots)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
Displays a message digest using algorithm
tagreplaceableparam(algo)
for each of the files
tagreplaceableparam(file tagdots).
If no files are listed, the input is taken from standard input.
If the algorithm specified is tagldquo*tagrdquo, then digests using
all available algorithms are displayed.
]],[[dnl
եtagreplaceableparam(file tagdots)γơˡ
르ꥺtagreplaceableparam(algo)Ȥäơ
åȤɽޤ
ե򤢤ʤȡ
ɸϤϤȤޤ
ꤵ줿르ꥺबtagldquo*tagrdquoȡ
Ѳǽ르ꥺΥȤɽޤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(gen-random)
beginrefnamediv
tagrefname(gen-random)
tagrefpurpose(iydraft(
generate random data
,
̵٥ǡȯ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(gen-random) tagreplaceableparam(level) tagreplaceableparam(n)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
This command emits tagreplaceableparam(n)
bytes of random data with quality 
tagreplaceableparam(level).
If the parameter tagreplaceableparam(n) is
omitted then an endless sequence of random bytes will be emitted.
This command should not be frivolously since it takes entropy from
the system.
]],[[dnl
Υޥɤϡ
ʼtagreplaceableparam(level)tagreplaceableparam(n)ХȤΥࡦǡȯޤ
ѥ᡼tagreplaceableparam(n)άȡ
ʥХȤ̵ȯޤ
Υޥɤϡ
ƥफ饨ȥԡȤΤǡ
˼¹Ԥ٤ǤϤޤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(gen-prime)
beginrefnamediv
tagrefname(gen-prime)
tagrefpurpose(?)
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(gen-prime) tagreplaceableparam(mode) tagreplaceableparam(bits) tagreplaceableparam(qbits)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
This probably generates a prime number.
Read the source for details if you are curious.
]],[[dnl
ϡ֤ǿޤ
ܺ٤ˤĤƹ񿴤ζͤϡ
ɤǤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(version)
beginrefnamediv
tagrefname(version)
tagrefpurpose(iydraft(
display version information
,
Ǿɽ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(version)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
Print version information along with a list of supported algorithms.
]],[[dnl
ٱ礵줿르ꥺΥꥹȤȥСޤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(warranty)
beginrefnamediv
tagrefname(warranty)
tagrefpurpose(iydraft(
display warranty information
,
̵ݾھɽ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(warranty)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
Enough said.
]],[[dnl
鷺⤬ʡ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(help)
beginrefnamediv
tagrefname(help)
tagrefpurpose(iydraft(
display usage information
,
ˡɽ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(help)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
Displays usage information include a list of commands and options.
The options list may be incomplete.
]],[[dnl
ޥɤ䥪ץΥꥹȤޤࡢ
Ѿɽޤ
ץΥꥹȤϡ
Դ⤷ޤ
]])dnl
endpara
endrefsect1
endrefentry

endreference
