#!/bin/sh
#
# $XFree86: test/xsuite/run.sh,v 1.1 2003/12/06 02:46:10 dawes Exp $
#
# A script for running the xtest suite.
#

# Check how to suppress newlines with echo (from perl's Configure)
((echo "xxx\c"; echo " ") > .echotmp) 2> /dev/null
if [ ! -f .echotmp ]; then
	echo "Can't write to the current directory.  Aborting";
	exit 1
fi
if grep c .echotmp >/dev/null 2>&1; then
	n='-n'
	c=''
else
	n=''
	c='\c'
fi
rm -f .echotmp

Echo()
{
	echo $n "$@""$c"
}

TET_ROOT=`pwd`
export TET_ROOT
PATH=$TET_ROOT/xtest/bin:$PATH

echo "Start the X server you're running the test against."
echo "Run 'xdpyinfo' against that X server, and enter the values as prompted."
echo ""
Echo "Press <enter> to continue: "
read resp
Echo "Enter the vendor release number from the xdpyinfo output: "
read XT_VENDOR_RELEASE
Echo "Enter the screen width in millimeters from the xdpyinfo output: "
read XT_WIDTH_MM
Echo "Enter the screen height in millimeters from the xdpyinfo output: "
read XT_HEIGHT_MM
Echo "Enter the black pixel value from the xdpyinfo output: "
read XT_BLACK_PIXEL
Echo "Enter the white pixel value from the xdpyinfo output: "
read XT_WHITE_PIXEL
Echo "Enter the list of pixmap depths from the xdpyinfo output: "
read XT_PIXMAP_DEPTHS
XT_PIXMAP_DEPTHS="`echo $XT_PIXMAP_DEPTHS | sed s/,//g`"
Echo "Enter the depth of the root window: "
read XT_ROOT_DEPTH
Echo "Enter the display's hostname: "
read XT_DISPLAYHOST
Echo "Enter the \$DISPLAY setting to use: "
read XT_DISPLAY
echo "If the display is remote, you will need to install the fonts from"
echo "$TET_ROOT/xtest/fonts on the remote host."
Echo "Enter the remote font directory (just hit return for a local display): "
read XT_FONTDIR
if [ X"$XT_FONTDIR" = X ]; then
	XT_FONTDIR="$TET_ROOT/xtest/fonts"
fi
case "$XT_ROOT_DEPTH" in
1)
	XT_VISUAL_CLASSES="StaticGray(1)"
	;;
4)
	XT_VISUAL_CLASSES="StaticGray(4) GrayScale(4) StaticColor(4) PseudoColor(4) TrueColor(4) DirectColor(4)"
	;;
8)
	XT_VISUAL_CLASSES="StaticGray(8) GrayScale(8) StaticColor(8) PseudoColor(8) TrueColor(8) DirectColor(8)"
	;;
15|16|24)
	Echo "Is a DirectColor visual present? (y/n) [n] "
	read resp
	case "$resp" in
	[yY]*)
		XT_VISUAL_CLASSES="TrueColor($XT_ROOT_DEPTH) DirectColor($XT_ROOT_DEPTH)"
		;;
	*)
		XT_VISUAL_CLASSES="TrueColor($XT_ROOT_DEPTH)"
		;;
	esac
	;;
*)
	echo "Unrecognised depth: $XT_ROOT_DEPTH"
	exit 1
	;;
esac

XT_FONTDIR="$TET_ROOT/xtest/fonts/"

rm -f xtest/tetexec.cfg
sed \
	-e "s,%XT_WIDTH_MM%,$XT_WIDTH_MM," \
	-e "s,%XT_HEIGHT_MM%,$XT_HEIGHT_MM," \
	-e "s,%XT_BLACK_PIXEL%,$XT_BLACK_PIXEL," \
	-e "s,%XT_WHITE_PIXEL%,$XT_WHITE_PIXEL," \
	-e "s,%XT_VISUAL_CLASSES%,$XT_VISUAL_CLASSES," \
	-e "s,%XT_PIXMAP_DEPTHS%,$XT_PIXMAP_DEPTHS," \
	-e "s,%XT_VENDOR_RELEASE%,$XT_VENDOR_RELEASE," \
	-e "s,%XT_DISPLAYHOST%,$XT_DISPLAYHOST," \
	-e "s,%XT_DISPLAY%,$XT_DISPLAY," \
	-e "s,%XT_FONTDIR%,$XT_FONTDIR," \
	< xtest/tetexec.cfg.tmpl > xtest/tetexec.cfg

echo ""
echo "Start the X server on the target machine.  Start it manually, with"
echo "no clients running, with the screen saver disabled, and with access"
echo "control disabled.  E.g., run 'XFree86 :N -ac -s 0' where N is the"
echo "display number you entered above"
echo ""
Echo "Press <enter> when that is done: "
read resp
echo "Starting the test run.  This will take a while."
echo "The message that gets printed below will show where the log file or"
echo "\"journal\" is.  Ignore warning messages that might get printed."
echo "The 'rpt' utility can be used to extract information from the log."
echo "'rpt -p > out.$$' will be run after the test in order to generate"
echo "a summary."
echo ""

(cd $TET_ROOT/xtest; tcc -e -s link_scen xtest linkexec)

echo "Test run finished.  Generating the summary report \"out.$$\""
rpt -p > out.$$

echo "Done."

exit 0
