#!/bin/sh
#
# $XFree86: test/xsuite/run.sh,v 1.3 2003/12/06 18:45:17 dawes Exp $
#
# A script for running the xtest suite.
#
# Copyright  2003 by The XFree86 Project, Inc.
# Copyright  2003 by David H. Dawes
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE COPYRIGHT HOLDER(S) OR AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
# OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
# ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
# OTHER DEALINGS IN THE SOFTWARE.
#
# Except as contained in this notice, the name of the copyright holder(s)
# and author(s) shall not be used in advertising or otherwise to promote
# the sale, use or other dealings in this Software without prior written
# authorization from the copyright holder(s) and author(s).
#

# Check how to suppress newlines with echo (from perl's Configure)
((echo "xxx\c"; echo " ") > .echotmp) 2> /dev/null
if [ ! -f .echotmp ]; then
	echo "Can't write to the current directory.  Aborting";
	exit 1
fi
if grep c .echotmp >/dev/null 2>&1; then
	n='-n'
	c=''
else
	n=''
	c='\c'
fi
rm -f .echotmp

Echo()
{
	echo $n "$@""$c"
}

TET_ROOT=`pwd`
export TET_ROOT
PATH=$TET_ROOT/xtest/bin:$PATH

echo "Start the X server you're running the test against."
echo "Run 'xdpyinfo' against that X server, and enter the values as prompted."
echo ""
Echo "Press <enter> to continue: "
read resp

if [ -f xtest/tetexec.cfg ]; then
	echo "There is an existing xtest configuration file"
	Echo "Do you want to use it? (y/n) [y] "
	read resp
	case "$resp" in
	[nN]*)
		newsettings=y
		;;
	*)
		;;
	esac
fi

GetParam() {
	Echo "${1} [$2] "
	read param
	param="${param:-$2}"
}

if [ "$newsettings" = y ]; then
	# Use the previous settings as the defaults.
	if [ -f xtest/tetexec.values ]; then
		. xtest/tetexec.values
	fi
	GetParam "Enter the vendor release number:" "$XT_VENDOR_RELEASE"
	XT_VENDOR_RELEASE="$param"
	GetParam "Enter the screen width in millimeters:" "$XT_WIDTH_MM"
	XT_WIDTH_MM="$param"
	GetParam "Enter the screen height in millimeters:" "$XT_HEIGHT_MM"
	XT_HEIGHT_MM="$param"
	GetParam "Enter the list of pixmap depths:" "$XT_PIXMAP_DEPTHS"
	XT_PIXMAP_DEPTHS="$param"
	XT_PIXMAP_DEPTHS="`echo $XT_PIXMAP_DEPTHS | sed s/,//g`"
	GetParam "Enter the depth of the root window:" "$XT_ROOT_DEPTH"
	XT_ROOT_DEPTH="$param"
	GetParam "Enter the black pixel value:" "$XT_BLACK_PIXEL"
	XT_BLACK_PIXEL="$param"
	GetParam "Enter the white pixel value:" "$XT_WHITE_PIXEL"
	XT_WHITE_PIXEL="$param"
	GetParam "Enter the display's hostname:" "$XT_DISPLAYHOST"
	XT_DISPLAYHOST="$param"
	GetParam "Enter the \$DISPLAY setting to use:" "$XT_DISPLAY"
	XT_DISPLAY="$param"
	# Make sure the screen component is present.
	scr="`expr $XT_DISPLAY : '.*:[0-9][0-9]*\(\.[0-9][0-9]*\)'`"
	if [ X"$scr" = X ]; then
		XT_DISPLAY="$XT_DISPLAY.0"
	fi
	XT_LOCAL_FONTDIR="$TET_ROOT/xtest/fonts"
	echo ""
	echo "If the display is remote, you will need to install the fonts from"
	echo "$TET_ROOT/xtest/fonts on the remote host."
	XT_REMOTE="${XT_REMOTE:-n}"
	GetParam "Is the X server running on a remote host?" "$XT_REMOTE"
	case "$XT_REMOTE" in
	[yY]*)
		GetParam "Enter the remote font directory:" "$XT_FONTDIR"
		XT_FONTDIR="$param"
		;;
	*)
		XT_FONTDIR="$XT_LOCAL_FONTDIR"
		;;
	esac
	XT_DIRECT_COLOR="${XT_DIRECT_COLOR:-n}"
	case "$XT_ROOT_DEPTH" in
	1)
		XT_VISUAL_CLASSES="StaticGray(1)"
		;;
	4)
		XT_VISUAL_CLASSES="StaticGray(4) GrayScale(4) StaticColor(4) PseudoColor(4) TrueColor(4) DirectColor(4)"
		;;
	8)
		XT_VISUAL_CLASSES="StaticGray(8) GrayScale(8) StaticColor(8) PseudoColor(8) TrueColor(8) DirectColor(8)"
		;;
	15|16|24)
		GetParam "Is a DirectColor visual present?" "$XT_DIRECT_COLOR"
		XT_DIRECT_COLOR="$param"
		case "$XT_DIRECT_COLOR" in
		[yY]*)
			XT_VISUAL_CLASSES="TrueColor($XT_ROOT_DEPTH) DirectColor($XT_ROOT_DEPTH)"
			;;
		*)
			XT_VISUAL_CLASSES="TrueColor($XT_ROOT_DEPTH)"
			;;
		esac
		;;
	*)
		echo "Unrecognised depth: $XT_ROOT_DEPTH"
		exit 1
		;;
	esac

	XT_FONTPATH="$XT_FONTDIR,/usr/X11R6/lib/X11/fonts/misc/"

	# Write out the defaults
	rm -f xtest/tetexec.values
	: > xtest/tetexec.values
	echo "XT_WIDTH_MM=\"$XT_WIDTH_MM\"" >> xtest/tetexec.values
	echo "XT_HEIGHT_MM=\"$XT_HEIGHT_MM\"" >> xtest/tetexec.values
	echo "XT_BLACK_PIXEL=\"$XT_BLACK_PIXEL\"" >> xtest/tetexec.values
	echo "XT_WHITE_PIXEL=\"$XT_WHITE_PIXEL\"" >> xtest/tetexec.values
	echo "XT_ROOT_DEPTH=\"$XT_ROOT_DEPTH\"" >> xtest/tetexec.values
	echo "XT_PIXMAP_DEPTHS=\"$XT_PIXMAP_DEPTHS\"" >> xtest/tetexec.values
	echo "XT_VENDOR_RELEASE=\"$XT_VENDOR_RELEASE\"" >> xtest/tetexec.values
	echo "XT_DISPLAYHOST=\"$XT_DISPLAYHOST\"" >> xtest/tetexec.values
	echo "XT_DISPLAY=\"$XT_DISPLAY\"" >> xtest/tetexec.values
	echo "XT_FONTDIR=\"$XT_FONTDIR\"" >> xtest/tetexec.values
	echo "XT_REMOTE=\"$XT_REMOTE\"" >> xtest/tetexec.values
	echo "XT_DIRECT_COLOR=\"$XT_DIRECT_COLOR\"" >> xtest/tetexec.values

	rm -f xtest/tetexec.cfg
	sed \
		-e "s@%XT_WIDTH_MM%@$XT_WIDTH_MM@" \
		-e "s@%XT_HEIGHT_MM%@$XT_HEIGHT_MM@" \
		-e "s@%XT_BLACK_PIXEL%@$XT_BLACK_PIXEL@" \
		-e "s@%XT_WHITE_PIXEL%@$XT_WHITE_PIXEL@" \
		-e "s@%XT_VISUAL_CLASSES%@$XT_VISUAL_CLASSES@" \
		-e "s@%XT_PIXMAP_DEPTHS%@$XT_PIXMAP_DEPTHS@" \
		-e "s@%XT_VENDOR_RELEASE%@$XT_VENDOR_RELEASE@" \
		-e "s@%XT_DISPLAYHOST%@$XT_DISPLAYHOST@" \
		-e "s@%XT_DISPLAY%@$XT_DISPLAY@" \
		-e "s@%XT_FONTDIR%@$XT_FONTDIR@" \
		-e "s@%XT_FONTPATH%@$XT_FONTPATH@" \
		< xtest/tetexec.cfg.tmpl > xtest/tetexec.cfg
fi

echo ""
echo "Start the X server on the target machine.  Start it manually, with"
echo "no clients running, with the screen saver disabled, and with access"
echo "control disabled.  E.g., run 'XFree86 :N -ac -s 0' where N is the"
echo "display number you entered above"
echo ""
Echo "Press <enter> when that is done: "
read resp
echo "Starting the test run.  This will take a while."
echo "The message that gets printed below will show where the log file or"
echo "\"journal\" is.  Ignore warning messages that might get printed."
echo "The 'rpt' utility can be used to extract information from the log."
echo "'rpt -p > out.$$' will be run after the test in order to generate"
echo "a summary."
echo ""

(cd $TET_ROOT/xtest; tcc -e -s link_scen xtest linkexec)

echo "Test run finished.  Generating the summary report \"out.$$\""
rpt -p > out.$$

echo "Done."

exit 0
