#ifndef _ISOKEYS_H_ 
#define _ISOKEYS_H_ 1

/* $XFree86: xc/programs/xkbprint/isokeys.h,v 1.2 2006/01/09 15:01:32 dawes Exp $ */
/************************************************************
 Copyright (c) 1995 by Silicon Graphics Computer Systems, Inc.

 Permission to use, copy, modify, and distribute this
 software and its documentation for any purpose and without
 fee is hereby granted, provided that the above copyright
 notice appear in all copies and that both that copyright
 notice and this permission notice appear in supporting
 documentation, and that the name of Silicon Graphics not be 
 used in advertising or publicity pertaining to distribution 
 of the software without specific prior written permission.
 Silicon Graphics makes no representation about the suitability 
 of this software for any purpose. It is provided "as is"
 without any express or implied warranty.
 
 SILICON GRAPHICS DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS 
 SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY 
 AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL SILICON
 GRAPHICS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL 
 DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, 
 DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE 
 OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION  WITH
 THE USE OR PERFORMANCE OF THIS SOFTWARE.

 *******************************************************/

#define	XKC_ISO_Shift				'0'
#define	XKC_ISO_Shift_Lock			'1'
#define	XKC_ISO_Caps_Lock			'2'
#define	XKC_ISO_Num_Lock			'3'
#define	XKC_ISO_Level3_Shift			'4'
#define	XKC_ISO_Level3_Lock			'5'
#define	XKC_ISO_Next_Group			'6'
#define	XKC_ISO_Next_Group_Lock			'7'
#define	XKC_ISO_Space				'8'
#define	XKC_ISO_No_Break_Space			'9'

#define	XKC_ISO_Insert				'A'
#define	XKC_ISO_Continuous_Underline		'B'
#define	XKC_ISO_Discontinuous_Underline		'C'
#define	XKC_ISO_Emphasize			'D'
#define	XKC_ISO_Compose				'E'
#define	XKC_ISO_Center_Object			'F'
#define	XKC_ISO_Backward_Erase			'G'
#define	XKC_ISO_Delete				'H'
#define	XKC_ISO_Clear_Screen			'I'
#define	XKC_ISO_Scroll_Lock			'J'
#define	XKC_ISO_Help				'K'
#define	XKC_ISO_Print_Screen			'L'
#define	XKC_ISO_Return				'M'
#define	XKC_ISO_Enter				'N'
#define	XKC_ISO_Alt				'O'
#define	XKC_ISO_Control				'P'
#define	XKC_ISO_Pause				'Q'
#define	XKC_ISO_Break				'R'
#define	XKC_ISO_Escape				'S'
#define	XKC_ISO_Undo				'T'
#define	XKC_ISO_Up				'U'
#define	XKC_ISO_Down				'V'
#define	XKC_ISO_Left				'W'
#define	XKC_ISO_Right				'X'
#define	XKC_ISO_Fast_Cursor_Up			'Y'
#define	XKC_ISO_Fast_Cursor_Down		'Z'
#define	XKC_ISO_Fast_Cursor_Left		'a'
#define	XKC_ISO_Fast_Cursor_Right		'b'
#define	XKC_ISO_Home				'c'
#define	XKC_ISO_End				'd'
#define	XKC_ISO_Page_Up				'e'
#define	XKC_ISO_Page_Down			'f'
#define	XKC_ISO_Left_Tab			'g'
#define	XKC_ISO_Tab				'h'
#define	XKC_ISO_Move_Line_Up			'i'
#define	XKC_ISO_Move_Line_Down			'j'
#define	XKC_ISO_Backspace			'k'
#define	XKC_ISO_Partial_Line_Up			'l'
#define	XKC_ISO_Partial_Line_Down		'm'
#define	XKC_ISO_Partial_Space_Left		'n'
#define	XKC_ISO_Partial_Space_Right		'o'
#define	XKC_ISO_Set_Margin_Left			'p'
#define	XKC_ISO_Set_Margin_Right		'q'
#define	XKC_ISO_Release_Margin_Left		'r'
#define	XKC_ISO_Release_Margin_Right		's'
#define	XKC_ISO_Release_Both_Margins		't'

#define	XKC_ISO_Prev_Group			'u'
#define	XKC_ISO_Prev_Group_Lock			'v'
#define	XKC_ISO_First_Group			'w'
#define	XKC_ISO_First_Group_Lock		'x'
#define	XKC_ISO_Last_Group			'y'
#define	XKC_ISO_Last_Group_Lock			'z'

static char *IsoKeyCaps[]= {
	"%!PS-AdobeFont-1.0: IsoKeyCaps",
	"%%CreationDate: Sun Apr 16 22:14:26 1995",
	"%%VMusage: 8064 8064",
	"% Created with FontMonger Copyright (c) 1991-2 Ares Software Corp. All rights reserved.",
	"11 dict begin",
	"/FontInfo 9 dict dup begin",
	"/version (0.0) readonly def",
	"/Notice (Copyright (c) 1993-1995 Erik Fortune:  Use and distribute  freely, but preserve this copyright) readonly def",
	"/FullName (IsoKeyCaps) readonly def",
	"/FamilyName (IsoKeyCaps) readonly def",
	"/Weight (Regular) readonly def",
	"/ItalicAngle 0 def",
	"/isFixedPitch false def",
	"/UnderlinePosition -100 def",
	"/UnderlineThickness 50 def",
	"end readonly def",
	"/FontName /IsoKeyCaps def",
	"/Encoding StandardEncoding def",
	"/PaintType 0 def",
	"/FontType 1 def",
	"/FontMatrix [0.001 0 0 0.001 0 0] readonly def",
	"/FontBBox{30 0 1033 1019}readonly def",
	"%/UniqueID 0 def",
	"currentdict end",
	"currentfile eexec",
	"8551A6FE281A24F7FF33BF71784C08FAF0BEC6A24D2D9612EB9369F0F90A5C3A",
	"4CE0CDDEA2B6602004E0E71429DDD22F439E984BA180E326344321F3E6F379F3",
	"32FD065A9AF79BA836D33A465E4D52132E403C31712D939E800A492D5BD1B69A",
	"1D55092933BCD8CFB7BD6A7B1E8172AFEBBE8CAF0D3B5C9BC9BF376DC2A6CBA5",
	"BA6C605BF0342BAB197654B1472A5875778372A6407275CC2101D85C5E0C4452",
	"3258E0B2F6F1FF7C1F4CDBE7CDBCF7FE819761317D5CBBB0AA8568A4F610A7ED",
	"75840096F2412D4EDAE38A49301D06C0AD8D577018FD86E93D124E6DFA543F66",
	"BDCBA8EE83BD7BEAD8EB002A92CF1325702FA1106CE5C18511F55CE7014E3459",
	"78915163CF281F100E5E19F6200EDEC562EACAF3962204C68432B46E9AF33BAF",
	"22E995C2F23E0431EAA01028A1028A3B161DA5CC9D3CF8D8D28E3D39021C19B7",
	"64A39F0FD70E85ADC704255AFBE9C86F6BD855B80BA9BF7A0FEB207558479485",
	"76CF7C428960B3C73E52315DD854162F01CAAD32D1A07C07E879AB0F152EF376",
	"0D33B0B8D68D7A0E09E9145C0DF114C6CAEECD6465173DF643FF820944A3C1DD",
	"808F03B79B2900BBCCD33550C677777D48B9BD3B727849563C32076ABD5A74E5",
	"4421912FC0833B178FE21C6B7C6DEAEED50C843AE02AC024187CE9E15E7CE921",
	"AB0E8FAC03B2EF345D361E6BFEB0F030CD43355AED642EE478E257B2D06E4880",
	"C531CF4859A76D7B6EC1C331450084E78EA4C88AB0555E7D3B486DC0F93AF35A",
	"41D9313815B951690AC587FF9D39DF68AD050A91940B73A54E93F3AF3BB3B3E1",
	"5FFD455EF337811B52450532A4A9BDF4CD0A1120874DE11BC9F8F7394AB45E43",
	"4E2DEBC4588AA1DE3AC2E31EB7AFB4DA68E9C72FF1318AC06C2324B51BD3911B",
	"B3E64237E46D213D348C9611C1D32A3095C4AC75513189B26F6A85171864905B",
	"5DC60C151A4BDD182B0BE8C416500E3D46F6680214B33CCDF1CFF844EEBAC1CB",
	"63D7608EDC2B5A7F955680D5501DC2E3014212563F713F690E6964998A1CADFC",
	"B5073630BCA52FC3DDB9B3B9BDF9CB7CE9735ADC3B5E1D6B6210B33A1FC400B0",
	"392EE750598D7AD3978FCDF244D8EF20532C9DFC5DB04775CA3D5BF3823DA096",
	"C5FAB0AC9E89227D13951380189A3AE6240C6AC0D75E21AE7C82E4164334ADA2",
	"3FE21ADE74B6EFF0C51323DDF81D85D36F0441F3ABAE00B94A81F3EAAA860FE8",
	"881191FD60B98C4FEFEAA1BB0D1C6F6EB027EEA34B722AACD0E9DDEF644EAE74",
	"714CD8ABFF98D847CEAF1E6AA251F894A8DC3F5AFC0FC1B2197E940B4D473A38",
	"90674DE22BB9126D90A7B9F2C957A936CCEBE6406D5803EEB28A2F429466426A",
	"DF1559A9C6CDE09F035C7E9D79B54792A7CF42FFEF9C3968CBCB5185CEE897EC",
	"BAFFB11AA4D6BC1338301B9EB2BCD4A0CE792F3209A75C95FB448EEB460B7178",
	"223CFA97B547547D4CD37F2898CCFBCEC519E6C1363119C5B005C3EB38C2F7D5",
	"4B2711FACE82B6DB16387F3EF76EDDA4E1C3042D2F82EE0448BE80623558FB7D",
	"C4CC6F95FE735EA451E0F3C298E84E83357FF7163B8939D5B5F4B22ACC78FDC6",
	"2272A317BABE200DB627A7D2231D72555D7A06ADC228D2D9138D228A92395B4D",
	"BE7754E6C944EEAD5E95334FAF3F2888FAFE14C60FE19823A3E936A908180CD1",
	"C3E3E829DF1E98270C47A2352FA9F66C80ACFEC4FF572E6D41BD4C3324F0AEBA",
	"8DC7178820253F86513622A670D4CD880597667D05EEB4217D871D17700F5DF4",
	"1F3ECAF271FFB35D34F6FEBF07644B84B2458A2AED9D9E85CE5EA8FA9D3E12CE",
	"0E92D899CBC468BECCF6F9132A68C1F067CA0260196965C8814957CF9CF2EBCC",
	"4427B031B58AB8BE9C6EC8E2D406EFC85145A5A614C4EF911CD976127593BAFF",
	"46EE074E8D4791AB00B750BB17BB8CD0EE7A5A6C64AF8E1F59E3DCD87AEB1ADF",
	"44F9B644A4B30E7AE35A8749B2612BCC9DEF8AC9B4FA7B3FDC67ED1D817FC6CB",
	"32DD3811D0720B6D45C9FCFA7954C30EBF1DC58F9B0069931500648F0D1C0BF8",
	"3E45E08522EEA6533E00CE023D23C2F5718ACAC657F76557B2B6D980A6DF58A3",
	"A22A752A9D6938E2267AE85BF94D94E24DB2679A2191B8872469C0A7B4008E22",
	"39FC7FD65AC2DCCF87031757611D0B6BC2F90B91E9D097FB07C6C31D6699809B",
	"A46027BA8BF0DD4F4911C3F8F9A45993F19319BEB3CF42BC25EDE305BD1EA124",
	"4BFE062800EA8E16E3893DC59E552D0E13704E1F8B3278396D6F6A11DC6F8625",
	"E6329E1BB89FDCE310CCF08D1946239A563FF7D6867197E78129D91BE5C1C61D",
	"4FBA7F90E270AFEBDE6E60E09B56348C71058E9FA2646B8A86F35C3979A123A4",
	"9EC3D0FD488CB2F5ACF1D3088706E2BF31E2A8603F3FC4F2D4879F118A584F53",
	"2CDAABF2A5E8069F69444818E4A510AD4D5EA007D27E590176EB6B5C6A676AB2",
	"113324BBA8684FE9D6CE31653D763BEE8C6A2111E957D7FF83232DEFC94056B1",
	"A6A0834C1C5E5B8C32FF5C0E1156E31A3726649839C36A858A7DCBFC523C4BF9",
	"E715B1A964A33BB82B2DA197F3EAD6EFDD8B27D38F7989E097046DDF159188E4",
	"31D1FE927CECD187F751BD425F63E4F6774A88E53980F706202F0EF89827D7AD",
	"153D617FFFC3092679061B9D40EB6E730E254A952FD27C6AF464E9893C7A3D43",
	"485865629D72323F52B177D0F264428D37E1F57123F52B107356C8B8F82BD131",
	"B73C42619791E589D3CC46DF65889F0D68CB0E2726F89DD4A935FAC17E007AFD",
	"3775E87DC4F0B2A154743C3C7FAAFB4F3C248948B02A50F1294BCB125D472EF4",
	"4797210694EE52ED647972585096EF4AB914D033123CE6F7BD7FE8B9F73BF0F5",
	"2FDD8EC6C9979E96B47BD8C2F2ADCB420A723F55341CFEE2351F5A81D0565995",
	"BB1CE047667B8D992F98D98F6EEA1710A96731CF2350E92810E081EFC5197ADD",
	"4BAD3D1F39721F0AA5FD0CE3B57518ED0942D775E0732ADB79EB2C359B648DC9",
	"37D4371BC58654B5AE4FAE3D9816EADAE629FE6A7265E62F6F9D9CF7E954BF76",
	"4D16AFB7DAF32596EDBFF141CAD0B7435B6CBBFA633EAD6072242A3514F81581",
	"0E256858C9B884408683E2667518A6AE13B946A722997F5E906FEF0796908AA1",
	"96DDD7A1D094488E883B9E942A322E2C7D48EDDC55353F07747B63520264F0DC",
	"09C55DB76104E03C95B392B019AEB84CEBC86DF52782B5DDD1DE2AF49B9EEB12",
	"E2FCDF150D7CCDE7E2A8AA7B6A7096E2523565DCB2516D216DA76A14E8719704",
	"367749C9DA3C0991FB850638EFFEC2AAB75074FCED82C1F32F5709BEA7DECCFA",
	"6B11015858B9DA957FA94C1DC10F3588948061D9A18133ECB9FD33E098CB982E",
	"7EFAFDCE42EFAEB46CD931C4061D881CC5467BDBBBD04DEFFA91445E0BC22646",
	"30EDA1127AE6C68ACEFB5D97074380EE73763D3757B6FE283FC8537566AA35E5",
	"C116487B3E7E38202D4716A0036C07ACFD54E066736E1F96E466B1D9F4E3D332",
	"F68AFDFD1CE473561117A6B25B2CDD597F0FFBF1717DA5F38C7FA88C89BB04B7",
	"56A8B6D15530B9D4FED94CB7BC689939ABF9E039A8B6A6005711599FE62DEFD2",
	"0BB32B9D7955E2862CF70BDCC552A15DEBBE3C8FB6F5E262C567D1206E97BBBA",
	"06AA8E9DFE48EEFD014E950C04E21E26D8E68D58EED0A62F5E58A95ABB584DC4",
	"BD3713366EDEBC55AE8FB1945096BD923FE56EF2A120B3B626F5C003CFC5BDFB",
	"070B70F6547033D2265C604C427D1D2200BCAC51DE3E7FE9DE200A987072BDA3",
	"16C75109106C806E2A639E1FB113CF30DED85351DA5CB1355D361CA025183AEE",
	"36567C4A8F570C70F4893FADBB2255F7B492ABC83213B54F162D8971EB4E5388",
	"CCCB4D83FD37BFFD2EB55423FF50C435CA62BE8C3B9F2879119A24A50829A698",
	"37E0EAFB1BEA0B509A54CD7029F3D1EDDD790AC4B82130C05754D2E260F06E2E",
	"676708D48CA94A7C655C36588B93B1D8FAD063D716D8A72D46BE475F4843C831",
	"5AC6D800B85834F75AD70E70404A2E2780901017489ED3A36288E803AF935F19",
	"90CDC06EAB81FE6B3D4CB80D9061D325C912339561EE17D572A2C342B37238CE",
	"656875528F48E80BEBC19E9BDE56CDA65F388483C3A73E7CA7C7B073DE643BEB",
	"D08F10182A813CBD30F504C064654AF74B9E8C443870A7187DA38A27EC957D25",
	"9F6F727D1218FD5DAD0AB3A0F654C0C06B5CE7720933918C9551A2206CA54180",
	"50EA0108F66AE8AF9F98474BF9735F49E4A05E2A001B659C637AEADB3AC071DE",
	"EB68CBBF532F009CD1A9871164FA0F09FE55E4B56DCE68F9765DAC0CD0497C46",
	"C2832C7E6971F108C8CDDD10E94ABC1DCED238E660B91F8561B1049549C626F1",
	"0267DB45863575D5992AB90B43E4EF2F82BFB3E5C81CF180C989EB94898877F3",
	"B065A1463EDA899712880E7400F3287ECD7B80F29E3508DEFC0C119789899D52",
	"0C6DAA060576DE7F8EA48FAD1EAAA7769A9038775829A0FAB7A4629E735F4D32",
	"CDDCB81AE1D909C2068C36D6A5FCB9E172B220DC35A7A1AE5650536C96B7A76F",
	"777F7593F7415FB20CC60DBD8C10720B4AADFED9443E0085CB3801FDA3536EC4",
	"2033FE1B107965F6E4FE703E1B0988BECC59F91E72DB6EB3195176DAD3BAB734",
	"E7EEF31EF2F2ACF6040EFE49FB479BF83A955EB84EB5C865CD49912B7D5DA2FC",
	"2CDE55624F80B3D23CDAC025AC28EE363407516920B2BF7473BFC061702407E8",
	"228F0C9A929A54C1526C173A76744EB706CFF7A4D07A09AD09D6D31574042DD0",
	"4EB9B8B731EE1A93129F161361EB321FA24BFB33DF690F56E789DC9C3EA33088",
	"379E2A75A060674E2384DF17E3032B2A650914338F1C8618885299CADA420BD5",
	"984205B90B7447907F9F1548AA05C7C8D6625EEEDB0ADE7DC28B387ADAEB97EF",
	"36A57C71AE6AA07524FB1597EDF32E36FE357CD3AD459EB614DC01BB0ACBB798",
	"EE8E847B4D1F389E75ADAD0878D09AE4EFE9C88BE371C99161A5B4FDE4175C94",
	"D6F3CFDBA861573F13FE543B3F022B19496DE0D576C76E256530D4494D7C88F9",
	"F6B77C54E27D01B02EC77B89B7BEE0315D7EA824E90B04341AC8D23D24ECDED9",
	"8C21DC4AC9FA672950D90C6F22DFC5970EECA5A9B0AB2A50703F1F0EAFE9BA50",
	"968D01CF29A26E8DA61ECB20D8848B5D13C1328F95B8516963C21FF3D35E8CBF",
	"40A0A1802CB0980C44368E563B3CFC66CF39F96240CA07D01A4B63CC80361EB8",
	"59A42D27969E08E1A324D366382E5227A8DF4639304901958A83B93E168E709B",
	"9A3B01A5DF227D026D317AE5A74E291A0AAA5B4757CFBCFDF513344E90155C80",
	"38C3D5BFFF301103AFB1EFAD0873AD5ECBDDAF94DC5130CB4AE36A57C398147D",
	"C12F54F79B5935EBD8B61E59EA9007AB5509B87A982CB2FDB09F2CDBB9999FC9",
	"B6431C534FC8BFC5B681092D99AF972815F436CE0EE102DF6846E7EB84A5750A",
	"BC79FAB0AA3FEBDEDC54EBC205A0511870F6AE6D37C81A2601690BDB98911D64",
	"D84AD154152AE131810F85821C4F2C3C05F59DE17E67EA98401A585099287101",
	"C1C95EBE3ECF028BCDD5BCBA1136869F8E518152BE454EEB34F34B6EC4734FE6",
	"C562A227BF9BBCA8661F2ACC204C9272B9530FB49D1BA84FB9CA9DCF365BDC57",
	"739A5712A53429DA22ED24B0FBC0BB38C0D73654271EAE00D3830B2A67172682",
	"020BC20637ABF30F200E0DE76CD12C95E339CCC5F62DF6E0572784410E1DA428",
	"EB5D34B8014B6475B5EC1D427F9849C3BD626A3F56C3EB3A0838110756F5C6E3",
	"05944E5F42D3C37B6830041E637C202018A9CDEA58CCA8E586BC79779A82642B",
	"67BA03F48152C521B147D68FF52843D623F2DFA562DD05F094C46EF05A102717",
	"E00C38631DA09739B57B412D0EA6D17847A4BC9B5C56692CCDC78E32D71B68D2",
	"B274233DEB63CEFFB0704E15A869C0EA62A562A6F652ECAC59632EA2A4AE1CE2",
	"4210AD7820AE57A4CC2FFFF97E2C516DBB7515A61CC95B3715205D11E3347B30",
	"896CCD3C5262A498C7FB38952CF569766156BED8B5F5FC804C0674088E00CA8C",
	"C35A5ED23CBFDC39867D90590601F7D5CE0B13A21F297AF7C323FF418670C3ED",
	"76A9E1F47B24473A19E345241A0BA804DF96EB5B525C86940B90A5D09635F82A",
	"22B03C67F975B05FFFD6A91FAC4546868477E865C5663C6D3F9DC0C041C5CCAE",
	"8B24FC0585989679ADE6E4B47B9A4732BDDB3F7A7CEC62B6D113C229A2847460",
	"1BD84E7D699D78788BE3B7E757222A6C63BD35775B6111F584084A66981690F7",
	"B3B964473847838A572EFA5FF79E680DA838D8A75C895E335A3E68A7306F88FD",
	"DFBA96676427230D64F5A9AE513218789050379812F43B1AD7A9B7C1867363C8",
	"E51A7CD7498ADC89D8A3B523E40A849D202CB939D8DCF1F1ABF767DD7106F80F",
	"6D08ED45235F9DDF810F3E37C311888F300EC445D2FD4628E4A309ADC941D67F",
	"3281471C6F2BCBFE32BD962BFC5F40CECE29CBFDA22B789EF88660F1C3F44FAC",
	"57083CE27A13764B328DC286D0C37AEAE647B7CA5985A09673B032B34214223D",
	"7549B6B76300326FDB2C66AA89640007EB6032CC6A2FB9D61347952AD3ED0A9D",
	"0F9889E004EF5EBACCA1CFD9C948E0377C29874546338E5962786BE164AFACA5",
	"06A8A13669F77AA351A4CC2314291E1B04F0A8A498E05138BE6B5FE2680D0F54",
	"CB40D50785D40F23A53A411150EC34B702642BA3F2E1853BAFC6EBBF157B423F",
	"BB18F6D5BCE1955E2E8B783F44312B05FFD359FF00BA2EC1815E2092BF4931E8",
	"36DE3B8918DE90EB21D0A3B0D67563723E4C60474B68AABFB3628BD5F168774C",
	"D21A3531754DFC9CD4F4DE13EA2AE551D17A85A009B4E4015D137BF1303C2689",
	"85668192CC8BF8BCB0603B55E9B0594AB12777BBD65CB6C547A4BCADE881FB5F",
	"C9219C0D1D6ED38BDF82D5563E05EC9BB1B5571989000BA2B5E39BFBDAD09419",
	"B8A5CDF30266A54CA194B4C5DC22BFE34E5064C3A025CB6ADF4E5AE66A5A8B17",
	"9A46FCCE1CD1AA88B98BD3BDBCAFBB13829C5F28CA91CBE69C7EBC0CBC8EE699",
	"03445465213D2165241691A68F251E5E50F149F9CBEC53AB7F6D57442056D06F",
	"D08C1C9CAC47DA2DD4B4102A831FA456F9E75696394575A230EB12059E13AC05",
	"05748FE675563705C7D8B757E62399E3D9715A2535E88BEC0C083E256195A2BD",
	"AE88F970A8AE15D4FE13885D5AE5024EBB60EDAF7CE0D1032AEFAF852B62C353",
	"6BAD01A873C648D2FCB5CC4DBC8E72C280901FD80291CC179F4DD896E9EEFDB7",
	"46C56D194978600F20E85F2A3A80F4C422DAEB567C5CC5361B4387530F86D0D3",
	"D6100685F30F274B895AFAA871891BC2645F0C33AD1046FBB8BD202FA0578430",
	"A59C8F609032B1AC55BF146180B97C73033ADEC767E1A66487CC709A296E6F47",
	"A709D63B76D8FDE87CC9D271EFBCB2B61795B9DA375A707DB621B74D3ECC4B78",
	"95B65D08EA0836B6168F66637D5C52CC34F27A08A33083AFB20B3C2AA44B258F",
	"02F8B90F328B7747F29F760A3DC6E411532D251F7DFEED0EC492207716EF511B",
	"25CDC477C2F16B66F5C196E22B12AEA03F6EEF8FFF5998C700758F35E01DEFE3",
	"CA69A1D04B4344440EE96A61D7B2EE41F411013746F6134A26251D92BC34D4A5",
	"B3D242752EEEE1A9F4618180690C042501AE97A3330ECA396FE3F26CD27BC7E6",
	"9EE57067A64049D1CB6010DA78EABE831EB58C9D65E45F66452DB082F6A16391",
	"6A9E3C178424A9D5EF30DEB6ACE4C56714AB62D76576D5AFCE4E3B85DB887715",
	"EF4CEB4AE3F65AA654567C5032B3854D9CE71ABF84EE72D321CE7CADA953B46C",
	"C7554A76534D1B4E1EF5EB5B316B22561768894355C7488C7A2098BDFC3E2E45",
	"98D81C3E54B64940350A625B25CE8D7AC5632C785E52473CAF62A521E9B1F5A6",
	"9494B3ED5AF8A1CA1F8C2F1CDAC0B09E535AAA8E8F2DA4187D48CB6BDFBE46C7",
	"4E4985450F3BB4B2D5AFEB2C39B3D0DE4335D5FA728AF0424A6B92CF631D2574",
	"7265632291C813C2E3FE6DF152F88388ADCC411D1147E79CD8F42F43E65B1F62",
	"8C04C73BBAC4288681193BDE7294F659353B0DFC9EB47988E09FA957F9459B84",
	"4324A7BFE9DF0308FFDFDA3B09D04BE4B53B53E79FA3E359B547B1E620B48612",
	"4477D6F5CFDBED07E1ADA5373F28311F7D646E00385EBF4ACC7F97BBE0D38730",
	"236B03968176800A9B77B278D01433DD59101416DD276823560A0D6F0CEA5C7D",
	"B02447BAF113A14F175EF0C76CDC53B33ACD30D15A4F04BAB43B0770362BA094",
	"751C179F99B75C17A98BE2F578F16C765C8E69B5BADAEBEADA801FBA618B16E7",
	"CB1A0BC08903D9A3B7C80046FF74383C8D114C08635E1AE6F7A31D160885A50B",
	"FB0CE5D95284262769FBD60301FA55CF4437106CDBA0FD4DBAB88E6B033DECE2",
	"3713A08DB472C877C617F1259EC9284CE83F2AD3C5E449112DA2AEC5F3A2B67E",
	"A2DD50C162B2317659F1DEF5A5925346AF796F743AF986298D2806C9AD21E138",
	"C675E1ECF4C4281038EA71301C857910A4D2D2EFFDF3DEBE8AD13554A693C0F8",
	"A307B6A12CE3BEFB007875104FCD54E3ECFAC68F6B4C341342D86C55D5ED3E15",
	"103A7A8ADF2BF865164B2CFA5D80270AEAD3EDA2308CA8D39D0BC180C6AF19E5",
	"B2113A401D67FB8365996C07F6DACE02F8D40D593EF1D09FDF23CCE07EB0D7FE",
	"2AF470053C6C330AE096093BDFBD8001171584979B4B62B07C16B9E48DD16BE2",
	"D0F92838D3714C6207AAF4054576895067F6A16B9924ACD74FA517FD0CE7F385",
	"C3B8CADEC8AF14B6117889BB8A87998BE5D2CE825C76B83160FEAB166918081F",
	"D7F7429AAD157ECD554163FAD079DD7B8F215B914BC6AF1C0D703E39CEB78E1E",
	"AB249F595DBFA22CF82D20442360FCDAC67A548E9E51603F74E778072DBF6F71",
	"A91C02D31274C26968CCE4CA30D6D4B0EF9BF8E5C0800B4DF35E0B37D6FDD807",
	"CA3307547646AF7B780B5148D6630EB11E1C8AB22EB488DA8A75C43F0C4EB1AC",
	"DCA00B1E4BEE10262C8F099D4694EA649E9973EDCB9682E8E5CBA4260B428E7A",
	"2A5CC995F5BE1347CF37B7B749F3B66AA45A57740A8610901346375CA3286C87",
	"EB2C357F45879A60DAE7390E83A4623862766014998513C5873CFEAA6A0E601A",
	"C2B3DD723D570E858D5DC3203224A6A158408DC5517916992508C9F44492C7D6",
	"7B9F8B7FEAB2E42CDF6711C251E497444D0A895F3EF7C2E734BFE16DCE2C9758",
	"A958B22493B184DD5738F29F7CDB3FC225FF8C608F009C24DD75A04583083858",
	"3DB6A8E5411C847BB4C5C373028F05F3939AF74ED6B4FC2AB2520D443AFCAB5C",
	"B9B2212B523AF44F152A43ED6D5EF79F9CD3D9F0F27AABBF489141AA784D8FDF",
	"E2681AE71C6FE5A1407007B28F92FFDFE9E2572C14D3715FFE9ABE355D836B2B",
	"49CC1F20AD2E6124BDEECCFE629AAADAA9F0D4C8844235CB20429D07471CDC84",
	"8243D185AADD3980292B93FFC607D0C519B2F3390879E95E994A9FFEFE66DCD5",
	"65852BA418CD8C9D0C848162BBC5487B58C8809BA65C7AD1DECAA91FA370870F",
	"01AD641E9E9236B951F684D4767FEC64696C7D83E49C841A0304C14C946ABB82",
	"271137095F2DB04B02676F40CB838746E40D45702288746F1339928F70B355B8",
	"4E66FE1B09EE0FF59592A105A5CBE8BF3D3B7DE0C090C9E2D6A4576AB2E39831",
	"D3EA4F52DDCFF62073E5E00D0FE76BEF1DC2AD774F60085871B516CB34AF222F",
	"71078ED4DDCDE2FA99AF6402BCA28362748C6761C8F173C4BC757C7B3D48C61B",
	"339DB7F070F71401B6341C843A34B570E49A019D7A8E2993D805D50C6C8B16B4",
	"2BFD72B7896E44C498AFBFBD6D97487961AB646A060DF7907ECA59BEC1A5778D",
	"5DFDC71F6BBC51F8848561F6AEDF33E8D095E8419F83F63F973BAA1721A754A4",
	"9D2D6045B9D527C613AC0864A87122A2A561D7C238AA4255E9F23B90769AF358",
	"71F6FB5A4E089751DF62AFBB9C73ECF551B255AD4577A73436F1CB1FB8FD7339",
	"A6F3CB35310990E9E72CEB6F919F1055BC771C1E90BA75B7CEBA7972932A33A9",
	"29499030879C592806C491BA2552A6AD21235101C5639F4E2BF3BE1273F70A06",
	"6749DE6B01B7B606E938F55648385ABDDEA9F4C7EC08A0348C73795689C812C5",
	"8AFC865B2A8DB0D031E69C23E66BFBB7200EB207E5A922E44191262D9A7043BB",
	"DF22C4BE28F012CA7DF1C473C00D76070D49FD2140B35CE5621114B5A62AD7DE",
	"EBB007D72BCD07C1F7B97D31EF381FB0E38C15A85A2561194F6FA933C6698CCE",
	"07859D29E7E9F28FDE58078E3B3654422317AF59617E4E6CCAF3DE902B98DA08",
	"8D19266AA88457169BE37F770F20C2C98147F17CB8F84DEEBFC9010D7EA5F8BD",
	"43FD16ABEF0EF2EC6D872CD9AA9DC7A0121536A6158FD6F131C7F61975956C27",
	"B42FFE4BA0AC507A558B0C6A9BBAACEED7343322FF6E198F3D839B535C22BA42",
	"9513CE5F9D1D0D45B428FDC72A10D1B35AA9B7687929DBD72E137E84ABA45D25",
	"88EE8F1B34B77A3FEEEB77539C813D401CD5E9E1FAF3AF061CEC302A0F59371E",
	"C40154C36247509AEBBDE391BE0A26666D1538223033DFA6E6E7BD9C73BF677E",
	"4B693A82F02FC39A23B957F6E543E838E1046074053414D0589A0455FD02AEE9",
	"5E9F3F92D89957A212BCE644EB20DDDE639595308F159AAD3C5E7E260A38B2CF",
	"B5B113F441769FCBAF88F3BA451E8A2C9C8D35BAFD851A7A4EDBA0587506D657",
	"55BF09502908F9A49F71CEE69512EA49C1509CE9D3E0B9D5936C10DB21DFCC85",
	"D70B9F84DAB0590F85DDB7ADE716C4B01B50F79BCA32EC7F4CD8871007777B8A",
	"4E9F0016C725E9DFF8B6518D8D362BE2CA33E5DE9208F3A7102B0B03FBFFA836",
	"D6D22BCD4D5EDE958A513E1EC8AA07DE220875A9D387E1DD6084C7CC0CF687A0",
	"BCFED60917033820C1C32B987DC81BDEE6593B0C7C7CA61E9B7EA3190B8ECA8C",
	"576C3972A32FBDB5159DCD2709EC37E26D7E3EA4CE80B958A8C4DA9C31A49D5A",
	"261FBD5600BC760D8926D35D2EB7F6DF2B03B96BFB959331E3263D3939DF8E90",
	"265E78CB344C2A26C772BF181BE88D4EF52C768B7B7242A63F6143A90D9A58A9",
	"A631B71B0E3B2F1D769DA37712747A6EB962CEAE0BEDE3E1E8AF54BF0A125F71",
	"950C95C6BF00E9A1338933ADA6B6C0A36123E0B19C98BBB6A256BCBFAB649198",
	"F16AD9A97F9AC8DEB71BC414FE7787630EE20CF5CDFA8B153125551BE4E2AF7E",
	"2034287198BF5BFA020F711ACD733240177ED50369C489CD12A7646BC23C7ABA",
	"23C6BD876E5C8E58C9EC1A966AECFFC48303F3D5A992DB07D771CAAB68845396",
	"BB4C2D62BFCF8E83ABC4EABC844CBACB83DEF961F50B3E0E6A3B62D221075B04",
	"18E9ADB715E41B89CE64B968A05608D74918A613D3BFCFBF2DC8545F2F674F50",
	"79746450C4B6563A73B3B54FAC871C8E9B5C2F18264C24244C80A831D7730C7A",
	"900BDBCA48F86DABCACBACFCFE013A5A17E41AABB88A9175F933D0B67740AF81",
	"8CE62B3D94341A4A574567BB0EE15518D2527EF12C87DAC85525C1957C82BEB0",
	"3F6A11D271759E7D7A37844805F1536A06ED298ED5183B9CEA79A985A4BDD151",
	"BC7A1C7451D1A1CC6FAE40705944BEE06778917F5518BFD7F9193838FE6D2A7F",
	"D3A4A85BBE51C6344303866B6F136419DEA368CEC9E3A417E7D746A616A1545C",
	"17E5D079D5A3A44EA47F09BD384822F7FAD9DA7B374FFD7F8C2835EEBC78DD73",
	"FCC1BD92E8A08DE9508B60B26BA5E4E8B78918F8CAB2CE6F8BD2F278A9829038",
	"DDD01F54BF34454556C65E72B0F3BD3914F1DBD18B75F7B8AB7094982A7112BE",
	"3270DCCD71767EBCB3EF4F890E649934628DD7CF94B136F6519A018F25132437",
	"F358F45D41FDC9CEBDBC908C6A676EB509166654674F785B20B6E5B78FAE2887",
	"065213B3722367DACE7B4E5634197C4DBCB7559A44599269FE33C515444A8B23",
	"A568253F684148084CCA02D97DACDDD76BE161557335CBCEB7F169B947DBAF91",
	"F4FFBF67C9366607DC44EA5A009E33083F2FA00CC2DBE6DC22A8D9AC53220407",
	"054353C28520C1DBAFB1EC685F6B8DC947D2980E66F32B39FE4304DFCDDD7160",
	"91058B0A5DA0CD976EFFFFEF5FB319763ACE0D8C35018A5D6F96F9D35CB937C0",
	"CA376D5BA86F62CEFF2D70EE7C8B267C8EAE3AE4B5967D3E9621E4877BB51A46",
	"44C824586C2A259AEFA84989E818279D2D0E0AC23DABA22917C435AA185EEA4C",
	"1E947C6B521F50298AFE02A430C23639F4449C6E41B6A8FC76124A079407DF62",
	"EA10F42122BAB59346FDA72D33AAD31221A692753E4E7657F35BA720517DAC44",
	"02C348C371F08B4754CE237D36176D7EB6D4D556BFB1F9C9F8A66054CBC02E3A",
	"A7A92AD773142AD76CD0AA011A995EE454C578A9E9BB264BAB094E1C8E48D1A1",
	"E623990F534E80C09D10602DDD9AA4D9F44027357D5BA825ED3BBE12CA7E2F28",
	"340DA18D04CCE3C6A847026EA23B46F1F7B7E3D22AD6C120E1521CC29EEA4099",
	"FF437EB15CD35F83A6CEBD6A294598B4A7D722FAA3D39FA555C50BE2E278F70C",
	"1874EFB0507E8115B76162E81E86FF60088B022B7BC956F89DF766F2C63B5847",
	"4DC295DDCC98CC388E0D37672E158EA926B3C761074ED40A2E38071EF978D761",
	"EB724B94BCA71524341B1FF4FEDA4F17437506B13971426C03203BA8EE82A691",
	"11F328509170AACBC96B1D2A0B1502E7CE6D0F95FD29251351DA875F8FBED6E9",
	"C663ABFAB57FF0F91648E8067BE92F40EEFA8C2AE667653EABA645F0AF86450C",
	"4C36B85CE4DFBF94ACD273F7A1EE5FCDB615AB50007018E9BAB2A961CBDE51B3",
	"AD043A85E66C424AB842FFEB7968031AC54CABEE0A08C38B4F0A772A3DBACAB7",
	"94373F0696D9BA1CCA4312B827F28D50DF0EFBB82507DD8CB846F388D9D69DB0",
	"5C19E622B2FB4BE2AD7C54B08DEA4D4CB5F62989C792AB3D7AC8B363B805A247",
	"C27127CD54D70B894570F7DA2520E6A02435023F26FB5D13F0B8D1A1BB69212E",
	"210917867309B1D48495D1A663ABF0262DD0FE1C8105FCDBA4DDA22BB1C287B6",
	"93F84A8EDF318A5EFD561D1DF0734BA2C5020CBA32BCE27B5554E54D7B7A8C61",
	"3EBD1E41A94B04ECBA8C2AABE8DF9B488BBE70C62A2045D0D46B261211089ECC",
	"559AAF2957692D8E5CA2FDF25F13E65AB33187C6CCFDB55C58F5BF1EF6A042CD",
	"B055E313CF08A6999A3F88BE516D9F4A9B4A2D99F1CE911936779D8F03E885FE",
	"C122CAEB9A97D78D4F1F5D9EDD57AF4F41DE07DB4B3ACBA5E6735A2B8EBB85CE",
	"2578314F35B3B43B0A65410B351E492467B86FFE5A60841629117DC763AC6250",
	"67620F8E3FCD17D952A39E672B2E1D9F56731D1E1CAFD23640D9C1021B860564",
	"AE989ED5E8352001A5B197AC2443DE09BF95B6070F9A3AE17B12B6E1B75E01E9",
	"F8175C702F45DFB9D175604C443BBEB7C2B7EE99F3FFCDAB2A4E3AA51FCDF8D2",
	"FA67490C6641CFDD550E88A603FDB826E832C106AA61479FD85B0A035824BDC7",
	"94F2477790477E3677DA097EAC6C8C45DE026B414400D1EC6A3E4ED461DF192A",
	"3A89DE6E767A1A9A878DD4314F3E38D6E7C87677C1D2FE98D442CA289F46C9A7",
	"16B12E37EC75EF9831F035D8509A408730CACF274B6FE231652507CBDE35D834",
	"0BDE2F69A15F2ED25B66AD68469542DEC72E5A14F86CAD9CC8587838F280EDB4",
	"F32AC53FEB258C257ABFB0C81A6EAC90E948960E21AA8AF075FF9BC1D13C50AB",
	"3BD7D1759F6AEEA4E7F7DE5E5BB0434756B1F5E0496B05945B0F9155AC425D0E",
	"0431FBCFFD0C0506FA6E286B9723B13CDBBE6FCC18FEF2E5DE04133FF174D542",
	"96E7066799B093ED977ED9EA37E2212E83E7C49CBCFDDFEE65E3D4FE075BF852",
	"0580843F4888FD11B41277E2DFA316A9F4982E505D366A5189DDCCB37239C92B",
	"C5252E460FD9F2CBFC6F4583FDDACCEB96C32693AFC996457B031B34349CB55E",
	"4F71573576C09670E254D3504316DBAAF665D21202AE48916D56AB9C4096AD13",
	"D6DCE51FA775ECEFD1D22550904CC47A74478389720E2D210AA902D7CBF9AC73",
	"755686836CB2E7323BF4E2C5DF03A46DB006DDFA195D3267DD36A22E06B2AD27",
	"63E424B9F7F6A4B3DC36F7251D337B8886705554B821A877FB32E2E5C716532C",
	"1A985A0F99C0AAD06B5DC2A0532D4E7CF55151ED43F3FAE3F376B398C09D6679",
	"1A30188BA9286749206FF8C8C41EA2DC056F153BC85D12295BBBE0296AD10A88",
	"EBE4FC352F064CC5E60CB4AFE4200D05C5E4945D283ADC3FC16FB7AA36013BBD",
	"0FFCE0AFFF167B402EB614EDC0A308ED5EDF5CA03EB979C37B23FC01592CF70C",
	"257AC64E0466EFC998408D428B5D93FB57BC00CAB2ABED6F0555D9CBEFC6C846",
	"7BFB98F1E42E0EF8A54F77C702104B542C717B618DA79646E86A009B7295214E",
	"40F8680B5CD41E6319B745B944D1AF55266DABD86BFD3D847DC3A7D5A3033151",
	"6C5028C092F75EB61B98E5734A547B071D635908F0BEEC2FB47A46029BD02786",
	"E7EBE4BC203EC0923EC7C038CAD1B027C02A039BE44A2DC3C7C5E262732353ED",
	"6D83286B2276F2E65CD8AA44A90EE406C2C0C41475468B8FEA435A291ED72357",
	"4E37EBC592E76DA9E8697F4FCD0E773742AFBB5C14E23761FA091734E09B31FD",
	"456927E8D5C39470AA2E14FD0E2A1E13304373EC68BAC5DEB37A55B3274BEBE4",
	"57996DA6A306DF4A70145D46191FBDC5D6BB7190C62772705078F936753C47D0",
	"0CCD06DEC277F5338AD7C56A39504374C4D39FF5E95108B8D017103A767733F4",
	"D65DD1432A4096B9442FCB09B103C4BB7E7B2BBCDDFD587A7DC22C78E1E84BBF",
	"9560609360FEF653D0729A876AEC64F36881A9483FCFD8205DB0B6950778FFA5",
	"BBB874133508F6882AA1069E61D1A39194C80738DDB20973514B48C7B50C6AB6",
	"AC618239C303852B7AEE4A5113B2BB1AA6A0D41BCEF802E0D8EFF42FC8861801",
	"530382B77B0A26F06500878F626AD1DCA73A5DC27345EF6B7AE1E85B5CFDED86",
	"6B787E269E4E95718ECC2EC4B7C261164E9CDEE9B5686A0D935F317C8F334075",
	"C345A32E28C0805A2BA682FA41887AE4E23057092698B9405B5CF484ED5BA026",
	"68B0A2F09628398DB6A4534C483318F71D7516EB642981E943511F96DC908E97",
	"4843026866ADBF2A9EFFF6538773A1A59F1F6DFDB1DA693DF5B0C23F408B3A68",
	"2F090D19A815D95D2EE4EBA4E8F6AE75DDD32929887EB43318523C10BC35F866",
	"BF14C1B3E5C075DB7771B289BE06A53B7565B29F568225F3B69E8E2672B3617A",
	"BC92F8BBB01548B42B8D0D47A2915D3274640624653201A844A211AEBA3BC6F3",
	"988B14EA6D3F89E2A53C2B553F020BC4C2AB5265B456AF637228841286CBCF9A",
	"93F322493206F875A8DEF842D01B9E07552FF4433DE08CD2C46E32EA02BBBF3C",
	"0B4CFA5EFBD19DDB3BF988147411147A106D5B666B1864E180C4DDEF18F0E66C",
	"DD5DB39249F6E10AFFF3B2B192C9193618CAAE8A50D0C72ED1077C33E67A5925",
	"FD02E8210E04B6FEEBC6CB4FDEF5BCC5D6ABF88863D1E42DC59453F487E02AC5",
	"D1722D7D870EBB783B908002A9E9CFC47AC754EAB85D61EC085C54FEA4400B53",
	"1B4C36F97E27E78580668DBC4125DC1C441E6B3D7FD289D0565B6D5DE088E48D",
	"80A76EBB439F3F03FB590FC132106ABCDDADC3940FD001CCE367BCAEEBD49CBC",
	"57E6938F3A4D9821B5C7322403BACC60A78CAE26FA098BC1F52012F92CCA2E85",
	"D5CF1FD3CB2CECD7C645F3E24079E15C45AF216A04814F80B25BAC12D0254326",
	"33C436D3331E4D8FBA8D1FC95608890E53BC69655402BAAD8E88507D2CE982BA",
	"2C24CE8A7A01B97EC86E52ADFFD35DE000B1F9977B3B123D49677F340AB462DE",
	"D0BCD7C8D5CD4BA4E112F3139971E0677F2C2D88D5F8622B52871D320B9E3451",
	"8C3E7C060B8461F1211762B56844C0D348ABACE0FDC8716315D9AB730DF074F4",
	"2447C41537159FB79061E74902C4E61BFEF401440CFF106CD2971BC74DDA112D",
	"2A8E6A59722B47549893EF243A8211EDF7237DF8D45F56113E46B0AC603ADC96",
	"4CAC9B484F577111D4FAF3C31A274613AD058328CABC7F321687E225E36537C7",
	"2ECF4C43391D2B8F17BFA585D410DCD6D4E84C585BE2D2C2B3551A58BB0B10A8",
	"1B8972AF9FBAD462224F6FED35B0F57806319951FFEE953FE2184CCF54731CD6",
	"606144EC572A76F62CE419179936AE6B24E0C3B9244FF1BC0F534EC0EB2D5275",
	"D87E9347DF1E8432519C83D254170F7B21F7B9E0BE588EB574D1BBB9F4CD0473",
	"E7AFEE4A550D69F520F0D1E9CC5866B43EC9E27B1C9F9D4A37B54122DF8C2CE2",
	"2862A38932EA8E732AC1642585D2563601A4293EAB25AB35303A2CA6F850CC81",
	"5FA24A5B80DA3548455AB886B258F12FC52830BEDC453C3E8391B69F6E00DF82",
	"7559B157FC734FB54BC8AC451CA23633CC4976B3357793C35B8C14C8A1490FBD",
	"AD0D6D7D2BCCF71085E9274BCE1622879F82F574EDC1BD5A88CAABBB5E15FD44",
	"E3EB69B79EAE8648AAB84B9AE531D5C696AEF9BB35A026D0B9512516718B3109",
	"0C850BC4C041F1D01465164747DD814BC45272DE42799DCF2F835E6D0EB976A5",
	"B9B31E07D63461BD3C675FBE5F7465BEC51173C943CB98D698B21795CC5FB41A",
	"47854CBBA11640491F44C1A696A0AD80FD35E36572A6FF65AAEC73BF545AF00C",
	"FAC06E1A78BEB28D003FDBF9207C5B592DCF2919193A791FEDE7E751390047DD",
	"54238EDC19052708381F696C087C1FA7D2E06448F3FF878E86D99CFA0467D96D",
	"F999BB090D82BE3F395C0970EC9A23DACA7A2FE18EE9850B408AD5C5314A38FA",
	"D60192B4F07B511A043B4220F2E3B9A1F74B497DE545438F8437B48314036029",
	"E2C6661D8653511C21B3E962382A34173700B99854F2310CCFB2646DE3C7DD4F",
	"B322B888D79C5CFDBCDB68B89DE05A3260EC18BBA7FECADF417C874409E5846A",
	"DE168023A8165AA8A948F3857AA715041A6FBEBDBF40A439CF55E70093154F5A",
	"F3BA90D8A2563B61761F60E8B5654C84D20FA04EB95BA34AAFBF0AE9EEB0E50E",
	"E7694C03098EC568584EBD7798B9DB8EE7E5D3F9A2A6E8B1742EBC126E0C9E8C",
	"55FCC4C017C60EBB908D5F0F9B92A837C20FBB20AF9030576F9EDB97A57549AB",
	"6623FAEC8BF75A85069AE33C92EE2C9119A4CF364E8F2DAC4468B203E6607117",
	"6A23DD98DCB5237672CA50C8A9ED0898450405041B1383421C909C92D548673A",
	"3A94E9DAB2AB08575975FD2297D1ECA68286DA2B09E95D03F06D17D14012ACE1",
	"852C9664B0AA99F64BC55018A7237704D17EC9455842D3659896152045133C67",
	"F9A12F46E3B05D69C206D5571808EA0444D95D8427B282859292DB31AF512BDB",
	"F1A15DC6A05D02A7F2A0D51E04E4BC9CABFF499D4DC2BC397F807726D9FFD40D",
	"9E36E3193AA8E65827A626D43D5CA27F8DAF41DAA6A9E4CD9495D43A120E1EB9",
	"B78168B190157187335B7EE425632A03FFF33FE55A1F4F5D96353AC4A6E63708",
	"1F690E649E8BF1FE69547292495C8D6352083BAB6F8DDBBB50B48E31AB2BEB12",
	"F11215716823CEEC1406816C3705CE4EE32930DDDDD5127B591046E27FA7FFCE",
	"DE0DD5F16CF8ECF50127B0BE0CA98A0AF8F28E99E8A6974B13A9D69240D682C1",
	"0E6965A71550320DD26FB5E898F4C06B44412FDE481912C14973C9B1FB868E4B",
	"D8DD81E9215DE5B2C84EBE93844CBDA786E821E8FBE69C25C64282FC2528D45E",
	"9B724EF11E6D194713D39D1900BCB0E9BBB5510D2441081E3881A8CDCC30182B",
	"865494ED6040CC8187BF3B20E4148F61702EB447B1535798904343C5611BA28F",
	"898ACA1949B28ABF5458744683EF3EB1AA18C4B764CA98B73D0AEF7122F341B8",
	"F9E9A304A3D819A4C49F049216C6AB965CBD407D3A534AECB8B7705A43BD7E41",
	"8488E4C1C19A142F386BF5322918780CDF39A2711D6C9FF6BD899D287470A2B8",
	"7AA7C2437B4B7F8D186B54145EC21F873D4B1BEF7FF14F498B178132B3BFB743",
	"35FED1B975C8219F2FE0065B3696F2E3A168E219B448918F312A46444EE6FD46",
	"2DC08DB22EC1BED4ED5EA93FBF8A681955E51D1B8039B9391194E67C70036CD0",
	"68071AD868BB5B45F10912CD6D25949FDC7C51CBD656CEB590F2C54E67226DD0",
	"F19B7B14453B787C8799DE89D0F941E47CB7BF7F100FEA8B5D187C3E44452971",
	"E1F33C60132A726E171263EFADD47FE84A894913F71AF59BE6B73B6078D5CEAF",
	"C0F3D72DCB10CC0C2BF54845DCAC4EFD9767E2B431287FAD4C05F60918600084",
	"312713E10B2B321226B955BC3AE74B43AEF3EA37F43DB39525DB9C1739EDF7D2",
	"5D3EEB71153E95FACCEC05C247E33664C7AA8B104FAD1B4BA2F6D3236FB07E4F",
	"EBC6F636203C5E9ECDAEC157201310B1BF51D2976217EE528613630A2C1C56E4",
	"F827B8CF47E5CD91AAE8A1CC47843D08A5AFC1644998062F6C3AAA1B9092D97E",
	"701D52B53C5F77F2B9AF0A76C93A593727CD6A2851FB9D1065964C6EF0B5009D",
	"D08B11815EBCA4516F1888F063FB0912037EB8D9FC4886A6445BE0873662FF74",
	"C59E137841DBE0A2173C828CA9DF76E6F6C5B630F10924F0AF7E4AFD9853C760",
	"43E1A0C55C4DDA0163CD06B051F83455F30EF5DA9BCF0BA71C4F4A4D71B8CA48",
	"5792A228B687D34BC2C80C102B8083CC805FB03CE6319E8C627023B5A0DB6A63",
	"84BBCC6AC5B7BA398287E512411B67E72E9C6CE6EBCC47A28A54395E4860727A",
	"D0C79C95777613A2DAF1928E4B95A8F9E9FAAD9DF1321033BE432783CBC2078F",
	"89997213AB237D36676C1B37617ABF888A598CAC6BEC05422BB463EDFA5E1198",
	"0B0EBAB802CD03156DF98271059E7BDB02D3A3EF6F75EEEA351BFB253366B708",
	"2F7AE932EC46112E01943A7809DCE78A92DDD559678B1D5701FA861C49219594",
	"FF4B7C63AF3D658B1ADF4D659059ACA3AC0DFF1E0DA318209E725EF806DFF5E2",
	"D47FC76CAFA6BD1A97645F0CA52EE5284106B6D1C8B2246198C0A7932BAFD403",
	"A188D2D39D3B0054BC086F6D7BE59B8042D3B872243C8B477D2A910C8932AC87",
	"5664BF1F148966BDC4E2AC635A1A5E59DB8BF2B8E2ECC85D7B1F7880BF3B078D",
	"31F38EDE7A722B8C480B6A545A39562923B41E62D5650149D60B0C20B6BCC2E9",
	"A9F406450C1A3C90E95F9CAC58638D40E6A4377D3D47C5070C91A0D64F100D81",
	"BC33B1AA5A6EB9EECF9B0144FAB645447E819FBB5F4939083A9E645CACA8713D",
	"78F45063D65F72BA855D19C447E4072098ED86F488BDF4DEC0A8DC30E5AD5B21",
	"A7F9883E14FB6BF17E2FE5029330BD9DFE3A3D56C9D2FE34D4C78FCC8B958CE6",
	"33C991FDBA0E06A2B6C4E69CAB13620E7F5504CCDC233360D5894CB8AEF84013",
	"DE33ACED887ACFA18717F8845591C34D3744F7162B667C321E16A6281DA03C0D",
	"E36B0BEC4F7B9636924617FABA609608DBE48AC0BC832DC1CB969E3E361DAA5B",
	"A62A80624BED309BD04F04F46C5738A741ADE15A69751F425B1AAED1CD5F5235",
	"A1DC3353F1C9D5DFA400682D1B04C958D2383BF2C80CB45F0995AD23A1923B4A",
	"617C13A04FE97E881F960DF582C39C0F4EB2C02602A7FF2EBB047372B6988E5E",
	"BA8F41B9E1F1608BD2C71A84EE0B25D25962BE1BF87DC82398B0B18ED800062E",
	"6B45D0D4C4CCEC520FD94DCEB2F399C3AD660A0725BF85AA56DAC7AADE17FAD7",
	"A934AC7289CAFCF64A43ACCF8A0A47CCF444FB1E830B24612D6F508592B9F07E",
	"283B704ED442075870458649A2D61482D8AFC9B5F43618A2F4F9DFB13B127DFA",
	"1585EDF934C4F4BF51A125091762BD34450C347B3B9CB88B3CE0EA90EE6CE998",
	"165217D2DB6D6976935FFB4A35D0EE99B8B962442BD351A320D71C58D0C1A047",
	"D80C3163852E5FE3A16CE0D7E6A1EC067089B2D0D03EB3D9F4813EDA1B1B9FEF",
	"CC8011EEB70940D682EC62B723FF26A04DE6A516E7775B71C9A3C563C3BF4EE6",
	"71D0EEAACDF187668BC86E55911DC7BE8425E7CB9A895D5B9FB90C7C14821866",
	"7456817E567486104F3CB1E421461113602E38E953F8B7ACA8354E85495595C0",
	"F30ACD4F924CFE0DA12F045F3810DBEEC977D49EA63B7FE2F93167B4A6E4CEA1",
	"00423BD27005F76D0AA5DCC47869E59C16353CD84D9D8D02A655F1B488396D11",
	"D115B271D5B97E7E016565A36DDA1DD0282E6EEC10121EDF5448CA1DD9F2933C",
	"FF7E356597C2CBE16449B629753B149AF53D88D997684EE98CF80821E8DB271E",
	"01DC15E7AD4550BC78C86D3325A3E0CED5F5A9458CEE87BC16C916521EAA41ED",
	"91D777B050539F5348A9847BA7791691945732D716E8FFFD8621DBC710D4C39C",
	"FB5E18C07B19F48EC6814A197877ADA88E633A727AA35A7930B5A6DF71556D05",
	"7D823A07DD309BCA55493B8807D8F4C76311BECEF5D77B623858CC32FD04E12B",
	"FA5D004554D43A19EDE6BDAD4E006D67202EC2B583F23152376A73B4D52583D6",
	"AC9367577F3ACA9B924A306488D119D1808CA4656EA10D4D42B17E0BC15A057F",
	"89E582929DE1F7367A237BC7EA95FE8C8CD2AC8A06435A311494BC370A43E225",
	"D620AC1F48A931D33A5785C9795E65BBB98CA66019572F315CA8336CC38CD979",
	"D180D89CE8A4CC5DDA7A3C3F5C6F6CE063BE9939E2B732735520DE754AF80C08",
	"7DC94FD6253300B89E22D09FD10F11143B598030428DAE88C9343645030D8AFF",
	"A5DE6751236D6646589F076715F457A1D15B2F0EE1E521761A6D23971065170E",
	"7A2E5140C76C23C762ED78423CE29379D98C5222C90ABFFF328CEC87C4324F52",
	"C4687772E68435A64A0292FC2E7CE785F838831FFDAEA085CEC705C560E23F25",
	"B6FB9DB6EBED371A9F1CB457AEA3F9C60BF102EB619C609C41F3CBF2B081D968",
	"20DF6D8F12C043BD40932BF9DE476B2EE1748FFED74FBB6BB8326CEF4CD52584",
	"02E145163AC998C77726B8ED31755FA19846A09C26143574AC668E9942184ECC",
	"8322C4249694117089E2AC0D072425361A4BDA9BC11BB5EACCAE2638B0FDAB6B",
	"4AEA9507C37BF3CE4C8697C621597601FFB94540B67292DBE25F79CDCB5972EB",
	"5E8B03D77E90D5C9DD7761DE25F45B4EA9DEECB28BA0251A1A719ED84CE5B718",
	"14354FF1E3E054262B71E6EE6C2B60D967D1A9830265C646CB0B337511BE220B",
	"B17317446601588BB0524D53A2CCF43A94FF8F4C9806ECBB7823787F46715A6D",
	"9E112F27AD921A757C26051DEEDB6CC4F1D5963D180E963FFA6F36836C0FD66B",
	"1FA60EC5D70DCB3ED642F429191C3B1658ED2D7073EC47B21B308667EC93231D",
	"5FCEBF63479289BD8E08CD21C4C66012172C7054E86FC2EB5265828CDADA449E",
	"72087BB4DCB2C405235592E5DD7C887090857D2327110E3771DB4543A8A486FC",
	"9BCEC1F50F78335D4B1A04D32621E9495721ACB4A5195EC6EF10753B14265C09",
	"0A5D64567A643130897FACF00E0FA475899BFE626BEF8E774979890CBB171FE9",
	"7816599534D5C2C7B96A1B41F1A59A0DFE1518C54623976F413E08382835605F",
	"A4DF9518B225165C66BB61CC7E46C42256534F015F26FE787497E7260BBDB17A",
	"8D083731E65B464A5A0B3F16995ED0528F4A7616DF2C44B0E6B7E90A92F9A14C",
	"A69BC849DB7B521ADDB970FCDF8984CE098E2C652AC96CB59C71578E85EC2B0A",
	"DD87F320BF2A83E77C038F74279396F17005B601B9CF4286CC69D0B00819B924",
	"9434A6ACA5F3F6945E3D0A9D3E62AECFD4397B3F057A3972517B8636C626A38F",
	"386BA8A0DD685E2860B66A0B3DFE5BDD87B0B9E898ECF1F24290B1E2BD874117",
	"33F44E6047190D02666F5D7D75BDE78795F686450E79F165E3CB5566CA9D1769",
	"3B27FF1A1ABDBA23E738BF958A856E2E165B012E69B0BD3E22A71923652E5084",
	"F578CE7FAC7B8BC46F41002A12510587C0DE7D7E53632A832587D44112FF1FA6",
	"6331D5085F1BE7F54E51932EADE6F765F4D7FF16F1CF67E6993B90132713AAD3",
	"9C379BFEC0F3CE1127EE761EDD918F4FC6D6CC183E5F70AFB3C3F3C02D53D421",
	"3B41C82CD692D68948A1CFC1657F06271A488F4880ADD0B4EE4BFEBBA0D4050E",
	"5B4FACE27EC3765D7B9BBA2082D7781230A458AB4FC52C59D2B8DE84692A29A4",
	"98DD7F438FEBAEA30F0A80A0B0CF547DA77AF39F28AE909ED2139F1221133DB8",
	"8BE9C6B16DE70460AEEFFC6D35229777C7067B792E6FEEF48750B4A9DCA2D61A",
	"92A25061E3B3EDA05BC3BD42BE7C13BF212B0E3AA1874D89A85BC500518B766A",
	"9A8EDCE718985195772449D6970CF847F4A8DC01775D12B9F9C8B40C47363FDC",
	"0D8F68BA45E6919BA5421D36A8CCD1769E78308693D27BFC7F723DFD6D268EE5",
	"FE334C0C929CBE1355C5C297095E77D8996E704AAD3BAB62588652B4A8768FE1",
	"050447FC10D71F5A3DB24F824BDBA467AFDFF81732CF78328C6AA22E214F1484",
	"B2DC246963894CD35E912D5FB5E51E74969B86AFFA9D043C1830B4EE0A4C072D",
	"A401DF440DA4890548AA981C19765EA4667D65AA8A707B170E8A1BE3A7131366",
	"FBEE56D123852FD358A0BC43FB5C50E22C2B6F59FC68FB72A2C649247FAF0F64",
	"FB742031B2A4FFB2E693628ACF301F154A178E9E22BC836BECF61510FD366A75",
	"4CDEAAD91C645A418775F4036DFD66F904FBBC935B531D42477D0C976F7C6838",
	"05896BC83C69EC553276820393EE06FC1A944C924F8C931A4CBBFCB25DCF0707",
	"B3DF6CFE1129F3E4CDEDB00D97AEF08AEB689AC30F97B418148E036AC1F626BB",
	"4A71F01BE5BF68FB270CAF57320D1A0B7C14EEF27026774F2586868ECB6EACC7",
	"25F63C66007EC7A7FDBED5C979B8994AA7BA32381C50FBE058282569AC648399",
	"6F2069AAAB017B712EE248BD17621812BAF6AE41B39B490918841C7E0386CE88",
	"2528C98BF5E5C331048E0000000000000000000000000000000000000000000000000000000000000000",
	"0000000000000000000000000000000000000000000000000000000000000000",
	"0000000000000000000000000000000000000000000000000000000000000000",
	"0000000000000000000000000000000000000000000000000000000000000000",
	"0000000000000000000000000000000000000000000000000000000000000000",
	"0000000000000000000000000000000000000000000000000000000000000000",
	"0000000000000000000000000000000000000000000000000000000000000000",
	"0000000000000000000000000000000000000000000000000000000000000000",
	"cleartomark",
	NULL
};

#endif /* _ISOKEYS_H_ */
