.\" $XFree86: xc/programs/Xserver/hw/xfree86/getconfig/getconfig.man,v 1.3 2005/02/09 20:55:57 dawes Exp $
.\"
.\" Copyright  2003-2005 David H. Dawes.
.\" Copyright  2003-2005 X-Oz Technologies.
.\" All rights reserved.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\" 
.\"  1. Redistributions of source code must retain the above copyright
.\"     notice, this list of conditions, and the following disclaimer.
.\"
.\"  2. Redistributions in binary form must reproduce the above
.\"     copyright notice, this list of conditions and the following
.\"     disclaimer in the documentation and/or other materials provided
.\"     with the distribution.
.\" 
.\"  3. The end-user documentation included with the redistribution,
.\"     if any, must include the following acknowledgment: "This product
.\"     includes software developed by X-Oz Technologies
.\"     (http://www.x-oz.com/)."  Alternately, this acknowledgment may
.\"     appear in the software itself, if and wherever such third-party
.\"     acknowledgments normally appear.
.\"
.\"  4. Except as contained in this notice, the name of X-Oz
.\"     Technologies shall not be used in advertising or otherwise to
.\"     promote the sale, use or other dealings in this Software without
.\"     prior written authorization from X-Oz Technologies.
.\"
.\" THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR
.\" IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL X-OZ TECHNOLOGIES OR ITS CONTRIBUTORS
.\" BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
.\" OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
.\" OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
.\" BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
.\" WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
.\" OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
.\" EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\" 
.\" Author: David Dawes <dawes@x-oz.com>.
.\"
.TH getconfig 1 __vendorversion__
.SH NAME
getconfig - get configuration information for the XFree86 server
.SH SYNOPSIS
.B getconfig
.RI [ option
.IR ... ]
.SH DESCRIPTION
.B getconfig
is a programmatic interface that is used by the
.B XFree86
server to get configuration information about video hardware when
operating without an
.B XF86Config
file.
.PP
This implementation of
.B getconfig
is written in perl.  It processes a prioritized and ordered list of
rules supplied internally and from meta-configuration files.  The rules
are in the form of perl expressions.
.B getconfig
writes to standard output the XF86Config-style configuration data
specified by the last highest priority rule that evaluates to true.
Information about the format of the meta-configuration files can be
found in the getconfig(__filemansuffix__) manual page.
.SH OPTIONS
.TP 8
.BI \-I " search-path"
Specify the search path to use for meta-config files.
.I search-path
is a comma-separated list of directories to search.  Each directory in
the search path is searched for files with a
.I .cfg
suffix.  Each such file is opened and checked for a valid signature
string.  Rules are read from files with a valid signature string and
appended to the list of rules to evaluate.  If no search path is specified,
only the internally supplied configuration rules will be used.
.TP 8
.B \-D
Enable debugging output.
.TP 8
.B \-V
Print out the version information and exit.
.TP 8
.BI \-X " XFree86-version"
Specify the XFree86 version in numeric (integer) form.
.TP 8
.BI \-b " subsys-id"
Specify the PCI subsystem ID of the video device.
.TP 8
.BI \-c " class"
Specify the PCI class of the video device.
.TP 8
.BI \-d " device-id"
Specify the PCI device ID of the video device.
.TP 8
.BI \-r " revision"
Specify the PCI revision of the video device.
.TP 8
.BI \-s " subsysvendor-id"
Specify the PCI subsystem vendor ID of the video device.
.TP 8
.BI \-v " vendor-id"
Specify the PCI vendor ID of the video device.
.TP 8
.BI \-S " sbus-path"
Specify the SBUS path of the video device.
.SH FILES
.I .cfg
files located in the search path.  The search path typically specified
by the
.B XFree86
server is:
.PP
.RS 4
.nf
.I /etc/X11
.I __projectroot__/etc/X11
.I <modulepath>
.I __projectroot__/lib/X11/getconfig
.fi
.RE
.PP
where
.I <modulepath>
is the
.B XFree86
server's module search path.

.SH "SEE ALSO"
getconfig(__filemansuffix__),
XFree86(1),
XF86Config(__filemansuffix__).

.SH AUTHORS
The XFree86 automatic configuration support and the
.B getconfig
interface was written by David H. Dawes, with the support of X-Oz
Technologies.
