.\" $XFree86: xc/programs/Xserver/hw/xfree86/XFree86.man,v 3.73 2005/03/16 15:31:32 dawes Exp $
.\"
.\" Copyright (c) 1994-2005 by The XFree86 Project, Inc.
.\" All rights reserved.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject
.\" to the following conditions:
.\"
.\"   1.  Redistributions of source code must retain the above copyright
.\"       notice, this list of conditions, and the following disclaimer.
.\"
.\"   2.  Redistributions in binary form must reproduce the above copyright
.\"       notice, this list of conditions and the following disclaimer
.\"       in the documentation and/or other materials provided with the
.\"       distribution, and in the same place and form as other copyright,
.\"       license and disclaimer information.
.\"
.\"   3.  The end-user documentation included with the redistribution,
.\"       if any, must include the following acknowledgment: "This product
.\"       includes software developed by The XFree86 Project, Inc
.\"       (http://www.xfree86.org/) and its contributors", in the same
.\"       place and form as other third-party acknowledgments.  Alternately,
.\"       this acknowledgment may appear in the software itself, in the
.\"       same form and location as other such third-party acknowledgments.
.\"
.\"   4.  Except as contained in this notice, the name of The XFree86
.\"       Project, Inc shall not be used in advertising or otherwise to
.\"       promote the sale, use or other dealings in this Software without
.\"       prior written authorization from The XFree86 Project, Inc.
.\"
.\" THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
.\" WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
.\" MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
.\" IN NO EVENT SHALL THE XFREE86 PROJECT, INC OR ITS CONTRIBUTORS BE
.\" LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
.\" OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
.\" OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
.\" BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
.\" WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
.\" OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
.\" EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\"
.\" Information related to automatic configuration is:
.\"
.\" Copyright  2003, 2004, 2005 David H. Dawes.
.\" Copyright  2003, 2004, 2005 X-Oz Technologies.
.\" All rights reserved.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\" 
.\"  1. Redistributions of source code must retain the above copyright
.\"     notice, this list of conditions, and the following disclaimer.
.\"
.\"  2. Redistributions in binary form must reproduce the above
.\"     copyright notice, this list of conditions and the following
.\"     disclaimer in the documentation and/or other materials provided
.\"     with the distribution.
.\" 
.\"  3. The end-user documentation included with the redistribution,
.\"     if any, must include the following acknowledgment: "This product
.\"     includes software developed by X-Oz Technologies
.\"     (http://www.x-oz.com/)."  Alternately, this acknowledgment may
.\"     appear in the software itself, if and wherever such third-party
.\"     acknowledgments normally appear.
.\"
.\"  4. Except as contained in this notice, the name of X-Oz
.\"     Technologies shall not be used in advertising or otherwise to
.\"     promote the sale, use or other dealings in this Software without
.\"     prior written authorization from X-Oz Technologies.
.\"
.\" THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR
.\" IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL X-OZ TECHNOLOGIES OR ITS CONTRIBUTORS
.\" BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
.\" OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
.\" OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
.\" BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
.\" WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
.\" OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
.\" EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\" 
.\"
.TH XFree86 1 __vendorversion__
.SH NAME
XFree86 - X11R6 X server
.SH SYNOPSIS
.B XFree86
.RI [\fB:\fP display ]
.RI [ option
.IR ... ]
.SH DESCRIPTION
.B XFree86
is a full featured X server that was originally designed for UNIX and
UNIX-like operating systems running on Intel x86 hardware.  It now runs
on a wider range of hardware and OS platforms.
.PP
This work was originally derived from
.I "X386\ 1.2"
by Thomas Roell which was contributed to X11R5 by Snitily Graphics
Consulting Service.  The
.B XFree86
server architecture was redesigned for the 4.0 release, and it includes
among many other things a loadable module system derived from code
donated by Metro Link, Inc.  The current XFree86 release is compatible
with X11R6.6.
.SH PLATFORMS
.PP
.B XFree86
operates under a wide range of operating systems and hardware platforms.
The Intel x86 (IA32) architecture is the most widely supported hardware
platform.  Other hardware platforms include Compaq Alpha, Intel IA64,
SPARC and PowerPC.  The most widely supported operating systems are the
free/OpenSource UNIX-like systems such as Linux, FreeBSD, NetBSD and
OpenBSD.  Commercial UNIX operating systems such as Solaris (x86) and
UnixWare are also supported.  Other supported operating systems include
LynxOS, and GNU Hurd.  Darwin and Mac OS X are supported with the
XDarwin(1) X server.  Win32/Cygwin is supported with the XWin X server.
.PP
.SH "NETWORK CONNECTIONS"
.B XFree86
supports connections made using the following reliable
byte-streams:
.TP 4
.I "Local"
On most platforms, the "Local" connection type is a UNIX-domain socket.
On some System V platforms, the "local" connection types also include
STREAMS pipes, named pipes, and some other mechanisms.
.TP 4
.I TCP\/IP
.B XFree86
listens on port
.RI 6000+ n ,
where
.I n
is the display number.  This connection type can be disabled with the
.B \-nolisten
option (see the Xserver(1) man page for details).
.SH "ENVIRONMENT VARIABLES"
For operating systems that support local connections other than Unix
Domain sockets (SVR3 and SVR4), there is a compiled-in list specifying
the order in which local connections should be attempted.  This list
can be overridden by the
.I XLOCAL
environment variable described below.  If the display name indicates a
best-choice connection should be made (e.g.
.BR :0.0 ),
each connection mechanism is tried until a connection succeeds or no
more mechanisms are available.  Note: for these OSs, the Unix Domain
socket connection is treated differently from the other local connection
types.  To use it the connection must be made to
.BR unix:0.0 .
.PP
The
.I XLOCAL
environment variable should contain a list of one more
more of the following:
.PP
.RS 8
.nf
NAMED
PTS
SCO
ISC
.fi
.RE
.PP
which represent SVR4 Named Streams pipe, Old-style USL Streams pipe,
SCO XSight Streams pipe, and ISC Streams pipe, respectively.  You can
select a single mechanism (e.g.
.IR XLOCAL=NAMED ),
or an ordered list (e.g. \fIXLOCAL="NAMED:PTS:SCO"\fP).
his variable overrides the compiled-in defaults.  For SVR4 it is
recommended that
.I NAMED
be the first preference connection.  The default setting is
.IR PTS:NAMED:ISC:SCO .
.PP
To globally override the compiled-in defaults, you should define (and
export if using
.B sh
or
.BR ksh )
.I XLOCAL
globally.  If you use startx(1) or xinit(1), the definition should be
at the top of your
.I .xinitrc
file.  If you use xdm(1), the definitions should be early on in the
.I __projectroot__/lib/X11/xdm/Xsession
script.
.SH OPTIONS
.B XFree86
supports several mechanisms for supplying/obtaining configuration and
run-time parameters: command line options, environment variables, the
XF86Config(__filemansuffix__) configuration file, auto-detection, and
fallback defaults.  When the same information is supplied in more than
one way, the highest precedence mechanism is used.  The list of mechanisms
is ordered from highest precedence to lowest.  Note that not all parameters
can be supplied via all methods.  The available command line options
and environment variables (and some defaults) are described here and in
the Xserver(1) manual page.  Most configuration file parameters, with
their defaults, are described in the XF86Config(__filemansuffix__) manual
page.  Driver and module specific configuration parameters are described
in the relevant driver or module manual page.
.PP
Starting with version 4.4,
.B XFree86
has support for generating a usable configuration at run-time when no
XF86Config(__filemansuffix__) configuration file is provided.  The
initial version of this automatic configuration support is targeted at
the most popular hardware and software platforms supported by XFree86.
Some details about how this works can be found in the
.B CONFIGURATION
section below and in the getconfig(1) manual page.
.PP
In addition to the normal server options described in the Xserver(1)
manual page,
.B XFree86
accepts the following command line switches:
.TP 8
.BI vt XX
.I XX
specifies the Virtual Terminal device number which
.B XFree86
will use.  Without this option,
.B XFree86
will pick the first available Virtual Terminal that it can locate.  This
option applies only to platforms such as Linux, BSD, SVR3 and SVR4, that
have virtual terminal support.
.TP 8
.B \-allowMouseOpenFail
Allow the server to start up even if the mouse device can't be opened
or initialised.  This is equivalent to the
.B AllowMouseOpenFail
XF86Config(__filemansuffix__) file option.
.TP 8
.B \-allowNonLocalModInDev
Allow changes to keyboard and mouse settings from non-local clients.
By default, connections from non-local clients are not allowed to do
this.  This is equivalent to the
.B AllowNonLocalModInDev
XF86Config(__filemansuffix__) file option.
.TP 8
.B \-allowNonLocalXvidtune
Make the VidMode extension available to remote clients.  This allows
the xvidtune client to connect from another host.  This is equivalent
to the
.B AllowNonLocalXvidtune
XF86Config(__filemansuffix__) file option.  By default non-local
connections are not allowed.
.TP 8
.B \-appendauto
Append the automatic XFree86 server configuration data to an existing
configuration file.  By default this is only done when an existing
configuration file does not contain any
.B ServerLayout
sections or any
.B Screen
sections.  This can be useful for providing configuration details for
things not currently handled by the automatic configuration mechanism,
such as input devices, font paths, etc.
.TP 8
.B \-autoconfig
Use automatic XFree86 server configuration, even if a configuration file
is available.  By default automatic configuration is only used when a
configuration file cannot be found.
.TP 8
.BI \-bgamma " value"
Set the blue gamma correction.
.I value
must be between 0.1 and 10.
The default is 1.0.  Not all drivers support this.  See also the
.BR \-gamma ,
.BR \-rgamma ,
and
.B \-ggamma
options.
.TP 8
.BI \-bpp " n"
No longer supported.  Use
.B \-depth
to set the color depth, and use
.B \-fbbpp
if you really need to force a non-default framebuffer (hardware) pixel
format.
.TP
.B \-configure
When this option is specified, the
.B XFree86
server loads all video driver modules, probes for available hardware,
and writes out an initial XF86Config(__filemansuffix__) file based on
what was detected.  This option currently has some problems on some
platforms, but in most cases it is a good way to bootstrap the
configuration process.  This option is only available when the server
is run as root (i.e, with real-uid 0).
.TP 8
.BI "\-crt /dev/tty" XX
SCO only.  This is the same as the
.B vt
option, and is provided for compatibility with the native SCO X server.
.TP 8
.BI \-depth " n"
Sets the default color depth.  Legal values are 1, 4, 8, 15, 16, and
24.  Not all drivers support all values.
.TP 8
.B \-disableModInDev
Disable dynamic modification of input device settings.  This is equivalent
to the
.B DisableModInDev
XF86Config(__filemansuffix__) file option.
.TP 8
.B \-disableVidMode
Disable the the parts of the VidMode extension (used by the xvidtune
client) that can be used to change the video modes.  This is equivalent
to the
.B DisableVidModeExtension
XF86Config(__filemansuffix__) file option.
.TP 8
.B \-fbbpp \fIn\fP
Sets the number of framebuffer bits per pixel.  You should only set this
if you're sure it's necessary; normally the server can deduce the correct
value from
.B \-depth
above.  Useful if you want to run a depth 24 configuration with a 24
bpp framebuffer rather than the (possibly default) 32 bpp framebuffer
(or vice versa).  Legal values are 1, 8, 16, 24, 32.  Not all drivers
support all values.
.TP 8
.B \-flipPixels
Swap the default values for the black and white pixels.
.TP 8
.BI \-gamma " value"
Set the gamma correction.
.I value
must be between 0.1 and 10.  The default is 1.0.  This value is applied
equally to the R, G and B values.  Those values can be set independently
with the
.BR \-rgamma ,
.BR \-bgamma ,
and
.B \-ggamma
options.  Not all drivers support this.
.TP 8
.BI \-ggamma " value"
Set the green gamma correction.
.I value
must be between 0.1 and 10.  The default is 1.0.  Not all drivers support
this.  See also the
.BR \-gamma ,
.BR \-rgamma ,
and
.B \-bgamma
options.
.TP 8
.B \-ignoreABI
The
.B XFree86
server checks the ABI revision levels of each module that it loads.  It
will normally refuse to load modules with ABI revisions that are newer
than the server's.  This is because such modules might use interfaces
that the server does not have.  When this option is specified, mismatches
like this are downgraded from fatal errors to warnings.  This option
should be used with care.
.TP 8
.B \-keeptty
Prevent the server from detaching its initial controlling terminal.
This option is only useful when debugging the server.  Not all platforms
support (or can use) this option.
.TP 8
.BI \-keyboard " keyboard-name"
Use the XF86Config(__filemansuffix__) file
.B InputDevice
section called
.I keyboard-name
as the core keyboard.  This option is ignored when the
.B ServerLayout
section specifies a core keyboard.  In the absence of both a ServerLayout
section and this option, the first relevant
.B InputDevice
section is used for the core keyboard.
.TP 8
.BI \-layout " layout-name"
Use the XF86Config(__filemansuffix__) file
.B ServerLayout
section called
.IR layout-name .
By default the first
.B ServerLayout
section is used.
.TP 8
.BI \-logfile " filename"
Use the file called
.I filename
as the
.B XFree86
server log file.  The default log file is
.BI __logdir__/XFree86. n .log
on most platforms, where
.I n
is the display number of the
.B XFree86
server.  The default may be in a different directory on some platforms.
This option is only available when the server is run as root (i.e, with
real-uid 0).
.TP 8
.BR \-logverbose " [\fIn\fP]"
Sets the verbosity level for information printed to the
.B XFree86
server log file.  If the
.I n
value isn't supplied, each occurrence of this option increments the log
file verbosity level.  When the
.I n
value is supplied, the log file verbosity level is set to that value.
The default log file verbosity level is 3.
.TP 8
.BI \-modulepath " searchpath"
Set the module search path to
.IR searchpath .
.I searchpath
is a comma separated list of directories to search for
.B XFree86
server modules.  This option is only available when the server is run
as root (i.e, with real-uid 0).
.TP 8
.B \-noappendauto
Disable appending the automatic XFree86 server configuration to a partial
static configuration.
.TP 8
.B \-nosilk
Disable Silken Mouse support.
.TP 8
.B \-pixmap24
Set the internal pixmap format for depth 24 pixmaps to 24 bits per pixel.
The default is usually 32 bits per pixel.  There is normally little
reason to use this option.  Some client applications don't like this
pixmap format, even though it is a perfectly legal format.  This is
equivalent to the
.B Pixmap
XF86Config(__filemansuffix__) file option.
.TP 8
.B \-pixmap32
Set the internal pixmap format for depth 24 pixmaps to 32 bits per pixel.
This is usually the default.  This is equivalent to the
.B Pixmap
XF86Config(__filemansuffix__) file option.
.TP 8
.BI \-pointer " pointer-name"
Use the XF86Config(__filemansuffix__) file
.B InputDevice
section called
.I pointer-name
as the core pointer.  This option is ignored when the
.B ServerLayout
section specifies a core pointer.  In the absence of both a ServerLayout
section and this option, the first relevant
.B InputDevice
section is used for the core pointer.
.TP 8
.B \-probeonly
Causes the server to exit after the device probing stage.  The
XF86Config(__filemansuffix__) file is still used when this option is
given, so information that can be auto-detected should be commented out.
.TP 8
.B \-quiet
Suppress most informational messages at startup.  The verbosity level
is set to zero.
.TP 8
.BI \-rgamma " value"
Set the red gamma correction.
.I value
must be between 0.1 and 10.  The default is 1.0.  Not all drivers support
this.  See also the
.BR \-gamma ,
.BR \-bgamma ,
and
.B \-ggamma
options.
.TP 8
.B \-scanpci
When this option is specified, the
.B XFree86
server scans the PCI bus, and prints out some information about each
device that was detected.  See also scanpci(1) and pcitweak(1).
.TP 8
.BI \-screen " screen-name"
Use the XF86Config(__filemansuffix__) file
.B Screen
section called
.IR screen-name .
By default the screens referenced by the default
.B ServerLayout
section are used, or the first
.B Screen
section when there are no
.B ServerLayout
sections.
.TP 8
.B \-showconfig
This is the same as the
.B \-version
option, and is included for compatibility reasons.  It may be removed
in a future release, so the
.B \-version
option should be used instead.
.TP 8
.BI \-weight " nnn"
Set RGB weighting at 16 bpp.  The default is 565.  This applies only to
those drivers which support 16 bpp.
.TP 8
.BR \-verbose " [\fIn\fP]"
Sets the verbosity level for information printed on stderr.  If the
.I n
value isn't supplied, each occurrence of this option increments the
verbosity level.  When the
.I n
value is supplied, the verbosity level is set to that value.  The default
verbosity level is 0.
.TP 8
.B \-version
Print out the server version, patchlevel, release date, the operating
system/platform it was built on, and whether it includes module loader
support.
.TP 8
.BI \-xf86config " file"
Read the server configuration from
.IR file .
This option will work for any file when the server is run as root (i.e,
with real-uid 0), or for files relative to a directory in the config
search path for all other users.
.SH "KEYBOARD"
.PP
The
.B XFree86
server is normally configured to recognize various special combinations
of key presses that instruct the server to perform some action, rather
than just sending the key press event to a client application.  The
default XKEYBOARD keymap defines the key combinations listed below.
The server also has these key combinations builtin to its event handler
for cases where the XKEYBOARD extension is not being used.  When using
the XKEYBOARD extension, which key combinations perform which actions
is completely configurable.
.PP
For more information about when the builtin event handler
is used to recognize the special key combinations, see
the documentation on the
.B HandleSpecialKeys
option in the XF86Config(__filemansuffix__) man page.
.PP
The special combinations of key presses recognized directly
by
.B XFree86
are:
.TP 8
.B Ctrl+Alt+Backspace
Immediately kills the server -- no questions asked.  This can be disabled
with the
.B DontZap
XF86Config(__filemansuffix__) file option.
.TP 8
.B Ctrl+Alt+Keypad-Plus
Change video mode to next one specified in the configuration file.
This can be disabled with the
.B DontZoom
XF86Config(__filemansuffix__) file option.
.TP 8
.B Ctrl+Alt+Keypad-Minus
Change video mode to previous one specified in the configuration file.
This can be disabled with the
.B DontZoom
XF86Config(__filemansuffix__) file option.
.TP 8
.B Ctrl+Alt+Keypad-Multiply
Not treated specially by default.  If the
.B AllowClosedownGrabs
XF86Config(__filemansuffix__) file option is specified, this key sequence
kills clients with an active keyboard or mouse grab as well as killing any
application that may have locked the server, normally using the
XGrabServer(__libmansuffix__) Xlib function.
.TP 8
.B Ctrl+Alt+Keypad-Divide
Not treated specially by default.  If the
.B AllowDeactivateGrabs
XF86Config(__filemansuffix__) file option is specified, this key sequence
deactivates any active keyboard and mouse grabs.
.TP 8
.B Ctrl+Alt+F1...F12
For BSD and Linux systems with virtual terminal support, these keystroke
combinations are used to switch to virtual terminals 1 through 12,
respectively.  This can be disabled with the
.B DontVTSwitch
XF86Config(__filemansuffix__) file option.
.SH CONFIGURATION
.B XFree86
typically uses a configuration file called
.B XF86Config
for its initial setup.
Refer to the XF86Config(__filemansuffix__) manual page for information
about the format of this file.
.PP
Starting with version 4.4,
.B XFree86
has a mechanism for automatically generating a built-in configuration
at run-time when no
.B XF86Config
file is present.  The current version of this automatic configuration
mechanism works in three ways.
.PP
The first is via enhancements that have made many components of the
.B XF86Config
file optional.  This means that information that can be probed or
reasonably deduced doesn't need to be specified explicitly, greatly
reducing the amount of built-in configuration information that needs to
be generated at run-time.
.PP
The second is to use an external utility called getconfig(1), when
available, to use meta-configuration information to generate a suitable
configuration for the primary video device.  The meta-configuration
information can be updated to allow an existing installation to get the
best out of new hardware or to work around bugs that are found
post-release.
.PP
The third is to have "safe" fallbacks for most configuration information.
This maximises the likelihood that the
.B XFree86
server will start up in some usable configuration even when information
about the specific hardware is not available.
.PP
The automatic configuration support for XFree86 is work in progress.
It is currently aimed at the most popular hardware and software platforms
supported by XFree86.  Enhancements are planned for future releases.
.SH FILES
The
.B XFree86
server config file can be found in a range of locations.  These are
documented fully in the XF86Config(__filemansuffix__) manual page.  The
most commonly used locations are shown here.
.TP 30
.B /etc/X11/XF86Config
Server configuration file.
.TP 30
.B /etc/X11/XF86Config-4
Server configuration file.
.TP 30
.B /etc/XF86Config
Server configuration file.
.TP 30
.B __projectroot__/etc/XF86Config
Server configuration file.
.TP 30
.B __projectroot__/lib/X11/XF86Config
Server configuration file.
.TP 30
.BI __logdir__/XFree86. n .log
Server log file for display
.IR n .
.TP 30
.B __projectroot__/bin/\(**
Client binaries.
.TP 30
.B __projectroot__/include/\(**
Header files.
.TP 30
.B __projectroot__/lib/\(**
Libraries.
.TP 30
.B __projectroot__/lib/X11/fonts/\(**
Fonts.
.TP 30
.B __projectroot__/lib/X11/rgb.txt
Color names to RGB mapping.
.TP 30
.B __projectroot__/lib/X11/XErrorDB
Client error message database.
.TP 30
.B __projectroot__/lib/X11/app-defaults/\(**
Client resource specifications.
.TP 30
.B __projectroot__/man/man?/\(**
Manual pages.
.TP 30
.BI /etc/X n .hosts
Initial access control list for display
.IR n .
.SH "SEE ALSO"
X(__miscmansuffix__), Xserver(1), xdm(1), xinit(1),
XF86Config(__filemansuffix__), xf86config(1), xf86cfg(1), xvidtune(1),
apm(__drivermansuffix__),
ati(__drivermansuffix__),
chips(__drivermansuffix__),
cirrus(__drivermansuffix__),
cyrix(__drivermansuffix__),
fbdev(__drivermansuffix__),
glide(__drivermansuffix__),
glint(__drivermansuffix__),
i128(__drivermansuffix__),
i740(__drivermansuffix__),
i810(__drivermansuffix__),
imstt(__drivermansuffix__),
mga(__drivermansuffix__),
neomagic(__drivermansuffix__),
nsc(__drivermansuffix__),
nv(__drivermansuffix__),
r128(__drivermansuffix__),
rendition(__drivermansuffix__),
s3virge(__drivermansuffix__),
siliconmotion(__drivermansuffix__),
sis(__drivermansuffix__),
sunbw2(__drivermansuffix__),
suncg14(__drivermansuffix__),
suncg3(__drivermansuffix__),
suncg6(__drivermansuffix__),
sunffb(__drivermansuffix__),
sunleo(__drivermansuffix__),
suntcx(__drivermansuffix__),
tdfx(__drivermansuffix__),
tga(__drivermansuffix__),
trident(__drivermansuffix__),
tseng(__drivermansuffix__),
v4l(__drivermansuffix__),
vesa(__drivermansuffix__),
vga(__drivermansuffix__),
vmware(__drivermansuffix__),
.br
README
.IR <http://www.xfree86.org/current/README.html> ,
.br
RELNOTES
.IR <http://www.xfree86.org/current/RELNOTES.html> ,
.br
README.mouse
.IR <http://www.xfree86.org/current/mouse.html> ,
.br
README.DRI
.IR <http://www.xfree86.org/current/DRI.html> ,
.br
Install
.IR <http://www.xfree86.org/current/Install.html> .

.SH AUTHORS
XFree86 has many contributors world wide.  The names of most of them can
be found in the documentation, CHANGELOG files in the source tree, and
in the actual source code.  The names of the contributors to the current
release can be found in the release notes
.IR <http://www.xfree86.org/current/RELNOTES.html> .
.PP
XFree86 was originally based on \fIX386 1.2\fP by Thomas Roell, which
was contributed to the then X Consortium's X11R5 distribution by SGCS.
.PP
The project that became XFree86 was originally founded in 1992 by
David Dawes, Glenn Lai, Jim Tsillas and David Wexelblat.
.PP
XFree86 was later integrated in the then X Consortium's X11R6 release
by a group of dedicated XFree86 developers, including the following:
.PP
.RS 4
Stuart Anderson,
Doug Anson,
Gertjan Akkerman,
Mike Bernson,
Robin Cutshaw,
David Dawes,
Marc Evans,
Pascal Haible,
Matthieu Herrb,
Dirk Hohndel,
David Holland,
Alan Hourihane,
Jeffrey Hsu,
Glenn Lai,
Ted Lemon,
Rich Murphey,
Hans Nasten,
Mark Snitily,
Randy Terbush,
Jon Tombs,
Kees Verstoep,
Paul Vixie,
Mark Weaver,
David Wexelblat,
Philip Wheatley,
Thomas Wolfram,
Orest Zborowski.
.RE
.PP
Contributors to XFree86 4.4.0 include:
.PP
.RS 4
Roi a Torkilsheyggi,
Dave Airlie,
Andrew Aitchison,
Marco Antonio Alvarez,
Alexandr Andreev,
Jack Angel,
Eric Anholt,
Ani,
Juuso \(oAberg,
Sergey Babkin,
Alexey Baj,
Bang Jun-Young,
Uberto Barbini,
Kyle Bateman,
Matthew W. S. Bell,
Vano Beridze,
Hiroyuki Bessho,
Andrew Bevitt,
Christian Biere,
Martin Birgmeier,
Jakub Bogusz,
Le Hong Boi,
Paul Bolle,
Charl Botha,
Stanislav Brabec,
Eric Branlund,
Rob Braun,
Peter Breitenlohner,
Michael Breuer,
Kevin Brosius,
Frederick Bruckman,
Oswald Buddenhagen,
Nilg\(:un Belma Bug\(:uner,
Julian Cable,
Yukun Chen,
Ping Cheng,
Juliusz Chroboczek,
Fred Clift,
Alan Coopersmith,
Martin Costabel,
Alan Cox,
Michel D\(:anzer,
David Dawes,
Leif Delgass,
Richard Dengler,
John Dennis,
Thomas Dickey,
Randy Dunlap,
Chris Edgington,
Paul Eggert,
Paul Elliott,
Emmanuel,
Visanu Euarchukiati,
Mike Fabian,
Rik Faith,
Brian Feldman,
Wu Jian Feng,
Kevin P. Fleming,
Jose Fonseca,
Hugues Fournier,
Miguel Freitas,
Quentin Garnier,
B\(/orre Gaup,
Michael Geddes,
Frank Giessler,
Hansruedi Glauser,
Wolfram Gloger,
Alexander Gottwald,
Guido Guenther,
Ralf Habacker,
Bruno Haible,
Lindsay Haigh,
John Harper,
James Harris,
Mike A. Harris,
Bryan W. Headley,
John Heasley,
Thomas Hellstr\(:om,
Matthieu Herrb,
Jonathan Hough,
Alan Hourihane,
Joel Ray Holveck,
Harold L Hunt II,
Ricardo Y. Igarashi,
Mutsumi ISHIKAWA ,
Tsuyoshi ITO,
Kean Johnston,
Nicolas JOLY,
Phil Jones,
Roman Kagan,
Theppitak Karoonboonyanan,
Etsushi Kato,
Koike Kazuhiko,
Aidan Kehoe,
Juergen Keil,
Andreas Kies,
Thomas Klausner,
Mario Klebsch,
Egmont Koblinger,
Vlatko Kosturjak,
Kusanagi Kouichi,
Mel Kravitz,
Peter Kunzmann,
Nick Kurshev,
Mashrab Kuvatov,
Marc La France,
Radics Laszlo,
Zarick Lau,
Nolan Leake,
Michel Lespinasse,
Noah Levitt,
Dave Love,
H.J. Lu,
Lubos Lunak,
Sven Luther,
Torrey T. Lyons,
Calum Mackay,
Paul Mackerras,
Roland Mainz,
Kevin Martin,
Michal Maruska,
Kensuke Matsuzaki,
maxim,
Stephen McCamant,
Ferris McCormick,
Luke Mewburn,
Nicholas Miell,
Robert Millan,
Hisashi MIYASHITA,
Gregory Mokhin,
Patrik Montgomery,
Joe Moss,
Josselin Mouette,
Frank Murphy,
Reiko Nakajima,
Paul Nasrat,
Dan Nelson,
Bastien Nocera,
Alexandre Oliva,
Hideki ONO,
Peter Osterlund,
Sergey V. Oudaltsov,
S\('eamus \('O Ciardhu\('ain,
Bob Paauwe,
Paul Pacheco,
Tom Pala,
Ivan Pascal,
T. M. Pederson,
Earle F. Philhower III,
Nils Philippsen,
Manfred Pohler,
Alexander Pohoyda,
Alain Poirier,
Arnaud Quette,
Jim Radford,
Dale Rahn,
Lucas Correia Villa Real,
Ren\('e Rebe,
Tyler Retzlaff,
Sebastian Rittau,
Tim Roberts,
Alastair M. Robinson,
Branden Robinson,
Daniel Rock,
Ian Romanick,
Bernhard Rosenkraenzer,
M\(oans Rullg\(oard,
Andriy Rysin,
Supphachoke Santiwichaya,
Pablo Saratxaga,
Matthias Scheler,
Jens Schweikhardt,
Danilo Segan,
Shantonu Sen,
Stas Sergeev,
Jungshik Shin,
Nikola Smolenski,
Andreas Stenglein,
Paul Stewart,
Alexander Stohr,
Alan Strohm,
Will Styles,
James Su,
Mike Sulivan,
Ville Syrjala,
Slava Sysoltsev,
Akira TAGOH,
Toshimitsu Tanaka,
Akira Taniguchi,
Owen Taylor,
Neil Terry,
Jonathan Thambidurai,
John Tillman,
Adam Tlalka,
Linus Torvalds,
Christian Tosta,
Warren Turkal,
Stephen J. Turnbull,
Ted Unangst,
Mike Urban,
Simon Vallet,
Thuraiappah Vaseeharan,
Luc Verhaegen,
Yann Vernier,
Michail Vidiassov,
Sebastiano Vigna,
Mark Vojkovich,
Stephane Voltz,
Boris Weissman,
Keith Whitwell,
Thomas Winischhofer,
Eric Wittry,
Kim Woelders,
Roy Wood,
Jason L. Wright,
Joerg Wunsch,
Chisato Yamauchi,
Hui Yu.
.RE
.PP
Contributors to XFree86 4.5.0 include:
.PP
.RS 4
Szilveszter Adam,
Tim Adye,
Taneem Ahmed,
Andrew Aitchison,
Raoul Arranz,
Zaeem Arshad,
Dwayne Bailey,
Ilyas Bakirov,
Denis Barbier,
Kyle Bateman,
J. Scott Berg,
Thomas Biege,
Dmitry Bolkhovityanov,
H Merijn Brand,
Peter Breitenlohner,
Benjamin Burke,
Dale L Busacker,
busmanus,
Julian Cable,
Mike Castle,
David M. Clay,
Philip Clayton,
Alan Coopersmith,
Ricardo Cruz,
Michel D\(:anzer,
J. D. Darling,
David Dawes,
Michael Dawes,
Rafael \('Avila de Esp\('indola,
Rick De Laet,
Josip Deanovic,
Angelus Dei,
Laurent Deniel,
Thomas Dickey,
Stefan Dirsch,
Charles Dobson,
DRI Project,
Emmanuel Dreyfus,
Boris Dusek,
Georgina O. Economou,
Egbert Eich,
Bernd Ernesti,
Chris Evans,
Rik Faith,
Adrian Fiechter,
Matthew Fischer,
FreeType Team,
Terry R. Frienrichsen,
Christopher Fynn,
Hubert Gburzynski,
Nicolas George,
Frank Giessler,
Fred Gleason,
Dmitry Golubev,
Alexander Gottwald,
Herbert Graeber,
Miroslav Halas,
John Harper,
Harshula,
John Heasley,
Matthieu Herrb,
David Holl,
Alex Holland,
Peng Hongbo,
Alan Hourihane,
Harold L Hunt II,
Alan Iwi,
Timur Jamakeev,
Paul Jarc,
Kean Johnston,
Nicolas Joly,
Mark Kandianis,
Kaleb Keithley,
Chamath Keppitiyagama,
Jung-uk Kim,
Satoshi Kimura,
Michael Knudsen,
Vlatko Kosturjak,
Alexei Kosut,
Anton Kovalenko,
Joachim Kuebart,
Marc La France,
David Laight,
Zarick Lau,
Pierre Lalet,
Michael Lampe,
Lanka Linux User Group,
Nolan Leake,
Werner Lemberg,
Dejan Lesjak,
Noah Levitt,
Greg Lewis,
Bernhard R Link,
Jonas Lund,
S. Lussos,
Torrey T. Lyons,
Roland Mainz,
N Marci,
Kevin Martin,
Stephen McCamant,
Mesa Developers,
Luke Mewburn,
Petr Mladek,
Bram Moolenaar,
Steve Murphy,
Ishikawa MUTSUMI,
Radu Octavian,
Lee Olsen,
Greg Parker,
Ivan Pascal,
Alexander E. Patrakov,
Mike Pechkin,
So\('os P\('eter,
Zvezdan Petkovic,
Alexander Pohoyda,
Xie Qian,
Bill Randle,
Adam J. Richter,
Tim Roberts,
Bernhard Rosenkraenzer,
Andreas R\(:uden,
Steve Rumble,
Oleg Safiullin,
Ty Sarna,
Leo Savernik,
Barry Scott,
Shantonu Sen,
Yu Shao,
Andreas Schwab,
Matthias Scheler,
Dan Shearer,
Michael Shell,
Paul Shupak,
Alexander Stohr,
Marius Strobl,
Mikko Markus Torni,
Jess Thrysoee,
Izumi Tsutsui,
Tungsten Graphics,
Ryan Underwood,
Tristan Van Berkom,
Michael van Elst,
Phillip Vandry,
Roman Vasylyev,
Luc Verhaegen,
Rodion Vshevtsov,
Mark Vojkovich,
Edi Werner,
Keith Whitwell,
Scot Wilcoxon,
Dave Williss,
Thomas Winischhofer,
Kuang-che Wu,
X-Oz Technologies,
Chisato Yamauchi,
Michael Yaroslavtsev,
David Yerger,
Su Yong,
Hui Yu,
Sagi Zeevi,
Christian Zietz
.RE
.PP
XFree86 source is available from the FTP server
\fI<ftp://ftp.XFree86.org/pub/XFree86/>\fP, and from the XFree86 CVS
server \fI<http://www.xfree86.org/cvs/>\fP.  Documentation and other
information can be found from the XFree86 web site
\fI<http://www.xfree86.org/>\fP.

.SH LEGAL
.PP
.B XFree86
is copyright software, provided under licenses that permit modification
and redistribution in source and binary form without fee.  Portions of
.B XFree86
are copyright by The XFree86 Project, Inc. and numerous authors and
contributors from around the world.  Licensing information can be found
at
.IR <http://www.xfree86.org/current/LICENSE.html> .
Refer to the source code for specific copyright notices.
.PP
.B XFree86(R)
is a registered trademark of The XFree86 Project, Inc.
