.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided ``as is'' without express or implied warranty.
.\" 
.\" $XFree86: xc/doc/man/X11/XQBSize.man,v 1.3 2003/04/28 22:17:56 herrb Exp $
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft 1
.\".ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de FD
.LP
.KS
.TA .5i 3i
.ta .5i 3i
.nf
..
.de FN
.fi
.KE
.LP
..
.de IN		\" send an index entry to the stderr
..
.de C{
.KS
.nf
.D
.\"
.\"	choose appropriate monospace font
.\"	the imagen conditional, 480,
.\"	may be changed to L if LB is too
.\"	heavy for your eyes...
.\"
.ie "\\*(.T"480" .ft L
.el .ie "\\*(.T"300" .ft L
.el .ie "\\*(.T"202" .ft PO
.el .ie "\\*(.T"aps" .ft CW
.el .ft R
.ps \\n(PS
.ie \\n(VS>40 .vs \\n(VSu
.el .vs \\n(VSp
..
.de C}
.DE
.R
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de hN
.ie t <\fB\\$1\fR>\\$2
.el <\fI\\$1\fP>\\$2
..
.de NT
.ne 7
.ds NO Note
.if \\n(.$>$1 .if !'\\$2'C' .ds NO \\$2
.if \\n(.$ .if !'\\$1'C' .ds NO \\$1
.ie n .sp
.el .sp 10p
.TB
.ce
\\*(NO
.ie n .sp
.el .sp 5p
.if '\\$1'C' .ce 99
.if '\\$2'C' .ce 99
.in +5n
.ll -5n
.R
..
.		\" Note End -- doug kraft 3/85
.de NE
.ce 0
.in -5n
.ll +5n
.ie n .sp
.el .sp 10p
..
.ny0
.TH XQueryBestSize 3X11 __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XQueryBestSize, XQueryBestTile, XQueryBestStipple \- determine efficient sizes
.SH SYNTAX
.HP
Status XQueryBestSize\^(\^Display *\fIdisplay\fP\^, int \fIclass\fP\^,
Drawable \fIwhich_screen\fP\^, unsigned int \fIwidth\fP, unsigned int
\fIheight\fP\^, unsigned int *\fIwidth_return\fP, unsigned int
*\fIheight_return\fP\^); 
.HP
Status XQueryBestTile\^(\^Display *\fIdisplay\fP\^, Drawable
\fIwhich_screen\fP\^, unsigned int \fIwidth\fP, unsigned int \fIheight\fP\^,
unsigned int *\fIwidth_return\fP, unsigned int *\fIheight_return\fP\^);
.HP
Status XQueryBestStipple\^(\^Display *\fIdisplay\fP\^, Drawable
\fIwhich_screen\fP\^, unsigned int \fIwidth\fP, unsigned int \fIheight\fP\^,
unsigned int *\fIwidth_return\fP, unsigned int *\fIheight_return\fP\^); 
.SH ARGUMENTS
.IP \fIclass\fP 1i
Specifies the class that you are interested in.
You can pass 
.ZN TileShape , 
.ZN CursorShape , 
or 
.ZN StippleShape .
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIwidth\fP 1i
.br
.ns
.IP \fIheight\fP 1i
Specify the width and height.
.IP \fIwhich_screen\fP 1i
Specifies any drawable on the screen.
.IP \fIwidth_return\fP 1i
.br
.ns
.IP \fIheight_return\fP 1i
Return the width and height of the object best supported 
by the display hardware.
.SH DESCRIPTION
The
.ZN XQueryBestSize
function returns the best or closest size to the specified size.
For 
.ZN CursorShape ,
this is the largest size that can be fully displayed on the screen specified by
which_screen.
For 
.ZN TileShape ,
this is the size that can be tiled fastest.
For 
.ZN StippleShape ,
this is the size that can be stippled fastest.
For 
.ZN CursorShape ,
the drawable indicates the desired screen.
For 
.ZN TileShape 
and 
.ZN StippleShape ,
the drawable indicates the screen and possibly the window class and depth.
An 
.ZN InputOnly 
window cannot be used as the drawable for 
.ZN TileShape
or 
.ZN StippleShape ,
or a
.ZN BadMatch 
error results.
.LP
.ZN XQueryBestSize
can generate
.ZN BadDrawable ,
.ZN BadMatch ,
and
.ZN BadValue 
errors.
.LP
The
.ZN XQueryBestTile
function returns the best or closest size, that is, the size that can be
tiled fastest on the screen specified by which_screen.
The drawable indicates the screen and possibly the window class and depth.
If an 
.ZN InputOnly 
window is used as the drawable, a 
.ZN BadMatch 
error results.
.LP
.ZN XQueryBestTile
can generate
.ZN BadDrawable
and
.ZN BadMatch 
errors.
.LP
The
.ZN XQueryBestStipple
function returns the best or closest size, that is, the size that can be
stippled fastest on the screen specified by which_screen.
The drawable indicates the screen and possibly the window class and depth.
If an
.ZN InputOnly
window is used as the drawable, a
.ZN BadMatch
error results.
.LP
.ZN XQueryBestStipple
can generate
.ZN BadDrawable
and
.ZN BadMatch 
errors.
.SH DIAGNOSTICS
.TP 1i
.ZN BadMatch
An
.ZN InputOnly
window is used as a Drawable.
.TP 1i
.ZN BadDrawable
A value for a Drawable argument does not name a defined Window or Pixmap.
.TP 1i
.ZN BadMatch
The values do not exist for an
.ZN InputOnly
window.
.TP 1i
.ZN BadValue
Some numeric value falls outside the range of values accepted by the request.
Unless a specific range is specified for an argument, the full range defined
by the argument's type is accepted.  Any argument defined as a set of
alternatives can generate this error.
.SH "SEE ALSO"
XCreateGC(3X11),
XSetArcMode(3X11),
XSetClipOrigin(3X11),
XSetFillStyle(3X11),
XSetFont(3X11),
XSetLineAttributes(3X11),
XSetState(3X11),
XSetTile(3X11)
.br
\fI\*(xL\fP
