/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;

public class ZipOutputStream
extends DeflaterOutputStream
implements ZipConstants {
    public static final int STORED = 0;
    public static final int DEFLATED = 8;
    private ZipEntry current;
    private ZipEntry chain;
    private int method;
    private int level;
    private String comment;
    private long bytes_written;
    private int uncompressed_size;
    private Checksum sum;

    private /* synthetic */ void finit$() {
        this.method = 8;
        this.level = -1;
        this.comment = "";
    }

    public void close() throws IOException {
        this.finish();
        this.out.close();
    }

    public void closeEntry() throws IOException {
        int n;
        if (this.current.method == 0) {
            n = this.uncompressed_size;
        } else {
            super.finish();
            n = this.def.getTotalOut();
        }
        long l = this.sum.getValue();
        this.bytes_written += (long)n;
        if (this.current.getCrc() == (long)-1 || this.current.getCompressedSize() == (long)-1 || this.current.getSize() == (long)-1) {
            this.current.setCrc(l);
            this.current.compressedSize = n;
            this.current.setSize(this.uncompressed_size);
            this.put4(134695760);
            this.put4((int)this.current.getCrc());
            this.put4((int)this.current.getCompressedSize());
            this.put4((int)this.current.getSize());
            this.bytes_written += (long)16;
        } else if (this.current.getCrc() != l || this.current.getCompressedSize() != (long)n || this.current.getSize() != (long)this.uncompressed_size) {
            throw new ZipException("zip entry field incorrect");
        }
        this.current.next = this.chain;
        this.chain = this.current;
        this.current = null;
    }

    public void write(int n) throws IOException {
        if (this.current.method == 0) {
            this.out.write(n);
        } else {
            super.write(n);
        }
        this.sum.update(n);
        ++this.uncompressed_size;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.current.method == 0) {
            this.out.write(byArray, n, n2);
        } else {
            super.write(byArray, n, n2);
        }
        this.sum.update(byArray, n, n2);
        this.uncompressed_size += n2;
    }

    public void finish() throws IOException {
        if (this.current != null) {
            this.closeEntry();
        }
        long l = this.bytes_written;
        int n = 0;
        int n2 = 0;
        while (this.chain != null) {
            n2 += this.write_entry(this.chain, false);
            ++n;
            this.chain = this.chain.next;
        }
        this.put4(101010256);
        this.put2(0);
        this.put2(0);
        this.put2(n);
        this.put2(n);
        this.put4(n2);
        this.put4((int)l);
        byte[] byArray = this.comment.getBytes("8859_1");
        this.put2(byArray.length);
        this.out.write(byArray);
    }

    private int write_entry(ZipEntry zipEntry, boolean bl) throws IOException {
        int n = this.put4(bl ? 67324752 : 33639248);
        if (!bl) {
            n += this.put_version();
        }
        n += this.put_version();
        boolean bl2 = false;
        if (bl && (zipEntry.getCrc() == (long)-1 || zipEntry.getCompressedSize() == (long)-1 || zipEntry.getSize() == (long)-1)) {
            bl2 = true;
        }
        n += this.put2(bl2 ? 8 : 0);
        n += this.put2(zipEntry.method);
        n += this.put2(0);
        n += this.put2(0);
        if (bl2) {
            n += this.put4(0);
            n += this.put4(0);
            n += this.put4(0);
        } else {
            n += this.put4((int)zipEntry.getCrc());
            n += this.put4((int)zipEntry.getCompressedSize());
            n += this.put4((int)zipEntry.getSize());
        }
        byte[] byArray = zipEntry.name.getBytes("8859_1");
        n += this.put2(byArray.length);
        n += this.put2(zipEntry.extra == null ? 0 : zipEntry.extra.length);
        byte[] byArray2 = null;
        if (!bl) {
            if (zipEntry.getComment() == null) {
                n += this.put2(0);
            } else {
                byArray2 = zipEntry.getComment().getBytes("8859_1");
                n += this.put2(byArray2.length);
            }
            n += this.put2(0);
            n += this.put2(0);
            n += this.put4(0);
            n += this.put4((int)zipEntry.relativeOffset);
        }
        this.out.write(byArray);
        n += byArray.length;
        if (zipEntry.extra != null) {
            this.out.write(zipEntry.extra);
            n += zipEntry.extra.length;
        }
        if (byArray2 != null) {
            this.out.write(byArray2);
            n += byArray2.length;
        }
        this.bytes_written += (long)n;
        return n;
    }

    public void putNextEntry(ZipEntry zipEntry) throws IOException {
        if (this.current != null) {
            this.closeEntry();
        }
        if (zipEntry.method < 0) {
            zipEntry.method = this.method;
        }
        if (zipEntry.method == 0) {
            if (zipEntry.getSize() == (long)-1 || zipEntry.getCrc() == (long)-1) {
                throw new ZipException("required entry not set");
            }
            zipEntry.compressedSize = zipEntry.getSize();
        }
        zipEntry.relativeOffset = this.bytes_written;
        this.write_entry(zipEntry, true);
        this.current = zipEntry;
        int n = this.method == 0 ? 0 : this.level;
        this.def.reset();
        this.def.setLevel(n);
        this.sum.reset();
    }

    public void setLevel(int n) {
        if (n != -1 && (n < 0 || n > 9)) {
            throw new IllegalArgumentException();
        }
        this.level = n;
    }

    public void setMethod(int n) {
        if (n != 8 && n != 0) {
            throw new IllegalArgumentException();
        }
        this.method = n;
    }

    public void setComment(String string) {
        if (string.length() > 65535) {
            throw new IllegalArgumentException();
        }
        this.comment = string;
    }

    public ZipOutputStream(OutputStream outputStream) {
        super(outputStream, new Deflater(-1, true), 8192);
        this.finit$();
        this.sum = new CRC32();
    }

    private int put2(int n) throws IOException {
        this.out.write(n);
        this.out.write(n >> 8);
        return 2;
    }

    private int put4(int n) throws IOException {
        this.out.write(n);
        this.out.write(n >> 8);
        this.out.write(n >> 16);
        this.out.write(n >> 24);
        return 4;
    }

    private int put_version() throws IOException {
        return this.put2(768);
    }
}

