/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;

public class ZipInputStream
extends InflaterInputStream
implements ZipConstants {
    private ZipEntry current;
    private int current_flags;
    private int avail;
    private int compressed_bytes;
    private boolean closed;

    private /* synthetic */ void finit$() {
        this.closed = false;
    }

    public ZipInputStream(InputStream inputStream) {
        super(inputStream, new Inflater(true));
        this.finit$();
    }

    public ZipEntry getNextEntry() throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        if (this.closed) {
            throw new IOException("stream closed");
        }
        if (this.current != null) {
            this.closeEntry();
        }
        if (this.in.read() != 80 || this.in.read() != 75) {
            return null;
        }
        int n5 = this.in.read();
        while (n5 == 1) {
            n5 = this.in.read();
            if (n5 != 2) {
                return null;
            }
            this.in.skip(16);
            n4 = this.read4();
            this.in.skip(4);
            n3 = this.readu2();
            n2 = this.readu2();
            n = this.readu2();
            this.in.skip(12 + n3 + n2 + n);
            if (this.in.read() != 80 || this.in.read() != 75) {
                return null;
            }
            n5 = this.in.read();
        }
        if (n5 == 5) {
            if (this.in.read() != 6) {
                return null;
            }
            this.in.skip(16);
            n4 = this.readu2();
            this.in.skip(n4);
            if (this.in.read() != 80 || this.in.read() != 75) {
                return null;
            }
            n5 = this.in.read();
        }
        if (n5 != 3 || this.in.read() != 4) {
            return null;
        }
        n4 = this.readu2();
        this.current_flags = this.readu2();
        n3 = this.readu2();
        n2 = this.readu2();
        n = this.readu2();
        int n6 = this.read4();
        int n7 = this.read4();
        int n8 = this.read4();
        int n9 = this.readu2();
        int n10 = this.readu2();
        byte[] byArray = new byte[n9];
        this.readFully(byArray);
        ZipEntry zipEntry = this.createZipEntry(new String(byArray, "8859_1"));
        if (n10 > 0) {
            byte[] byArray2 = new byte[n10];
            this.readFully(byArray2);
            zipEntry.extra = byArray2;
        }
        zipEntry.compressedSize = n7;
        zipEntry.size = n8;
        zipEntry.crc = (long)n6 & 0xFFFFFFFFL;
        zipEntry.method = n3;
        zipEntry.time = ZipEntry.timeFromDOS(n, n2);
        this.current = zipEntry;
        this.avail = n8;
        this.compressed_bytes = n7;
        return zipEntry;
    }

    protected void fill() throws IOException {
        if (this.closed) {
            throw new IOException("stream closed");
        }
        int n = this.buf.length;
        if (n > this.compressed_bytes) {
            n = this.compressed_bytes;
        }
        this.len = this.in.read(this.buf, 0, n);
        if (this.len != -1) {
            this.compressed_bytes -= this.len;
            this.inf.setInput(this.buf, 0, this.len);
        }
    }

    protected ZipEntry createZipEntry(String string) {
        return new ZipEntry(string);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this.closed) {
            throw new IOException("stream closed");
        }
        if (n2 > this.avail) {
            n2 = this.avail;
        }
        if ((n3 = this.current.method == 8 ? super.read(byArray, n, n2) : this.in.read(byArray, n, n2)) == -1 || this.avail == 0) {
            this.inf.reset();
            n3 = -1;
        } else {
            this.avail -= n3;
        }
        return n3;
    }

    public long skip(long l) throws IOException {
        if (this.closed) {
            throw new IOException("stream closed");
        }
        if (l > (long)this.avail) {
            l = this.avail;
        }
        long l2 = this.current.method == 8 ? super.skip(l) : this.in.skip(l);
        this.avail -= (int)l2;
        return l2;
    }

    public int available() {
        if (this.closed) {
            return 0;
        }
        return 1;
    }

    private void readFully(byte[] byArray) throws IOException {
        int n;
        int n2 = 0;
        for (int i = byArray.length; i > 0; i -= n) {
            n = this.in.read(byArray, n2, i);
            if (n <= 0) {
                throw new EOFException(".zip archive ended prematurely");
            }
            n2 += n;
        }
    }

    private int readu2() throws IOException {
        int n = this.in.read();
        int n2 = this.in.read();
        if (n < 0 || n2 < 0) {
            throw new EOFException(".zip archive ended prematurely");
        }
        return (n2 & 0xFF) << 8 | n & 0xFF;
    }

    private int read4() throws IOException {
        int n = this.in.read();
        int n2 = this.in.read();
        int n3 = this.in.read();
        int n4 = this.in.read();
        if (n4 < 0) {
            throw new EOFException(".zip archive ended prematurely");
        }
        return ((n4 & 0xFF) << 24) + ((n3 & 0xFF) << 16) + ((n2 & 0xFF) << 8) + (n & 0xFF);
    }

    public void closeEntry() throws IOException {
        if (this.current != null) {
            if (this.avail > 0) {
                this.skip(this.avail);
            }
            if ((this.current_flags & 8) != 0) {
                int n = this.read4();
                if (n != 67324752) {
                    throw new ZipException("bad/missing magic number at end of .zip entry");
                }
                int n2 = this.read4();
                int n3 = this.read4();
                int n4 = this.read4();
                if (this.current.compressedSize != (long)n3 || this.current.size != (long)n4 || this.current.crc != (long)n2) {
                    throw new ZipException("bad data descriptor at end of .zip entry");
                }
            }
            this.current = null;
            this.avail = 0;
        }
    }

    public void close() throws IOException {
        this.current = null;
        this.closed = true;
        super.close();
    }
}

