/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipEnumeration;
import java.util.zip.ZipException;

public class ZipFile
implements ZipConstants {
    public static final int OPEN_READ = 1;
    public static final int OPEN_DELETE = 4;
    ZipEntry entries;
    int numEntries;
    RandomAccessFile file;
    String name;
    File delete_on_close;

    public ZipFile(String string) throws IOException {
        this(new File(string));
    }

    public ZipFile(File file) throws IOException {
        this(file, 1);
    }

    public ZipFile(File file, int n) throws IOException {
        if (n != 1 && n != 5) {
            throw new IllegalArgumentException("mode can only be OPEN_READ or OPEN_READ | OPEN_DELETE");
        }
        if ((n & 4) != 0) {
            this.delete_on_close = file;
            file.deleteOnExit();
        } else {
            this.delete_on_close = null;
        }
        this.file = new RandomAccessFile(file, "r");
        this.name = file.getName();
        this.readDirectory();
    }

    void readDirectory() throws IOException {
        long l = this.file.length();
        if (l < (long)22) {
            throw new ZipException("zipfile too short");
        }
        this.file.seek(l - (long)22);
        if (this.file.read() != 80 || this.file.read() != 75 || this.file.read() != 5 || this.file.read() != 6) {
            throw new ZipException("not a valid zipfile");
        }
        this.file.skipBytes(6);
        this.numEntries = this.readu2();
        int n = this.read4();
        this.file.seek(l - (long)(n + 22));
        ZipEntry zipEntry = null;
        for (int i = 0; i < this.numEntries; ++i) {
            byte[] byArray;
            this.file.skipBytes(10);
            int n2 = this.readu2();
            int n3 = this.readu2();
            int n4 = this.readu2();
            int n5 = this.read4();
            int n6 = this.read4();
            int n7 = this.read4();
            int n8 = this.readu2();
            int n9 = this.readu2();
            int n10 = this.readu2();
            int n11 = this.readu2();
            int n12 = this.readu2();
            int n13 = this.read4();
            int n14 = this.read4();
            byte[] byArray2 = new byte[n8];
            this.file.readFully(byArray2);
            ZipEntry zipEntry2 = new ZipEntry(new String(byArray2, "8859_1"));
            if (n9 > 0) {
                byArray = new byte[n9];
                this.file.readFully(byArray);
                zipEntry2.extra = byArray;
            }
            if (n10 > 0) {
                byArray = new byte[n10];
                this.file.readFully(byArray);
                zipEntry2.comment = new String(byArray, "8859_1");
            }
            zipEntry2.compressedSize = n6;
            zipEntry2.size = n7;
            zipEntry2.crc = (long)n5 & 0xFFFFFFFFL;
            zipEntry2.method = n2;
            zipEntry2.relativeOffset = n14;
            zipEntry2.time = ZipEntry.timeFromDOS(n4, n3);
            if (zipEntry == null) {
                this.entries = zipEntry2;
            } else {
                zipEntry.next = zipEntry2;
            }
            zipEntry = zipEntry2;
        }
    }

    public Enumeration entries() {
        return new ZipEnumeration(this);
    }

    public void close() throws IOException {
        this.file.close();
        this.entries = null;
        this.numEntries = 0;
        if (this.delete_on_close != null) {
            this.delete_on_close.delete();
        }
    }

    public ZipEntry getEntry(String string) {
        ZipEntry zipEntry = this.entries;
        while (zipEntry != null) {
            if (string.equals(zipEntry.getName())) {
                return zipEntry;
            }
            zipEntry = zipEntry.next;
        }
        return null;
    }

    public InputStream getInputStream(ZipEntry zipEntry) throws IOException {
        byte[] byArray = new byte[(int)zipEntry.getCompressedSize()];
        this.file.seek(zipEntry.relativeOffset + (long)30 - (long)2);
        int n = this.readu2();
        this.file.skipBytes(zipEntry.getName().length() + n);
        this.file.readFully(byArray);
        InputStream inputStream = new ByteArrayInputStream(byArray);
        if (zipEntry.getMethod() == 8) {
            inputStream = new InflaterInputStream(inputStream, new Inflater(true), 512);
        }
        return inputStream;
    }

    public String getName() {
        return this.name;
    }

    public int size() {
        if (this.entries == null) {
            throw new IllegalStateException("ZipFile already closed");
        }
        return this.numEntries;
    }

    protected void finalize() throws IOException {
        this.close();
    }

    private int readu2() throws IOException {
        int n = this.file.read();
        int n2 = this.file.read();
        if (n < 0 || n2 < 0) {
            throw new ZipException(".zip archive ended prematurely");
        }
        return (n2 & 0xFF) << 8 | n & 0xFF;
    }

    private int read4() throws IOException {
        int n = this.file.read();
        int n2 = this.file.read();
        int n3 = this.file.read();
        int n4 = this.file.read();
        if (n4 < 0) {
            throw new ZipException(".zip archive ended prematurely");
        }
        return ((n4 & 0xFF) << 24) + ((n3 & 0xFF) << 16) + ((n2 & 0xFF) << 8) + (n & 0xFF);
    }
}

