/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.util.zip.ZipConstants;

public class ZipEntry
implements ZipConstants,
Cloneable {
    public static final int STORED = 0;
    public static final int DEFLATED = 8;
    String comment;
    long compressedSize;
    long crc;
    byte[] extra;
    int method;
    String name;
    long size;
    long time;
    long relativeOffset;
    ZipEntry next;
    private static final short[] daysToMonthStart = new short[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};

    private /* synthetic */ void finit$() {
        this.compressedSize = -1;
        this.crc = -1;
        this.method = -1;
        this.size = -1;
        this.time = -1;
        this.relativeOffset = -1;
    }

    public ZipEntry(String string) {
        this.finit$();
        if (string.length() > 65535) {
            throw new IllegalArgumentException();
        }
        this.name = string;
    }

    public ZipEntry(ZipEntry zipEntry) {
        this.finit$();
        this.comment = zipEntry.comment;
        this.compressedSize = zipEntry.compressedSize;
        this.crc = zipEntry.crc;
        this.extra = zipEntry.extra;
        this.method = zipEntry.method;
        this.name = zipEntry.name;
        this.size = zipEntry.size;
        this.time = zipEntry.time;
        this.relativeOffset = zipEntry.relativeOffset;
    }

    public Object clone() {
        ZipEntry zipEntry = new ZipEntry(this);
        zipEntry.extra = (byte[])this.extra.clone();
        return zipEntry;
    }

    public String getComment() {
        return this.comment;
    }

    public long getCompressedSize() {
        return this.compressedSize;
    }

    public long getCrc() {
        return this.crc;
    }

    public byte[] getExtra() {
        return this.extra;
    }

    public int getMethod() {
        return this.method;
    }

    public String getName() {
        return this.name;
    }

    public long getSize() {
        return this.size;
    }

    public long getTime() {
        return this.time;
    }

    public boolean isDirectory() {
        int n;
        return this.name != null && (n = this.name.length()) > 0 && this.name.charAt(n - 1) == '/';
    }

    public void setComment(String string) {
        if (string != null && string.length() > 65535) {
            throw new IllegalArgumentException();
        }
        this.comment = string;
    }

    public void setCompressedSize(long l) {
        if (l < 0L || l > 0xFFFFFFFFL) {
            throw new IllegalArgumentException();
        }
        this.compressedSize = l;
    }

    public void setCrc(long l) {
        if (l < 0L || l > 0xFFFFFFFFL) {
            throw new IllegalArgumentException();
        }
        this.crc = l;
    }

    public void setExtra(byte[] byArray) {
        if (byArray != null && byArray.length > 65535) {
            throw new IllegalArgumentException();
        }
        this.extra = byArray;
    }

    public void setMethod(int n) {
        if (n != 8 && n != 0) {
            throw new IllegalArgumentException();
        }
        this.method = n;
    }

    public void setSize(long l) {
        if (l < 0L || l > 0xFFFFFFFFL) {
            throw new IllegalArgumentException();
        }
        this.size = l;
    }

    public void setTime(long l) {
        this.time = l;
    }

    static long timeFromDOS(int n, int n2) {
        int n3 = 2 * (n2 & 0x1F);
        int n4 = n2 >> 5 & 0x3F;
        int n5 = n2 >> 11 & 0x1F;
        int n6 = n & 0x1F;
        int n7 = (n >> 5 & 0xF) - 1;
        int n8 = (n >> 9 & 0x7F) + 10;
        if (n7 < 0 || n7 > 11) {
            return -1;
        }
        long l = ((n5 * 60 + n4) * 60 + n3) * 1000;
        int n9 = 365 * n8 + (n8 + 1 >> 2);
        n9 += daysToMonthStart[n7];
        if ((n8 & 3) == 0 && n7 > 1) {
            ++n9;
        }
        return ((long)((n9 += n6) * 24 * 60) * (long)60 + (long)((n5 * 60 + n4) * 60) + (long)n3) * (long)1000;
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

