/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.ZipException;

public class InflaterInputStream
extends FilterInputStream {
    protected byte[] buf;
    protected Inflater inf;
    protected int len;

    protected void fill() throws IOException {
        this.len = this.in.read(this.buf, 0, this.buf.length);
        if (this.len != -1) {
            this.inf.setInput(this.buf, 0, this.len);
        }
    }

    public InflaterInputStream(InputStream inputStream) {
        this(inputStream, new Inflater(), 512);
    }

    public InflaterInputStream(InputStream inputStream, Inflater inflater) {
        this(inputStream, inflater, 512);
    }

    public InflaterInputStream(InputStream inputStream, Inflater inflater, int n) {
        super(inputStream);
        this.inf = inflater;
        this.buf = new byte[n];
    }

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n = this.read(byArray, 0, 1);
        if (n != -1) {
            n = byArray[0] & 0xFF;
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this.inf == null) {
            throw new IOException("stream closed");
        }
        if (this.inf.finished()) {
            return -1;
        }
        if (this.inf.needsInput()) {
            this.fill();
        }
        try {
            n3 = this.inf.inflate(byArray, n, n2);
            if (n3 == 0) {
                if (this.len == -1) {
                    return -1;
                }
                if (this.inf.needsDictionary()) {
                    throw new ZipException("Inflater needs Dictionary");
                }
            }
        }
        catch (DataFormatException dataFormatException) {
            throw new ZipException(dataFormatException.getMessage());
        }
        return n3;
    }

    public void close() throws IOException {
        this.inf = null;
        super.close();
    }

    public int available() throws IOException {
        if (this.inf == null) {
            throw new IOException("stream closed");
        }
        if (this.inf.finished()) {
            return 0;
        }
        return 1;
    }

    public long skip(long l) throws IOException {
        int n;
        if (this.inf == null) {
            throw new IOException("stream closed");
        }
        if (l == 0L) {
            return 0L;
        }
        int n2 = (int)Math.min(l, (long)1024);
        byte[] byArray = new byte[n2];
        long l2 = 0L;
        while (l > 0L && (n = this.read(byArray, 0, n2)) != -1) {
            l2 += (long)n;
            n2 = (int)Math.min(l -= (long)n, (long)1024);
        }
        return l2;
    }
}

