/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipException;

public class GZIPInputStream
extends InflaterInputStream {
    public static final int GZIP_MAGIC = 35615;
    protected CRC32 crc;
    protected boolean eos;
    static final int Z_DEFLATED = 8;
    static final int HEAD_CRC = 2;
    static final int EXTRA_FIELD = 4;
    static final int ORIG_NAME = 8;
    static final int COMMENT = 16;
    static final int RESERVED = 224;

    public void close() throws IOException {
        super.close();
    }

    public GZIPInputStream(InputStream inputStream) throws IOException {
        this(inputStream, 512);
    }

    private final int eof_read() throws IOException {
        int n = this.in.read();
        if (n == -1) {
            throw new ZipException("gzip header corrupted");
        }
        return n & 0xFF;
    }

    public GZIPInputStream(InputStream inputStream, int n) throws IOException {
        super(inputStream, new Inflater(true), n);
        int n2;
        int n3 = this.eof_read() | this.eof_read() << 8;
        if (n3 != 35615) {
            throw new ZipException("gzip header corrupted");
        }
        int n4 = this.eof_read();
        int n5 = this.eof_read();
        if (n4 != 8 || (n5 & 0xE0) != 0) {
            throw new ZipException("gzip header corrupted");
        }
        for (n2 = 0; n2 < 6; ++n2) {
            this.eof_read();
        }
        if ((n5 & 4) != 0) {
            n2 = this.eof_read() | this.eof_read() << 8;
            while (n2-- != 0) {
                this.eof_read();
            }
        }
        if ((n5 & 8) != 0) {
            while ((n2 = this.eof_read()) != 0) {
            }
        }
        if ((n5 & 0x10) != 0) {
            while ((n2 = this.eof_read()) != 0) {
            }
        }
        if ((n5 & 2) != 0) {
            this.eof_read();
            this.eof_read();
        }
        this.crc = new CRC32();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.eos) {
            return -1;
        }
        int n3 = super.read(byArray, n, n2);
        if (n3 == -1) {
            this.eos = true;
            int n4 = this.read4();
            if (this.crc.getValue() != (long)n4) {
                throw new ZipException("corrupted gzip file");
            }
            this.read4();
            return -1;
        }
        this.crc.update(byArray, n, n3);
        return n3;
    }

    private final int read4() throws IOException {
        int n = this.in.read();
        int n2 = this.in.read();
        int n3 = this.in.read();
        int n4 = this.in.read();
        if (n4 < 0) {
            throw new ZipException(".zip archive ended prematurely");
        }
        return ((n4 & 0xFF) << 24) + ((n3 & 0xFF) << 16) + ((n2 & 0xFF) << 8) + (n & 0xFF);
    }
}

