/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.util.zip.Checksum;

public class CRC32
implements Checksum {
    private int crc;
    private static int[] crc_table = CRC32.make_crc_table();

    private /* synthetic */ void finit$() {
        this.crc = 0;
    }

    private static int[] make_crc_table() {
        int[] nArray = new int[256];
        for (int i = 0; i < 256; ++i) {
            int n = i;
            int n2 = 8;
            while (--n2 >= 0) {
                if ((n & 1) != 0) {
                    n = 0xEDB88320 ^ n >>> 1;
                    continue;
                }
                n >>>= 1;
            }
            nArray[i] = n;
        }
        return nArray;
    }

    public long getValue() {
        return (long)this.crc & 0xFFFFFFFFL;
    }

    public void reset() {
        this.crc = 0;
    }

    public void update(int n) {
        int n2 = ~this.crc;
        n2 = crc_table[(n2 ^ n) & 0xFF] ^ n2 >>> 8;
        this.crc = ~n2;
    }

    public void update(byte[] byArray, int n, int n2) {
        int n3 = ~this.crc;
        while (--n2 >= 0) {
            n3 = crc_table[(n3 ^ byArray[n++]) & 0xFF] ^ n3 >>> 8;
        }
        this.crc = ~n3;
    }

    public void update(byte[] byArray) {
        this.update(byArray, 0, byArray.length);
    }

    public CRC32() {
        this.finit$();
    }
}

