/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.util.zip.Checksum;

public class Adler32
implements Checksum {
    private static int BASE = 65521;
    private int s1;
    private int s2;

    public Adler32() {
        this.reset();
    }

    public void reset() {
        this.s1 = 1;
        this.s2 = 0;
    }

    public void update(int n) {
        this.s1 = (this.s1 + (n & 0xFF)) % BASE;
        this.s2 = (this.s1 + this.s2) % BASE;
    }

    public void update(byte[] byArray) {
        this.update(byArray, 0, byArray.length);
    }

    public void update(byte[] byArray, int n, int n2) {
        int n3 = this.s1;
        int n4 = this.s2;
        while (n2 > 0) {
            int n5 = 4000;
            if (n5 > n2) {
                n5 = n2;
            }
            n2 -= n5;
            while (--n5 >= 0) {
                n4 += (n3 += byArray[n++] & 0xFF);
            }
            n3 %= BASE;
            n4 %= BASE;
        }
        this.s1 = n3;
        this.s2 = n4;
    }

    public long getValue() {
        return ((long)this.s2 << 16) + (long)this.s1;
    }
}

