/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarException;

public class Manifest
implements Cloneable {
    private final Attributes mainAttr;
    private final Map entries;

    public Manifest() {
        this.mainAttr = new Attributes();
        this.entries = new Hashtable();
    }

    public Manifest(InputStream inputStream) throws IOException {
        this();
        this.read(inputStream);
    }

    public Manifest(Manifest manifest) {
        this.mainAttr = new Attributes(manifest.getMainAttributes());
        this.entries = new Hashtable(manifest.getEntries());
    }

    public Attributes getMainAttributes() {
        return this.mainAttr;
    }

    public Map getEntries() {
        return this.entries;
    }

    public Attributes getAttributes(String string) {
        return (Attributes)this.getEntries().get(string);
    }

    public void clear() {
        this.mainAttr.clear();
        this.entries.clear();
    }

    public void read(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "8859_1"));
        Manifest.read_main_section(this.getMainAttributes(), bufferedReader);
        Manifest.read_individual_sections(this.getEntries(), bufferedReader);
    }

    private static void read_main_section(Attributes attributes, BufferedReader bufferedReader) throws IOException {
        Manifest.read_version_info(attributes, bufferedReader);
        Manifest.read_attributes(attributes, bufferedReader);
    }

    private static void read_version_info(Attributes attributes, BufferedReader bufferedReader) throws IOException {
        String string = Attributes.Name.MANIFEST_VERSION.toString();
        try {
            String string2 = Manifest.expect_header(string, bufferedReader);
            attributes.putValue(string, string2);
        }
        catch (IOException iOException) {
            throw new JarException("Manifest should start with a " + string + ": " + iOException.getMessage());
        }
    }

    private static String expect_header(String string, BufferedReader bufferedReader) throws IOException {
        String string2 = bufferedReader.readLine();
        if (string2 == null) {
            throw new JarException("unexpected end of file");
        }
        return Manifest.expect_header(string, bufferedReader, string2);
    }

    private static String expect_header(String string, BufferedReader bufferedReader, String string2) throws IOException {
        try {
            String string3 = string2.substring(0, string.length() + 1);
            if (string3.equalsIgnoreCase(string + ":")) {
                String string4 = string2.substring(string.length() + 2);
                return Manifest.read_header_value(string4, bufferedReader);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        throw new JarException("unexpected '" + string2 + "'");
    }

    private static String read_header_value(String string, BufferedReader bufferedReader) throws IOException {
        boolean bl = true;
        while (bl) {
            bufferedReader.mark(1);
            if (bufferedReader.read() == 32) {
                string = string + bufferedReader.readLine();
                continue;
            }
            bufferedReader.reset();
            bl = false;
        }
        return string;
    }

    private static void read_attributes(Attributes attributes, BufferedReader bufferedReader) throws IOException {
        String string = bufferedReader.readLine();
        while (string != null && !string.equals("")) {
            Manifest.read_attribute(attributes, string, bufferedReader);
            string = bufferedReader.readLine();
        }
    }

    private static void read_attribute(Attributes attributes, String string, BufferedReader bufferedReader) throws IOException {
        try {
            int n = string.indexOf(": ");
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 2);
            String string4 = Manifest.read_header_value(string3, bufferedReader);
            attributes.putValue(string2, string4);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new JarException("Manifest contains a bad header: " + string);
        }
    }

    private static void read_individual_sections(Map map, BufferedReader bufferedReader) throws IOException {
        String string = bufferedReader.readLine();
        while (string != null && !string.equals("")) {
            Attributes attributes = Manifest.read_section_name(string, bufferedReader, map);
            Manifest.read_attributes(attributes, bufferedReader);
            string = bufferedReader.readLine();
        }
    }

    private static Attributes read_section_name(String string, BufferedReader bufferedReader, Map map) throws JarException {
        try {
            String string2 = Manifest.expect_header("Name", bufferedReader, string);
            Attributes attributes = new Attributes();
            map.put(string2, attributes);
            return attributes;
        }
        catch (IOException iOException) {
            throw new JarException("Section should start with a Name header: " + iOException.getMessage());
        }
    }

    public void write(OutputStream outputStream) throws IOException {
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputStream, "8859_1")));
        Manifest.write_main_section(this.getMainAttributes(), printWriter);
        printWriter.println();
        Manifest.write_individual_sections(this.getEntries(), printWriter);
        if (printWriter.checkError()) {
            throw new JarException("Error while writing manifest");
        }
    }

    private static void write_main_section(Attributes attributes, PrintWriter printWriter) throws JarException {
        Manifest.write_version_info(attributes, printWriter);
        Manifest.write_main_attributes(attributes, printWriter);
    }

    private static void write_version_info(Attributes attributes, PrintWriter printWriter) {
        String string = attributes.getValue(Attributes.Name.MANIFEST_VERSION);
        if (string == null) {
            string = "1.0";
        }
        Manifest.write_header(Attributes.Name.MANIFEST_VERSION.toString(), string, printWriter);
    }

    private static void write_header(String string, String string2, PrintWriter printWriter) {
        printWriter.print(string + ": ");
        int n = 68 - string.length();
        if (n > string2.length()) {
            printWriter.println(string2);
        } else {
            printWriter.println(string2.substring(0, n));
        }
        while (n < string2.length()) {
            printWriter.print(" ");
            int n2 = n + 69;
            if (n2 > string2.length()) {
                printWriter.println(string2.substring(n));
            } else {
                printWriter.println(string2.substring(n, n2));
            }
            n = n2;
        }
    }

    private static void write_main_attributes(Attributes attributes, PrintWriter printWriter) throws JarException {
        Iterator iterator = attributes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (Attributes.Name.MANIFEST_VERSION.equals(entry.getKey())) continue;
            Manifest.write_attribute_entry(entry, printWriter);
        }
    }

    private static void write_attribute_entry(Map.Entry entry, PrintWriter printWriter) throws JarException {
        String string = entry.getKey().toString();
        String string2 = entry.getValue().toString();
        if (string.equalsIgnoreCase("Name")) {
            throw new JarException("Attributes cannot be called 'Name'");
        }
        if (string.startsWith("From")) {
            throw new JarException("Header cannot start with the four letters 'From'" + string);
        }
        Manifest.write_header(string, string2, printWriter);
    }

    private static void write_individual_sections(Map map, PrintWriter printWriter) throws JarException {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Manifest.write_header("Name", entry.getKey().toString(), printWriter);
            Manifest.write_entry_attributes((Attributes)entry.getValue(), printWriter);
            printWriter.println();
        }
    }

    private static void write_entry_attributes(Attributes attributes, PrintWriter printWriter) throws JarException {
        Iterator iterator = attributes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Manifest.write_attribute_entry(entry, printWriter);
        }
    }

    public Object clone() {
        return new Manifest(this);
    }

    public boolean equals(Object object) {
        return object instanceof Manifest && this.mainAttr.equals(((Manifest)object).mainAttr) && this.entries.equals(((Manifest)object).entries);
    }

    public int hashCode() {
        return this.mainAttr.hashCode() ^ this.entries.hashCode();
    }
}

