/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class JarFile
extends ZipFile {
    public static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    private final Manifest manifest = this.readManifest();
    private boolean verify;

    public JarFile(String string) throws IOException, FileNotFoundException {
        this(string, true);
    }

    public JarFile(String string, boolean bl) throws IOException, FileNotFoundException {
        super(string);
        if (bl) {
            this.verify();
        }
    }

    public JarFile(File file) throws IOException, FileNotFoundException {
        this(file, true);
    }

    public JarFile(File file, boolean bl) throws IOException, FileNotFoundException {
        super(file);
        if (bl) {
            this.verify();
        }
    }

    public JarFile(File file, boolean bl, int n) throws IOException, FileNotFoundException {
        super(file, n);
        if (bl) {
            this.verify();
        }
    }

    private void verify() {
        if (this.manifest == null) {
            this.verify = false;
            return;
        }
        this.verify = true;
    }

    private Manifest readManifest() {
        try {
            ZipEntry zipEntry = super.getEntry(MANIFEST_NAME);
            if (zipEntry != null) {
                InputStream inputStream = super.getInputStream(zipEntry);
                return new Manifest(inputStream);
            }
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public Enumeration entries() {
        return new JarEnumeration(this, super.entries());
    }

    public ZipEntry getEntry(String string) {
        ZipEntry zipEntry = super.getEntry(string);
        if (zipEntry != null) {
            JarEntry jarEntry = new JarEntry(zipEntry);
            if (this.manifest != null) {
                jarEntry.attr = this.manifest.getAttributes(string);
            }
            return jarEntry;
        }
        return null;
    }

    public synchronized InputStream getInputStream(ZipEntry zipEntry) throws IOException, ZipException {
        return super.getInputStream(zipEntry);
    }

    public JarEntry getJarEntry(String string) {
        return (JarEntry)this.getEntry(string);
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    class JarEnumeration
    implements Enumeration {
        private /* synthetic */ JarFile this$0;
        private final Enumeration entries;

        JarEnumeration(JarFile jarFile, Enumeration enumeration) {
            this.this$0 = jarFile;
            this.entries = enumeration;
        }

        public boolean hasMoreElements() {
            return this.entries.hasMoreElements();
        }

        public Object nextElement() {
            ZipEntry zipEntry = (ZipEntry)this.entries.nextElement();
            JarEntry jarEntry = new JarEntry(zipEntry);
            if (this.this$0.manifest != null) {
                jarEntry.attr = this.this$0.manifest.getAttributes(jarEntry.getName());
            }
            return jarEntry;
        }
    }
}

