/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class WeakHashMap
extends AbstractMap
implements Map {
    private static final int DEFAULT_CAPACITY = 11;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final Object NULL_KEY = new Object();
    private ReferenceQueue queue;
    private int size;
    private float loadFactor;
    private int threshold;
    private int modCount;
    private WeakEntrySet theEntrySet;
    private WeakBucket[] buckets;

    static /* synthetic */ int access$6(WeakHashMap weakHashMap, int n) {
        weakHashMap.size = n;
        return weakHashMap.size;
    }

    static /* synthetic */ WeakBucket[] access$2(WeakHashMap weakHashMap, WeakBucket[] weakBucketArray) {
        weakHashMap.buckets = weakBucketArray;
        return weakBucketArray;
    }

    public WeakHashMap() {
        this(11, 0.75f);
    }

    public WeakHashMap(int n) {
        this(n, 0.75f);
    }

    public WeakHashMap(int n, float f) {
        if (n < 0 || f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = f;
        this.threshold = (int)((float)n * f);
        this.theEntrySet = new WeakEntrySet(this);
        this.queue = new ReferenceQueue();
        this.buckets = new WeakBucket[n];
    }

    private int hash(Object object) {
        return Math.abs(object.hashCode() % this.buckets.length);
    }

    private void cleanQueue() {
        Reference reference = this.queue.poll();
        while (reference != null) {
            this.internalRemove((WeakBucket)reference);
            reference = this.queue.poll();
        }
    }

    private void rehash() {
        WeakBucket[] weakBucketArray = this.buckets;
        int n = this.buckets.length * 2 + 1;
        this.threshold = (int)((float)n * this.loadFactor);
        this.buckets = new WeakBucket[n];
        for (int i = 0; i < weakBucketArray.length; ++i) {
            WeakBucket weakBucket = weakBucketArray[i];
            while (weakBucket != null) {
                WeakBucket weakBucket2 = weakBucket.next;
                Object object = weakBucket.get();
                if (object == null) {
                    weakBucket.slot = -1;
                    this.size += -1;
                } else {
                    int n2;
                    weakBucket.slot = n2 = this.hash(object);
                    weakBucket.next = this.buckets[n2];
                    this.buckets[n2] = weakBucket;
                }
                weakBucket = weakBucket2;
            }
        }
    }

    private WeakBucket.Entry internalGet(Object object) {
        if (object == null) {
            object = NULL_KEY;
        }
        int n = this.hash(object);
        WeakBucket weakBucket = this.buckets[n];
        while (weakBucket != null) {
            WeakBucket.Entry entry = weakBucket.getEntry();
            if (entry != null && object.equals(entry.key)) {
                return entry;
            }
            weakBucket = weakBucket.next;
        }
        return null;
    }

    private void internalAdd(Object object, Object object2) {
        if (object == null) {
            object = NULL_KEY;
        }
        int n = this.hash(object);
        WeakBucket weakBucket = new WeakBucket(object, this.queue, object2, n);
        weakBucket.next = this.buckets[n];
        this.buckets[n] = weakBucket;
        ++this.size;
    }

    private void internalRemove(WeakBucket weakBucket) {
        int n = weakBucket.slot;
        if (n == -1) {
            return;
        }
        weakBucket.slot = -1;
        if (this.buckets[n] == weakBucket) {
            this.buckets[n] = weakBucket.next;
        } else {
            WeakBucket weakBucket2 = this.buckets[n];
            while (weakBucket2.next != weakBucket) {
                weakBucket2 = weakBucket2.next;
            }
            weakBucket2.next = weakBucket.next;
        }
        this.size += -1;
    }

    public int size() {
        this.cleanQueue();
        return this.size;
    }

    public boolean isEmpty() {
        this.cleanQueue();
        return this.size == 0;
    }

    public boolean containsKey(Object object) {
        this.cleanQueue();
        return this.internalGet(object) != null;
    }

    public Object get(Object object) {
        this.cleanQueue();
        WeakBucket.Entry entry = this.internalGet(object);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    public Object put(Object object, Object object2) {
        this.cleanQueue();
        WeakBucket.Entry entry = this.internalGet(object);
        if (entry != null) {
            return entry.setValue(object2);
        }
        if (this.size >= this.threshold) {
            this.rehash();
        }
        this.internalAdd(object, object2);
        ++this.modCount;
        return null;
    }

    public Object remove(Object object) {
        this.cleanQueue();
        WeakBucket.Entry entry = this.internalGet(object);
        if (entry == null) {
            return null;
        }
        this.internalRemove(entry.getBucket());
        ++this.modCount;
        return entry.getValue();
    }

    public Set entrySet() {
        this.cleanQueue();
        return this.theEntrySet;
    }

    static class WeakBucket
    extends WeakReference {
        Object value;
        WeakBucket next;
        int slot;

        public WeakBucket(Object object, ReferenceQueue referenceQueue, Object object2, int n) {
            super(object, referenceQueue);
            this.value = object2;
            this.slot = n;
        }

        Entry getEntry() {
            Object object = this.get();
            if (object == null) {
                return null;
            }
            return new Entry(this, object);
        }

        class Entry
        implements Map.Entry {
            private /* synthetic */ WeakBucket this$1;
            Object key;

            public Entry(WeakBucket weakBucket, Object object) {
                this.this$1 = weakBucket;
                this.key = object;
            }

            public WeakBucket getBucket() {
                return this.this$1;
            }

            public Object getKey() {
                if (this.key == NULL_KEY) {
                    return null;
                }
                return this.key;
            }

            public Object getValue() {
                return this.this$1.value;
            }

            public Object setValue(Object object) {
                Object object2 = this.this$1.value;
                this.this$1.value = object;
                return object2;
            }

            public int hashCode() {
                return (this.key == NULL_KEY ? 0 : this.key.hashCode()) ^ (this.this$1.value == null ? 0 : this.this$1.value.hashCode());
            }

            public boolean equals(Object object) {
                if (object instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)object;
                    return (this.key == NULL_KEY ? entry.getKey() == null : this.key.equals(entry.getKey())) && (this.this$1.value == null ? entry.getValue() == null : this.this$1.value.equals(entry.getValue()));
                }
                return false;
            }
        }
    }

    class WeakEntrySet
    extends AbstractSet {
        private /* synthetic */ WeakHashMap this$0;

        static /* synthetic */ WeakHashMap access$3(WeakEntrySet weakEntrySet, WeakHashMap weakHashMap) {
            weakEntrySet.this$0 = weakHashMap;
            return weakEntrySet.this$0;
        }

        static WeakHashMap access$0(WeakEntrySet weakEntrySet) {
            return weakEntrySet.this$0;
        }

        public int size() {
            return this.this$0.size;
        }

        public Iterator iterator() {
            return new Iterator(this){
                private /* synthetic */ WeakEntrySet this$1;
                WeakBucket.Entry lastEntry;
                WeakBucket.Entry nextEntry;
                int knownMod;
                {
                    this.this$1 = weakEntrySet;
                    this.finit$();
                }

                private /* synthetic */ void finit$() {
                    this.nextEntry = this.findNext(null);
                    this.knownMod = WeakEntrySet.access$0(this.this$1).modCount;
                }

                private void checkMod() {
                    if (this.knownMod != WeakEntrySet.access$0(this.this$1).modCount) {
                        throw new ConcurrentModificationException();
                    }
                }

                private WeakBucket.Entry findNext(WeakBucket.Entry entry) {
                    int n;
                    WeakBucket weakBucket;
                    if (entry != null) {
                        weakBucket = entry.getBucket().next;
                        n = entry.getBucket().slot;
                    } else {
                        weakBucket = WeakEntrySet.access$0(this.this$1).buckets[0];
                        n = 0;
                    }
                    while (true) {
                        if (weakBucket != null) {
                            WeakBucket.Entry entry2 = weakBucket.getEntry();
                            if (entry2 != null) {
                                return entry2;
                            }
                            weakBucket = weakBucket.next;
                            continue;
                        }
                        if (++n == WeakEntrySet.access$0(this.this$1).buckets.length) {
                            return null;
                        }
                        weakBucket = WeakEntrySet.access$0(this.this$1).buckets[n];
                    }
                }

                public boolean hasNext() {
                    this.this$1.this$0.cleanQueue();
                    this.checkMod();
                    return this.nextEntry != null;
                }

                public Object next() {
                    this.this$1.this$0.cleanQueue();
                    this.checkMod();
                    if (this.nextEntry == null) {
                        throw new NoSuchElementException();
                    }
                    this.lastEntry = this.nextEntry;
                    this.nextEntry = this.findNext(this.lastEntry);
                    return this.lastEntry;
                }

                public void remove() {
                    this.this$1.this$0.cleanQueue();
                    this.checkMod();
                    if (this.lastEntry == null) {
                        throw new IllegalStateException();
                    }
                    this.this$1.this$0.internalRemove(this.lastEntry.getBucket());
                    this.lastEntry = null;
                    WeakEntrySet.access$0(this.this$1).modCount = WeakEntrySet.access$0(this.this$1).modCount + 1;
                    this.knownMod = WeakEntrySet.access$0(this.this$1).modCount;
                }
            };
        }

        WeakEntrySet(WeakHashMap weakHashMap) {
            this.this$0 = weakHashMap;
        }
    }
}

