/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class Vector
extends AbstractList
implements List,
Cloneable,
Serializable {
    protected int capacityIncrement;
    protected int elementCount;
    protected Object[] elementData;
    private static final long serialVersionUID = -2767605614048989439L;

    private /* synthetic */ void finit$() {
        this.capacityIncrement = 0;
        this.elementCount = 0;
    }

    public Vector() {
        this(10);
    }

    public Vector(Collection collection) {
        this.finit$();
        int n = collection.size();
        this.elementData = new Object[n];
        this.elementCount = n;
        Iterator iterator = collection.iterator();
        for (int i = 0; i < n; ++i) {
            this.elementData[i] = iterator.next();
        }
    }

    public Vector(int n, int n2) {
        this.finit$();
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.elementData = new Object[n];
        this.capacityIncrement = n2;
    }

    public Vector(int n) {
        this.finit$();
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.elementData = new Object[n];
    }

    public synchronized void copyInto(Object[] objectArray) {
        System.arraycopy(this.elementData, 0, objectArray, 0, this.elementCount);
    }

    public synchronized void trimToSize() {
        Object[] objectArray = new Object[this.elementCount];
        System.arraycopy(this.elementData, 0, objectArray, 0, this.elementCount);
        this.elementData = objectArray;
    }

    public synchronized void ensureCapacity(int n) {
        if (this.elementData.length >= n) {
            return;
        }
        int n2 = this.capacityIncrement <= 0 ? this.elementData.length * 2 : this.elementData.length + this.capacityIncrement;
        Object[] objectArray = new Object[Math.max(n2, n)];
        System.arraycopy(this.elementData, 0, objectArray, 0, this.elementData.length);
        this.elementData = objectArray;
    }

    public synchronized void setSize(int n) {
        ++this.modCount;
        Object[] objectArray = new Object[n];
        System.arraycopy(this.elementData, 0, objectArray, 0, Math.min(n, this.elementCount));
        this.elementCount = n;
        this.elementData = objectArray;
    }

    public int capacity() {
        return this.elementData.length;
    }

    public int size() {
        return this.elementCount;
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public synchronized int indexOf(Object object, int n) {
        for (int i = n; i < this.elementCount; ++i) {
            if (!(object == null ? this.elementData[i] == null : object.equals(this.elementData[i]))) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(Object object) {
        return this.indexOf(object, 0);
    }

    public boolean contains(Object object) {
        return this.indexOf(object, 0) != -1;
    }

    public synchronized int lastIndexOf(Object object, int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        for (int i = n; i >= 0; --i) {
            if (!(object == null ? this.elementData[i] == null : object.equals(this.elementData[i]))) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(Object object) {
        return this.lastIndexOf(object, this.elementCount - 1);
    }

    public synchronized Object elementAt(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        return this.elementData[n];
    }

    public synchronized Object firstElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementAt(0);
    }

    public synchronized Object lastElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementAt(this.elementCount - 1);
    }

    public synchronized void setElementAt(Object object, int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        this.elementData[n] = object;
    }

    public synchronized Object set(int n, Object object) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        Object object2 = this.elementData[n];
        this.elementData[n] = object;
        return object2;
    }

    public synchronized void removeElementAt(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        ++this.modCount;
        this.elementCount += -1;
        if (n < this.elementCount) {
            System.arraycopy(this.elementData, n + 1, this.elementData, n, this.elementCount - n);
        }
        this.elementData[this.elementCount] = null;
    }

    public void insertElementAt(Object object, int n) {
        if (n > this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " > " + this.elementCount);
        }
        if (this.elementCount == this.elementData.length) {
            this.ensureCapacity(this.elementCount + 1);
        }
        ++this.modCount;
        ++this.elementCount;
        System.arraycopy(this.elementData, n, this.elementData, n + 1, this.elementCount - 1 - n);
        this.elementData[n] = object;
    }

    public synchronized void addElement(Object object) {
        if (this.elementCount == this.elementData.length) {
            this.ensureCapacity(this.elementCount + 1);
        }
        ++this.modCount;
        this.elementData[this.elementCount++] = object;
    }

    public synchronized boolean removeElement(Object object) {
        int n = this.indexOf(object);
        if (n != -1) {
            this.removeElementAt(n);
            return true;
        }
        return false;
    }

    public synchronized void removeAllElements() {
        ++this.modCount;
        if (this.elementCount == 0) {
            return;
        }
        for (int i = this.elementCount - 1; i >= 0; --i) {
            this.elementData[i] = null;
        }
        this.elementCount = 0;
    }

    public synchronized Object clone() {
        try {
            Vector vector = (Vector)super.clone();
            vector.elementData = (Object[])this.elementData.clone();
            return vector;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public synchronized Object[] toArray() {
        Object[] objectArray = new Object[this.elementCount];
        this.copyInto(objectArray);
        return objectArray;
    }

    public synchronized Object[] toArray(Object[] objectArray) {
        if (objectArray.length < this.elementCount) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.elementCount);
        } else if (objectArray.length > this.elementCount) {
            objectArray[this.elementCount] = null;
        }
        System.arraycopy(this.elementData, 0, objectArray, 0, this.elementCount);
        return objectArray;
    }

    public synchronized Object get(int n) {
        return this.elementAt(n);
    }

    public boolean remove(Object object) {
        return this.removeElement(object);
    }

    public synchronized boolean add(Object object) {
        this.addElement(object);
        return true;
    }

    public void add(int n, Object object) {
        this.insertElementAt(object, n);
    }

    public synchronized Object remove(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        Object object = this.elementData[n];
        this.removeElementAt(n);
        return object;
    }

    public void clear() {
        this.removeAllElements();
    }

    public synchronized boolean containsAll(Collection collection) {
        Iterator iterator = collection.iterator();
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public synchronized boolean addAll(Collection collection) {
        return this.addAll(this.elementCount, collection);
    }

    public synchronized boolean removeAll(Collection collection) {
        return super.removeAll(collection);
    }

    public synchronized boolean retainAll(Collection collection) {
        return super.retainAll(collection);
    }

    public synchronized boolean addAll(int n, Collection collection) {
        if (n < 0 || n > this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        ++this.modCount;
        Iterator iterator = collection.iterator();
        int n2 = collection.size();
        this.ensureCapacity(this.elementCount + n2);
        int n3 = n + n2;
        if (this.elementCount > 0 && n != this.elementCount) {
            System.arraycopy(this.elementData, n, this.elementData, n3, n2);
        }
        this.elementCount += n2;
        while (n < n3) {
            this.elementData[n] = iterator.next();
            ++n;
        }
        return n2 > 0;
    }

    public synchronized boolean equals(Object object) {
        return super.equals(object);
    }

    public synchronized int hashCode() {
        return super.hashCode();
    }

    public synchronized String toString() {
        String string = "[";
        for (int i = 0; i < this.elementCount; ++i) {
            string = string + this.elementData[i];
            if (i >= this.elementCount - 1) continue;
            string = string + ", ";
        }
        string = string + "]";
        return string;
    }

    public synchronized Enumeration elements() {
        return new Enumeration(this){
            private /* synthetic */ Vector this$0;
            int i;
            {
                this.this$0 = vector;
                this.finit$();
            }

            private /* synthetic */ void finit$() {
                this.i = 0;
            }

            public boolean hasMoreElements() {
                return this.i < this.this$0.elementCount;
            }

            public Object nextElement() {
                if (this.i >= this.this$0.elementCount) {
                    throw new NoSuchElementException();
                }
                return this.this$0.elementAt(this.i++);
            }
        };
    }

    public List subList(int n, int n2) {
        List list = super.subList(n, n2);
        return Collections.synchronizedList(list);
    }

    protected synchronized void removeRange(int n, int n2) {
        ++this.modCount;
        if (n != n2) {
            System.arraycopy(this.elementData, n2, this.elementData, n, this.elementCount - n2);
            int n3 = this.elementCount;
            this.elementCount -= n2 - n;
            for (int i = this.elementCount; i < n3; ++i) {
                this.elementData[i] = null;
            }
        }
    }
}

