/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;

public class TreeSet
extends AbstractSet
implements SortedSet,
Cloneable,
Serializable {
    transient SortedMap map;
    static final long serialVersionUID = -2479143000061671589L;

    public TreeSet() {
        this.map = new TreeMap();
    }

    public TreeSet(Comparator comparator) {
        this.map = new TreeMap(comparator);
    }

    public TreeSet(Collection collection) {
        this.map = new TreeMap();
        this.addAll(collection);
    }

    public TreeSet(SortedSet sortedSet) {
        TreeMap treeMap = new TreeMap(sortedSet.comparator());
        boolean bl = false;
        Iterator iterator = sortedSet.iterator();
        treeMap.putKeysLinear(iterator, sortedSet.size());
        this.map = treeMap;
    }

    TreeSet(SortedMap sortedMap) {
        this.map = sortedMap;
    }

    public boolean add(Object object) {
        return this.map.put(object, Boolean.TRUE) == null;
    }

    public boolean addAll(Collection collection) {
        boolean bl = false;
        int n = collection.size();
        Iterator iterator = collection.iterator();
        for (int i = 0; i < n; ++i) {
            bl |= this.map.put(iterator.next(), Boolean.TRUE) == null;
        }
        return bl;
    }

    public void clear() {
        this.map.clear();
    }

    public Object clone() {
        TreeSet treeSet = null;
        try {
            treeSet = (TreeSet)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        treeSet.map = (SortedMap)((TreeMap)this.map).clone();
        return treeSet;
    }

    public Comparator comparator() {
        return this.map.comparator();
    }

    public boolean contains(Object object) {
        return this.map.containsKey(object);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public int size() {
        return this.map.size();
    }

    public boolean remove(Object object) {
        return this.map.remove(object) != null;
    }

    public Object first() {
        return this.map.firstKey();
    }

    public Object last() {
        return this.map.lastKey();
    }

    public SortedSet subSet(Object object, Object object2) {
        return new TreeSet(this.map.subMap(object, object2));
    }

    public SortedSet headSet(Object object) {
        return new TreeSet(this.map.headMap(object));
    }

    public SortedSet tailSet(Object object) {
        return new TreeSet(this.map.tailMap(object));
    }

    public Iterator iterator() {
        return this.map.keySet().iterator();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Iterator iterator = this.map.keySet().iterator();
        int n = this.map.size();
        objectOutputStream.writeObject(this.map.comparator());
        objectOutputStream.writeInt(n);
        for (int i = 0; i < n; ++i) {
            objectOutputStream.writeObject(iterator.next());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        Comparator comparator = (Comparator)objectInputStream.readObject();
        int n = objectInputStream.readInt();
        TreeMap treeMap = new TreeMap(comparator);
        treeMap.putFromObjStream(objectInputStream, n, false);
        this.map = treeMap;
    }
}

