/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.BasicMapEntry;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;

public class TreeMap
extends AbstractMap
implements SortedMap,
Cloneable,
Serializable {
    private static final int RED = -1;
    private static final int BLACK = 1;
    transient Node nil;
    transient Node root;
    transient int size;
    transient int modCount;
    Comparator comparator;
    static final long serialVersionUID = 919286545866124006L;

    private /* synthetic */ void finit$() {
        this.root = this.nil = new Node(null, null);
        this.size = 0;
        this.modCount = 0;
        this.comparator = null;
    }

    public TreeMap() {
        this.finit$();
    }

    public TreeMap(Comparator comparator) {
        this.finit$();
        this.comparator = comparator;
    }

    public TreeMap(Map map) {
        this.finit$();
        this.putAll(map);
    }

    public TreeMap(SortedMap sortedMap) {
        this(sortedMap.comparator());
        int n = sortedMap.size();
        Iterator iterator = sortedMap.entrySet().iterator();
        this.fabricateTree(n);
        Node node = this.firstNode();
        for (int i = 0; i < n; ++i) {
            Map.Entry entry = (Map.Entry)iterator.next();
            node.key = entry.getKey();
            node.value = entry.getValue();
            node = this.successor(node);
        }
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        ++this.modCount;
        this.root = this.nil;
        this.nil.parent = null;
        this.size = 0;
    }

    public Object clone() {
        TreeMap treeMap = null;
        try {
            treeMap = (TreeMap)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        treeMap.nil = new Node(null, null);
        treeMap.fabricateTree(this.size);
        Node node = this.firstNode();
        Node node2 = treeMap.firstNode();
        while (node != this.nil) {
            node2.key = node.key;
            node2.value = node.value;
            node = this.successor(node);
            node2 = treeMap.successor(node2);
        }
        return treeMap;
    }

    public Comparator comparator() {
        return this.comparator;
    }

    public boolean containsKey(Object object) {
        return this.getNode(object) != this.nil;
    }

    public boolean containsValue(Object object) {
        Node node = this.firstNode();
        while (node != this.nil) {
            Object object2 = node.getValue();
            if (object == null ? object2 == null : object.equals(object2)) {
                return true;
            }
            node = this.successor(node);
        }
        return false;
    }

    public Set entrySet() {
        return new AbstractSet(this){
            private /* synthetic */ TreeMap this$0;
            {
                this.this$0 = treeMap;
            }

            public int size() {
                return this.this$0.size;
            }

            public Iterator iterator() {
                return new TreeIterator(this.this$0, 0);
            }

            public void clear() {
                this.this$0.clear();
            }

            public boolean contains(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                Node node = this.this$0.getNode(entry.getKey());
                return node != this.this$0.nil && entry.getValue().equals(node.value);
            }

            public boolean remove(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                Node node = this.this$0.getNode(entry.getKey());
                if (node != this.this$0.nil && entry.getValue().equals(node.value)) {
                    this.this$0.removeNode(node);
                    return true;
                }
                return false;
            }
        };
    }

    public Object firstKey() {
        if (this.root == this.nil) {
            throw new NoSuchElementException("empty");
        }
        return this.firstNode().getKey();
    }

    private Node firstNode() {
        if (this.root == this.nil) {
            return this.nil;
        }
        Node node = this.root;
        while (node.left != this.nil) {
            node = node.left;
        }
        return node;
    }

    public Object lastKey() {
        if (this.root == this.nil) {
            throw new NoSuchElementException("empty");
        }
        return this.lastNode().getKey();
    }

    private Node lastNode() {
        if (this.root == this.nil) {
            return this.nil;
        }
        Node node = this.root;
        while (node.right != this.nil) {
            node = node.right;
        }
        return node;
    }

    public Object get(Object object) {
        return this.getNode((Object)object).value;
    }

    private Node getNode(Object object) {
        Node node = this.root;
        while (node != this.nil) {
            int n = this.compare(object, node.key);
            if (n > 0) {
                node = node.right;
                continue;
            }
            if (n < 0) {
                node = node.left;
                continue;
            }
            return node;
        }
        return node;
    }

    public Set keySet() {
        return new AbstractSet(this){
            private /* synthetic */ TreeMap this$0;
            {
                this.this$0 = treeMap;
            }

            public int size() {
                return this.this$0.size;
            }

            public Iterator iterator() {
                return new TreeIterator(this.this$0, 1);
            }

            public void clear() {
                this.this$0.clear();
            }

            public boolean contains(Object object) {
                return this.this$0.containsKey(object);
            }

            public boolean remove(Object object) {
                Node node = this.this$0.getNode(object);
                if (node == this.this$0.nil) {
                    return false;
                }
                this.this$0.removeNode(node);
                return true;
            }
        };
    }

    public Object put(Object object, Object object2) {
        ++this.modCount;
        Node node = this.root;
        Node node2 = this.nil;
        int n = 0;
        while (node != this.nil) {
            node2 = node;
            n = this.compare(object, node.key);
            if (n > 0) {
                node = node.right;
                continue;
            }
            if (n < 0) {
                node = node.left;
                continue;
            }
            Object object3 = node.value;
            node.value = object2;
            return object3;
        }
        Node node3 = new Node(object, object2);
        node3.color = -1;
        node3.parent = node2;
        node3.left = this.nil;
        node3.right = this.nil;
        ++this.size;
        if (node2 == this.nil) {
            this.root = node3;
            node3.color = 1;
            return null;
        }
        if (n > 0) {
            node2.right = node3;
        } else {
            node2.left = node3;
        }
        this.insertFixup(node3);
        return null;
    }

    private void insertFixup(Node node) {
        while (node != this.root && node.parent.parent != this.nil && node.parent.color == -1) {
            Node node2;
            if (node.parent == node.parent.parent.left) {
                node2 = node.parent.parent.right;
                if (node2 != this.nil && node2.color == -1) {
                    node.parent.color = 1;
                    node2.color = 1;
                    node.parent.parent.color = -1;
                    node = node.parent.parent;
                    continue;
                }
                if (node == node.parent.right) {
                    node = node.parent;
                    this.rotateLeft(node);
                }
                node.parent.color = 1;
                node.parent.parent.color = -1;
                this.rotateRight(node.parent.parent);
                continue;
            }
            node2 = node.parent.parent.left;
            if (node2 != this.nil && node2.color == -1) {
                node.parent.color = 1;
                node2.color = 1;
                node.parent.parent.color = -1;
                node = node.parent.parent;
                continue;
            }
            if (node == node.parent.left) {
                node = node.parent;
                this.rotateRight(node);
            }
            node.parent.color = 1;
            node.parent.parent.color = -1;
            this.rotateLeft(node.parent.parent);
        }
        this.root.color = 1;
    }

    public void putAll(Map map) {
        Iterator iterator = map.entrySet().iterator();
        int n = map.size();
        for (int i = 0; i < n; ++i) {
            Map.Entry entry = (Map.Entry)iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object remove(Object object) {
        Node node = this.getNode(object);
        if (node != this.nil) {
            this.removeNode(node);
            return node.value;
        }
        return null;
    }

    private void removeNode(Node node) {
        Node node2;
        Node node3;
        Node node4;
        ++this.modCount;
        this.size += -1;
        if (node.left == this.nil || node.right == this.nil) {
            node4 = node;
            node3 = node.left == this.nil ? node.right : node.left;
        } else {
            node4 = node.right;
            while (node4.left != this.nil) {
                node4 = node4.left;
            }
            node3 = node4.right;
        }
        node3.parent = node2 = node4.parent;
        if (node2 != this.nil) {
            if (node4 == node2.left) {
                node2.left = node3;
            } else {
                node2.right = node3;
            }
        } else {
            this.root = node3;
        }
        int n = node4.color;
        if (node4 != node) {
            if (node == this.root) {
                this.root = node4;
            } else if (node.parent.left == node) {
                node.parent.left = node4;
            } else {
                node.parent.right = node4;
            }
            node4.parent = node.parent;
            node4.left = node.left;
            node4.right = node.right;
            node4.left.parent = node4;
            node4.right.parent = node4;
            node4.color = node.color;
        }
        if (n == 1) {
            this.deleteFixup(node3);
        }
    }

    private void deleteFixup(Node node) {
        while (node != this.root && node.color == 1) {
            Node node2;
            if (node == node.parent.left) {
                node2 = node.parent.right;
                if (node2.color == -1) {
                    node2.color = 1;
                    node.parent.color = -1;
                    this.rotateLeft(node.parent);
                    node2 = node.parent.right;
                }
                if (node2.left.color == 1 && node2.right.color == 1) {
                    node2.color = -1;
                    node = node.parent;
                    continue;
                }
                if (node2.right.color == 1) {
                    node2.left.color = 1;
                    node2.color = -1;
                    this.rotateRight(node2);
                    node2 = node.parent.right;
                }
                node2.color = node2.parent.color;
                node2.parent.color = 1;
                node2.right.color = 1;
                this.rotateLeft(node.parent);
                node = this.root;
                continue;
            }
            node2 = node.parent.left;
            if (node2.color == -1) {
                node2.color = 1;
                node.parent.color = -1;
                this.rotateRight(node.parent);
                node2 = node.parent.left;
            }
            if (node2.left.color == 1 && node2.right.color == 1) {
                node2.color = -1;
                node = node.parent;
                continue;
            }
            if (node2.left.color == 1) {
                node2.right.color = 1;
                node2.color = -1;
                this.rotateLeft(node2);
                node2 = node.parent.left;
            }
            node2.color = node2.parent.color;
            node2.parent.color = 1;
            node2.left.color = 1;
            this.rotateRight(node.parent);
            node = this.root;
        }
        node.color = 1;
    }

    public SortedMap subMap(Object object, Object object2) {
        if (this.compare(object, object2) <= 0) {
            return new SubMap(this, object, object2);
        }
        throw new IllegalArgumentException("fromKey > toKey");
    }

    public SortedMap headMap(Object object) {
        return new SubMap(this, this.nil, object);
    }

    public SortedMap tailMap(Object object) {
        return new SubMap(this, object, this.nil);
    }

    public Collection values() {
        return new AbstractCollection(this){
            private /* synthetic */ TreeMap this$0;
            {
                this.this$0 = treeMap;
            }

            public int size() {
                return this.this$0.size;
            }

            public Iterator iterator() {
                return new TreeIterator(this.this$0, 2);
            }

            public void clear() {
                this.this$0.clear();
            }
        };
    }

    private Node highestLessThan(Object object) {
        if (object == this.nil) {
            return this.lastNode();
        }
        Node node = this.nil;
        Node node2 = this.root;
        int n = 0;
        while (node2 != this.nil) {
            node = node2;
            n = this.compare(object, node2.key);
            if (n > 0) {
                node2 = node2.right;
                continue;
            }
            if (n < 0) {
                node2 = node2.left;
                continue;
            }
            return this.predecessor(node);
        }
        if (n <= 0) {
            return this.predecessor(node);
        }
        return node;
    }

    private Node lowestGreaterThan(Object object) {
        if (object == this.nil) {
            return this.firstNode();
        }
        Node node = this.nil;
        Node node2 = this.root;
        int n = 0;
        while (node2 != this.nil) {
            node = node2;
            n = this.compare(object, node2.key);
            if (n > 0) {
                node2 = node2.right;
                continue;
            }
            if (n < 0) {
                node2 = node2.left;
                continue;
            }
            return node2;
        }
        if (n > 0) {
            return this.successor(node);
        }
        return node;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Node node = this.firstNode();
        objectOutputStream.writeInt(this.size);
        while (node != this.nil) {
            objectOutputStream.writeObject(node.key);
            objectOutputStream.writeObject(node.value);
            node = this.successor(node);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.putFromObjStream(objectInputStream, n, true);
    }

    private int compare(Object object, Object object2) {
        if (this.comparator == null) {
            return ((Comparable)object).compareTo(object2);
        }
        return this.comparator.compare(object, object2);
    }

    private Node successor(Node node) {
        if (node.right != this.nil) {
            node = node.right;
            while (node.left != this.nil) {
                node = node.left;
            }
            return node;
        }
        Node node2 = node.parent;
        while (node2 != this.nil && node == node2.right) {
            node = node2;
            node2 = node2.parent;
        }
        return node2;
    }

    private Node predecessor(Node node) {
        if (node.left != this.nil) {
            node = node.left;
            while (node.right != this.nil) {
                node = node.right;
            }
            return node;
        }
        Node node2 = node.parent;
        while (node2 != this.nil && node == node2.left) {
            node = node2;
            node2 = node2.parent;
        }
        return node2;
    }

    private void rotateLeft(Node node) {
        Node node2 = node.right;
        node.right = node2.left;
        if (node2.left != this.nil) {
            node2.left.parent = node;
        }
        node2.parent = node.parent;
        if (node.parent != this.nil) {
            if (node == node.parent.left) {
                node.parent.left = node2;
            } else {
                node.parent.right = node2;
            }
        } else {
            this.root = node2;
        }
        node2.left = node;
        if (node != this.nil) {
            node.parent = node2;
        }
    }

    private void rotateRight(Node node) {
        Node node2 = node.left;
        node.left = node2.right;
        if (node2.right != this.nil) {
            node2.right.parent = node;
        }
        node2.parent = node.parent;
        if (node.parent != this.nil) {
            if (node == node.parent.right) {
                node.parent.right = node2;
            } else {
                node.parent.left = node2;
            }
        } else {
            this.root = node2;
        }
        node2.right = node;
        if (node != this.nil) {
            node.parent = node2;
        }
    }

    void putKeysLinear(Iterator iterator, int n) {
        this.fabricateTree(n);
        Node node = this.firstNode();
        for (int i = 0; i < n; ++i) {
            node.key = iterator.next();
            node.value = Boolean.TRUE;
            node = this.successor(node);
        }
    }

    void putFromObjStream(ObjectInputStream objectInputStream, int n, boolean bl) throws ClassNotFoundException, IOException {
        this.fabricateTree(n);
        Node node = this.firstNode();
        for (int i = 0; i < n; ++i) {
            node.key = objectInputStream.readObject();
            node.value = bl ? objectInputStream.readObject() : Boolean.TRUE;
            node = this.successor(node);
        }
    }

    private void fabricateTree(int n) {
        if (n == 0) {
            return;
        }
        double d = Math.log(n + 1) / Math.log(2.0);
        int n2 = (int)Math.ceil(d);
        int n3 = (int)Math.pow(2.0, n2 - 1) - 1;
        int n4 = n - n3;
        this.size = n;
        this.root = new Node(null, null);
        this.root.parent = this.nil;
        this.root.left = this.nil;
        this.root.right = this.nil;
        Node node = this.root;
        for (int i = 2; i <= n2; ++i) {
            Node node2;
            Node node3;
            int n5;
            int n6 = (int)Math.pow(2.0, i - 1);
            Node node4 = node;
            Node node5 = null;
            int n7 = i == n2 ? n4 : n6;
            boolean bl = i % 2 == n2 % 2;
            for (n5 = 1; n5 <= n7; ++n5) {
                node3 = new Node(null, null);
                node3.parent = node4;
                if (n5 % 2 == 1) {
                    node4.left = node3;
                } else {
                    node2 = node4.right;
                    node4.right = node3;
                    node4 = node2;
                }
                if (node5 != null) {
                    node5.right = node3;
                }
                node5 = node3;
                if (bl) {
                    node3.color = -1;
                }
                if (n5 != 1) continue;
                node = node3;
            }
            if (i != n2) continue;
            if (node4 != null) {
                if (n5 % 2 == 0) {
                    node3 = node4.right;
                    node4.right = this.nil;
                    node4 = node3;
                }
                while (node4 != null) {
                    node4.left = this.nil;
                    node3 = node4.right;
                    node4.right = this.nil;
                    node4 = node3;
                }
            }
            node3 = node;
            while (node3 != null) {
                node3.left = this.nil;
                node2 = node3.right;
                node3.right = this.nil;
                node3 = node2;
            }
        }
    }

    private void verifyTree() {
        if (this.root == this.nil) {
            System.err.println("Verify: empty tree");
            if (this.size != 0) {
                this.verifyError(this, "no root node but size=" + this.size);
            }
            return;
        }
        VerifyResult verifyResult = this.verifySub(this.root);
        if (verifyResult.count != this.size) {
            this.verifyError(this, "Tree size not consistent with actual nodes counted. counted " + verifyResult.count + ", size=" + this.size);
            System.exit(1);
        }
        System.err.println("Verify: " + verifyResult.count + " nodes, black height=" + verifyResult.black + ", maxdepth=" + verifyResult.maxdepth);
    }

    private VerifyResult verifySub(Node node) {
        VerifyResult verifyResult = null;
        VerifyResult verifyResult2 = null;
        if (node.left == this.nil && node.right == this.nil) {
            VerifyResult verifyResult3 = new VerifyResult(this);
            verifyResult3.black = node.color == 1 ? 1 : 0;
            verifyResult3.count = 1;
            verifyResult3.maxdepth = 1;
            return verifyResult3;
        }
        if (node.left != this.nil) {
            if (node.left.parent != node) {
                this.verifyError(node.left, "Node's parent link does not point to " + node);
            }
            if (node.color == -1 && node.left.color == -1) {
                this.verifyError(node, "Red node has red left child");
            }
            verifyResult = this.verifySub(node.left);
            if (node.right == this.nil) {
                if (node.color == 1) {
                    ++verifyResult.black;
                }
                ++verifyResult.count;
                ++verifyResult.maxdepth;
                return verifyResult;
            }
        }
        if (node.right != this.nil) {
            if (node.right.parent != node) {
                this.verifyError(node.right, "Node's parent link does not point to " + node);
            }
            if (node.color == -1 && node.right.color == -1) {
                this.verifyError(node, "Red node has red right child");
            }
            verifyResult2 = this.verifySub(node.right);
            if (node.left == this.nil) {
                if (node.color == 1) {
                    ++verifyResult2.black;
                }
                ++verifyResult2.count;
                ++verifyResult2.maxdepth;
                return verifyResult2;
            }
        }
        if (verifyResult.black != verifyResult2.black) {
            this.verifyError(node, "Black heights: " + verifyResult.black + "," + verifyResult2.black + " don't match.");
        }
        verifyResult.count += verifyResult2.count + 1;
        verifyResult.maxdepth = Math.max(verifyResult.maxdepth, verifyResult2.maxdepth) + 1;
        if (node.color == 1) {
            ++verifyResult.black;
        }
        return verifyResult;
    }

    private void verifyError(Object object, String string) {
        System.err.print("Verify error: ");
        try {
            System.err.print(object);
        }
        catch (Exception exception) {
            System.err.print("(error printing obj): " + exception);
        }
        System.err.println();
        System.err.println(string);
        Thread.dumpStack();
        System.exit(1);
    }

    class SubMap
    extends AbstractMap
    implements SortedMap {
        private /* synthetic */ TreeMap this$0;
        Object minKey;
        Object maxKey;

        static /* synthetic */ TreeMap access$1(SubMap subMap, TreeMap treeMap) {
            subMap.this$0 = treeMap;
            return subMap.this$0;
        }

        static TreeMap access$0(SubMap subMap) {
            return subMap.this$0;
        }

        SubMap(TreeMap treeMap, Object object, Object object2) {
            this.this$0 = treeMap;
            this.minKey = object;
            this.maxKey = object2;
        }

        public void clear() {
            Node node;
            Node node2 = this.this$0.lowestGreaterThan(this.minKey);
            Node node3 = this.this$0.highestLessThan(this.maxKey);
            if (this.this$0.compare(node2.key, node3.key) > 0) {
                return;
            }
            do {
                node = node2;
                node2 = this.this$0.successor(node);
                this.remove(node);
            } while (node != node3);
        }

        private boolean keyInRange(Object object) {
            return !(this.minKey != this.this$0.nil && this.this$0.compare(object, this.minKey) < 0 || this.maxKey != this.this$0.nil && this.this$0.compare(object, this.maxKey) >= 0);
        }

        public boolean containsKey(Object object) {
            return this.keyInRange(object) && this.this$0.containsKey(object);
        }

        public boolean containsValue(Object object) {
            Node node = this.this$0.lowestGreaterThan(this.minKey);
            Node node2 = this.this$0.highestLessThan(this.maxKey);
            if (node == this.this$0.nil || node2 == this.this$0.nil || this.this$0.compare(node.key, node2.key) > 0) {
                return false;
            }
            while (true) {
                Object object2 = node.getValue();
                if (object == null ? object2 == null : object.equals(object2)) {
                    return true;
                }
                if (node == node2) {
                    return false;
                }
                node = this.this$0.successor(node);
            }
        }

        public Object get(Object object) {
            if (this.keyInRange(object)) {
                return this.this$0.get(object);
            }
            return null;
        }

        public Object put(Object object, Object object2) {
            if (this.keyInRange(object)) {
                return this.this$0.put(object, object2);
            }
            throw new IllegalArgumentException("Key outside range");
        }

        public Object remove(Object object) {
            if (this.keyInRange(object)) {
                return this.this$0.remove(object);
            }
            return null;
        }

        public int size() {
            Node node = this.this$0.lowestGreaterThan(this.minKey);
            Node node2 = this.this$0.highestLessThan(this.maxKey);
            if (node == this.this$0.nil || node2 == this.this$0.nil || this.this$0.compare(node.key, node2.key) > 0) {
                return 0;
            }
            int n = 1;
            while (node != node2) {
                ++n;
                node = this.this$0.successor(node);
            }
            return n;
        }

        public Set entrySet() {
            return new AbstractSet(this){
                private /* synthetic */ SubMap this$1;
                {
                    this.this$1 = subMap;
                }

                public int size() {
                    return this.this$1.size();
                }

                public Iterator iterator() {
                    Node node = this.this$1.this$0.lowestGreaterThan(this.this$1.minKey);
                    Node node2 = this.this$1.this$0.highestLessThan(this.this$1.maxKey);
                    return new TreeIterator(SubMap.access$0(this.this$1), 0, node, node2);
                }

                public void clear() {
                    this.clear();
                }

                public boolean contains(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    Object object2 = entry.getKey();
                    if (!this.this$1.keyInRange(object2)) {
                        return false;
                    }
                    Node node = this.this$1.this$0.getNode(object2);
                    return node != SubMap.access$0((SubMap)this.this$1).nil && entry.getValue().equals(node.value);
                }

                public boolean remove(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    Object object2 = entry.getKey();
                    if (!this.this$1.keyInRange(object2)) {
                        return false;
                    }
                    Node node = this.this$1.this$0.getNode(object2);
                    if (node != SubMap.access$0((SubMap)this.this$1).nil && entry.getValue().equals(node.value)) {
                        this.this$1.this$0.removeNode(node);
                        return true;
                    }
                    return false;
                }
            };
        }

        public Comparator comparator() {
            return this.this$0.comparator;
        }

        public Object firstKey() {
            Node node = this.this$0.lowestGreaterThan(this.minKey);
            if (node == this.this$0.nil || !this.keyInRange(node.key)) {
                throw new NoSuchElementException("empty");
            }
            return node.key;
        }

        public Object lastKey() {
            Node node = this.this$0.highestLessThan(this.maxKey);
            if (node == this.this$0.nil || !this.keyInRange(node.key)) {
                throw new NoSuchElementException("empty");
            }
            return node.key;
        }

        public SortedMap subMap(Object object, Object object2) {
            if (!this.keyInRange(object) || !this.keyInRange(object2)) {
                throw new IllegalArgumentException("key outside range");
            }
            return this.this$0.subMap(object, object2);
        }

        public SortedMap headMap(Object object) {
            if (!this.keyInRange(object)) {
                throw new IllegalArgumentException("key outside range");
            }
            return this.this$0.subMap(this.minKey, object);
        }

        public SortedMap tailMap(Object object) {
            if (!this.keyInRange(object)) {
                throw new IllegalArgumentException("key outside range");
            }
            return this.this$0.subMap(object, this.maxKey);
        }
    }

    class TreeIterator
    implements Iterator {
        private /* synthetic */ TreeMap this$0;
        static final int ENTRIES = 0;
        static final int KEYS = 1;
        static final int VALUES = 2;
        int type;
        int knownMod;
        Node last;
        Node next;
        Node max;

        private /* synthetic */ void finit$() {
            this.knownMod = this.this$0.modCount;
        }

        TreeIterator(TreeMap treeMap, int n) {
            this.this$0 = treeMap;
            this.finit$();
            this.type = n;
            this.next = treeMap.firstNode();
        }

        TreeIterator(TreeMap treeMap, int n, Node node, Node node2) {
            this.this$0 = treeMap;
            this.finit$();
            this.type = n;
            this.next = node;
            this.max = node2;
        }

        public boolean hasNext() {
            if (this.knownMod != this.this$0.modCount) {
                throw new ConcurrentModificationException();
            }
            return this.next != this.this$0.nil;
        }

        public Object next() {
            if (this.next == this.this$0.nil) {
                throw new NoSuchElementException();
            }
            if (this.knownMod != this.this$0.modCount) {
                throw new ConcurrentModificationException();
            }
            Node node = this.next;
            this.next = node != this.max ? this.this$0.successor(node) : this.this$0.nil;
            this.last = node;
            if (this.type == 2) {
                return node.value;
            }
            if (this.type == 1) {
                return node.key;
            }
            return node;
        }

        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            if (this.knownMod != this.this$0.modCount) {
                throw new ConcurrentModificationException();
            }
            this.this$0.removeNode(this.last);
            ++this.knownMod;
            this.last = null;
        }
    }

    class VerifyResult {
        private /* synthetic */ TreeMap this$0;
        int count;
        int black;
        int maxdepth;

        VerifyResult(TreeMap treeMap) {
            this.this$0 = treeMap;
        }
    }

    static class Node
    extends BasicMapEntry
    implements Map.Entry {
        int color = 1;
        Node left;
        Node right;
        Node parent;

        Node(Object object, Object object2) {
            super(object, object2);
        }
    }
}

