/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.text.DateFormatSymbols;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.SimpleTimeZone;

public abstract class TimeZone
implements Serializable,
Cloneable {
    public static final int SHORT = 0;
    public static final int LONG = 1;
    private String ID;
    private static TimeZone defaultZone;
    private static final long serialVersionUID = 3581463369166924961L;
    private static final Hashtable timezones;

    public abstract int getOffset(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract int getRawOffset();

    public abstract void setRawOffset(int var1);

    public String getID() {
        return this.ID;
    }

    public void setID(String string) {
        this.ID = string;
    }

    public final String getDisplayName() {
        return this.getDisplayName(false, 1, Locale.getDefault());
    }

    public final String getDisplayName(Locale locale) {
        return this.getDisplayName(false, 1, locale);
    }

    public final String getDisplayName(boolean bl, int n) {
        return this.getDisplayName(bl, n, Locale.getDefault());
    }

    public String getDisplayName(boolean bl, int n, Locale locale) {
        try {
            DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(locale);
            String[][] stringArray = dateFormatSymbols.getZoneStrings();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i][0].equals(this.getID())) continue;
                if (!bl) {
                    if (n == 0) {
                        return stringArray[i][2];
                    }
                    return stringArray[i][1];
                }
                if (n == 0) {
                    return stringArray[i][4];
                }
                return stringArray[i][3];
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return this.getDefaultDisplayName(bl);
    }

    private String getDefaultDisplayName(boolean bl) {
        int n = this.getRawOffset();
        if (bl && this instanceof SimpleTimeZone) {
            n += ((SimpleTimeZone)this).getDSTSavings();
        }
        StringBuffer stringBuffer = new StringBuffer(9);
        stringBuffer.append("GMT");
        stringBuffer.append(n >= 0 ? (char)'+' : '-');
        n = Math.abs(n) / 60000;
        int n2 = n / 60;
        int n3 = n % 60;
        stringBuffer.append((char)(48 + n2 / 10)).append((char)(48 + n2 % 10));
        stringBuffer.append(':');
        stringBuffer.append((char)(48 + n3 / 10)).append((char)(48 + n3 % 10));
        return stringBuffer.toString();
    }

    public abstract boolean useDaylightTime();

    public abstract boolean inDaylightTime(Date var1);

    public static TimeZone getTimeZone(String string) {
        TimeZone timeZone = (TimeZone)timezones.get(string);
        if (timeZone != null) {
            if (timeZone.getID().equals(string)) {
                return timeZone;
            }
            timeZone = (TimeZone)timeZone.clone();
            timeZone.setID(string);
            timezones.put(string, timeZone);
            return timeZone;
        }
        if (string.startsWith("GMT")) {
            int n = 3;
            int n2 = 1;
            if (string.charAt(n) == '-') {
                n2 = -1;
                ++n;
            } else if (string.charAt(n) == '+') {
                ++n;
            }
            try {
                int n3;
                int n4;
                String string2 = string.substring(n);
                int n5 = string2.indexOf(":");
                if (n5 != -1) {
                    n4 = Integer.parseInt(string2.substring(0, n5));
                    n3 = Integer.parseInt(string2.substring(n5 + 1));
                } else {
                    int n6 = string2.length();
                    if (n6 <= 2) {
                        n4 = Integer.parseInt(string2);
                        n3 = 0;
                    } else {
                        n4 = Integer.parseInt(string2.substring(0, n6 - 2));
                        n3 = Integer.parseInt(string2.substring(n6 - 2));
                    }
                }
                return new SimpleTimeZone((n4 * 3600000 + n3 * 60000) * n2, string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return TimeZone.getTimeZone("GMT");
    }

    public static String[] getAvailableIDs(int n) {
        Object object;
        int n2 = 0;
        Iterator iterator = timezones.entrySet().iterator();
        while (iterator.hasNext()) {
            object = (Map.Entry)iterator.next();
            if (((TimeZone)object.getValue()).getRawOffset() != n) continue;
            ++n2;
        }
        object = new String[n2];
        n2 = 0;
        iterator = timezones.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (((TimeZone)entry.getValue()).getRawOffset() != n) continue;
            object[n2++] = (String)entry.getKey();
        }
        return object;
    }

    public static String[] getAvailableIDs() {
        return (String[])timezones.keySet().toArray(new String[timezones.size()]);
    }

    public static TimeZone getDefault() {
        return defaultZone;
    }

    public static void setDefault(TimeZone timeZone) {
        defaultZone = timeZone;
    }

    public boolean hasSameRules(TimeZone timeZone) {
        return timeZone.getRawOffset() == this.getRawOffset();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    static {
        timezones = new Hashtable();
        Object object = new SimpleTimeZone(-39600000, "MIT");
        timezones.put("MIT", object);
        timezones.put("Pacific/Apia", object);
        timezones.put("Pacific/Midway", object);
        timezones.put("Pacific/Niue", object);
        timezones.put("Pacific/Pago_Pago", object);
        object = new SimpleTimeZone(-36000000, "America/Adak", 3, 1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
        timezones.put("America/Adak", object);
        object = new SimpleTimeZone(-36000000, "HST");
        timezones.put("HST", object);
        timezones.put("Pacific/Fakaofo", object);
        timezones.put("Pacific/Honolulu", object);
        timezones.put("Pacific/Johnston", object);
        timezones.put("Pacific/Rarotonga", object);
        timezones.put("Pacific/Tahiti", object);
        object = new SimpleTimeZone(-34200000, "Pacific/Marquesas");
        timezones.put("Pacific/Marquesas", object);
        object = new SimpleTimeZone(-32400000, "AST", 3, 1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
        timezones.put("AST", object);
        timezones.put("America/Anchorage", object);
        timezones.put("America/Juneau", object);
        timezones.put("America/Nome", object);
        timezones.put("America/Yakutat", object);
        object = new SimpleTimeZone(-32400000, "Pacific/Gambier");
        timezones.put("Pacific/Gambier", object);
        object = new SimpleTimeZone(-28800000, "PST", 3, 1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
        timezones.put("PST", object);
        timezones.put("America/Dawson", object);
        timezones.put("America/Los_Angeles", object);
        timezones.put("America/Tijuana", object);
        timezones.put("America/Vancouver", object);
        timezones.put("America/Whitehorse", object);
        timezones.put("US/Pacific-New", object);
        object = new SimpleTimeZone(-28800000, "Pacific/Pitcairn");
        timezones.put("Pacific/Pitcairn", object);
        object = new SimpleTimeZone(-25200000, "MST", 3, 1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
        timezones.put("MST", object);
        timezones.put("America/Boise", object);
        timezones.put("America/Chihuahua", object);
        timezones.put("America/Denver", object);
        timezones.put("America/Edmonton", object);
        timezones.put("America/Inuvik", object);
        timezones.put("America/Mazatlan", object);
        timezones.put("America/Shiprock", object);
        timezones.put("America/Yellowknife", object);
        object = new SimpleTimeZone(-25200000, "PNT");
        timezones.put("PNT", object);
        timezones.put("America/Dawson_Creek", object);
        timezones.put("America/Hermosillo", object);
        timezones.put("America/Phoenix", object);
        object = new SimpleTimeZone(-21600000, "CST", 3, 1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
        timezones.put("CST", object);
        timezones.put("America/Cambridge_Bay", object);
        timezones.put("America/Cancun", object);
        timezones.put("America/Chicago", object);
        timezones.put("America/Menominee", object);
        timezones.put("America/Merida", object);
        timezones.put("America/Mexico_City", object);
        timezones.put("America/Monterrey", object);
        timezones.put("America/Rainy_River", object);
        timezones.put("America/Winnipeg", object);
        object = new SimpleTimeZone(-21600000, "America/Belize");
        timezones.put("America/Belize", object);
        timezones.put("America/Costa_Rica", object);
        timezones.put("America/El_Salvador", object);
        timezones.put("America/Guatemala", object);
        timezones.put("America/Managua", object);
        timezones.put("America/Regina", object);
        timezones.put("America/Swift_Current", object);
        timezones.put("America/Tegucigalpa", object);
        timezones.put("Pacific/Galapagos", object);
        object = new SimpleTimeZone(-21600000, "Pacific/Easter", 9, 9, -1, 0, 2, 9, -1, 0);
        timezones.put("Pacific/Easter", object);
        object = new SimpleTimeZone(-18000000, "America/Grand_Turk", 3, 1, 1, 0, 9, -1, 1, 0);
        timezones.put("America/Grand_Turk", object);
        timezones.put("America/Havana", object);
        object = new SimpleTimeZone(-18000000, "IET");
        timezones.put("IET", object);
        timezones.put("America/Bogota", object);
        timezones.put("America/Cayman", object);
        timezones.put("America/Eirunepe", object);
        timezones.put("America/Guayaquil", object);
        timezones.put("America/Indiana/Indianapolis", object);
        timezones.put("America/Indiana/Knox", object);
        timezones.put("America/Indiana/Marengo", object);
        timezones.put("America/Indiana/Vevay", object);
        timezones.put("America/Indianapolis", object);
        timezones.put("America/Iqaluit", object);
        timezones.put("America/Jamaica", object);
        timezones.put("America/Lima", object);
        timezones.put("America/Panama", object);
        timezones.put("America/Pangnirtung", object);
        timezones.put("America/Port-au-Prince", object);
        timezones.put("America/Porto_Acre", object);
        timezones.put("America/Rankin_Inlet", object);
        object = new SimpleTimeZone(-18000000, "EST", 3, 1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
        timezones.put("EST", object);
        timezones.put("America/Detroit", object);
        timezones.put("America/Kentucky/Louisville", object);
        timezones.put("America/Kentucky/Monticello", object);
        timezones.put("America/Louisville", object);
        timezones.put("America/Montreal", object);
        timezones.put("America/Nassau", object);
        timezones.put("America/New_York", object);
        timezones.put("America/Nipigon", object);
        timezones.put("America/Thunder_Bay", object);
        object = new SimpleTimeZone(-14400000, "PRT");
        timezones.put("PRT", object);
        timezones.put("America/Anguilla", object);
        timezones.put("America/Antigua", object);
        timezones.put("America/Aruba", object);
        timezones.put("America/Barbados", object);
        timezones.put("America/Boa_Vista", object);
        timezones.put("America/Caracas", object);
        timezones.put("America/Curacao", object);
        timezones.put("America/Dominica", object);
        timezones.put("America/Grenada", object);
        timezones.put("America/Guadeloupe", object);
        timezones.put("America/Guyana", object);
        timezones.put("America/La_Paz", object);
        timezones.put("America/Manaus", object);
        timezones.put("America/Martinique", object);
        timezones.put("America/Montserrat", object);
        timezones.put("America/Port_of_Spain", object);
        timezones.put("America/Porto_Velho", object);
        timezones.put("America/Puerto_Rico", object);
        timezones.put("America/Santo_Domingo", object);
        timezones.put("America/St_Kitts", object);
        timezones.put("America/St_Lucia", object);
        timezones.put("America/St_Thomas", object);
        timezones.put("America/St_Vincent", object);
        timezones.put("America/Tortola", object);
        object = new SimpleTimeZone(-14400000, "America/Asuncion", 9, 1, 1, 0, 1, -1, 1, 0);
        timezones.put("America/Asuncion", object);
        object = new SimpleTimeZone(-14400000, "America/Cuiaba", 9, 2, 1, 0, 1, 3, 1, 0);
        timezones.put("America/Cuiaba", object);
        object = new SimpleTimeZone(-14400000, "America/Goose_Bay", 3, 1, 1, 60000, 9, -1, 1, 60000);
        timezones.put("America/Goose_Bay", object);
        object = new SimpleTimeZone(-14400000, "America/Glace_Bay", 3, 1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
        timezones.put("America/Glace_Bay", object);
        timezones.put("America/Halifax", object);
        timezones.put("America/Thule", object);
        timezones.put("Atlantic/Bermuda", object);
        object = new SimpleTimeZone(-14400000, "America/Santiago", 9, 9, -1, 0, 2, 9, -1, 0);
        timezones.put("America/Santiago", object);
        timezones.put("Antarctica/Palmer", object);
        object = new SimpleTimeZone(-14400000, "Atlantic/Stanley", 8, 2, 1, 0, 3, 16, -1, 0);
        timezones.put("Atlantic/Stanley", object);
        object = new SimpleTimeZone(-12600000, "CNT", 3, 1, 1, 60000, 9, -1, 1, 60000);
        timezones.put("CNT", object);
        timezones.put("America/St_Johns", object);
        object = new SimpleTimeZone(-10800000, "America/Araguaina", 9, 2, 1, 0, 1, 3, 1, 0);
        timezones.put("America/Araguaina", object);
        timezones.put("America/Sao_Paulo", object);
        object = new SimpleTimeZone(-10800000, "AGT");
        timezones.put("AGT", object);
        timezones.put("America/Belem", object);
        timezones.put("America/Buenos_Aires", object);
        timezones.put("America/Catamarca", object);
        timezones.put("America/Cayenne", object);
        timezones.put("America/Cordoba", object);
        timezones.put("America/Fortaleza", object);
        timezones.put("America/Jujuy", object);
        timezones.put("America/Maceio", object);
        timezones.put("America/Mendoza", object);
        timezones.put("America/Montevideo", object);
        timezones.put("America/Paramaribo", object);
        timezones.put("America/Recife", object);
        timezones.put("America/Rosario", object);
        object = new SimpleTimeZone(-10800000, "America/Godthab", 2, 30, -7, 79200000, 9, 30, -7, 79200000);
        timezones.put("America/Godthab", object);
        object = new SimpleTimeZone(-10800000, "America/Miquelon", 3, 1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
        timezones.put("America/Miquelon", object);
        object = new SimpleTimeZone(-7200000, "America/Noronha");
        timezones.put("America/Noronha", object);
        timezones.put("Atlantic/South_Georgia", object);
        object = new SimpleTimeZone(-3600000, "America/Scoresbysund", 2, -1, 1, 0, 9, -1, 1, 0);
        timezones.put("America/Scoresbysund", object);
        timezones.put("Atlantic/Azores", object);
        object = new SimpleTimeZone(-3600000, "Atlantic/Cape_Verde");
        timezones.put("Atlantic/Cape_Verde", object);
        timezones.put("Atlantic/Jan_Mayen", object);
        object = new SimpleTimeZone(0, "GMT");
        timezones.put("GMT", object);
        timezones.put("UTC", object);
        timezones.put("Africa/Abidjan", object);
        timezones.put("Africa/Accra", object);
        timezones.put("Africa/Bamako", object);
        timezones.put("Africa/Banjul", object);
        timezones.put("Africa/Bissau", object);
        timezones.put("Africa/Casablanca", object);
        timezones.put("Africa/Conakry", object);
        timezones.put("Africa/Dakar", object);
        timezones.put("Africa/El_Aaiun", object);
        timezones.put("Africa/Freetown", object);
        timezones.put("Africa/Lome", object);
        timezones.put("Africa/Monrovia", object);
        timezones.put("Africa/Nouakchott", object);
        timezones.put("Africa/Ouagadougou", object);
        timezones.put("Africa/Sao_Tome", object);
        timezones.put("Africa/Timbuktu", object);
        timezones.put("Atlantic/Reykjavik", object);
        timezones.put("Atlantic/St_Helena", object);
        timezones.put("Europe/Belfast", object);
        timezones.put("Europe/Dublin", object);
        timezones.put("Europe/London", object);
        object = new SimpleTimeZone(0, "WET", 2, -1, 1, 3600000, 9, -1, 1, 3600000);
        timezones.put("WET", object);
        timezones.put("Atlantic/Canary", object);
        timezones.put("Atlantic/Faeroe", object);
        timezones.put("Atlantic/Madeira", object);
        timezones.put("Europe/Lisbon", object);
        object = new SimpleTimeZone(3600000, "Africa/Algiers");
        timezones.put("Africa/Algiers", object);
        timezones.put("Africa/Bangui", object);
        timezones.put("Africa/Brazzaville", object);
        timezones.put("Africa/Douala", object);
        timezones.put("Africa/Kinshasa", object);
        timezones.put("Africa/Lagos", object);
        timezones.put("Africa/Libreville", object);
        timezones.put("Africa/Luanda", object);
        timezones.put("Africa/Malabo", object);
        timezones.put("Africa/Ndjamena", object);
        timezones.put("Africa/Niamey", object);
        timezones.put("Africa/Porto-Novo", object);
        timezones.put("Africa/Tunis", object);
        object = new SimpleTimeZone(3600000, "Africa/Windhoek", 8, 1, 1, 0x6DDD00, 3, 1, 1, 0x6DDD00);
        timezones.put("Africa/Windhoek", object);
        object = new SimpleTimeZone(3600000, "CET", 2, -1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
        timezones.put("CET", object);
        timezones.put("ECT", object);
        timezones.put("MET", object);
        timezones.put("Africa/Ceuta", object);
        timezones.put("Arctic/Longyearbyen", object);
        timezones.put("Europe/Amsterdam", object);
        timezones.put("Europe/Andorra", object);
        timezones.put("Europe/Belgrade", object);
        timezones.put("Europe/Berlin", object);
        timezones.put("Europe/Bratislava", object);
        timezones.put("Europe/Brussels", object);
        timezones.put("Europe/Budapest", object);
        timezones.put("Europe/Copenhagen", object);
        timezones.put("Europe/Gibraltar", object);
        timezones.put("Europe/Ljubljana", object);
        timezones.put("Europe/Luxembourg", object);
        timezones.put("Europe/Madrid", object);
        timezones.put("Europe/Malta", object);
        timezones.put("Europe/Monaco", object);
        timezones.put("Europe/Oslo", object);
        timezones.put("Europe/Paris", object);
        timezones.put("Europe/Prague", object);
        timezones.put("Europe/Rome", object);
        timezones.put("Europe/San_Marino", object);
        timezones.put("Europe/Sarajevo", object);
        timezones.put("Europe/Skopje", object);
        timezones.put("Europe/Stockholm", object);
        timezones.put("Europe/Tirane", object);
        timezones.put("Europe/Vaduz", object);
        timezones.put("Europe/Vatican", object);
        timezones.put("Europe/Vienna", object);
        timezones.put("Europe/Warsaw", object);
        timezones.put("Europe/Zagreb", object);
        timezones.put("Europe/Zurich", object);
        object = new SimpleTimeZone(0x6DDD00, "ART", 3, -1, 6, 0, 8, -1, 5, 82800000);
        timezones.put("ART", object);
        timezones.put("Africa/Cairo", object);
        object = new SimpleTimeZone(0x6DDD00, "CAT");
        timezones.put("CAT", object);
        timezones.put("Africa/Blantyre", object);
        timezones.put("Africa/Bujumbura", object);
        timezones.put("Africa/Gaborone", object);
        timezones.put("Africa/Harare", object);
        timezones.put("Africa/Johannesburg", object);
        timezones.put("Africa/Kigali", object);
        timezones.put("Africa/Lubumbashi", object);
        timezones.put("Africa/Lusaka", object);
        timezones.put("Africa/Maputo", object);
        timezones.put("Africa/Maseru", object);
        timezones.put("Africa/Mbabane", object);
        timezones.put("Africa/Tripoli", object);
        timezones.put("Europe/Riga", object);
        timezones.put("Europe/Tallinn", object);
        timezones.put("Europe/Vilnius", object);
        object = new SimpleTimeZone(0x6DDD00, "Asia/Amman", 2, -1, 5, 0, 8, -1, 5, 0);
        timezones.put("Asia/Amman", object);
        object = new SimpleTimeZone(0x6DDD00, "Asia/Beirut", 2, -1, 1, 0, 9, -1, 1, 0);
        timezones.put("Asia/Beirut", object);
        object = new SimpleTimeZone(0x6DDD00, "Asia/Damascus", 3, 1, 0, 0, 9, 1, 0, 0);
        timezones.put("Asia/Damascus", object);
        object = new SimpleTimeZone(0x6DDD00, "Asia/Gaza", 3, 3, 6, 0, 9, 3, 6, 0);
        timezones.put("Asia/Gaza", object);
        object = new SimpleTimeZone(0x6DDD00, "Asia/Jerusalem", 3, 1, 0, 3600000, 9, 1, 0, 3600000);
        timezones.put("Asia/Jerusalem", object);
        object = new SimpleTimeZone(0x6DDD00, "EET", 2, -1, 1, 10800000, 9, -1, 1, 10800000);
        timezones.put("EET", object);
        timezones.put("Asia/Istanbul", object);
        timezones.put("Asia/Nicosia", object);
        timezones.put("Europe/Athens", object);
        timezones.put("Europe/Bucharest", object);
        timezones.put("Europe/Chisinau", object);
        timezones.put("Europe/Helsinki", object);
        timezones.put("Europe/Istanbul", object);
        timezones.put("Europe/Kiev", object);
        timezones.put("Europe/Nicosia", object);
        timezones.put("Europe/Simferopol", object);
        timezones.put("Europe/Sofia", object);
        timezones.put("Europe/Uzhgorod", object);
        timezones.put("Europe/Zaporozhye", object);
        object = new SimpleTimeZone(0x6DDD00, "Europe/Kaliningrad", 2, -1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
        timezones.put("Europe/Kaliningrad", object);
        timezones.put("Europe/Minsk", object);
        object = new SimpleTimeZone(10800000, "Asia/Baghdad", 3, 1, 0, 10800000, 9, 1, 0, 10800000);
        timezones.put("Asia/Baghdad", object);
        object = new SimpleTimeZone(10800000, "Europe/Moscow", 2, -1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
        timezones.put("Europe/Moscow", object);
        timezones.put("Europe/Tiraspol", object);
        object = new SimpleTimeZone(10800000, "EAT");
        timezones.put("EAT", object);
        timezones.put("Africa/Addis_Ababa", object);
        timezones.put("Africa/Asmera", object);
        timezones.put("Africa/Dar_es_Salaam", object);
        timezones.put("Africa/Djibouti", object);
        timezones.put("Africa/Kampala", object);
        timezones.put("Africa/Khartoum", object);
        timezones.put("Africa/Mogadishu", object);
        timezones.put("Africa/Nairobi", object);
        timezones.put("Antarctica/Syowa", object);
        timezones.put("Asia/Aden", object);
        timezones.put("Asia/Bahrain", object);
        timezones.put("Asia/Kuwait", object);
        timezones.put("Asia/Qatar", object);
        timezones.put("Asia/Riyadh", object);
        timezones.put("Indian/Antananarivo", object);
        timezones.put("Indian/Comoro", object);
        timezones.put("Indian/Mayotte", object);
        object = new SimpleTimeZone(12600000, "Asia/Tehran");
        timezones.put("Asia/Tehran", object);
        object = new SimpleTimeZone(14400000, "Asia/Baku", 2, -1, 1, 3600000, 9, -1, 1, 3600000);
        timezones.put("Asia/Baku", object);
        object = new SimpleTimeZone(14400000, "Asia/Aqtau", 2, -1, 1, 0, 9, -1, 1, 0);
        timezones.put("Asia/Aqtau", object);
        timezones.put("Asia/Tbilisi", object);
        object = new SimpleTimeZone(14400000, "Asia/Yerevan", 2, -1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
        timezones.put("Asia/Yerevan", object);
        timezones.put("Europe/Samara", object);
        object = new SimpleTimeZone(14400000, "NET");
        timezones.put("NET", object);
        timezones.put("Asia/Dubai", object);
        timezones.put("Asia/Muscat", object);
        timezones.put("Indian/Mahe", object);
        timezones.put("Indian/Mauritius", object);
        timezones.put("Indian/Reunion", object);
        object = new SimpleTimeZone(16200000, "Asia/Kabul");
        timezones.put("Asia/Kabul", object);
        object = new SimpleTimeZone(18000000, "Asia/Aqtobe", 2, -1, 1, 0, 9, -1, 1, 0);
        timezones.put("Asia/Aqtobe", object);
        object = new SimpleTimeZone(18000000, "Asia/Bishkek", 2, -1, 1, 9000000, 9, -1, 1, 9000000);
        timezones.put("Asia/Bishkek", object);
        object = new SimpleTimeZone(18000000, "Asia/Yekaterinburg", 2, -1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
        timezones.put("Asia/Yekaterinburg", object);
        object = new SimpleTimeZone(18000000, "PLT");
        timezones.put("PLT", object);
        timezones.put("Asia/Ashgabat", object);
        timezones.put("Asia/Dushanbe", object);
        timezones.put("Asia/Karachi", object);
        timezones.put("Asia/Samarkand", object);
        timezones.put("Asia/Tashkent", object);
        timezones.put("Indian/Chagos", object);
        timezones.put("Indian/Kerguelen", object);
        timezones.put("Indian/Maldives", object);
        object = new SimpleTimeZone(19800000, "IST");
        timezones.put("IST", object);
        timezones.put("Asia/Calcutta", object);
        object = new SimpleTimeZone(20700000, "Asia/Katmandu");
        timezones.put("Asia/Katmandu", object);
        object = new SimpleTimeZone(21600000, "BST");
        timezones.put("BST", object);
        timezones.put("Antarctica/Mawson", object);
        timezones.put("Asia/Colombo", object);
        timezones.put("Asia/Dhaka", object);
        timezones.put("Asia/Thimphu", object);
        object = new SimpleTimeZone(21600000, "Asia/Almaty", 2, -1, 1, 0, 9, -1, 1, 0);
        timezones.put("Asia/Almaty", object);
        object = new SimpleTimeZone(21600000, "Asia/Novosibirsk", 2, -1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
        timezones.put("Asia/Novosibirsk", object);
        timezones.put("Asia/Omsk", object);
        object = new SimpleTimeZone(23400000, "Asia/Rangoon");
        timezones.put("Asia/Rangoon", object);
        timezones.put("Indian/Cocos", object);
        object = new SimpleTimeZone(25200000, "VST");
        timezones.put("VST", object);
        timezones.put("Antarctica/Davis", object);
        timezones.put("Asia/Bangkok", object);
        timezones.put("Asia/Hovd", object);
        timezones.put("Asia/Jakarta", object);
        timezones.put("Asia/Phnom_Penh", object);
        timezones.put("Asia/Saigon", object);
        timezones.put("Asia/Vientiane", object);
        timezones.put("Indian/Christmas", object);
        object = new SimpleTimeZone(25200000, "Asia/Krasnoyarsk", 2, -1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
        timezones.put("Asia/Krasnoyarsk", object);
        object = new SimpleTimeZone(28800000, "CTT");
        timezones.put("CTT", object);
        timezones.put("Antarctica/Casey", object);
        timezones.put("Asia/Brunei", object);
        timezones.put("Asia/Chungking", object);
        timezones.put("Asia/Harbin", object);
        timezones.put("Asia/Hong_Kong", object);
        timezones.put("Asia/Kashgar", object);
        timezones.put("Asia/Kuala_Lumpur", object);
        timezones.put("Asia/Kuching", object);
        timezones.put("Asia/Macao", object);
        timezones.put("Asia/Manila", object);
        timezones.put("Asia/Shanghai", object);
        timezones.put("Asia/Singapore", object);
        timezones.put("Asia/Taipei", object);
        timezones.put("Asia/Ujung_Pandang", object);
        timezones.put("Asia/Ulaanbaatar", object);
        timezones.put("Asia/Urumqi", object);
        timezones.put("Australia/Perth", object);
        object = new SimpleTimeZone(28800000, "Asia/Irkutsk", 2, -1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
        timezones.put("Asia/Irkutsk", object);
        object = new SimpleTimeZone(32400000, "JST");
        timezones.put("JST", object);
        timezones.put("Asia/Dili", object);
        timezones.put("Asia/Jayapura", object);
        timezones.put("Asia/Pyongyang", object);
        timezones.put("Asia/Seoul", object);
        timezones.put("Asia/Tokyo", object);
        timezones.put("Pacific/Palau", object);
        object = new SimpleTimeZone(32400000, "Asia/Yakutsk", 2, -1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
        timezones.put("Asia/Yakutsk", object);
        object = new SimpleTimeZone(34200000, "Australia/Adelaide", 9, -1, 1, 0x6DDD00, 2, -1, 1, 0x6DDD00);
        timezones.put("Australia/Adelaide", object);
        timezones.put("Australia/Broken_Hill", object);
        object = new SimpleTimeZone(34200000, "ACT");
        timezones.put("ACT", object);
        timezones.put("Australia/Darwin", object);
        object = new SimpleTimeZone(36000000, "Antarctica/DumontDUrville");
        timezones.put("Antarctica/DumontDUrville", object);
        timezones.put("Australia/Brisbane", object);
        timezones.put("Australia/Lindeman", object);
        timezones.put("Pacific/Guam", object);
        timezones.put("Pacific/Port_Moresby", object);
        timezones.put("Pacific/Saipan", object);
        timezones.put("Pacific/Truk", object);
        timezones.put("Pacific/Yap", object);
        object = new SimpleTimeZone(36000000, "Asia/Vladivostok", 2, -1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
        timezones.put("Asia/Vladivostok", object);
        object = new SimpleTimeZone(36000000, "Australia/Hobart", 9, 1, 1, 0x6DDD00, 2, -1, 1, 0x6DDD00);
        timezones.put("Australia/Hobart", object);
        object = new SimpleTimeZone(36000000, "AET", 9, -1, 1, 0x6DDD00, 2, -1, 1, 0x6DDD00);
        timezones.put("AET", object);
        timezones.put("Australia/Melbourne", object);
        timezones.put("Australia/Sydney", object);
        object = new SimpleTimeZone(37800000, "Australia/Lord_Howe", 9, -1, 1, 0x6DDD00, 2, -1, 1, 0x6DDD00, 1800000);
        timezones.put("Australia/Lord_Howe", object);
        object = new SimpleTimeZone(39600000, "Asia/Magadan", 2, -1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
        timezones.put("Asia/Magadan", object);
        object = new SimpleTimeZone(39600000, "SST");
        timezones.put("SST", object);
        timezones.put("Pacific/Efate", object);
        timezones.put("Pacific/Guadalcanal", object);
        timezones.put("Pacific/Kosrae", object);
        timezones.put("Pacific/Noumea", object);
        timezones.put("Pacific/Ponape", object);
        object = new SimpleTimeZone(41400000, "Pacific/Norfolk");
        timezones.put("Pacific/Norfolk", object);
        object = new SimpleTimeZone(43200000, "NST", 9, 1, 1, 0x6DDD00, 2, 3, 1, 0x6DDD00);
        timezones.put("NST", object);
        timezones.put("Antarctica/McMurdo", object);
        timezones.put("Antarctica/South_Pole", object);
        timezones.put("Pacific/Auckland", object);
        object = new SimpleTimeZone(43200000, "Asia/Anadyr", 2, -1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
        timezones.put("Asia/Anadyr", object);
        timezones.put("Asia/Kamchatka", object);
        object = new SimpleTimeZone(43200000, "Pacific/Fiji");
        timezones.put("Pacific/Fiji", object);
        timezones.put("Pacific/Funafuti", object);
        timezones.put("Pacific/Kwajalein", object);
        timezones.put("Pacific/Majuro", object);
        timezones.put("Pacific/Nauru", object);
        timezones.put("Pacific/Tarawa", object);
        timezones.put("Pacific/Wake", object);
        timezones.put("Pacific/Wallis", object);
        object = new SimpleTimeZone(45900000, "Pacific/Chatham", 9, 1, 1, 9900000, 2, 3, 1, 9900000);
        timezones.put("Pacific/Chatham", object);
        object = new SimpleTimeZone(46800000, "Pacific/Enderbury");
        timezones.put("Pacific/Enderbury", object);
        timezones.put("Pacific/Tongatapu", object);
        object = new SimpleTimeZone(50400000, "Pacific/Kiritimati");
        timezones.put("Pacific/Kiritimati", object);
        object = System.getProperty("user.timezone");
        if (object == null) {
            object = "GMT";
        }
        defaultZone = TimeZone.getTimeZone((String)object);
    }
}

