/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

class SubList
extends AbstractList {
    private AbstractList backingList;
    private int offset;
    private int size;

    static /* synthetic */ AbstractList access$2(SubList subList, AbstractList abstractList) {
        subList.backingList = abstractList;
        return subList.backingList;
    }

    static /* synthetic */ int access$1(SubList subList, int n) {
        subList.offset = n;
        return subList.offset;
    }

    public SubList(AbstractList abstractList, int n, int n2) {
        this.backingList = abstractList;
        this.modCount = this.backingList.modCount;
        this.offset = n;
        this.size = n2 - n;
    }

    private void checkMod() {
        if (this.modCount != this.backingList.modCount) {
            throw new ConcurrentModificationException();
        }
    }

    private void checkBoundsInclusive(int n) {
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size:" + this.size);
        }
    }

    private void checkBoundsExclusive(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size:" + this.size);
        }
    }

    public int size() {
        this.checkMod();
        return this.size;
    }

    public Object set(int n, Object object) {
        this.checkMod();
        this.checkBoundsExclusive(n);
        object = this.backingList.set(n + this.offset, object);
        return object;
    }

    public Object get(int n) {
        this.checkMod();
        this.checkBoundsExclusive(n);
        return this.backingList.get(n + this.offset);
    }

    public void add(int n, Object object) {
        this.checkMod();
        this.checkBoundsInclusive(n);
        this.backingList.add(n + this.offset, object);
        ++this.modCount;
        ++this.size;
    }

    public Object remove(int n) {
        this.checkMod();
        this.checkBoundsExclusive(n);
        Object object = this.backingList.remove(n + this.offset);
        ++this.modCount;
        this.size += -1;
        return object;
    }

    public void removeRange(int n, int n2) {
        this.checkMod();
        this.checkBoundsExclusive(n);
        this.checkBoundsInclusive(n2);
        this.backingList.removeRange(this.offset + n, this.offset + n2);
        this.modCount = this.backingList.modCount;
        this.size -= n2 - n;
    }

    public boolean addAll(int n, Collection collection) {
        this.checkMod();
        this.checkBoundsInclusive(n);
        int n2 = collection.size();
        boolean bl = this.backingList.addAll(this.offset + n, collection);
        this.modCount = this.backingList.modCount;
        this.size += n2;
        return bl;
    }

    public Iterator iterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(int n) {
        this.checkMod();
        this.checkBoundsInclusive(n);
        return new ListIterator(this, n){
            private /* synthetic */ SubList this$0;
            private /* synthetic */ int val$index;
            ListIterator i;
            int position;
            {
                this.this$0 = subList;
                this.finit$(n);
            }

            private /* synthetic */ void finit$(int n) {
                this.val$index = n;
                this.i = this.this$0.backingList.listIterator(this.val$index + this.this$0.offset);
                this.position = this.val$index;
            }

            public boolean hasNext() {
                this.this$0.checkMod();
                return this.position < this.this$0.size;
            }

            public boolean hasPrevious() {
                this.this$0.checkMod();
                return this.position > 0;
            }

            public Object next() {
                if (this.position < this.this$0.size) {
                    Object object = this.i.next();
                    ++this.position;
                    return object;
                }
                throw new NoSuchElementException();
            }

            public Object previous() {
                if (this.position > 0) {
                    Object object = this.i.previous();
                    this.position += -1;
                    return object;
                }
                throw new NoSuchElementException();
            }

            public int nextIndex() {
                return this.this$0.offset + this.i.nextIndex();
            }

            public int previousIndex() {
                return this.this$0.offset + this.i.previousIndex();
            }

            public void remove() {
                this.i.remove();
                ++this.this$0.modCount;
                this.this$0.size = this.this$0.size + 1;
                this.position = this.nextIndex();
            }

            public void set(Object object) {
                this.i.set(object);
            }

            public void add(Object object) {
                this.i.add(object);
                ++this.this$0.modCount;
                this.this$0.size = this.this$0.size + 1;
                ++this.position;
            }
        };
    }
}

